// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Ref;
use crate::RefKind;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakBundleRef")]
    pub struct BundleRef(Object<ffi::FlatpakBundleRef, ffi::FlatpakBundleRefClass>) @extends Ref;

    match fn {
        type_ => || ffi::flatpak_bundle_ref_get_type(),
    }
}

impl BundleRef {
    pub const NONE: Option<&'static BundleRef> = None;

    #[doc(alias = "flatpak_bundle_ref_new")]
    pub fn new(file: &impl IsA<gio::File>) -> Result<BundleRef, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_bundle_ref_new(file.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`BundleRef`] objects.
    ///
    /// This method returns an instance of [`BundleRefBuilder`](crate::builders::BundleRefBuilder) which can be used to create [`BundleRef`] objects.
    pub fn builder() -> BundleRefBuilder {
        BundleRefBuilder::default()
    }
}

impl Default for BundleRef {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct BundleRef object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`BundleRef`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct BundleRefBuilder {
    file: Option<gio::File>,
    arch: Option<String>,
    branch: Option<String>,
    collection_id: Option<String>,
    commit: Option<String>,
    kind: Option<RefKind>,
    name: Option<String>,
}

impl BundleRefBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`BundleRefBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`BundleRef`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> BundleRef {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref file) = self.file {
            properties.push(("file", file));
        }
        if let Some(ref arch) = self.arch {
            properties.push(("arch", arch));
        }
        if let Some(ref branch) = self.branch {
            properties.push(("branch", branch));
        }
        if let Some(ref collection_id) = self.collection_id {
            properties.push(("collection-id", collection_id));
        }
        if let Some(ref commit) = self.commit {
            properties.push(("commit", commit));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<BundleRef>(&properties)
            .expect("Failed to create an instance of BundleRef")
    }

    pub fn file(mut self, file: &impl IsA<gio::File>) -> Self {
        self.file = Some(file.clone().upcast());
        self
    }

    pub fn arch(mut self, arch: &str) -> Self {
        self.arch = Some(arch.to_string());
        self
    }

    pub fn branch(mut self, branch: &str) -> Self {
        self.branch = Some(branch.to_string());
        self
    }

    pub fn collection_id(mut self, collection_id: &str) -> Self {
        self.collection_id = Some(collection_id.to_string());
        self
    }

    pub fn commit(mut self, commit: &str) -> Self {
        self.commit = Some(commit.to_string());
        self
    }

    pub fn kind(mut self, kind: RefKind) -> Self {
        self.kind = Some(kind);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait BundleRefExt: 'static {
    #[doc(alias = "flatpak_bundle_ref_get_appstream")]
    #[doc(alias = "get_appstream")]
    fn appstream(&self) -> Option<glib::Bytes>;

    #[doc(alias = "flatpak_bundle_ref_get_file")]
    #[doc(alias = "get_file")]
    fn file(&self) -> Option<gio::File>;

    #[doc(alias = "flatpak_bundle_ref_get_icon")]
    #[doc(alias = "get_icon")]
    fn icon(&self, size: i32) -> Option<glib::Bytes>;

    #[doc(alias = "flatpak_bundle_ref_get_installed_size")]
    #[doc(alias = "get_installed_size")]
    fn installed_size(&self) -> u64;

    #[doc(alias = "flatpak_bundle_ref_get_metadata")]
    #[doc(alias = "get_metadata")]
    fn metadata(&self) -> Option<glib::Bytes>;

    #[doc(alias = "flatpak_bundle_ref_get_origin")]
    #[doc(alias = "get_origin")]
    fn origin(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_bundle_ref_get_runtime_repo_url")]
    #[doc(alias = "get_runtime_repo_url")]
    fn runtime_repo_url(&self) -> Option<glib::GString>;
}

impl<O: IsA<BundleRef>> BundleRefExt for O {
    fn appstream(&self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_appstream(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn file(&self) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_file(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn icon(&self, size: i32) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_icon(
                self.as_ref().to_glib_none().0,
                size,
            ))
        }
    }

    fn installed_size(&self) -> u64 {
        unsafe { ffi::flatpak_bundle_ref_get_installed_size(self.as_ref().to_glib_none().0) }
    }

    fn metadata(&self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_metadata(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn origin(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_origin(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn runtime_repo_url(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_bundle_ref_get_runtime_repo_url(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for BundleRef {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("BundleRef")
    }
}
