// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 5264fd0c3183)
// DO NOT EDIT

use flatpak_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["flatpak"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "FlatpakBundleRef",
        Layout {
            size: size_of::<FlatpakBundleRef>(),
            alignment: align_of::<FlatpakBundleRef>(),
        },
    ),
    (
        "FlatpakBundleRefClass",
        Layout {
            size: size_of::<FlatpakBundleRefClass>(),
            alignment: align_of::<FlatpakBundleRefClass>(),
        },
    ),
    (
        "FlatpakError",
        Layout {
            size: size_of::<FlatpakError>(),
            alignment: align_of::<FlatpakError>(),
        },
    ),
    (
        "FlatpakInstallFlags",
        Layout {
            size: size_of::<FlatpakInstallFlags>(),
            alignment: align_of::<FlatpakInstallFlags>(),
        },
    ),
    (
        "FlatpakInstallation",
        Layout {
            size: size_of::<FlatpakInstallation>(),
            alignment: align_of::<FlatpakInstallation>(),
        },
    ),
    (
        "FlatpakInstallationClass",
        Layout {
            size: size_of::<FlatpakInstallationClass>(),
            alignment: align_of::<FlatpakInstallationClass>(),
        },
    ),
    (
        "FlatpakInstalledRef",
        Layout {
            size: size_of::<FlatpakInstalledRef>(),
            alignment: align_of::<FlatpakInstalledRef>(),
        },
    ),
    (
        "FlatpakInstalledRefClass",
        Layout {
            size: size_of::<FlatpakInstalledRefClass>(),
            alignment: align_of::<FlatpakInstalledRefClass>(),
        },
    ),
    (
        "FlatpakInstance",
        Layout {
            size: size_of::<FlatpakInstance>(),
            alignment: align_of::<FlatpakInstance>(),
        },
    ),
    (
        "FlatpakInstanceClass",
        Layout {
            size: size_of::<FlatpakInstanceClass>(),
            alignment: align_of::<FlatpakInstanceClass>(),
        },
    ),
    (
        "FlatpakLaunchFlags",
        Layout {
            size: size_of::<FlatpakLaunchFlags>(),
            alignment: align_of::<FlatpakLaunchFlags>(),
        },
    ),
    (
        "FlatpakPortalError",
        Layout {
            size: size_of::<FlatpakPortalError>(),
            alignment: align_of::<FlatpakPortalError>(),
        },
    ),
    (
        "FlatpakQueryFlags",
        Layout {
            size: size_of::<FlatpakQueryFlags>(),
            alignment: align_of::<FlatpakQueryFlags>(),
        },
    ),
    (
        "FlatpakRef",
        Layout {
            size: size_of::<FlatpakRef>(),
            alignment: align_of::<FlatpakRef>(),
        },
    ),
    (
        "FlatpakRefClass",
        Layout {
            size: size_of::<FlatpakRefClass>(),
            alignment: align_of::<FlatpakRefClass>(),
        },
    ),
    (
        "FlatpakRefKind",
        Layout {
            size: size_of::<FlatpakRefKind>(),
            alignment: align_of::<FlatpakRefKind>(),
        },
    ),
    (
        "FlatpakRelatedRef",
        Layout {
            size: size_of::<FlatpakRelatedRef>(),
            alignment: align_of::<FlatpakRelatedRef>(),
        },
    ),
    (
        "FlatpakRelatedRefClass",
        Layout {
            size: size_of::<FlatpakRelatedRefClass>(),
            alignment: align_of::<FlatpakRelatedRefClass>(),
        },
    ),
    (
        "FlatpakRemote",
        Layout {
            size: size_of::<FlatpakRemote>(),
            alignment: align_of::<FlatpakRemote>(),
        },
    ),
    (
        "FlatpakRemoteClass",
        Layout {
            size: size_of::<FlatpakRemoteClass>(),
            alignment: align_of::<FlatpakRemoteClass>(),
        },
    ),
    (
        "FlatpakRemoteRef",
        Layout {
            size: size_of::<FlatpakRemoteRef>(),
            alignment: align_of::<FlatpakRemoteRef>(),
        },
    ),
    (
        "FlatpakRemoteRefClass",
        Layout {
            size: size_of::<FlatpakRemoteRefClass>(),
            alignment: align_of::<FlatpakRemoteRefClass>(),
        },
    ),
    (
        "FlatpakRemoteType",
        Layout {
            size: size_of::<FlatpakRemoteType>(),
            alignment: align_of::<FlatpakRemoteType>(),
        },
    ),
    (
        "FlatpakStorageType",
        Layout {
            size: size_of::<FlatpakStorageType>(),
            alignment: align_of::<FlatpakStorageType>(),
        },
    ),
    (
        "FlatpakTransaction",
        Layout {
            size: size_of::<FlatpakTransaction>(),
            alignment: align_of::<FlatpakTransaction>(),
        },
    ),
    (
        "FlatpakTransactionClass",
        Layout {
            size: size_of::<FlatpakTransactionClass>(),
            alignment: align_of::<FlatpakTransactionClass>(),
        },
    ),
    (
        "FlatpakTransactionErrorDetails",
        Layout {
            size: size_of::<FlatpakTransactionErrorDetails>(),
            alignment: align_of::<FlatpakTransactionErrorDetails>(),
        },
    ),
    (
        "FlatpakTransactionOperationClass",
        Layout {
            size: size_of::<FlatpakTransactionOperationClass>(),
            alignment: align_of::<FlatpakTransactionOperationClass>(),
        },
    ),
    (
        "FlatpakTransactionOperationType",
        Layout {
            size: size_of::<FlatpakTransactionOperationType>(),
            alignment: align_of::<FlatpakTransactionOperationType>(),
        },
    ),
    (
        "FlatpakTransactionProgressClass",
        Layout {
            size: size_of::<FlatpakTransactionProgressClass>(),
            alignment: align_of::<FlatpakTransactionProgressClass>(),
        },
    ),
    (
        "FlatpakTransactionRemoteReason",
        Layout {
            size: size_of::<FlatpakTransactionRemoteReason>(),
            alignment: align_of::<FlatpakTransactionRemoteReason>(),
        },
    ),
    (
        "FlatpakTransactionResult",
        Layout {
            size: size_of::<FlatpakTransactionResult>(),
            alignment: align_of::<FlatpakTransactionResult>(),
        },
    ),
    (
        "FlatpakUninstallFlags",
        Layout {
            size: size_of::<FlatpakUninstallFlags>(),
            alignment: align_of::<FlatpakUninstallFlags>(),
        },
    ),
    (
        "FlatpakUpdateFlags",
        Layout {
            size: size_of::<FlatpakUpdateFlags>(),
            alignment: align_of::<FlatpakUpdateFlags>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) FLATPAK_ERROR_ABORTED", "4"),
    ("(gint) FLATPAK_ERROR_ALREADY_INSTALLED", "0"),
    ("(gint) FLATPAK_ERROR_AUTHENTICATION_FAILED", "23"),
    ("(gint) FLATPAK_ERROR_DIFFERENT_REMOTE", "3"),
    ("(gint) FLATPAK_ERROR_DOWNGRADE", "9"),
    ("(gint) FLATPAK_ERROR_EXPORT_FAILED", "14"),
    ("(gint) FLATPAK_ERROR_INVALID_DATA", "11"),
    ("(gint) FLATPAK_ERROR_INVALID_NAME", "17"),
    ("(gint) FLATPAK_ERROR_INVALID_REF", "10"),
    ("(gint) FLATPAK_ERROR_NEED_NEW_FLATPAK", "6"),
    ("(gint) FLATPAK_ERROR_NOT_AUTHORIZED", "24"),
    ("(gint) FLATPAK_ERROR_NOT_CACHED", "20"),
    ("(gint) FLATPAK_ERROR_NOT_INSTALLED", "1"),
    ("(gint) FLATPAK_ERROR_ONLY_PULLED", "2"),
    ("(gint) FLATPAK_ERROR_OUT_OF_SPACE", "18"),
    ("(gint) FLATPAK_ERROR_PERMISSION_DENIED", "22"),
    ("(gint) FLATPAK_ERROR_REF_NOT_FOUND", "21"),
    ("(gint) FLATPAK_ERROR_REMOTE_NOT_FOUND", "7"),
    ("(gint) FLATPAK_ERROR_REMOTE_USED", "15"),
    ("(gint) FLATPAK_ERROR_RUNTIME_NOT_FOUND", "8"),
    ("(gint) FLATPAK_ERROR_RUNTIME_USED", "16"),
    ("(gint) FLATPAK_ERROR_SETUP_FAILED", "13"),
    ("(gint) FLATPAK_ERROR_SKIPPED", "5"),
    ("(gint) FLATPAK_ERROR_UNTRUSTED", "12"),
    ("(gint) FLATPAK_ERROR_WRONG_USER", "19"),
    ("(guint) FLATPAK_INSTALL_FLAGS_NONE", "0"),
    ("(guint) FLATPAK_INSTALL_FLAGS_NO_DEPLOY", "4"),
    ("(guint) FLATPAK_INSTALL_FLAGS_NO_PULL", "8"),
    ("(guint) FLATPAK_INSTALL_FLAGS_NO_STATIC_DELTAS", "1"),
    ("(guint) FLATPAK_INSTALL_FLAGS_NO_TRIGGERS", "16"),
    ("(guint) FLATPAK_LAUNCH_FLAGS_DO_NOT_REAP", "1"),
    ("(guint) FLATPAK_LAUNCH_FLAGS_NONE", "0"),
    ("(gint) FLATPAK_PORTAL_ERROR_CANCELLED", "5"),
    ("(gint) FLATPAK_PORTAL_ERROR_EXISTS", "3"),
    ("(gint) FLATPAK_PORTAL_ERROR_FAILED", "0"),
    ("(gint) FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT", "1"),
    ("(gint) FLATPAK_PORTAL_ERROR_NOT_ALLOWED", "4"),
    ("(gint) FLATPAK_PORTAL_ERROR_NOT_FOUND", "2"),
    ("(gint) FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED", "6"),
    ("(guint) FLATPAK_QUERY_FLAGS_NONE", "0"),
    ("(guint) FLATPAK_QUERY_FLAGS_ONLY_CACHED", "1"),
    ("(guint) FLATPAK_QUERY_FLAGS_ONLY_SIDELOADED", "2"),
    ("(gint) FLATPAK_REF_KIND_APP", "0"),
    ("(gint) FLATPAK_REF_KIND_RUNTIME", "1"),
    ("(gint) FLATPAK_REMOTE_TYPE_LAN", "2"),
    ("(gint) FLATPAK_REMOTE_TYPE_STATIC", "0"),
    ("(gint) FLATPAK_REMOTE_TYPE_USB", "1"),
    ("(gint) FLATPAK_STORAGE_TYPE_DEFAULT", "0"),
    ("(gint) FLATPAK_STORAGE_TYPE_HARD_DISK", "1"),
    ("(gint) FLATPAK_STORAGE_TYPE_MMC", "3"),
    ("(gint) FLATPAK_STORAGE_TYPE_NETWORK", "4"),
    ("(gint) FLATPAK_STORAGE_TYPE_SDCARD", "2"),
    ("(guint) FLATPAK_TRANSACTION_ERROR_DETAILS_NON_FATAL", "1"),
    ("(gint) FLATPAK_TRANSACTION_OPERATION_INSTALL", "0"),
    ("(gint) FLATPAK_TRANSACTION_OPERATION_INSTALL_BUNDLE", "2"),
    ("(gint) FLATPAK_TRANSACTION_OPERATION_LAST_TYPE", "4"),
    ("(gint) FLATPAK_TRANSACTION_OPERATION_UNINSTALL", "3"),
    ("(gint) FLATPAK_TRANSACTION_OPERATION_UPDATE", "1"),
    ("(gint) FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO", "0"),
    ("(gint) FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS", "1"),
    ("(guint) FLATPAK_TRANSACTION_RESULT_NO_CHANGE", "1"),
    ("(guint) FLATPAK_UNINSTALL_FLAGS_NONE", "0"),
    ("(guint) FLATPAK_UNINSTALL_FLAGS_NO_PRUNE", "1"),
    ("(guint) FLATPAK_UNINSTALL_FLAGS_NO_TRIGGERS", "2"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NONE", "0"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NO_DEPLOY", "1"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NO_PRUNE", "8"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NO_PULL", "2"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NO_STATIC_DELTAS", "4"),
    ("(guint) FLATPAK_UPDATE_FLAGS_NO_TRIGGERS", "16"),
];
