/* automatically generated by rust-bindgen 0.55.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const FLAC_API_VERSION_CURRENT: u32 = 11;
pub const FLAC_API_VERSION_REVISION: u32 = 0;
pub const FLAC_API_VERSION_AGE: u32 = 3;
pub const FLAC__MAX_METADATA_TYPE_CODE: u32 = 126;
pub const FLAC__MIN_BLOCK_SIZE: u32 = 16;
pub const FLAC__MAX_BLOCK_SIZE: u32 = 65535;
pub const FLAC__SUBSET_MAX_BLOCK_SIZE_48000HZ: u32 = 4608;
pub const FLAC__MAX_CHANNELS: u32 = 8;
pub const FLAC__MIN_BITS_PER_SAMPLE: u32 = 4;
pub const FLAC__MAX_BITS_PER_SAMPLE: u32 = 32;
pub const FLAC__REFERENCE_CODEC_MAX_BITS_PER_SAMPLE: u32 = 24;
pub const FLAC__MAX_SAMPLE_RATE: u32 = 655350;
pub const FLAC__MAX_LPC_ORDER: u32 = 32;
pub const FLAC__SUBSET_MAX_LPC_ORDER_48000HZ: u32 = 12;
pub const FLAC__MIN_QLP_COEFF_PRECISION: u32 = 5;
pub const FLAC__MAX_QLP_COEFF_PRECISION: u32 = 15;
pub const FLAC__MAX_FIXED_ORDER: u32 = 4;
pub const FLAC__MAX_RICE_PARTITION_ORDER: u32 = 15;
pub const FLAC__SUBSET_MAX_RICE_PARTITION_ORDER: u32 = 8;
pub const FLAC__STREAM_SYNC_LENGTH: u32 = 4;
pub const FLAC__STREAM_METADATA_STREAMINFO_LENGTH: u32 = 34;
pub const FLAC__STREAM_METADATA_SEEKPOINT_LENGTH: u32 = 18;
pub const FLAC__STREAM_METADATA_HEADER_LENGTH: u32 = 4;
extern "C" {
    pub static mut FLAC_API_SUPPORTS_OGG_FLAC: libc::c_int;
}
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type __off_t = libc::c_long;
pub type __off64_t = libc::c_long;
pub type FLAC__int8 = i8;
pub type FLAC__uint8 = u8;
pub type FLAC__int16 = i16;
pub type FLAC__int32 = i32;
pub type FLAC__int64 = i64;
pub type FLAC__uint16 = u16;
pub type FLAC__uint32 = u32;
pub type FLAC__uint64 = u64;
pub type FLAC__bool = libc::c_int;
pub type FLAC__byte = FLAC__uint8;
pub type off_t = __off_t;
pub type FLAC__IOHandle = *mut libc::c_void;
pub type FLAC__IOCallback_Read = ::core::option::Option<
    unsafe extern "C" fn(
        ptr: *mut libc::c_void,
        size: usize,
        nmemb: usize,
        handle: FLAC__IOHandle,
    ) -> usize,
>;
pub type FLAC__IOCallback_Write = ::core::option::Option<
    unsafe extern "C" fn(
        ptr: *const libc::c_void,
        size: usize,
        nmemb: usize,
        handle: FLAC__IOHandle,
    ) -> usize,
>;
pub type FLAC__IOCallback_Seek = ::core::option::Option<
    unsafe extern "C" fn(
        handle: FLAC__IOHandle,
        offset: FLAC__int64,
        whence: libc::c_int,
    ) -> libc::c_int,
>;
pub type FLAC__IOCallback_Tell =
    ::core::option::Option<unsafe extern "C" fn(handle: FLAC__IOHandle) -> FLAC__int64>;
pub type FLAC__IOCallback_Eof =
    ::core::option::Option<unsafe extern "C" fn(handle: FLAC__IOHandle) -> libc::c_int>;
pub type FLAC__IOCallback_Close =
    ::core::option::Option<unsafe extern "C" fn(handle: FLAC__IOHandle) -> libc::c_int>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__IOCallbacks {
    pub read: FLAC__IOCallback_Read,
    pub write: FLAC__IOCallback_Write,
    pub seek: FLAC__IOCallback_Seek,
    pub tell: FLAC__IOCallback_Tell,
    pub eof: FLAC__IOCallback_Eof,
    pub close: FLAC__IOCallback_Close,
}
#[test]
fn bindgen_test_layout_FLAC__IOCallbacks() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__IOCallbacks>(),
        48usize,
        concat!("Size of: ", stringify!(FLAC__IOCallbacks))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__IOCallbacks>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__IOCallbacks))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).read as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).write as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).seek as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).tell as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(tell)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).eof as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(eof)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__IOCallbacks>())).close as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__IOCallbacks),
            "::",
            stringify!(close)
        )
    );
}
extern "C" {
    pub static mut FLAC__VERSION_STRING: *const libc::c_char;
}
extern "C" {
    pub static mut FLAC__VENDOR_STRING: *const libc::c_char;
}
extern "C" {
    pub static FLAC__STREAM_SYNC_STRING: [FLAC__byte; 4usize];
}
extern "C" {
    pub static FLAC__STREAM_SYNC: u32;
}
extern "C" {
    pub static FLAC__STREAM_SYNC_LEN: u32;
}
pub const FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE: FLAC__EntropyCodingMethodType = 0;
pub const FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2: FLAC__EntropyCodingMethodType = 1;
pub type FLAC__EntropyCodingMethodType = libc::c_uint;
extern "C" {
    pub static mut FLAC__EntropyCodingMethodTypeString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__EntropyCodingMethod_PartitionedRiceContents {
    pub parameters: *mut u32,
    pub raw_bits: *mut u32,
    pub capacity_by_order: u32,
}
#[test]
fn bindgen_test_layout_FLAC__EntropyCodingMethod_PartitionedRiceContents() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__EntropyCodingMethod_PartitionedRiceContents>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRiceContents)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__EntropyCodingMethod_PartitionedRiceContents>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRiceContents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod_PartitionedRiceContents>()))
                .parameters as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRiceContents),
            "::",
            stringify!(parameters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod_PartitionedRiceContents>())).raw_bits
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRiceContents),
            "::",
            stringify!(raw_bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod_PartitionedRiceContents>()))
                .capacity_by_order as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRiceContents),
            "::",
            stringify!(capacity_by_order)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__EntropyCodingMethod_PartitionedRice {
    pub order: u32,
    pub contents: *const FLAC__EntropyCodingMethod_PartitionedRiceContents,
}
#[test]
fn bindgen_test_layout_FLAC__EntropyCodingMethod_PartitionedRice() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__EntropyCodingMethod_PartitionedRice>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRice)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__EntropyCodingMethod_PartitionedRice>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod_PartitionedRice>())).order as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRice),
            "::",
            stringify!(order)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod_PartitionedRice>())).contents
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod_PartitionedRice),
            "::",
            stringify!(contents)
        )
    );
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ORDER_LEN: u32;
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_PARAMETER_LEN: u32;
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_PARAMETER_LEN: u32;
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN: u32;
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ESCAPE_PARAMETER: u32;
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_ESCAPE_PARAMETER: u32;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__EntropyCodingMethod {
    pub type_: FLAC__EntropyCodingMethodType,
    pub data: FLAC__EntropyCodingMethod__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union FLAC__EntropyCodingMethod__bindgen_ty_1 {
    pub partitioned_rice: FLAC__EntropyCodingMethod_PartitionedRice,
    _bindgen_union_align: [u64; 2usize],
}
#[test]
fn bindgen_test_layout_FLAC__EntropyCodingMethod__bindgen_ty_1() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__EntropyCodingMethod__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(FLAC__EntropyCodingMethod__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__EntropyCodingMethod__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__EntropyCodingMethod__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod__bindgen_ty_1>())).partitioned_rice
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod__bindgen_ty_1),
            "::",
            stringify!(partitioned_rice)
        )
    );
}
#[test]
fn bindgen_test_layout_FLAC__EntropyCodingMethod() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__EntropyCodingMethod>(),
        24usize,
        concat!("Size of: ", stringify!(FLAC__EntropyCodingMethod))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__EntropyCodingMethod>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__EntropyCodingMethod))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__EntropyCodingMethod>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__EntropyCodingMethod>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__EntropyCodingMethod),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub static FLAC__ENTROPY_CODING_METHOD_TYPE_LEN: u32;
}
pub const FLAC__SUBFRAME_TYPE_CONSTANT: FLAC__SubframeType = 0;
pub const FLAC__SUBFRAME_TYPE_VERBATIM: FLAC__SubframeType = 1;
pub const FLAC__SUBFRAME_TYPE_FIXED: FLAC__SubframeType = 2;
pub const FLAC__SUBFRAME_TYPE_LPC: FLAC__SubframeType = 3;
pub type FLAC__SubframeType = libc::c_uint;
extern "C" {
    pub static mut FLAC__SubframeTypeString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__Subframe_Constant {
    pub value: FLAC__int32,
}
#[test]
fn bindgen_test_layout_FLAC__Subframe_Constant() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe_Constant>(),
        4usize,
        concat!("Size of: ", stringify!(FLAC__Subframe_Constant))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe_Constant>(),
        4usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe_Constant))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_Constant>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Constant),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__Subframe_Verbatim {
    pub data: *const FLAC__int32,
}
#[test]
fn bindgen_test_layout_FLAC__Subframe_Verbatim() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe_Verbatim>(),
        8usize,
        concat!("Size of: ", stringify!(FLAC__Subframe_Verbatim))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe_Verbatim>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe_Verbatim))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_Verbatim>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Verbatim),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__Subframe_Fixed {
    pub entropy_coding_method: FLAC__EntropyCodingMethod,
    pub order: u32,
    pub warmup: [FLAC__int32; 4usize],
    pub residual: *const FLAC__int32,
}
#[test]
fn bindgen_test_layout_FLAC__Subframe_Fixed() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe_Fixed>(),
        56usize,
        concat!("Size of: ", stringify!(FLAC__Subframe_Fixed))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe_Fixed>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe_Fixed))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe_Fixed>())).entropy_coding_method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Fixed),
            "::",
            stringify!(entropy_coding_method)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_Fixed>())).order as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Fixed),
            "::",
            stringify!(order)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_Fixed>())).warmup as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Fixed),
            "::",
            stringify!(warmup)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_Fixed>())).residual as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_Fixed),
            "::",
            stringify!(residual)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__Subframe_LPC {
    pub entropy_coding_method: FLAC__EntropyCodingMethod,
    pub order: u32,
    pub qlp_coeff_precision: u32,
    pub quantization_level: libc::c_int,
    pub qlp_coeff: [FLAC__int32; 32usize],
    pub warmup: [FLAC__int32; 32usize],
    pub residual: *const FLAC__int32,
}
#[test]
fn bindgen_test_layout_FLAC__Subframe_LPC() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe_LPC>(),
        304usize,
        concat!("Size of: ", stringify!(FLAC__Subframe_LPC))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe_LPC>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe_LPC))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).entropy_coding_method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(entropy_coding_method)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).order as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(order)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).qlp_coeff_precision as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(qlp_coeff_precision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).quantization_level as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(quantization_level)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).qlp_coeff as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(qlp_coeff)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).warmup as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(warmup)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe_LPC>())).residual as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe_LPC),
            "::",
            stringify!(residual)
        )
    );
}
extern "C" {
    pub static FLAC__SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_LPC_QLP_SHIFT_LEN: u32;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__Subframe {
    pub type_: FLAC__SubframeType,
    pub data: FLAC__Subframe__bindgen_ty_1,
    pub wasted_bits: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union FLAC__Subframe__bindgen_ty_1 {
    pub constant: FLAC__Subframe_Constant,
    pub fixed: FLAC__Subframe_Fixed,
    pub lpc: FLAC__Subframe_LPC,
    pub verbatim: FLAC__Subframe_Verbatim,
    _bindgen_union_align: [u64; 38usize],
}
#[test]
fn bindgen_test_layout_FLAC__Subframe__bindgen_ty_1() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe__bindgen_ty_1>(),
        304usize,
        concat!("Size of: ", stringify!(FLAC__Subframe__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe__bindgen_ty_1>())).constant as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe__bindgen_ty_1),
            "::",
            stringify!(constant)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe__bindgen_ty_1>())).fixed as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe__bindgen_ty_1),
            "::",
            stringify!(fixed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe__bindgen_ty_1>())).lpc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe__bindgen_ty_1),
            "::",
            stringify!(lpc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__Subframe__bindgen_ty_1>())).verbatim as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe__bindgen_ty_1),
            "::",
            stringify!(verbatim)
        )
    );
}
#[test]
fn bindgen_test_layout_FLAC__Subframe() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Subframe>(),
        320usize,
        concat!("Size of: ", stringify!(FLAC__Subframe))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Subframe>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Subframe))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Subframe>())).wasted_bits as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Subframe),
            "::",
            stringify!(wasted_bits)
        )
    );
}
extern "C" {
    pub static FLAC__SUBFRAME_ZERO_PAD_LEN: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_TYPE_LEN: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_TYPE_CONSTANT_BYTE_ALIGNED_MASK: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_TYPE_VERBATIM_BYTE_ALIGNED_MASK: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_TYPE_FIXED_BYTE_ALIGNED_MASK: u32;
}
extern "C" {
    pub static FLAC__SUBFRAME_TYPE_LPC_BYTE_ALIGNED_MASK: u32;
}
pub const FLAC__CHANNEL_ASSIGNMENT_INDEPENDENT: FLAC__ChannelAssignment = 0;
pub const FLAC__CHANNEL_ASSIGNMENT_LEFT_SIDE: FLAC__ChannelAssignment = 1;
pub const FLAC__CHANNEL_ASSIGNMENT_RIGHT_SIDE: FLAC__ChannelAssignment = 2;
pub const FLAC__CHANNEL_ASSIGNMENT_MID_SIDE: FLAC__ChannelAssignment = 3;
pub type FLAC__ChannelAssignment = libc::c_uint;
extern "C" {
    pub static mut FLAC__ChannelAssignmentString: [*const libc::c_char; 0usize];
}
pub const FLAC__FRAME_NUMBER_TYPE_FRAME_NUMBER: FLAC__FrameNumberType = 0;
pub const FLAC__FRAME_NUMBER_TYPE_SAMPLE_NUMBER: FLAC__FrameNumberType = 1;
pub type FLAC__FrameNumberType = libc::c_uint;
extern "C" {
    pub static mut FLAC__FrameNumberTypeString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__FrameHeader {
    pub blocksize: u32,
    pub sample_rate: u32,
    pub channels: u32,
    pub channel_assignment: FLAC__ChannelAssignment,
    pub bits_per_sample: u32,
    pub number_type: FLAC__FrameNumberType,
    pub number: FLAC__FrameHeader__bindgen_ty_1,
    pub crc: FLAC__uint8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union FLAC__FrameHeader__bindgen_ty_1 {
    pub frame_number: FLAC__uint32,
    pub sample_number: FLAC__uint64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_FLAC__FrameHeader__bindgen_ty_1() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__FrameHeader__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(FLAC__FrameHeader__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__FrameHeader__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__FrameHeader__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__FrameHeader__bindgen_ty_1>())).frame_number as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader__bindgen_ty_1),
            "::",
            stringify!(frame_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__FrameHeader__bindgen_ty_1>())).sample_number as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader__bindgen_ty_1),
            "::",
            stringify!(sample_number)
        )
    );
}
#[test]
fn bindgen_test_layout_FLAC__FrameHeader() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__FrameHeader>(),
        40usize,
        concat!("Size of: ", stringify!(FLAC__FrameHeader))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__FrameHeader>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__FrameHeader))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).blocksize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(blocksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).sample_rate as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(sample_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).channels as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__FrameHeader>())).channel_assignment as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(channel_assignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__FrameHeader>())).bits_per_sample as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(bits_per_sample)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).number_type as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(number_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).number as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(number)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameHeader>())).crc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameHeader),
            "::",
            stringify!(crc)
        )
    );
}
extern "C" {
    pub static FLAC__FRAME_HEADER_SYNC: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_SYNC_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_RESERVED_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_BLOCKING_STRATEGY_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_BLOCK_SIZE_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_SAMPLE_RATE_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_CHANNEL_ASSIGNMENT_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_BITS_PER_SAMPLE_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_ZERO_PAD_LEN: u32;
}
extern "C" {
    pub static FLAC__FRAME_HEADER_CRC_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__FrameFooter {
    pub crc: FLAC__uint16,
}
#[test]
fn bindgen_test_layout_FLAC__FrameFooter() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__FrameFooter>(),
        2usize,
        concat!("Size of: ", stringify!(FLAC__FrameFooter))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__FrameFooter>(),
        2usize,
        concat!("Alignment of ", stringify!(FLAC__FrameFooter))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__FrameFooter>())).crc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__FrameFooter),
            "::",
            stringify!(crc)
        )
    );
}
extern "C" {
    pub static FLAC__FRAME_FOOTER_CRC_LEN: u32;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__Frame {
    pub header: FLAC__FrameHeader,
    pub subframes: [FLAC__Subframe; 8usize],
    pub footer: FLAC__FrameFooter,
}
#[test]
fn bindgen_test_layout_FLAC__Frame() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__Frame>(),
        2608usize,
        concat!("Size of: ", stringify!(FLAC__Frame))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__Frame>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__Frame))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Frame>())).header as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Frame),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Frame>())).subframes as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Frame),
            "::",
            stringify!(subframes)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__Frame>())).footer as *const _ as usize },
        2600usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__Frame),
            "::",
            stringify!(footer)
        )
    );
}
pub const FLAC__METADATA_TYPE_STREAMINFO: FLAC__MetadataType = 0;
pub const FLAC__METADATA_TYPE_PADDING: FLAC__MetadataType = 1;
pub const FLAC__METADATA_TYPE_APPLICATION: FLAC__MetadataType = 2;
pub const FLAC__METADATA_TYPE_SEEKTABLE: FLAC__MetadataType = 3;
pub const FLAC__METADATA_TYPE_VORBIS_COMMENT: FLAC__MetadataType = 4;
pub const FLAC__METADATA_TYPE_CUESHEET: FLAC__MetadataType = 5;
pub const FLAC__METADATA_TYPE_PICTURE: FLAC__MetadataType = 6;
pub const FLAC__METADATA_TYPE_UNDEFINED: FLAC__MetadataType = 7;
pub const FLAC__MAX_METADATA_TYPE: FLAC__MetadataType = 126;
pub type FLAC__MetadataType = libc::c_uint;
extern "C" {
    pub static mut FLAC__MetadataTypeString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_StreamInfo {
    pub min_blocksize: u32,
    pub max_blocksize: u32,
    pub min_framesize: u32,
    pub max_framesize: u32,
    pub sample_rate: u32,
    pub channels: u32,
    pub bits_per_sample: u32,
    pub total_samples: FLAC__uint64,
    pub md5sum: [FLAC__byte; 16usize],
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_StreamInfo() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_StreamInfo>(),
        56usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_StreamInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_StreamInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_StreamInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).min_blocksize as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(min_blocksize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).max_blocksize as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(max_blocksize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).min_framesize as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(min_framesize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).max_framesize as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(max_framesize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).sample_rate as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(sample_rate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).channels as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).bits_per_sample as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(bits_per_sample)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).total_samples as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(total_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_StreamInfo>())).md5sum as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_StreamInfo),
            "::",
            stringify!(md5sum)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_MIN_BLOCK_SIZE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_MAX_BLOCK_SIZE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_MIN_FRAME_SIZE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_MAX_FRAME_SIZE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_SAMPLE_RATE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_CHANNELS_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_BITS_PER_SAMPLE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_TOTAL_SAMPLES_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_STREAMINFO_MD5SUM_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_Padding {
    pub dummy: libc::c_int,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_Padding() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_Padding>(),
        4usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_Padding))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_Padding>(),
        4usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_Padding))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Padding>())).dummy as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Padding),
            "::",
            stringify!(dummy)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_Application {
    pub id: [FLAC__byte; 4usize],
    pub data: *mut FLAC__byte,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_Application() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_Application>(),
        16usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_Application))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_Application>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata_Application)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Application>())).id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Application),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Application>())).data as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Application),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_APPLICATION_ID_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_SeekPoint {
    pub sample_number: FLAC__uint64,
    pub stream_offset: FLAC__uint64,
    pub frame_samples: u32,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_SeekPoint() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_SeekPoint>(),
        24usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_SeekPoint))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_SeekPoint>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_SeekPoint))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_SeekPoint>())).sample_number as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_SeekPoint),
            "::",
            stringify!(sample_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_SeekPoint>())).stream_offset as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_SeekPoint),
            "::",
            stringify!(stream_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_SeekPoint>())).frame_samples as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_SeekPoint),
            "::",
            stringify!(frame_samples)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_SEEKPOINT_SAMPLE_NUMBER_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_SEEKPOINT_STREAM_OFFSET_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_SEEKPOINT_FRAME_SAMPLES_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_SEEKPOINT_PLACEHOLDER: FLAC__uint64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_SeekTable {
    pub num_points: u32,
    pub points: *mut FLAC__StreamMetadata_SeekPoint,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_SeekTable() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_SeekTable>(),
        16usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_SeekTable))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_SeekTable>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_SeekTable))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_SeekTable>())).num_points as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_SeekTable),
            "::",
            stringify!(num_points)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_SeekTable>())).points as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_SeekTable),
            "::",
            stringify!(points)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_VorbisComment_Entry {
    pub length: FLAC__uint32,
    pub entry: *mut FLAC__byte,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_VorbisComment_Entry() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_VorbisComment_Entry>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(FLAC__StreamMetadata_VorbisComment_Entry)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_VorbisComment_Entry>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata_VorbisComment_Entry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_VorbisComment_Entry>())).length as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_VorbisComment_Entry),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_VorbisComment_Entry>())).entry as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_VorbisComment_Entry),
            "::",
            stringify!(entry)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_VORBIS_COMMENT_ENTRY_LENGTH_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_VorbisComment {
    pub vendor_string: FLAC__StreamMetadata_VorbisComment_Entry,
    pub num_comments: FLAC__uint32,
    pub comments: *mut FLAC__StreamMetadata_VorbisComment_Entry,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_VorbisComment() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_VorbisComment>(),
        32usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_VorbisComment))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_VorbisComment>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata_VorbisComment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_VorbisComment>())).vendor_string
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_VorbisComment),
            "::",
            stringify!(vendor_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_VorbisComment>())).num_comments as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_VorbisComment),
            "::",
            stringify!(num_comments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_VorbisComment>())).comments as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_VorbisComment),
            "::",
            stringify!(comments)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_VORBIS_COMMENT_NUM_COMMENTS_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_CueSheet_Index {
    pub offset: FLAC__uint64,
    pub number: FLAC__byte,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_CueSheet_Index() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_CueSheet_Index>(),
        16usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_CueSheet_Index))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_CueSheet_Index>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata_CueSheet_Index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Index>())).offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Index),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Index>())).number as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Index),
            "::",
            stringify!(number)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_INDEX_OFFSET_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_INDEX_NUMBER_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_INDEX_RESERVED_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_CueSheet_Track {
    pub offset: FLAC__uint64,
    pub number: FLAC__byte,
    pub isrc: [libc::c_char; 13usize],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub num_indices: FLAC__byte,
    pub indices: *mut FLAC__StreamMetadata_CueSheet_Index,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_CueSheet_Track() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_CueSheet_Track>(),
        32usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_CueSheet_Track))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_CueSheet_Track>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Track>())).offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Track>())).number as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track),
            "::",
            stringify!(number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Track>())).isrc as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track),
            "::",
            stringify!(isrc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Track>())).num_indices as *const _
                as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track),
            "::",
            stringify!(num_indices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet_Track>())).indices as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet_Track),
            "::",
            stringify!(indices)
        )
    );
}
impl FLAC__StreamMetadata_CueSheet_Track {
    #[inline]
    pub fn type_(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pre_emphasis(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pre_emphasis(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: u32,
        pre_emphasis: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let pre_emphasis: u32 = unsafe { ::core::mem::transmute(pre_emphasis) };
            pre_emphasis as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_OFFSET_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_NUMBER_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_ISRC_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_TYPE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_PRE_EMPHASIS_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_RESERVED_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_TRACK_NUM_INDICES_LEN: u32;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__StreamMetadata_CueSheet {
    pub media_catalog_number: [libc::c_char; 129usize],
    pub lead_in: FLAC__uint64,
    pub is_cd: FLAC__bool,
    pub num_tracks: u32,
    pub tracks: *mut FLAC__StreamMetadata_CueSheet_Track,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_CueSheet() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_CueSheet>(),
        160usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_CueSheet))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_CueSheet>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_CueSheet))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet>())).media_catalog_number
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet),
            "::",
            stringify!(media_catalog_number)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet>())).lead_in as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet),
            "::",
            stringify!(lead_in)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet>())).is_cd as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet),
            "::",
            stringify!(is_cd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet>())).num_tracks as *const _
                as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet),
            "::",
            stringify!(num_tracks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_CueSheet>())).tracks as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_CueSheet),
            "::",
            stringify!(tracks)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_MEDIA_CATALOG_NUMBER_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_LEAD_IN_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_IS_CD_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_RESERVED_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_CUESHEET_NUM_TRACKS_LEN: u32;
}
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_OTHER: FLAC__StreamMetadata_Picture_Type = 0;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_FILE_ICON_STANDARD: FLAC__StreamMetadata_Picture_Type =
    1;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_FILE_ICON: FLAC__StreamMetadata_Picture_Type = 2;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_FRONT_COVER: FLAC__StreamMetadata_Picture_Type = 3;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_BACK_COVER: FLAC__StreamMetadata_Picture_Type = 4;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_LEAFLET_PAGE: FLAC__StreamMetadata_Picture_Type = 5;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_MEDIA: FLAC__StreamMetadata_Picture_Type = 6;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_LEAD_ARTIST: FLAC__StreamMetadata_Picture_Type = 7;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_ARTIST: FLAC__StreamMetadata_Picture_Type = 8;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_CONDUCTOR: FLAC__StreamMetadata_Picture_Type = 9;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_BAND: FLAC__StreamMetadata_Picture_Type = 10;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_COMPOSER: FLAC__StreamMetadata_Picture_Type = 11;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_LYRICIST: FLAC__StreamMetadata_Picture_Type = 12;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_RECORDING_LOCATION: FLAC__StreamMetadata_Picture_Type =
    13;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_DURING_RECORDING: FLAC__StreamMetadata_Picture_Type =
    14;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_DURING_PERFORMANCE: FLAC__StreamMetadata_Picture_Type =
    15;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_VIDEO_SCREEN_CAPTURE:
    FLAC__StreamMetadata_Picture_Type = 16;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_FISH: FLAC__StreamMetadata_Picture_Type = 17;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_ILLUSTRATION: FLAC__StreamMetadata_Picture_Type = 18;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_BAND_LOGOTYPE: FLAC__StreamMetadata_Picture_Type = 19;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_PUBLISHER_LOGOTYPE: FLAC__StreamMetadata_Picture_Type =
    20;
pub const FLAC__STREAM_METADATA_PICTURE_TYPE_UNDEFINED: FLAC__StreamMetadata_Picture_Type = 21;
pub type FLAC__StreamMetadata_Picture_Type = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamMetadata_Picture_TypeString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_Picture {
    pub type_: FLAC__StreamMetadata_Picture_Type,
    pub mime_type: *mut libc::c_char,
    pub description: *mut FLAC__byte,
    pub width: FLAC__uint32,
    pub height: FLAC__uint32,
    pub depth: FLAC__uint32,
    pub colors: FLAC__uint32,
    pub data_length: FLAC__uint32,
    pub data: *mut FLAC__byte,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_Picture() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_Picture>(),
        56usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_Picture))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_Picture>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_Picture))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).mime_type as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(mime_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).description as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).width as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).height as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).depth as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).colors as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(colors)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).data_length as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(data_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Picture>())).data as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Picture),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_TYPE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_MIME_TYPE_LENGTH_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_DESCRIPTION_LENGTH_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_WIDTH_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_HEIGHT_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_DEPTH_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_COLORS_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_PICTURE_DATA_LENGTH_LEN: u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamMetadata_Unknown {
    pub data: *mut FLAC__byte,
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata_Unknown() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata_Unknown>(),
        8usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata_Unknown))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata_Unknown>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata_Unknown))
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata_Unknown>())).data as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata_Unknown),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FLAC__StreamMetadata {
    pub type_: FLAC__MetadataType,
    pub is_last: FLAC__bool,
    pub length: u32,
    pub data: FLAC__StreamMetadata__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union FLAC__StreamMetadata__bindgen_ty_1 {
    pub stream_info: FLAC__StreamMetadata_StreamInfo,
    pub padding: FLAC__StreamMetadata_Padding,
    pub application: FLAC__StreamMetadata_Application,
    pub seek_table: FLAC__StreamMetadata_SeekTable,
    pub vorbis_comment: FLAC__StreamMetadata_VorbisComment,
    pub cue_sheet: FLAC__StreamMetadata_CueSheet,
    pub picture: FLAC__StreamMetadata_Picture,
    pub unknown: FLAC__StreamMetadata_Unknown,
    _bindgen_union_align: [u64; 20usize],
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata__bindgen_ty_1() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata__bindgen_ty_1>(),
        160usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).stream_info as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(stream_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).padding as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).application as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(application)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).seek_table as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(seek_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).vorbis_comment
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(vorbis_comment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).cue_sheet as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(cue_sheet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).picture as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(picture)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<FLAC__StreamMetadata__bindgen_ty_1>())).unknown as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata__bindgen_ty_1),
            "::",
            stringify!(unknown)
        )
    );
}
#[test]
fn bindgen_test_layout_FLAC__StreamMetadata() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamMetadata>(),
        176usize,
        concat!("Size of: ", stringify!(FLAC__StreamMetadata))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamMetadata>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamMetadata))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamMetadata>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamMetadata>())).is_last as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata),
            "::",
            stringify!(is_last)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamMetadata>())).length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamMetadata>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamMetadata),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub static FLAC__STREAM_METADATA_IS_LAST_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_TYPE_LEN: u32;
}
extern "C" {
    pub static FLAC__STREAM_METADATA_LENGTH_LEN: u32;
}
extern "C" {
    pub fn FLAC__format_sample_rate_is_valid(sample_rate: u32) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_blocksize_is_subset(blocksize: u32, sample_rate: u32) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_sample_rate_is_subset(sample_rate: u32) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_vorbiscomment_entry_name_is_legal(name: *const libc::c_char) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_vorbiscomment_entry_value_is_legal(
        value: *const FLAC__byte,
        length: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_vorbiscomment_entry_is_legal(
        entry: *const FLAC__byte,
        length: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_seektable_is_legal(
        seek_table: *const FLAC__StreamMetadata_SeekTable,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_seektable_sort(seek_table: *mut FLAC__StreamMetadata_SeekTable) -> u32;
}
extern "C" {
    pub fn FLAC__format_cuesheet_is_legal(
        cue_sheet: *const FLAC__StreamMetadata_CueSheet,
        check_cd_da_subset: FLAC__bool,
        violation: *mut *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__format_picture_is_legal(
        picture: *const FLAC__StreamMetadata_Picture,
        violation: *mut *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_get_streaminfo(
        filename: *const libc::c_char,
        streaminfo: *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_get_tags(
        filename: *const libc::c_char,
        tags: *mut *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_get_cuesheet(
        filename: *const libc::c_char,
        cuesheet: *mut *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_get_picture(
        filename: *const libc::c_char,
        picture: *mut *mut FLAC__StreamMetadata,
        type_: FLAC__StreamMetadata_Picture_Type,
        mime_type: *const libc::c_char,
        description: *const FLAC__byte,
        max_width: u32,
        max_height: u32,
        max_depth: u32,
        max_colors: u32,
    ) -> FLAC__bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__Metadata_SimpleIterator {
    _unused: [u8; 0],
}
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_OK: FLAC__Metadata_SimpleIteratorStatus = 0;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_ILLEGAL_INPUT: FLAC__Metadata_SimpleIteratorStatus =
    1;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_ERROR_OPENING_FILE:
    FLAC__Metadata_SimpleIteratorStatus = 2;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_NOT_A_FLAC_FILE:
    FLAC__Metadata_SimpleIteratorStatus = 3;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_NOT_WRITABLE: FLAC__Metadata_SimpleIteratorStatus =
    4;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_BAD_METADATA: FLAC__Metadata_SimpleIteratorStatus =
    5;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_READ_ERROR: FLAC__Metadata_SimpleIteratorStatus = 6;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_SEEK_ERROR: FLAC__Metadata_SimpleIteratorStatus = 7;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_WRITE_ERROR: FLAC__Metadata_SimpleIteratorStatus =
    8;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_RENAME_ERROR: FLAC__Metadata_SimpleIteratorStatus =
    9;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_UNLINK_ERROR: FLAC__Metadata_SimpleIteratorStatus =
    10;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_MEMORY_ALLOCATION_ERROR:
    FLAC__Metadata_SimpleIteratorStatus = 11;
pub const FLAC__METADATA_SIMPLE_ITERATOR_STATUS_INTERNAL_ERROR:
    FLAC__Metadata_SimpleIteratorStatus = 12;
pub type FLAC__Metadata_SimpleIteratorStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__Metadata_SimpleIteratorStatusString: [*const libc::c_char; 0usize];
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_new() -> *mut FLAC__Metadata_SimpleIterator;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_delete(iterator: *mut FLAC__Metadata_SimpleIterator);
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_status(
        iterator: *mut FLAC__Metadata_SimpleIterator,
    ) -> FLAC__Metadata_SimpleIteratorStatus;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_init(
        iterator: *mut FLAC__Metadata_SimpleIterator,
        filename: *const libc::c_char,
        read_only: FLAC__bool,
        preserve_file_stats: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_is_writable(
        iterator: *const FLAC__Metadata_SimpleIterator,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_next(
        iterator: *mut FLAC__Metadata_SimpleIterator,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_prev(
        iterator: *mut FLAC__Metadata_SimpleIterator,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_is_last(
        iterator: *const FLAC__Metadata_SimpleIterator,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_get_block_offset(
        iterator: *const FLAC__Metadata_SimpleIterator,
    ) -> off_t;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_get_block_type(
        iterator: *const FLAC__Metadata_SimpleIterator,
    ) -> FLAC__MetadataType;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_get_block_length(
        iterator: *const FLAC__Metadata_SimpleIterator,
    ) -> u32;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_get_application_id(
        iterator: *mut FLAC__Metadata_SimpleIterator,
        id: *mut FLAC__byte,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_get_block(
        iterator: *mut FLAC__Metadata_SimpleIterator,
    ) -> *mut FLAC__StreamMetadata;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_set_block(
        iterator: *mut FLAC__Metadata_SimpleIterator,
        block: *mut FLAC__StreamMetadata,
        use_padding: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_insert_block_after(
        iterator: *mut FLAC__Metadata_SimpleIterator,
        block: *mut FLAC__StreamMetadata,
        use_padding: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_simple_iterator_delete_block(
        iterator: *mut FLAC__Metadata_SimpleIterator,
        use_padding: FLAC__bool,
    ) -> FLAC__bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__Metadata_Chain {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__Metadata_Iterator {
    _unused: [u8; 0],
}
pub const FLAC__METADATA_CHAIN_STATUS_OK: FLAC__Metadata_ChainStatus = 0;
pub const FLAC__METADATA_CHAIN_STATUS_ILLEGAL_INPUT: FLAC__Metadata_ChainStatus = 1;
pub const FLAC__METADATA_CHAIN_STATUS_ERROR_OPENING_FILE: FLAC__Metadata_ChainStatus = 2;
pub const FLAC__METADATA_CHAIN_STATUS_NOT_A_FLAC_FILE: FLAC__Metadata_ChainStatus = 3;
pub const FLAC__METADATA_CHAIN_STATUS_NOT_WRITABLE: FLAC__Metadata_ChainStatus = 4;
pub const FLAC__METADATA_CHAIN_STATUS_BAD_METADATA: FLAC__Metadata_ChainStatus = 5;
pub const FLAC__METADATA_CHAIN_STATUS_READ_ERROR: FLAC__Metadata_ChainStatus = 6;
pub const FLAC__METADATA_CHAIN_STATUS_SEEK_ERROR: FLAC__Metadata_ChainStatus = 7;
pub const FLAC__METADATA_CHAIN_STATUS_WRITE_ERROR: FLAC__Metadata_ChainStatus = 8;
pub const FLAC__METADATA_CHAIN_STATUS_RENAME_ERROR: FLAC__Metadata_ChainStatus = 9;
pub const FLAC__METADATA_CHAIN_STATUS_UNLINK_ERROR: FLAC__Metadata_ChainStatus = 10;
pub const FLAC__METADATA_CHAIN_STATUS_MEMORY_ALLOCATION_ERROR: FLAC__Metadata_ChainStatus = 11;
pub const FLAC__METADATA_CHAIN_STATUS_INTERNAL_ERROR: FLAC__Metadata_ChainStatus = 12;
pub const FLAC__METADATA_CHAIN_STATUS_INVALID_CALLBACKS: FLAC__Metadata_ChainStatus = 13;
pub const FLAC__METADATA_CHAIN_STATUS_READ_WRITE_MISMATCH: FLAC__Metadata_ChainStatus = 14;
pub const FLAC__METADATA_CHAIN_STATUS_WRONG_WRITE_CALL: FLAC__Metadata_ChainStatus = 15;
pub type FLAC__Metadata_ChainStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__Metadata_ChainStatusString: [*const libc::c_char; 0usize];
}
extern "C" {
    pub fn FLAC__metadata_chain_new() -> *mut FLAC__Metadata_Chain;
}
extern "C" {
    pub fn FLAC__metadata_chain_delete(chain: *mut FLAC__Metadata_Chain);
}
extern "C" {
    pub fn FLAC__metadata_chain_status(
        chain: *mut FLAC__Metadata_Chain,
    ) -> FLAC__Metadata_ChainStatus;
}
extern "C" {
    pub fn FLAC__metadata_chain_read(
        chain: *mut FLAC__Metadata_Chain,
        filename: *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_read_ogg(
        chain: *mut FLAC__Metadata_Chain,
        filename: *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_read_with_callbacks(
        chain: *mut FLAC__Metadata_Chain,
        handle: FLAC__IOHandle,
        callbacks: FLAC__IOCallbacks,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_read_ogg_with_callbacks(
        chain: *mut FLAC__Metadata_Chain,
        handle: FLAC__IOHandle,
        callbacks: FLAC__IOCallbacks,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_check_if_tempfile_needed(
        chain: *mut FLAC__Metadata_Chain,
        use_padding: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_write(
        chain: *mut FLAC__Metadata_Chain,
        use_padding: FLAC__bool,
        preserve_file_stats: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_write_with_callbacks(
        chain: *mut FLAC__Metadata_Chain,
        use_padding: FLAC__bool,
        handle: FLAC__IOHandle,
        callbacks: FLAC__IOCallbacks,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_write_with_callbacks_and_tempfile(
        chain: *mut FLAC__Metadata_Chain,
        use_padding: FLAC__bool,
        handle: FLAC__IOHandle,
        callbacks: FLAC__IOCallbacks,
        temp_handle: FLAC__IOHandle,
        temp_callbacks: FLAC__IOCallbacks,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_chain_merge_padding(chain: *mut FLAC__Metadata_Chain);
}
extern "C" {
    pub fn FLAC__metadata_chain_sort_padding(chain: *mut FLAC__Metadata_Chain);
}
extern "C" {
    pub fn FLAC__metadata_iterator_new() -> *mut FLAC__Metadata_Iterator;
}
extern "C" {
    pub fn FLAC__metadata_iterator_delete(iterator: *mut FLAC__Metadata_Iterator);
}
extern "C" {
    pub fn FLAC__metadata_iterator_init(
        iterator: *mut FLAC__Metadata_Iterator,
        chain: *mut FLAC__Metadata_Chain,
    );
}
extern "C" {
    pub fn FLAC__metadata_iterator_next(iterator: *mut FLAC__Metadata_Iterator) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_iterator_prev(iterator: *mut FLAC__Metadata_Iterator) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_iterator_get_block_type(
        iterator: *const FLAC__Metadata_Iterator,
    ) -> FLAC__MetadataType;
}
extern "C" {
    pub fn FLAC__metadata_iterator_get_block(
        iterator: *mut FLAC__Metadata_Iterator,
    ) -> *mut FLAC__StreamMetadata;
}
extern "C" {
    pub fn FLAC__metadata_iterator_set_block(
        iterator: *mut FLAC__Metadata_Iterator,
        block: *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_iterator_delete_block(
        iterator: *mut FLAC__Metadata_Iterator,
        replace_with_padding: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_iterator_insert_block_before(
        iterator: *mut FLAC__Metadata_Iterator,
        block: *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_iterator_insert_block_after(
        iterator: *mut FLAC__Metadata_Iterator,
        block: *mut FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_new(type_: FLAC__MetadataType) -> *mut FLAC__StreamMetadata;
}
extern "C" {
    pub fn FLAC__metadata_object_clone(
        object: *const FLAC__StreamMetadata,
    ) -> *mut FLAC__StreamMetadata;
}
extern "C" {
    pub fn FLAC__metadata_object_delete(object: *mut FLAC__StreamMetadata);
}
extern "C" {
    pub fn FLAC__metadata_object_is_equal(
        block1: *const FLAC__StreamMetadata,
        block2: *const FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_application_set_data(
        object: *mut FLAC__StreamMetadata,
        data: *mut FLAC__byte,
        length: u32,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_resize_points(
        object: *mut FLAC__StreamMetadata,
        new_num_points: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_set_point(
        object: *mut FLAC__StreamMetadata,
        point_num: u32,
        point: FLAC__StreamMetadata_SeekPoint,
    );
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_insert_point(
        object: *mut FLAC__StreamMetadata,
        point_num: u32,
        point: FLAC__StreamMetadata_SeekPoint,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_delete_point(
        object: *mut FLAC__StreamMetadata,
        point_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_is_legal(
        object: *const FLAC__StreamMetadata,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_append_placeholders(
        object: *mut FLAC__StreamMetadata,
        num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_append_point(
        object: *mut FLAC__StreamMetadata,
        sample_number: FLAC__uint64,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_append_points(
        object: *mut FLAC__StreamMetadata,
        sample_numbers: *mut FLAC__uint64,
        num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_append_spaced_points(
        object: *mut FLAC__StreamMetadata,
        num: u32,
        total_samples: FLAC__uint64,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_append_spaced_points_by_samples(
        object: *mut FLAC__StreamMetadata,
        samples: u32,
        total_samples: FLAC__uint64,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_seektable_template_sort(
        object: *mut FLAC__StreamMetadata,
        compact: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_set_vendor_string(
        object: *mut FLAC__StreamMetadata,
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_resize_comments(
        object: *mut FLAC__StreamMetadata,
        new_num_comments: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_set_comment(
        object: *mut FLAC__StreamMetadata,
        comment_num: u32,
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_insert_comment(
        object: *mut FLAC__StreamMetadata,
        comment_num: u32,
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_append_comment(
        object: *mut FLAC__StreamMetadata,
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_replace_comment(
        object: *mut FLAC__StreamMetadata,
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        all: FLAC__bool,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_delete_comment(
        object: *mut FLAC__StreamMetadata,
        comment_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_entry_from_name_value_pair(
        entry: *mut FLAC__StreamMetadata_VorbisComment_Entry,
        field_name: *const libc::c_char,
        field_value: *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_entry_to_name_value_pair(
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        field_name: *mut *mut libc::c_char,
        field_value: *mut *mut libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_entry_matches(
        entry: FLAC__StreamMetadata_VorbisComment_Entry,
        field_name: *const libc::c_char,
        field_name_length: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_find_entry_from(
        object: *const FLAC__StreamMetadata,
        offset: u32,
        field_name: *const libc::c_char,
    ) -> libc::c_int;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_remove_entry_matching(
        object: *mut FLAC__StreamMetadata,
        field_name: *const libc::c_char,
    ) -> libc::c_int;
}
extern "C" {
    pub fn FLAC__metadata_object_vorbiscomment_remove_entries_matching(
        object: *mut FLAC__StreamMetadata,
        field_name: *const libc::c_char,
    ) -> libc::c_int;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_new() -> *mut FLAC__StreamMetadata_CueSheet_Track;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_clone(
        object: *const FLAC__StreamMetadata_CueSheet_Track,
    ) -> *mut FLAC__StreamMetadata_CueSheet_Track;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_delete(
        object: *mut FLAC__StreamMetadata_CueSheet_Track,
    );
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_resize_indices(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        new_num_indices: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_insert_index(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        index_num: u32,
        index: FLAC__StreamMetadata_CueSheet_Index,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_insert_blank_index(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        index_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_track_delete_index(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        index_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_resize_tracks(
        object: *mut FLAC__StreamMetadata,
        new_num_tracks: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_set_track(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        track: *mut FLAC__StreamMetadata_CueSheet_Track,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_insert_track(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
        track: *mut FLAC__StreamMetadata_CueSheet_Track,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_insert_blank_track(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_delete_track(
        object: *mut FLAC__StreamMetadata,
        track_num: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_is_legal(
        object: *const FLAC__StreamMetadata,
        check_cd_da_subset: FLAC__bool,
        violation: *mut *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_cuesheet_calculate_cddb_id(
        object: *const FLAC__StreamMetadata,
    ) -> FLAC__uint32;
}
extern "C" {
    pub fn FLAC__metadata_object_picture_set_mime_type(
        object: *mut FLAC__StreamMetadata,
        mime_type: *mut libc::c_char,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_picture_set_description(
        object: *mut FLAC__StreamMetadata,
        description: *mut FLAC__byte,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_picture_set_data(
        object: *mut FLAC__StreamMetadata,
        data: *mut FLAC__byte,
        length: FLAC__uint32,
        copy: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__metadata_object_picture_is_legal(
        object: *const FLAC__StreamMetadata,
        violation: *mut *const libc::c_char,
    ) -> FLAC__bool;
}
pub const FLAC__STREAM_DECODER_SEARCH_FOR_METADATA: FLAC__StreamDecoderState = 0;
pub const FLAC__STREAM_DECODER_READ_METADATA: FLAC__StreamDecoderState = 1;
pub const FLAC__STREAM_DECODER_SEARCH_FOR_FRAME_SYNC: FLAC__StreamDecoderState = 2;
pub const FLAC__STREAM_DECODER_READ_FRAME: FLAC__StreamDecoderState = 3;
pub const FLAC__STREAM_DECODER_END_OF_STREAM: FLAC__StreamDecoderState = 4;
pub const FLAC__STREAM_DECODER_OGG_ERROR: FLAC__StreamDecoderState = 5;
pub const FLAC__STREAM_DECODER_SEEK_ERROR: FLAC__StreamDecoderState = 6;
pub const FLAC__STREAM_DECODER_ABORTED: FLAC__StreamDecoderState = 7;
pub const FLAC__STREAM_DECODER_MEMORY_ALLOCATION_ERROR: FLAC__StreamDecoderState = 8;
pub const FLAC__STREAM_DECODER_UNINITIALIZED: FLAC__StreamDecoderState = 9;
pub type FLAC__StreamDecoderState = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderStateString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_INIT_STATUS_OK: FLAC__StreamDecoderInitStatus = 0;
pub const FLAC__STREAM_DECODER_INIT_STATUS_UNSUPPORTED_CONTAINER: FLAC__StreamDecoderInitStatus = 1;
pub const FLAC__STREAM_DECODER_INIT_STATUS_INVALID_CALLBACKS: FLAC__StreamDecoderInitStatus = 2;
pub const FLAC__STREAM_DECODER_INIT_STATUS_MEMORY_ALLOCATION_ERROR: FLAC__StreamDecoderInitStatus =
    3;
pub const FLAC__STREAM_DECODER_INIT_STATUS_ERROR_OPENING_FILE: FLAC__StreamDecoderInitStatus = 4;
pub const FLAC__STREAM_DECODER_INIT_STATUS_ALREADY_INITIALIZED: FLAC__StreamDecoderInitStatus = 5;
pub type FLAC__StreamDecoderInitStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderInitStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_READ_STATUS_CONTINUE: FLAC__StreamDecoderReadStatus = 0;
pub const FLAC__STREAM_DECODER_READ_STATUS_END_OF_STREAM: FLAC__StreamDecoderReadStatus = 1;
pub const FLAC__STREAM_DECODER_READ_STATUS_ABORT: FLAC__StreamDecoderReadStatus = 2;
pub type FLAC__StreamDecoderReadStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderReadStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_SEEK_STATUS_OK: FLAC__StreamDecoderSeekStatus = 0;
pub const FLAC__STREAM_DECODER_SEEK_STATUS_ERROR: FLAC__StreamDecoderSeekStatus = 1;
pub const FLAC__STREAM_DECODER_SEEK_STATUS_UNSUPPORTED: FLAC__StreamDecoderSeekStatus = 2;
pub type FLAC__StreamDecoderSeekStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderSeekStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_TELL_STATUS_OK: FLAC__StreamDecoderTellStatus = 0;
pub const FLAC__STREAM_DECODER_TELL_STATUS_ERROR: FLAC__StreamDecoderTellStatus = 1;
pub const FLAC__STREAM_DECODER_TELL_STATUS_UNSUPPORTED: FLAC__StreamDecoderTellStatus = 2;
pub type FLAC__StreamDecoderTellStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderTellStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_LENGTH_STATUS_OK: FLAC__StreamDecoderLengthStatus = 0;
pub const FLAC__STREAM_DECODER_LENGTH_STATUS_ERROR: FLAC__StreamDecoderLengthStatus = 1;
pub const FLAC__STREAM_DECODER_LENGTH_STATUS_UNSUPPORTED: FLAC__StreamDecoderLengthStatus = 2;
pub type FLAC__StreamDecoderLengthStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderLengthStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_WRITE_STATUS_CONTINUE: FLAC__StreamDecoderWriteStatus = 0;
pub const FLAC__STREAM_DECODER_WRITE_STATUS_ABORT: FLAC__StreamDecoderWriteStatus = 1;
pub type FLAC__StreamDecoderWriteStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderWriteStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_DECODER_ERROR_STATUS_LOST_SYNC: FLAC__StreamDecoderErrorStatus = 0;
pub const FLAC__STREAM_DECODER_ERROR_STATUS_BAD_HEADER: FLAC__StreamDecoderErrorStatus = 1;
pub const FLAC__STREAM_DECODER_ERROR_STATUS_FRAME_CRC_MISMATCH: FLAC__StreamDecoderErrorStatus = 2;
pub const FLAC__STREAM_DECODER_ERROR_STATUS_UNPARSEABLE_STREAM: FLAC__StreamDecoderErrorStatus = 3;
pub type FLAC__StreamDecoderErrorStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamDecoderErrorStatusString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamDecoderProtected {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamDecoderPrivate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamDecoder {
    pub protected_: *mut FLAC__StreamDecoderProtected,
    pub private_: *mut FLAC__StreamDecoderPrivate,
}
#[test]
fn bindgen_test_layout_FLAC__StreamDecoder() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamDecoder>(),
        16usize,
        concat!("Size of: ", stringify!(FLAC__StreamDecoder))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamDecoder>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamDecoder))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamDecoder>())).protected_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamDecoder),
            "::",
            stringify!(protected_)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamDecoder>())).private_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamDecoder),
            "::",
            stringify!(private_)
        )
    );
}
pub type FLAC__StreamDecoderReadCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        buffer: *mut FLAC__byte,
        bytes: *mut usize,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderReadStatus,
>;
pub type FLAC__StreamDecoderSeekCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        absolute_byte_offset: FLAC__uint64,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderSeekStatus,
>;
pub type FLAC__StreamDecoderTellCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        absolute_byte_offset: *mut FLAC__uint64,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderTellStatus,
>;
pub type FLAC__StreamDecoderLengthCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        stream_length: *mut FLAC__uint64,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderLengthStatus,
>;
pub type FLAC__StreamDecoderEofCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        client_data: *mut libc::c_void,
    ) -> FLAC__bool,
>;
pub type FLAC__StreamDecoderWriteCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        frame: *const FLAC__Frame,
        buffer: *const *const FLAC__int32,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderWriteStatus,
>;
pub type FLAC__StreamDecoderMetadataCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        metadata: *const FLAC__StreamMetadata,
        client_data: *mut libc::c_void,
    ),
>;
pub type FLAC__StreamDecoderErrorCallback = ::core::option::Option<
    unsafe extern "C" fn(
        decoder: *const FLAC__StreamDecoder,
        status: FLAC__StreamDecoderErrorStatus,
        client_data: *mut libc::c_void,
    ),
>;
extern "C" {
    pub fn FLAC__stream_decoder_new() -> *mut FLAC__StreamDecoder;
}
extern "C" {
    pub fn FLAC__stream_decoder_delete(decoder: *mut FLAC__StreamDecoder);
}
extern "C" {
    pub fn FLAC__stream_decoder_set_ogg_serial_number(
        decoder: *mut FLAC__StreamDecoder,
        serial_number: libc::c_long,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_md5_checking(
        decoder: *mut FLAC__StreamDecoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_respond(
        decoder: *mut FLAC__StreamDecoder,
        type_: FLAC__MetadataType,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_respond_application(
        decoder: *mut FLAC__StreamDecoder,
        id: *const FLAC__byte,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_respond_all(
        decoder: *mut FLAC__StreamDecoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_ignore(
        decoder: *mut FLAC__StreamDecoder,
        type_: FLAC__MetadataType,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_ignore_application(
        decoder: *mut FLAC__StreamDecoder,
        id: *const FLAC__byte,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_set_metadata_ignore_all(
        decoder: *mut FLAC__StreamDecoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_state(
        decoder: *const FLAC__StreamDecoder,
    ) -> FLAC__StreamDecoderState;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_resolved_state_string(
        decoder: *const FLAC__StreamDecoder,
    ) -> *const libc::c_char;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_md5_checking(decoder: *const FLAC__StreamDecoder)
        -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_total_samples(
        decoder: *const FLAC__StreamDecoder,
    ) -> FLAC__uint64;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_channels(decoder: *const FLAC__StreamDecoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_channel_assignment(
        decoder: *const FLAC__StreamDecoder,
    ) -> FLAC__ChannelAssignment;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_bits_per_sample(decoder: *const FLAC__StreamDecoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_sample_rate(decoder: *const FLAC__StreamDecoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_blocksize(decoder: *const FLAC__StreamDecoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_decoder_get_decode_position(
        decoder: *const FLAC__StreamDecoder,
        position: *mut FLAC__uint64,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_stream(
        decoder: *mut FLAC__StreamDecoder,
        read_callback: FLAC__StreamDecoderReadCallback,
        seek_callback: FLAC__StreamDecoderSeekCallback,
        tell_callback: FLAC__StreamDecoderTellCallback,
        length_callback: FLAC__StreamDecoderLengthCallback,
        eof_callback: FLAC__StreamDecoderEofCallback,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_ogg_stream(
        decoder: *mut FLAC__StreamDecoder,
        read_callback: FLAC__StreamDecoderReadCallback,
        seek_callback: FLAC__StreamDecoderSeekCallback,
        tell_callback: FLAC__StreamDecoderTellCallback,
        length_callback: FLAC__StreamDecoderLengthCallback,
        eof_callback: FLAC__StreamDecoderEofCallback,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_FILE(
        decoder: *mut FLAC__StreamDecoder,
        file: *mut FILE,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_ogg_FILE(
        decoder: *mut FLAC__StreamDecoder,
        file: *mut FILE,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_file(
        decoder: *mut FLAC__StreamDecoder,
        filename: *const libc::c_char,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_init_ogg_file(
        decoder: *mut FLAC__StreamDecoder,
        filename: *const libc::c_char,
        write_callback: FLAC__StreamDecoderWriteCallback,
        metadata_callback: FLAC__StreamDecoderMetadataCallback,
        error_callback: FLAC__StreamDecoderErrorCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamDecoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_decoder_finish(decoder: *mut FLAC__StreamDecoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_flush(decoder: *mut FLAC__StreamDecoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_reset(decoder: *mut FLAC__StreamDecoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_process_single(decoder: *mut FLAC__StreamDecoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_process_until_end_of_metadata(
        decoder: *mut FLAC__StreamDecoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_process_until_end_of_stream(
        decoder: *mut FLAC__StreamDecoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_skip_single_frame(decoder: *mut FLAC__StreamDecoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_decoder_seek_absolute(
        decoder: *mut FLAC__StreamDecoder,
        sample: FLAC__uint64,
    ) -> FLAC__bool;
}
pub const FLAC__STREAM_ENCODER_OK: FLAC__StreamEncoderState = 0;
pub const FLAC__STREAM_ENCODER_UNINITIALIZED: FLAC__StreamEncoderState = 1;
pub const FLAC__STREAM_ENCODER_OGG_ERROR: FLAC__StreamEncoderState = 2;
pub const FLAC__STREAM_ENCODER_VERIFY_DECODER_ERROR: FLAC__StreamEncoderState = 3;
pub const FLAC__STREAM_ENCODER_VERIFY_MISMATCH_IN_AUDIO_DATA: FLAC__StreamEncoderState = 4;
pub const FLAC__STREAM_ENCODER_CLIENT_ERROR: FLAC__StreamEncoderState = 5;
pub const FLAC__STREAM_ENCODER_IO_ERROR: FLAC__StreamEncoderState = 6;
pub const FLAC__STREAM_ENCODER_FRAMING_ERROR: FLAC__StreamEncoderState = 7;
pub const FLAC__STREAM_ENCODER_MEMORY_ALLOCATION_ERROR: FLAC__StreamEncoderState = 8;
pub type FLAC__StreamEncoderState = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderStateString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_ENCODER_INIT_STATUS_OK: FLAC__StreamEncoderInitStatus = 0;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_ENCODER_ERROR: FLAC__StreamEncoderInitStatus = 1;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_UNSUPPORTED_CONTAINER: FLAC__StreamEncoderInitStatus = 2;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_CALLBACKS: FLAC__StreamEncoderInitStatus = 3;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_NUMBER_OF_CHANNELS:
    FLAC__StreamEncoderInitStatus = 4;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_BITS_PER_SAMPLE: FLAC__StreamEncoderInitStatus =
    5;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_SAMPLE_RATE: FLAC__StreamEncoderInitStatus = 6;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_BLOCK_SIZE: FLAC__StreamEncoderInitStatus = 7;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_MAX_LPC_ORDER: FLAC__StreamEncoderInitStatus = 8;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_QLP_COEFF_PRECISION:
    FLAC__StreamEncoderInitStatus = 9;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_BLOCK_SIZE_TOO_SMALL_FOR_LPC_ORDER:
    FLAC__StreamEncoderInitStatus = 10;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_NOT_STREAMABLE: FLAC__StreamEncoderInitStatus = 11;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_INVALID_METADATA: FLAC__StreamEncoderInitStatus = 12;
pub const FLAC__STREAM_ENCODER_INIT_STATUS_ALREADY_INITIALIZED: FLAC__StreamEncoderInitStatus = 13;
pub type FLAC__StreamEncoderInitStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderInitStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_ENCODER_READ_STATUS_CONTINUE: FLAC__StreamEncoderReadStatus = 0;
pub const FLAC__STREAM_ENCODER_READ_STATUS_END_OF_STREAM: FLAC__StreamEncoderReadStatus = 1;
pub const FLAC__STREAM_ENCODER_READ_STATUS_ABORT: FLAC__StreamEncoderReadStatus = 2;
pub const FLAC__STREAM_ENCODER_READ_STATUS_UNSUPPORTED: FLAC__StreamEncoderReadStatus = 3;
pub type FLAC__StreamEncoderReadStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderReadStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_ENCODER_WRITE_STATUS_OK: FLAC__StreamEncoderWriteStatus = 0;
pub const FLAC__STREAM_ENCODER_WRITE_STATUS_FATAL_ERROR: FLAC__StreamEncoderWriteStatus = 1;
pub type FLAC__StreamEncoderWriteStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderWriteStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_ENCODER_SEEK_STATUS_OK: FLAC__StreamEncoderSeekStatus = 0;
pub const FLAC__STREAM_ENCODER_SEEK_STATUS_ERROR: FLAC__StreamEncoderSeekStatus = 1;
pub const FLAC__STREAM_ENCODER_SEEK_STATUS_UNSUPPORTED: FLAC__StreamEncoderSeekStatus = 2;
pub type FLAC__StreamEncoderSeekStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderSeekStatusString: [*const libc::c_char; 0usize];
}
pub const FLAC__STREAM_ENCODER_TELL_STATUS_OK: FLAC__StreamEncoderTellStatus = 0;
pub const FLAC__STREAM_ENCODER_TELL_STATUS_ERROR: FLAC__StreamEncoderTellStatus = 1;
pub const FLAC__STREAM_ENCODER_TELL_STATUS_UNSUPPORTED: FLAC__StreamEncoderTellStatus = 2;
pub type FLAC__StreamEncoderTellStatus = libc::c_uint;
extern "C" {
    pub static mut FLAC__StreamEncoderTellStatusString: [*const libc::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamEncoderProtected {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamEncoderPrivate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FLAC__StreamEncoder {
    pub protected_: *mut FLAC__StreamEncoderProtected,
    pub private_: *mut FLAC__StreamEncoderPrivate,
}
#[test]
fn bindgen_test_layout_FLAC__StreamEncoder() {
    assert_eq!(
        ::core::mem::size_of::<FLAC__StreamEncoder>(),
        16usize,
        concat!("Size of: ", stringify!(FLAC__StreamEncoder))
    );
    assert_eq!(
        ::core::mem::align_of::<FLAC__StreamEncoder>(),
        8usize,
        concat!("Alignment of ", stringify!(FLAC__StreamEncoder))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamEncoder>())).protected_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamEncoder),
            "::",
            stringify!(protected_)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<FLAC__StreamEncoder>())).private_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FLAC__StreamEncoder),
            "::",
            stringify!(private_)
        )
    );
}
pub type FLAC__StreamEncoderReadCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        buffer: *mut FLAC__byte,
        bytes: *mut usize,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderReadStatus,
>;
pub type FLAC__StreamEncoderWriteCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        buffer: *const FLAC__byte,
        bytes: usize,
        samples: u32,
        current_frame: u32,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderWriteStatus,
>;
pub type FLAC__StreamEncoderSeekCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        absolute_byte_offset: FLAC__uint64,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderSeekStatus,
>;
pub type FLAC__StreamEncoderTellCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        absolute_byte_offset: *mut FLAC__uint64,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderTellStatus,
>;
pub type FLAC__StreamEncoderMetadataCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        metadata: *const FLAC__StreamMetadata,
        client_data: *mut libc::c_void,
    ),
>;
pub type FLAC__StreamEncoderProgressCallback = ::core::option::Option<
    unsafe extern "C" fn(
        encoder: *const FLAC__StreamEncoder,
        bytes_written: FLAC__uint64,
        samples_written: FLAC__uint64,
        frames_written: u32,
        total_frames_estimate: u32,
        client_data: *mut libc::c_void,
    ),
>;
extern "C" {
    pub fn FLAC__stream_encoder_new() -> *mut FLAC__StreamEncoder;
}
extern "C" {
    pub fn FLAC__stream_encoder_delete(encoder: *mut FLAC__StreamEncoder);
}
extern "C" {
    pub fn FLAC__stream_encoder_set_ogg_serial_number(
        encoder: *mut FLAC__StreamEncoder,
        serial_number: libc::c_long,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_verify(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_streamable_subset(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_channels(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_bits_per_sample(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_sample_rate(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_compression_level(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_blocksize(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_do_mid_side_stereo(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_loose_mid_side_stereo(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_apodization(
        encoder: *mut FLAC__StreamEncoder,
        specification: *const libc::c_char,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_max_lpc_order(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_qlp_coeff_precision(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_do_qlp_coeff_prec_search(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_do_escape_coding(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_do_exhaustive_model_search(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__bool,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_min_residual_partition_order(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_max_residual_partition_order(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_rice_parameter_search_dist(
        encoder: *mut FLAC__StreamEncoder,
        value: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_total_samples_estimate(
        encoder: *mut FLAC__StreamEncoder,
        value: FLAC__uint64,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_set_metadata(
        encoder: *mut FLAC__StreamEncoder,
        metadata: *mut *mut FLAC__StreamMetadata,
        num_blocks: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_state(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__StreamEncoderState;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_verify_decoder_state(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__StreamDecoderState;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_resolved_state_string(
        encoder: *const FLAC__StreamEncoder,
    ) -> *const libc::c_char;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_verify_decoder_error_stats(
        encoder: *const FLAC__StreamEncoder,
        absolute_sample: *mut FLAC__uint64,
        frame_number: *mut u32,
        channel: *mut u32,
        sample: *mut u32,
        expected: *mut FLAC__int32,
        got: *mut FLAC__int32,
    );
}
extern "C" {
    pub fn FLAC__stream_encoder_get_verify(encoder: *const FLAC__StreamEncoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_streamable_subset(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_channels(encoder: *const FLAC__StreamEncoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_bits_per_sample(encoder: *const FLAC__StreamEncoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_sample_rate(encoder: *const FLAC__StreamEncoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_blocksize(encoder: *const FLAC__StreamEncoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_do_mid_side_stereo(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_loose_mid_side_stereo(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_max_lpc_order(encoder: *const FLAC__StreamEncoder) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_qlp_coeff_precision(encoder: *const FLAC__StreamEncoder)
        -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_do_qlp_coeff_prec_search(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_do_escape_coding(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_do_exhaustive_model_search(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_min_residual_partition_order(
        encoder: *const FLAC__StreamEncoder,
    ) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_max_residual_partition_order(
        encoder: *const FLAC__StreamEncoder,
    ) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_rice_parameter_search_dist(
        encoder: *const FLAC__StreamEncoder,
    ) -> u32;
}
extern "C" {
    pub fn FLAC__stream_encoder_get_total_samples_estimate(
        encoder: *const FLAC__StreamEncoder,
    ) -> FLAC__uint64;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_stream(
        encoder: *mut FLAC__StreamEncoder,
        write_callback: FLAC__StreamEncoderWriteCallback,
        seek_callback: FLAC__StreamEncoderSeekCallback,
        tell_callback: FLAC__StreamEncoderTellCallback,
        metadata_callback: FLAC__StreamEncoderMetadataCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_ogg_stream(
        encoder: *mut FLAC__StreamEncoder,
        read_callback: FLAC__StreamEncoderReadCallback,
        write_callback: FLAC__StreamEncoderWriteCallback,
        seek_callback: FLAC__StreamEncoderSeekCallback,
        tell_callback: FLAC__StreamEncoderTellCallback,
        metadata_callback: FLAC__StreamEncoderMetadataCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_FILE(
        encoder: *mut FLAC__StreamEncoder,
        file: *mut FILE,
        progress_callback: FLAC__StreamEncoderProgressCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_ogg_FILE(
        encoder: *mut FLAC__StreamEncoder,
        file: *mut FILE,
        progress_callback: FLAC__StreamEncoderProgressCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_file(
        encoder: *mut FLAC__StreamEncoder,
        filename: *const libc::c_char,
        progress_callback: FLAC__StreamEncoderProgressCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_init_ogg_file(
        encoder: *mut FLAC__StreamEncoder,
        filename: *const libc::c_char,
        progress_callback: FLAC__StreamEncoderProgressCallback,
        client_data: *mut libc::c_void,
    ) -> FLAC__StreamEncoderInitStatus;
}
extern "C" {
    pub fn FLAC__stream_encoder_finish(encoder: *mut FLAC__StreamEncoder) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_process(
        encoder: *mut FLAC__StreamEncoder,
        buffer: *const *const FLAC__int32,
        samples: u32,
    ) -> FLAC__bool;
}
extern "C" {
    pub fn FLAC__stream_encoder_process_interleaved(
        encoder: *mut FLAC__StreamEncoder,
        buffer: *const FLAC__int32,
        samples: u32,
    ) -> FLAC__bool;
}
