//! Macro implementation for using #[derive(Parsable)]
extern crate proc_macro;

use proc_macro::{TokenStream};
use syn::{DeriveInput, Data};
use quote::quote;

/// Macro generator
#[proc_macro_derive(Parsable)]
pub fn derive_parsable(struc: TokenStream) -> TokenStream {
    let ast: &DeriveInput = &syn::parse(struc).unwrap();
    let name = &ast.ident;
    if let Data::Struct(data_struct) = &ast.data {
        let mut fields_gen = vec![];
        for field in &data_struct.fields {
            let field_ident = &field.ident.clone().expect("Expected named field");
            let field_type = &field.ty;
            fields_gen.push(
                quote! {
                    #field_ident: <#field_type>::parse(data)?
                }
            );
        }
        let final_gen = quote! {
            impl Parsable for #name {
                fn parse(data: &mut dyn std::io::Read) -> Result<Self, ()> {
                    Ok(Self{
                        #(#fields_gen),*
                    })
                }
            }
        };
        return final_gen.into();
    } else {
        panic!("Expected Parsable auto-trait to be applied to struct");
    }
}
