/*
 * Copyright (c) 2021-2021 Thomas Kramer.
 *
 * This file is part of LibrEDA
 * (see https://codeberg.org/libreda/liberty-io).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

//! Parse boolean expressions as used in the liberty format.

use crate::stream_lexer::*;

/// Boolean operation.
#[derive(Clone, Debug)]
pub enum BooleanExpr<Var> {
    False,
    True,
    Var(Var),
    Neg(Box<Self>),
    And(Box<Self>, Box<Self>),
    Or(Box<Self>, Box<Self>),
    Xor(Box<Self>, Box<Self>)
}

//
// use itertools::{Itertools, PeekingNext};
// use std::iter::Peekable;
// use std::str::FromStr;
// use std::fmt;
// use std::num::ParseIntError;
//
// /// Error while parsing Liberty.
// /// TODO: Separate lexer errors from Liberty specific errors.
// #[derive(Clone, Debug)]
// pub enum ParserError {
//     InvalidCharacter,
//     UnexpectedEndOfFile,
//     /// Expected and actual token.
//     UnexpectedToken(String, String),
//     UnknownToken(String),
//     InvalidLiteral(String),
//     NotImplemented(&'static str),
//     ParseIntError(ParseIntError),
//     Other(&'static str),
// }
//
// impl fmt::Display for ParserError {
//     fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
//         match self {
//             ParserError::InvalidCharacter => write!(f, "Invalid character."),
//             ParserError::UnexpectedEndOfFile => write!(f, "Unexpected end of file."),
//             ParserError::UnexpectedToken(actual, exp) =>
//                 write!(f, "Unexpected token. '{}' instead of '{}'", actual, exp),
//             ParserError::UnknownToken(t) => write!(f, "Unknown token: '{}'.", t),
//             ParserError::InvalidLiteral(n) => write!(f, "Invalid literal: '{}'.", n),
//             ParserError::NotImplemented(n) => write!(f, "Not implemented: '{}'.", n),
//             ParserError::Other(msg) => write!(f, "'{}'.", msg),
//             ParserError::ParseIntError(e) => write!(f, "Illegal integer: '{}'", e)
//         }
//     }
// }
//
// impl From<ParseIntError> for ParserError {
//     fn from(e: ParseIntError) -> Self {
//         Self::ParseIntError(e)
//     }
// }
//
// fn is_terminal_char(c: char) -> bool {
//     match c {
//         '(' | ')' | '!' | '~' | '+' | '&' | '|' | '*' | '^' => true,
//         _ => false
//     }
// }
//
// /// Read a token into the buffer. Tokens are separated by white space. Comments are ignored.
// /// Quoted tokens can contain white space.
// fn read_token<'a, I>(iter: &mut I, buffer: &'a mut String) -> Option<&'a str>
//     where I: Iterator<Item=char> + PeekingNext {
//     buffer.clear();
//
//     let iter = iter.by_ref();
//
//     loop {
//         // Skip whitespace but not newlines.
//         let _n = iter.peeking_take_while(|c| c.is_whitespace() && *c != '\n').count();
//
//         // Look ahead.
//         if let Some(c) = iter.peeking_next(|_| true) {
//             debug_assert!(!c.is_whitespace() || c == '\n');
//
//             match c {
//                 '#' => {
//                     // Skip comments.
//                     iter.peeking_take_while(|&c| c != '\n' && c != '\r').count();
//                 }
//                 '/' => {
//                     if let Some(_) = iter.peeking_next(|&c| c == '*') {
//                         // Skip comment.
//
//                         loop {
//                             // Consume until next '*'.
//                             iter.peeking_take_while(|&c| c != '*').count();
//                             if iter.next() != Some('*') {
//                                 break; // End of file.
//                             }
//
//                             if let Some(_) = iter.peeking_next(|&c| c == '/') {
//                                 // End of comment.
//                                 break;
//                             }
//                         }
//                     } else if let Some(_) = iter.peeking_next(|&c| c == '/') {
//                         // Skip comment.
//
//                         // Consume until next '\n'.
//                         iter.peeking_take_while(|&c| c != '\n').count();
//                     } else {
//                         buffer.push(c);
//                     }
//                 }
//                 '\\' => {
//                     if let Some(_) = iter.peeking_next(|&c| c == '\\') {
//                         // Ignore masked newlines.
//                         buffer.push('\\');
//                     } else if let Some(_) = iter.peeking_next(|&c| c == '\n') {
//                         // Ignore masked newlines.
//                         iter.next();
//                     } else if let Some(_) = iter.peeking_next(|&c| c == '\r') {
//                         // Ignore masked newlines.
//                         iter.next();
//                         if let Some(_) = iter.peeking_next(|&c| c == '\n') {
//                             iter.next();
//                         }
//                     } else {
//                         buffer.push('\\');
//                     }
//                 }
//                 '\n' => {
//                     // Newline.
//                     debug_assert!(buffer.is_empty());
//                     buffer.push(c);
//
//                     // Consume all other newlines.
//                     iter.peeking_take_while(|&c| c.is_whitespace()).count();
//
//                     return Some(buffer.as_str());
//                 }
//                 _ => {
//                     // Normal token.
//                     let mut prev = Some(c);
//                     buffer.push(c);
//
//                     if is_terminal_char(c) {
//                         return Some(buffer.as_str());
//                     }
//
//                     while let Some(c) = iter.peeking_next(|&c| !is_terminal_char(c)) {
//                         if prev != Some('\\') && (c.is_whitespace() || is_terminal_char(c)) {
//                             // Abort on unmasked whitespace or terminal character.
//                             break;
//                         }
//
//                         buffer.push(c);
//                         prev = Some(c);
//                     }
//                     return Some(buffer.as_str());
//                 }
//             }
//         } else {
//             return None;
//         }
//     }
// }