// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 5264fd0c3183)
// DO NOT EDIT

use libdazzle_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["libdazzle-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "DzlAnimationClass",
        Layout {
            size: size_of::<DzlAnimationClass>(),
            alignment: align_of::<DzlAnimationClass>(),
        },
    ),
    (
        "DzlAnimationMode",
        Layout {
            size: size_of::<DzlAnimationMode>(),
            alignment: align_of::<DzlAnimationMode>(),
        },
    ),
    (
        "DzlApplication",
        Layout {
            size: size_of::<DzlApplication>(),
            alignment: align_of::<DzlApplication>(),
        },
    ),
    (
        "DzlApplicationClass",
        Layout {
            size: size_of::<DzlApplicationClass>(),
            alignment: align_of::<DzlApplicationClass>(),
        },
    ),
    (
        "DzlApplicationWindow",
        Layout {
            size: size_of::<DzlApplicationWindow>(),
            alignment: align_of::<DzlApplicationWindow>(),
        },
    ),
    (
        "DzlApplicationWindowClass",
        Layout {
            size: size_of::<DzlApplicationWindowClass>(),
            alignment: align_of::<DzlApplicationWindowClass>(),
        },
    ),
    (
        "DzlBin",
        Layout {
            size: size_of::<DzlBin>(),
            alignment: align_of::<DzlBin>(),
        },
    ),
    (
        "DzlBinClass",
        Layout {
            size: size_of::<DzlBinClass>(),
            alignment: align_of::<DzlBinClass>(),
        },
    ),
    (
        "DzlBindingGroupClass",
        Layout {
            size: size_of::<DzlBindingGroupClass>(),
            alignment: align_of::<DzlBindingGroupClass>(),
        },
    ),
    (
        "DzlBoldingLabelClass",
        Layout {
            size: size_of::<DzlBoldingLabelClass>(),
            alignment: align_of::<DzlBoldingLabelClass>(),
        },
    ),
    (
        "DzlBox",
        Layout {
            size: size_of::<DzlBox>(),
            alignment: align_of::<DzlBox>(),
        },
    ),
    (
        "DzlBoxClass",
        Layout {
            size: size_of::<DzlBoxClass>(),
            alignment: align_of::<DzlBoxClass>(),
        },
    ),
    (
        "DzlBoxTheatricClass",
        Layout {
            size: size_of::<DzlBoxTheatricClass>(),
            alignment: align_of::<DzlBoxTheatricClass>(),
        },
    ),
    (
        "DzlCenteringBin",
        Layout {
            size: size_of::<DzlCenteringBin>(),
            alignment: align_of::<DzlCenteringBin>(),
        },
    ),
    (
        "DzlCenteringBinClass",
        Layout {
            size: size_of::<DzlCenteringBinClass>(),
            alignment: align_of::<DzlCenteringBinClass>(),
        },
    ),
    (
        "DzlChildPropertyActionClass",
        Layout {
            size: size_of::<DzlChildPropertyActionClass>(),
            alignment: align_of::<DzlChildPropertyActionClass>(),
        },
    ),
    (
        "DzlColumnLayout",
        Layout {
            size: size_of::<DzlColumnLayout>(),
            alignment: align_of::<DzlColumnLayout>(),
        },
    ),
    (
        "DzlColumnLayoutClass",
        Layout {
            size: size_of::<DzlColumnLayoutClass>(),
            alignment: align_of::<DzlColumnLayoutClass>(),
        },
    ),
    (
        "DzlCounter",
        Layout {
            size: size_of::<DzlCounter>(),
            alignment: align_of::<DzlCounter>(),
        },
    ),
    (
        "DzlCounterValue",
        Layout {
            size: size_of::<DzlCounterValue>(),
            alignment: align_of::<DzlCounterValue>(),
        },
    ),
    (
        "DzlCountersWindow",
        Layout {
            size: size_of::<DzlCountersWindow>(),
            alignment: align_of::<DzlCountersWindow>(),
        },
    ),
    (
        "DzlCountersWindowClass",
        Layout {
            size: size_of::<DzlCountersWindowClass>(),
            alignment: align_of::<DzlCountersWindowClass>(),
        },
    ),
    (
        "DzlCpuGraphClass",
        Layout {
            size: size_of::<DzlCpuGraphClass>(),
            alignment: align_of::<DzlCpuGraphClass>(),
        },
    ),
    (
        "DzlCpuModelClass",
        Layout {
            size: size_of::<DzlCpuModelClass>(),
            alignment: align_of::<DzlCpuModelClass>(),
        },
    ),
    (
        "DzlCssProviderClass",
        Layout {
            size: size_of::<DzlCssProviderClass>(),
            alignment: align_of::<DzlCssProviderClass>(),
        },
    ),
    (
        "DzlDirectoryModelClass",
        Layout {
            size: size_of::<DzlDirectoryModelClass>(),
            alignment: align_of::<DzlDirectoryModelClass>(),
        },
    ),
    (
        "DzlDirectoryReaperClass",
        Layout {
            size: size_of::<DzlDirectoryReaperClass>(),
            alignment: align_of::<DzlDirectoryReaperClass>(),
        },
    ),
    (
        "DzlDockBin",
        Layout {
            size: size_of::<DzlDockBin>(),
            alignment: align_of::<DzlDockBin>(),
        },
    ),
    (
        "DzlDockBinClass",
        Layout {
            size: size_of::<DzlDockBinClass>(),
            alignment: align_of::<DzlDockBinClass>(),
        },
    ),
    (
        "DzlDockBinEdge",
        Layout {
            size: size_of::<DzlDockBinEdge>(),
            alignment: align_of::<DzlDockBinEdge>(),
        },
    ),
    (
        "DzlDockBinEdgeClass",
        Layout {
            size: size_of::<DzlDockBinEdgeClass>(),
            alignment: align_of::<DzlDockBinEdgeClass>(),
        },
    ),
    (
        "DzlDockInterface",
        Layout {
            size: size_of::<DzlDockInterface>(),
            alignment: align_of::<DzlDockInterface>(),
        },
    ),
    (
        "DzlDockItemInterface",
        Layout {
            size: size_of::<DzlDockItemInterface>(),
            alignment: align_of::<DzlDockItemInterface>(),
        },
    ),
    (
        "DzlDockManager",
        Layout {
            size: size_of::<DzlDockManager>(),
            alignment: align_of::<DzlDockManager>(),
        },
    ),
    (
        "DzlDockManagerClass",
        Layout {
            size: size_of::<DzlDockManagerClass>(),
            alignment: align_of::<DzlDockManagerClass>(),
        },
    ),
    (
        "DzlDockOverlay",
        Layout {
            size: size_of::<DzlDockOverlay>(),
            alignment: align_of::<DzlDockOverlay>(),
        },
    ),
    (
        "DzlDockOverlayClass",
        Layout {
            size: size_of::<DzlDockOverlayClass>(),
            alignment: align_of::<DzlDockOverlayClass>(),
        },
    ),
    (
        "DzlDockOverlayEdgeClass",
        Layout {
            size: size_of::<DzlDockOverlayEdgeClass>(),
            alignment: align_of::<DzlDockOverlayEdgeClass>(),
        },
    ),
    (
        "DzlDockPaned",
        Layout {
            size: size_of::<DzlDockPaned>(),
            alignment: align_of::<DzlDockPaned>(),
        },
    ),
    (
        "DzlDockPanedClass",
        Layout {
            size: size_of::<DzlDockPanedClass>(),
            alignment: align_of::<DzlDockPanedClass>(),
        },
    ),
    (
        "DzlDockRevealer",
        Layout {
            size: size_of::<DzlDockRevealer>(),
            alignment: align_of::<DzlDockRevealer>(),
        },
    ),
    (
        "DzlDockRevealerClass",
        Layout {
            size: size_of::<DzlDockRevealerClass>(),
            alignment: align_of::<DzlDockRevealerClass>(),
        },
    ),
    (
        "DzlDockRevealerTransitionType",
        Layout {
            size: size_of::<DzlDockRevealerTransitionType>(),
            alignment: align_of::<DzlDockRevealerTransitionType>(),
        },
    ),
    (
        "DzlDockStack",
        Layout {
            size: size_of::<DzlDockStack>(),
            alignment: align_of::<DzlDockStack>(),
        },
    ),
    (
        "DzlDockStackClass",
        Layout {
            size: size_of::<DzlDockStackClass>(),
            alignment: align_of::<DzlDockStackClass>(),
        },
    ),
    (
        "DzlDockTransientGrabClass",
        Layout {
            size: size_of::<DzlDockTransientGrabClass>(),
            alignment: align_of::<DzlDockTransientGrabClass>(),
        },
    ),
    (
        "DzlDockWidget",
        Layout {
            size: size_of::<DzlDockWidget>(),
            alignment: align_of::<DzlDockWidget>(),
        },
    ),
    (
        "DzlDockWidgetClass",
        Layout {
            size: size_of::<DzlDockWidgetClass>(),
            alignment: align_of::<DzlDockWidgetClass>(),
        },
    ),
    (
        "DzlDockWindow",
        Layout {
            size: size_of::<DzlDockWindow>(),
            alignment: align_of::<DzlDockWindow>(),
        },
    ),
    (
        "DzlDockWindowClass",
        Layout {
            size: size_of::<DzlDockWindowClass>(),
            alignment: align_of::<DzlDockWindowClass>(),
        },
    ),
    (
        "DzlElasticBin",
        Layout {
            size: size_of::<DzlElasticBin>(),
            alignment: align_of::<DzlElasticBin>(),
        },
    ),
    (
        "DzlElasticBinClass",
        Layout {
            size: size_of::<DzlElasticBinClass>(),
            alignment: align_of::<DzlElasticBinClass>(),
        },
    ),
    (
        "DzlEmptyState",
        Layout {
            size: size_of::<DzlEmptyState>(),
            alignment: align_of::<DzlEmptyState>(),
        },
    ),
    (
        "DzlEmptyStateClass",
        Layout {
            size: size_of::<DzlEmptyStateClass>(),
            alignment: align_of::<DzlEmptyStateClass>(),
        },
    ),
    (
        "DzlEntryBoxClass",
        Layout {
            size: size_of::<DzlEntryBoxClass>(),
            alignment: align_of::<DzlEntryBoxClass>(),
        },
    ),
    (
        "DzlFileChooserEntry",
        Layout {
            size: size_of::<DzlFileChooserEntry>(),
            alignment: align_of::<DzlFileChooserEntry>(),
        },
    ),
    (
        "DzlFileChooserEntryClass",
        Layout {
            size: size_of::<DzlFileChooserEntryClass>(),
            alignment: align_of::<DzlFileChooserEntryClass>(),
        },
    ),
    (
        "DzlFileTransfer",
        Layout {
            size: size_of::<DzlFileTransfer>(),
            alignment: align_of::<DzlFileTransfer>(),
        },
    ),
    (
        "DzlFileTransferClass",
        Layout {
            size: size_of::<DzlFileTransferClass>(),
            alignment: align_of::<DzlFileTransferClass>(),
        },
    ),
    (
        "DzlFileTransferFlags",
        Layout {
            size: size_of::<DzlFileTransferFlags>(),
            alignment: align_of::<DzlFileTransferFlags>(),
        },
    ),
    (
        "DzlFileTransferStat",
        Layout {
            size: size_of::<DzlFileTransferStat>(),
            alignment: align_of::<DzlFileTransferStat>(),
        },
    ),
    (
        "DzlFuzzyIndexBuilderClass",
        Layout {
            size: size_of::<DzlFuzzyIndexBuilderClass>(),
            alignment: align_of::<DzlFuzzyIndexBuilderClass>(),
        },
    ),
    (
        "DzlFuzzyIndexClass",
        Layout {
            size: size_of::<DzlFuzzyIndexClass>(),
            alignment: align_of::<DzlFuzzyIndexClass>(),
        },
    ),
    (
        "DzlFuzzyIndexCursorClass",
        Layout {
            size: size_of::<DzlFuzzyIndexCursorClass>(),
            alignment: align_of::<DzlFuzzyIndexCursorClass>(),
        },
    ),
    (
        "DzlFuzzyIndexMatchClass",
        Layout {
            size: size_of::<DzlFuzzyIndexMatchClass>(),
            alignment: align_of::<DzlFuzzyIndexMatchClass>(),
        },
    ),
    (
        "DzlFuzzyMutableIndexMatch",
        Layout {
            size: size_of::<DzlFuzzyMutableIndexMatch>(),
            alignment: align_of::<DzlFuzzyMutableIndexMatch>(),
        },
    ),
    (
        "DzlGraphColumnClass",
        Layout {
            size: size_of::<DzlGraphColumnClass>(),
            alignment: align_of::<DzlGraphColumnClass>(),
        },
    ),
    (
        "DzlGraphLineRendererClass",
        Layout {
            size: size_of::<DzlGraphLineRendererClass>(),
            alignment: align_of::<DzlGraphLineRendererClass>(),
        },
    ),
    (
        "DzlGraphModel",
        Layout {
            size: size_of::<DzlGraphModel>(),
            alignment: align_of::<DzlGraphModel>(),
        },
    ),
    (
        "DzlGraphModelClass",
        Layout {
            size: size_of::<DzlGraphModelClass>(),
            alignment: align_of::<DzlGraphModelClass>(),
        },
    ),
    (
        "DzlGraphModelIter",
        Layout {
            size: size_of::<DzlGraphModelIter>(),
            alignment: align_of::<DzlGraphModelIter>(),
        },
    ),
    (
        "DzlGraphRendererInterface",
        Layout {
            size: size_of::<DzlGraphRendererInterface>(),
            alignment: align_of::<DzlGraphRendererInterface>(),
        },
    ),
    (
        "DzlGraphView",
        Layout {
            size: size_of::<DzlGraphView>(),
            alignment: align_of::<DzlGraphView>(),
        },
    ),
    (
        "DzlGraphViewClass",
        Layout {
            size: size_of::<DzlGraphViewClass>(),
            alignment: align_of::<DzlGraphViewClass>(),
        },
    ),
    (
        "DzlHeap",
        Layout {
            size: size_of::<DzlHeap>(),
            alignment: align_of::<DzlHeap>(),
        },
    ),
    (
        "DzlJoinedMenuClass",
        Layout {
            size: size_of::<DzlJoinedMenuClass>(),
            alignment: align_of::<DzlJoinedMenuClass>(),
        },
    ),
    (
        "DzlListBox",
        Layout {
            size: size_of::<DzlListBox>(),
            alignment: align_of::<DzlListBox>(),
        },
    ),
    (
        "DzlListBoxClass",
        Layout {
            size: size_of::<DzlListBoxClass>(),
            alignment: align_of::<DzlListBoxClass>(),
        },
    ),
    (
        "DzlListBoxRow",
        Layout {
            size: size_of::<DzlListBoxRow>(),
            alignment: align_of::<DzlListBoxRow>(),
        },
    ),
    (
        "DzlListBoxRowClass",
        Layout {
            size: size_of::<DzlListBoxRowClass>(),
            alignment: align_of::<DzlListBoxRowClass>(),
        },
    ),
    (
        "DzlListModelFilterClass",
        Layout {
            size: size_of::<DzlListModelFilterClass>(),
            alignment: align_of::<DzlListModelFilterClass>(),
        },
    ),
    (
        "DzlListStoreAdapter",
        Layout {
            size: size_of::<DzlListStoreAdapter>(),
            alignment: align_of::<DzlListStoreAdapter>(),
        },
    ),
    (
        "DzlListStoreAdapterClass",
        Layout {
            size: size_of::<DzlListStoreAdapterClass>(),
            alignment: align_of::<DzlListStoreAdapterClass>(),
        },
    ),
    (
        "DzlMenuButton",
        Layout {
            size: size_of::<DzlMenuButton>(),
            alignment: align_of::<DzlMenuButton>(),
        },
    ),
    (
        "DzlMenuButtonClass",
        Layout {
            size: size_of::<DzlMenuButtonClass>(),
            alignment: align_of::<DzlMenuButtonClass>(),
        },
    ),
    (
        "DzlMenuManagerClass",
        Layout {
            size: size_of::<DzlMenuManagerClass>(),
            alignment: align_of::<DzlMenuManagerClass>(),
        },
    ),
    (
        "DzlMultiPaned",
        Layout {
            size: size_of::<DzlMultiPaned>(),
            alignment: align_of::<DzlMultiPaned>(),
        },
    ),
    (
        "DzlMultiPanedClass",
        Layout {
            size: size_of::<DzlMultiPanedClass>(),
            alignment: align_of::<DzlMultiPanedClass>(),
        },
    ),
    (
        "DzlPathBarClass",
        Layout {
            size: size_of::<DzlPathBarClass>(),
            alignment: align_of::<DzlPathBarClass>(),
        },
    ),
    (
        "DzlPathClass",
        Layout {
            size: size_of::<DzlPathClass>(),
            alignment: align_of::<DzlPathClass>(),
        },
    ),
    (
        "DzlPathElementClass",
        Layout {
            size: size_of::<DzlPathElementClass>(),
            alignment: align_of::<DzlPathElementClass>(),
        },
    ),
    (
        "DzlPillBoxClass",
        Layout {
            size: size_of::<DzlPillBoxClass>(),
            alignment: align_of::<DzlPillBoxClass>(),
        },
    ),
    (
        "DzlPreferencesBin",
        Layout {
            size: size_of::<DzlPreferencesBin>(),
            alignment: align_of::<DzlPreferencesBin>(),
        },
    ),
    (
        "DzlPreferencesBinClass",
        Layout {
            size: size_of::<DzlPreferencesBinClass>(),
            alignment: align_of::<DzlPreferencesBinClass>(),
        },
    ),
    (
        "DzlPreferencesEntry",
        Layout {
            size: size_of::<DzlPreferencesEntry>(),
            alignment: align_of::<DzlPreferencesEntry>(),
        },
    ),
    (
        "DzlPreferencesEntryClass",
        Layout {
            size: size_of::<DzlPreferencesEntryClass>(),
            alignment: align_of::<DzlPreferencesEntryClass>(),
        },
    ),
    (
        "DzlPreferencesFileChooserButtonClass",
        Layout {
            size: size_of::<DzlPreferencesFileChooserButtonClass>(),
            alignment: align_of::<DzlPreferencesFileChooserButtonClass>(),
        },
    ),
    (
        "DzlPreferencesFlowBoxClass",
        Layout {
            size: size_of::<DzlPreferencesFlowBoxClass>(),
            alignment: align_of::<DzlPreferencesFlowBoxClass>(),
        },
    ),
    (
        "DzlPreferencesFontButtonClass",
        Layout {
            size: size_of::<DzlPreferencesFontButtonClass>(),
            alignment: align_of::<DzlPreferencesFontButtonClass>(),
        },
    ),
    (
        "DzlPreferencesGroupClass",
        Layout {
            size: size_of::<DzlPreferencesGroupClass>(),
            alignment: align_of::<DzlPreferencesGroupClass>(),
        },
    ),
    (
        "DzlPreferencesPageClass",
        Layout {
            size: size_of::<DzlPreferencesPageClass>(),
            alignment: align_of::<DzlPreferencesPageClass>(),
        },
    ),
    (
        "DzlPreferencesSpinButtonClass",
        Layout {
            size: size_of::<DzlPreferencesSpinButtonClass>(),
            alignment: align_of::<DzlPreferencesSpinButtonClass>(),
        },
    ),
    (
        "DzlPreferencesSwitchClass",
        Layout {
            size: size_of::<DzlPreferencesSwitchClass>(),
            alignment: align_of::<DzlPreferencesSwitchClass>(),
        },
    ),
    (
        "DzlPreferencesView",
        Layout {
            size: size_of::<DzlPreferencesView>(),
            alignment: align_of::<DzlPreferencesView>(),
        },
    ),
    (
        "DzlPreferencesViewClass",
        Layout {
            size: size_of::<DzlPreferencesViewClass>(),
            alignment: align_of::<DzlPreferencesViewClass>(),
        },
    ),
    (
        "DzlPriorityBox",
        Layout {
            size: size_of::<DzlPriorityBox>(),
            alignment: align_of::<DzlPriorityBox>(),
        },
    ),
    (
        "DzlPriorityBoxClass",
        Layout {
            size: size_of::<DzlPriorityBoxClass>(),
            alignment: align_of::<DzlPriorityBoxClass>(),
        },
    ),
    (
        "DzlProgressButton",
        Layout {
            size: size_of::<DzlProgressButton>(),
            alignment: align_of::<DzlProgressButton>(),
        },
    ),
    (
        "DzlProgressButtonClass",
        Layout {
            size: size_of::<DzlProgressButtonClass>(),
            alignment: align_of::<DzlProgressButtonClass>(),
        },
    ),
    (
        "DzlProgressIconClass",
        Layout {
            size: size_of::<DzlProgressIconClass>(),
            alignment: align_of::<DzlProgressIconClass>(),
        },
    ),
    (
        "DzlProgressMenuButton",
        Layout {
            size: size_of::<DzlProgressMenuButton>(),
            alignment: align_of::<DzlProgressMenuButton>(),
        },
    ),
    (
        "DzlProgressMenuButtonClass",
        Layout {
            size: size_of::<DzlProgressMenuButtonClass>(),
            alignment: align_of::<DzlProgressMenuButtonClass>(),
        },
    ),
    (
        "DzlPropertiesFlags",
        Layout {
            size: size_of::<DzlPropertiesFlags>(),
            alignment: align_of::<DzlPropertiesFlags>(),
        },
    ),
    (
        "DzlPropertiesGroupClass",
        Layout {
            size: size_of::<DzlPropertiesGroupClass>(),
            alignment: align_of::<DzlPropertiesGroupClass>(),
        },
    ),
    (
        "DzlRadioBox",
        Layout {
            size: size_of::<DzlRadioBox>(),
            alignment: align_of::<DzlRadioBox>(),
        },
    ),
    (
        "DzlRadioBoxClass",
        Layout {
            size: size_of::<DzlRadioBoxClass>(),
            alignment: align_of::<DzlRadioBoxClass>(),
        },
    ),
    (
        "DzlReadOnlyListModelClass",
        Layout {
            size: size_of::<DzlReadOnlyListModelClass>(),
            alignment: align_of::<DzlReadOnlyListModelClass>(),
        },
    ),
    (
        "DzlRecursiveFileMonitorClass",
        Layout {
            size: size_of::<DzlRecursiveFileMonitorClass>(),
            alignment: align_of::<DzlRecursiveFileMonitorClass>(),
        },
    ),
    (
        "DzlRing",
        Layout {
            size: size_of::<DzlRing>(),
            alignment: align_of::<DzlRing>(),
        },
    ),
    (
        "DzlScrolledWindowClass",
        Layout {
            size: size_of::<DzlScrolledWindowClass>(),
            alignment: align_of::<DzlScrolledWindowClass>(),
        },
    ),
    (
        "DzlSearchBar",
        Layout {
            size: size_of::<DzlSearchBar>(),
            alignment: align_of::<DzlSearchBar>(),
        },
    ),
    (
        "DzlSearchBarClass",
        Layout {
            size: size_of::<DzlSearchBarClass>(),
            alignment: align_of::<DzlSearchBarClass>(),
        },
    ),
    (
        "DzlSettingsFlagActionClass",
        Layout {
            size: size_of::<DzlSettingsFlagActionClass>(),
            alignment: align_of::<DzlSettingsFlagActionClass>(),
        },
    ),
    (
        "DzlSettingsSandwichClass",
        Layout {
            size: size_of::<DzlSettingsSandwichClass>(),
            alignment: align_of::<DzlSettingsSandwichClass>(),
        },
    ),
    (
        "DzlShortcutAccelDialogClass",
        Layout {
            size: size_of::<DzlShortcutAccelDialogClass>(),
            alignment: align_of::<DzlShortcutAccelDialogClass>(),
        },
    ),
    (
        "DzlShortcutContextClass",
        Layout {
            size: size_of::<DzlShortcutContextClass>(),
            alignment: align_of::<DzlShortcutContextClass>(),
        },
    ),
    (
        "DzlShortcutControllerClass",
        Layout {
            size: size_of::<DzlShortcutControllerClass>(),
            alignment: align_of::<DzlShortcutControllerClass>(),
        },
    ),
    (
        "DzlShortcutEntry",
        Layout {
            size: size_of::<DzlShortcutEntry>(),
            alignment: align_of::<DzlShortcutEntry>(),
        },
    ),
    (
        "DzlShortcutLabelClass",
        Layout {
            size: size_of::<DzlShortcutLabelClass>(),
            alignment: align_of::<DzlShortcutLabelClass>(),
        },
    ),
    (
        "DzlShortcutManager",
        Layout {
            size: size_of::<DzlShortcutManager>(),
            alignment: align_of::<DzlShortcutManager>(),
        },
    ),
    (
        "DzlShortcutManagerClass",
        Layout {
            size: size_of::<DzlShortcutManagerClass>(),
            alignment: align_of::<DzlShortcutManagerClass>(),
        },
    ),
    (
        "DzlShortcutMatch",
        Layout {
            size: size_of::<DzlShortcutMatch>(),
            alignment: align_of::<DzlShortcutMatch>(),
        },
    ),
    (
        "DzlShortcutModelClass",
        Layout {
            size: size_of::<DzlShortcutModelClass>(),
            alignment: align_of::<DzlShortcutModelClass>(),
        },
    ),
    (
        "DzlShortcutPhase",
        Layout {
            size: size_of::<DzlShortcutPhase>(),
            alignment: align_of::<DzlShortcutPhase>(),
        },
    ),
    (
        "DzlShortcutSimpleLabelClass",
        Layout {
            size: size_of::<DzlShortcutSimpleLabelClass>(),
            alignment: align_of::<DzlShortcutSimpleLabelClass>(),
        },
    ),
    (
        "DzlShortcutTheme",
        Layout {
            size: size_of::<DzlShortcutTheme>(),
            alignment: align_of::<DzlShortcutTheme>(),
        },
    ),
    (
        "DzlShortcutThemeClass",
        Layout {
            size: size_of::<DzlShortcutThemeClass>(),
            alignment: align_of::<DzlShortcutThemeClass>(),
        },
    ),
    (
        "DzlShortcutThemeEditor",
        Layout {
            size: size_of::<DzlShortcutThemeEditor>(),
            alignment: align_of::<DzlShortcutThemeEditor>(),
        },
    ),
    (
        "DzlShortcutThemeEditorClass",
        Layout {
            size: size_of::<DzlShortcutThemeEditorClass>(),
            alignment: align_of::<DzlShortcutThemeEditorClass>(),
        },
    ),
    (
        "DzlShortcutTooltipClass",
        Layout {
            size: size_of::<DzlShortcutTooltipClass>(),
            alignment: align_of::<DzlShortcutTooltipClass>(),
        },
    ),
    (
        "DzlShortcutType",
        Layout {
            size: size_of::<DzlShortcutType>(),
            alignment: align_of::<DzlShortcutType>(),
        },
    ),
    (
        "DzlShortcutsWindow",
        Layout {
            size: size_of::<DzlShortcutsWindow>(),
            alignment: align_of::<DzlShortcutsWindow>(),
        },
    ),
    (
        "DzlShortcutsWindowClass",
        Layout {
            size: size_of::<DzlShortcutsWindowClass>(),
            alignment: align_of::<DzlShortcutsWindowClass>(),
        },
    ),
    (
        "DzlSignalGroupClass",
        Layout {
            size: size_of::<DzlSignalGroupClass>(),
            alignment: align_of::<DzlSignalGroupClass>(),
        },
    ),
    (
        "DzlSimpleLabelClass",
        Layout {
            size: size_of::<DzlSimpleLabelClass>(),
            alignment: align_of::<DzlSimpleLabelClass>(),
        },
    ),
    (
        "DzlSimplePopover",
        Layout {
            size: size_of::<DzlSimplePopover>(),
            alignment: align_of::<DzlSimplePopover>(),
        },
    ),
    (
        "DzlSimplePopoverClass",
        Layout {
            size: size_of::<DzlSimplePopoverClass>(),
            alignment: align_of::<DzlSimplePopoverClass>(),
        },
    ),
    (
        "DzlSlider",
        Layout {
            size: size_of::<DzlSlider>(),
            alignment: align_of::<DzlSlider>(),
        },
    ),
    (
        "DzlSliderClass",
        Layout {
            size: size_of::<DzlSliderClass>(),
            alignment: align_of::<DzlSliderClass>(),
        },
    ),
    (
        "DzlSliderPosition",
        Layout {
            size: size_of::<DzlSliderPosition>(),
            alignment: align_of::<DzlSliderPosition>(),
        },
    ),
    (
        "DzlStackList",
        Layout {
            size: size_of::<DzlStackList>(),
            alignment: align_of::<DzlStackList>(),
        },
    ),
    (
        "DzlStackListClass",
        Layout {
            size: size_of::<DzlStackListClass>(),
            alignment: align_of::<DzlStackListClass>(),
        },
    ),
    (
        "DzlStateMachine",
        Layout {
            size: size_of::<DzlStateMachine>(),
            alignment: align_of::<DzlStateMachine>(),
        },
    ),
    (
        "DzlStateMachineClass",
        Layout {
            size: size_of::<DzlStateMachineClass>(),
            alignment: align_of::<DzlStateMachineClass>(),
        },
    ),
    (
        "DzlSuggestion",
        Layout {
            size: size_of::<DzlSuggestion>(),
            alignment: align_of::<DzlSuggestion>(),
        },
    ),
    (
        "DzlSuggestionButton",
        Layout {
            size: size_of::<DzlSuggestionButton>(),
            alignment: align_of::<DzlSuggestionButton>(),
        },
    ),
    (
        "DzlSuggestionButtonClass",
        Layout {
            size: size_of::<DzlSuggestionButtonClass>(),
            alignment: align_of::<DzlSuggestionButtonClass>(),
        },
    ),
    (
        "DzlSuggestionClass",
        Layout {
            size: size_of::<DzlSuggestionClass>(),
            alignment: align_of::<DzlSuggestionClass>(),
        },
    ),
    (
        "DzlSuggestionEntry",
        Layout {
            size: size_of::<DzlSuggestionEntry>(),
            alignment: align_of::<DzlSuggestionEntry>(),
        },
    ),
    (
        "DzlSuggestionEntryBuffer",
        Layout {
            size: size_of::<DzlSuggestionEntryBuffer>(),
            alignment: align_of::<DzlSuggestionEntryBuffer>(),
        },
    ),
    (
        "DzlSuggestionEntryBufferClass",
        Layout {
            size: size_of::<DzlSuggestionEntryBufferClass>(),
            alignment: align_of::<DzlSuggestionEntryBufferClass>(),
        },
    ),
    (
        "DzlSuggestionEntryClass",
        Layout {
            size: size_of::<DzlSuggestionEntryClass>(),
            alignment: align_of::<DzlSuggestionEntryClass>(),
        },
    ),
    (
        "DzlSuggestionPopoverClass",
        Layout {
            size: size_of::<DzlSuggestionPopoverClass>(),
            alignment: align_of::<DzlSuggestionPopoverClass>(),
        },
    ),
    (
        "DzlSuggestionRow",
        Layout {
            size: size_of::<DzlSuggestionRow>(),
            alignment: align_of::<DzlSuggestionRow>(),
        },
    ),
    (
        "DzlSuggestionRowClass",
        Layout {
            size: size_of::<DzlSuggestionRowClass>(),
            alignment: align_of::<DzlSuggestionRowClass>(),
        },
    ),
    (
        "DzlTabClass",
        Layout {
            size: size_of::<DzlTabClass>(),
            alignment: align_of::<DzlTabClass>(),
        },
    ),
    (
        "DzlTabStrip",
        Layout {
            size: size_of::<DzlTabStrip>(),
            alignment: align_of::<DzlTabStrip>(),
        },
    ),
    (
        "DzlTabStripClass",
        Layout {
            size: size_of::<DzlTabStripClass>(),
            alignment: align_of::<DzlTabStripClass>(),
        },
    ),
    (
        "DzlTabStyle",
        Layout {
            size: size_of::<DzlTabStyle>(),
            alignment: align_of::<DzlTabStyle>(),
        },
    ),
    (
        "DzlTaskCacheClass",
        Layout {
            size: size_of::<DzlTaskCacheClass>(),
            alignment: align_of::<DzlTaskCacheClass>(),
        },
    ),
    (
        "DzlThemeManagerClass",
        Layout {
            size: size_of::<DzlThemeManagerClass>(),
            alignment: align_of::<DzlThemeManagerClass>(),
        },
    ),
    (
        "DzlThreeGrid",
        Layout {
            size: size_of::<DzlThreeGrid>(),
            alignment: align_of::<DzlThreeGrid>(),
        },
    ),
    (
        "DzlThreeGridClass",
        Layout {
            size: size_of::<DzlThreeGridClass>(),
            alignment: align_of::<DzlThreeGridClass>(),
        },
    ),
    (
        "DzlThreeGridColumn",
        Layout {
            size: size_of::<DzlThreeGridColumn>(),
            alignment: align_of::<DzlThreeGridColumn>(),
        },
    ),
    (
        "DzlTree",
        Layout {
            size: size_of::<DzlTree>(),
            alignment: align_of::<DzlTree>(),
        },
    ),
    (
        "DzlTreeBuilder",
        Layout {
            size: size_of::<DzlTreeBuilder>(),
            alignment: align_of::<DzlTreeBuilder>(),
        },
    ),
    (
        "DzlTreeBuilderClass",
        Layout {
            size: size_of::<DzlTreeBuilderClass>(),
            alignment: align_of::<DzlTreeBuilderClass>(),
        },
    ),
    (
        "DzlTreeClass",
        Layout {
            size: size_of::<DzlTreeClass>(),
            alignment: align_of::<DzlTreeClass>(),
        },
    ),
    (
        "DzlTreeDropPosition",
        Layout {
            size: size_of::<DzlTreeDropPosition>(),
            alignment: align_of::<DzlTreeDropPosition>(),
        },
    ),
    (
        "DzlTreeNodeClass",
        Layout {
            size: size_of::<DzlTreeNodeClass>(),
            alignment: align_of::<DzlTreeNodeClass>(),
        },
    ),
    (
        "DzlWidgetActionGroupClass",
        Layout {
            size: size_of::<DzlWidgetActionGroupClass>(),
            alignment: align_of::<DzlWidgetActionGroupClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) DZL_ANIMATION_EASE_IN_CUBIC", "4"),
    ("(gint) DZL_ANIMATION_EASE_IN_OUT_CUBIC", "6"),
    ("(gint) DZL_ANIMATION_EASE_IN_OUT_QUAD", "3"),
    ("(gint) DZL_ANIMATION_EASE_IN_QUAD", "1"),
    ("(gint) DZL_ANIMATION_EASE_OUT_CUBIC", "5"),
    ("(gint) DZL_ANIMATION_EASE_OUT_QUAD", "2"),
    ("(gint) DZL_ANIMATION_LINEAR", "0"),
    ("DZL_DOCK_BIN_STYLE_CLASS_PINNED", "pinned"),
    ("(gint) DZL_DOCK_REVEALER_TRANSITION_TYPE_NONE", "0"),
    ("(gint) DZL_DOCK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN", "4"),
    ("(gint) DZL_DOCK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT", "2"),
    ("(gint) DZL_DOCK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT", "1"),
    ("(gint) DZL_DOCK_REVEALER_TRANSITION_TYPE_SLIDE_UP", "3"),
    ("(guint) DZL_FILE_TRANSFER_FLAGS_MOVE", "1"),
    ("(guint) DZL_FILE_TRANSFER_FLAGS_NONE", "0"),
    ("(guint) DZL_PROPERTIES_FLAGS_NONE", "0"),
    ("(guint) DZL_PROPERTIES_FLAGS_STATEFUL_BOOLEANS", "1"),
    ("(gint) DZL_SHORTCUT_ACCELERATOR", "0"),
    ("(gint) DZL_SHORTCUT_GESTURE", "7"),
    ("(gint) DZL_SHORTCUT_GESTURE_PINCH", "1"),
    ("(gint) DZL_SHORTCUT_GESTURE_ROTATE_CLOCKWISE", "3"),
    ("(gint) DZL_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE", "4"),
    ("(gint) DZL_SHORTCUT_GESTURE_STRETCH", "2"),
    ("(gint) DZL_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT", "5"),
    ("(gint) DZL_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT", "6"),
    ("(gint) DZL_SHORTCUT_MATCH_EQUAL", "1"),
    ("(gint) DZL_SHORTCUT_MATCH_NONE", "0"),
    ("(gint) DZL_SHORTCUT_MATCH_PARTIAL", "2"),
    ("(guint) DZL_SHORTCUT_PHASE_BUBBLE", "2"),
    ("(guint) DZL_SHORTCUT_PHASE_CAPTURE", "1"),
    ("(guint) DZL_SHORTCUT_PHASE_DISPATCH", "0"),
    ("(guint) DZL_SHORTCUT_PHASE_GLOBAL", "4"),
    ("(gint) DZL_SLIDER_BOTTOM", "3"),
    ("(gint) DZL_SLIDER_LEFT", "4"),
    ("(gint) DZL_SLIDER_NONE", "0"),
    ("(gint) DZL_SLIDER_RIGHT", "2"),
    ("(gint) DZL_SLIDER_TOP", "1"),
    ("(guint) DZL_TAB_BOTH", "3"),
    ("(guint) DZL_TAB_ICONS", "2"),
    ("(guint) DZL_TAB_TEXT", "1"),
    ("(gint) DZL_THREE_GRID_COLUMN_CENTER", "1"),
    ("(gint) DZL_THREE_GRID_COLUMN_LEFT", "0"),
    ("(gint) DZL_THREE_GRID_COLUMN_RIGHT", "2"),
    ("(gint) DZL_TREE_DROP_AFTER", "2"),
    ("(gint) DZL_TREE_DROP_BEFORE", "1"),
    ("(gint) DZL_TREE_DROP_INTO", "0"),
];
