use std::fs;
use std::path::Path;
use std::process::Command;
use std::{env, io};

use hex_literal::hex;
use sha2::{Digest, Sha512};

fn main() {
    let out_dir = env::var_os("OUT_DIR").unwrap();
    println!("cargo:rustc-flags=-L {}", out_dir.to_str().unwrap());
    println!("cargo:rustc-link-lib=Cwtch");

    println!("cargo:rerun-if-changed=build.rs");
    println!("cargo:rerun-if-changed=libCwtch.h");

    let lib_cwtch_path = Path::new(&out_dir).join("libCwtch.so");
    // https://git.openprivacy.ca/cwtch.im/libcwtch-go/releases v1.7.1
    Command::new("wget")
        .arg("https://git.openprivacy.ca/attachments/98184e9c-1dc7-431a-9601-91a9e763e8fc")
        .arg("-O")
        .arg(lib_cwtch_path)
        .output()
        .expect("failed to download libCwtch.so");

    let lib_cwtch_path = Path::new(&out_dir).join("libCwtch.so");
    let mut hasher = Sha512::new();
    let mut file = fs::File::open(&lib_cwtch_path).expect("could not open lib to hash");
    io::copy(&mut file, &mut hasher).expect("failed to copy file into hasher");
    let hash_bytes = hasher.finalize();

    assert_eq!(hash_bytes[..], hex!("cb4368d72a46f8046261c50e6e9ecf170d8e606871d5de2c1e9e34303533c344f92f5d946d7e12614581dfa3ae8e638512af7f4623ed91b1ceb1570de14bf192")[..]);
}
