use std::ops::{Deref, DerefMut};

pub trait Null {
    fn null() -> Self;
    fn is_null(&self) -> bool;
}
pub fn null<T: Null>() -> T {
    T::null()
}

pub struct Val<T: Null> {
    pub value: T
}
pub trait Valid: Sized + Null {
    fn valid(self) -> Val<Self> {
        debug_assert!(!self.is_null());
        Val::<Self> {
            value: self
        }
    }
}
impl<T: Null> Valid for T {
}

impl<T: Null> Deref for Val<T> {
    type Target = T;

    #[inline]
    fn deref(&self) -> &Self::Target {
        &self.value
    }
}
impl<T: Null> DerefMut for Val<T> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.value
    }
}