// This code was autogenerated with `dbus-codegen-rust -s -g -m None -d org.freedesktop.systemd1 -p /org/freedesktop/systemd1`, see https://github.com/diwic/dbus-rs
#![allow(clippy::all)]
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopDBusPeer {
    fn ping(&self) -> Result<(), dbus::Error>;
    fn get_machine_id(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> OrgFreedesktopDBusPeer
    for blocking::Proxy<'a, C>
{
    fn ping(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "Ping", ())
    }

    fn get_machine_id(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "GetMachineId", ())
            .and_then(|r: (String,)| Ok(r.0))
    }
}

pub trait OrgFreedesktopDBusIntrospectable {
    fn introspect(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>>
    OrgFreedesktopDBusIntrospectable for blocking::Proxy<'a, C>
{
    fn introspect(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ())
            .and_then(|r: (String,)| Ok(r.0))
    }
}

pub trait OrgFreedesktopDBusProperties {
    fn get<R0: for<'b> arg::Get<'b> + 'static>(
        &self,
        interface: &str,
        property: &str,
    ) -> Result<R0, dbus::Error>;
    fn get_all(&self, interface: &str) -> Result<arg::PropMap, dbus::Error>;
    fn set<I2: arg::Arg + arg::Append>(
        &self,
        interface: &str,
        property: &str,
        value: I2,
    ) -> Result<(), dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> OrgFreedesktopDBusProperties
    for blocking::Proxy<'a, C>
{
    fn get<R0: for<'b> arg::Get<'b> + 'static>(
        &self,
        interface: &str,
        property: &str,
    ) -> Result<R0, dbus::Error> {
        self.method_call(
            "org.freedesktop.DBus.Properties",
            "Get",
            (interface, property),
        )
        .and_then(|r: (arg::Variant<R0>,)| Ok((r.0).0))
    }

    fn get_all(&self, interface: &str) -> Result<arg::PropMap, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "GetAll", (interface,))
            .and_then(|r: (arg::PropMap,)| Ok(r.0))
    }

    fn set<I2: arg::Arg + arg::Append>(
        &self,
        interface: &str,
        property: &str,
        value: I2,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.DBus.Properties",
            "Set",
            (interface, property, arg::Variant(value)),
        )
    }
}

#[derive(Debug)]
pub struct OrgFreedesktopDBusPropertiesPropertiesChanged {
    pub interface: String,
    pub changed_properties: arg::PropMap,
    pub invalidated_properties: Vec<String>,
}

impl arg::AppendAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.interface, i);
        arg::RefArg::append(&self.changed_properties, i);
        arg::RefArg::append(&self.invalidated_properties, i);
    }
}

impl arg::ReadAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopDBusPropertiesPropertiesChanged {
            interface: i.read()?,
            changed_properties: i.read()?,
            invalidated_properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopDBusPropertiesPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus.Properties";
}

pub trait OrgFreedesktopSystemd1Manager {
    fn get_unit(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_unit_by_pid(&self, pid: u32) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_unit_by_invocation_id(
        &self,
        invocation_id: Vec<u8>,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_unit_by_control_group(&self, cgroup: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn load_unit(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn start_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn start_unit_replace(
        &self,
        old_unit: &str,
        new_unit: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn stop_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn restart_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn try_restart_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_or_restart_unit(
        &self,
        name: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_or_try_restart_unit(
        &self,
        name: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn enqueue_unit_job(
        &self,
        name: &str,
        job_type: &str,
        job_mode: &str,
    ) -> Result<
        (
            u32,
            dbus::Path<'static>,
            String,
            dbus::Path<'static>,
            String,
            Vec<(
                u32,
                dbus::Path<'static>,
                String,
                dbus::Path<'static>,
                String,
            )>,
        ),
        dbus::Error,
    >;
    fn kill_unit(&self, name: &str, whom: &str, signal: i32) -> Result<(), dbus::Error>;
    fn clean_unit(&self, name: &str, mask: Vec<&str>) -> Result<(), dbus::Error>;
    fn freeze_unit(&self, name: &str) -> Result<(), dbus::Error>;
    fn thaw_unit(&self, name: &str) -> Result<(), dbus::Error>;
    fn reset_failed_unit(&self, name: &str) -> Result<(), dbus::Error>;
    fn set_unit_properties(
        &self,
        name: &str,
        runtime: bool,
        properties: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>,
    ) -> Result<(), dbus::Error>;
    fn ref_unit(&self, name: &str) -> Result<(), dbus::Error>;
    fn unref_unit(&self, name: &str) -> Result<(), dbus::Error>;
    fn start_transient_unit(
        &self,
        name: &str,
        mode: &str,
        properties: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>,
        aux: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_unit_processes(&self, name: &str) -> Result<Vec<(String, u32, String)>, dbus::Error>;
    fn attach_processes_to_unit(
        &self,
        unit_name: &str,
        subcgroup: &str,
        pids: Vec<u32>,
    ) -> Result<(), dbus::Error>;
    fn abandon_scope(&self, name: &str) -> Result<(), dbus::Error>;
    fn get_job(&self, id: u32) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_job_after(
        &self,
        id: u32,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn get_job_before(
        &self,
        id: u32,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn cancel_job(&self, id: u32) -> Result<(), dbus::Error>;
    fn clear_jobs(&self) -> Result<(), dbus::Error>;
    fn reset_failed(&self) -> Result<(), dbus::Error>;
    fn set_show_status_(&self, mode: &str) -> Result<(), dbus::Error>;
    fn list_units(
        &self,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn list_units_filtered(
        &self,
        states: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn list_units_by_patterns(
        &self,
        states: Vec<&str>,
        patterns: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn list_units_by_names(
        &self,
        names: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn list_jobs(
        &self,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    >;
    fn subscribe(&self) -> Result<(), dbus::Error>;
    fn unsubscribe(&self) -> Result<(), dbus::Error>;
    fn dump(&self) -> Result<String, dbus::Error>;
    fn dump_by_file_descriptor(&self) -> Result<arg::OwnedFd, dbus::Error>;
    fn reload(&self) -> Result<(), dbus::Error>;
    fn reexecute(&self) -> Result<(), dbus::Error>;
    fn exit(&self) -> Result<(), dbus::Error>;
    fn reboot(&self) -> Result<(), dbus::Error>;
    fn power_off(&self) -> Result<(), dbus::Error>;
    fn halt(&self) -> Result<(), dbus::Error>;
    fn kexec(&self) -> Result<(), dbus::Error>;
    fn switch_root(&self, new_root: &str, init: &str) -> Result<(), dbus::Error>;
    fn set_environment_(&self, assignments: Vec<&str>) -> Result<(), dbus::Error>;
    fn unset_environment(&self, names: Vec<&str>) -> Result<(), dbus::Error>;
    fn unset_and_set_environment(
        &self,
        names: Vec<&str>,
        assignments: Vec<&str>,
    ) -> Result<(), dbus::Error>;
    fn list_unit_files(&self) -> Result<Vec<(String, String)>, dbus::Error>;
    fn list_unit_files_by_patterns(
        &self,
        states: Vec<&str>,
        patterns: Vec<&str>,
    ) -> Result<Vec<(String, String)>, dbus::Error>;
    fn get_unit_file_state(&self, file: &str) -> Result<String, dbus::Error>;
    fn enable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn disable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn reenable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn link_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn preset_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn preset_unit_files_with_mode(
        &self,
        files: Vec<&str>,
        mode: &str,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn mask_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn unmask_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn revert_unit_files(
        &self,
        files: Vec<&str>,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn set_default_target(
        &self,
        name: &str,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn get_default_target(&self) -> Result<String, dbus::Error>;
    fn preset_all_unit_files(
        &self,
        mode: &str,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn add_dependency_unit_files(
        &self,
        files: Vec<&str>,
        target: &str,
        type_: &str,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn get_unit_file_links(&self, name: &str, runtime: bool) -> Result<Vec<String>, dbus::Error>;
    fn set_exit_code_(&self, number: u8) -> Result<(), dbus::Error>;
    fn lookup_dynamic_user_by_name(&self, name: &str) -> Result<u32, dbus::Error>;
    fn lookup_dynamic_user_by_uid(&self, uid: u32) -> Result<String, dbus::Error>;
    fn get_dynamic_users(&self) -> Result<Vec<(u32, String)>, dbus::Error>;
    fn version(&self) -> Result<String, dbus::Error>;
    fn features(&self) -> Result<String, dbus::Error>;
    fn virtualization(&self) -> Result<String, dbus::Error>;
    fn architecture(&self) -> Result<String, dbus::Error>;
    fn tainted(&self) -> Result<String, dbus::Error>;
    fn firmware_timestamp(&self) -> Result<u64, dbus::Error>;
    fn firmware_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn loader_timestamp(&self) -> Result<u64, dbus::Error>;
    fn loader_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn kernel_timestamp(&self) -> Result<u64, dbus::Error>;
    fn kernel_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdtimestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdtimestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn userspace_timestamp(&self) -> Result<u64, dbus::Error>;
    fn userspace_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn security_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn security_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn security_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn security_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn generators_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn generators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn generators_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn generators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn units_load_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn units_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn units_load_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn units_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdsecurity_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdsecurity_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdsecurity_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdsecurity_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdgenerators_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdgenerators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdgenerators_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdgenerators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdunits_load_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdunits_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdunits_load_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdunits_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn log_level(&self) -> Result<String, dbus::Error>;
    fn set_log_level(&self, value: String) -> Result<(), dbus::Error>;
    fn log_target(&self) -> Result<String, dbus::Error>;
    fn set_log_target(&self, value: String) -> Result<(), dbus::Error>;
    fn nnames(&self) -> Result<u32, dbus::Error>;
    fn nfailed_units(&self) -> Result<u32, dbus::Error>;
    fn njobs(&self) -> Result<u32, dbus::Error>;
    fn ninstalled_jobs(&self) -> Result<u32, dbus::Error>;
    fn nfailed_jobs(&self) -> Result<u32, dbus::Error>;
    fn progress(&self) -> Result<f64, dbus::Error>;
    fn environment(&self) -> Result<Vec<String>, dbus::Error>;
    fn confirm_spawn(&self) -> Result<bool, dbus::Error>;
    fn show_status(&self) -> Result<bool, dbus::Error>;
    fn unit_path(&self) -> Result<Vec<String>, dbus::Error>;
    fn default_standard_output(&self) -> Result<String, dbus::Error>;
    fn default_standard_error(&self) -> Result<String, dbus::Error>;
    fn runtime_watchdog_usec(&self) -> Result<u64, dbus::Error>;
    fn set_runtime_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error>;
    fn reboot_watchdog_usec(&self) -> Result<u64, dbus::Error>;
    fn set_reboot_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error>;
    fn kexec_watchdog_usec(&self) -> Result<u64, dbus::Error>;
    fn set_kexec_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error>;
    fn service_watchdogs(&self) -> Result<bool, dbus::Error>;
    fn set_service_watchdogs(&self, value: bool) -> Result<(), dbus::Error>;
    fn control_group(&self) -> Result<String, dbus::Error>;
    fn system_state(&self) -> Result<String, dbus::Error>;
    fn exit_code(&self) -> Result<u8, dbus::Error>;
    fn default_timer_accuracy_usec(&self) -> Result<u64, dbus::Error>;
    fn default_timeout_start_usec(&self) -> Result<u64, dbus::Error>;
    fn default_timeout_stop_usec(&self) -> Result<u64, dbus::Error>;
    fn default_timeout_abort_usec(&self) -> Result<u64, dbus::Error>;
    fn default_restart_usec(&self) -> Result<u64, dbus::Error>;
    fn default_start_limit_interval_usec(&self) -> Result<u64, dbus::Error>;
    fn default_start_limit_burst(&self) -> Result<u32, dbus::Error>;
    fn default_cpuaccounting(&self) -> Result<bool, dbus::Error>;
    fn default_block_ioaccounting(&self) -> Result<bool, dbus::Error>;
    fn default_memory_accounting(&self) -> Result<bool, dbus::Error>;
    fn default_tasks_accounting(&self) -> Result<bool, dbus::Error>;
    fn default_limit_cpu(&self) -> Result<u64, dbus::Error>;
    fn default_limit_cpusoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_fsize(&self) -> Result<u64, dbus::Error>;
    fn default_limit_fsizesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_data(&self) -> Result<u64, dbus::Error>;
    fn default_limit_datasoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_stack(&self) -> Result<u64, dbus::Error>;
    fn default_limit_stacksoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_core(&self) -> Result<u64, dbus::Error>;
    fn default_limit_coresoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rss(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rsssoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nofile(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nofilesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_as(&self) -> Result<u64, dbus::Error>;
    fn default_limit_assoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nproc(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nprocsoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_memlock(&self) -> Result<u64, dbus::Error>;
    fn default_limit_memlocksoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_locks(&self) -> Result<u64, dbus::Error>;
    fn default_limit_lockssoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_sigpending(&self) -> Result<u64, dbus::Error>;
    fn default_limit_sigpendingsoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_msgqueue(&self) -> Result<u64, dbus::Error>;
    fn default_limit_msgqueuesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nice(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nicesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rtprio(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rtpriosoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rttime(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rttimesoft(&self) -> Result<u64, dbus::Error>;
    fn default_tasks_max(&self) -> Result<u64, dbus::Error>;
    fn timer_slack_nsec(&self) -> Result<u64, dbus::Error>;
    fn default_oompolicy(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>>
    OrgFreedesktopSystemd1Manager for blocking::Proxy<'a, C>
{
    fn get_unit(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnit", (name,))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_unit_by_pid(&self, pid: u32) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnitByPID", (pid,))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_unit_by_invocation_id(
        &self,
        invocation_id: Vec<u8>,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "GetUnitByInvocationID",
            (invocation_id,),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_unit_by_control_group(&self, cgroup: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "GetUnitByControlGroup",
            (cgroup,),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn load_unit(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "LoadUnit", (name,))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn start_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "StartUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn start_unit_replace(
        &self,
        old_unit: &str,
        new_unit: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "StartUnitReplace",
            (old_unit, new_unit, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn stop_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "StopUnit", (name, mode))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn reload_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ReloadUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn restart_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "RestartUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn try_restart_unit(&self, name: &str, mode: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "TryRestartUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn reload_or_restart_unit(
        &self,
        name: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ReloadOrRestartUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn reload_or_try_restart_unit(
        &self,
        name: &str,
        mode: &str,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ReloadOrTryRestartUnit",
            (name, mode),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn enqueue_unit_job(
        &self,
        name: &str,
        job_type: &str,
        job_mode: &str,
    ) -> Result<
        (
            u32,
            dbus::Path<'static>,
            String,
            dbus::Path<'static>,
            String,
            Vec<(
                u32,
                dbus::Path<'static>,
                String,
                dbus::Path<'static>,
                String,
            )>,
        ),
        dbus::Error,
    > {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "EnqueueUnitJob",
            (name, job_type, job_mode),
        )
    }

    fn kill_unit(&self, name: &str, whom: &str, signal: i32) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "KillUnit",
            (name, whom, signal),
        )
    }

    fn clean_unit(&self, name: &str, mask: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "CleanUnit",
            (name, mask),
        )
    }

    fn freeze_unit(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "FreezeUnit", (name,))
    }

    fn thaw_unit(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ThawUnit", (name,))
    }

    fn reset_failed_unit(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ResetFailedUnit",
            (name,),
        )
    }

    fn set_unit_properties(
        &self,
        name: &str,
        runtime: bool,
        properties: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "SetUnitProperties",
            (name, runtime, properties),
        )
    }

    fn ref_unit(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "RefUnit", (name,))
    }

    fn unref_unit(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnrefUnit", (name,))
    }

    fn start_transient_unit(
        &self,
        name: &str,
        mode: &str,
        properties: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>,
        aux: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "StartTransientUnit",
            (name, mode, properties, aux),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_unit_processes(&self, name: &str) -> Result<Vec<(String, u32, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "GetUnitProcesses",
            (name,),
        )
        .and_then(|r: (Vec<(String, u32, String)>,)| Ok(r.0))
    }

    fn attach_processes_to_unit(
        &self,
        unit_name: &str,
        subcgroup: &str,
        pids: Vec<u32>,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "AttachProcessesToUnit",
            (unit_name, subcgroup, pids),
        )
    }

    fn abandon_scope(&self, name: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "AbandonScope", (name,))
    }

    fn get_job(&self, id: u32) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetJob", (id,))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn get_job_after(
        &self,
        id: u32,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call("org.freedesktop.systemd1.Manager", "GetJobAfter", (id,))
            .and_then(
                |r: (
                    Vec<(
                        u32,
                        String,
                        String,
                        String,
                        dbus::Path<'static>,
                        dbus::Path<'static>,
                    )>,
                )| Ok(r.0),
            )
    }

    fn get_job_before(
        &self,
        id: u32,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call("org.freedesktop.systemd1.Manager", "GetJobBefore", (id,))
            .and_then(
                |r: (
                    Vec<(
                        u32,
                        String,
                        String,
                        String,
                        dbus::Path<'static>,
                        dbus::Path<'static>,
                    )>,
                )| Ok(r.0),
            )
    }

    fn cancel_job(&self, id: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "CancelJob", (id,))
    }

    fn clear_jobs(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ClearJobs", ())
    }

    fn reset_failed(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ResetFailed", ())
    }

    fn set_show_status_(&self, mode: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetShowStatus", (mode,))
    }

    fn list_units(
        &self,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnits", ())
            .and_then(
                |r: (
                    Vec<(
                        String,
                        String,
                        String,
                        String,
                        String,
                        String,
                        dbus::Path<'static>,
                        u32,
                        String,
                        dbus::Path<'static>,
                    )>,
                )| Ok(r.0),
            )
    }

    fn list_units_filtered(
        &self,
        states: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ListUnitsFiltered",
            (states,),
        )
        .and_then(
            |r: (
                Vec<(
                    String,
                    String,
                    String,
                    String,
                    String,
                    String,
                    dbus::Path<'static>,
                    u32,
                    String,
                    dbus::Path<'static>,
                )>,
            )| Ok(r.0),
        )
    }

    fn list_units_by_patterns(
        &self,
        states: Vec<&str>,
        patterns: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ListUnitsByPatterns",
            (states, patterns),
        )
        .and_then(
            |r: (
                Vec<(
                    String,
                    String,
                    String,
                    String,
                    String,
                    String,
                    dbus::Path<'static>,
                    u32,
                    String,
                    dbus::Path<'static>,
                )>,
            )| Ok(r.0),
        )
    }

    fn list_units_by_names(
        &self,
        names: Vec<&str>,
    ) -> Result<
        Vec<(
            String,
            String,
            String,
            String,
            String,
            String,
            dbus::Path<'static>,
            u32,
            String,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ListUnitsByNames",
            (names,),
        )
        .and_then(
            |r: (
                Vec<(
                    String,
                    String,
                    String,
                    String,
                    String,
                    String,
                    dbus::Path<'static>,
                    u32,
                    String,
                    dbus::Path<'static>,
                )>,
            )| Ok(r.0),
        )
    }

    fn list_jobs(
        &self,
    ) -> Result<
        Vec<(
            u32,
            String,
            String,
            String,
            dbus::Path<'static>,
            dbus::Path<'static>,
        )>,
        dbus::Error,
    > {
        self.method_call("org.freedesktop.systemd1.Manager", "ListJobs", ())
            .and_then(
                |r: (
                    Vec<(
                        u32,
                        String,
                        String,
                        String,
                        dbus::Path<'static>,
                        dbus::Path<'static>,
                    )>,
                )| Ok(r.0),
            )
    }

    fn subscribe(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Subscribe", ())
    }

    fn unsubscribe(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Unsubscribe", ())
    }

    fn dump(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Dump", ())
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn dump_by_file_descriptor(&self) -> Result<arg::OwnedFd, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "DumpByFileDescriptor",
            (),
        )
        .and_then(|r: (arg::OwnedFd,)| Ok(r.0))
    }

    fn reload(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reload", ())
    }

    fn reexecute(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reexecute", ())
    }

    fn exit(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Exit", ())
    }

    fn reboot(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reboot", ())
    }

    fn power_off(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "PowerOff", ())
    }

    fn halt(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Halt", ())
    }

    fn kexec(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "KExec", ())
    }

    fn switch_root(&self, new_root: &str, init: &str) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "SwitchRoot",
            (new_root, init),
        )
    }

    fn set_environment_(&self, assignments: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "SetEnvironment",
            (assignments,),
        )
    }

    fn unset_environment(&self, names: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "UnsetEnvironment",
            (names,),
        )
    }

    fn unset_and_set_environment(
        &self,
        names: Vec<&str>,
        assignments: Vec<&str>,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "UnsetAndSetEnvironment",
            (names, assignments),
        )
    }

    fn list_unit_files(&self) -> Result<Vec<(String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnitFiles", ())
            .and_then(|r: (Vec<(String, String)>,)| Ok(r.0))
    }

    fn list_unit_files_by_patterns(
        &self,
        states: Vec<&str>,
        patterns: Vec<&str>,
    ) -> Result<Vec<(String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ListUnitFilesByPatterns",
            (states, patterns),
        )
        .and_then(|r: (Vec<(String, String)>,)| Ok(r.0))
    }

    fn get_unit_file_state(&self, file: &str) -> Result<String, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "GetUnitFileState",
            (file,),
        )
        .and_then(|r: (String,)| Ok(r.0))
    }

    fn enable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "EnableUnitFiles",
            (files, runtime, force),
        )
    }

    fn disable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "DisableUnitFiles",
            (files, runtime),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn reenable_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "ReenableUnitFiles",
            (files, runtime, force),
        )
    }

    fn link_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "LinkUnitFiles",
            (files, runtime, force),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn preset_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "PresetUnitFiles",
            (files, runtime, force),
        )
    }

    fn preset_unit_files_with_mode(
        &self,
        files: Vec<&str>,
        mode: &str,
        runtime: bool,
        force: bool,
    ) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "PresetUnitFilesWithMode",
            (files, mode, runtime, force),
        )
    }

    fn mask_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "MaskUnitFiles",
            (files, runtime, force),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn unmask_unit_files(
        &self,
        files: Vec<&str>,
        runtime: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "UnmaskUnitFiles",
            (files, runtime),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn revert_unit_files(
        &self,
        files: Vec<&str>,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "RevertUnitFiles",
            (files,),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn set_default_target(
        &self,
        name: &str,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "SetDefaultTarget",
            (name, force),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn get_default_target(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetDefaultTarget", ())
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn preset_all_unit_files(
        &self,
        mode: &str,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "PresetAllUnitFiles",
            (mode, runtime, force),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn add_dependency_unit_files(
        &self,
        files: Vec<&str>,
        target: &str,
        type_: &str,
        runtime: bool,
        force: bool,
    ) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "AddDependencyUnitFiles",
            (files, target, type_, runtime, force),
        )
        .and_then(|r: (Vec<(String, String, String)>,)| Ok(r.0))
    }

    fn get_unit_file_links(&self, name: &str, runtime: bool) -> Result<Vec<String>, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "GetUnitFileLinks",
            (name, runtime),
        )
        .and_then(|r: (Vec<String>,)| Ok(r.0))
    }

    fn set_exit_code_(&self, number: u8) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetExitCode", (number,))
    }

    fn lookup_dynamic_user_by_name(&self, name: &str) -> Result<u32, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "LookupDynamicUserByName",
            (name,),
        )
        .and_then(|r: (u32,)| Ok(r.0))
    }

    fn lookup_dynamic_user_by_uid(&self, uid: u32) -> Result<String, dbus::Error> {
        self.method_call(
            "org.freedesktop.systemd1.Manager",
            "LookupDynamicUserByUID",
            (uid,),
        )
        .and_then(|r: (String,)| Ok(r.0))
    }

    fn get_dynamic_users(&self) -> Result<Vec<(u32, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetDynamicUsers", ())
            .and_then(|r: (Vec<(u32, String)>,)| Ok(r.0))
    }

    fn version(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Version",
        )
    }

    fn features(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Features",
        )
    }

    fn virtualization(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Virtualization",
        )
    }

    fn architecture(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Architecture",
        )
    }

    fn tainted(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Tainted",
        )
    }

    fn firmware_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "FirmwareTimestamp",
        )
    }

    fn firmware_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "FirmwareTimestampMonotonic",
        )
    }

    fn loader_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LoaderTimestamp",
        )
    }

    fn loader_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LoaderTimestampMonotonic",
        )
    }

    fn kernel_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "KernelTimestamp",
        )
    }

    fn kernel_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "KernelTimestampMonotonic",
        )
    }

    fn init_rdtimestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDTimestamp",
        )
    }

    fn init_rdtimestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDTimestampMonotonic",
        )
    }

    fn userspace_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UserspaceTimestamp",
        )
    }

    fn userspace_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UserspaceTimestampMonotonic",
        )
    }

    fn finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "FinishTimestamp",
        )
    }

    fn finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "FinishTimestampMonotonic",
        )
    }

    fn security_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "SecurityStartTimestamp",
        )
    }

    fn security_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "SecurityStartTimestampMonotonic",
        )
    }

    fn security_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "SecurityFinishTimestamp",
        )
    }

    fn security_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "SecurityFinishTimestampMonotonic",
        )
    }

    fn generators_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "GeneratorsStartTimestamp",
        )
    }

    fn generators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "GeneratorsStartTimestampMonotonic",
        )
    }

    fn generators_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "GeneratorsFinishTimestamp",
        )
    }

    fn generators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "GeneratorsFinishTimestampMonotonic",
        )
    }

    fn units_load_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UnitsLoadStartTimestamp",
        )
    }

    fn units_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UnitsLoadStartTimestampMonotonic",
        )
    }

    fn units_load_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UnitsLoadFinishTimestamp",
        )
    }

    fn units_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UnitsLoadFinishTimestampMonotonic",
        )
    }

    fn init_rdsecurity_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDSecurityStartTimestamp",
        )
    }

    fn init_rdsecurity_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDSecurityStartTimestampMonotonic",
        )
    }

    fn init_rdsecurity_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDSecurityFinishTimestamp",
        )
    }

    fn init_rdsecurity_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDSecurityFinishTimestampMonotonic",
        )
    }

    fn init_rdgenerators_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDGeneratorsStartTimestamp",
        )
    }

    fn init_rdgenerators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDGeneratorsStartTimestampMonotonic",
        )
    }

    fn init_rdgenerators_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDGeneratorsFinishTimestamp",
        )
    }

    fn init_rdgenerators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDGeneratorsFinishTimestampMonotonic",
        )
    }

    fn init_rdunits_load_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDUnitsLoadStartTimestamp",
        )
    }

    fn init_rdunits_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDUnitsLoadStartTimestampMonotonic",
        )
    }

    fn init_rdunits_load_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDUnitsLoadFinishTimestamp",
        )
    }

    fn init_rdunits_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "InitRDUnitsLoadFinishTimestampMonotonic",
        )
    }

    fn log_level(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LogLevel",
        )
    }

    fn log_target(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LogTarget",
        )
    }

    fn nnames(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "NNames",
        )
    }

    fn nfailed_units(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "NFailedUnits",
        )
    }

    fn njobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "NJobs",
        )
    }

    fn ninstalled_jobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "NInstalledJobs",
        )
    }

    fn nfailed_jobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "NFailedJobs",
        )
    }

    fn progress(&self) -> Result<f64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Progress",
        )
    }

    fn environment(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "Environment",
        )
    }

    fn confirm_spawn(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ConfirmSpawn",
        )
    }

    fn show_status(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ShowStatus",
        )
    }

    fn unit_path(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "UnitPath",
        )
    }

    fn default_standard_output(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultStandardOutput",
        )
    }

    fn default_standard_error(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultStandardError",
        )
    }

    fn runtime_watchdog_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "RuntimeWatchdogUSec",
        )
    }

    fn reboot_watchdog_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "RebootWatchdogUSec",
        )
    }

    fn kexec_watchdog_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "KExecWatchdogUSec",
        )
    }

    fn service_watchdogs(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ServiceWatchdogs",
        )
    }

    fn control_group(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ControlGroup",
        )
    }

    fn system_state(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "SystemState",
        )
    }

    fn exit_code(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ExitCode",
        )
    }

    fn default_timer_accuracy_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTimerAccuracyUSec",
        )
    }

    fn default_timeout_start_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTimeoutStartUSec",
        )
    }

    fn default_timeout_stop_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTimeoutStopUSec",
        )
    }

    fn default_timeout_abort_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTimeoutAbortUSec",
        )
    }

    fn default_restart_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultRestartUSec",
        )
    }

    fn default_start_limit_interval_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultStartLimitIntervalUSec",
        )
    }

    fn default_start_limit_burst(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultStartLimitBurst",
        )
    }

    fn default_cpuaccounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultCPUAccounting",
        )
    }

    fn default_block_ioaccounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultBlockIOAccounting",
        )
    }

    fn default_memory_accounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultMemoryAccounting",
        )
    }

    fn default_tasks_accounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTasksAccounting",
        )
    }

    fn default_limit_cpu(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitCPU",
        )
    }

    fn default_limit_cpusoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitCPUSoft",
        )
    }

    fn default_limit_fsize(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitFSIZE",
        )
    }

    fn default_limit_fsizesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitFSIZESoft",
        )
    }

    fn default_limit_data(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitDATA",
        )
    }

    fn default_limit_datasoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitDATASoft",
        )
    }

    fn default_limit_stack(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitSTACK",
        )
    }

    fn default_limit_stacksoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitSTACKSoft",
        )
    }

    fn default_limit_core(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitCORE",
        )
    }

    fn default_limit_coresoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitCORESoft",
        )
    }

    fn default_limit_rss(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRSS",
        )
    }

    fn default_limit_rsssoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRSSSoft",
        )
    }

    fn default_limit_nofile(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNOFILE",
        )
    }

    fn default_limit_nofilesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNOFILESoft",
        )
    }

    fn default_limit_as(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitAS",
        )
    }

    fn default_limit_assoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitASSoft",
        )
    }

    fn default_limit_nproc(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNPROC",
        )
    }

    fn default_limit_nprocsoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNPROCSoft",
        )
    }

    fn default_limit_memlock(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitMEMLOCK",
        )
    }

    fn default_limit_memlocksoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitMEMLOCKSoft",
        )
    }

    fn default_limit_locks(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitLOCKS",
        )
    }

    fn default_limit_lockssoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitLOCKSSoft",
        )
    }

    fn default_limit_sigpending(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitSIGPENDING",
        )
    }

    fn default_limit_sigpendingsoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitSIGPENDINGSoft",
        )
    }

    fn default_limit_msgqueue(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitMSGQUEUE",
        )
    }

    fn default_limit_msgqueuesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitMSGQUEUESoft",
        )
    }

    fn default_limit_nice(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNICE",
        )
    }

    fn default_limit_nicesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitNICESoft",
        )
    }

    fn default_limit_rtprio(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRTPRIO",
        )
    }

    fn default_limit_rtpriosoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRTPRIOSoft",
        )
    }

    fn default_limit_rttime(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRTTIME",
        )
    }

    fn default_limit_rttimesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultLimitRTTIMESoft",
        )
    }

    fn default_tasks_max(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultTasksMax",
        )
    }

    fn timer_slack_nsec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "TimerSlackNSec",
        )
    }

    fn default_oompolicy(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.systemd1.Manager",
            "DefaultOOMPolicy",
        )
    }

    fn set_log_level(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LogLevel",
            value,
        )
    }

    fn set_log_target(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "LogTarget",
            value,
        )
    }

    fn set_runtime_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "RuntimeWatchdogUSec",
            value,
        )
    }

    fn set_reboot_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "RebootWatchdogUSec",
            value,
        )
    }

    fn set_kexec_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "KExecWatchdogUSec",
            value,
        )
    }

    fn set_service_watchdogs(&self, value: bool) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            &self,
            "org.freedesktop.systemd1.Manager",
            "ServiceWatchdogs",
            value,
        )
    }
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitNew {
    pub id: String,
    pub unit: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.id, i);
        arg::RefArg::append(&self.unit, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitNew {
            id: i.read()?,
            unit: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitNew {
    const NAME: &'static str = "UnitNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitRemoved {
    pub id: String,
    pub unit: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.id, i);
        arg::RefArg::append(&self.unit, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitRemoved {
            id: i.read()?,
            unit: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitRemoved {
    const NAME: &'static str = "UnitRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobNew {
    pub id: u32,
    pub job: dbus::Path<'static>,
    pub unit: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.id, i);
        arg::RefArg::append(&self.job, i);
        arg::RefArg::append(&self.unit, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobNew {
            id: i.read()?,
            job: i.read()?,
            unit: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobNew {
    const NAME: &'static str = "JobNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobRemoved {
    pub id: u32,
    pub job: dbus::Path<'static>,
    pub unit: String,
    pub result: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.id, i);
        arg::RefArg::append(&self.job, i);
        arg::RefArg::append(&self.unit, i);
        arg::RefArg::append(&self.result, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobRemoved {
            id: i.read()?,
            job: i.read()?,
            unit: i.read()?,
            result: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobRemoved {
    const NAME: &'static str = "JobRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerStartupFinished {
    pub firmware: u64,
    pub loader: u64,
    pub kernel: u64,
    pub initrd: u64,
    pub userspace: u64,
    pub total: u64,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.firmware, i);
        arg::RefArg::append(&self.loader, i);
        arg::RefArg::append(&self.kernel, i);
        arg::RefArg::append(&self.initrd, i);
        arg::RefArg::append(&self.userspace, i);
        arg::RefArg::append(&self.total, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerStartupFinished {
            firmware: i.read()?,
            loader: i.read()?,
            kernel: i.read()?,
            initrd: i.read()?,
            userspace: i.read()?,
            total: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerStartupFinished {
    const NAME: &'static str = "StartupFinished";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitFilesChanged {}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn append(&self, _: &mut arg::IterAppend) {}
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitFilesChanged {})
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    const NAME: &'static str = "UnitFilesChanged";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerReloading {
    pub active: bool,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerReloading {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.active, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerReloading {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerReloading { active: i.read()? })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerReloading {
    const NAME: &'static str = "Reloading";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}
