// Copyright (c) 2019, Lawrence Livermore National Security, LLC.
// Produced at the Lawrence Livermore National Laboratory. LLNL-CODE-734707.
// All Rights reserved. See files LICENSE and NOTICE for details.
//
// This file is part of CEED, a collection of benchmarks, miniapps, software
// libraries and APIs for efficient high-order finite element and spectral
// element discretizations for exascale applications. For more information and
// source code availability see http://github.com/ceed.
//
// The CEED research is supported by the Exascale Computing Project 17-SC-20-SC,
// a collaborative effort of two U.S. Department of Energy organizations (Office
// of Science and the National Nuclear Security Administration) responsible for
// the planning and preparation of a capable exascale ecosystem, including
// software, applications, hardware, advanced system engineering and early
// testbed platforms, in support of the nation's exascale computing imperative.

#include "ceed-occa-ceed-object.hpp"
#include "ceed-occa-context.hpp"

namespace ceed {
  namespace occa {
    CeedObject::CeedObject(Ceed ceed_) :
        ceed(ceed_) {}

    ::occa::device CeedObject::getDevice() {
      if (!_device.isInitialized()) {
        _device = Context::from(ceed)->device;
      }
      return _device;
    }

    bool CeedObject::usingCpuDevice() const {
      return Context::from(ceed)->usingCpuDevice();
    }

    bool CeedObject::usingGpuDevice() const {
      return Context::from(ceed)->usingGpuDevice();
    }

    int CeedObject::ceedError(const std::string &message) const {
      return CeedError(ceed, CEED_ERROR_BACKEND, message.c_str());
    }

    int CeedObject::staticCeedError(const std::string &message) {
      return CeedError(NULL, CEED_ERROR_BACKEND, message.c_str());
    }
  }
}
