/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const XDP_FLAGS_UPDATE_IF_NOEXIST: u32 = 1;
pub const XDP_FLAGS_SKB_MODE: u32 = 2;
pub const XDP_FLAGS_DRV_MODE: u32 = 4;
pub const XDP_FLAGS_HW_MODE: u32 = 8;
pub const XDP_FLAGS_REPLACE: u32 = 16;
pub const XDP_FLAGS_MODES: u32 = 14;
pub const XDP_FLAGS_MASK: u32 = 31;
pub const BPF_LD: u32 = 0;
pub const BPF_LDX: u32 = 1;
pub const BPF_ST: u32 = 2;
pub const BPF_STX: u32 = 3;
pub const BPF_ALU: u32 = 4;
pub const BPF_JMP: u32 = 5;
pub const BPF_RET: u32 = 6;
pub const BPF_MISC: u32 = 7;
pub const BPF_W: u32 = 0;
pub const BPF_H: u32 = 8;
pub const BPF_B: u32 = 16;
pub const BPF_IMM: u32 = 0;
pub const BPF_ABS: u32 = 32;
pub const BPF_IND: u32 = 64;
pub const BPF_MEM: u32 = 96;
pub const BPF_LEN: u32 = 128;
pub const BPF_MSH: u32 = 160;
pub const BPF_ADD: u32 = 0;
pub const BPF_SUB: u32 = 16;
pub const BPF_MUL: u32 = 32;
pub const BPF_DIV: u32 = 48;
pub const BPF_OR: u32 = 64;
pub const BPF_AND: u32 = 80;
pub const BPF_LSH: u32 = 96;
pub const BPF_RSH: u32 = 112;
pub const BPF_NEG: u32 = 128;
pub const BPF_MOD: u32 = 144;
pub const BPF_XOR: u32 = 160;
pub const BPF_JA: u32 = 0;
pub const BPF_JEQ: u32 = 16;
pub const BPF_JGT: u32 = 32;
pub const BPF_JGE: u32 = 48;
pub const BPF_JSET: u32 = 64;
pub const BPF_K: u32 = 0;
pub const BPF_X: u32 = 8;
pub const BPF_MAXINSNS: u32 = 4096;
pub const BPF_JMP32: u32 = 6;
pub const BPF_ALU64: u32 = 7;
pub const BPF_DW: u32 = 24;
pub const BPF_ATOMIC: u32 = 192;
pub const BPF_XADD: u32 = 192;
pub const BPF_MOV: u32 = 176;
pub const BPF_ARSH: u32 = 192;
pub const BPF_END: u32 = 208;
pub const BPF_TO_LE: u32 = 0;
pub const BPF_TO_BE: u32 = 8;
pub const BPF_FROM_LE: u32 = 0;
pub const BPF_FROM_BE: u32 = 8;
pub const BPF_JNE: u32 = 80;
pub const BPF_JLT: u32 = 160;
pub const BPF_JLE: u32 = 176;
pub const BPF_JSGT: u32 = 96;
pub const BPF_JSGE: u32 = 112;
pub const BPF_JSLT: u32 = 192;
pub const BPF_JSLE: u32 = 208;
pub const BPF_CALL: u32 = 128;
pub const BPF_EXIT: u32 = 144;
pub const BPF_FETCH: u32 = 1;
pub const BPF_XCHG: u32 = 225;
pub const BPF_CMPXCHG: u32 = 241;
pub const BPF_F_ALLOW_OVERRIDE: u32 = 1;
pub const BPF_F_ALLOW_MULTI: u32 = 2;
pub const BPF_F_REPLACE: u32 = 4;
pub const BPF_F_STRICT_ALIGNMENT: u32 = 1;
pub const BPF_F_ANY_ALIGNMENT: u32 = 2;
pub const BPF_F_TEST_RND_HI32: u32 = 4;
pub const BPF_F_TEST_STATE_FREQ: u32 = 8;
pub const BPF_F_SLEEPABLE: u32 = 16;
pub const BPF_PSEUDO_MAP_FD: u32 = 1;
pub const BPF_PSEUDO_MAP_IDX: u32 = 5;
pub const BPF_PSEUDO_MAP_VALUE: u32 = 2;
pub const BPF_PSEUDO_MAP_IDX_VALUE: u32 = 6;
pub const BPF_PSEUDO_BTF_ID: u32 = 3;
pub const BPF_PSEUDO_FUNC: u32 = 4;
pub const BPF_PSEUDO_CALL: u32 = 1;
pub const BPF_PSEUDO_KFUNC_CALL: u32 = 2;
pub const BPF_F_QUERY_EFFECTIVE: u32 = 1;
pub const BPF_F_TEST_RUN_ON_CPU: u32 = 1;
pub const BPF_BUILD_ID_SIZE: u32 = 20;
pub const BPF_OBJ_NAME_LEN: u32 = 16;
pub const XDP_PACKET_HEADROOM: u32 = 256;
pub const BPF_TAG_SIZE: u32 = 8;
pub const BPF_LOG_BUF_SIZE: u32 = 16777215;
pub const BTF_MAGIC: u32 = 60319;
pub const BTF_VERSION: u32 = 1;
pub const BTF_MAX_TYPE: u32 = 1048575;
pub const BTF_MAX_NAME_OFFSET: u32 = 16777215;
pub const BTF_MAX_VLEN: u32 = 65535;
pub const BTF_KIND_UNKN: u32 = 0;
pub const BTF_KIND_INT: u32 = 1;
pub const BTF_KIND_PTR: u32 = 2;
pub const BTF_KIND_ARRAY: u32 = 3;
pub const BTF_KIND_STRUCT: u32 = 4;
pub const BTF_KIND_UNION: u32 = 5;
pub const BTF_KIND_ENUM: u32 = 6;
pub const BTF_KIND_FWD: u32 = 7;
pub const BTF_KIND_TYPEDEF: u32 = 8;
pub const BTF_KIND_VOLATILE: u32 = 9;
pub const BTF_KIND_CONST: u32 = 10;
pub const BTF_KIND_RESTRICT: u32 = 11;
pub const BTF_KIND_FUNC: u32 = 12;
pub const BTF_KIND_FUNC_PROTO: u32 = 13;
pub const BTF_KIND_VAR: u32 = 14;
pub const BTF_KIND_DATASEC: u32 = 15;
pub const BTF_KIND_FLOAT: u32 = 16;
pub const BTF_KIND_MAX: u32 = 16;
pub const BTF_INT_SIGNED: u32 = 1;
pub const BTF_INT_CHAR: u32 = 2;
pub const BTF_INT_BOOL: u32 = 4;
pub const BTF_ELF_SEC: &'static [u8; 5usize] = b".BTF\0";
pub const BTF_EXT_ELF_SEC: &'static [u8; 9usize] = b".BTF.ext\0";
pub const XDP_SHARED_UMEM: u32 = 1;
pub const XDP_COPY: u32 = 2;
pub const XDP_ZEROCOPY: u32 = 4;
pub const XDP_USE_NEED_WAKEUP: u32 = 8;
pub const XDP_UMEM_UNALIGNED_CHUNK_FLAG: u32 = 1;
pub const XDP_RING_NEED_WAKEUP: u32 = 1;
pub const XDP_MMAP_OFFSETS: u32 = 1;
pub const XDP_RX_RING: u32 = 2;
pub const XDP_TX_RING: u32 = 3;
pub const XDP_UMEM_REG: u32 = 4;
pub const XDP_UMEM_FILL_RING: u32 = 5;
pub const XDP_UMEM_COMPLETION_RING: u32 = 6;
pub const XDP_STATISTICS: u32 = 7;
pub const XDP_OPTIONS: u32 = 8;
pub const XDP_OPTIONS_ZEROCOPY: u32 = 1;
pub const XDP_PGOFF_RX_RING: u32 = 0;
pub const XDP_PGOFF_TX_RING: u32 = 2147483648;
pub const XDP_UMEM_PGOFF_FILL_RING: u64 = 4294967296;
pub const XDP_UMEM_PGOFF_COMPLETION_RING: u64 = 6442450944;
pub const XSK_UNALIGNED_BUF_OFFSET_SHIFT: u32 = 48;
pub const XSK_UNALIGNED_BUF_ADDR_MASK: u64 = 281474976710655;
pub const XSK_RING_CONS__DEFAULT_NUM_DESCS: u32 = 2048;
pub const XSK_RING_PROD__DEFAULT_NUM_DESCS: u32 = 2048;
pub const XSK_UMEM__DEFAULT_FRAME_SHIFT: u32 = 12;
pub const XSK_UMEM__DEFAULT_FRAME_SIZE: u32 = 4096;
pub const XSK_UMEM__DEFAULT_FRAME_HEADROOM: u32 = 0;
pub const XSK_UMEM__DEFAULT_FLAGS: u32 = 0;
pub const XSK_LIBBPF_FLAGS__INHIBIT_PROG_LOAD: u32 = 1;
pub type size_t = ::std::os::raw::c_ulong;
pub type __pid_t = ::std::os::raw::c_int;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
pub type __be16 = __u16;
pub type __be32 = __u32;
pub const XDP_ATTACHED_NONE: ::std::os::raw::c_uint = 0;
pub const XDP_ATTACHED_DRV: ::std::os::raw::c_uint = 1;
pub const XDP_ATTACHED_SKB: ::std::os::raw::c_uint = 2;
pub const XDP_ATTACHED_HW: ::std::os::raw::c_uint = 3;
pub const XDP_ATTACHED_MULTI: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_39 = ::std::os::raw::c_uint;
pub const BPF_REG_0: ::std::os::raw::c_uint = 0;
pub const BPF_REG_1: ::std::os::raw::c_uint = 1;
pub const BPF_REG_2: ::std::os::raw::c_uint = 2;
pub const BPF_REG_3: ::std::os::raw::c_uint = 3;
pub const BPF_REG_4: ::std::os::raw::c_uint = 4;
pub const BPF_REG_5: ::std::os::raw::c_uint = 5;
pub const BPF_REG_6: ::std::os::raw::c_uint = 6;
pub const BPF_REG_7: ::std::os::raw::c_uint = 7;
pub const BPF_REG_8: ::std::os::raw::c_uint = 8;
pub const BPF_REG_9: ::std::os::raw::c_uint = 9;
pub const BPF_REG_10: ::std::os::raw::c_uint = 10;
pub const __MAX_BPF_REG: ::std::os::raw::c_uint = 11;
pub type _bindgen_ty_44 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_insn {
    pub code: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub off: __s16,
    pub imm: __s32,
}
impl bpf_insn {
    #[inline]
    pub fn dst_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_dst_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn src_reg(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_src_reg(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(dst_reg: __u8, src_reg: __u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let dst_reg: u8 = unsafe { ::std::mem::transmute(dst_reg) };
            dst_reg as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let src_reg: u8 = unsafe { ::std::mem::transmute(src_reg) };
            src_reg as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_lpm_trie_key {
    pub prefixlen: __u32,
    pub data: __IncompleteArrayField<__u8>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_cgroup_storage_key {
    pub cgroup_inode_id: __u64,
    pub attach_type: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_iter_link_info {
    pub map: bpf_iter_link_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_iter_link_info__bindgen_ty_1 {
    pub map_fd: __u32,
}
impl Default for bpf_iter_link_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BPF_MAP_CREATE: bpf_cmd = 0;
pub const BPF_MAP_LOOKUP_ELEM: bpf_cmd = 1;
pub const BPF_MAP_UPDATE_ELEM: bpf_cmd = 2;
pub const BPF_MAP_DELETE_ELEM: bpf_cmd = 3;
pub const BPF_MAP_GET_NEXT_KEY: bpf_cmd = 4;
pub const BPF_PROG_LOAD: bpf_cmd = 5;
pub const BPF_OBJ_PIN: bpf_cmd = 6;
pub const BPF_OBJ_GET: bpf_cmd = 7;
pub const BPF_PROG_ATTACH: bpf_cmd = 8;
pub const BPF_PROG_DETACH: bpf_cmd = 9;
pub const BPF_PROG_TEST_RUN: bpf_cmd = 10;
pub const BPF_PROG_RUN: bpf_cmd = 10;
pub const BPF_PROG_GET_NEXT_ID: bpf_cmd = 11;
pub const BPF_MAP_GET_NEXT_ID: bpf_cmd = 12;
pub const BPF_PROG_GET_FD_BY_ID: bpf_cmd = 13;
pub const BPF_MAP_GET_FD_BY_ID: bpf_cmd = 14;
pub const BPF_OBJ_GET_INFO_BY_FD: bpf_cmd = 15;
pub const BPF_PROG_QUERY: bpf_cmd = 16;
pub const BPF_RAW_TRACEPOINT_OPEN: bpf_cmd = 17;
pub const BPF_BTF_LOAD: bpf_cmd = 18;
pub const BPF_BTF_GET_FD_BY_ID: bpf_cmd = 19;
pub const BPF_TASK_FD_QUERY: bpf_cmd = 20;
pub const BPF_MAP_LOOKUP_AND_DELETE_ELEM: bpf_cmd = 21;
pub const BPF_MAP_FREEZE: bpf_cmd = 22;
pub const BPF_BTF_GET_NEXT_ID: bpf_cmd = 23;
pub const BPF_MAP_LOOKUP_BATCH: bpf_cmd = 24;
pub const BPF_MAP_LOOKUP_AND_DELETE_BATCH: bpf_cmd = 25;
pub const BPF_MAP_UPDATE_BATCH: bpf_cmd = 26;
pub const BPF_MAP_DELETE_BATCH: bpf_cmd = 27;
pub const BPF_LINK_CREATE: bpf_cmd = 28;
pub const BPF_LINK_UPDATE: bpf_cmd = 29;
pub const BPF_LINK_GET_FD_BY_ID: bpf_cmd = 30;
pub const BPF_LINK_GET_NEXT_ID: bpf_cmd = 31;
pub const BPF_ENABLE_STATS: bpf_cmd = 32;
pub const BPF_ITER_CREATE: bpf_cmd = 33;
pub const BPF_LINK_DETACH: bpf_cmd = 34;
pub const BPF_PROG_BIND_MAP: bpf_cmd = 35;
pub type bpf_cmd = ::std::os::raw::c_uint;
pub const BPF_MAP_TYPE_UNSPEC: bpf_map_type = 0;
pub const BPF_MAP_TYPE_HASH: bpf_map_type = 1;
pub const BPF_MAP_TYPE_ARRAY: bpf_map_type = 2;
pub const BPF_MAP_TYPE_PROG_ARRAY: bpf_map_type = 3;
pub const BPF_MAP_TYPE_PERF_EVENT_ARRAY: bpf_map_type = 4;
pub const BPF_MAP_TYPE_PERCPU_HASH: bpf_map_type = 5;
pub const BPF_MAP_TYPE_PERCPU_ARRAY: bpf_map_type = 6;
pub const BPF_MAP_TYPE_STACK_TRACE: bpf_map_type = 7;
pub const BPF_MAP_TYPE_CGROUP_ARRAY: bpf_map_type = 8;
pub const BPF_MAP_TYPE_LRU_HASH: bpf_map_type = 9;
pub const BPF_MAP_TYPE_LRU_PERCPU_HASH: bpf_map_type = 10;
pub const BPF_MAP_TYPE_LPM_TRIE: bpf_map_type = 11;
pub const BPF_MAP_TYPE_ARRAY_OF_MAPS: bpf_map_type = 12;
pub const BPF_MAP_TYPE_HASH_OF_MAPS: bpf_map_type = 13;
pub const BPF_MAP_TYPE_DEVMAP: bpf_map_type = 14;
pub const BPF_MAP_TYPE_SOCKMAP: bpf_map_type = 15;
pub const BPF_MAP_TYPE_CPUMAP: bpf_map_type = 16;
pub const BPF_MAP_TYPE_XSKMAP: bpf_map_type = 17;
pub const BPF_MAP_TYPE_SOCKHASH: bpf_map_type = 18;
pub const BPF_MAP_TYPE_CGROUP_STORAGE: bpf_map_type = 19;
pub const BPF_MAP_TYPE_REUSEPORT_SOCKARRAY: bpf_map_type = 20;
pub const BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE: bpf_map_type = 21;
pub const BPF_MAP_TYPE_QUEUE: bpf_map_type = 22;
pub const BPF_MAP_TYPE_STACK: bpf_map_type = 23;
pub const BPF_MAP_TYPE_SK_STORAGE: bpf_map_type = 24;
pub const BPF_MAP_TYPE_DEVMAP_HASH: bpf_map_type = 25;
pub const BPF_MAP_TYPE_STRUCT_OPS: bpf_map_type = 26;
pub const BPF_MAP_TYPE_RINGBUF: bpf_map_type = 27;
pub const BPF_MAP_TYPE_INODE_STORAGE: bpf_map_type = 28;
pub const BPF_MAP_TYPE_TASK_STORAGE: bpf_map_type = 29;
pub type bpf_map_type = ::std::os::raw::c_uint;
pub const BPF_PROG_TYPE_UNSPEC: bpf_prog_type = 0;
pub const BPF_PROG_TYPE_SOCKET_FILTER: bpf_prog_type = 1;
pub const BPF_PROG_TYPE_KPROBE: bpf_prog_type = 2;
pub const BPF_PROG_TYPE_SCHED_CLS: bpf_prog_type = 3;
pub const BPF_PROG_TYPE_SCHED_ACT: bpf_prog_type = 4;
pub const BPF_PROG_TYPE_TRACEPOINT: bpf_prog_type = 5;
pub const BPF_PROG_TYPE_XDP: bpf_prog_type = 6;
pub const BPF_PROG_TYPE_PERF_EVENT: bpf_prog_type = 7;
pub const BPF_PROG_TYPE_CGROUP_SKB: bpf_prog_type = 8;
pub const BPF_PROG_TYPE_CGROUP_SOCK: bpf_prog_type = 9;
pub const BPF_PROG_TYPE_LWT_IN: bpf_prog_type = 10;
pub const BPF_PROG_TYPE_LWT_OUT: bpf_prog_type = 11;
pub const BPF_PROG_TYPE_LWT_XMIT: bpf_prog_type = 12;
pub const BPF_PROG_TYPE_SOCK_OPS: bpf_prog_type = 13;
pub const BPF_PROG_TYPE_SK_SKB: bpf_prog_type = 14;
pub const BPF_PROG_TYPE_CGROUP_DEVICE: bpf_prog_type = 15;
pub const BPF_PROG_TYPE_SK_MSG: bpf_prog_type = 16;
pub const BPF_PROG_TYPE_RAW_TRACEPOINT: bpf_prog_type = 17;
pub const BPF_PROG_TYPE_CGROUP_SOCK_ADDR: bpf_prog_type = 18;
pub const BPF_PROG_TYPE_LWT_SEG6LOCAL: bpf_prog_type = 19;
pub const BPF_PROG_TYPE_LIRC_MODE2: bpf_prog_type = 20;
pub const BPF_PROG_TYPE_SK_REUSEPORT: bpf_prog_type = 21;
pub const BPF_PROG_TYPE_FLOW_DISSECTOR: bpf_prog_type = 22;
pub const BPF_PROG_TYPE_CGROUP_SYSCTL: bpf_prog_type = 23;
pub const BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE: bpf_prog_type = 24;
pub const BPF_PROG_TYPE_CGROUP_SOCKOPT: bpf_prog_type = 25;
pub const BPF_PROG_TYPE_TRACING: bpf_prog_type = 26;
pub const BPF_PROG_TYPE_STRUCT_OPS: bpf_prog_type = 27;
pub const BPF_PROG_TYPE_EXT: bpf_prog_type = 28;
pub const BPF_PROG_TYPE_LSM: bpf_prog_type = 29;
pub const BPF_PROG_TYPE_SK_LOOKUP: bpf_prog_type = 30;
pub const BPF_PROG_TYPE_SYSCALL: bpf_prog_type = 31;
pub type bpf_prog_type = ::std::os::raw::c_uint;
pub const BPF_CGROUP_INET_INGRESS: bpf_attach_type = 0;
pub const BPF_CGROUP_INET_EGRESS: bpf_attach_type = 1;
pub const BPF_CGROUP_INET_SOCK_CREATE: bpf_attach_type = 2;
pub const BPF_CGROUP_SOCK_OPS: bpf_attach_type = 3;
pub const BPF_SK_SKB_STREAM_PARSER: bpf_attach_type = 4;
pub const BPF_SK_SKB_STREAM_VERDICT: bpf_attach_type = 5;
pub const BPF_CGROUP_DEVICE: bpf_attach_type = 6;
pub const BPF_SK_MSG_VERDICT: bpf_attach_type = 7;
pub const BPF_CGROUP_INET4_BIND: bpf_attach_type = 8;
pub const BPF_CGROUP_INET6_BIND: bpf_attach_type = 9;
pub const BPF_CGROUP_INET4_CONNECT: bpf_attach_type = 10;
pub const BPF_CGROUP_INET6_CONNECT: bpf_attach_type = 11;
pub const BPF_CGROUP_INET4_POST_BIND: bpf_attach_type = 12;
pub const BPF_CGROUP_INET6_POST_BIND: bpf_attach_type = 13;
pub const BPF_CGROUP_UDP4_SENDMSG: bpf_attach_type = 14;
pub const BPF_CGROUP_UDP6_SENDMSG: bpf_attach_type = 15;
pub const BPF_LIRC_MODE2: bpf_attach_type = 16;
pub const BPF_FLOW_DISSECTOR: bpf_attach_type = 17;
pub const BPF_CGROUP_SYSCTL: bpf_attach_type = 18;
pub const BPF_CGROUP_UDP4_RECVMSG: bpf_attach_type = 19;
pub const BPF_CGROUP_UDP6_RECVMSG: bpf_attach_type = 20;
pub const BPF_CGROUP_GETSOCKOPT: bpf_attach_type = 21;
pub const BPF_CGROUP_SETSOCKOPT: bpf_attach_type = 22;
pub const BPF_TRACE_RAW_TP: bpf_attach_type = 23;
pub const BPF_TRACE_FENTRY: bpf_attach_type = 24;
pub const BPF_TRACE_FEXIT: bpf_attach_type = 25;
pub const BPF_MODIFY_RETURN: bpf_attach_type = 26;
pub const BPF_LSM_MAC: bpf_attach_type = 27;
pub const BPF_TRACE_ITER: bpf_attach_type = 28;
pub const BPF_CGROUP_INET4_GETPEERNAME: bpf_attach_type = 29;
pub const BPF_CGROUP_INET6_GETPEERNAME: bpf_attach_type = 30;
pub const BPF_CGROUP_INET4_GETSOCKNAME: bpf_attach_type = 31;
pub const BPF_CGROUP_INET6_GETSOCKNAME: bpf_attach_type = 32;
pub const BPF_XDP_DEVMAP: bpf_attach_type = 33;
pub const BPF_CGROUP_INET_SOCK_RELEASE: bpf_attach_type = 34;
pub const BPF_XDP_CPUMAP: bpf_attach_type = 35;
pub const BPF_SK_LOOKUP: bpf_attach_type = 36;
pub const BPF_XDP: bpf_attach_type = 37;
pub const BPF_SK_SKB_VERDICT: bpf_attach_type = 38;
pub const BPF_SK_REUSEPORT_SELECT: bpf_attach_type = 39;
pub const BPF_SK_REUSEPORT_SELECT_OR_MIGRATE: bpf_attach_type = 40;
pub const BPF_PERF_EVENT: bpf_attach_type = 41;
pub const __MAX_BPF_ATTACH_TYPE: bpf_attach_type = 42;
pub type bpf_attach_type = ::std::os::raw::c_uint;
pub const BPF_LINK_TYPE_UNSPEC: bpf_link_type = 0;
pub const BPF_LINK_TYPE_RAW_TRACEPOINT: bpf_link_type = 1;
pub const BPF_LINK_TYPE_TRACING: bpf_link_type = 2;
pub const BPF_LINK_TYPE_CGROUP: bpf_link_type = 3;
pub const BPF_LINK_TYPE_ITER: bpf_link_type = 4;
pub const BPF_LINK_TYPE_NETNS: bpf_link_type = 5;
pub const BPF_LINK_TYPE_XDP: bpf_link_type = 6;
pub const BPF_LINK_TYPE_PERF_EVENT: bpf_link_type = 7;
pub const MAX_BPF_LINK_TYPE: bpf_link_type = 8;
pub type bpf_link_type = ::std::os::raw::c_uint;
pub const BPF_ANY: ::std::os::raw::c_uint = 0;
pub const BPF_NOEXIST: ::std::os::raw::c_uint = 1;
pub const BPF_EXIST: ::std::os::raw::c_uint = 2;
pub const BPF_F_LOCK: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_45 = ::std::os::raw::c_uint;
pub const BPF_F_NO_PREALLOC: ::std::os::raw::c_uint = 1;
pub const BPF_F_NO_COMMON_LRU: ::std::os::raw::c_uint = 2;
pub const BPF_F_NUMA_NODE: ::std::os::raw::c_uint = 4;
pub const BPF_F_RDONLY: ::std::os::raw::c_uint = 8;
pub const BPF_F_WRONLY: ::std::os::raw::c_uint = 16;
pub const BPF_F_STACK_BUILD_ID: ::std::os::raw::c_uint = 32;
pub const BPF_F_ZERO_SEED: ::std::os::raw::c_uint = 64;
pub const BPF_F_RDONLY_PROG: ::std::os::raw::c_uint = 128;
pub const BPF_F_WRONLY_PROG: ::std::os::raw::c_uint = 256;
pub const BPF_F_CLONE: ::std::os::raw::c_uint = 512;
pub const BPF_F_MMAPABLE: ::std::os::raw::c_uint = 1024;
pub const BPF_F_PRESERVE_ELEMS: ::std::os::raw::c_uint = 2048;
pub const BPF_F_INNER_MAP: ::std::os::raw::c_uint = 4096;
pub type _bindgen_ty_46 = ::std::os::raw::c_uint;
pub const BPF_STATS_RUN_TIME: bpf_stats_type = 0;
pub type bpf_stats_type = ::std::os::raw::c_uint;
pub const BPF_STACK_BUILD_ID_EMPTY: bpf_stack_build_id_status = 0;
pub const BPF_STACK_BUILD_ID_VALID: bpf_stack_build_id_status = 1;
pub const BPF_STACK_BUILD_ID_IP: bpf_stack_build_id_status = 2;
pub type bpf_stack_build_id_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_stack_build_id {
    pub status: __s32,
    pub build_id: [::std::os::raw::c_uchar; 20usize],
    pub __bindgen_anon_1: bpf_stack_build_id__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_stack_build_id__bindgen_ty_1 {
    pub offset: __u64,
    pub ip: __u64,
}
impl Default for bpf_stack_build_id__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_stack_build_id {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr {
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_attr__bindgen_ty_2,
    pub batch: bpf_attr__bindgen_ty_3,
    pub __bindgen_anon_3: bpf_attr__bindgen_ty_4,
    pub __bindgen_anon_4: bpf_attr__bindgen_ty_5,
    pub __bindgen_anon_5: bpf_attr__bindgen_ty_6,
    pub test: bpf_attr__bindgen_ty_7,
    pub __bindgen_anon_6: bpf_attr__bindgen_ty_8,
    pub info: bpf_attr__bindgen_ty_9,
    pub query: bpf_attr__bindgen_ty_10,
    pub raw_tracepoint: bpf_attr__bindgen_ty_11,
    pub __bindgen_anon_7: bpf_attr__bindgen_ty_12,
    pub task_fd_query: bpf_attr__bindgen_ty_13,
    pub link_create: bpf_attr__bindgen_ty_14,
    pub link_update: bpf_attr__bindgen_ty_15,
    pub link_detach: bpf_attr__bindgen_ty_16,
    pub enable_stats: bpf_attr__bindgen_ty_17,
    pub iter_create: bpf_attr__bindgen_ty_18,
    pub prog_bind_map: bpf_attr__bindgen_ty_19,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_1 {
    pub map_type: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub map_flags: __u32,
    pub inner_map_fd: __u32,
    pub numa_node: __u32,
    pub map_name: [::std::os::raw::c_char; 16usize],
    pub map_ifindex: __u32,
    pub btf_fd: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
    pub btf_vmlinux_value_type_id: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_2 {
    pub map_fd: __u32,
    pub key: __u64,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_2__bindgen_ty_1,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    pub value: __u64,
    pub next_key: __u64,
}
impl Default for bpf_attr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_attr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_3 {
    pub in_batch: __u64,
    pub out_batch: __u64,
    pub keys: __u64,
    pub values: __u64,
    pub count: __u32,
    pub map_fd: __u32,
    pub elem_flags: __u64,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_4 {
    pub prog_type: __u32,
    pub insn_cnt: __u32,
    pub insns: __u64,
    pub license: __u64,
    pub log_level: __u32,
    pub log_size: __u32,
    pub log_buf: __u64,
    pub kern_version: __u32,
    pub prog_flags: __u32,
    pub prog_name: [::std::os::raw::c_char; 16usize],
    pub prog_ifindex: __u32,
    pub expected_attach_type: __u32,
    pub prog_btf_fd: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: __u64,
    pub func_info_cnt: __u32,
    pub line_info_rec_size: __u32,
    pub line_info: __u64,
    pub line_info_cnt: __u32,
    pub attach_btf_id: __u32,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_4__bindgen_ty_1,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub fd_array: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_4__bindgen_ty_1 {
    pub attach_prog_fd: __u32,
    pub attach_btf_obj_fd: __u32,
}
impl Default for bpf_attr__bindgen_ty_4__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_attr__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_attr__bindgen_ty_4 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_5 {
    pub pathname: __u64,
    pub bpf_fd: __u32,
    pub file_flags: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_6 {
    pub target_fd: __u32,
    pub attach_bpf_fd: __u32,
    pub attach_type: __u32,
    pub attach_flags: __u32,
    pub replace_bpf_fd: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_7 {
    pub prog_fd: __u32,
    pub retval: __u32,
    pub data_size_in: __u32,
    pub data_size_out: __u32,
    pub data_in: __u64,
    pub data_out: __u64,
    pub repeat: __u32,
    pub duration: __u32,
    pub ctx_size_in: __u32,
    pub ctx_size_out: __u32,
    pub ctx_in: __u64,
    pub ctx_out: __u64,
    pub flags: __u32,
    pub cpu: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_8 {
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_8__bindgen_ty_1,
    pub next_id: __u32,
    pub open_flags: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_8__bindgen_ty_1 {
    pub start_id: __u32,
    pub prog_id: __u32,
    pub map_id: __u32,
    pub btf_id: __u32,
    pub link_id: __u32,
}
impl Default for bpf_attr__bindgen_ty_8__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_attr__bindgen_ty_8 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_9 {
    pub bpf_fd: __u32,
    pub info_len: __u32,
    pub info: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_10 {
    pub target_fd: __u32,
    pub attach_type: __u32,
    pub query_flags: __u32,
    pub attach_flags: __u32,
    pub prog_ids: __u64,
    pub prog_cnt: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_11 {
    pub name: __u64,
    pub prog_fd: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_12 {
    pub btf: __u64,
    pub btf_log_buf: __u64,
    pub btf_size: __u32,
    pub btf_log_size: __u32,
    pub btf_log_level: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_13 {
    pub pid: __u32,
    pub fd: __u32,
    pub flags: __u32,
    pub buf_len: __u32,
    pub buf: __u64,
    pub prog_id: __u32,
    pub fd_type: __u32,
    pub probe_offset: __u64,
    pub probe_addr: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_attr__bindgen_ty_14 {
    pub prog_fd: __u32,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_14__bindgen_ty_1,
    pub attach_type: __u32,
    pub flags: __u32,
    pub __bindgen_anon_2: bpf_attr__bindgen_ty_14__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_14__bindgen_ty_1 {
    pub target_fd: __u32,
    pub target_ifindex: __u32,
}
impl Default for bpf_attr__bindgen_ty_14__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_attr__bindgen_ty_14__bindgen_ty_2 {
    pub target_btf_id: __u32,
    pub __bindgen_anon_1: bpf_attr__bindgen_ty_14__bindgen_ty_2__bindgen_ty_1,
    pub perf_event: bpf_attr__bindgen_ty_14__bindgen_ty_2__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_14__bindgen_ty_2__bindgen_ty_1 {
    pub iter_info: __u64,
    pub iter_info_len: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_14__bindgen_ty_2__bindgen_ty_2 {
    pub bpf_cookie: __u64,
}
impl Default for bpf_attr__bindgen_ty_14__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_attr__bindgen_ty_14 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_15 {
    pub link_fd: __u32,
    pub new_prog_fd: __u32,
    pub flags: __u32,
    pub old_prog_fd: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_16 {
    pub link_fd: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_17 {
    pub type_: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_18 {
    pub link_fd: __u32,
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_attr__bindgen_ty_19 {
    pub prog_fd: __u32,
    pub map_fd: __u32,
    pub flags: __u32,
}
impl Default for bpf_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BPF_FUNC_unspec: bpf_func_id = 0;
pub const BPF_FUNC_map_lookup_elem: bpf_func_id = 1;
pub const BPF_FUNC_map_update_elem: bpf_func_id = 2;
pub const BPF_FUNC_map_delete_elem: bpf_func_id = 3;
pub const BPF_FUNC_probe_read: bpf_func_id = 4;
pub const BPF_FUNC_ktime_get_ns: bpf_func_id = 5;
pub const BPF_FUNC_trace_printk: bpf_func_id = 6;
pub const BPF_FUNC_get_prandom_u32: bpf_func_id = 7;
pub const BPF_FUNC_get_smp_processor_id: bpf_func_id = 8;
pub const BPF_FUNC_skb_store_bytes: bpf_func_id = 9;
pub const BPF_FUNC_l3_csum_replace: bpf_func_id = 10;
pub const BPF_FUNC_l4_csum_replace: bpf_func_id = 11;
pub const BPF_FUNC_tail_call: bpf_func_id = 12;
pub const BPF_FUNC_clone_redirect: bpf_func_id = 13;
pub const BPF_FUNC_get_current_pid_tgid: bpf_func_id = 14;
pub const BPF_FUNC_get_current_uid_gid: bpf_func_id = 15;
pub const BPF_FUNC_get_current_comm: bpf_func_id = 16;
pub const BPF_FUNC_get_cgroup_classid: bpf_func_id = 17;
pub const BPF_FUNC_skb_vlan_push: bpf_func_id = 18;
pub const BPF_FUNC_skb_vlan_pop: bpf_func_id = 19;
pub const BPF_FUNC_skb_get_tunnel_key: bpf_func_id = 20;
pub const BPF_FUNC_skb_set_tunnel_key: bpf_func_id = 21;
pub const BPF_FUNC_perf_event_read: bpf_func_id = 22;
pub const BPF_FUNC_redirect: bpf_func_id = 23;
pub const BPF_FUNC_get_route_realm: bpf_func_id = 24;
pub const BPF_FUNC_perf_event_output: bpf_func_id = 25;
pub const BPF_FUNC_skb_load_bytes: bpf_func_id = 26;
pub const BPF_FUNC_get_stackid: bpf_func_id = 27;
pub const BPF_FUNC_csum_diff: bpf_func_id = 28;
pub const BPF_FUNC_skb_get_tunnel_opt: bpf_func_id = 29;
pub const BPF_FUNC_skb_set_tunnel_opt: bpf_func_id = 30;
pub const BPF_FUNC_skb_change_proto: bpf_func_id = 31;
pub const BPF_FUNC_skb_change_type: bpf_func_id = 32;
pub const BPF_FUNC_skb_under_cgroup: bpf_func_id = 33;
pub const BPF_FUNC_get_hash_recalc: bpf_func_id = 34;
pub const BPF_FUNC_get_current_task: bpf_func_id = 35;
pub const BPF_FUNC_probe_write_user: bpf_func_id = 36;
pub const BPF_FUNC_current_task_under_cgroup: bpf_func_id = 37;
pub const BPF_FUNC_skb_change_tail: bpf_func_id = 38;
pub const BPF_FUNC_skb_pull_data: bpf_func_id = 39;
pub const BPF_FUNC_csum_update: bpf_func_id = 40;
pub const BPF_FUNC_set_hash_invalid: bpf_func_id = 41;
pub const BPF_FUNC_get_numa_node_id: bpf_func_id = 42;
pub const BPF_FUNC_skb_change_head: bpf_func_id = 43;
pub const BPF_FUNC_xdp_adjust_head: bpf_func_id = 44;
pub const BPF_FUNC_probe_read_str: bpf_func_id = 45;
pub const BPF_FUNC_get_socket_cookie: bpf_func_id = 46;
pub const BPF_FUNC_get_socket_uid: bpf_func_id = 47;
pub const BPF_FUNC_set_hash: bpf_func_id = 48;
pub const BPF_FUNC_setsockopt: bpf_func_id = 49;
pub const BPF_FUNC_skb_adjust_room: bpf_func_id = 50;
pub const BPF_FUNC_redirect_map: bpf_func_id = 51;
pub const BPF_FUNC_sk_redirect_map: bpf_func_id = 52;
pub const BPF_FUNC_sock_map_update: bpf_func_id = 53;
pub const BPF_FUNC_xdp_adjust_meta: bpf_func_id = 54;
pub const BPF_FUNC_perf_event_read_value: bpf_func_id = 55;
pub const BPF_FUNC_perf_prog_read_value: bpf_func_id = 56;
pub const BPF_FUNC_getsockopt: bpf_func_id = 57;
pub const BPF_FUNC_override_return: bpf_func_id = 58;
pub const BPF_FUNC_sock_ops_cb_flags_set: bpf_func_id = 59;
pub const BPF_FUNC_msg_redirect_map: bpf_func_id = 60;
pub const BPF_FUNC_msg_apply_bytes: bpf_func_id = 61;
pub const BPF_FUNC_msg_cork_bytes: bpf_func_id = 62;
pub const BPF_FUNC_msg_pull_data: bpf_func_id = 63;
pub const BPF_FUNC_bind: bpf_func_id = 64;
pub const BPF_FUNC_xdp_adjust_tail: bpf_func_id = 65;
pub const BPF_FUNC_skb_get_xfrm_state: bpf_func_id = 66;
pub const BPF_FUNC_get_stack: bpf_func_id = 67;
pub const BPF_FUNC_skb_load_bytes_relative: bpf_func_id = 68;
pub const BPF_FUNC_fib_lookup: bpf_func_id = 69;
pub const BPF_FUNC_sock_hash_update: bpf_func_id = 70;
pub const BPF_FUNC_msg_redirect_hash: bpf_func_id = 71;
pub const BPF_FUNC_sk_redirect_hash: bpf_func_id = 72;
pub const BPF_FUNC_lwt_push_encap: bpf_func_id = 73;
pub const BPF_FUNC_lwt_seg6_store_bytes: bpf_func_id = 74;
pub const BPF_FUNC_lwt_seg6_adjust_srh: bpf_func_id = 75;
pub const BPF_FUNC_lwt_seg6_action: bpf_func_id = 76;
pub const BPF_FUNC_rc_repeat: bpf_func_id = 77;
pub const BPF_FUNC_rc_keydown: bpf_func_id = 78;
pub const BPF_FUNC_skb_cgroup_id: bpf_func_id = 79;
pub const BPF_FUNC_get_current_cgroup_id: bpf_func_id = 80;
pub const BPF_FUNC_get_local_storage: bpf_func_id = 81;
pub const BPF_FUNC_sk_select_reuseport: bpf_func_id = 82;
pub const BPF_FUNC_skb_ancestor_cgroup_id: bpf_func_id = 83;
pub const BPF_FUNC_sk_lookup_tcp: bpf_func_id = 84;
pub const BPF_FUNC_sk_lookup_udp: bpf_func_id = 85;
pub const BPF_FUNC_sk_release: bpf_func_id = 86;
pub const BPF_FUNC_map_push_elem: bpf_func_id = 87;
pub const BPF_FUNC_map_pop_elem: bpf_func_id = 88;
pub const BPF_FUNC_map_peek_elem: bpf_func_id = 89;
pub const BPF_FUNC_msg_push_data: bpf_func_id = 90;
pub const BPF_FUNC_msg_pop_data: bpf_func_id = 91;
pub const BPF_FUNC_rc_pointer_rel: bpf_func_id = 92;
pub const BPF_FUNC_spin_lock: bpf_func_id = 93;
pub const BPF_FUNC_spin_unlock: bpf_func_id = 94;
pub const BPF_FUNC_sk_fullsock: bpf_func_id = 95;
pub const BPF_FUNC_tcp_sock: bpf_func_id = 96;
pub const BPF_FUNC_skb_ecn_set_ce: bpf_func_id = 97;
pub const BPF_FUNC_get_listener_sock: bpf_func_id = 98;
pub const BPF_FUNC_skc_lookup_tcp: bpf_func_id = 99;
pub const BPF_FUNC_tcp_check_syncookie: bpf_func_id = 100;
pub const BPF_FUNC_sysctl_get_name: bpf_func_id = 101;
pub const BPF_FUNC_sysctl_get_current_value: bpf_func_id = 102;
pub const BPF_FUNC_sysctl_get_new_value: bpf_func_id = 103;
pub const BPF_FUNC_sysctl_set_new_value: bpf_func_id = 104;
pub const BPF_FUNC_strtol: bpf_func_id = 105;
pub const BPF_FUNC_strtoul: bpf_func_id = 106;
pub const BPF_FUNC_sk_storage_get: bpf_func_id = 107;
pub const BPF_FUNC_sk_storage_delete: bpf_func_id = 108;
pub const BPF_FUNC_send_signal: bpf_func_id = 109;
pub const BPF_FUNC_tcp_gen_syncookie: bpf_func_id = 110;
pub const BPF_FUNC_skb_output: bpf_func_id = 111;
pub const BPF_FUNC_probe_read_user: bpf_func_id = 112;
pub const BPF_FUNC_probe_read_kernel: bpf_func_id = 113;
pub const BPF_FUNC_probe_read_user_str: bpf_func_id = 114;
pub const BPF_FUNC_probe_read_kernel_str: bpf_func_id = 115;
pub const BPF_FUNC_tcp_send_ack: bpf_func_id = 116;
pub const BPF_FUNC_send_signal_thread: bpf_func_id = 117;
pub const BPF_FUNC_jiffies64: bpf_func_id = 118;
pub const BPF_FUNC_read_branch_records: bpf_func_id = 119;
pub const BPF_FUNC_get_ns_current_pid_tgid: bpf_func_id = 120;
pub const BPF_FUNC_xdp_output: bpf_func_id = 121;
pub const BPF_FUNC_get_netns_cookie: bpf_func_id = 122;
pub const BPF_FUNC_get_current_ancestor_cgroup_id: bpf_func_id = 123;
pub const BPF_FUNC_sk_assign: bpf_func_id = 124;
pub const BPF_FUNC_ktime_get_boot_ns: bpf_func_id = 125;
pub const BPF_FUNC_seq_printf: bpf_func_id = 126;
pub const BPF_FUNC_seq_write: bpf_func_id = 127;
pub const BPF_FUNC_sk_cgroup_id: bpf_func_id = 128;
pub const BPF_FUNC_sk_ancestor_cgroup_id: bpf_func_id = 129;
pub const BPF_FUNC_ringbuf_output: bpf_func_id = 130;
pub const BPF_FUNC_ringbuf_reserve: bpf_func_id = 131;
pub const BPF_FUNC_ringbuf_submit: bpf_func_id = 132;
pub const BPF_FUNC_ringbuf_discard: bpf_func_id = 133;
pub const BPF_FUNC_ringbuf_query: bpf_func_id = 134;
pub const BPF_FUNC_csum_level: bpf_func_id = 135;
pub const BPF_FUNC_skc_to_tcp6_sock: bpf_func_id = 136;
pub const BPF_FUNC_skc_to_tcp_sock: bpf_func_id = 137;
pub const BPF_FUNC_skc_to_tcp_timewait_sock: bpf_func_id = 138;
pub const BPF_FUNC_skc_to_tcp_request_sock: bpf_func_id = 139;
pub const BPF_FUNC_skc_to_udp6_sock: bpf_func_id = 140;
pub const BPF_FUNC_get_task_stack: bpf_func_id = 141;
pub const BPF_FUNC_load_hdr_opt: bpf_func_id = 142;
pub const BPF_FUNC_store_hdr_opt: bpf_func_id = 143;
pub const BPF_FUNC_reserve_hdr_opt: bpf_func_id = 144;
pub const BPF_FUNC_inode_storage_get: bpf_func_id = 145;
pub const BPF_FUNC_inode_storage_delete: bpf_func_id = 146;
pub const BPF_FUNC_d_path: bpf_func_id = 147;
pub const BPF_FUNC_copy_from_user: bpf_func_id = 148;
pub const BPF_FUNC_snprintf_btf: bpf_func_id = 149;
pub const BPF_FUNC_seq_printf_btf: bpf_func_id = 150;
pub const BPF_FUNC_skb_cgroup_classid: bpf_func_id = 151;
pub const BPF_FUNC_redirect_neigh: bpf_func_id = 152;
pub const BPF_FUNC_per_cpu_ptr: bpf_func_id = 153;
pub const BPF_FUNC_this_cpu_ptr: bpf_func_id = 154;
pub const BPF_FUNC_redirect_peer: bpf_func_id = 155;
pub const BPF_FUNC_task_storage_get: bpf_func_id = 156;
pub const BPF_FUNC_task_storage_delete: bpf_func_id = 157;
pub const BPF_FUNC_get_current_task_btf: bpf_func_id = 158;
pub const BPF_FUNC_bprm_opts_set: bpf_func_id = 159;
pub const BPF_FUNC_ktime_get_coarse_ns: bpf_func_id = 160;
pub const BPF_FUNC_ima_inode_hash: bpf_func_id = 161;
pub const BPF_FUNC_sock_from_file: bpf_func_id = 162;
pub const BPF_FUNC_check_mtu: bpf_func_id = 163;
pub const BPF_FUNC_for_each_map_elem: bpf_func_id = 164;
pub const BPF_FUNC_snprintf: bpf_func_id = 165;
pub const BPF_FUNC_sys_bpf: bpf_func_id = 166;
pub const BPF_FUNC_btf_find_by_name_kind: bpf_func_id = 167;
pub const BPF_FUNC_sys_close: bpf_func_id = 168;
pub const BPF_FUNC_timer_init: bpf_func_id = 169;
pub const BPF_FUNC_timer_set_callback: bpf_func_id = 170;
pub const BPF_FUNC_timer_start: bpf_func_id = 171;
pub const BPF_FUNC_timer_cancel: bpf_func_id = 172;
pub const BPF_FUNC_get_func_ip: bpf_func_id = 173;
pub const BPF_FUNC_get_attach_cookie: bpf_func_id = 174;
pub const BPF_FUNC_task_pt_regs: bpf_func_id = 175;
pub const __BPF_FUNC_MAX_ID: bpf_func_id = 176;
pub type bpf_func_id = ::std::os::raw::c_uint;
pub const BPF_F_RECOMPUTE_CSUM: ::std::os::raw::c_uint = 1;
pub const BPF_F_INVALIDATE_HASH: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_47 = ::std::os::raw::c_uint;
pub const BPF_F_HDR_FIELD_MASK: ::std::os::raw::c_uint = 15;
pub type _bindgen_ty_48 = ::std::os::raw::c_uint;
pub const BPF_F_PSEUDO_HDR: ::std::os::raw::c_uint = 16;
pub const BPF_F_MARK_MANGLED_0: ::std::os::raw::c_uint = 32;
pub const BPF_F_MARK_ENFORCE: ::std::os::raw::c_uint = 64;
pub type _bindgen_ty_49 = ::std::os::raw::c_uint;
pub const BPF_F_INGRESS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_50 = ::std::os::raw::c_uint;
pub const BPF_F_TUNINFO_IPV6: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_51 = ::std::os::raw::c_uint;
pub const BPF_F_SKIP_FIELD_MASK: ::std::os::raw::c_uint = 255;
pub const BPF_F_USER_STACK: ::std::os::raw::c_uint = 256;
pub const BPF_F_FAST_STACK_CMP: ::std::os::raw::c_uint = 512;
pub const BPF_F_REUSE_STACKID: ::std::os::raw::c_uint = 1024;
pub const BPF_F_USER_BUILD_ID: ::std::os::raw::c_uint = 2048;
pub type _bindgen_ty_52 = ::std::os::raw::c_uint;
pub const BPF_F_ZERO_CSUM_TX: ::std::os::raw::c_uint = 2;
pub const BPF_F_DONT_FRAGMENT: ::std::os::raw::c_uint = 4;
pub const BPF_F_SEQ_NUMBER: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_53 = ::std::os::raw::c_uint;
pub const BPF_F_INDEX_MASK: ::std::os::raw::c_ulong = 4294967295;
pub const BPF_F_CURRENT_CPU: ::std::os::raw::c_ulong = 4294967295;
pub const BPF_F_CTXLEN_MASK: ::std::os::raw::c_ulong = 4503595332403200;
pub type _bindgen_ty_54 = ::std::os::raw::c_ulong;
pub const BPF_F_CURRENT_NETNS: ::std::os::raw::c_int = -1;
pub type _bindgen_ty_55 = ::std::os::raw::c_int;
pub const BPF_CSUM_LEVEL_QUERY: ::std::os::raw::c_uint = 0;
pub const BPF_CSUM_LEVEL_INC: ::std::os::raw::c_uint = 1;
pub const BPF_CSUM_LEVEL_DEC: ::std::os::raw::c_uint = 2;
pub const BPF_CSUM_LEVEL_RESET: ::std::os::raw::c_uint = 3;
pub type _bindgen_ty_56 = ::std::os::raw::c_uint;
pub const BPF_F_ADJ_ROOM_FIXED_GSO: ::std::os::raw::c_uint = 1;
pub const BPF_F_ADJ_ROOM_ENCAP_L3_IPV4: ::std::os::raw::c_uint = 2;
pub const BPF_F_ADJ_ROOM_ENCAP_L3_IPV6: ::std::os::raw::c_uint = 4;
pub const BPF_F_ADJ_ROOM_ENCAP_L4_GRE: ::std::os::raw::c_uint = 8;
pub const BPF_F_ADJ_ROOM_ENCAP_L4_UDP: ::std::os::raw::c_uint = 16;
pub const BPF_F_ADJ_ROOM_NO_CSUM_RESET: ::std::os::raw::c_uint = 32;
pub const BPF_F_ADJ_ROOM_ENCAP_L2_ETH: ::std::os::raw::c_uint = 64;
pub type _bindgen_ty_57 = ::std::os::raw::c_uint;
pub const BPF_ADJ_ROOM_ENCAP_L2_MASK: ::std::os::raw::c_uint = 255;
pub const BPF_ADJ_ROOM_ENCAP_L2_SHIFT: ::std::os::raw::c_uint = 56;
pub type _bindgen_ty_58 = ::std::os::raw::c_uint;
pub const BPF_F_SYSCTL_BASE_NAME: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_59 = ::std::os::raw::c_uint;
pub const BPF_LOCAL_STORAGE_GET_F_CREATE: ::std::os::raw::c_uint = 1;
pub const BPF_SK_STORAGE_GET_F_CREATE: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_60 = ::std::os::raw::c_uint;
pub const BPF_F_GET_BRANCH_RECORDS_SIZE: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_61 = ::std::os::raw::c_uint;
pub const BPF_RB_NO_WAKEUP: ::std::os::raw::c_uint = 1;
pub const BPF_RB_FORCE_WAKEUP: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_62 = ::std::os::raw::c_uint;
pub const BPF_RB_AVAIL_DATA: ::std::os::raw::c_uint = 0;
pub const BPF_RB_RING_SIZE: ::std::os::raw::c_uint = 1;
pub const BPF_RB_CONS_POS: ::std::os::raw::c_uint = 2;
pub const BPF_RB_PROD_POS: ::std::os::raw::c_uint = 3;
pub type _bindgen_ty_63 = ::std::os::raw::c_uint;
pub const BPF_RINGBUF_BUSY_BIT: ::std::os::raw::c_uint = 2147483648;
pub const BPF_RINGBUF_DISCARD_BIT: ::std::os::raw::c_uint = 1073741824;
pub const BPF_RINGBUF_HDR_SZ: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_64 = ::std::os::raw::c_uint;
pub const BPF_SK_LOOKUP_F_REPLACE: ::std::os::raw::c_uint = 1;
pub const BPF_SK_LOOKUP_F_NO_REUSEPORT: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_65 = ::std::os::raw::c_uint;
pub const BPF_ADJ_ROOM_NET: bpf_adj_room_mode = 0;
pub const BPF_ADJ_ROOM_MAC: bpf_adj_room_mode = 1;
pub type bpf_adj_room_mode = ::std::os::raw::c_uint;
pub const BPF_HDR_START_MAC: bpf_hdr_start_off = 0;
pub const BPF_HDR_START_NET: bpf_hdr_start_off = 1;
pub type bpf_hdr_start_off = ::std::os::raw::c_uint;
pub const BPF_LWT_ENCAP_SEG6: bpf_lwt_encap_mode = 0;
pub const BPF_LWT_ENCAP_SEG6_INLINE: bpf_lwt_encap_mode = 1;
pub const BPF_LWT_ENCAP_IP: bpf_lwt_encap_mode = 2;
pub type bpf_lwt_encap_mode = ::std::os::raw::c_uint;
pub const BPF_F_BPRM_SECUREEXEC: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_66 = ::std::os::raw::c_uint;
pub const BPF_F_BROADCAST: ::std::os::raw::c_uint = 8;
pub const BPF_F_EXCLUDE_INGRESS: ::std::os::raw::c_uint = 16;
pub type _bindgen_ty_67 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_tunnel_key {
    pub tunnel_id: __u32,
    pub __bindgen_anon_1: bpf_tunnel_key__bindgen_ty_1,
    pub tunnel_tos: __u8,
    pub tunnel_ttl: __u8,
    pub tunnel_ext: __u16,
    pub tunnel_label: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_tunnel_key__bindgen_ty_1 {
    pub remote_ipv4: __u32,
    pub remote_ipv6: [__u32; 4usize],
}
impl Default for bpf_tunnel_key__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_tunnel_key {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_xfrm_state {
    pub reqid: __u32,
    pub spi: __u32,
    pub family: __u16,
    pub ext: __u16,
    pub __bindgen_anon_1: bpf_xfrm_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_xfrm_state__bindgen_ty_1 {
    pub remote_ipv4: __u32,
    pub remote_ipv6: [__u32; 4usize],
}
impl Default for bpf_xfrm_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_xfrm_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BPF_OK: bpf_ret_code = 0;
pub const BPF_DROP: bpf_ret_code = 2;
pub const BPF_REDIRECT: bpf_ret_code = 7;
pub const BPF_LWT_REROUTE: bpf_ret_code = 128;
pub type bpf_ret_code = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_sock {
    pub bound_dev_if: __u32,
    pub family: __u32,
    pub type_: __u32,
    pub protocol: __u32,
    pub mark: __u32,
    pub priority: __u32,
    pub src_ip4: __u32,
    pub src_ip6: [__u32; 4usize],
    pub src_port: __u32,
    pub dst_port: __u32,
    pub dst_ip4: __u32,
    pub dst_ip6: [__u32; 4usize],
    pub state: __u32,
    pub rx_queue_mapping: __s32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_tcp_sock {
    pub snd_cwnd: __u32,
    pub srtt_us: __u32,
    pub rtt_min: __u32,
    pub snd_ssthresh: __u32,
    pub rcv_nxt: __u32,
    pub snd_nxt: __u32,
    pub snd_una: __u32,
    pub mss_cache: __u32,
    pub ecn_flags: __u32,
    pub rate_delivered: __u32,
    pub rate_interval_us: __u32,
    pub packets_out: __u32,
    pub retrans_out: __u32,
    pub total_retrans: __u32,
    pub segs_in: __u32,
    pub data_segs_in: __u32,
    pub segs_out: __u32,
    pub data_segs_out: __u32,
    pub lost_out: __u32,
    pub sacked_out: __u32,
    pub bytes_received: __u64,
    pub bytes_acked: __u64,
    pub dsack_dups: __u32,
    pub delivered: __u32,
    pub delivered_ce: __u32,
    pub icsk_retransmits: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_tuple {
    pub __bindgen_anon_1: bpf_sock_tuple__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_tuple__bindgen_ty_1 {
    pub ipv4: bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1,
    pub ipv6: bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_sock_tuple__bindgen_ty_1__bindgen_ty_1 {
    pub saddr: __be32,
    pub daddr: __be32,
    pub sport: __be16,
    pub dport: __be16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_sock_tuple__bindgen_ty_1__bindgen_ty_2 {
    pub saddr: [__be32; 4usize],
    pub daddr: [__be32; 4usize],
    pub sport: __be16,
    pub dport: __be16,
}
impl Default for bpf_sock_tuple__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_sock_tuple {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_xdp_sock {
    pub queue_id: __u32,
}
pub const XDP_ABORTED: xdp_action = 0;
pub const XDP_DROP: xdp_action = 1;
pub const XDP_PASS: xdp_action = 2;
pub const XDP_TX: xdp_action = 3;
pub const XDP_REDIRECT: xdp_action = 4;
pub type xdp_action = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_md {
    pub data: __u32,
    pub data_end: __u32,
    pub data_meta: __u32,
    pub ingress_ifindex: __u32,
    pub rx_queue_index: __u32,
    pub egress_ifindex: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_devmap_val {
    pub ifindex: __u32,
    pub bpf_prog: bpf_devmap_val__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_devmap_val__bindgen_ty_1 {
    pub fd: ::std::os::raw::c_int,
    pub id: __u32,
}
impl Default for bpf_devmap_val__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_devmap_val {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_cpumap_val {
    pub qsize: __u32,
    pub bpf_prog: bpf_cpumap_val__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_cpumap_val__bindgen_ty_1 {
    pub fd: ::std::os::raw::c_int,
    pub id: __u32,
}
impl Default for bpf_cpumap_val__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_cpumap_val {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_prog_info {
    pub type_: __u32,
    pub id: __u32,
    pub tag: [__u8; 8usize],
    pub jited_prog_len: __u32,
    pub xlated_prog_len: __u32,
    pub jited_prog_insns: __u64,
    pub xlated_prog_insns: __u64,
    pub load_time: __u64,
    pub created_by_uid: __u32,
    pub nr_map_ids: __u32,
    pub map_ids: __u64,
    pub name: [::std::os::raw::c_char; 16usize],
    pub ifindex: __u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub netns_dev: __u64,
    pub netns_ino: __u64,
    pub nr_jited_ksyms: __u32,
    pub nr_jited_func_lens: __u32,
    pub jited_ksyms: __u64,
    pub jited_func_lens: __u64,
    pub btf_id: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: __u64,
    pub nr_func_info: __u32,
    pub nr_line_info: __u32,
    pub line_info: __u64,
    pub jited_line_info: __u64,
    pub nr_jited_line_info: __u32,
    pub line_info_rec_size: __u32,
    pub jited_line_info_rec_size: __u32,
    pub nr_prog_tags: __u32,
    pub prog_tags: __u64,
    pub run_time_ns: __u64,
    pub run_cnt: __u64,
    pub recursion_misses: __u64,
}
impl bpf_prog_info {
    #[inline]
    pub fn gpl_compatible(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gpl_compatible(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(gpl_compatible: __u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let gpl_compatible: u32 = unsafe { ::std::mem::transmute(gpl_compatible) };
            gpl_compatible as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_map_info {
    pub type_: __u32,
    pub id: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub map_flags: __u32,
    pub name: [::std::os::raw::c_char; 16usize],
    pub ifindex: __u32,
    pub btf_vmlinux_value_type_id: __u32,
    pub netns_dev: __u64,
    pub netns_ino: __u64,
    pub btf_id: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_btf_info {
    pub btf: __u64,
    pub btf_size: __u32,
    pub id: __u32,
    pub name: __u64,
    pub name_len: __u32,
    pub kernel_btf: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_link_info {
    pub type_: __u32,
    pub id: __u32,
    pub prog_id: __u32,
    pub __bindgen_anon_1: bpf_link_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_link_info__bindgen_ty_1 {
    pub raw_tracepoint: bpf_link_info__bindgen_ty_1__bindgen_ty_1,
    pub tracing: bpf_link_info__bindgen_ty_1__bindgen_ty_2,
    pub cgroup: bpf_link_info__bindgen_ty_1__bindgen_ty_3,
    pub iter: bpf_link_info__bindgen_ty_1__bindgen_ty_4,
    pub netns: bpf_link_info__bindgen_ty_1__bindgen_ty_5,
    pub xdp: bpf_link_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_1 {
    pub tp_name: __u64,
    pub tp_name_len: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_2 {
    pub attach_type: __u32,
    pub target_obj_id: __u32,
    pub target_btf_id: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_3 {
    pub cgroup_id: __u64,
    pub attach_type: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_4 {
    pub target_name: __u64,
    pub target_name_len: __u32,
    pub __bindgen_anon_1: bpf_link_info__bindgen_ty_1__bindgen_ty_4__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_link_info__bindgen_ty_1__bindgen_ty_4__bindgen_ty_1 {
    pub map: bpf_link_info__bindgen_ty_1__bindgen_ty_4__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_4__bindgen_ty_1__bindgen_ty_1 {
    pub map_id: __u32,
}
impl Default for bpf_link_info__bindgen_ty_1__bindgen_ty_4__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_link_info__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_5 {
    pub netns_ino: __u32,
    pub attach_type: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_info__bindgen_ty_1__bindgen_ty_6 {
    pub ifindex: __u32,
}
impl Default for bpf_link_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_link_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_addr {
    pub user_family: __u32,
    pub user_ip4: __u32,
    pub user_ip6: [__u32; 4usize],
    pub user_port: __u32,
    pub family: __u32,
    pub type_: __u32,
    pub protocol: __u32,
    pub msg_src_ip4: __u32,
    pub msg_src_ip6: [__u32; 4usize],
    pub __bindgen_anon_1: bpf_sock_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_addr__bindgen_ty_1 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sock_addr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sock_addr__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
impl Default for bpf_sock_addr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sock_ops {
    pub op: __u32,
    pub __bindgen_anon_1: bpf_sock_ops__bindgen_ty_1,
    pub family: __u32,
    pub remote_ip4: __u32,
    pub local_ip4: __u32,
    pub remote_ip6: [__u32; 4usize],
    pub local_ip6: [__u32; 4usize],
    pub remote_port: __u32,
    pub local_port: __u32,
    pub is_fullsock: __u32,
    pub snd_cwnd: __u32,
    pub srtt_us: __u32,
    pub bpf_sock_ops_cb_flags: __u32,
    pub state: __u32,
    pub rtt_min: __u32,
    pub snd_ssthresh: __u32,
    pub rcv_nxt: __u32,
    pub snd_nxt: __u32,
    pub snd_una: __u32,
    pub mss_cache: __u32,
    pub ecn_flags: __u32,
    pub rate_delivered: __u32,
    pub rate_interval_us: __u32,
    pub packets_out: __u32,
    pub retrans_out: __u32,
    pub total_retrans: __u32,
    pub segs_in: __u32,
    pub data_segs_in: __u32,
    pub segs_out: __u32,
    pub data_segs_out: __u32,
    pub lost_out: __u32,
    pub sacked_out: __u32,
    pub sk_txhash: __u32,
    pub bytes_received: __u64,
    pub bytes_acked: __u64,
    pub __bindgen_anon_2: bpf_sock_ops__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_sock_ops__bindgen_ty_3,
    pub __bindgen_anon_4: bpf_sock_ops__bindgen_ty_4,
    pub skb_len: __u32,
    pub skb_tcp_flags: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_1 {
    pub args: [__u32; 4usize],
    pub reply: __u32,
    pub replylong: [__u32; 4usize],
}
impl Default for bpf_sock_ops__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_2 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sock_ops__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sock_ops__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_3 {
    pub skb_data: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sock_ops__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sock_ops__bindgen_ty_3 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sock_ops__bindgen_ty_4 {
    pub skb_data_end: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sock_ops__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sock_ops__bindgen_ty_4 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
impl Default for bpf_sock_ops {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BPF_SOCK_OPS_RTO_CB_FLAG: ::std::os::raw::c_uint = 1;
pub const BPF_SOCK_OPS_RETRANS_CB_FLAG: ::std::os::raw::c_uint = 2;
pub const BPF_SOCK_OPS_STATE_CB_FLAG: ::std::os::raw::c_uint = 4;
pub const BPF_SOCK_OPS_RTT_CB_FLAG: ::std::os::raw::c_uint = 8;
pub const BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG: ::std::os::raw::c_uint = 16;
pub const BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG: ::std::os::raw::c_uint = 32;
pub const BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG: ::std::os::raw::c_uint = 64;
pub const BPF_SOCK_OPS_ALL_CB_FLAGS: ::std::os::raw::c_uint = 127;
pub type _bindgen_ty_68 = ::std::os::raw::c_uint;
pub const BPF_SOCK_OPS_VOID: ::std::os::raw::c_uint = 0;
pub const BPF_SOCK_OPS_TIMEOUT_INIT: ::std::os::raw::c_uint = 1;
pub const BPF_SOCK_OPS_RWND_INIT: ::std::os::raw::c_uint = 2;
pub const BPF_SOCK_OPS_TCP_CONNECT_CB: ::std::os::raw::c_uint = 3;
pub const BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB: ::std::os::raw::c_uint = 4;
pub const BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB: ::std::os::raw::c_uint = 5;
pub const BPF_SOCK_OPS_NEEDS_ECN: ::std::os::raw::c_uint = 6;
pub const BPF_SOCK_OPS_BASE_RTT: ::std::os::raw::c_uint = 7;
pub const BPF_SOCK_OPS_RTO_CB: ::std::os::raw::c_uint = 8;
pub const BPF_SOCK_OPS_RETRANS_CB: ::std::os::raw::c_uint = 9;
pub const BPF_SOCK_OPS_STATE_CB: ::std::os::raw::c_uint = 10;
pub const BPF_SOCK_OPS_TCP_LISTEN_CB: ::std::os::raw::c_uint = 11;
pub const BPF_SOCK_OPS_RTT_CB: ::std::os::raw::c_uint = 12;
pub const BPF_SOCK_OPS_PARSE_HDR_OPT_CB: ::std::os::raw::c_uint = 13;
pub const BPF_SOCK_OPS_HDR_OPT_LEN_CB: ::std::os::raw::c_uint = 14;
pub const BPF_SOCK_OPS_WRITE_HDR_OPT_CB: ::std::os::raw::c_uint = 15;
pub type _bindgen_ty_69 = ::std::os::raw::c_uint;
pub const BPF_TCP_ESTABLISHED: ::std::os::raw::c_uint = 1;
pub const BPF_TCP_SYN_SENT: ::std::os::raw::c_uint = 2;
pub const BPF_TCP_SYN_RECV: ::std::os::raw::c_uint = 3;
pub const BPF_TCP_FIN_WAIT1: ::std::os::raw::c_uint = 4;
pub const BPF_TCP_FIN_WAIT2: ::std::os::raw::c_uint = 5;
pub const BPF_TCP_TIME_WAIT: ::std::os::raw::c_uint = 6;
pub const BPF_TCP_CLOSE: ::std::os::raw::c_uint = 7;
pub const BPF_TCP_CLOSE_WAIT: ::std::os::raw::c_uint = 8;
pub const BPF_TCP_LAST_ACK: ::std::os::raw::c_uint = 9;
pub const BPF_TCP_LISTEN: ::std::os::raw::c_uint = 10;
pub const BPF_TCP_CLOSING: ::std::os::raw::c_uint = 11;
pub const BPF_TCP_NEW_SYN_RECV: ::std::os::raw::c_uint = 12;
pub const BPF_TCP_MAX_STATES: ::std::os::raw::c_uint = 13;
pub type _bindgen_ty_70 = ::std::os::raw::c_uint;
pub const BPF_LOAD_HDR_OPT_TCP_SYN: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_72 = ::std::os::raw::c_uint;
pub const BPF_WRITE_HDR_TCP_CURRENT_MSS: ::std::os::raw::c_uint = 1;
pub const BPF_WRITE_HDR_TCP_SYNACK_COOKIE: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_73 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_perf_event_value {
    pub counter: __u64,
    pub enabled: __u64,
    pub running: __u64,
}
pub const BPF_DEVCG_ACC_MKNOD: ::std::os::raw::c_uint = 1;
pub const BPF_DEVCG_ACC_READ: ::std::os::raw::c_uint = 2;
pub const BPF_DEVCG_ACC_WRITE: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_74 = ::std::os::raw::c_uint;
pub const BPF_DEVCG_DEV_BLOCK: ::std::os::raw::c_uint = 1;
pub const BPF_DEVCG_DEV_CHAR: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_75 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_cgroup_dev_ctx {
    pub access_type: __u32,
    pub major: __u32,
    pub minor: __u32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_raw_tracepoint_args {
    pub args: __IncompleteArrayField<__u64>,
}
pub const BPF_FIB_LOOKUP_DIRECT: ::std::os::raw::c_uint = 1;
pub const BPF_FIB_LOOKUP_OUTPUT: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_76 = ::std::os::raw::c_uint;
pub const BPF_FIB_LKUP_RET_SUCCESS: ::std::os::raw::c_uint = 0;
pub const BPF_FIB_LKUP_RET_BLACKHOLE: ::std::os::raw::c_uint = 1;
pub const BPF_FIB_LKUP_RET_UNREACHABLE: ::std::os::raw::c_uint = 2;
pub const BPF_FIB_LKUP_RET_PROHIBIT: ::std::os::raw::c_uint = 3;
pub const BPF_FIB_LKUP_RET_NOT_FWDED: ::std::os::raw::c_uint = 4;
pub const BPF_FIB_LKUP_RET_FWD_DISABLED: ::std::os::raw::c_uint = 5;
pub const BPF_FIB_LKUP_RET_UNSUPP_LWT: ::std::os::raw::c_uint = 6;
pub const BPF_FIB_LKUP_RET_NO_NEIGH: ::std::os::raw::c_uint = 7;
pub const BPF_FIB_LKUP_RET_FRAG_NEEDED: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_77 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_fib_lookup {
    pub family: __u8,
    pub l4_protocol: __u8,
    pub sport: __be16,
    pub dport: __be16,
    pub __bindgen_anon_1: bpf_fib_lookup__bindgen_ty_1,
    pub ifindex: __u32,
    pub __bindgen_anon_2: bpf_fib_lookup__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_fib_lookup__bindgen_ty_3,
    pub __bindgen_anon_4: bpf_fib_lookup__bindgen_ty_4,
    pub h_vlan_proto: __be16,
    pub h_vlan_TCI: __be16,
    pub smac: [__u8; 6usize],
    pub dmac: [__u8; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_1 {
    pub tot_len: __u16,
    pub mtu_result: __u16,
}
impl Default for bpf_fib_lookup__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_2 {
    pub tos: __u8,
    pub flowinfo: __be32,
    pub rt_metric: __u32,
}
impl Default for bpf_fib_lookup__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_3 {
    pub ipv4_src: __be32,
    pub ipv6_src: [__u32; 4usize],
}
impl Default for bpf_fib_lookup__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_fib_lookup__bindgen_ty_4 {
    pub ipv4_dst: __be32,
    pub ipv6_dst: [__u32; 4usize],
}
impl Default for bpf_fib_lookup__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_fib_lookup {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_redir_neigh {
    pub nh_family: __u32,
    pub __bindgen_anon_1: bpf_redir_neigh__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_redir_neigh__bindgen_ty_1 {
    pub ipv4_nh: __be32,
    pub ipv6_nh: [__u32; 4usize],
}
impl Default for bpf_redir_neigh__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_redir_neigh {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BPF_MTU_CHK_SEGS: bpf_check_mtu_flags = 1;
pub type bpf_check_mtu_flags = ::std::os::raw::c_uint;
pub const BPF_MTU_CHK_RET_SUCCESS: bpf_check_mtu_ret = 0;
pub const BPF_MTU_CHK_RET_FRAG_NEEDED: bpf_check_mtu_ret = 1;
pub const BPF_MTU_CHK_RET_SEGS_TOOBIG: bpf_check_mtu_ret = 2;
pub type bpf_check_mtu_ret = ::std::os::raw::c_uint;
pub const BPF_FD_TYPE_RAW_TRACEPOINT: bpf_task_fd_type = 0;
pub const BPF_FD_TYPE_TRACEPOINT: bpf_task_fd_type = 1;
pub const BPF_FD_TYPE_KPROBE: bpf_task_fd_type = 2;
pub const BPF_FD_TYPE_KRETPROBE: bpf_task_fd_type = 3;
pub const BPF_FD_TYPE_UPROBE: bpf_task_fd_type = 4;
pub const BPF_FD_TYPE_URETPROBE: bpf_task_fd_type = 5;
pub type bpf_task_fd_type = ::std::os::raw::c_uint;
pub const BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG: ::std::os::raw::c_uint = 1;
pub const BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL: ::std::os::raw::c_uint = 2;
pub const BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_78 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_flow_keys {
    pub nhoff: __u16,
    pub thoff: __u16,
    pub addr_proto: __u16,
    pub is_frag: __u8,
    pub is_first_frag: __u8,
    pub is_encap: __u8,
    pub ip_proto: __u8,
    pub n_proto: __be16,
    pub sport: __be16,
    pub dport: __be16,
    pub __bindgen_anon_1: bpf_flow_keys__bindgen_ty_1,
    pub flags: __u32,
    pub flow_label: __be32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_flow_keys__bindgen_ty_1 {
    pub __bindgen_anon_1: bpf_flow_keys__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_flow_keys__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_flow_keys__bindgen_ty_1__bindgen_ty_1 {
    pub ipv4_src: __be32,
    pub ipv4_dst: __be32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_flow_keys__bindgen_ty_1__bindgen_ty_2 {
    pub ipv6_src: [__u32; 4usize],
    pub ipv6_dst: [__u32; 4usize],
}
impl Default for bpf_flow_keys__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_flow_keys {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_func_info {
    pub insn_off: __u32,
    pub type_id: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_line_info {
    pub insn_off: __u32,
    pub file_name_off: __u32,
    pub line_off: __u32,
    pub line_col: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_spin_lock {
    pub val: __u32,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_timer {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 16usize]>,
}
impl bpf_timer {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 16usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 16usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_sysctl {
    pub write: __u32,
    pub file_pos: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sockopt {
    pub __bindgen_anon_1: bpf_sockopt__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_sockopt__bindgen_ty_2,
    pub __bindgen_anon_3: bpf_sockopt__bindgen_ty_3,
    pub level: __s32,
    pub optname: __s32,
    pub optlen: __s32,
    pub retval: __s32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_1 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sockopt__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sockopt__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_2 {
    pub optval: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sockopt__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sockopt__bindgen_ty_2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sockopt__bindgen_ty_3 {
    pub optval_end: *mut ::std::os::raw::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sockopt__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sockopt__bindgen_ty_3 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
impl Default for bpf_sockopt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_pidns_info {
    pub pid: __u32,
    pub tgid: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_sk_lookup {
    pub __bindgen_anon_1: bpf_sk_lookup__bindgen_ty_1,
    pub family: __u32,
    pub protocol: __u32,
    pub remote_ip4: __u32,
    pub remote_ip6: [__u32; 4usize],
    pub remote_port: __u32,
    pub local_ip4: __u32,
    pub local_ip6: [__u32; 4usize],
    pub local_port: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sk_lookup__bindgen_ty_1 {
    pub __bindgen_anon_1: bpf_sk_lookup__bindgen_ty_1__bindgen_ty_1,
    pub cookie: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_sk_lookup__bindgen_ty_1__bindgen_ty_1 {
    pub sk: *mut bpf_sock,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl Default for bpf_sk_lookup__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bpf_sk_lookup__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
impl Default for bpf_sk_lookup__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_sk_lookup {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BTF_F_COMPACT: ::std::os::raw::c_uint = 1;
pub const BTF_F_NONAME: ::std::os::raw::c_uint = 2;
pub const BTF_F_PTR_RAW: ::std::os::raw::c_uint = 4;
pub const BTF_F_ZERO: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_79 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_create_map_attr {
    pub name: *const ::std::os::raw::c_char,
    pub map_type: bpf_map_type,
    pub map_flags: __u32,
    pub key_size: __u32,
    pub value_size: __u32,
    pub max_entries: __u32,
    pub numa_node: __u32,
    pub btf_fd: __u32,
    pub btf_key_type_id: __u32,
    pub btf_value_type_id: __u32,
    pub map_ifindex: __u32,
    pub __bindgen_anon_1: bpf_create_map_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_create_map_attr__bindgen_ty_1 {
    pub inner_map_fd: __u32,
    pub btf_vmlinux_value_type_id: __u32,
}
impl Default for bpf_create_map_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_create_map_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_create_map_xattr(create_attr: *const bpf_create_map_attr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_node(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
        node: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_name(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map(
        map_type: bpf_map_type,
        key_size: ::std::os::raw::c_int,
        value_size: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_in_map_node(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        inner_map_fd: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
        node: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_create_map_in_map(
        map_type: bpf_map_type,
        name: *const ::std::os::raw::c_char,
        key_size: ::std::os::raw::c_int,
        inner_map_fd: ::std::os::raw::c_int,
        max_entries: ::std::os::raw::c_int,
        map_flags: __u32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_load_program_attr {
    pub prog_type: bpf_prog_type,
    pub expected_attach_type: bpf_attach_type,
    pub name: *const ::std::os::raw::c_char,
    pub insns: *const bpf_insn,
    pub insns_cnt: size_t,
    pub license: *const ::std::os::raw::c_char,
    pub __bindgen_anon_1: bpf_load_program_attr__bindgen_ty_1,
    pub __bindgen_anon_2: bpf_load_program_attr__bindgen_ty_2,
    pub prog_btf_fd: __u32,
    pub func_info_rec_size: __u32,
    pub func_info: *const ::std::os::raw::c_void,
    pub func_info_cnt: __u32,
    pub line_info_rec_size: __u32,
    pub line_info: *const ::std::os::raw::c_void,
    pub line_info_cnt: __u32,
    pub log_level: __u32,
    pub prog_flags: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_load_program_attr__bindgen_ty_1 {
    pub kern_version: __u32,
    pub attach_prog_fd: __u32,
}
impl Default for bpf_load_program_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_load_program_attr__bindgen_ty_2 {
    pub prog_ifindex: __u32,
    pub attach_btf_id: __u32,
}
impl Default for bpf_load_program_attr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_load_program_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_load_program_xattr(
        load_attr: *const bpf_load_program_attr,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_load_program(
        type_: bpf_prog_type,
        insns: *const bpf_insn,
        insns_cnt: size_t,
        license: *const ::std::os::raw::c_char,
        kern_version: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_verify_program(
        type_: bpf_prog_type,
        insns: *const bpf_insn,
        insns_cnt: size_t,
        prog_flags: __u32,
        license: *const ::std::os::raw::c_char,
        kern_version: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_sz: size_t,
        log_level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_update_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *const ::std::os::raw::c_void,
        flags: __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_elem_flags(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
        flags: __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_and_delete_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_and_delete_elem_flags(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        value: *mut ::std::os::raw::c_void,
        flags: __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_delete_elem(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_next_key(
        fd: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_void,
        next_key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_freeze(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_map_batch_opts {
    pub sz: size_t,
    pub elem_flags: __u64,
    pub flags: __u64,
}
extern "C" {
    pub fn bpf_map_delete_batch(
        fd: ::std::os::raw::c_int,
        keys: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_batch(
        fd: ::std::os::raw::c_int,
        in_batch: *mut ::std::os::raw::c_void,
        out_batch: *mut ::std::os::raw::c_void,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_lookup_and_delete_batch(
        fd: ::std::os::raw::c_int,
        in_batch: *mut ::std::os::raw::c_void,
        out_batch: *mut ::std::os::raw::c_void,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_update_batch(
        fd: ::std::os::raw::c_int,
        keys: *mut ::std::os::raw::c_void,
        values: *mut ::std::os::raw::c_void,
        count: *mut __u32,
        opts: *const bpf_map_batch_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_pin(
        fd: ::std::os::raw::c_int,
        pathname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get(pathname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_prog_attach_opts {
    pub sz: size_t,
    pub flags: ::std::os::raw::c_uint,
    pub replace_prog_fd: ::std::os::raw::c_int,
}
extern "C" {
    pub fn bpf_prog_attach(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_attach_xattr(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        opts: *const bpf_prog_attach_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_detach(
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_detach2(
        prog_fd: ::std::os::raw::c_int,
        attachable_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bpf_link_create_opts {
    pub sz: size_t,
    pub flags: __u32,
    pub iter_info: *mut bpf_iter_link_info,
    pub iter_info_len: __u32,
    pub target_btf_id: __u32,
    pub __bindgen_anon_1: bpf_link_create_opts__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bpf_link_create_opts__bindgen_ty_1 {
    pub perf_event: bpf_link_create_opts__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_create_opts__bindgen_ty_1__bindgen_ty_1 {
    pub bpf_cookie: __u64,
}
impl Default for bpf_link_create_opts__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for bpf_link_create_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_link_create(
        prog_fd: ::std::os::raw::c_int,
        target_fd: ::std::os::raw::c_int,
        attach_type: bpf_attach_type,
        opts: *const bpf_link_create_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_detach(link_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_link_update_opts {
    pub sz: size_t,
    pub flags: __u32,
    pub old_prog_fd: __u32,
}
extern "C" {
    pub fn bpf_link_update(
        link_fd: ::std::os::raw::c_int,
        new_prog_fd: ::std::os::raw::c_int,
        opts: *const bpf_link_update_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_iter_create(link_fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_test_run_attr {
    pub prog_fd: ::std::os::raw::c_int,
    pub repeat: ::std::os::raw::c_int,
    pub data_in: *const ::std::os::raw::c_void,
    pub data_size_in: __u32,
    pub data_out: *mut ::std::os::raw::c_void,
    pub data_size_out: __u32,
    pub retval: __u32,
    pub duration: __u32,
    pub ctx_in: *const ::std::os::raw::c_void,
    pub ctx_size_in: __u32,
    pub ctx_out: *mut ::std::os::raw::c_void,
    pub ctx_size_out: __u32,
}
impl Default for bpf_prog_test_run_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_prog_test_run_xattr(test_attr: *mut bpf_prog_test_run_attr)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_test_run(
        prog_fd: ::std::os::raw::c_int,
        repeat: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        size: __u32,
        data_out: *mut ::std::os::raw::c_void,
        size_out: *mut __u32,
        retval: *mut __u32,
        duration: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_btf_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_get_next_id(start_id: __u32, next_id: *mut __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_btf_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link_get_fd_by_id(id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_obj_get_info_by_fd(
        bpf_fd: ::std::os::raw::c_int,
        info: *mut ::std::os::raw::c_void,
        info_len: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_query(
        target_fd: ::std::os::raw::c_int,
        type_: bpf_attach_type,
        query_flags: __u32,
        attach_flags: *mut __u32,
        prog_ids: *mut __u32,
        prog_cnt: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_raw_tracepoint_open(
        name: *const ::std::os::raw::c_char,
        prog_fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_load_btf(
        btf: *const ::std::os::raw::c_void,
        btf_size: __u32,
        log_buf: *mut ::std::os::raw::c_char,
        log_buf_size: __u32,
        do_log: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_task_fd_query(
        pid: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
        buf: *mut ::std::os::raw::c_char,
        buf_len: *mut __u32,
        prog_id: *mut __u32,
        fd_type: *mut __u32,
        probe_offset: *mut __u64,
        probe_addr: *mut __u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_enable_stats(type_: bpf_stats_type) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_prog_bind_opts {
    pub sz: size_t,
    pub flags: __u32,
}
extern "C" {
    pub fn bpf_prog_bind_map(
        prog_fd: ::std::os::raw::c_int,
        map_fd: ::std::os::raw::c_int,
        opts: *const bpf_prog_bind_opts,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_test_run_opts {
    pub sz: size_t,
    pub data_in: *const ::std::os::raw::c_void,
    pub data_out: *mut ::std::os::raw::c_void,
    pub data_size_in: __u32,
    pub data_size_out: __u32,
    pub ctx_in: *const ::std::os::raw::c_void,
    pub ctx_out: *mut ::std::os::raw::c_void,
    pub ctx_size_in: __u32,
    pub ctx_size_out: __u32,
    pub retval: __u32,
    pub repeat: ::std::os::raw::c_int,
    pub duration: __u32,
    pub flags: __u32,
    pub cpu: __u32,
}
impl Default for bpf_test_run_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_prog_test_run_opts(
        prog_fd: ::std::os::raw::c_int,
        opts: *mut bpf_test_run_opts,
    ) -> ::std::os::raw::c_int;
}
pub type va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct btf_type {
    pub name_off: __u32,
    pub info: __u32,
    pub __bindgen_anon_1: btf_type__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union btf_type__bindgen_ty_1 {
    pub size: __u32,
    pub type_: __u32,
}
impl Default for btf_type__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for btf_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BTF_VAR_STATIC: ::std::os::raw::c_uint = 0;
pub const BTF_VAR_GLOBAL_ALLOCATED: ::std::os::raw::c_uint = 1;
pub const BTF_VAR_GLOBAL_EXTERN: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_80 = ::std::os::raw::c_uint;
pub const BTF_FUNC_STATIC: btf_func_linkage = 0;
pub const BTF_FUNC_GLOBAL: btf_func_linkage = 1;
pub const BTF_FUNC_EXTERN: btf_func_linkage = 2;
pub type btf_func_linkage = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf_ext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object {
    _unused: [u8; 0],
}
pub const BTF_LITTLE_ENDIAN: btf_endianness = 0;
pub const BTF_BIG_ENDIAN: btf_endianness = 1;
pub type btf_endianness = ::std::os::raw::c_uint;
extern "C" {
    pub fn btf__free(btf: *mut btf);
}
extern "C" {
    pub fn btf__new(data: *const ::std::os::raw::c_void, size: __u32) -> *mut btf;
}
extern "C" {
    pub fn btf__new_split(
        data: *const ::std::os::raw::c_void,
        size: __u32,
        base_btf: *mut btf,
    ) -> *mut btf;
}
extern "C" {
    pub fn btf__new_empty() -> *mut btf;
}
extern "C" {
    pub fn btf__new_empty_split(base_btf: *mut btf) -> *mut btf;
}
extern "C" {
    pub fn btf__parse(path: *const ::std::os::raw::c_char, btf_ext: *mut *mut btf_ext) -> *mut btf;
}
extern "C" {
    pub fn btf__parse_split(path: *const ::std::os::raw::c_char, base_btf: *mut btf) -> *mut btf;
}
extern "C" {
    pub fn btf__parse_elf(
        path: *const ::std::os::raw::c_char,
        btf_ext: *mut *mut btf_ext,
    ) -> *mut btf;
}
extern "C" {
    pub fn btf__parse_elf_split(
        path: *const ::std::os::raw::c_char,
        base_btf: *mut btf,
    ) -> *mut btf;
}
extern "C" {
    pub fn btf__parse_raw(path: *const ::std::os::raw::c_char) -> *mut btf;
}
extern "C" {
    pub fn btf__parse_raw_split(
        path: *const ::std::os::raw::c_char,
        base_btf: *mut btf,
    ) -> *mut btf;
}
extern "C" {
    pub fn btf__load_vmlinux_btf() -> *mut btf;
}
extern "C" {
    pub fn btf__load_module_btf(
        module_name: *const ::std::os::raw::c_char,
        vmlinux_btf: *mut btf,
    ) -> *mut btf;
}
extern "C" {
    pub fn libbpf_find_kernel_btf() -> *mut btf;
}
extern "C" {
    pub fn btf__load_from_kernel_by_id(id: __u32) -> *mut btf;
}
extern "C" {
    pub fn btf__load_from_kernel_by_id_split(id: __u32, base_btf: *mut btf) -> *mut btf;
}
extern "C" {
    pub fn btf__get_from_id(id: __u32, btf: *mut *mut btf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__finalize_data(obj: *mut bpf_object, btf: *mut btf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__load(btf: *mut btf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__load_into_kernel(btf: *mut btf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__find_by_name(btf: *const btf, type_name: *const ::std::os::raw::c_char) -> __s32;
}
extern "C" {
    pub fn btf__find_by_name_kind(
        btf: *const btf,
        type_name: *const ::std::os::raw::c_char,
        kind: __u32,
    ) -> __s32;
}
extern "C" {
    pub fn btf__get_nr_types(btf: *const btf) -> __u32;
}
extern "C" {
    pub fn btf__base_btf(btf: *const btf) -> *const btf;
}
extern "C" {
    pub fn btf__type_by_id(btf: *const btf, id: __u32) -> *const btf_type;
}
extern "C" {
    pub fn btf__pointer_size(btf: *const btf) -> size_t;
}
extern "C" {
    pub fn btf__set_pointer_size(btf: *mut btf, ptr_sz: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__endianness(btf: *const btf) -> btf_endianness;
}
extern "C" {
    pub fn btf__set_endianness(btf: *mut btf, endian: btf_endianness) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__resolve_size(btf: *const btf, type_id: __u32) -> __s64;
}
extern "C" {
    pub fn btf__resolve_type(btf: *const btf, type_id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__align_of(btf: *const btf, id: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__fd(btf: *const btf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__set_fd(btf: *mut btf, fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn btf__get_raw_data(btf: *const btf, size: *mut __u32) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn btf__name_by_offset(btf: *const btf, offset: __u32) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn btf__str_by_offset(btf: *const btf, offset: __u32) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn btf__get_map_kv_tids(
        btf: *const btf,
        map_name: *const ::std::os::raw::c_char,
        expected_key_size: __u32,
        expected_value_size: __u32,
        key_type_id: *mut __u32,
        value_type_id: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf_ext__new(data: *mut __u8, size: __u32) -> *mut btf_ext;
}
extern "C" {
    pub fn btf_ext__free(btf_ext: *mut btf_ext);
}
extern "C" {
    pub fn btf_ext__get_raw_data(
        btf_ext: *const btf_ext,
        size: *mut __u32,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn btf_ext__reloc_func_info(
        btf: *const btf,
        btf_ext: *const btf_ext,
        sec_name: *const ::std::os::raw::c_char,
        insns_cnt: __u32,
        func_info: *mut *mut ::std::os::raw::c_void,
        cnt: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf_ext__reloc_line_info(
        btf: *const btf,
        btf_ext: *const btf_ext,
        sec_name: *const ::std::os::raw::c_char,
        insns_cnt: __u32,
        line_info: *mut *mut ::std::os::raw::c_void,
        cnt: *mut __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf_ext__func_info_rec_size(btf_ext: *const btf_ext) -> __u32;
}
extern "C" {
    pub fn btf_ext__line_info_rec_size(btf_ext: *const btf_ext) -> __u32;
}
extern "C" {
    pub fn btf__find_str(btf: *mut btf, s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_str(btf: *mut btf, s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_type(
        btf: *mut btf,
        src_btf: *const btf,
        src_type: *const btf_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_int(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        byte_sz: size_t,
        encoding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_float(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        byte_sz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_ptr(btf: *mut btf, ref_type_id: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_array(
        btf: *mut btf,
        index_type_id: ::std::os::raw::c_int,
        elem_type_id: ::std::os::raw::c_int,
        nr_elems: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_struct(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        sz: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_union(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        sz: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_field(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        field_type_id: ::std::os::raw::c_int,
        bit_offset: __u32,
        bit_size: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_enum(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        bytes_sz: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_enum_value(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        value: __s64,
    ) -> ::std::os::raw::c_int;
}
pub const BTF_FWD_STRUCT: btf_fwd_kind = 0;
pub const BTF_FWD_UNION: btf_fwd_kind = 1;
pub const BTF_FWD_ENUM: btf_fwd_kind = 2;
pub type btf_fwd_kind = ::std::os::raw::c_uint;
extern "C" {
    pub fn btf__add_fwd(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        fwd_kind: btf_fwd_kind,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_typedef(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        ref_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_volatile(
        btf: *mut btf,
        ref_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_const(
        btf: *mut btf,
        ref_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_restrict(
        btf: *mut btf,
        ref_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_func(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        linkage: btf_func_linkage,
        proto_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_func_proto(
        btf: *mut btf,
        ret_type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_func_param(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_var(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        linkage: ::std::os::raw::c_int,
        type_id: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_datasec(
        btf: *mut btf,
        name: *const ::std::os::raw::c_char,
        byte_sz: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn btf__add_datasec_var_info(
        btf: *mut btf,
        var_type_id: ::std::os::raw::c_int,
        offset: __u32,
        byte_sz: __u32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct btf_dedup_opts {
    pub dedup_table_size: ::std::os::raw::c_uint,
    pub dont_resolve_fwds: bool,
}
extern "C" {
    pub fn btf__dedup(
        btf: *mut btf,
        btf_ext: *mut btf_ext,
        opts: *const btf_dedup_opts,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf_dump {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf_dump_opts {
    pub ctx: *mut ::std::os::raw::c_void,
}
impl Default for btf_dump_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type btf_dump_printf_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ),
>;
extern "C" {
    pub fn btf_dump__new(
        btf: *const btf,
        btf_ext: *const btf_ext,
        opts: *const btf_dump_opts,
        printf_fn: btf_dump_printf_fn_t,
    ) -> *mut btf_dump;
}
extern "C" {
    pub fn btf_dump__free(d: *mut btf_dump);
}
extern "C" {
    pub fn btf_dump__dump_type(d: *mut btf_dump, id: __u32) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf_dump_emit_type_decl_opts {
    pub sz: size_t,
    pub field_name: *const ::std::os::raw::c_char,
    pub indent_level: ::std::os::raw::c_int,
    pub strip_mods: bool,
}
impl Default for btf_dump_emit_type_decl_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn btf_dump__emit_type_decl(
        d: *mut btf_dump,
        id: __u32,
        opts: *const btf_dump_emit_type_decl_opts,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btf_dump_type_data_opts {
    pub sz: size_t,
    pub indent_str: *const ::std::os::raw::c_char,
    pub indent_level: ::std::os::raw::c_int,
    pub compact: bool,
    pub skip_names: bool,
    pub emit_zeroes: bool,
}
impl Default for btf_dump_type_data_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn btf_dump__dump_type_data(
        d: *mut btf_dump,
        id: __u32,
        data: *const ::std::os::raw::c_void,
        data_sz: size_t,
        opts: *const btf_dump_type_data_opts,
    ) -> ::std::os::raw::c_int;
}
pub type pid_t = __pid_t;
pub const LIBBPF_STRICT_ALL: libbpf_strict_mode = 4294967295;
pub const LIBBPF_STRICT_NONE: libbpf_strict_mode = 0;
pub const LIBBPF_STRICT_CLEAN_PTRS: libbpf_strict_mode = 1;
pub const LIBBPF_STRICT_DIRECT_ERRS: libbpf_strict_mode = 2;
pub const __LIBBPF_STRICT_LAST: libbpf_strict_mode = 3;
pub type libbpf_strict_mode = ::std::os::raw::c_uint;
extern "C" {
    pub fn libbpf_set_strict_mode(mode: libbpf_strict_mode) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_strerror(
        err: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
pub const LIBBPF_WARN: libbpf_print_level = 0;
pub const LIBBPF_INFO: libbpf_print_level = 1;
pub const LIBBPF_DEBUG: libbpf_print_level = 2;
pub type libbpf_print_level = ::std::os::raw::c_uint;
pub type libbpf_print_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        level: libbpf_print_level,
        arg1: *const ::std::os::raw::c_char,
        ap: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn libbpf_set_print(fn_: libbpf_print_fn_t) -> libbpf_print_fn_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object_open_attr {
    pub file: *const ::std::os::raw::c_char,
    pub prog_type: bpf_prog_type,
}
impl Default for bpf_object_open_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object_open_opts {
    pub sz: size_t,
    pub object_name: *const ::std::os::raw::c_char,
    pub relaxed_maps: bool,
    pub relaxed_core_relocs: bool,
    pub pin_root_path: *const ::std::os::raw::c_char,
    pub attach_prog_fd: __u32,
    pub kconfig: *const ::std::os::raw::c_char,
    pub btf_custom_path: *const ::std::os::raw::c_char,
}
impl Default for bpf_object_open_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_object__open(path: *const ::std::os::raw::c_char) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_file(
        path: *const ::std::os::raw::c_char,
        opts: *const bpf_object_open_opts,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_mem(
        obj_buf: *const ::std::os::raw::c_void,
        obj_buf_sz: size_t,
        opts: *const bpf_object_open_opts,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_buffer(
        obj_buf: *const ::std::os::raw::c_void,
        obj_buf_sz: size_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__open_xattr(attr: *mut bpf_object_open_attr) -> *mut bpf_object;
}
extern "C" {
    pub fn bpf_object__pin_maps(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unpin_maps(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__pin_programs(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unpin_programs(
        obj: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__pin(
        object: *mut bpf_object,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__close(object: *mut bpf_object);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object_load_attr {
    pub obj: *mut bpf_object,
    pub log_level: ::std::os::raw::c_int,
    pub target_btf_path: *const ::std::os::raw::c_char,
}
impl Default for bpf_object_load_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_object__load(obj: *mut bpf_object) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__load_xattr(attr: *mut bpf_object_load_attr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__unload(obj: *mut bpf_object) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__name(obj: *const bpf_object) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_object__kversion(obj: *const bpf_object) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn bpf_object__set_kversion(
        obj: *mut bpf_object,
        kern_version: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__btf(obj: *const bpf_object) -> *mut btf;
}
extern "C" {
    pub fn bpf_object__btf_fd(obj: *const bpf_object) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_program {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_object__find_program_by_title(
        obj: *const bpf_object,
        title: *const ::std::os::raw::c_char,
    ) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_object__find_program_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_object__next(prev: *mut bpf_object) -> *mut bpf_object;
}
pub type bpf_object_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_object, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_object__set_priv(
        obj: *mut bpf_object,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_object_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__priv(prog: *const bpf_object) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn libbpf_prog_type_by_name(
        name: *const ::std::os::raw::c_char,
        prog_type: *mut bpf_prog_type,
        expected_attach_type: *mut bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_attach_type_by_name(
        name: *const ::std::os::raw::c_char,
        attach_type: *mut bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn libbpf_find_vmlinux_btf_id(
        name: *const ::std::os::raw::c_char,
        attach_type: bpf_attach_type,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__next(prog: *mut bpf_program, obj: *const bpf_object) -> *mut bpf_program;
}
extern "C" {
    pub fn bpf_program__prev(prog: *mut bpf_program, obj: *const bpf_object) -> *mut bpf_program;
}
pub type bpf_program_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_program, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_program__set_priv(
        prog: *mut bpf_program,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_program_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__priv(prog: *const bpf_program) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_program__set_ifindex(prog: *mut bpf_program, ifindex: __u32);
}
extern "C" {
    pub fn bpf_program__name(prog: *const bpf_program) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__section_name(prog: *const bpf_program) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__title(
        prog: *const bpf_program,
        needs_copy: bool,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_program__autoload(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__set_autoload(
        prog: *mut bpf_program,
        autoload: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__size(prog: *const bpf_program) -> size_t;
}
extern "C" {
    pub fn bpf_program__load(
        prog: *mut bpf_program,
        license: *mut ::std::os::raw::c_char,
        kern_version: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__fd(prog: *const bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__pin_instance(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
        instance: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unpin_instance(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
        instance: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__pin(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unpin(
        prog: *mut bpf_program,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__unload(prog: *mut bpf_program);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_link {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_link__open(path: *const ::std::os::raw::c_char) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_link__fd(link: *const bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__pin_path(link: *const bpf_link) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_link__pin(
        link: *mut bpf_link,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__unpin(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__update_program(
        link: *mut bpf_link,
        prog: *mut bpf_program,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__disconnect(link: *mut bpf_link);
}
extern "C" {
    pub fn bpf_link__detach(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_link__destroy(link: *mut bpf_link) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__attach(prog: *mut bpf_program) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_perf_event_opts {
    pub sz: size_t,
    pub bpf_cookie: __u64,
}
extern "C" {
    pub fn bpf_program__attach_perf_event(
        prog: *mut bpf_program,
        pfd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_perf_event_opts(
        prog: *mut bpf_program,
        pfd: ::std::os::raw::c_int,
        opts: *const bpf_perf_event_opts,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_kprobe_opts {
    pub sz: size_t,
    pub bpf_cookie: __u64,
    pub offset: ::std::os::raw::c_ulong,
    pub retprobe: bool,
}
extern "C" {
    pub fn bpf_program__attach_kprobe(
        prog: *mut bpf_program,
        retprobe: bool,
        func_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_kprobe_opts(
        prog: *mut bpf_program,
        func_name: *const ::std::os::raw::c_char,
        opts: *const bpf_kprobe_opts,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_uprobe_opts {
    pub sz: size_t,
    pub ref_ctr_offset: size_t,
    pub bpf_cookie: __u64,
    pub retprobe: bool,
}
extern "C" {
    pub fn bpf_program__attach_uprobe(
        prog: *mut bpf_program,
        retprobe: bool,
        pid: pid_t,
        binary_path: *const ::std::os::raw::c_char,
        func_offset: size_t,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_uprobe_opts(
        prog: *mut bpf_program,
        pid: pid_t,
        binary_path: *const ::std::os::raw::c_char,
        func_offset: size_t,
        opts: *const bpf_uprobe_opts,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_tracepoint_opts {
    pub sz: size_t,
    pub bpf_cookie: __u64,
}
extern "C" {
    pub fn bpf_program__attach_tracepoint(
        prog: *mut bpf_program,
        tp_category: *const ::std::os::raw::c_char,
        tp_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_tracepoint_opts(
        prog: *mut bpf_program,
        tp_category: *const ::std::os::raw::c_char,
        tp_name: *const ::std::os::raw::c_char,
        opts: *const bpf_tracepoint_opts,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_raw_tracepoint(
        prog: *mut bpf_program,
        tp_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_trace(prog: *mut bpf_program) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_lsm(prog: *mut bpf_program) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_cgroup(
        prog: *mut bpf_program,
        cgroup_fd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_netns(
        prog: *mut bpf_program,
        netns_fd: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_xdp(
        prog: *mut bpf_program,
        ifindex: ::std::os::raw::c_int,
    ) -> *mut bpf_link;
}
extern "C" {
    pub fn bpf_program__attach_freplace(
        prog: *mut bpf_program,
        target_fd: ::std::os::raw::c_int,
        attach_func_name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_map {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_map__attach_struct_ops(map: *mut bpf_map) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_iter_attach_opts {
    pub sz: size_t,
    pub link_info: *mut bpf_iter_link_info,
    pub link_info_len: __u32,
}
impl Default for bpf_iter_attach_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_program__attach_iter(
        prog: *mut bpf_program,
        opts: *const bpf_iter_attach_opts,
    ) -> *mut bpf_link;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_prep_result {
    pub new_insn_ptr: *mut bpf_insn,
    pub new_insn_cnt: ::std::os::raw::c_int,
    pub pfd: *mut ::std::os::raw::c_int,
}
impl Default for bpf_prog_prep_result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bpf_program_prep_t = ::std::option::Option<
    unsafe extern "C" fn(
        prog: *mut bpf_program,
        n: ::std::os::raw::c_int,
        insns: *mut bpf_insn,
        insns_cnt: ::std::os::raw::c_int,
        res: *mut bpf_prog_prep_result,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bpf_program__set_prep(
        prog: *mut bpf_program,
        nr_instance: ::std::os::raw::c_int,
        prep: bpf_program_prep_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__nth_fd(
        prog: *const bpf_program,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_socket_filter(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_tracepoint(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_raw_tracepoint(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_kprobe(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_lsm(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sched_cls(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sched_act(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_xdp(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_perf_event(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_tracing(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_struct_ops(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_extension(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__set_sk_lookup(prog: *mut bpf_program) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__get_type(prog: *const bpf_program) -> bpf_prog_type;
}
extern "C" {
    pub fn bpf_program__set_type(prog: *mut bpf_program, type_: bpf_prog_type);
}
extern "C" {
    pub fn bpf_program__get_expected_attach_type(prog: *const bpf_program) -> bpf_attach_type;
}
extern "C" {
    pub fn bpf_program__set_expected_attach_type(prog: *mut bpf_program, type_: bpf_attach_type);
}
extern "C" {
    pub fn bpf_program__set_attach_target(
        prog: *mut bpf_program,
        attach_prog_fd: ::std::os::raw::c_int,
        attach_func_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_program__is_socket_filter(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_tracepoint(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_raw_tracepoint(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_kprobe(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_lsm(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sched_cls(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sched_act(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_xdp(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_perf_event(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_tracing(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_struct_ops(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_extension(prog: *const bpf_program) -> bool;
}
extern "C" {
    pub fn bpf_program__is_sk_lookup(prog: *const bpf_program) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_map_def {
    pub type_: ::std::os::raw::c_uint,
    pub key_size: ::std::os::raw::c_uint,
    pub value_size: ::std::os::raw::c_uint,
    pub max_entries: ::std::os::raw::c_uint,
    pub map_flags: ::std::os::raw::c_uint,
}
extern "C" {
    pub fn bpf_object__find_map_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_object__find_map_fd_by_name(
        obj: *const bpf_object,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__find_map_by_offset(obj: *mut bpf_object, offset: size_t) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__next(map: *const bpf_map, obj: *const bpf_object) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__prev(map: *const bpf_map, obj: *const bpf_object) -> *mut bpf_map;
}
extern "C" {
    pub fn bpf_map__fd(map: *const bpf_map) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__reuse_fd(map: *mut bpf_map, fd: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__def(map: *const bpf_map) -> *const bpf_map_def;
}
extern "C" {
    pub fn bpf_map__name(map: *const bpf_map) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_map__type(map: *const bpf_map) -> bpf_map_type;
}
extern "C" {
    pub fn bpf_map__set_type(map: *mut bpf_map, type_: bpf_map_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__max_entries(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_max_entries(map: *mut bpf_map, max_entries: __u32)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__resize(map: *mut bpf_map, max_entries: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__map_flags(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_map_flags(map: *mut bpf_map, flags: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__numa_node(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_numa_node(map: *mut bpf_map, numa_node: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__key_size(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_key_size(map: *mut bpf_map, size: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__value_size(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_value_size(map: *mut bpf_map, size: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__btf_key_type_id(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__btf_value_type_id(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__ifindex(map: *const bpf_map) -> __u32;
}
extern "C" {
    pub fn bpf_map__set_ifindex(map: *mut bpf_map, ifindex: __u32) -> ::std::os::raw::c_int;
}
pub type bpf_map_clear_priv_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut bpf_map, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn bpf_map__set_priv(
        map: *mut bpf_map,
        priv_: *mut ::std::os::raw::c_void,
        clear_priv: bpf_map_clear_priv_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__priv(map: *const bpf_map) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_map__set_initial_value(
        map: *mut bpf_map,
        data: *const ::std::os::raw::c_void,
        size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__initial_value(
        map: *mut bpf_map,
        psize: *mut size_t,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn bpf_map__is_offload_neutral(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__is_internal(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__set_pin_path(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__get_pin_path(map: *const bpf_map) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_map__pin_path(map: *const bpf_map) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bpf_map__is_pinned(map: *const bpf_map) -> bool;
}
extern "C" {
    pub fn bpf_map__pin(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__unpin(
        map: *mut bpf_map,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__set_inner_map_fd(
        map: *mut bpf_map,
        fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_map__inner_map(map: *mut bpf_map) -> *mut bpf_map;
}
extern "C" {
    pub fn libbpf_get_error(ptr: *const ::std::os::raw::c_void) -> ::std::os::raw::c_long;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_load_attr {
    pub file: *const ::std::os::raw::c_char,
    pub prog_type: bpf_prog_type,
    pub expected_attach_type: bpf_attach_type,
    pub ifindex: ::std::os::raw::c_int,
    pub log_level: ::std::os::raw::c_int,
    pub prog_flags: ::std::os::raw::c_int,
}
impl Default for bpf_prog_load_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_prog_load_xattr(
        attr: *const bpf_prog_load_attr,
        pobj: *mut *mut bpf_object,
        prog_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_prog_load(
        file: *const ::std::os::raw::c_char,
        type_: bpf_prog_type,
        pobj: *mut *mut bpf_object,
        prog_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_link_info {
    pub prog_id: __u32,
    pub drv_prog_id: __u32,
    pub hw_prog_id: __u32,
    pub skb_prog_id: __u32,
    pub attach_mode: __u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_xdp_set_link_opts {
    pub sz: size_t,
    pub old_fd: ::std::os::raw::c_int,
}
extern "C" {
    pub fn bpf_set_link_xdp_fd(
        ifindex: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_set_link_xdp_fd_opts(
        ifindex: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        flags: __u32,
        opts: *const bpf_xdp_set_link_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_link_xdp_id(
        ifindex: ::std::os::raw::c_int,
        prog_id: *mut __u32,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_get_link_xdp_info(
        ifindex: ::std::os::raw::c_int,
        info: *mut xdp_link_info,
        info_size: size_t,
        flags: __u32,
    ) -> ::std::os::raw::c_int;
}
pub const BPF_TC_INGRESS: bpf_tc_attach_point = 1;
pub const BPF_TC_EGRESS: bpf_tc_attach_point = 2;
pub const BPF_TC_CUSTOM: bpf_tc_attach_point = 4;
pub type bpf_tc_attach_point = ::std::os::raw::c_uint;
pub const BPF_TC_F_REPLACE: bpf_tc_flags = 1;
pub type bpf_tc_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_tc_hook {
    pub sz: size_t,
    pub ifindex: ::std::os::raw::c_int,
    pub attach_point: bpf_tc_attach_point,
    pub parent: __u32,
}
impl Default for bpf_tc_hook {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_tc_opts {
    pub sz: size_t,
    pub prog_fd: ::std::os::raw::c_int,
    pub flags: __u32,
    pub prog_id: __u32,
    pub handle: __u32,
    pub priority: __u32,
}
extern "C" {
    pub fn bpf_tc_hook_create(hook: *mut bpf_tc_hook) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_tc_hook_destroy(hook: *mut bpf_tc_hook) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_tc_attach(hook: *const bpf_tc_hook, opts: *mut bpf_tc_opts)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_tc_detach(
        hook: *const bpf_tc_hook,
        opts: *const bpf_tc_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_tc_query(hook: *const bpf_tc_hook, opts: *mut bpf_tc_opts) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ring_buffer {
    _unused: [u8; 0],
}
pub type ring_buffer_sample_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
        size: size_t,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ring_buffer_opts {
    pub sz: size_t,
}
extern "C" {
    pub fn ring_buffer__new(
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
        opts: *const ring_buffer_opts,
    ) -> *mut ring_buffer;
}
extern "C" {
    pub fn ring_buffer__free(rb: *mut ring_buffer);
}
extern "C" {
    pub fn ring_buffer__add(
        rb: *mut ring_buffer,
        map_fd: ::std::os::raw::c_int,
        sample_cb: ring_buffer_sample_fn,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__poll(
        rb: *mut ring_buffer,
        timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__consume(rb: *mut ring_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ring_buffer__epoll_fd(rb: *const ring_buffer) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_buffer {
    _unused: [u8; 0],
}
pub type perf_buffer_sample_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        cpu: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        size: __u32,
    ),
>;
pub type perf_buffer_lost_fn = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, cpu: ::std::os::raw::c_int, cnt: __u64),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_buffer_opts {
    pub sample_cb: perf_buffer_sample_fn,
    pub lost_cb: perf_buffer_lost_fn,
    pub ctx: *mut ::std::os::raw::c_void,
}
impl Default for perf_buffer_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn perf_buffer__new(
        map_fd: ::std::os::raw::c_int,
        page_cnt: size_t,
        opts: *const perf_buffer_opts,
    ) -> *mut perf_buffer;
}
pub const LIBBPF_PERF_EVENT_DONE: bpf_perf_event_ret = 0;
pub const LIBBPF_PERF_EVENT_ERROR: bpf_perf_event_ret = -1;
pub const LIBBPF_PERF_EVENT_CONT: bpf_perf_event_ret = -2;
pub type bpf_perf_event_ret = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_event_header {
    _unused: [u8; 0],
}
pub type perf_buffer_event_fn = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        cpu: ::std::os::raw::c_int,
        event: *mut perf_event_header,
    ) -> bpf_perf_event_ret,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct perf_buffer_raw_opts {
    pub attr: *mut perf_event_attr,
    pub event_cb: perf_buffer_event_fn,
    pub ctx: *mut ::std::os::raw::c_void,
    pub cpu_cnt: ::std::os::raw::c_int,
    pub cpus: *mut ::std::os::raw::c_int,
    pub map_keys: *mut ::std::os::raw::c_int,
}
impl Default for perf_buffer_raw_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn perf_buffer__new_raw(
        map_fd: ::std::os::raw::c_int,
        page_cnt: size_t,
        opts: *const perf_buffer_raw_opts,
    ) -> *mut perf_buffer;
}
extern "C" {
    pub fn perf_buffer__free(pb: *mut perf_buffer);
}
extern "C" {
    pub fn perf_buffer__epoll_fd(pb: *const perf_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__poll(
        pb: *mut perf_buffer,
        timeout_ms: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__consume(pb: *mut perf_buffer) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__consume_buffer(
        pb: *mut perf_buffer,
        buf_idx: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perf_buffer__buffer_cnt(pb: *const perf_buffer) -> size_t;
}
extern "C" {
    pub fn perf_buffer__buffer_fd(pb: *const perf_buffer, buf_idx: size_t)
        -> ::std::os::raw::c_int;
}
pub type bpf_perf_event_print_t = ::std::option::Option<
    unsafe extern "C" fn(
        hdr: *mut perf_event_header,
        private_data: *mut ::std::os::raw::c_void,
    ) -> bpf_perf_event_ret,
>;
extern "C" {
    pub fn bpf_perf_event_read_simple(
        mmap_mem: *mut ::std::os::raw::c_void,
        mmap_size: size_t,
        page_size: size_t,
        copy_mem: *mut *mut ::std::os::raw::c_void,
        copy_size: *mut size_t,
        fn_: bpf_perf_event_print_t,
        private_data: *mut ::std::os::raw::c_void,
    ) -> bpf_perf_event_ret;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_linfo {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_prog_linfo__free(prog_linfo: *mut bpf_prog_linfo);
}
extern "C" {
    pub fn bpf_prog_linfo__new(info: *const bpf_prog_info) -> *mut bpf_prog_linfo;
}
extern "C" {
    pub fn bpf_prog_linfo__lfind_addr_func(
        prog_linfo: *const bpf_prog_linfo,
        addr: __u64,
        func_idx: __u32,
        nr_skip: __u32,
    ) -> *const bpf_line_info;
}
extern "C" {
    pub fn bpf_prog_linfo__lfind(
        prog_linfo: *const bpf_prog_linfo,
        insn_off: __u32,
        nr_skip: __u32,
    ) -> *const bpf_line_info;
}
extern "C" {
    pub fn bpf_probe_prog_type(prog_type: bpf_prog_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_map_type(map_type: bpf_map_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_helper(id: bpf_func_id, prog_type: bpf_prog_type, ifindex: __u32) -> bool;
}
extern "C" {
    pub fn bpf_probe_large_insn_limit(ifindex: __u32) -> bool;
}
pub const BPF_PROG_INFO_FIRST_ARRAY: bpf_prog_info_array = 0;
pub const BPF_PROG_INFO_JITED_INSNS: bpf_prog_info_array = 0;
pub const BPF_PROG_INFO_XLATED_INSNS: bpf_prog_info_array = 1;
pub const BPF_PROG_INFO_MAP_IDS: bpf_prog_info_array = 2;
pub const BPF_PROG_INFO_JITED_KSYMS: bpf_prog_info_array = 3;
pub const BPF_PROG_INFO_JITED_FUNC_LENS: bpf_prog_info_array = 4;
pub const BPF_PROG_INFO_FUNC_INFO: bpf_prog_info_array = 5;
pub const BPF_PROG_INFO_LINE_INFO: bpf_prog_info_array = 6;
pub const BPF_PROG_INFO_JITED_LINE_INFO: bpf_prog_info_array = 7;
pub const BPF_PROG_INFO_PROG_TAGS: bpf_prog_info_array = 8;
pub const BPF_PROG_INFO_LAST_ARRAY: bpf_prog_info_array = 9;
pub type bpf_prog_info_array = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default)]
pub struct bpf_prog_info_linear {
    pub info_len: __u32,
    pub data_len: __u32,
    pub arrays: __u64,
    pub info: bpf_prog_info,
    pub data: __IncompleteArrayField<__u8>,
}
extern "C" {
    pub fn bpf_program__get_prog_info_linear(
        fd: ::std::os::raw::c_int,
        arrays: __u64,
    ) -> *mut bpf_prog_info_linear;
}
extern "C" {
    pub fn bpf_program__bpil_addr_to_offs(info_linear: *mut bpf_prog_info_linear);
}
extern "C" {
    pub fn bpf_program__bpil_offs_to_addr(info_linear: *mut bpf_prog_info_linear);
}
extern "C" {
    pub fn libbpf_num_possible_cpus() -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_map_skeleton {
    pub name: *const ::std::os::raw::c_char,
    pub map: *mut *mut bpf_map,
    pub mmaped: *mut *mut ::std::os::raw::c_void,
}
impl Default for bpf_map_skeleton {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_prog_skeleton {
    pub name: *const ::std::os::raw::c_char,
    pub prog: *mut *mut bpf_program,
    pub link: *mut *mut bpf_link,
}
impl Default for bpf_prog_skeleton {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_object_skeleton {
    pub sz: size_t,
    pub name: *const ::std::os::raw::c_char,
    pub data: *const ::std::os::raw::c_void,
    pub data_sz: size_t,
    pub obj: *mut *mut bpf_object,
    pub map_cnt: ::std::os::raw::c_int,
    pub map_skel_sz: ::std::os::raw::c_int,
    pub maps: *mut bpf_map_skeleton,
    pub prog_cnt: ::std::os::raw::c_int,
    pub prog_skel_sz: ::std::os::raw::c_int,
    pub progs: *mut bpf_prog_skeleton,
}
impl Default for bpf_object_skeleton {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_object__open_skeleton(
        s: *mut bpf_object_skeleton,
        opts: *const bpf_object_open_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__load_skeleton(s: *mut bpf_object_skeleton) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__attach_skeleton(s: *mut bpf_object_skeleton) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_object__detach_skeleton(s: *mut bpf_object_skeleton);
}
extern "C" {
    pub fn bpf_object__destroy_skeleton(s: *mut bpf_object_skeleton);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gen_loader_opts {
    pub sz: size_t,
    pub data: *const ::std::os::raw::c_char,
    pub insns: *const ::std::os::raw::c_char,
    pub data_sz: __u32,
    pub insns_sz: __u32,
}
impl Default for gen_loader_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bpf_object__gen_loader(
        obj: *mut bpf_object,
        opts: *mut gen_loader_opts,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_linker_opts {
    pub sz: size_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpf_linker_file_opts {
    pub sz: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bpf_linker {
    _unused: [u8; 0],
}
extern "C" {
    pub fn bpf_linker__new(
        filename: *const ::std::os::raw::c_char,
        opts: *mut bpf_linker_opts,
    ) -> *mut bpf_linker;
}
extern "C" {
    pub fn bpf_linker__add_file(
        linker: *mut bpf_linker,
        filename: *const ::std::os::raw::c_char,
        opts: *const bpf_linker_file_opts,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_linker__finalize(linker: *mut bpf_linker) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bpf_linker__free(linker: *mut bpf_linker);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_ring_offset {
    pub producer: __u64,
    pub consumer: __u64,
    pub desc: __u64,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_mmap_offsets {
    pub rx: xdp_ring_offset,
    pub tx: xdp_ring_offset,
    pub fr: xdp_ring_offset,
    pub cr: xdp_ring_offset,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_umem_reg {
    pub addr: __u64,
    pub len: __u64,
    pub chunk_size: __u32,
    pub headroom: __u32,
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_statistics {
    pub rx_dropped: __u64,
    pub rx_invalid_descs: __u64,
    pub tx_invalid_descs: __u64,
    pub rx_ring_full: __u64,
    pub rx_fill_ring_empty_descs: __u64,
    pub tx_ring_empty_descs: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_options {
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xdp_desc {
    pub addr: __u64,
    pub len: __u32,
    pub options: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xsk_ring_prod {
    pub cached_prod: __u32,
    pub cached_cons: __u32,
    pub mask: __u32,
    pub size: __u32,
    pub producer: *mut __u32,
    pub consumer: *mut __u32,
    pub ring: *mut ::std::os::raw::c_void,
    pub flags: *mut __u32,
}
impl Default for xsk_ring_prod {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xsk_ring_cons {
    pub cached_prod: __u32,
    pub cached_cons: __u32,
    pub mask: __u32,
    pub size: __u32,
    pub producer: *mut __u32,
    pub consumer: *mut __u32,
    pub ring: *mut ::std::os::raw::c_void,
    pub flags: *mut __u32,
}
impl Default for xsk_ring_cons {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xsk_umem {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xsk_socket {
    _unused: [u8; 0],
}
extern "C" {
    pub fn xsk_umem__fd(umem: *const xsk_umem) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_socket__fd(xsk: *const xsk_socket) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xsk_umem_config {
    pub fill_size: __u32,
    pub comp_size: __u32,
    pub frame_size: __u32,
    pub frame_headroom: __u32,
    pub flags: __u32,
}
extern "C" {
    pub fn xsk_setup_xdp_prog(
        ifindex: ::std::os::raw::c_int,
        xsks_map_fd: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_socket__update_xskmap(
        xsk: *mut xsk_socket,
        xsks_map_fd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xsk_socket_config {
    pub rx_size: __u32,
    pub tx_size: __u32,
    pub libbpf_flags: __u32,
    pub xdp_flags: __u32,
    pub bind_flags: __u16,
}
extern "C" {
    pub fn xsk_umem__create(
        umem: *mut *mut xsk_umem,
        umem_area: *mut ::std::os::raw::c_void,
        size: __u64,
        fill: *mut xsk_ring_prod,
        comp: *mut xsk_ring_cons,
        config: *const xsk_umem_config,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_umem__create_v0_0_2(
        umem: *mut *mut xsk_umem,
        umem_area: *mut ::std::os::raw::c_void,
        size: __u64,
        fill: *mut xsk_ring_prod,
        comp: *mut xsk_ring_cons,
        config: *const xsk_umem_config,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_umem__create_v0_0_4(
        umem: *mut *mut xsk_umem,
        umem_area: *mut ::std::os::raw::c_void,
        size: __u64,
        fill: *mut xsk_ring_prod,
        comp: *mut xsk_ring_cons,
        config: *const xsk_umem_config,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_socket__create(
        xsk: *mut *mut xsk_socket,
        ifname: *const ::std::os::raw::c_char,
        queue_id: __u32,
        umem: *mut xsk_umem,
        rx: *mut xsk_ring_cons,
        tx: *mut xsk_ring_prod,
        config: *const xsk_socket_config,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_socket__create_shared(
        xsk_ptr: *mut *mut xsk_socket,
        ifname: *const ::std::os::raw::c_char,
        queue_id: __u32,
        umem: *mut xsk_umem,
        rx: *mut xsk_ring_cons,
        tx: *mut xsk_ring_prod,
        fill: *mut xsk_ring_prod,
        comp: *mut xsk_ring_cons,
        config: *const xsk_socket_config,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_umem__delete(umem: *mut xsk_umem) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn xsk_socket__delete(xsk: *mut xsk_socket);
}
extern "C" {
    pub fn _xsk_ring_prod__fill_addr(fill: *mut xsk_ring_prod, idx: __u32) -> *mut __u64;
}
extern "C" {
    pub fn _xsk_ring_cons__comp_addr(comp: *const xsk_ring_cons, idx: __u32) -> *const __u64;
}
extern "C" {
    pub fn _xsk_ring_cons__peek(cons: *mut xsk_ring_cons, nb: size_t, idx: *mut __u32) -> size_t;
}
extern "C" {
    pub fn _xsk_ring_cons__release(cons: *mut xsk_ring_cons, nb: size_t);
}
extern "C" {
    pub fn _xsk_ring_prod__reserve(prod: *mut xsk_ring_prod, nb: size_t, idx: *mut __u32)
        -> size_t;
}
extern "C" {
    pub fn _xsk_ring_prod__submit(prod: *mut xsk_ring_prod, nb: size_t);
}
extern "C" {
    pub fn _xsk_ring_cons__rx_desc(rx: *const xsk_ring_cons, idx: __u32) -> *const xdp_desc;
}
extern "C" {
    pub fn _xsk_ring_prod__tx_desc(tx: *mut xsk_ring_prod, idx: __u32) -> *mut xdp_desc;
}
extern "C" {
    pub fn _xsk_umem__get_data(
        umem_area: *mut ::std::os::raw::c_void,
        addr: __u64,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn _xsk_ring_prod__needs_wakeup(r: *const xsk_ring_prod) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _xsk_prod_nb_free(r: *mut xsk_ring_prod, nb: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _xsk_cons_nb_avail(r: *mut xsk_ring_cons, nb: __u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _xsk_umem__extract_addr(addr: __u64) -> __u64;
}
extern "C" {
    pub fn _xsk_umem__extract_offset(addr: __u64) -> __u64;
}
extern "C" {
    pub fn _xsk_umem__add_offset_to_addr(addr: __u64) -> __u64;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
impl Default for __va_list_tag {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct perf_event_attr {
    pub _address: u8,
}
