// cargo:warning=couldn't execute `llvm-config --prefix` (error: No such file or directory (os error 2))
// cargo:warning=set the LLVM_CONFIG_PATH environment variable to the full path to a valid `llvm-config` executable (including the executable itself)
/* automatically generated by rust-bindgen */

pub const AOM_IMAGE_ABI_VERSION: u32 = 9;
pub const AOM_IMG_FMT_PLANAR: u32 = 256;
pub const AOM_IMG_FMT_UV_FLIP: u32 = 512;
pub const AOM_IMG_FMT_HIGHBITDEPTH: u32 = 2048;
pub const AOM_PLANE_PACKED: u32 = 0;
pub const AOM_PLANE_Y: u32 = 0;
pub const AOM_PLANE_U: u32 = 1;
pub const AOM_PLANE_V: u32 = 2;
pub const AOM_CODEC_ABI_VERSION: u32 = 14;
pub const AOM_CODEC_CAP_DECODER: u32 = 1;
pub const AOM_CODEC_CAP_ENCODER: u32 = 2;
pub const AOM_FRAME_IS_KEY: u32 = 1;
pub const AOM_FRAME_IS_DROPPABLE: u32 = 2;
pub const AOM_FRAME_IS_INTRAONLY: u32 = 16;
pub const AOM_FRAME_IS_SWITCH: u32 = 32;
pub const AOM_FRAME_IS_ERROR_RESILIENT: u32 = 64;
pub const AOM_FRAME_IS_DELAYED_RANDOM_ACCESS_POINT: u32 = 128;
pub const AOM_ENCODER_ABI_VERSION: u32 = 22;
pub const AOM_CODEC_CAP_PSNR: u32 = 65536;
pub const AOM_CODEC_CAP_HIGHBITDEPTH: u32 = 262144;
pub const AOM_CODEC_USE_PSNR: u32 = 65536;
pub const AOM_CODEC_USE_HIGHBITDEPTH: u32 = 262144;
pub const AOM_ERROR_RESILIENT_DEFAULT: u32 = 1;
pub const AOM_EFLAG_FORCE_KF: u32 = 1;
pub const AOM_USAGE_GOOD_QUALITY: u32 = 0;
pub const AOM_USAGE_REALTIME: u32 = 1;
pub const AOM_MAXIMUM_WORK_BUFFERS: u32 = 8;
pub const AOM_MAXIMUM_REF_BUFFERS: u32 = 8;
pub const AOM_DECODER_ABI_VERSION: u32 = 20;
pub const AOM_CODEC_CAP_EXTERNAL_FRAME_BUFFER: u32 = 2097152;
pub const AOM_EFLAG_NO_REF_LAST: u32 = 65536;
pub const AOM_EFLAG_NO_REF_LAST2: u32 = 131072;
pub const AOM_EFLAG_NO_REF_LAST3: u32 = 262144;
pub const AOM_EFLAG_NO_REF_GF: u32 = 524288;
pub const AOM_EFLAG_NO_REF_ARF: u32 = 1048576;
pub const AOM_EFLAG_NO_REF_BWD: u32 = 2097152;
pub const AOM_EFLAG_NO_REF_ARF2: u32 = 4194304;
pub const AOM_EFLAG_NO_UPD_LAST: u32 = 8388608;
pub const AOM_EFLAG_NO_UPD_GF: u32 = 16777216;
pub const AOM_EFLAG_NO_UPD_ARF: u32 = 33554432;
pub const AOM_EFLAG_NO_UPD_ENTROPY: u32 = 67108864;
pub const AOM_EFLAG_NO_REF_FRAME_MVS: u32 = 134217728;
pub const AOM_EFLAG_ERROR_RESILIENT: u32 = 268435456;
pub const AOM_EFLAG_SET_S_FRAME: u32 = 536870912;
pub const AOM_EFLAG_SET_PRIMARY_REF_NONE: u32 = 1073741824;
pub const AOM_MAX_SEGMENTS: u32 = 8;
pub const AOM_MAX_LAYERS: u32 = 32;
pub const AOM_MAX_SS_LAYERS: u32 = 4;
pub const AOM_MAX_TS_LAYERS: u32 = 8;
pub const AOM_MAX_TILE_COLS: u32 = 64;
pub const AOM_MAX_TILE_ROWS: u32 = 64;
extern "C" {
    pub fn aom_uleb_size_in_bytes(value: u64) -> usize;
}
extern "C" {
    pub fn aom_uleb_decode(
        buffer: *const u8,
        available: usize,
        value: *mut u64,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aom_uleb_encode(
        value: u64,
        available: usize,
        coded_value: *mut u8,
        coded_size: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aom_uleb_encode_fixed_size(
        value: u64,
        available: usize,
        pad_to_size: usize,
        coded_value: *mut u8,
        coded_size: *mut usize,
    ) -> ::std::os::raw::c_int;
}
pub const AOM_IMG_FMT_NONE: aom_img_fmt = 0;
pub const AOM_IMG_FMT_YV12: aom_img_fmt = 769;
pub const AOM_IMG_FMT_I420: aom_img_fmt = 258;
pub const AOM_IMG_FMT_AOMYV12: aom_img_fmt = 771;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_AOMI420: aom_img_fmt = 260;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_I422: aom_img_fmt = 261;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_I444: aom_img_fmt = 262;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_I42016: aom_img_fmt = 2306;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_YV1216: aom_img_fmt = 2817;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_I42216: aom_img_fmt = 2309;
#[doc = "planar 4:2:0 format with aom color space"]
pub const AOM_IMG_FMT_I44416: aom_img_fmt = 2310;
#[doc = "List of supported image formats"]
pub type aom_img_fmt = u32;
#[doc = "List of supported image formats"]
pub use self::aom_img_fmt as aom_img_fmt_t;
#[doc = "For future use"]
pub const AOM_CICP_CP_RESERVED_0: aom_color_primaries = 0;
#[doc = "BT.709"]
pub const AOM_CICP_CP_BT_709: aom_color_primaries = 1;
#[doc = "Unspecified"]
pub const AOM_CICP_CP_UNSPECIFIED: aom_color_primaries = 2;
#[doc = "For future use"]
pub const AOM_CICP_CP_RESERVED_3: aom_color_primaries = 3;
#[doc = "BT.470 System M (historical)"]
pub const AOM_CICP_CP_BT_470_M: aom_color_primaries = 4;
#[doc = "BT.470 System B, G (historical)"]
pub const AOM_CICP_CP_BT_470_B_G: aom_color_primaries = 5;
#[doc = "BT.601"]
pub const AOM_CICP_CP_BT_601: aom_color_primaries = 6;
#[doc = "SMPTE 240"]
pub const AOM_CICP_CP_SMPTE_240: aom_color_primaries = 7;
pub const AOM_CICP_CP_GENERIC_FILM: aom_color_primaries = 8;
#[doc = "BT.2020, BT.2100"]
pub const AOM_CICP_CP_BT_2020: aom_color_primaries = 9;
#[doc = "SMPTE 428 (CIE 1921 XYZ)"]
pub const AOM_CICP_CP_XYZ: aom_color_primaries = 10;
#[doc = "SMPTE RP 431-2"]
pub const AOM_CICP_CP_SMPTE_431: aom_color_primaries = 11;
#[doc = "SMPTE EG 432-1"]
pub const AOM_CICP_CP_SMPTE_432: aom_color_primaries = 12;
#[doc = "For future use (values 13 - 21)"]
pub const AOM_CICP_CP_RESERVED_13: aom_color_primaries = 13;
#[doc = "EBU Tech. 3213-E"]
pub const AOM_CICP_CP_EBU_3213: aom_color_primaries = 22;
#[doc = "For future use (values 23 - 255)"]
pub const AOM_CICP_CP_RESERVED_23: aom_color_primaries = 23;
#[doc = "List of supported color primaries"]
pub type aom_color_primaries = u32;
#[doc = "List of supported color primaries"]
pub use self::aom_color_primaries as aom_color_primaries_t;
#[doc = "For future use"]
pub const AOM_CICP_TC_RESERVED_0: aom_transfer_characteristics = 0;
#[doc = "BT.709"]
pub const AOM_CICP_TC_BT_709: aom_transfer_characteristics = 1;
#[doc = "Unspecified"]
pub const AOM_CICP_TC_UNSPECIFIED: aom_transfer_characteristics = 2;
#[doc = "For future use"]
pub const AOM_CICP_TC_RESERVED_3: aom_transfer_characteristics = 3;
#[doc = "BT.470 System M (historical)"]
pub const AOM_CICP_TC_BT_470_M: aom_transfer_characteristics = 4;
#[doc = "BT.470 System B, G (historical)"]
pub const AOM_CICP_TC_BT_470_B_G: aom_transfer_characteristics = 5;
#[doc = "BT.601"]
pub const AOM_CICP_TC_BT_601: aom_transfer_characteristics = 6;
#[doc = "SMPTE 240 M"]
pub const AOM_CICP_TC_SMPTE_240: aom_transfer_characteristics = 7;
#[doc = "Linear"]
pub const AOM_CICP_TC_LINEAR: aom_transfer_characteristics = 8;
#[doc = "Logarithmic (100 : 1 range)"]
pub const AOM_CICP_TC_LOG_100: aom_transfer_characteristics = 9;
pub const AOM_CICP_TC_LOG_100_SQRT10: aom_transfer_characteristics = 10;
#[doc = "IEC 61966-2-4"]
pub const AOM_CICP_TC_IEC_61966: aom_transfer_characteristics = 11;
#[doc = "BT.1361"]
pub const AOM_CICP_TC_BT_1361: aom_transfer_characteristics = 12;
#[doc = "sRGB or sYCC"]
pub const AOM_CICP_TC_SRGB: aom_transfer_characteristics = 13;
#[doc = "BT.2020 10-bit systems"]
pub const AOM_CICP_TC_BT_2020_10_BIT: aom_transfer_characteristics = 14;
#[doc = "BT.2020 12-bit systems"]
pub const AOM_CICP_TC_BT_2020_12_BIT: aom_transfer_characteristics = 15;
#[doc = "SMPTE ST 2084, ITU BT.2100 PQ"]
pub const AOM_CICP_TC_SMPTE_2084: aom_transfer_characteristics = 16;
#[doc = "SMPTE ST 428"]
pub const AOM_CICP_TC_SMPTE_428: aom_transfer_characteristics = 17;
#[doc = "BT.2100 HLG, ARIB STD-B67"]
pub const AOM_CICP_TC_HLG: aom_transfer_characteristics = 18;
#[doc = "For future use (values 19-255)"]
pub const AOM_CICP_TC_RESERVED_19: aom_transfer_characteristics = 19;
#[doc = "List of supported transfer functions"]
pub type aom_transfer_characteristics = u32;
#[doc = "List of supported transfer functions"]
pub use self::aom_transfer_characteristics as aom_transfer_characteristics_t;
#[doc = "Identity matrix"]
pub const AOM_CICP_MC_IDENTITY: aom_matrix_coefficients = 0;
#[doc = "BT.709"]
pub const AOM_CICP_MC_BT_709: aom_matrix_coefficients = 1;
#[doc = "Unspecified"]
pub const AOM_CICP_MC_UNSPECIFIED: aom_matrix_coefficients = 2;
#[doc = "For future use"]
pub const AOM_CICP_MC_RESERVED_3: aom_matrix_coefficients = 3;
#[doc = "US FCC 73.628"]
pub const AOM_CICP_MC_FCC: aom_matrix_coefficients = 4;
#[doc = "BT.470 System B, G (historical)"]
pub const AOM_CICP_MC_BT_470_B_G: aom_matrix_coefficients = 5;
#[doc = "BT.601"]
pub const AOM_CICP_MC_BT_601: aom_matrix_coefficients = 6;
#[doc = "SMPTE 240 M"]
pub const AOM_CICP_MC_SMPTE_240: aom_matrix_coefficients = 7;
#[doc = "YCgCo"]
pub const AOM_CICP_MC_SMPTE_YCGCO: aom_matrix_coefficients = 8;
pub const AOM_CICP_MC_BT_2020_NCL: aom_matrix_coefficients = 9;
#[doc = "BT.2020 constant luminance"]
pub const AOM_CICP_MC_BT_2020_CL: aom_matrix_coefficients = 10;
#[doc = "SMPTE ST 2085 YDzDx"]
pub const AOM_CICP_MC_SMPTE_2085: aom_matrix_coefficients = 11;
pub const AOM_CICP_MC_CHROMAT_NCL: aom_matrix_coefficients = 12;
#[doc = "Chromaticity-derived constant luminance"]
pub const AOM_CICP_MC_CHROMAT_CL: aom_matrix_coefficients = 13;
#[doc = "BT.2100 ICtCp"]
pub const AOM_CICP_MC_ICTCP: aom_matrix_coefficients = 14;
#[doc = "For future use (values 15-255)"]
pub const AOM_CICP_MC_RESERVED_15: aom_matrix_coefficients = 15;
#[doc = "List of supported matrix coefficients"]
pub type aom_matrix_coefficients = u32;
#[doc = "List of supported matrix coefficients"]
pub use self::aom_matrix_coefficients as aom_matrix_coefficients_t;
#[doc = "Y [16..235], UV [16..240]"]
pub const AOM_CR_STUDIO_RANGE: aom_color_range = 0;
#[doc = "YUV/RGB [0..255]"]
pub const AOM_CR_FULL_RANGE: aom_color_range = 1;
#[doc = "List of supported color range"]
pub type aom_color_range = u32;
#[doc = "List of supported color range"]
pub use self::aom_color_range as aom_color_range_t;
#[doc = "Unknown"]
pub const AOM_CSP_UNKNOWN: aom_chroma_sample_position = 0;
#[doc = "Horizontally co-located with luma(0, 0)*/"]
pub const AOM_CSP_VERTICAL: aom_chroma_sample_position = 1;
#[doc = "Co-located with luma(0, 0) sample"]
pub const AOM_CSP_COLOCATED: aom_chroma_sample_position = 2;
#[doc = "Reserved value"]
pub const AOM_CSP_RESERVED: aom_chroma_sample_position = 3;
#[doc = "List of chroma sample positions"]
pub type aom_chroma_sample_position = u32;
#[doc = "List of chroma sample positions"]
pub use self::aom_chroma_sample_position as aom_chroma_sample_position_t;
#[doc = "Adds metadata if it's not keyframe"]
pub const AOM_MIF_NON_KEY_FRAME: aom_metadata_insert_flags = 0;
#[doc = "Adds metadata only if it's a keyframe"]
pub const AOM_MIF_KEY_FRAME: aom_metadata_insert_flags = 1;
#[doc = "Adds metadata to any type of frame"]
pub const AOM_MIF_ANY_FRAME: aom_metadata_insert_flags = 2;
#[doc = "List of insert flags for Metadata"]
#[doc = ""]
#[doc = " These flags control how the library treats metadata during encode."]
#[doc = ""]
#[doc = " While encoding, when metadata is added to an aom_image via"]
#[doc = " aom_img_add_metadata(), the flag passed along with the metadata will"]
#[doc = " determine where the metadata OBU will be placed in the encoded OBU stream."]
#[doc = " Metadata will be emitted into the output stream within the next temporal unit"]
#[doc = " if it satisfies the specified insertion flag."]
#[doc = ""]
#[doc = " During decoding, when the library encounters a metadata OBU, it is always"]
#[doc = " flagged as AOM_MIF_ANY_FRAME and emitted with the next output aom_image."]
pub type aom_metadata_insert_flags = u32;
#[doc = "List of insert flags for Metadata"]
#[doc = ""]
#[doc = " These flags control how the library treats metadata during encode."]
#[doc = ""]
#[doc = " While encoding, when metadata is added to an aom_image via"]
#[doc = " aom_img_add_metadata(), the flag passed along with the metadata will"]
#[doc = " determine where the metadata OBU will be placed in the encoded OBU stream."]
#[doc = " Metadata will be emitted into the output stream within the next temporal unit"]
#[doc = " if it satisfies the specified insertion flag."]
#[doc = ""]
#[doc = " During decoding, when the library encounters a metadata OBU, it is always"]
#[doc = " flagged as AOM_MIF_ANY_FRAME and emitted with the next output aom_image."]
pub use self::aom_metadata_insert_flags as aom_metadata_insert_flags_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_metadata_array {
    _unused: [u8; 0],
}
#[doc = "Array of aom_metadata structs for an image."]
pub type aom_metadata_array_t = aom_metadata_array;
#[doc = "Metadata payload."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_metadata {
    #[doc = "Metadata type"]
    pub type_: u32,
    #[doc = "Metadata payload data"]
    pub payload: *mut u8,
    #[doc = "Metadata payload size"]
    pub sz: usize,
    #[doc = "Metadata insertion flag"]
    pub insert_flag: aom_metadata_insert_flags_t,
}
#[doc = "Metadata payload."]
pub type aom_metadata_t = aom_metadata;
#[doc = "Image Descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_image {
    #[doc = "Image Format"]
    pub fmt: aom_img_fmt_t,
    #[doc = "CICP Color Primaries"]
    pub cp: aom_color_primaries_t,
    #[doc = "CICP Transfer Characteristics"]
    pub tc: aom_transfer_characteristics_t,
    #[doc = "CICP Matrix Coefficients"]
    pub mc: aom_matrix_coefficients_t,
    #[doc = "Whether image is monochrome"]
    pub monochrome: ::std::os::raw::c_int,
    #[doc = "chroma sample position"]
    pub csp: aom_chroma_sample_position_t,
    #[doc = "Color Range"]
    pub range: aom_color_range_t,
    #[doc = "Stored image width"]
    pub w: ::std::os::raw::c_uint,
    #[doc = "Stored image height"]
    pub h: ::std::os::raw::c_uint,
    #[doc = "Stored image bit-depth"]
    pub bit_depth: ::std::os::raw::c_uint,
    #[doc = "Displayed image width"]
    pub d_w: ::std::os::raw::c_uint,
    #[doc = "Displayed image height"]
    pub d_h: ::std::os::raw::c_uint,
    #[doc = "Intended rendering image width"]
    pub r_w: ::std::os::raw::c_uint,
    #[doc = "Intended rendering image height"]
    pub r_h: ::std::os::raw::c_uint,
    #[doc = "subsampling order, X"]
    pub x_chroma_shift: ::std::os::raw::c_uint,
    #[doc = "subsampling order, Y"]
    pub y_chroma_shift: ::std::os::raw::c_uint,
    #[doc = "pointer to the top left pixel for each plane"]
    pub planes: [*mut ::std::os::raw::c_uchar; 3usize],
    #[doc = "stride between rows for each plane"]
    pub stride: [::std::os::raw::c_int; 3usize],
    #[doc = "data size"]
    pub sz: usize,
    #[doc = "bits per sample (for packed formats)"]
    pub bps: ::std::os::raw::c_int,
    #[doc = "Temporal layer Id of image"]
    pub temporal_id: ::std::os::raw::c_int,
    #[doc = "Spatial layer Id of image"]
    pub spatial_id: ::std::os::raw::c_int,
    #[doc = "The following member may be set by the application to associate"]
    #[doc = " data with this image."]
    pub user_priv: *mut ::std::os::raw::c_void,
    #[doc = "private"]
    pub img_data: *mut ::std::os::raw::c_uchar,
    #[doc = "private"]
    pub img_data_owner: ::std::os::raw::c_int,
    #[doc = "private"]
    pub self_allocd: ::std::os::raw::c_int,
    #[doc = "Metadata payloads associated with the image."]
    pub metadata: *mut aom_metadata_array_t,
    #[doc = "Frame buffer data associated with the image."]
    pub fb_priv: *mut ::std::os::raw::c_void,
}
#[doc = "Image Descriptor"]
pub type aom_image_t = aom_image;
extern "C" {
    #[doc = "Open a descriptor, allocating storage for the underlying image"]
    #[doc = ""]
    #[doc = " Returns a descriptor for storing an image of the given format. The"]
    #[doc = " storage for the image is allocated on the heap."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Pointer to storage for descriptor. If this parameter"]
    #[doc = "                         is NULL, the storage for the descriptor will be"]
    #[doc = "                         allocated on the heap."]
    #[doc = " \\param[in]    fmt       Format for the image"]
    #[doc = " \\param[in]    d_w       Width of the image"]
    #[doc = " \\param[in]    d_h       Height of the image"]
    #[doc = " \\param[in]    align     Alignment, in bytes, of the image buffer and"]
    #[doc = "                         each row in the image (stride)."]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to the initialized image descriptor. If the img"]
    #[doc = "         parameter is non-null, the value of the img parameter will be"]
    #[doc = "         returned."]
    pub fn aom_img_alloc(
        img: *mut aom_image_t,
        fmt: aom_img_fmt_t,
        d_w: ::std::os::raw::c_uint,
        d_h: ::std::os::raw::c_uint,
        align: ::std::os::raw::c_uint,
    ) -> *mut aom_image_t;
}
extern "C" {
    #[doc = "Open a descriptor, using existing storage for the underlying image"]
    #[doc = ""]
    #[doc = " Returns a descriptor for storing an image of the given format. The"]
    #[doc = " storage for the image has been allocated elsewhere, and a descriptor is"]
    #[doc = " desired to \"wrap\" that storage."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Pointer to storage for descriptor. If this parameter"]
    #[doc = "                         is NULL, the storage for the descriptor will be"]
    #[doc = "                         allocated on the heap."]
    #[doc = " \\param[in]    fmt       Format for the image"]
    #[doc = " \\param[in]    d_w       Width of the image"]
    #[doc = " \\param[in]    d_h       Height of the image"]
    #[doc = " \\param[in]    align     Alignment, in bytes, of each row in the image"]
    #[doc = "                         (stride)."]
    #[doc = " \\param[in]    img_data  Storage to use for the image"]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to the initialized image descriptor. If the img"]
    #[doc = "         parameter is non-null, the value of the img parameter will be"]
    #[doc = "         returned."]
    pub fn aom_img_wrap(
        img: *mut aom_image_t,
        fmt: aom_img_fmt_t,
        d_w: ::std::os::raw::c_uint,
        d_h: ::std::os::raw::c_uint,
        align: ::std::os::raw::c_uint,
        img_data: *mut ::std::os::raw::c_uchar,
    ) -> *mut aom_image_t;
}
extern "C" {
    #[doc = "Open a descriptor, allocating storage for the underlying image with a"]
    #[doc = " border"]
    #[doc = ""]
    #[doc = " Returns a descriptor for storing an image of the given format and its"]
    #[doc = " borders. The storage for the image is allocated on the heap."]
    #[doc = ""]
    #[doc = " \\param[in]    img        Pointer to storage for descriptor. If this parameter"]
    #[doc = "                          is NULL, the storage for the descriptor will be"]
    #[doc = "                          allocated on the heap."]
    #[doc = " \\param[in]    fmt        Format for the image"]
    #[doc = " \\param[in]    d_w        Width of the image"]
    #[doc = " \\param[in]    d_h        Height of the image"]
    #[doc = " \\param[in]    align      Alignment, in bytes, of the image buffer and"]
    #[doc = "                          each row in the image (stride)."]
    #[doc = " \\param[in]    size_align Alignment, in pixels, of the image width and height."]
    #[doc = " \\param[in]    border     A border that is padded on four sides of the image."]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to the initialized image descriptor. If the img"]
    #[doc = "         parameter is non-null, the value of the img parameter will be"]
    #[doc = "         returned."]
    pub fn aom_img_alloc_with_border(
        img: *mut aom_image_t,
        fmt: aom_img_fmt_t,
        d_w: ::std::os::raw::c_uint,
        d_h: ::std::os::raw::c_uint,
        align: ::std::os::raw::c_uint,
        size_align: ::std::os::raw::c_uint,
        border: ::std::os::raw::c_uint,
    ) -> *mut aom_image_t;
}
extern "C" {
    #[doc = "Set the rectangle identifying the displayed portion of the image"]
    #[doc = ""]
    #[doc = " Updates the displayed rectangle (aka viewport) on the image surface to"]
    #[doc = " match the specified coordinates and size."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    #[doc = " \\param[in]    x         leftmost column"]
    #[doc = " \\param[in]    y         topmost row"]
    #[doc = " \\param[in]    w         width"]
    #[doc = " \\param[in]    h         height"]
    #[doc = " \\param[in]    border    A border that is padded on four sides of the image."]
    #[doc = ""]
    #[doc = " \\return 0 if the requested rectangle is valid, nonzero otherwise."]
    pub fn aom_img_set_rect(
        img: *mut aom_image_t,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
        border: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Flip the image vertically (top for bottom)"]
    #[doc = ""]
    #[doc = " Adjusts the image descriptor's pointers and strides to make the image"]
    #[doc = " be referenced upside-down."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    pub fn aom_img_flip(img: *mut aom_image_t);
}
extern "C" {
    #[doc = "Close an image descriptor"]
    #[doc = ""]
    #[doc = " Frees all allocated storage associated with an image descriptor."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    pub fn aom_img_free(img: *mut aom_image_t);
}
extern "C" {
    #[doc = "Get the width of a plane"]
    #[doc = ""]
    #[doc = " Get the width of a plane of an image"]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    #[doc = " \\param[in]    plane     Plane index"]
    pub fn aom_img_plane_width(
        img: *const aom_image_t,
        plane: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Get the height of a plane"]
    #[doc = ""]
    #[doc = " Get the height of a plane of an image"]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    #[doc = " \\param[in]    plane     Plane index"]
    pub fn aom_img_plane_height(
        img: *const aom_image_t,
        plane: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Add metadata to image."]
    #[doc = ""]
    #[doc = " Adds metadata to aom_image_t."]
    #[doc = " Function makes a copy of the provided data parameter."]
    #[doc = " Metadata insertion point is controlled by insert_flag."]
    #[doc = ""]
    #[doc = " \\param[in]    img          Image descriptor"]
    #[doc = " \\param[in]    type         Metadata type"]
    #[doc = " \\param[in]    data         Metadata contents"]
    #[doc = " \\param[in]    sz           Metadata contents size"]
    #[doc = " \\param[in]    insert_flag  Metadata insert flag"]
    #[doc = ""]
    #[doc = " \\return Returns 0 on success. If img or data is NULL, sz is 0, or memory"]
    #[doc = " allocation fails, it returns -1."]
    pub fn aom_img_add_metadata(
        img: *mut aom_image_t,
        type_: u32,
        data: *const u8,
        sz: usize,
        insert_flag: aom_metadata_insert_flags_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Return a metadata payload stored within the image metadata array."]
    #[doc = ""]
    #[doc = " Gets the metadata (aom_metadata_t) at the indicated index in the image"]
    #[doc = " metadata array."]
    #[doc = ""]
    #[doc = " \\param[in] img          Pointer to image descriptor to get metadata from"]
    #[doc = " \\param[in] index        Metadata index to get from metadata array"]
    #[doc = ""]
    #[doc = " \\return Returns a const pointer to the selected metadata, if img and/or index"]
    #[doc = " is invalid, it returns NULL."]
    pub fn aom_img_get_metadata(img: *const aom_image_t, index: usize) -> *const aom_metadata_t;
}
extern "C" {
    #[doc = "Return the number of metadata blocks within the image."]
    #[doc = ""]
    #[doc = " Gets the number of metadata blocks contained within the provided image"]
    #[doc = " metadata array."]
    #[doc = ""]
    #[doc = " \\param[in] img          Pointer to image descriptor to get metadata number"]
    #[doc = " from."]
    #[doc = ""]
    #[doc = " \\return Returns the size of the metadata array. If img or metadata is NULL,"]
    #[doc = " it returns 0."]
    pub fn aom_img_num_metadata(img: *const aom_image_t) -> usize;
}
extern "C" {
    #[doc = "Remove metadata from image."]
    #[doc = ""]
    #[doc = " Removes all metadata in image metadata list and sets metadata list pointer"]
    #[doc = " to NULL."]
    #[doc = ""]
    #[doc = " \\param[in]    img       Image descriptor"]
    pub fn aom_img_remove_metadata(img: *mut aom_image_t);
}
extern "C" {
    #[doc = "Allocate memory for aom_metadata struct."]
    #[doc = ""]
    #[doc = " Allocates storage for the metadata payload, sets its type and copies the"]
    #[doc = " payload data into the aom_metadata struct. A metadata payload buffer of size"]
    #[doc = " sz is allocated and sz bytes are copied from data into the payload buffer."]
    #[doc = ""]
    #[doc = " \\param[in]    type         Metadata type"]
    #[doc = " \\param[in]    data         Metadata data pointer"]
    #[doc = " \\param[in]    sz           Metadata size"]
    #[doc = " \\param[in]    insert_flag  Metadata insert flag"]
    #[doc = ""]
    #[doc = " \\return Returns the newly allocated aom_metadata struct. If data is NULL,"]
    #[doc = " sz is 0, or memory allocation fails, it returns NULL."]
    pub fn aom_img_metadata_alloc(
        type_: u32,
        data: *const u8,
        sz: usize,
        insert_flag: aom_metadata_insert_flags_t,
    ) -> *mut aom_metadata_t;
}
extern "C" {
    #[doc = "Free metadata struct."]
    #[doc = ""]
    #[doc = " Free metadata struct and its buffer."]
    #[doc = ""]
    #[doc = " \\param[in]    metadata       Metadata struct pointer"]
    pub fn aom_img_metadata_free(metadata: *mut aom_metadata_t);
}
#[doc = "Operation completed without error"]
pub const AOM_CODEC_OK: aom_codec_err_t = 0;
#[doc = "Unspecified error"]
pub const AOM_CODEC_ERROR: aom_codec_err_t = 1;
#[doc = "Memory operation failed"]
pub const AOM_CODEC_MEM_ERROR: aom_codec_err_t = 2;
#[doc = "ABI version mismatch"]
pub const AOM_CODEC_ABI_MISMATCH: aom_codec_err_t = 3;
#[doc = "Algorithm does not have required capability"]
pub const AOM_CODEC_INCAPABLE: aom_codec_err_t = 4;
#[doc = "The given bitstream is not supported."]
#[doc = ""]
#[doc = " The bitstream was unable to be parsed at the highest level. The decoder"]
#[doc = " is unable to proceed. This error \\ref SHOULD be treated as fatal to the"]
#[doc = " stream."]
pub const AOM_CODEC_UNSUP_BITSTREAM: aom_codec_err_t = 5;
#[doc = "Encoded bitstream uses an unsupported feature"]
#[doc = ""]
#[doc = " The decoder does not implement a feature required by the encoder. This"]
#[doc = " return code should only be used for features that prevent future"]
#[doc = " pictures from being properly decoded. This error \\ref MAY be treated as"]
#[doc = " fatal to the stream or \\ref MAY be treated as fatal to the current GOP."]
pub const AOM_CODEC_UNSUP_FEATURE: aom_codec_err_t = 6;
#[doc = "The coded data for this stream is corrupt or incomplete"]
#[doc = ""]
#[doc = " There was a problem decoding the current frame.  This return code"]
#[doc = " should only be used for failures that prevent future pictures from"]
#[doc = " being properly decoded. This error \\ref MAY be treated as fatal to the"]
#[doc = " stream or \\ref MAY be treated as fatal to the current GOP. If decoding"]
#[doc = " is continued for the current GOP, artifacts may be present."]
pub const AOM_CODEC_CORRUPT_FRAME: aom_codec_err_t = 7;
#[doc = "An application-supplied parameter is not valid."]
#[doc = ""]
pub const AOM_CODEC_INVALID_PARAM: aom_codec_err_t = 8;
#[doc = "An iterator reached the end of list."]
#[doc = ""]
pub const AOM_CODEC_LIST_END: aom_codec_err_t = 9;
#[doc = "Algorithm return codes"]
pub type aom_codec_err_t = u32;
#[doc = "Codec capabilities bitfield"]
#[doc = ""]
#[doc = "  Each codec advertises the capabilities it supports as part of its"]
#[doc = "  ::aom_codec_iface_t interface structure. Capabilities are extra interfaces"]
#[doc = "  or functionality, and are not required to be supported."]
#[doc = ""]
#[doc = "  The available flags are specified by AOM_CODEC_CAP_* defines."]
pub type aom_codec_caps_t = ::std::os::raw::c_long;
#[doc = "Initialization-time Feature Enabling"]
#[doc = ""]
#[doc = "  Certain codec features must be known at initialization time, to allow for"]
#[doc = "  proper memory allocation."]
#[doc = ""]
#[doc = "  The available flags are specified by AOM_CODEC_USE_* defines."]
pub type aom_codec_flags_t = ::std::os::raw::c_long;
#[doc = "Time Stamp Type"]
#[doc = ""]
#[doc = " An integer, which when multiplied by the stream's time base, provides"]
#[doc = " the absolute time of a sample."]
pub type aom_codec_pts_t = i64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_iface {
    _unused: [u8; 0],
}
#[doc = "Codec interface structure."]
#[doc = ""]
#[doc = " Contains function pointers and other data private to the codec"]
#[doc = " implementation. This structure is opaque to the application. Common"]
#[doc = " functions used with this structure:"]
#[doc = "   - aom_codec_iface_name(aom_codec_iface_t *iface): get the"]
#[doc = "     name of the codec"]
#[doc = "   - aom_codec_get_caps(aom_codec_iface_t *iface): returns"]
#[doc = "     the capabilities of the codec"]
#[doc = "   - aom_codec_enc_config_default: generate the default config for"]
#[doc = "     initializing the encoder (see documention in aom_encoder.h)"]
#[doc = "   - aom_codec_dec_init, aom_codec_enc_init: initialize the codec context"]
#[doc = "     structure (see documentation on aom_codec_ctx)."]
#[doc = ""]
#[doc = " To get access to the AV1 encoder and decoder, use aom_codec_av1_cx() and"]
#[doc = "  aom_codec_av1_dx()."]
pub type aom_codec_iface_t = aom_codec_iface;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_priv {
    _unused: [u8; 0],
}
#[doc = "Codec private data structure."]
#[doc = ""]
#[doc = " Contains data private to the codec implementation. This structure is opaque"]
#[doc = " to the application."]
pub type aom_codec_priv_t = aom_codec_priv;
#[doc = "Compressed Frame Flags"]
#[doc = ""]
#[doc = " This type represents a bitfield containing information about a compressed"]
#[doc = " frame that may be useful to an application. The most significant 16 bits"]
#[doc = " can be used by an algorithm to provide additional detail, for example to"]
#[doc = " support frame types that are codec specific (MPEG-1 D-frames for example)"]
pub type aom_codec_frame_flags_t = u32;
#[doc = "Iterator"]
#[doc = ""]
#[doc = " Opaque storage used for iterating over lists."]
pub type aom_codec_iter_t = *const ::std::os::raw::c_void;
#[doc = "Codec context structure"]
#[doc = ""]
#[doc = " All codecs \\ref MUST support this context structure fully. In general,"]
#[doc = " this data should be considered private to the codec algorithm, and"]
#[doc = " not be manipulated or examined by the calling application. Applications"]
#[doc = " may reference the 'name' member to get a printable description of the"]
#[doc = " algorithm."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct aom_codec_ctx {
    #[doc = "Printable interface name"]
    pub name: *const ::std::os::raw::c_char,
    #[doc = "Interface pointers"]
    pub iface: *mut aom_codec_iface_t,
    #[doc = "Last returned error"]
    pub err: aom_codec_err_t,
    #[doc = "Detailed info, if available"]
    pub err_detail: *const ::std::os::raw::c_char,
    #[doc = "Flags passed at init time"]
    pub init_flags: aom_codec_flags_t,
    #[doc = "Configuration pointer aliasing union"]
    pub config: aom_codec_ctx__bindgen_ty_1,
    #[doc = "Algorithm private storage"]
    pub priv_: *mut aom_codec_priv_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union aom_codec_ctx__bindgen_ty_1 {
    pub dec: *const aom_codec_dec_cfg,
    pub enc: *const aom_codec_enc_cfg,
    pub raw: *const ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[doc = "Codec context structure"]
#[doc = ""]
#[doc = " All codecs \\ref MUST support this context structure fully. In general,"]
#[doc = " this data should be considered private to the codec algorithm, and"]
#[doc = " not be manipulated or examined by the calling application. Applications"]
#[doc = " may reference the 'name' member to get a printable description of the"]
#[doc = " algorithm."]
pub type aom_codec_ctx_t = aom_codec_ctx;
#[doc = " 8 bits"]
pub const AOM_BITS_8: aom_bit_depth = 8;
#[doc = "10 bits"]
pub const AOM_BITS_10: aom_bit_depth = 10;
#[doc = "12 bits"]
pub const AOM_BITS_12: aom_bit_depth = 12;
#[doc = "Bit depth for codec"]
#[doc = " *"]
#[doc = " This enumeration determines the bit depth of the codec."]
pub type aom_bit_depth = u32;
#[doc = "Bit depth for codec"]
#[doc = " *"]
#[doc = " This enumeration determines the bit depth of the codec."]
pub use self::aom_bit_depth as aom_bit_depth_t;
#[doc = "Always use 64x64 superblocks."]
pub const AOM_SUPERBLOCK_SIZE_64X64: aom_superblock_size = 0;
#[doc = "Always use 128x128 superblocks."]
pub const AOM_SUPERBLOCK_SIZE_128X128: aom_superblock_size = 1;
#[doc = "Select superblock size dynamically."]
pub const AOM_SUPERBLOCK_SIZE_DYNAMIC: aom_superblock_size = 2;
#[doc = "Superblock size selection."]
#[doc = ""]
#[doc = " Defines the superblock size used for encoding. The superblock size can"]
#[doc = " either be fixed at 64x64 or 128x128 pixels, or it can be dynamically"]
#[doc = " selected by the encoder for each frame."]
pub type aom_superblock_size = u32;
#[doc = "Superblock size selection."]
#[doc = ""]
#[doc = " Defines the superblock size used for encoding. The superblock size can"]
#[doc = " either be fixed at 64x64 or 128x128 pixels, or it can be dynamically"]
#[doc = " selected by the encoder for each frame."]
pub use self::aom_superblock_size as aom_superblock_size_t;
extern "C" {
    #[doc = "Return the version information (as an integer)"]
    #[doc = ""]
    #[doc = " Returns a packed encoding of the library version number. This will only"]
    #[doc = " include the major.minor.patch component of the version number. Note that this"]
    #[doc = " encoded value should be accessed through the macros provided, as the encoding"]
    #[doc = " may change in the future."]
    #[doc = ""]
    pub fn aom_codec_version() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Return the version information (as a string)"]
    #[doc = ""]
    #[doc = " Returns a printable string containing the full library version number. This"]
    #[doc = " may contain additional text following the three digit version number, as to"]
    #[doc = " indicate release candidates, prerelease versions, etc."]
    #[doc = ""]
    pub fn aom_codec_version_str() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Return the version information (as a string)"]
    #[doc = ""]
    #[doc = " Returns a printable \"extra string\". This is the component of the string"]
    #[doc = " returned by aom_codec_version_str() following the three digit version number."]
    #[doc = ""]
    pub fn aom_codec_version_extra_str() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Return the build configuration"]
    #[doc = ""]
    #[doc = " Returns a printable string containing an encoded version of the build"]
    #[doc = " configuration. This may be useful to aom support."]
    #[doc = ""]
    pub fn aom_codec_build_config() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Return the name for a given interface"]
    #[doc = ""]
    #[doc = " Returns a human readable string for name of the given codec interface."]
    #[doc = ""]
    #[doc = " \\param[in]    iface     Interface pointer"]
    #[doc = ""]
    pub fn aom_codec_iface_name(iface: *mut aom_codec_iface_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Convert error number to printable string"]
    #[doc = ""]
    #[doc = " Returns a human readable string for the last error returned by the"]
    #[doc = " algorithm. The returned error will be one line and will not contain"]
    #[doc = " any newline characters."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " \\param[in]    err     Error number."]
    #[doc = ""]
    pub fn aom_codec_err_to_string(err: aom_codec_err_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Retrieve error synopsis for codec context"]
    #[doc = ""]
    #[doc = " Returns a human readable string for the last error returned by the"]
    #[doc = " algorithm. The returned error will be one line and will not contain"]
    #[doc = " any newline characters."]
    #[doc = ""]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context."]
    #[doc = ""]
    pub fn aom_codec_error(ctx: *mut aom_codec_ctx_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Retrieve detailed error information for codec context"]
    #[doc = ""]
    #[doc = " Returns a human readable string providing detailed information about"]
    #[doc = " the last error."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context."]
    #[doc = ""]
    #[doc = " \\retval NULL"]
    #[doc = "     No detailed information is available."]
    pub fn aom_codec_error_detail(ctx: *mut aom_codec_ctx_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Destroy a codec instance"]
    #[doc = ""]
    #[doc = " Destroys a codec context, freeing any associated memory buffers."]
    #[doc = ""]
    #[doc = " \\param[in] ctx   Pointer to this instance's context"]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The codec algorithm initialized."]
    #[doc = " \\retval #AOM_CODEC_MEM_ERROR"]
    #[doc = "     Memory allocation failed."]
    pub fn aom_codec_destroy(ctx: *mut aom_codec_ctx_t) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Get the capabilities of an algorithm."]
    #[doc = ""]
    #[doc = " Retrieves the capabilities bitfield from the algorithm's interface."]
    #[doc = ""]
    #[doc = " \\param[in] iface   Pointer to the algorithm interface"]
    #[doc = ""]
    pub fn aom_codec_get_caps(iface: *mut aom_codec_iface_t) -> aom_codec_caps_t;
}
extern "C" {
    #[doc = "\\name Codec Control"]
    #[doc = ""]
    #[doc = " The aom_codec_control function exchanges algorithm specific data with the"]
    #[doc = " codec instance. Additionally, the macro AOM_CODEC_CONTROL_TYPECHECKED is"]
    #[doc = " provided, which will type-check the parameter against the control ID before"]
    #[doc = " calling aom_codec_control - note that this macro requires the control ID"]
    #[doc = " to be directly encoded in it, e.g.,"]
    #[doc = " AOM_CODEC_CONTROL_TYPECHECKED(&ctx, AOME_SET_CPUUSED, 8)."]
    #[doc = ""]
    #[doc = " The codec control IDs can be found in aom.h, aomcx.h, and aomdx.h"]
    #[doc = " (defined as aom_com_control_id, aome_enc_control_id, and aom_dec_control_id)."]
    #[doc = " @{"]
    #[doc = ""]
    #[doc = " aom_codec_control takes a context, a control ID, and a third parameter"]
    #[doc = " (with varying type). If the context is non-null and an error occurs,"]
    #[doc = " ctx->err will be set to the same value as the return value."]
    #[doc = ""]
    #[doc = " \\param[in]     ctx              Pointer to this instance's context"]
    #[doc = " \\param[in]     ctrl_id          Algorithm specific control identifier"]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The control request was processed."]
    #[doc = " \\retval #AOM_CODEC_ERROR"]
    #[doc = "     The control request was not processed."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     The data was not valid."]
    pub fn aom_codec_control(
        ctx: *mut aom_codec_ctx_t,
        ctrl_id: ::std::os::raw::c_int,
        ...
    ) -> aom_codec_err_t;
}
pub const OBU_SEQUENCE_HEADER: OBU_TYPE = 1;
pub const OBU_TEMPORAL_DELIMITER: OBU_TYPE = 2;
pub const OBU_FRAME_HEADER: OBU_TYPE = 3;
pub const OBU_TILE_GROUP: OBU_TYPE = 4;
pub const OBU_METADATA: OBU_TYPE = 5;
pub const OBU_FRAME: OBU_TYPE = 6;
pub const OBU_REDUNDANT_FRAME_HEADER: OBU_TYPE = 7;
pub const OBU_TILE_LIST: OBU_TYPE = 8;
pub const OBU_PADDING: OBU_TYPE = 15;
#[doc = "OBU types."]
pub type OBU_TYPE = u8;
pub const OBU_METADATA_TYPE_AOM_RESERVED_0: OBU_METADATA_TYPE = 0;
pub const OBU_METADATA_TYPE_HDR_CLL: OBU_METADATA_TYPE = 1;
pub const OBU_METADATA_TYPE_HDR_MDCV: OBU_METADATA_TYPE = 2;
pub const OBU_METADATA_TYPE_SCALABILITY: OBU_METADATA_TYPE = 3;
pub const OBU_METADATA_TYPE_ITUT_T35: OBU_METADATA_TYPE = 4;
pub const OBU_METADATA_TYPE_TIMECODE: OBU_METADATA_TYPE = 5;
#[doc = "OBU metadata types."]
pub type OBU_METADATA_TYPE = u32;
extern "C" {
    #[doc = "Returns string representation of OBU_TYPE."]
    #[doc = ""]
    #[doc = " \\param[in]     type            The OBU_TYPE to convert to string."]
    pub fn aom_obu_type_to_string(type_: OBU_TYPE) -> *const ::std::os::raw::c_char;
}
#[doc = "get a pointer to a reference frame,"]
#[doc = "av1_ref_frame_t* parameter"]
pub const AV1_GET_REFERENCE: aom_com_control_id = 128;
#[doc = "write a frame into a reference buffer,"]
#[doc = "av1_ref_frame_t* parameter"]
pub const AV1_SET_REFERENCE: aom_com_control_id = 129;
#[doc = "get a copy of reference frame from the decoderm"]
#[doc = "av1_ref_frame_t* parameter"]
pub const AV1_COPY_REFERENCE: aom_com_control_id = 130;
pub const AOM_COMMON_CTRL_ID_MAX: aom_com_control_id = 131;
pub const AV1_GET_NEW_FRAME_IMAGE: aom_com_control_id = 192;
#[doc = "copy the new frame to an external buffer,"]
#[doc = "aom_image_t* parameter"]
pub const AV1_COPY_NEW_FRAME_IMAGE: aom_com_control_id = 193;
pub const AOM_DECODER_CTRL_ID_START: aom_com_control_id = 256;
#[doc = "Control functions"]
#[doc = ""]
#[doc = " The set of macros define the control functions of AOM interface"]
pub type aom_com_control_id = u32;
#[doc = "AV1 specific reference frame data struct"]
#[doc = ""]
#[doc = " Define the data struct to access av1 reference frames."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct av1_ref_frame {
    #[doc = "frame index to get (input)"]
    pub idx: ::std::os::raw::c_int,
    #[doc = "Directly use external ref buffer(decoder only)"]
    pub use_external_ref: ::std::os::raw::c_int,
    #[doc = "img structure to populate (output)"]
    pub img: aom_image_t,
}
#[doc = "AV1 specific reference frame data struct"]
#[doc = ""]
#[doc = " Define the data struct to access av1 reference frames."]
pub type av1_ref_frame_t = av1_ref_frame;
pub type aom_codec_control_type_AV1_GET_REFERENCE = *mut av1_ref_frame_t;
pub type aom_codec_control_type_AV1_SET_REFERENCE = *mut av1_ref_frame_t;
pub type aom_codec_control_type_AV1_COPY_REFERENCE = *mut av1_ref_frame_t;
pub type aom_codec_control_type_AV1_GET_NEW_FRAME_IMAGE = *mut aom_image_t;
pub type aom_codec_control_type_AV1_COPY_NEW_FRAME_IMAGE = *mut aom_image_t;
#[doc = "Generic fixed size buffer structure"]
#[doc = ""]
#[doc = " This structure is able to hold a reference to any fixed size buffer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_fixed_buf {
    #[doc = "Pointer to the data. Does NOT own the data!"]
    pub buf: *mut ::std::os::raw::c_void,
    #[doc = "Length of the buffer, in chars"]
    pub sz: usize,
}
#[doc = "Generic fixed size buffer structure"]
#[doc = ""]
#[doc = " This structure is able to hold a reference to any fixed size buffer."]
pub type aom_fixed_buf_t = aom_fixed_buf;
#[doc = "Error Resilient flags"]
#[doc = ""]
#[doc = " These flags define which error resilient features to enable in the"]
#[doc = " encoder. The flags are specified through the"]
#[doc = " aom_codec_enc_cfg::g_error_resilient variable."]
pub type aom_codec_er_flags_t = u32;
#[doc = "Compressed video frame"]
pub const AOM_CODEC_CX_FRAME_PKT: aom_codec_cx_pkt_kind = 0;
#[doc = "Two-pass statistics for this frame"]
pub const AOM_CODEC_STATS_PKT: aom_codec_cx_pkt_kind = 1;
#[doc = "first pass mb statistics for this frame"]
pub const AOM_CODEC_FPMB_STATS_PKT: aom_codec_cx_pkt_kind = 2;
#[doc = "PSNR statistics for this frame"]
pub const AOM_CODEC_PSNR_PKT: aom_codec_cx_pkt_kind = 3;
#[doc = "Algorithm extensions"]
pub const AOM_CODEC_CUSTOM_PKT: aom_codec_cx_pkt_kind = 256;
#[doc = "Encoder output packet variants"]
#[doc = ""]
#[doc = " This enumeration lists the different kinds of data packets that can be"]
#[doc = " returned by calls to aom_codec_get_cx_data(). Algorithms \\ref MAY"]
#[doc = " extend this list to provide additional functionality."]
pub type aom_codec_cx_pkt_kind = u32;
#[doc = "Encoder output packet"]
#[doc = ""]
#[doc = " This structure contains the different kinds of output data the encoder"]
#[doc = " may produce while compressing a frame."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct aom_codec_cx_pkt {
    #[doc = "packet variant"]
    pub kind: aom_codec_cx_pkt_kind,
    #[doc = "packet data"]
    pub data: aom_codec_cx_pkt__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union aom_codec_cx_pkt__bindgen_ty_1 {
    #[doc = "data for compressed frame packet"]
    pub frame: aom_codec_cx_pkt__bindgen_ty_1__bindgen_ty_1,
    #[doc = "data for two-pass packet"]
    pub twopass_stats: aom_fixed_buf_t,
    #[doc = "first pass mb packet"]
    pub firstpass_mb_stats: aom_fixed_buf_t,
    #[doc = "data for PSNR packet"]
    pub psnr: aom_codec_cx_pkt__bindgen_ty_1_aom_psnr_pkt,
    #[doc = "data for arbitrary packets"]
    pub raw: aom_fixed_buf_t,
    #[doc = "fixed sz"]
    pub pad: [::std::os::raw::c_char; 124usize],
    _bindgen_union_align: [u64; 20usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_cx_pkt__bindgen_ty_1__bindgen_ty_1 {
    #[doc = "compressed data buffer"]
    pub buf: *mut ::std::os::raw::c_void,
    #[doc = "length of compressed data"]
    pub sz: usize,
    #[doc = "time stamp to show frame (in timebase units)"]
    pub pts: aom_codec_pts_t,
    #[doc = "duration to show frame (in timebase units)"]
    pub duration: ::std::os::raw::c_ulong,
    #[doc = "flags for this frame"]
    pub flags: aom_codec_frame_flags_t,
    #[doc = "the partition id defines the decoding order of the partitions."]
    #[doc = " Only applicable when \"output partition\" mode is enabled. First"]
    #[doc = " partition has id 0."]
    pub partition_id: ::std::os::raw::c_int,
    #[doc = "size of the visible frame in this packet"]
    pub vis_frame_size: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_cx_pkt__bindgen_ty_1_aom_psnr_pkt {
    #[doc = "Number of samples, total/y/u/v"]
    pub samples: [::std::os::raw::c_uint; 4usize],
    #[doc = "sum squared error, total/y/u/v"]
    pub sse: [u64; 4usize],
    #[doc = "PSNR, total/y/u/v"]
    pub psnr: [f64; 4usize],
    #[doc = "Number of samples, total/y/u/v when"]
    #[doc = " input bit-depth < stream bit-depth."]
    pub samples_hbd: [::std::os::raw::c_uint; 4usize],
    #[doc = "sum squared error, total/y/u/v when"]
    #[doc = " input bit-depth < stream bit-depth."]
    pub sse_hbd: [u64; 4usize],
    #[doc = "PSNR, total/y/u/v when"]
    #[doc = " input bit-depth < stream bit-depth."]
    pub psnr_hbd: [f64; 4usize],
}
#[doc = "Encoder output packet"]
#[doc = ""]
#[doc = " This structure contains the different kinds of output data the encoder"]
#[doc = " may produce while compressing a frame."]
pub type aom_codec_cx_pkt_t = aom_codec_cx_pkt;
#[doc = "Rational Number"]
#[doc = ""]
#[doc = " This structure holds a fractional value."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_rational {
    #[doc = "fraction numerator"]
    pub num: ::std::os::raw::c_int,
    #[doc = "fraction denominator"]
    pub den: ::std::os::raw::c_int,
}
#[doc = "Rational Number"]
#[doc = ""]
#[doc = " This structure holds a fractional value."]
pub type aom_rational_t = aom_rational;
#[doc = "Single pass mode"]
pub const AOM_RC_ONE_PASS: aom_enc_pass = 0;
#[doc = "First pass of multi-pass mode"]
pub const AOM_RC_FIRST_PASS: aom_enc_pass = 1;
#[doc = "Final pass of multi-pass mode"]
pub const AOM_RC_LAST_PASS: aom_enc_pass = 2;
#[doc = "Multi-pass Encoding Pass"]
pub type aom_enc_pass = u32;
#[doc = "Variable Bit Rate (VBR) mode"]
pub const AOM_VBR: aom_rc_mode = 0;
#[doc = "Constant Bit Rate (CBR) mode"]
pub const AOM_CBR: aom_rc_mode = 1;
#[doc = "Constrained Quality (CQ)  mode"]
pub const AOM_CQ: aom_rc_mode = 2;
#[doc = "Constant Quality (Q) mode"]
pub const AOM_Q: aom_rc_mode = 3;
#[doc = "Rate control mode"]
pub type aom_rc_mode = u32;
#[doc = "deprecated, implies AOM_KF_DISABLED"]
pub const AOM_KF_FIXED: aom_kf_mode = 0;
#[doc = "Encoder determines optimal placement automatically"]
pub const AOM_KF_AUTO: aom_kf_mode = 1;
#[doc = "Encoder does not place keyframes."]
pub const AOM_KF_DISABLED: aom_kf_mode = 0;
#[doc = "Keyframe placement mode."]
#[doc = ""]
#[doc = " This enumeration determines whether keyframes are placed automatically by"]
#[doc = " the encoder or whether this behavior is disabled. Older releases of this"]
#[doc = " SDK were implemented such that AOM_KF_FIXED meant keyframes were disabled."]
#[doc = " This name is confusing for this behavior, so the new symbols to be used"]
#[doc = " are AOM_KF_AUTO and AOM_KF_DISABLED."]
pub type aom_kf_mode = u32;
pub const AOM_SUPERRES_NONE: aom_superres_mode = 0;
pub const AOM_SUPERRES_FIXED: aom_superres_mode = 1;
pub const AOM_SUPERRES_RANDOM: aom_superres_mode = 2;
pub const AOM_SUPERRES_QTHRESH: aom_superres_mode = 3;
pub const AOM_SUPERRES_AUTO: aom_superres_mode = 4;
#[doc = "Frame super-resolution mode."]
pub type aom_superres_mode = u32;
#[doc = "Encoder Config Options"]
#[doc = ""]
#[doc = " This type allows to enumerate and control flags defined for encoder control"]
#[doc = " via config file at runtime."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cfg_options {
    #[doc = "Indicate init by cfg file"]
    #[doc = " 0 or 1"]
    pub init_by_cfg_file: ::std::os::raw::c_uint,
    #[doc = "Superblock size"]
    #[doc = " 0, 64 or 128"]
    pub super_block_size: ::std::os::raw::c_uint,
    #[doc = "max partition size"]
    #[doc = " 8, 16, 32, 64, 128"]
    pub max_partition_size: ::std::os::raw::c_uint,
    #[doc = "min partition size"]
    #[doc = " 8, 16, 32, 64, 128"]
    pub min_partition_size: ::std::os::raw::c_uint,
    #[doc = "disable AB Shape partition type"]
    #[doc = ""]
    pub disable_ab_partition_type: ::std::os::raw::c_uint,
    #[doc = "disable rectangular partition type"]
    #[doc = ""]
    pub disable_rect_partition_type: ::std::os::raw::c_uint,
    #[doc = "disable 1:4/4:1 partition type"]
    #[doc = ""]
    pub disable_1to4_partition_type: ::std::os::raw::c_uint,
    #[doc = "disable flip and identity transform type"]
    #[doc = ""]
    pub disable_flip_idtx: ::std::os::raw::c_uint,
    #[doc = "disable CDEF filter"]
    #[doc = ""]
    pub disable_cdef: ::std::os::raw::c_uint,
    #[doc = "disable Loop Restoration Filter"]
    #[doc = ""]
    pub disable_lr: ::std::os::raw::c_uint,
    #[doc = "disable OBMC"]
    #[doc = ""]
    pub disable_obmc: ::std::os::raw::c_uint,
    #[doc = "disable Warped Motion"]
    #[doc = ""]
    pub disable_warp_motion: ::std::os::raw::c_uint,
    #[doc = "disable global motion"]
    #[doc = ""]
    pub disable_global_motion: ::std::os::raw::c_uint,
    #[doc = "disable dist weighted compound"]
    #[doc = ""]
    pub disable_dist_wtd_comp: ::std::os::raw::c_uint,
    #[doc = "disable diff weighted compound"]
    #[doc = ""]
    pub disable_diff_wtd_comp: ::std::os::raw::c_uint,
    #[doc = "disable inter/intra compound"]
    #[doc = ""]
    pub disable_inter_intra_comp: ::std::os::raw::c_uint,
    #[doc = "disable masked compound"]
    #[doc = ""]
    pub disable_masked_comp: ::std::os::raw::c_uint,
    #[doc = "disable one sided compound"]
    #[doc = ""]
    pub disable_one_sided_comp: ::std::os::raw::c_uint,
    #[doc = "disable Palette"]
    #[doc = ""]
    pub disable_palette: ::std::os::raw::c_uint,
    #[doc = "disable Intra Block Copy"]
    #[doc = ""]
    pub disable_intrabc: ::std::os::raw::c_uint,
    #[doc = "disable chroma from luma"]
    #[doc = ""]
    pub disable_cfl: ::std::os::raw::c_uint,
    #[doc = "disable intra smooth mode"]
    #[doc = ""]
    pub disable_smooth_intra: ::std::os::raw::c_uint,
    #[doc = "disable filter intra"]
    #[doc = ""]
    pub disable_filter_intra: ::std::os::raw::c_uint,
    #[doc = "disable dual filter"]
    #[doc = ""]
    pub disable_dual_filter: ::std::os::raw::c_uint,
    #[doc = "disable intra angle delta"]
    #[doc = ""]
    pub disable_intra_angle_delta: ::std::os::raw::c_uint,
    #[doc = "disable intra edge filter"]
    #[doc = ""]
    pub disable_intra_edge_filter: ::std::os::raw::c_uint,
    #[doc = "disable 64x64 transform"]
    #[doc = ""]
    pub disable_tx_64x64: ::std::os::raw::c_uint,
    #[doc = "disable smooth inter/intra"]
    #[doc = ""]
    pub disable_smooth_inter_intra: ::std::os::raw::c_uint,
    #[doc = "disable inter/inter wedge comp"]
    #[doc = ""]
    pub disable_inter_inter_wedge: ::std::os::raw::c_uint,
    #[doc = "disable inter/intra wedge comp"]
    #[doc = ""]
    pub disable_inter_intra_wedge: ::std::os::raw::c_uint,
    #[doc = "disable paeth intra"]
    #[doc = ""]
    pub disable_paeth_intra: ::std::os::raw::c_uint,
    #[doc = "disable trellis quantization"]
    #[doc = ""]
    pub disable_trellis_quant: ::std::os::raw::c_uint,
    #[doc = "disable ref frame MV"]
    #[doc = ""]
    pub disable_ref_frame_mv: ::std::os::raw::c_uint,
    #[doc = "use reduced reference frame set"]
    #[doc = ""]
    pub reduced_reference_set: ::std::os::raw::c_uint,
    #[doc = "use reduced transform type set"]
    #[doc = ""]
    pub reduced_tx_type_set: ::std::os::raw::c_uint,
}
#[doc = "Encoder Config Options"]
#[doc = ""]
#[doc = " This type allows to enumerate and control flags defined for encoder control"]
#[doc = " via config file at runtime."]
pub type cfg_options_t = cfg_options;
#[doc = "Encoded Frame Flags"]
#[doc = ""]
#[doc = " This type indicates a bitfield to be passed to aom_codec_encode(), defining"]
#[doc = " per-frame boolean values. By convention, bits common to all codecs will be"]
#[doc = " named AOM_EFLAG_*, and bits specific to an algorithm will be named"]
#[doc = " /algo/_eflag_*. The lower order 16 bits are reserved for common use."]
pub type aom_enc_frame_flags_t = ::std::os::raw::c_long;
#[doc = "Encoder configuration structure"]
#[doc = ""]
#[doc = " This structure contains the encoder settings that have common representations"]
#[doc = " across all codecs. This doesn't imply that all codecs support all features,"]
#[doc = " however."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct aom_codec_enc_cfg {
    #[doc = "Algorithm specific \"usage\" value"]
    #[doc = ""]
    #[doc = " Algorithms may define multiple values for usage, which may convey the"]
    #[doc = " intent of how the application intends to use the stream. If this value"]
    #[doc = " is non-zero, consult the documentation for the codec to determine its"]
    #[doc = " meaning."]
    pub g_usage: ::std::os::raw::c_uint,
    #[doc = "Maximum number of threads to use"]
    #[doc = ""]
    #[doc = " For multi-threaded implementations, use no more than this number of"]
    #[doc = " threads. The codec may use fewer threads than allowed. The value"]
    #[doc = " 0 is equivalent to the value 1."]
    pub g_threads: ::std::os::raw::c_uint,
    #[doc = "profile of bitstream to use"]
    pub g_profile: ::std::os::raw::c_uint,
    #[doc = "Width of the frame"]
    #[doc = ""]
    #[doc = " This value identifies the presentation resolution of the frame,"]
    #[doc = " in pixels. Note that the frames passed as input to the encoder must"]
    #[doc = " have this resolution. Frames will be presented by the decoder in this"]
    #[doc = " resolution, independent of any spatial resampling the encoder may do."]
    pub g_w: ::std::os::raw::c_uint,
    #[doc = "Height of the frame"]
    #[doc = ""]
    #[doc = " This value identifies the presentation resolution of the frame,"]
    #[doc = " in pixels. Note that the frames passed as input to the encoder must"]
    #[doc = " have this resolution. Frames will be presented by the decoder in this"]
    #[doc = " resolution, independent of any spatial resampling the encoder may do."]
    pub g_h: ::std::os::raw::c_uint,
    #[doc = "Max number of frames to encode"]
    #[doc = ""]
    pub g_limit: ::std::os::raw::c_uint,
    #[doc = "Forced maximum width of the frame"]
    #[doc = ""]
    #[doc = " If this value is non-zero then it is used to force the maximum frame"]
    #[doc = " width written in write_sequence_header()."]
    pub g_forced_max_frame_width: ::std::os::raw::c_uint,
    #[doc = "Forced maximum height of the frame"]
    #[doc = ""]
    #[doc = " If this value is non-zero then it is used to force the maximum frame"]
    #[doc = " height written in write_sequence_header()."]
    pub g_forced_max_frame_height: ::std::os::raw::c_uint,
    #[doc = "Bit-depth of the codec"]
    #[doc = ""]
    #[doc = " This value identifies the bit_depth of the codec,"]
    #[doc = " Only certain bit-depths are supported as identified in the"]
    #[doc = " aom_bit_depth_t enum."]
    pub g_bit_depth: aom_bit_depth_t,
    #[doc = "Bit-depth of the input frames"]
    #[doc = ""]
    #[doc = " This value identifies the bit_depth of the input frames in bits."]
    #[doc = " Note that the frames passed as input to the encoder must have"]
    #[doc = " this bit-depth."]
    pub g_input_bit_depth: ::std::os::raw::c_uint,
    #[doc = "Stream timebase units"]
    #[doc = ""]
    #[doc = " Indicates the smallest interval of time, in seconds, used by the stream."]
    #[doc = " For fixed frame rate material, or variable frame rate material where"]
    #[doc = " frames are timed at a multiple of a given clock (ex: video capture),"]
    #[doc = " the \\ref RECOMMENDED method is to set the timebase to the reciprocal"]
    #[doc = " of the frame rate (ex: 1001/30000 for 29.970 Hz NTSC). This allows the"]
    #[doc = " pts to correspond to the frame number, which can be handy. For"]
    #[doc = " re-encoding video from containers with absolute time timestamps, the"]
    #[doc = " \\ref RECOMMENDED method is to set the timebase to that of the parent"]
    #[doc = " container or multimedia framework (ex: 1/1000 for ms, as in FLV)."]
    pub g_timebase: aom_rational,
    #[doc = "Enable error resilient modes."]
    #[doc = ""]
    #[doc = " The error resilient bitfield indicates to the encoder which features"]
    #[doc = " it should enable to take measures for streaming over lossy or noisy"]
    #[doc = " links."]
    pub g_error_resilient: aom_codec_er_flags_t,
    #[doc = "Multi-pass Encoding Mode"]
    #[doc = ""]
    #[doc = " This value should be set to the current phase for multi-pass encoding."]
    #[doc = " For single pass, set to #AOM_RC_ONE_PASS."]
    pub g_pass: aom_enc_pass,
    #[doc = "Allow lagged encoding"]
    #[doc = ""]
    #[doc = " If set, this value allows the encoder to consume a number of input"]
    #[doc = " frames before producing output frames. This allows the encoder to"]
    #[doc = " base decisions for the current frame on future frames. This does"]
    #[doc = " increase the latency of the encoding pipeline, so it is not appropriate"]
    #[doc = " in all situations (ex: realtime encoding)."]
    #[doc = ""]
    #[doc = " Note that this is a maximum value -- the encoder may produce frames"]
    #[doc = " sooner than the given limit. Set this value to 0 to disable this"]
    #[doc = " feature."]
    pub g_lag_in_frames: ::std::os::raw::c_uint,
    #[doc = "Temporal resampling configuration, if supported by the codec."]
    #[doc = ""]
    #[doc = " Temporal resampling allows the codec to \"drop\" frames as a strategy to"]
    #[doc = " meet its target data rate. This can cause temporal discontinuities in"]
    #[doc = " the encoded video, which may appear as stuttering during playback. This"]
    #[doc = " trade-off is often acceptable, but for many applications is not. It can"]
    #[doc = " be disabled in these cases."]
    #[doc = ""]
    #[doc = " Note that not all codecs support this feature. All aom AVx codecs do."]
    #[doc = " For other codecs, consult the documentation for that algorithm."]
    #[doc = ""]
    #[doc = " This threshold is described as a percentage of the target data buffer."]
    #[doc = " When the data buffer falls below this percentage of fullness, a"]
    #[doc = " dropped frame is indicated. Set the threshold to zero (0) to disable"]
    #[doc = " this feature."]
    pub rc_dropframe_thresh: ::std::os::raw::c_uint,
    #[doc = "Mode for spatial resampling, if supported by the codec."]
    #[doc = ""]
    #[doc = " Spatial resampling allows the codec to compress a lower resolution"]
    #[doc = " version of the frame, which is then upscaled by the decoder to the"]
    #[doc = " correct presentation resolution. This increases visual quality at"]
    #[doc = " low data rates, at the expense of CPU time on the encoder/decoder."]
    pub rc_resize_mode: ::std::os::raw::c_uint,
    #[doc = "Frame resize denominator."]
    #[doc = ""]
    #[doc = " The denominator for resize to use, assuming 8 as the numerator."]
    #[doc = ""]
    #[doc = " Valid denominators are  8 - 16 for now."]
    pub rc_resize_denominator: ::std::os::raw::c_uint,
    #[doc = "Keyframe resize denominator."]
    #[doc = ""]
    #[doc = " The denominator for resize to use, assuming 8 as the numerator."]
    #[doc = ""]
    #[doc = " Valid denominators are  8 - 16 for now."]
    pub rc_resize_kf_denominator: ::std::os::raw::c_uint,
    #[doc = "Frame super-resolution scaling mode."]
    #[doc = ""]
    #[doc = " Similar to spatial resampling, frame super-resolution integrates"]
    #[doc = " upscaling after the encode/decode process. Taking control of upscaling and"]
    #[doc = " using restoration filters should allow it to outperform normal resizing."]
    pub rc_superres_mode: aom_superres_mode,
    #[doc = "Frame super-resolution denominator."]
    #[doc = ""]
    #[doc = " The denominator for superres to use. If fixed it will only change if the"]
    #[doc = " cumulative scale change over resizing and superres is greater than 1/2;"]
    #[doc = " this forces superres to reduce scaling."]
    #[doc = ""]
    #[doc = " Valid denominators are 8 to 16."]
    #[doc = ""]
    #[doc = " Used only by AOM_SUPERRES_FIXED."]
    pub rc_superres_denominator: ::std::os::raw::c_uint,
    #[doc = "Keyframe super-resolution denominator."]
    #[doc = ""]
    #[doc = " The denominator for superres to use. If fixed it will only change if the"]
    #[doc = " cumulative scale change over resizing and superres is greater than 1/2;"]
    #[doc = " this forces superres to reduce scaling."]
    #[doc = ""]
    #[doc = " Valid denominators are 8 - 16 for now."]
    pub rc_superres_kf_denominator: ::std::os::raw::c_uint,
    #[doc = "Frame super-resolution q threshold."]
    #[doc = ""]
    #[doc = " The q level threshold after which superres is used."]
    #[doc = " Valid values are 1 to 63."]
    #[doc = ""]
    #[doc = " Used only by AOM_SUPERRES_QTHRESH"]
    pub rc_superres_qthresh: ::std::os::raw::c_uint,
    #[doc = "Keyframe super-resolution q threshold."]
    #[doc = ""]
    #[doc = " The q level threshold after which superres is used for key frames."]
    #[doc = " Valid values are 1 to 63."]
    #[doc = ""]
    #[doc = " Used only by AOM_SUPERRES_QTHRESH"]
    pub rc_superres_kf_qthresh: ::std::os::raw::c_uint,
    #[doc = "Rate control algorithm to use."]
    #[doc = ""]
    #[doc = " Indicates whether the end usage of this stream is to be streamed over"]
    #[doc = " a bandwidth constrained link, indicating that Constant Bit Rate (CBR)"]
    #[doc = " mode should be used, or whether it will be played back on a high"]
    #[doc = " bandwidth link, as from a local disk, where higher variations in"]
    #[doc = " bitrate are acceptable."]
    pub rc_end_usage: aom_rc_mode,
    #[doc = "Two-pass stats buffer."]
    #[doc = ""]
    #[doc = " A buffer containing all of the stats packets produced in the first"]
    #[doc = " pass, concatenated."]
    pub rc_twopass_stats_in: aom_fixed_buf_t,
    #[doc = "first pass mb stats buffer."]
    #[doc = ""]
    #[doc = " A buffer containing all of the first pass mb stats packets produced"]
    #[doc = " in the first pass, concatenated."]
    pub rc_firstpass_mb_stats_in: aom_fixed_buf_t,
    #[doc = "Target data rate"]
    #[doc = ""]
    #[doc = " Target bandwidth to use for this stream, in kilobits per second."]
    pub rc_target_bitrate: ::std::os::raw::c_uint,
    #[doc = "Minimum (Best Quality) Quantizer"]
    #[doc = ""]
    #[doc = " The quantizer is the most direct control over the quality of the"]
    #[doc = " encoded image. The range of valid values for the quantizer is codec"]
    #[doc = " specific. Consult the documentation for the codec to determine the"]
    #[doc = " values to use. To determine the range programmatically, call"]
    #[doc = " aom_codec_enc_config_default() with a usage value of 0."]
    pub rc_min_quantizer: ::std::os::raw::c_uint,
    #[doc = "Maximum (Worst Quality) Quantizer"]
    #[doc = ""]
    #[doc = " The quantizer is the most direct control over the quality of the"]
    #[doc = " encoded image. The range of valid values for the quantizer is codec"]
    #[doc = " specific. Consult the documentation for the codec to determine the"]
    #[doc = " values to use. To determine the range programmatically, call"]
    #[doc = " aom_codec_enc_config_default() with a usage value of 0."]
    pub rc_max_quantizer: ::std::os::raw::c_uint,
    #[doc = "Rate control adaptation undershoot control"]
    #[doc = ""]
    #[doc = " This value, controls the tolerance of the VBR algorithm to undershoot"]
    #[doc = " and is used as a trigger threshold for more agressive adaptation of Q."]
    #[doc = ""]
    #[doc = " Valid values in the range 0-100."]
    pub rc_undershoot_pct: ::std::os::raw::c_uint,
    #[doc = "Rate control adaptation overshoot control"]
    #[doc = ""]
    #[doc = " This value, controls the tolerance of the VBR algorithm to overshoot"]
    #[doc = " and is used as a trigger threshold for more agressive adaptation of Q."]
    #[doc = ""]
    #[doc = " Valid values in the range 0-1000."]
    pub rc_overshoot_pct: ::std::os::raw::c_uint,
    #[doc = "Decoder Buffer Size"]
    #[doc = ""]
    #[doc = " This value indicates the amount of data that may be buffered by the"]
    #[doc = " decoding application. Note that this value is expressed in units of"]
    #[doc = " time (milliseconds). For example, a value of 5000 indicates that the"]
    #[doc = " client will buffer (at least) 5000ms worth of encoded data. Use the"]
    #[doc = " target bitrate (#rc_target_bitrate) to convert to bits/bytes, if"]
    #[doc = " necessary."]
    pub rc_buf_sz: ::std::os::raw::c_uint,
    #[doc = "Decoder Buffer Initial Size"]
    #[doc = ""]
    #[doc = " This value indicates the amount of data that will be buffered by the"]
    #[doc = " decoding application prior to beginning playback. This value is"]
    #[doc = " expressed in units of time (milliseconds). Use the target bitrate"]
    #[doc = " (#rc_target_bitrate) to convert to bits/bytes, if necessary."]
    pub rc_buf_initial_sz: ::std::os::raw::c_uint,
    #[doc = "Decoder Buffer Optimal Size"]
    #[doc = ""]
    #[doc = " This value indicates the amount of data that the encoder should try"]
    #[doc = " to maintain in the decoder's buffer. This value is expressed in units"]
    #[doc = " of time (milliseconds). Use the target bitrate (#rc_target_bitrate)"]
    #[doc = " to convert to bits/bytes, if necessary."]
    pub rc_buf_optimal_sz: ::std::os::raw::c_uint,
    #[doc = "Two-pass mode CBR/VBR bias"]
    #[doc = ""]
    #[doc = " Bias, expressed on a scale of 0 to 100, for determining target size"]
    #[doc = " for the current frame. The value 0 indicates the optimal CBR mode"]
    #[doc = " value should be used. The value 100 indicates the optimal VBR mode"]
    #[doc = " value should be used. Values in between indicate which way the"]
    #[doc = " encoder should \"lean.\""]
    pub rc_2pass_vbr_bias_pct: ::std::os::raw::c_uint,
    #[doc = "Two-pass mode per-GOP minimum bitrate"]
    #[doc = ""]
    #[doc = " This value, expressed as a percentage of the target bitrate, indicates"]
    #[doc = " the minimum bitrate to be used for a single GOP (aka \"section\")"]
    pub rc_2pass_vbr_minsection_pct: ::std::os::raw::c_uint,
    #[doc = "Two-pass mode per-GOP maximum bitrate"]
    #[doc = ""]
    #[doc = " This value, expressed as a percentage of the target bitrate, indicates"]
    #[doc = " the maximum bitrate to be used for a single GOP (aka \"section\")"]
    pub rc_2pass_vbr_maxsection_pct: ::std::os::raw::c_uint,
    #[doc = "Option to enable forward reference key frame"]
    #[doc = ""]
    pub fwd_kf_enabled: ::std::os::raw::c_int,
    #[doc = "Keyframe placement mode"]
    #[doc = ""]
    #[doc = " This value indicates whether the encoder should place keyframes at a"]
    #[doc = " fixed interval, or determine the optimal placement automatically"]
    #[doc = " (as governed by the #kf_min_dist and #kf_max_dist parameters)"]
    pub kf_mode: aom_kf_mode,
    #[doc = "Keyframe minimum interval"]
    #[doc = ""]
    #[doc = " This value, expressed as a number of frames, prevents the encoder from"]
    #[doc = " placing a keyframe nearer than kf_min_dist to the previous keyframe. At"]
    #[doc = " least kf_min_dist frames non-keyframes will be coded before the next"]
    #[doc = " keyframe. Set kf_min_dist equal to kf_max_dist for a fixed interval."]
    pub kf_min_dist: ::std::os::raw::c_uint,
    #[doc = "Keyframe maximum interval"]
    #[doc = ""]
    #[doc = " This value, expressed as a number of frames, forces the encoder to code"]
    #[doc = " a keyframe if one has not been coded in the last kf_max_dist frames."]
    #[doc = " A value of 0 implies all frames will be keyframes. Set kf_min_dist"]
    #[doc = " equal to kf_max_dist for a fixed interval."]
    pub kf_max_dist: ::std::os::raw::c_uint,
    #[doc = "sframe interval"]
    #[doc = ""]
    #[doc = " This value, expressed as a number of frames, forces the encoder to code"]
    #[doc = " an S-Frame every sframe_dist frames."]
    pub sframe_dist: ::std::os::raw::c_uint,
    #[doc = "sframe insertion mode"]
    #[doc = ""]
    #[doc = " This value must be set to 1 or 2, and tells the encoder how to insert"]
    #[doc = " S-Frames. It will only have an effect if sframe_dist != 0."]
    #[doc = ""]
    #[doc = " If altref is enabled:"]
    #[doc = "   - if sframe_mode == 1, the considered frame will be made into an"]
    #[doc = "     S-Frame only if it is an altref frame"]
    #[doc = "   - if sframe_mode == 2, the next altref frame will be made into an"]
    #[doc = "     S-Frame."]
    #[doc = ""]
    #[doc = " Otherwise: the considered frame will be made into an S-Frame."]
    pub sframe_mode: ::std::os::raw::c_uint,
    #[doc = "Tile coding mode"]
    #[doc = ""]
    #[doc = " This value indicates the tile coding mode."]
    #[doc = " A value of 0 implies a normal non-large-scale tile coding. A value of 1"]
    #[doc = " implies a large-scale tile coding."]
    pub large_scale_tile: ::std::os::raw::c_uint,
    #[doc = "Monochrome mode"]
    #[doc = ""]
    #[doc = " If this is nonzero, the encoder will generate a monochrome stream"]
    #[doc = " with no chroma planes."]
    pub monochrome: ::std::os::raw::c_uint,
    #[doc = "full_still_picture_hdr"]
    #[doc = ""]
    #[doc = " If this is nonzero, the encoder will generate a full header even for"]
    #[doc = " still picture encoding. if zero, a reduced header is used for still"]
    #[doc = " picture. This flag has no effect when a regular video with more than"]
    #[doc = " a single frame is encoded."]
    pub full_still_picture_hdr: ::std::os::raw::c_uint,
    #[doc = "Bitstream syntax mode"]
    #[doc = ""]
    #[doc = " This value indicates the bitstream syntax mode."]
    #[doc = " A value of 0 indicates bitstream is saved as Section 5 bitstream. A value"]
    #[doc = " of 1 indicates the bitstream is saved in Annex-B format"]
    pub save_as_annexb: ::std::os::raw::c_uint,
    #[doc = "Number of explicit tile widths specified"]
    #[doc = ""]
    #[doc = " This value indicates the number of tile widths specified"]
    #[doc = " A value of 0 implies no tile widths are specified."]
    #[doc = " Tile widths are given in the array tile_widths[]"]
    pub tile_width_count: ::std::os::raw::c_int,
    #[doc = "Number of explicit tile heights specified"]
    #[doc = ""]
    #[doc = " This value indicates the number of tile heights specified"]
    #[doc = " A value of 0 implies no tile heights are specified."]
    #[doc = " Tile heights are given in the array tile_heights[]"]
    pub tile_height_count: ::std::os::raw::c_int,
    #[doc = "Array of specified tile widths"]
    #[doc = ""]
    #[doc = " This array specifies tile widths (and may be empty)"]
    #[doc = " The number of widths specified is given by tile_width_count"]
    pub tile_widths: [::std::os::raw::c_int; 64usize],
    #[doc = "Array of specified tile heights"]
    #[doc = ""]
    #[doc = " This array specifies tile heights (and may be empty)"]
    #[doc = " The number of heights specified is given by tile_height_count"]
    pub tile_heights: [::std::os::raw::c_int; 64usize],
    #[doc = "Whether encoder should use fixed QP offsets."]
    #[doc = ""]
    #[doc = " If a value of 1 is provided, encoder will use fixed QP offsets for frames"]
    #[doc = " at different levels of the pyramid."]
    #[doc = " - If 'fixed_qp_offsets' is also provided, encoder will use the given"]
    #[doc = " offsets"]
    #[doc = " - If not, encoder will select the fixed offsets based on the cq-level"]
    #[doc = "   provided."]
    #[doc = " If a value of 0 is provided and fixed_qp_offset are not provided, encoder"]
    #[doc = " will NOT use fixed QP offsets."]
    #[doc = " Note: This option is only relevant for --end-usage=q."]
    pub use_fixed_qp_offsets: ::std::os::raw::c_uint,
    #[doc = "Array of fixed QP offsets"]
    #[doc = ""]
    #[doc = " This array specifies fixed QP offsets (range: 0 to 63) for frames at"]
    #[doc = " different levels of the pyramid. It is a comma-separated list of 5 values:"]
    #[doc = " - QP offset for keyframe"]
    #[doc = " - QP offset for ALTREF frame"]
    #[doc = " - QP offset for 1st level internal ARF"]
    #[doc = " - QP offset for 2nd level internal ARF"]
    #[doc = " - QP offset for 3rd level internal ARF"]
    #[doc = " Notes:"]
    #[doc = " - QP offset for leaf level frames is not explicitly specified. These frames"]
    #[doc = "   use the worst quality allowed (--cq-level)."]
    #[doc = " - This option is only relevant for --end-usage=q."]
    pub fixed_qp_offsets: [::std::os::raw::c_int; 5usize],
    #[doc = "Options defined per config file"]
    #[doc = ""]
    pub encoder_cfg: cfg_options_t,
}
#[doc = "Encoder configuration structure"]
#[doc = ""]
#[doc = " This structure contains the encoder settings that have common representations"]
#[doc = " across all codecs. This doesn't imply that all codecs support all features,"]
#[doc = " however."]
pub type aom_codec_enc_cfg_t = aom_codec_enc_cfg;
extern "C" {
    #[doc = "Initialize an encoder instance"]
    #[doc = ""]
    #[doc = " Initializes a encoder context using the given interface. Applications"]
    #[doc = " should call the aom_codec_enc_init convenience macro instead of this"]
    #[doc = " function directly, to ensure that the ABI version number parameter"]
    #[doc = " is properly initialized."]
    #[doc = ""]
    #[doc = " If the library was configured with --disable-multithread, this call"]
    #[doc = " is not thread safe and should be guarded with a lock if being used"]
    #[doc = " in a multithreaded context."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context."]
    #[doc = " \\param[in]    iface   Pointer to the algorithm interface to use."]
    #[doc = " \\param[in]    cfg     Configuration to use, if known."]
    #[doc = " \\param[in]    flags   Bitfield of AOM_CODEC_USE_* flags"]
    #[doc = " \\param[in]    ver     ABI version number. Must be set to"]
    #[doc = "                       AOM_ENCODER_ABI_VERSION"]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The decoder algorithm initialized."]
    #[doc = " \\retval #AOM_CODEC_MEM_ERROR"]
    #[doc = "     Memory allocation failed."]
    pub fn aom_codec_enc_init_ver(
        ctx: *mut aom_codec_ctx_t,
        iface: *mut aom_codec_iface_t,
        cfg: *const aom_codec_enc_cfg_t,
        flags: aom_codec_flags_t,
        ver: ::std::os::raw::c_int,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Get the default configuration for a usage."]
    #[doc = ""]
    #[doc = " Initializes an encoder configuration structure with default values. Supports"]
    #[doc = " the notion of \"usages\" so that an algorithm may offer different default"]
    #[doc = " settings depending on the user's intended goal. This function \\ref SHOULD"]
    #[doc = " be called by all applications to initialize the configuration structure"]
    #[doc = " before specializing the configuration with application specific values."]
    #[doc = ""]
    #[doc = " \\param[in]    iface     Pointer to the algorithm interface to use."]
    #[doc = " \\param[out]   cfg       Configuration buffer to populate."]
    #[doc = " \\param[in]    usage     Algorithm specific usage value. For AV1, must be"]
    #[doc = "                         set to AOM_USAGE_GOOD_QUALITY (0) or"]
    #[doc = "                         AOM_USAGE_REALTIME (1)."]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The configuration was populated."]
    #[doc = " \\retval #AOM_CODEC_INCAPABLE"]
    #[doc = "     Interface is not an encoder interface."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     A parameter was NULL, or the usage value was not recognized."]
    pub fn aom_codec_enc_config_default(
        iface: *mut aom_codec_iface_t,
        cfg: *mut aom_codec_enc_cfg_t,
        usage: ::std::os::raw::c_uint,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Set or change configuration"]
    #[doc = ""]
    #[doc = " Reconfigures an encoder instance according to the given configuration."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context"]
    #[doc = " \\param[in]    cfg     Configuration buffer to use"]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The configuration was populated."]
    #[doc = " \\retval #AOM_CODEC_INCAPABLE"]
    #[doc = "     Interface is not an encoder interface."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     A parameter was NULL, or the usage value was not recognized."]
    pub fn aom_codec_enc_config_set(
        ctx: *mut aom_codec_ctx_t,
        cfg: *const aom_codec_enc_cfg_t,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Get global stream headers"]
    #[doc = ""]
    #[doc = " Retrieves a stream level global header packet, if supported by the codec."]
    #[doc = " Calls to this function should be deferred until all configuration information"]
    #[doc = " has been passed to libaom. Otherwise the global header data may be"]
    #[doc = " invalidated by additional configuration changes."]
    #[doc = ""]
    #[doc = " The AV1 implementation of this function returns an OBU. The OBU returned is"]
    #[doc = " in Low Overhead Bitstream Format. Specifically, the obu_has_size_field bit is"]
    #[doc = " set, and the buffer contains the obu_size field for the returned OBU."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context"]
    #[doc = ""]
    #[doc = " \\retval NULL"]
    #[doc = "     Encoder does not support global header, or an error occurred while"]
    #[doc = "     generating the global header."]
    #[doc = ""]
    #[doc = " \\retval Non-NULL"]
    #[doc = "     Pointer to buffer containing global header packet. The caller owns the"]
    #[doc = "     memory associated with this buffer, and must free the 'buf' member of the"]
    #[doc = "     aom_fixed_buf_t as well as the aom_fixed_buf_t pointer. Memory returned"]
    #[doc = "     must be freed via call to free()."]
    pub fn aom_codec_get_global_headers(ctx: *mut aom_codec_ctx_t) -> *mut aom_fixed_buf_t;
}
extern "C" {
    #[doc = "Encode a frame"]
    #[doc = ""]
    #[doc = " Encodes a video frame at the given \"presentation time.\" The presentation"]
    #[doc = " time stamp (PTS) \\ref MUST be strictly increasing."]
    #[doc = ""]
    #[doc = " When the last frame has been passed to the encoder, this function should"]
    #[doc = " continue to be called in a loop, with the img parameter set to NULL. This"]
    #[doc = " will signal the end-of-stream condition to the encoder and allow it to"]
    #[doc = " encode any held buffers. Encoding is complete when aom_codec_encode() is"]
    #[doc = " called with img set to NULL and aom_codec_get_cx_data() returns no data."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx       Pointer to this instance's context"]
    #[doc = " \\param[in]    img       Image data to encode, NULL to flush."]
    #[doc = " \\param[in]    pts       Presentation time stamp, in timebase units. If img"]
    #[doc = "                         is NULL, pts is ignored."]
    #[doc = " \\param[in]    duration  Duration to show frame, in timebase units. If img"]
    #[doc = "                         is not NULL, duration must be nonzero. If img is"]
    #[doc = "                         NULL, duration is ignored."]
    #[doc = " \\param[in]    flags     Flags to use for encoding this frame."]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The configuration was populated."]
    #[doc = " \\retval #AOM_CODEC_INCAPABLE"]
    #[doc = "     Interface is not an encoder interface."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     A parameter was NULL, the image format is unsupported, etc."]
    pub fn aom_codec_encode(
        ctx: *mut aom_codec_ctx_t,
        img: *const aom_image_t,
        pts: aom_codec_pts_t,
        duration: ::std::os::raw::c_ulong,
        flags: aom_enc_frame_flags_t,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Set compressed data output buffer"]
    #[doc = ""]
    #[doc = " Sets the buffer that the codec should output the compressed data"]
    #[doc = " into. This call effectively sets the buffer pointer returned in the"]
    #[doc = " next AOM_CODEC_CX_FRAME_PKT packet. Subsequent packets will be"]
    #[doc = " appended into this buffer. The buffer is preserved across frames,"]
    #[doc = " so applications must periodically call this function after flushing"]
    #[doc = " the accumulated compressed data to disk or to the network to reset"]
    #[doc = " the pointer to the buffer's head."]
    #[doc = ""]
    #[doc = " `pad_before` bytes will be skipped before writing the compressed"]
    #[doc = " data, and `pad_after` bytes will be appended to the packet. The size"]
    #[doc = " of the packet will be the sum of the size of the actual compressed"]
    #[doc = " data, pad_before, and pad_after. The padding bytes will be preserved"]
    #[doc = " (not overwritten)."]
    #[doc = ""]
    #[doc = " Note that calling this function does not guarantee that the returned"]
    #[doc = " compressed data will be placed into the specified buffer. In the"]
    #[doc = " event that the encoded data will not fit into the buffer provided,"]
    #[doc = " the returned packet \\ref MAY point to an internal buffer, as it would"]
    #[doc = " if this call were never used. In this event, the output packet will"]
    #[doc = " NOT have any padding, and the application must free space and copy it"]
    #[doc = " to the proper place. This is of particular note in configurations"]
    #[doc = " that may output multiple packets for a single encoded frame (e.g., lagged"]
    #[doc = " encoding) or if the application does not reset the buffer periodically."]
    #[doc = ""]
    #[doc = " Applications may restore the default behavior of the codec providing"]
    #[doc = " the compressed data buffer by calling this function with a NULL"]
    #[doc = " buffer."]
    #[doc = ""]
    #[doc = " Applications \\ref MUSTNOT call this function during iteration of"]
    #[doc = " aom_codec_get_cx_data()."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx         Pointer to this instance's context"]
    #[doc = " \\param[in]    buf         Buffer to store compressed data into"]
    #[doc = " \\param[in]    pad_before  Bytes to skip before writing compressed data"]
    #[doc = " \\param[in]    pad_after   Bytes to skip after writing compressed data"]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The buffer was set successfully."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     A parameter was NULL, the image format is unsupported, etc."]
    pub fn aom_codec_set_cx_data_buf(
        ctx: *mut aom_codec_ctx_t,
        buf: *const aom_fixed_buf_t,
        pad_before: ::std::os::raw::c_uint,
        pad_after: ::std::os::raw::c_uint,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Encoded data iterator"]
    #[doc = ""]
    #[doc = " Iterates over a list of data packets to be passed from the encoder to the"]
    #[doc = " application. The different kinds of packets available are enumerated in"]
    #[doc = " #aom_codec_cx_pkt_kind."]
    #[doc = ""]
    #[doc = " #AOM_CODEC_CX_FRAME_PKT packets should be passed to the application's"]
    #[doc = " muxer. Multiple compressed frames may be in the list."]
    #[doc = " #AOM_CODEC_STATS_PKT packets should be appended to a global buffer."]
    #[doc = ""]
    #[doc = " The application \\ref MUST silently ignore any packet kinds that it does"]
    #[doc = " not recognize or support."]
    #[doc = ""]
    #[doc = " The data buffers returned from this function are only guaranteed to be"]
    #[doc = " valid until the application makes another call to any aom_codec_* function."]
    #[doc = ""]
    #[doc = " \\param[in]     ctx      Pointer to this instance's context"]
    #[doc = " \\param[in,out] iter     Iterator storage, initialized to NULL"]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to an output data packet (compressed frame data,"]
    #[doc = "         two-pass statistics, etc.) or NULL to signal end-of-list."]
    #[doc = ""]
    pub fn aom_codec_get_cx_data(
        ctx: *mut aom_codec_ctx_t,
        iter: *mut aom_codec_iter_t,
    ) -> *const aom_codec_cx_pkt_t;
}
extern "C" {
    #[doc = "Get Preview Frame"]
    #[doc = ""]
    #[doc = " Returns an image that can be used as a preview. Shows the image as it would"]
    #[doc = " exist at the decompressor. The application \\ref MUST NOT write into this"]
    #[doc = " image buffer."]
    #[doc = ""]
    #[doc = " \\param[in]     ctx      Pointer to this instance's context"]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to a preview image, or NULL if no image is"]
    #[doc = "         available."]
    #[doc = ""]
    pub fn aom_codec_get_preview_frame(ctx: *mut aom_codec_ctx_t) -> *const aom_image_t;
}
#[doc = "External frame buffer"]
#[doc = ""]
#[doc = " This structure holds allocated frame buffers used by the decoder."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_frame_buffer {
    #[doc = "Pointer to the data buffer"]
    pub data: *mut u8,
    #[doc = "Size of data in bytes"]
    pub size: usize,
    #[doc = "Frame's private data"]
    pub priv_: *mut ::std::os::raw::c_void,
}
#[doc = "External frame buffer"]
#[doc = ""]
#[doc = " This structure holds allocated frame buffers used by the decoder."]
pub type aom_codec_frame_buffer_t = aom_codec_frame_buffer;
#[doc = "get frame buffer callback prototype"]
#[doc = ""]
#[doc = " This callback is invoked by the decoder to retrieve data for the frame"]
#[doc = " buffer in order for the decode call to complete. The callback must"]
#[doc = " allocate at least min_size in bytes and assign it to fb->data. The callback"]
#[doc = " must zero out all the data allocated. Then the callback must set fb->size"]
#[doc = " to the allocated size. The application does not need to align the allocated"]
#[doc = " data. The callback is triggered when the decoder needs a frame buffer to"]
#[doc = " decode a compressed image into. This function may be called more than once"]
#[doc = " for every call to aom_codec_decode. The application may set fb->priv to"]
#[doc = " some data which will be passed back in the aom_image_t and the release"]
#[doc = " function call. |fb| is guaranteed to not be NULL. On success the callback"]
#[doc = " must return 0. Any failure the callback must return a value less than 0."]
#[doc = ""]
#[doc = " \\param[in] priv         Callback's private data"]
#[doc = " \\param[in] new_size     Size in bytes needed by the buffer"]
#[doc = " \\param[in,out] fb       Pointer to aom_codec_frame_buffer_t"]
pub type aom_get_frame_buffer_cb_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        priv_: *mut ::std::os::raw::c_void,
        min_size: usize,
        fb: *mut aom_codec_frame_buffer_t,
    ) -> ::std::os::raw::c_int,
>;
#[doc = "release frame buffer callback prototype"]
#[doc = ""]
#[doc = " This callback is invoked by the decoder when the frame buffer is not"]
#[doc = " referenced by any other buffers. |fb| is guaranteed to not be NULL. On"]
#[doc = " success the callback must return 0. Any failure the callback must return"]
#[doc = " a value less than 0."]
#[doc = ""]
#[doc = " \\param[in] priv         Callback's private data"]
#[doc = " \\param[in] fb           Pointer to aom_codec_frame_buffer_t"]
pub type aom_release_frame_buffer_cb_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        priv_: *mut ::std::os::raw::c_void,
        fb: *mut aom_codec_frame_buffer_t,
    ) -> ::std::os::raw::c_int,
>;
#[doc = "Stream properties"]
#[doc = ""]
#[doc = " This structure is used to query or set properties of the decoded"]
#[doc = " stream."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_stream_info {
    #[doc = "Width (or 0 for unknown/default)"]
    pub w: ::std::os::raw::c_uint,
    #[doc = "Height (or 0 for unknown/default)"]
    pub h: ::std::os::raw::c_uint,
    #[doc = "Current frame is a keyframe"]
    pub is_kf: ::std::os::raw::c_uint,
    #[doc = "Number of spatial layers"]
    pub number_spatial_layers: ::std::os::raw::c_uint,
    #[doc = "Number of temporal layers"]
    pub number_temporal_layers: ::std::os::raw::c_uint,
    #[doc = "Is Bitstream in Annex-B format"]
    pub is_annexb: ::std::os::raw::c_uint,
}
#[doc = "Stream properties"]
#[doc = ""]
#[doc = " This structure is used to query or set properties of the decoded"]
#[doc = " stream."]
pub type aom_codec_stream_info_t = aom_codec_stream_info;
#[doc = "Initialization Configurations"]
#[doc = ""]
#[doc = " This structure is used to pass init time configuration options to the"]
#[doc = " decoder."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_codec_dec_cfg {
    #[doc = "Maximum number of threads to use, default 1"]
    pub threads: ::std::os::raw::c_uint,
    #[doc = "Width"]
    pub w: ::std::os::raw::c_uint,
    #[doc = "Height"]
    pub h: ::std::os::raw::c_uint,
    #[doc = "Allow use of low-bitdepth coding path"]
    pub allow_lowbitdepth: ::std::os::raw::c_uint,
}
#[doc = "Initialization Configurations"]
#[doc = ""]
#[doc = " This structure is used to pass init time configuration options to the"]
#[doc = " decoder."]
pub type aom_codec_dec_cfg_t = aom_codec_dec_cfg;
extern "C" {
    #[doc = "Initialize a decoder instance"]
    #[doc = ""]
    #[doc = " Initializes a decoder context using the given interface. Applications"]
    #[doc = " should call the aom_codec_dec_init convenience macro instead of this"]
    #[doc = " function directly, to ensure that the ABI version number parameter"]
    #[doc = " is properly initialized."]
    #[doc = ""]
    #[doc = " If the library was configured with cmake -DCONFIG_MULTITHREAD=0, this"]
    #[doc = " call is not thread safe and should be guarded with a lock if being used"]
    #[doc = " in a multithreaded context."]
    #[doc = ""]
    #[doc = " \\param[in]    ctx     Pointer to this instance's context."]
    #[doc = " \\param[in]    iface   Pointer to the algorithm interface to use."]
    #[doc = " \\param[in]    cfg     Configuration to use, if known. May be NULL."]
    #[doc = " \\param[in]    flags   Bitfield of AOM_CODEC_USE_* flags"]
    #[doc = " \\param[in]    ver     ABI version number. Must be set to"]
    #[doc = "                       AOM_DECODER_ABI_VERSION"]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     The decoder algorithm initialized."]
    #[doc = " \\retval #AOM_CODEC_MEM_ERROR"]
    #[doc = "     Memory allocation failed."]
    pub fn aom_codec_dec_init_ver(
        ctx: *mut aom_codec_ctx_t,
        iface: *mut aom_codec_iface_t,
        cfg: *const aom_codec_dec_cfg_t,
        flags: aom_codec_flags_t,
        ver: ::std::os::raw::c_int,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Parse stream info from a buffer"]
    #[doc = ""]
    #[doc = " Performs high level parsing of the bitstream. Construction of a decoder"]
    #[doc = " context is not necessary. Can be used to determine if the bitstream is"]
    #[doc = " of the proper format, and to extract information from the stream."]
    #[doc = ""]
    #[doc = " \\param[in]      iface   Pointer to the algorithm interface"]
    #[doc = " \\param[in]      data    Pointer to a block of data to parse"]
    #[doc = " \\param[in]      data_sz Size of the data buffer"]
    #[doc = " \\param[in,out]  si      Pointer to stream info to update. The is_annexb"]
    #[doc = "                         member \\ref MUST be properly initialized. This"]
    #[doc = "                         function sets the rest of the members."]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     Bitstream is parsable and stream information updated."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     One of the arguments is invalid, for example a NULL pointer."]
    #[doc = " \\retval #AOM_CODEC_UNSUP_BITSTREAM"]
    #[doc = "     The decoder didn't recognize the coded data, or the"]
    #[doc = "     buffer was too short."]
    pub fn aom_codec_peek_stream_info(
        iface: *mut aom_codec_iface_t,
        data: *const u8,
        data_sz: usize,
        si: *mut aom_codec_stream_info_t,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Return information about the current stream."]
    #[doc = ""]
    #[doc = " Returns information about the stream that has been parsed during decoding."]
    #[doc = ""]
    #[doc = " \\param[in]      ctx     Pointer to this instance's context"]
    #[doc = " \\param[in,out]  si      Pointer to stream info to update."]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     Bitstream is parsable and stream information updated."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     One of the arguments is invalid, for example a NULL pointer."]
    #[doc = " \\retval #AOM_CODEC_UNSUP_BITSTREAM"]
    #[doc = "     The decoder couldn't parse the submitted data."]
    pub fn aom_codec_get_stream_info(
        ctx: *mut aom_codec_ctx_t,
        si: *mut aom_codec_stream_info_t,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Decode data"]
    #[doc = ""]
    #[doc = " Processes a buffer of coded data. Encoded data \\ref MUST be passed in DTS"]
    #[doc = " (decode time stamp) order. Frames produced will always be in PTS"]
    #[doc = " (presentation time stamp) order."]
    #[doc = ""]
    #[doc = " \\param[in] ctx          Pointer to this instance's context"]
    #[doc = " \\param[in] data         Pointer to this block of new coded data."]
    #[doc = " \\param[in] data_sz      Size of the coded data, in bytes."]
    #[doc = " \\param[in] user_priv    Application specific data to associate with"]
    #[doc = "                         this frame."]
    #[doc = ""]
    #[doc = " \\return Returns #AOM_CODEC_OK if the coded data was processed completely"]
    #[doc = "         and future pictures can be decoded without error. Otherwise,"]
    #[doc = "         see the descriptions of the other error codes in ::aom_codec_err_t"]
    #[doc = "         for recoverability capabilities."]
    pub fn aom_codec_decode(
        ctx: *mut aom_codec_ctx_t,
        data: *const u8,
        data_sz: usize,
        user_priv: *mut ::std::os::raw::c_void,
    ) -> aom_codec_err_t;
}
extern "C" {
    #[doc = "Decoded frames iterator"]
    #[doc = ""]
    #[doc = " Iterates over a list of the frames available for display. The iterator"]
    #[doc = " storage should be initialized to NULL to start the iteration. Iteration is"]
    #[doc = " complete when this function returns NULL."]
    #[doc = ""]
    #[doc = " The list of available frames becomes valid upon completion of the"]
    #[doc = " aom_codec_decode call, and remains valid until the next call to"]
    #[doc = " aom_codec_decode."]
    #[doc = ""]
    #[doc = " \\param[in]     ctx      Pointer to this instance's context"]
    #[doc = " \\param[in,out] iter     Iterator storage, initialized to NULL"]
    #[doc = ""]
    #[doc = " \\return Returns a pointer to an image, if one is ready for display. Frames"]
    #[doc = "         produced will always be in PTS (presentation time stamp) order."]
    pub fn aom_codec_get_frame(
        ctx: *mut aom_codec_ctx_t,
        iter: *mut aom_codec_iter_t,
    ) -> *mut aom_image_t;
}
extern "C" {
    #[doc = "Pass in external frame buffers for the decoder to use."]
    #[doc = ""]
    #[doc = " Registers functions to be called when libaom needs a frame buffer"]
    #[doc = " to decode the current frame and a function to be called when libaom does"]
    #[doc = " not internally reference the frame buffer. This set function must"]
    #[doc = " be called before the first call to decode or libaom will assume the"]
    #[doc = " default behavior of allocating frame buffers internally."]
    #[doc = ""]
    #[doc = " \\param[in] ctx          Pointer to this instance's context"]
    #[doc = " \\param[in] cb_get       Pointer to the get callback function"]
    #[doc = " \\param[in] cb_release   Pointer to the release callback function"]
    #[doc = " \\param[in] cb_priv      Callback's private data"]
    #[doc = ""]
    #[doc = " \\retval #AOM_CODEC_OK"]
    #[doc = "     External frame buffers will be used by libaom."]
    #[doc = " \\retval #AOM_CODEC_INVALID_PARAM"]
    #[doc = "     One or more of the callbacks were NULL."]
    #[doc = " \\retval #AOM_CODEC_ERROR"]
    #[doc = "     Decoder context not initialized."]
    #[doc = " \\retval #AOM_CODEC_INCAPABLE"]
    #[doc = "     Algorithm not capable of using external frame buffers."]
    #[doc = ""]
    #[doc = " \\note"]
    #[doc = " When decoding AV1, the application may be required to pass in at least"]
    #[doc = " #AOM_MAXIMUM_WORK_BUFFERS external frame buffers."]
    pub fn aom_codec_set_frame_buffer_functions(
        ctx: *mut aom_codec_ctx_t,
        cb_get: aom_get_frame_buffer_cb_fn_t,
        cb_release: aom_release_frame_buffer_cb_fn_t,
        cb_priv: *mut ::std::os::raw::c_void,
    ) -> aom_codec_err_t;
}
extern "C" {
    pub static mut aom_codec_av1_cx_algo: aom_codec_iface_t;
}
extern "C" {
    #[doc = "The interface to the AV1 encoder."]
    pub fn aom_codec_av1_cx() -> *mut aom_codec_iface_t;
}
#[doc = "Codec control function to set which reference frame encoder can use,"]
#[doc = " int parameter."]
pub const AOME_USE_REFERENCE: aome_enc_control_id = 7;
#[doc = "Codec control function to pass an ROI map to encoder, aom_roi_map_t*"]
#[doc = " parameter."]
pub const AOME_SET_ROI_MAP: aome_enc_control_id = 8;
#[doc = "Codec control function to pass an Active map to encoder,"]
#[doc = " aom_active_map_t* parameter."]
pub const AOME_SET_ACTIVEMAP: aome_enc_control_id = 9;
#[doc = "Codec control function to set encoder scaling mode,"]
#[doc = " aom_scaling_mode_t* parameter."]
pub const AOME_SET_SCALEMODE: aome_enc_control_id = 11;
#[doc = "Codec control function to set encoder spatial layer id, unsigned int"]
#[doc = " parameter."]
pub const AOME_SET_SPATIAL_LAYER_ID: aome_enc_control_id = 12;
#[doc = "Codec control function to set encoder internal speed settings,"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " Changes in this value influences the complexity of algorithms used in"]
#[doc = " encoding process, values greater than 0 will increase encoder speed at"]
#[doc = " the expense of quality."]
#[doc = ""]
#[doc = " Valid range: 0..8. 0 runs the slowest, and 8 runs the fastest;"]
#[doc = " quality improves as speed decreases (since more compression"]
#[doc = " possibilities are explored)."]
pub const AOME_SET_CPUUSED: aome_enc_control_id = 13;
#[doc = "Codec control function to enable automatic set and use alf frames,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AOME_SET_ENABLEAUTOALTREF: aome_enc_control_id = 14;
#[doc = "Codec control function to set sharpness, unsigned int parameter."]
pub const AOME_SET_SHARPNESS: aome_enc_control_id = 16;
#[doc = "Codec control function to set the threshold for MBs treated static,"]
#[doc = " unsigned int parameter"]
pub const AOME_SET_STATIC_THRESHOLD: aome_enc_control_id = 17;
#[doc = "Codec control function to get last quantizer chosen by the encoder,"]
#[doc = " int* parameter"]
#[doc = ""]
#[doc = " Return value uses internal quantizer scale defined by the codec."]
pub const AOME_GET_LAST_QUANTIZER: aome_enc_control_id = 19;
#[doc = "Codec control function to get last quantizer chosen by the encoder,"]
#[doc = " int* parameter"]
#[doc = ""]
#[doc = " Return value uses the 0..63 scale as used by the rc_*_quantizer config"]
#[doc = " parameters."]
pub const AOME_GET_LAST_QUANTIZER_64: aome_enc_control_id = 20;
#[doc = "Codec control function to set the max no of frames to create arf,"]
#[doc = " unsigned int parameter"]
pub const AOME_SET_ARNR_MAXFRAMES: aome_enc_control_id = 21;
#[doc = "Codec control function to set the filter strength for the arf,"]
#[doc = " unsigned int parameter"]
pub const AOME_SET_ARNR_STRENGTH: aome_enc_control_id = 22;
#[doc = "Codec control function to set visual tuning, aom_tune_metric (int)"]
#[doc = " parameter"]
pub const AOME_SET_TUNING: aome_enc_control_id = 24;
#[doc = "Codec control function to set constrained / constant quality level,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " Valid range: 0..63"]
#[doc = ""]
#[doc = " \\attention For this value to be used aom_codec_enc_cfg_t::rc_end_usage"]
#[doc = "            must be set to #AOM_CQ or #AOM_Q."]
pub const AOME_SET_CQ_LEVEL: aome_enc_control_id = 25;
#[doc = "Codec control function to set max data rate for intra frames,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " This value controls additional clamping on the maximum size of a"]
#[doc = " keyframe. It is expressed as a percentage of the average"]
#[doc = " per-frame bitrate, with the special (and default) value 0 meaning"]
#[doc = " unlimited, or no additional clamping beyond the codec's built-in"]
#[doc = " algorithm."]
#[doc = ""]
#[doc = " For example, to allocate no more than 4.5 frames worth of bitrate"]
#[doc = " to a keyframe, set this to 450."]
pub const AOME_SET_MAX_INTRA_BITRATE_PCT: aome_enc_control_id = 26;
#[doc = "Codec control function to set number of spatial layers, int"]
#[doc = " parameter"]
pub const AOME_SET_NUMBER_SPATIAL_LAYERS: aome_enc_control_id = 27;
#[doc = "Codec control function to set max data rate for inter frames,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " This value controls additional clamping on the maximum size of an"]
#[doc = " inter frame. It is expressed as a percentage of the average"]
#[doc = " per-frame bitrate, with the special (and default) value 0 meaning"]
#[doc = " unlimited, or no additional clamping beyond the codec's built-in"]
#[doc = " algorithm."]
#[doc = ""]
#[doc = " For example, to allow no more than 4.5 frames worth of bitrate"]
#[doc = " to an inter frame, set this to 450."]
pub const AV1E_SET_MAX_INTER_BITRATE_PCT: aome_enc_control_id = 28;
#[doc = "Boost percentage for Golden Frame in CBR mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " This value controls the amount of boost given to Golden Frame in"]
#[doc = " CBR mode. It is expressed as a percentage of the average"]
#[doc = " per-frame bitrate, with the special (and default) value 0 meaning"]
#[doc = " the feature is off, i.e., no golden frame boost in CBR mode and"]
#[doc = " average bitrate target is used."]
#[doc = ""]
#[doc = " For example, to allow 100% more bits, i.e, 2X, in a golden frame"]
#[doc = " than average frame, set this to 100."]
pub const AV1E_SET_GF_CBR_BOOST_PCT: aome_enc_control_id = 29;
#[doc = "Codec control function to set lossless encoding mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " AV1 can operate in lossless encoding mode, in which the bitstream"]
#[doc = " produced will be able to decode and reconstruct a perfect copy of"]
#[doc = " input source."]
#[doc = ""]
#[doc = " - 0 = normal coding mode, may be lossy (default)"]
#[doc = " - 1 = lossless coding mode"]
pub const AV1E_SET_LOSSLESS: aome_enc_control_id = 31;
#[doc = "Codec control function to enable the row based multi-threading"]
#[doc = " of the encoder, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ROW_MT: aome_enc_control_id = 32;
#[doc = "Codec control function to set number of tile columns. unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " In encoding and decoding, AV1 allows an input image frame be partitioned"]
#[doc = " into separate vertical tile columns, which can be encoded or decoded"]
#[doc = " independently. This enables easy implementation of parallel encoding and"]
#[doc = " decoding. The parameter for this control describes the number of tile"]
#[doc = " columns (in log2 units), which has a valid range of [0, 6]:"]
#[doc = " \\verbatim"]
#[doc = "0 = 1 tile column"]
#[doc = "1 = 2 tile columns"]
#[doc = "2 = 4 tile columns"]
#[doc = "....."]
#[doc = "n = 2**n tile columns"]
#[doc = "\\endverbatim"]
#[doc = " By default, the value is 0, i.e. one single column tile for entire image."]
pub const AV1E_SET_TILE_COLUMNS: aome_enc_control_id = 33;
#[doc = "Codec control function to set number of tile rows, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " In encoding and decoding, AV1 allows an input image frame be partitioned"]
#[doc = " into separate horizontal tile rows, which can be encoded or decoded"]
#[doc = " independently. The parameter for this control describes the number of tile"]
#[doc = " rows (in log2 units), which has a valid range of [0, 6]:"]
#[doc = " \\verbatim"]
#[doc = "0 = 1 tile row"]
#[doc = "1 = 2 tile rows"]
#[doc = "2 = 4 tile rows"]
#[doc = "....."]
#[doc = "n = 2**n tile rows"]
#[doc = "\\endverbatim"]
#[doc = " By default, the value is 0, i.e. one single row tile for entire image."]
pub const AV1E_SET_TILE_ROWS: aome_enc_control_id = 34;
#[doc = "Codec control function to enable RDO modulated by frame temporal"]
#[doc = " dependency, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_TPL_MODEL: aome_enc_control_id = 35;
#[doc = "Codec control function to enable temporal filtering on key frame,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_KEYFRAME_FILTERING: aome_enc_control_id = 36;
#[doc = "Codec control function to enable frame parallel decoding feature,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AV1 has a bitstream feature to reduce decoding dependency between frames"]
#[doc = " by turning off backward update of probability context used in encoding"]
#[doc = " and decoding. This allows staged parallel processing of more than one"]
#[doc = " video frames in the decoder. This control function provides a mean to"]
#[doc = " turn this feature on or off for bitstreams produced by encoder."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_FRAME_PARALLEL_DECODING: aome_enc_control_id = 37;
#[doc = "Codec control function to enable error_resilient_mode, int parameter"]
#[doc = ""]
#[doc = " AV1 has a bitstream feature to guarantee parseability of a frame"]
#[doc = " by turning on the error_resilient_decoding mode, even though the"]
#[doc = " reference buffers are unreliable or not received."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_ERROR_RESILIENT_MODE: aome_enc_control_id = 38;
#[doc = "Codec control function to enable s_frame_mode, int parameter"]
#[doc = ""]
#[doc = " AV1 has a bitstream feature to designate certain frames as S-frames,"]
#[doc = " from where we can switch to a different stream,"]
#[doc = " even though the reference buffers may not be exactly identical."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_S_FRAME_MODE: aome_enc_control_id = 39;
#[doc = "Codec control function to set adaptive quantization mode, unsigned"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " AV1 has a segment based feature that allows encoder to adaptively change"]
#[doc = " quantization parameter for each segment within a frame to improve the"]
#[doc = " subjective quality. This control makes encoder operate in one of the"]
#[doc = " several AQ_modes supported."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_AQ_MODE: aome_enc_control_id = 40;
#[doc = "Codec control function to enable/disable periodic Q boost, unsigned"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " One AV1 encoder speed feature is to enable quality boost by lowering"]
#[doc = " frame level Q periodically. This control function provides a mean to"]
#[doc = " turn on/off this feature."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_FRAME_PERIODIC_BOOST: aome_enc_control_id = 41;
#[doc = "Codec control function to set noise sensitivity, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable (Y only)"]
pub const AV1E_SET_NOISE_SENSITIVITY: aome_enc_control_id = 42;
#[doc = "Codec control function to set content type, aom_tune_content"]
#[doc = " parameter"]
#[doc = ""]
#[doc = "  - AOM_CONTENT_DEFAULT = Regular video content (default)"]
#[doc = "  - AOM_CONTENT_SCREEN  = Screen capture content"]
pub const AV1E_SET_TUNE_CONTENT: aome_enc_control_id = 43;
#[doc = "Codec control function to set CDF update mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = "  - 0: no update"]
#[doc = "  - 1: update on every frame (default)"]
#[doc = "  - 2: selectively update"]
pub const AV1E_SET_CDF_UPDATE_MODE: aome_enc_control_id = 44;
#[doc = "Codec control function to set color space info, int parameter"]
#[doc = ""]
#[doc = "  - 0 = For future use"]
#[doc = "  - 1 = BT.709"]
#[doc = "  - 2 = Unspecified (default)"]
#[doc = "  - 3 = For future use"]
#[doc = "  - 4 = BT.470 System M (historical)"]
#[doc = "  - 5 = BT.470 System B, G (historical)"]
#[doc = "  - 6 = BT.601"]
#[doc = "  - 7 = SMPTE 240"]
#[doc = "  - 8 = Generic film (color filters using illuminant C)"]
#[doc = "  - 9 = BT.2020, BT.2100"]
#[doc = "  - 10 = SMPTE 428 (CIE 1921 XYZ)"]
#[doc = "  - 11 = SMPTE RP 431-2"]
#[doc = "  - 12 = SMPTE EG 432-1"]
#[doc = "  - 13..21 = For future use"]
#[doc = "  - 22 = EBU Tech. 3213-E"]
#[doc = "  - 23 = For future use"]
pub const AV1E_SET_COLOR_PRIMARIES: aome_enc_control_id = 45;
#[doc = "Codec control function to set transfer function info, int parameter"]
#[doc = ""]
#[doc = " - 0 = For future use"]
#[doc = " - 1 = BT.709"]
#[doc = " - 2 = Unspecified (default)"]
#[doc = " - 3 = For future use"]
#[doc = " - 4 = BT.470 System M (historical)"]
#[doc = " - 5 = BT.470 System B, G (historical)"]
#[doc = " - 6 = BT.601"]
#[doc = " - 7 = SMPTE 240 M"]
#[doc = " - 8 = Linear"]
#[doc = " - 9 = Logarithmic (100 : 1 range)"]
#[doc = " - 10 = Logarithmic (100 * Sqrt(10) : 1 range)"]
#[doc = " - 11 = IEC 61966-2-4"]
#[doc = " - 12 = BT.1361"]
#[doc = " - 13 = sRGB or sYCC"]
#[doc = " - 14 = BT.2020 10-bit systems"]
#[doc = " - 15 = BT.2020 12-bit systems"]
#[doc = " - 16 = SMPTE ST 2084, ITU BT.2100 PQ"]
#[doc = " - 17 = SMPTE ST 428"]
#[doc = " - 18 = BT.2100 HLG, ARIB STD-B67"]
#[doc = " - 19 = For future use"]
pub const AV1E_SET_TRANSFER_CHARACTERISTICS: aome_enc_control_id = 46;
#[doc = "Codec control function to set transfer function info, int parameter"]
#[doc = ""]
#[doc = " - 0 = Identity matrix"]
#[doc = " - 1 = BT.709"]
#[doc = " - 2 = Unspecified (default)"]
#[doc = " - 3 = For future use"]
#[doc = " - 4 = US FCC 73.628"]
#[doc = " - 5 = BT.470 System B, G (historical)"]
#[doc = " - 6 = BT.601"]
#[doc = " - 7 = SMPTE 240 M"]
#[doc = " - 8 = YCgCo"]
#[doc = " - 9 = BT.2020 non-constant luminance, BT.2100 YCbCr"]
#[doc = " - 10 = BT.2020 constant luminance"]
#[doc = " - 11 = SMPTE ST 2085 YDzDx"]
#[doc = " - 12 = Chromaticity-derived non-constant luminance"]
#[doc = " - 13 = Chromaticity-derived constant luminance"]
#[doc = " - 14 = BT.2100 ICtCp"]
#[doc = " - 15 = For future use"]
pub const AV1E_SET_MATRIX_COEFFICIENTS: aome_enc_control_id = 47;
#[doc = "Codec control function to set chroma 4:2:0 sample position info,"]
#[doc = " aom_chroma_sample_position_t parameter"]
#[doc = ""]
#[doc = " AOM_CSP_UNKNOWN is default"]
pub const AV1E_SET_CHROMA_SAMPLE_POSITION: aome_enc_control_id = 48;
#[doc = "Codec control function to set minimum interval between GF/ARF"]
#[doc = " frames, unsigned int parameter"]
#[doc = ""]
#[doc = " By default the value is set as 4."]
pub const AV1E_SET_MIN_GF_INTERVAL: aome_enc_control_id = 49;
#[doc = "Codec control function to set minimum interval between GF/ARF"]
#[doc = " frames, unsigned int parameter"]
#[doc = ""]
#[doc = " By default the value is set as 16."]
pub const AV1E_SET_MAX_GF_INTERVAL: aome_enc_control_id = 50;
#[doc = "Codec control function to get an active map back from the encoder,"]
#[doc = "aom_active_map_t* parameter"]
pub const AV1E_GET_ACTIVEMAP: aome_enc_control_id = 51;
#[doc = "Codec control function to set color range bit, int parameter"]
#[doc = ""]
#[doc = " - 0 = Limited range, 16..235 or HBD equivalent (default)"]
#[doc = " - 1 = Full range, 0..255 or HBD equivalent"]
pub const AV1E_SET_COLOR_RANGE: aome_enc_control_id = 52;
#[doc = "Codec control function to set intended rendering image size,"]
#[doc = " int32_t[2] parameter"]
#[doc = ""]
#[doc = " By default, this is identical to the image size in pixels."]
pub const AV1E_SET_RENDER_SIZE: aome_enc_control_id = 53;
#[doc = "Control to set target sequence level index for a certain operating"]
#[doc = " point(OP), int parameter"]
#[doc = " Possible values are in the form of \"ABxy\"(pad leading zeros if less than"]
#[doc = " 4 digits)."]
#[doc = "  - AB: OP index."]
#[doc = "  - xy: Target level index for the OP. Can be values 0~23(corresponding to"]
#[doc = "    level 2.0 ~ 7.3) or 24(keep level stats only for level monitoring) or"]
#[doc = "    31(maximum level parameter, no level-based constraints)."]
#[doc = ""]
#[doc = " E.g.:"]
#[doc = " - \"0\" means target level index 0 for the 0th OP;"]
#[doc = " - \"111\" means target level index 11 for the 1st OP;"]
#[doc = " - \"1021\" means target level index 21 for the 10th OP."]
#[doc = ""]
#[doc = " If the target level is not specified for an OP, the maximum level parameter"]
#[doc = " of 31 is used as default."]
pub const AV1E_SET_TARGET_SEQ_LEVEL_IDX: aome_enc_control_id = 54;
#[doc = "Codec control function to get sequence level index for each"]
#[doc = " operating point. int* parameter. There can be at most 32 operating points."]
#[doc = " The results will be written into a provided integer array of sufficient"]
#[doc = " size."]
pub const AV1E_GET_SEQ_LEVEL_IDX: aome_enc_control_id = 55;
#[doc = "Codec control function to set intended superblock size, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " By default, the superblock size is determined separately for each"]
#[doc = " frame by the encoder."]
pub const AV1E_SET_SUPERBLOCK_SIZE: aome_enc_control_id = 56;
#[doc = "Codec control function to enable automatic set and use of"]
#[doc = " bwd-pred frames, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AOME_SET_ENABLEAUTOBWDREF: aome_enc_control_id = 57;
#[doc = "Codec control function to encode with CDEF, unsigned int parameter"]
#[doc = ""]
#[doc = " CDEF is the constrained directional enhancement filter which is an"]
#[doc = " in-loop filter aiming to remove coding artifacts"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_CDEF: aome_enc_control_id = 58;
#[doc = "Codec control function to encode with Loop Restoration Filter,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_RESTORATION: aome_enc_control_id = 59;
#[doc = "Codec control function to force video mode, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = do not force video mode (default)"]
#[doc = " - 1 = force video mode even for a single frame"]
pub const AV1E_SET_FORCE_VIDEO_MODE: aome_enc_control_id = 60;
#[doc = "Codec control function to predict with OBMC mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_OBMC: aome_enc_control_id = 61;
#[doc = "Codec control function to encode without trellis quantization,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = apply trellis quantization (default)"]
#[doc = " - 1 = do not apply trellis quantization"]
#[doc = " - 2 = disable trellis quantization in rd search"]
#[doc = " - 3 = disable trellis quantization in estimate yrd"]
pub const AV1E_SET_DISABLE_TRELLIS_QUANT: aome_enc_control_id = 62;
#[doc = "Codec control function to encode with quantisation matrices,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with default quantisation matrices dependent on"]
#[doc = " quantisation level and block type."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_ENABLE_QM: aome_enc_control_id = 63;
#[doc = "Codec control function to set the min quant matrix flatness,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with different ranges of quantisation matrices."]
#[doc = " As quantisation levels increase, the matrices get flatter. This"]
#[doc = " control sets the minimum level of flatness from which the matrices"]
#[doc = " are determined."]
#[doc = ""]
#[doc = " By default, the encoder sets this minimum at half the available"]
#[doc = " range."]
pub const AV1E_SET_QM_MIN: aome_enc_control_id = 64;
#[doc = "Codec control function to set the max quant matrix flatness,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with different ranges of quantisation matrices."]
#[doc = " As quantisation levels increase, the matrices get flatter. This"]
#[doc = " control sets the maximum level of flatness possible."]
#[doc = ""]
#[doc = " By default, the encoder sets this maximum at the top of the"]
#[doc = " available range."]
pub const AV1E_SET_QM_MAX: aome_enc_control_id = 65;
#[doc = "Codec control function to set the min quant matrix flatness,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with different ranges of quantisation matrices."]
#[doc = " As quantisation levels increase, the matrices get flatter. This"]
#[doc = " control sets the flatness for luma (Y)."]
#[doc = ""]
#[doc = " By default, the encoder sets this minimum at half the available"]
#[doc = " range."]
pub const AV1E_SET_QM_Y: aome_enc_control_id = 66;
#[doc = "Codec control function to set the min quant matrix flatness,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with different ranges of quantisation matrices."]
#[doc = " As quantisation levels increase, the matrices get flatter. This"]
#[doc = " control sets the flatness for chroma (U)."]
#[doc = ""]
#[doc = " By default, the encoder sets this minimum at half the available"]
#[doc = " range."]
pub const AV1E_SET_QM_U: aome_enc_control_id = 67;
#[doc = "Codec control function to set the min quant matrix flatness,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " AOM can operate with different ranges of quantisation matrices."]
#[doc = " As quantisation levels increase, the matrices get flatter. This"]
#[doc = " control sets the flatness for chrome (V)."]
#[doc = ""]
#[doc = " By default, the encoder sets this minimum at half the available"]
#[doc = " range."]
pub const AV1E_SET_QM_V: aome_enc_control_id = 68;
#[doc = "Codec control function to set a maximum number of tile groups,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " This will set the maximum number of tile groups. This will be"]
#[doc = " overridden if an MTU size is set. The default value is 1."]
pub const AV1E_SET_NUM_TG: aome_enc_control_id = 70;
#[doc = "Codec control function to set an MTU size for a tile group, unsigned"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " This will set the maximum number of bytes in a tile group. This can be"]
#[doc = " exceeded only if a single tile is larger than this amount."]
#[doc = ""]
#[doc = " By default, the value is 0, in which case a fixed number of tile groups"]
#[doc = " is used."]
pub const AV1E_SET_MTU: aome_enc_control_id = 71;
#[doc = "Codec control function to enable/disable rectangular partitions, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_RECT_PARTITIONS: aome_enc_control_id = 73;
#[doc = "Codec control function to enable/disable AB partitions, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_AB_PARTITIONS: aome_enc_control_id = 74;
#[doc = "Codec control function to enable/disable 1:4 and 4:1 partitions, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_1TO4_PARTITIONS: aome_enc_control_id = 75;
#[doc = "Codec control function to set min partition size, int parameter"]
#[doc = ""]
#[doc = " min_partition_size is applied to both width and height of the partition."]
#[doc = " i.e, both width and height of a partition can not be smaller than"]
#[doc = " the min_partition_size, except the partition at the picture boundary."]
#[doc = ""]
#[doc = " Valid values: [4, 8, 16, 32, 64, 128]. The default value is 4 for"]
#[doc = " 4x4."]
pub const AV1E_SET_MIN_PARTITION_SIZE: aome_enc_control_id = 76;
#[doc = "Codec control function to set max partition size, int parameter"]
#[doc = ""]
#[doc = " max_partition_size is applied to both width and height of the partition."]
#[doc = " i.e, both width and height of a partition can not be larger than"]
#[doc = " the max_partition_size."]
#[doc = ""]
#[doc = " Valid values:[4, 8, 16, 32, 64, 128] The default value is 128 for"]
#[doc = " 128x128."]
pub const AV1E_SET_MAX_PARTITION_SIZE: aome_enc_control_id = 77;
#[doc = "Codec control function to turn on / off intra edge filter"]
#[doc = " at sequence level, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_INTRA_EDGE_FILTER: aome_enc_control_id = 78;
#[doc = "Codec control function to turn on / off frame order hint (int"]
#[doc = " parameter). Affects: joint compound mode, motion field motion vector,"]
#[doc = " ref frame sign bias"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_ORDER_HINT: aome_enc_control_id = 79;
#[doc = "Codec control function to turn on / off 64-length transforms, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " This will enable or disable usage of length 64 transforms in any"]
#[doc = " direction."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_TX64: aome_enc_control_id = 80;
#[doc = "Codec control function to turn on / off flip and identity"]
#[doc = " transforms, int parameter"]
#[doc = ""]
#[doc = " This will enable or disable usage of flip and identity transform"]
#[doc = " types in any direction. If enabled, this includes:"]
#[doc = " - FLIPADST_DCT"]
#[doc = " - DCT_FLIPADST"]
#[doc = " - FLIPADST_FLIPADST"]
#[doc = " - ADST_FLIPADST"]
#[doc = " - FLIPADST_ADST"]
#[doc = " - IDTX"]
#[doc = " - V_DCT"]
#[doc = " - H_DCT"]
#[doc = " - V_ADST"]
#[doc = " - H_ADST"]
#[doc = " - V_FLIPADST"]
#[doc = " - H_FLIPADST"]
#[doc = ""]
#[doc = " Valid values:"]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_FLIP_IDTX: aome_enc_control_id = 81;
#[doc = "Codec control function to turn on / off dist-wtd compound mode"]
#[doc = " at sequence level, int parameter"]
#[doc = ""]
#[doc = " This will enable or disable distance-weighted compound mode."]
#[doc = " \\attention If AV1E_SET_ENABLE_ORDER_HINT is 0, then this flag is forced"]
#[doc = " to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_DIST_WTD_COMP: aome_enc_control_id = 83;
#[doc = "Codec control function to turn on / off ref frame mvs (mfmv) usage"]
#[doc = " at sequence level, int parameter"]
#[doc = ""]
#[doc = " \\attention If AV1E_SET_ENABLE_ORDER_HINT is 0, then this flag is forced"]
#[doc = " to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_REF_FRAME_MVS: aome_enc_control_id = 84;
#[doc = "Codec control function to set temporal mv prediction"]
#[doc = " enabling/disabling at frame level, int parameter"]
#[doc = ""]
#[doc = " \\attention If AV1E_SET_ENABLE_REF_FRAME_MVS is 0, then this flag is"]
#[doc = " forced to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ALLOW_REF_FRAME_MVS: aome_enc_control_id = 85;
#[doc = "Codec control function to turn on / off dual interpolation filter"]
#[doc = " for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_ENABLE_DUAL_FILTER: aome_enc_control_id = 86;
#[doc = "Codec control function to turn on / off delta quantization in chroma"]
#[doc = " planes usage for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
pub const AV1E_SET_ENABLE_CHROMA_DELTAQ: aome_enc_control_id = 87;
#[doc = "Codec control function to turn on / off masked compound usage"]
#[doc = " (wedge and diff-wtd compound modes) for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_MASKED_COMP: aome_enc_control_id = 88;
#[doc = "Codec control function to turn on / off one sided compound usage"]
#[doc = " for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_ONESIDED_COMP: aome_enc_control_id = 89;
#[doc = "Codec control function to turn on / off interintra compound"]
#[doc = " for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_INTERINTRA_COMP: aome_enc_control_id = 90;
#[doc = "Codec control function to turn on / off smooth inter-intra"]
#[doc = " mode for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_SMOOTH_INTERINTRA: aome_enc_control_id = 91;
#[doc = "Codec control function to turn on / off difference weighted"]
#[doc = " compound, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_DIFF_WTD_COMP: aome_enc_control_id = 92;
#[doc = "Codec control function to turn on / off interinter wedge"]
#[doc = " compound, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_INTERINTER_WEDGE: aome_enc_control_id = 93;
#[doc = "Codec control function to turn on / off interintra wedge"]
#[doc = " compound, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_INTERINTRA_WEDGE: aome_enc_control_id = 94;
#[doc = "Codec control function to turn on / off global motion usage"]
#[doc = " for a sequence, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_GLOBAL_MOTION: aome_enc_control_id = 95;
#[doc = "Codec control function to turn on / off warped motion usage"]
#[doc = " at sequence level, int parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_WARPED_MOTION: aome_enc_control_id = 96;
#[doc = "Codec control function to turn on / off warped motion usage"]
#[doc = " at frame level, int parameter"]
#[doc = ""]
#[doc = " \\attention If AV1E_SET_ENABLE_WARPED_MOTION is 0, then this flag is"]
#[doc = " forced to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ALLOW_WARPED_MOTION: aome_enc_control_id = 97;
#[doc = "Codec control function to turn on / off filter intra usage at"]
#[doc = " sequence level, int parameter"]
#[doc = ""]
#[doc = " \\attention If AV1E_SET_ENABLE_FILTER_INTRA is 0, then this flag is"]
#[doc = " forced to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_FILTER_INTRA: aome_enc_control_id = 98;
#[doc = "Codec control function to turn on / off smooth intra modes usage,"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " This will enable or disable usage of smooth, smooth_h and smooth_v intra"]
#[doc = " modes."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_SMOOTH_INTRA: aome_enc_control_id = 99;
#[doc = "Codec control function to turn on / off Paeth intra mode usage, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_PAETH_INTRA: aome_enc_control_id = 100;
#[doc = "Codec control function to turn on / off CFL uv intra mode usage, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " This will enable or disable usage of chroma-from-luma intra mode."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_CFL_INTRA: aome_enc_control_id = 101;
#[doc = "Codec control function to turn on / off frame superresolution, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " \\attention If AV1E_SET_ENABLE_SUPERRES is 0, then this flag is forced to 0."]
#[doc = ""]
#[doc = " - 0 = disable"]
#[doc = " - 1 = enable (default)"]
pub const AV1E_SET_ENABLE_SUPERRES: aome_enc_control_id = 102;
#[doc = "Codec control function to turn on / off overlay frames for"]
#[doc = " filtered ALTREF frames, int parameter"]
#[doc = ""]
#[doc = " This will enable or disable coding of overlay frames for filtered ALTREF"]
#[doc = " frames. When set to 0, overlay frames are not used but show existing frame"]
#[doc = " is used to display the filtered ALTREF frame as is. As a result the decoded"]
#[doc = " frame rate remains the same as the display frame rate. The default is 1."]
pub const AV1E_SET_ENABLE_OVERLAY: aome_enc_control_id = 103;
#[doc = "Codec control function to turn on/off palette mode, int parameter"]
pub const AV1E_SET_ENABLE_PALETTE: aome_enc_control_id = 104;
#[doc = "Codec control function to turn on/off intra block copy mode, int"]
#[doc = "parameter"]
pub const AV1E_SET_ENABLE_INTRABC: aome_enc_control_id = 105;
#[doc = "Codec control function to turn on/off intra angle delta, int"]
#[doc = "parameter"]
pub const AV1E_SET_ENABLE_ANGLE_DELTA: aome_enc_control_id = 106;
#[doc = "Codec control function to set the delta q mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " AV1 supports a delta q mode feature, that allows modulating q per"]
#[doc = " superblock."]
#[doc = ""]
#[doc = " - 0 = deltaq signaling off"]
#[doc = " - 1 = use modulation to maximize objective quality (default)"]
#[doc = " - 2 = use modulation to maximize perceptual quality"]
pub const AV1E_SET_DELTAQ_MODE: aome_enc_control_id = 107;
#[doc = "Codec control function to turn on/off loopfilter modulation"]
#[doc = " when delta q modulation is enabled, unsigned int parameter."]
#[doc = ""]
#[doc = " \\attention AV1 only supports loopfilter modulation when delta q"]
#[doc = " modulation is enabled as well."]
pub const AV1E_SET_DELTALF_MODE: aome_enc_control_id = 108;
#[doc = "Codec control function to set the single tile decoding mode,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " \\attention Only applicable if large scale tiling is on."]
#[doc = ""]
#[doc = " - 0 = single tile decoding is off"]
#[doc = " - 1 = single tile decoding is on (default)"]
pub const AV1E_SET_SINGLE_TILE_DECODING: aome_enc_control_id = 109;
#[doc = "Codec control function to enable the extreme motion vector unit"]
#[doc = " test, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = off"]
#[doc = " - 1 = MAX_EXTREME_MV"]
#[doc = " - 2 = MIN_EXTREME_MV"]
#[doc = ""]
#[doc = " \\note This is only used in motion vector unit test."]
pub const AV1E_ENABLE_MOTION_VECTOR_UNIT_TEST: aome_enc_control_id = 110;
#[doc = "Codec control function to signal picture timing info in the"]
#[doc = " bitstream, aom_timing_info_type_t parameter. Default is"]
#[doc = " AOM_TIMING_UNSPECIFIED."]
pub const AV1E_SET_TIMING_INFO_TYPE: aome_enc_control_id = 111;
#[doc = "Codec control function to add film grain parameters (one of several"]
#[doc = " preset types) info in the bitstream, int parameter"]
#[doc = ""]
#[doc = "Valid range: 0..16, 0 is unknown, 1..16 are test vectors"]
pub const AV1E_SET_FILM_GRAIN_TEST_VECTOR: aome_enc_control_id = 112;
#[doc = "Codec control function to set the path to the film grain parameters,"]
#[doc = " const char* parameter"]
pub const AV1E_SET_FILM_GRAIN_TABLE: aome_enc_control_id = 113;
#[doc = "Sets the noise level, int parameter"]
pub const AV1E_SET_DENOISE_NOISE_LEVEL: aome_enc_control_id = 114;
#[doc = "Sets the denoisers block size, unsigned int parameter"]
pub const AV1E_SET_DENOISE_BLOCK_SIZE: aome_enc_control_id = 115;
#[doc = "Sets the chroma subsampling x value, unsigned int parameter"]
pub const AV1E_SET_CHROMA_SUBSAMPLING_X: aome_enc_control_id = 116;
#[doc = "Sets the chroma subsampling y value, unsigned int parameter"]
pub const AV1E_SET_CHROMA_SUBSAMPLING_Y: aome_enc_control_id = 117;
#[doc = "Control to use a reduced tx type set, int parameter"]
pub const AV1E_SET_REDUCED_TX_TYPE_SET: aome_enc_control_id = 118;
#[doc = "Control to use dct only for intra modes, int parameter"]
pub const AV1E_SET_INTRA_DCT_ONLY: aome_enc_control_id = 119;
#[doc = "Control to use dct only for inter modes, int parameter"]
pub const AV1E_SET_INTER_DCT_ONLY: aome_enc_control_id = 120;
#[doc = "Control to use default tx type only for intra modes, int parameter"]
pub const AV1E_SET_INTRA_DEFAULT_TX_ONLY: aome_enc_control_id = 121;
#[doc = "Control to use adaptive quantize_b, int parameter"]
pub const AV1E_SET_QUANT_B_ADAPT: aome_enc_control_id = 122;
#[doc = "Control to select maximum height for the GF group pyramid structure,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " Valid range: 0..4"]
pub const AV1E_SET_GF_MAX_PYRAMID_HEIGHT: aome_enc_control_id = 123;
#[doc = "Control to select maximum reference frames allowed per frame, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " Valid range: 3..7"]
pub const AV1E_SET_MAX_REFERENCE_FRAMES: aome_enc_control_id = 124;
#[doc = "Control to use reduced set of single and compound references, int"]
#[doc = "parameter"]
pub const AV1E_SET_REDUCED_REFERENCE_SET: aome_enc_control_id = 125;
#[doc = "Control to set frequency of the cost updates for coefficients,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = update at SB level (default)"]
#[doc = " - 1 = update at SB row level in tile"]
#[doc = " - 2 = update at tile level"]
#[doc = " - 3 = turn off"]
pub const AV1E_SET_COEFF_COST_UPD_FREQ: aome_enc_control_id = 140;
#[doc = "Control to set frequency of the cost updates for mode, unsigned int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " - 0 = update at SB level (default)"]
#[doc = " - 1 = update at SB row level in tile"]
#[doc = " - 2 = update at tile level"]
#[doc = " - 3 = turn off"]
pub const AV1E_SET_MODE_COST_UPD_FREQ: aome_enc_control_id = 141;
#[doc = "Control to set frequency of the cost updates for motion vectors,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = update at SB level (default)"]
#[doc = " - 1 = update at SB row level in tile"]
#[doc = " - 2 = update at tile level"]
#[doc = " - 3 = turn off"]
pub const AV1E_SET_MV_COST_UPD_FREQ: aome_enc_control_id = 142;
#[doc = "Control to set bit mask that specifies which tier each of the 32"]
#[doc = " possible operating points conforms to, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = main tier (default)"]
#[doc = " - 1 = high tier"]
pub const AV1E_SET_TIER_MASK: aome_enc_control_id = 143;
#[doc = "Control to set minimum compression ratio, unsigned int parameter"]
#[doc = " Take integer values. If non-zero, encoder will try to keep the compression"]
#[doc = " ratio of each frame to be higher than the given value divided by 100."]
#[doc = " E.g. 850 means minimum compression ratio of 8.5."]
pub const AV1E_SET_MIN_CR: aome_enc_control_id = 144;
#[doc = "Codec control function to set the layer id, aom_svc_layer_id_t*"]
#[doc = " parameter"]
pub const AV1E_SET_SVC_LAYER_ID: aome_enc_control_id = 150;
#[doc = "Codec control function to set SVC paramaeters, aom_svc_params_t*"]
#[doc = " parameter"]
pub const AV1E_SET_SVC_PARAMS: aome_enc_control_id = 151;
#[doc = "Codec control function to set reference frame config:"]
#[doc = " the ref_idx and the refresh flags for each buffer slot."]
#[doc = " aom_svc_ref_frame_config_t* parameter"]
pub const AV1E_SET_SVC_REF_FRAME_CONFIG: aome_enc_control_id = 152;
#[doc = "Codec control function to set the path to the VMAF model used when"]
#[doc = " tuning the encoder for VMAF, const char* parameter"]
pub const AV1E_SET_VMAF_MODEL_PATH: aome_enc_control_id = 153;
#[doc = "Codec control function to enable EXT_TILE_DEBUG in AV1 encoder,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
#[doc = ""]
#[doc = " \\note This is only used in lightfield example test."]
pub const AV1E_ENABLE_EXT_TILE_DEBUG: aome_enc_control_id = 154;
#[doc = "Codec control function to enable the superblock multipass unit test"]
#[doc = " in AV1 to ensure that the encoder does not leak state between different"]
#[doc = " passes. unsigned int parameter."]
#[doc = ""]
#[doc = " - 0 = disable (default)"]
#[doc = " - 1 = enable"]
#[doc = ""]
#[doc = " \\note This is only used in sb_multipass unit test."]
pub const AV1E_ENABLE_SB_MULTIPASS_UNIT_TEST: aome_enc_control_id = 155;
#[doc = "Control to select minimum height for the GF group pyramid structure,"]
#[doc = " unsigned int parameter"]
#[doc = ""]
#[doc = " Valid values: 0..4"]
pub const AV1E_SET_GF_MIN_PYRAMID_HEIGHT: aome_enc_control_id = 156;
#[doc = "Control to set average complexity of the corpus in the case of"]
#[doc = " single pass vbr based on LAP, unsigned int parameter"]
pub const AV1E_SET_VBR_CORPUS_COMPLEXITY_LAP: aome_enc_control_id = 157;
#[doc = "Control to get baseline gf interval"]
pub const AV1E_GET_BASELINE_GF_INTERVAL: aome_enc_control_id = 158;
#[doc = "AVx encoder control functions"]
#[doc = ""]
#[doc = " This set of macros define the control functions available for AVx"]
#[doc = " encoder interface."]
#[doc = ""]
#[doc = " \\sa #aom_codec_control(aom_codec_ctx_t *ctx, int ctrl_id, ...)"]
pub type aome_enc_control_id = u32;
pub const AOME_NORMAL: aom_scaling_mode_1d = 0;
pub const AOME_FOURFIVE: aom_scaling_mode_1d = 1;
pub const AOME_THREEFIVE: aom_scaling_mode_1d = 2;
pub const AOME_THREEFOUR: aom_scaling_mode_1d = 3;
pub const AOME_ONEFOUR: aom_scaling_mode_1d = 4;
pub const AOME_ONEEIGHT: aom_scaling_mode_1d = 5;
pub const AOME_ONETWO: aom_scaling_mode_1d = 6;
#[doc = "aom 1-D scaling mode"]
#[doc = ""]
#[doc = " This set of constants define 1-D aom scaling modes"]
pub type aom_scaling_mode_1d = u32;
#[doc = "aom 1-D scaling mode"]
#[doc = ""]
#[doc = " This set of constants define 1-D aom scaling modes"]
pub use self::aom_scaling_mode_1d as AOM_SCALING_MODE;
#[doc = " aom region of interest map"]
#[doc = ""]
#[doc = " These defines the data structures for the region of interest map"]
#[doc = ""]
#[doc = " TODO(yaowu): create a unit test for ROI map related APIs"]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_roi_map {
    #[doc = " An id between 0 and 7 for each 8x8 region within a frame."]
    pub roi_map: *mut ::std::os::raw::c_uchar,
    #[doc = "Number of rows."]
    pub rows: ::std::os::raw::c_uint,
    #[doc = "Number of columns."]
    pub cols: ::std::os::raw::c_uint,
    #[doc = "Quantizer deltas."]
    pub delta_q: [::std::os::raw::c_int; 8usize],
    #[doc = "Loop filter deltas."]
    pub delta_lf: [::std::os::raw::c_int; 8usize],
    #[doc = " Static breakout threshold for each segment."]
    pub static_threshold: [::std::os::raw::c_uint; 8usize],
}
#[doc = " aom region of interest map"]
#[doc = ""]
#[doc = " These defines the data structures for the region of interest map"]
#[doc = ""]
#[doc = " TODO(yaowu): create a unit test for ROI map related APIs"]
#[doc = ""]
pub type aom_roi_map_t = aom_roi_map;
#[doc = " aom active region map"]
#[doc = ""]
#[doc = " These defines the data structures for active region map"]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_active_map {
    #[doc = "specify an on (1) or off (0) each 16x16 region within a frame"]
    pub active_map: *mut ::std::os::raw::c_uchar,
    #[doc = "number of rows"]
    pub rows: ::std::os::raw::c_uint,
    #[doc = "number of cols"]
    pub cols: ::std::os::raw::c_uint,
}
#[doc = " aom active region map"]
#[doc = ""]
#[doc = " These defines the data structures for active region map"]
#[doc = ""]
pub type aom_active_map_t = aom_active_map;
#[doc = " aom image scaling mode"]
#[doc = ""]
#[doc = " This defines the data structure for image scaling mode"]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_scaling_mode {
    #[doc = "horizontal scaling mode"]
    pub h_scaling_mode: AOM_SCALING_MODE,
    #[doc = "vertical scaling mode"]
    pub v_scaling_mode: AOM_SCALING_MODE,
}
#[doc = " aom image scaling mode"]
#[doc = ""]
#[doc = " This defines the data structure for image scaling mode"]
#[doc = ""]
pub type aom_scaling_mode_t = aom_scaling_mode;
pub const AOM_CONTENT_DEFAULT: aom_tune_content = 0;
pub const AOM_CONTENT_SCREEN: aom_tune_content = 1;
pub const AOM_CONTENT_INVALID: aom_tune_content = 2;
#[doc = "brief AV1 encoder content type"]
pub type aom_tune_content = u32;
pub const AOM_TIMING_UNSPECIFIED: aom_timing_info_type_t = 0;
pub const AOM_TIMING_EQUAL: aom_timing_info_type_t = 1;
pub const AOM_TIMING_DEC_MODEL: aom_timing_info_type_t = 2;
#[doc = "brief AV1 encoder timing info type signaling"]
pub type aom_timing_info_type_t = u32;
pub const AOM_TUNE_PSNR: aom_tune_metric = 0;
pub const AOM_TUNE_SSIM: aom_tune_metric = 1;
pub const AOM_TUNE_VMAF_WITH_PREPROCESSING: aom_tune_metric = 4;
pub const AOM_TUNE_VMAF_WITHOUT_PREPROCESSING: aom_tune_metric = 5;
pub const AOM_TUNE_VMAF_MAX_GAIN: aom_tune_metric = 6;
#[doc = "Model tuning parameters"]
#[doc = ""]
#[doc = " Changes the encoder to tune for certain types of input material."]
#[doc = ""]
pub type aom_tune_metric = u32;
#[doc = "brief Struct for spatial and temporal layer ID"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_svc_layer_id {
    #[doc = "Spatial layer ID"]
    pub spatial_layer_id: ::std::os::raw::c_int,
    #[doc = "Temporal layer ID"]
    pub temporal_layer_id: ::std::os::raw::c_int,
}
#[doc = "brief Struct for spatial and temporal layer ID"]
pub type aom_svc_layer_id_t = aom_svc_layer_id;
#[doc = "brief Parameter type for SVC"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_svc_params {
    #[doc = "Number of spatial layers"]
    pub number_spatial_layers: ::std::os::raw::c_int,
    #[doc = "Number of temporal layers"]
    pub number_temporal_layers: ::std::os::raw::c_int,
    #[doc = "Max Q for each layer"]
    pub max_quantizers: [::std::os::raw::c_int; 32usize],
    #[doc = "Min Q for each layer"]
    pub min_quantizers: [::std::os::raw::c_int; 32usize],
    #[doc = "Scaling factor-numerator"]
    pub scaling_factor_num: [::std::os::raw::c_int; 4usize],
    #[doc = "Scaling factor-denominator"]
    pub scaling_factor_den: [::std::os::raw::c_int; 4usize],
    #[doc = " Target bitrate for each layer"]
    pub layer_target_bitrate: [::std::os::raw::c_int; 32usize],
    #[doc = " Frame rate factor for each temporal layer"]
    pub framerate_factor: [::std::os::raw::c_int; 8usize],
}
#[doc = "brief Parameter type for SVC"]
pub type aom_svc_params_t = aom_svc_params;
#[doc = "brief Parameters for setting ref frame config"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_svc_ref_frame_config {
    #[doc = "Reference flag for each of the 7 references."]
    pub reference: [::std::os::raw::c_int; 7usize],
    #[doc = " Buffer slot index for each of 7 references."]
    pub ref_idx: [::std::os::raw::c_int; 7usize],
    #[doc = "Refresh flag for each of the 8 slots."]
    pub refresh: [::std::os::raw::c_int; 8usize],
}
#[doc = "brief Parameters for setting ref frame config"]
pub type aom_svc_ref_frame_config_t = aom_svc_ref_frame_config;
pub type aom_codec_control_type_AOME_USE_REFERENCE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AOME_SET_ROI_MAP = *mut aom_roi_map_t;
pub type aom_codec_control_type_AOME_SET_ACTIVEMAP = *mut aom_active_map_t;
pub type aom_codec_control_type_AOME_SET_SCALEMODE = *mut aom_scaling_mode_t;
pub type aom_codec_control_type_AOME_SET_SPATIAL_LAYER_ID = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_CPUUSED = ::std::os::raw::c_int;
pub type aom_codec_control_type_AOME_SET_ENABLEAUTOALTREF = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_ENABLEAUTOBWDREF = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_SHARPNESS = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_STATIC_THRESHOLD = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_ARNR_MAXFRAMES = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_ARNR_STRENGTH = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_TUNING = ::std::os::raw::c_int;
pub type aom_codec_control_type_AOME_SET_CQ_LEVEL = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ROW_MT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_TILE_COLUMNS = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_TILE_ROWS = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_TPL_MODEL = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_KEYFRAME_FILTERING = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_GET_LAST_QUANTIZER = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOME_GET_LAST_QUANTIZER_64 = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOME_SET_MAX_INTRA_BITRATE_PCT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_MAX_INTER_BITRATE_PCT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AOME_SET_NUMBER_SPATIAL_LAYERS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_GF_CBR_BOOST_PCT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_LOSSLESS = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_CDEF = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_RESTORATION = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_FORCE_VIDEO_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_OBMC = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_DISABLE_TRELLIS_QUANT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_QM = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ENABLE_DIST_8X8 = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_QM_MIN = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_QM_MAX = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_QM_Y = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_QM_U = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_QM_V = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_NUM_TG = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MTU = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_TIMING_INFO_TYPE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_RECT_PARTITIONS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_AB_PARTITIONS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_1TO4_PARTITIONS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_MIN_PARTITION_SIZE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_MAX_PARTITION_SIZE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_INTRA_EDGE_FILTER = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_ORDER_HINT = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_TX64 = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_FLIP_IDTX = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_DIST_WTD_COMP = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_REF_FRAME_MVS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ALLOW_REF_FRAME_MVS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_DUAL_FILTER = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_CHROMA_DELTAQ = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_MASKED_COMP = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_ONESIDED_COMP = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_INTERINTRA_COMP = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_SMOOTH_INTERINTRA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_DIFF_WTD_COMP = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_INTERINTER_WEDGE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_INTERINTRA_WEDGE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_GLOBAL_MOTION = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_WARPED_MOTION = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ALLOW_WARPED_MOTION = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_FILTER_INTRA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_SMOOTH_INTRA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_PAETH_INTRA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_CFL_INTRA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_SUPERRES = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_OVERLAY = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_PALETTE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_INTRABC = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_ENABLE_ANGLE_DELTA = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_FRAME_PARALLEL_DECODING = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_ERROR_RESILIENT_MODE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_S_FRAME_MODE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_AQ_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_DELTAQ_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_DELTALF_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_FRAME_PERIODIC_BOOST = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_NOISE_SENSITIVITY = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_TUNE_CONTENT = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_COLOR_PRIMARIES = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_TRANSFER_CHARACTERISTICS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_MATRIX_COEFFICIENTS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_CHROMA_SAMPLE_POSITION = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_MIN_GF_INTERVAL = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MAX_GF_INTERVAL = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_GET_ACTIVEMAP = *mut aom_active_map_t;
pub type aom_codec_control_type_AV1E_SET_COLOR_RANGE = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_RENDER_SIZE = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_SUPERBLOCK_SIZE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_GET_SEQ_LEVEL_IDX = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_GET_BASELINE_GF_INTERVAL = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_SINGLE_TILE_DECODING = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_ENABLE_MOTION_VECTOR_UNIT_TEST = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_ENABLE_EXT_TILE_DEBUG = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_VMAF_MODEL_PATH = *const ::std::os::raw::c_char;
pub type aom_codec_control_type_AV1E_SET_FILM_GRAIN_TEST_VECTOR = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_FILM_GRAIN_TABLE = *const ::std::os::raw::c_char;
pub type aom_codec_control_type_AV1E_SET_CDF_UPDATE_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_DENOISE_NOISE_LEVEL = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_DENOISE_BLOCK_SIZE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_CHROMA_SUBSAMPLING_X = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_CHROMA_SUBSAMPLING_Y = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_REDUCED_TX_TYPE_SET = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_INTRA_DCT_ONLY = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_INTER_DCT_ONLY = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_INTRA_DEFAULT_TX_ONLY = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_QUANT_B_ADAPT = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_GF_MIN_PYRAMID_HEIGHT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_GF_MAX_PYRAMID_HEIGHT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MAX_REFERENCE_FRAMES = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_REDUCED_REFERENCE_SET = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_COEFF_COST_UPD_FREQ = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MODE_COST_UPD_FREQ = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MV_COST_UPD_FREQ = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_TARGET_SEQ_LEVEL_IDX = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1E_SET_TIER_MASK = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_MIN_CR = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_SVC_LAYER_ID = *mut aom_svc_layer_id_t;
pub type aom_codec_control_type_AV1E_SET_SVC_PARAMS = *mut aom_svc_params_t;
pub type aom_codec_control_type_AV1E_SET_SVC_REF_FRAME_CONFIG = *mut aom_svc_ref_frame_config_t;
pub type aom_codec_control_type_AV1E_ENABLE_SB_MULTIPASS_UNIT_TEST = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1E_SET_VBR_CORPUS_COMPLEXITY_LAP = ::std::os::raw::c_uint;
extern "C" {
    pub static mut aom_codec_av1_dx_algo: aom_codec_iface_t;
}
extern "C" {
    #[doc = "The interface to the AV1 decoder."]
    pub fn aom_codec_av1_dx() -> *mut aom_codec_iface_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Accounting {
    _unused: [u8; 0],
}
#[doc = " Callback that inspects decoder frame data."]
pub type aom_inspect_cb = ::std::option::Option<
    unsafe extern "C" fn(decoder: *mut ::std::os::raw::c_void, ctx: *mut ::std::os::raw::c_void),
>;
#[doc = "Structure to hold inspection callback and context."]
#[doc = ""]
#[doc = " Defines a structure to hold the inspection callback function and calling"]
#[doc = " context."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_inspect_init {
    #[doc = " Inspection callback."]
    pub inspect_cb: aom_inspect_cb,
    #[doc = " Inspection context."]
    pub inspect_ctx: *mut ::std::os::raw::c_void,
}
#[doc = "Structure to hold a tile's start address and size in the bitstream."]
#[doc = ""]
#[doc = " Defines a structure to hold a tile's start address and size in the bitstream."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_tile_data {
    #[doc = " Tile data size."]
    pub coded_tile_data_size: usize,
    #[doc = " Tile's start address."]
    pub coded_tile_data: *const ::std::os::raw::c_void,
    #[doc = " Extra size information."]
    pub extra_size: usize,
}
#[doc = "Structure to hold information about tiles in a frame."]
#[doc = ""]
#[doc = " Defines a structure to hold a frame's tile information, namely"]
#[doc = " number of tile columns, number of tile_rows, and the width and"]
#[doc = " height of each tile."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct aom_tile_info {
    #[doc = " Indicates the number of tile columns."]
    pub tile_columns: ::std::os::raw::c_int,
    #[doc = " Indicates the number of tile rows."]
    pub tile_rows: ::std::os::raw::c_int,
    #[doc = " Indicates the tile widths in units of SB."]
    pub tile_widths: [::std::os::raw::c_int; 64usize],
    #[doc = " Indicates the tile heights in units of SB."]
    pub tile_heights: [::std::os::raw::c_int; 64usize],
    #[doc = " Indicates the number of tile groups present in a frame."]
    pub num_tile_groups: ::std::os::raw::c_int,
}
#[doc = "Structure to hold information about still image coding."]
#[doc = ""]
#[doc = " Defines a structure to hold a information regarding still picture"]
#[doc = " and its header type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_still_picture_info {
    #[doc = " Video is a single frame still picture"]
    pub is_still_picture: ::std::os::raw::c_int,
    #[doc = " Use full header for still picture"]
    pub is_reduced_still_picture_hdr: ::std::os::raw::c_int,
}
#[doc = "Structure to hold information about S_FRAME."]
#[doc = ""]
#[doc = " Defines a structure to hold a information regarding S_FRAME"]
#[doc = " and its position."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_s_frame_info {
    #[doc = " Indicates if current frame is S_FRAME"]
    pub is_s_frame: ::std::os::raw::c_int,
    #[doc = " Indicates if current S_FRAME is present at ALTREF frame"]
    pub is_s_frame_at_altref: ::std::os::raw::c_int,
}
#[doc = "Structure to hold information about screen content tools."]
#[doc = ""]
#[doc = " Defines a structure to hold information about screen content"]
#[doc = " tools, namely: allow_screen_content_tools, allow_intrabc, and"]
#[doc = " force_integer_mv."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aom_screen_content_tools_info {
    #[doc = " Are screen content tools allowed"]
    pub allow_screen_content_tools: ::std::os::raw::c_int,
    #[doc = " Is intrabc allowed"]
    pub allow_intrabc: ::std::os::raw::c_int,
    #[doc = " Is integer mv forced"]
    pub force_integer_mv: ::std::os::raw::c_int,
}
#[doc = "Structure to hold the external reference frame pointer."]
#[doc = ""]
#[doc = " Define a structure to hold the external reference frame pointer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct av1_ext_ref_frame {
    #[doc = " Start pointer of external references."]
    pub img: *mut aom_image_t,
    #[doc = " Number of available external references."]
    pub num: ::std::os::raw::c_int,
}
#[doc = "Structure to hold the external reference frame pointer."]
#[doc = ""]
#[doc = " Define a structure to hold the external reference frame pointer."]
pub type av1_ext_ref_frame_t = av1_ext_ref_frame;
#[doc = "Codec control function to get info on which reference frames were"]
#[doc = " updated by the last decode, int* parameter"]
pub const AOMD_GET_LAST_REF_UPDATES: aom_dec_control_id = 256;
#[doc = "Codec control function to check if the indicated frame is"]
#[doc = "corrupted, int* parameter"]
pub const AOMD_GET_FRAME_CORRUPTED: aom_dec_control_id = 257;
#[doc = "Codec control function to get info on which reference frames were"]
#[doc = " used by the last decode, int* parameter"]
pub const AOMD_GET_LAST_REF_USED: aom_dec_control_id = 258;
#[doc = "Codec control function to get the dimensions that the current"]
#[doc = " frame is decoded at, int* parameter. This may be different to the"]
#[doc = " intended display size for the frame as specified in the wrapper or frame"]
#[doc = " header (see AV1D_GET_DISPLAY_SIZE)."]
pub const AV1D_GET_FRAME_SIZE: aom_dec_control_id = 259;
#[doc = "Codec control function to get the current frame's intended display"]
#[doc = " dimensions (as specified in the wrapper or frame header), int* parameter."]
#[doc = " This may be different to the decoded dimensions of this frame (see"]
#[doc = " AV1D_GET_FRAME_SIZE)."]
pub const AV1D_GET_DISPLAY_SIZE: aom_dec_control_id = 260;
#[doc = "Codec control function to get the bit depth of the stream,"]
#[doc = " unsigned int* parameter"]
pub const AV1D_GET_BIT_DEPTH: aom_dec_control_id = 261;
#[doc = "Codec control function to get the image format of the stream,"]
#[doc = " aom_img_fmt_t* parameter"]
pub const AV1D_GET_IMG_FORMAT: aom_dec_control_id = 262;
#[doc = "Codec control function to get the size of the tile, unsigned int"]
#[doc = "parameter"]
pub const AV1D_GET_TILE_SIZE: aom_dec_control_id = 263;
#[doc = "Codec control function to get the tile count in a tile list, int*"]
#[doc = " parameter"]
pub const AV1D_GET_TILE_COUNT: aom_dec_control_id = 264;
#[doc = "Codec control function to set the byte alignment of the planes in"]
#[doc = " the reference buffers, int parameter"]
#[doc = ""]
#[doc = " Valid values are power of 2, from 32 to 1024. A value of 0 sets"]
#[doc = " legacy alignment. I.e. Y plane is aligned to 32 bytes, U plane directly"]
#[doc = " follows Y plane, and V plane directly follows U plane. Default value is 0."]
pub const AV1_SET_BYTE_ALIGNMENT: aom_dec_control_id = 265;
#[doc = "Codec control function to invert the decoding order to from right to"]
#[doc = " left, int parameter"]
#[doc = ""]
#[doc = " The function is used in a test to confirm the decoding independence of tile"]
#[doc = " columns. The function may be used in application where this order"]
#[doc = " of decoding is desired. int parameter"]
#[doc = ""]
#[doc = " TODO(yaowu): Rework the unit test that uses this control, and in a future"]
#[doc = "              release, this test-only control shall be removed."]
pub const AV1_INVERT_TILE_DECODE_ORDER: aom_dec_control_id = 266;
#[doc = "Codec control function to set the skip loop filter flag, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " Valid values are integers. The decoder will skip the loop filter"]
#[doc = " when its value is set to nonzero. If the loop filter is skipped the"]
#[doc = " decoder may accumulate decode artifacts. The default value is 0."]
pub const AV1_SET_SKIP_LOOP_FILTER: aom_dec_control_id = 267;
#[doc = "Codec control function to retrieve a pointer to the Accounting"]
#[doc = " struct, takes Accounting** as parameter"]
#[doc = ""]
#[doc = " If called before a frame has been decoded, this returns AOM_CODEC_ERROR."]
#[doc = " The caller should ensure that AOM_CODEC_OK is returned before attempting"]
#[doc = " to dereference the Accounting pointer."]
#[doc = ""]
#[doc = " \\attention When compiled without --enable-accounting, this returns"]
#[doc = " AOM_CODEC_INCAPABLE."]
pub const AV1_GET_ACCOUNTING: aom_dec_control_id = 268;
#[doc = "Codec control function to get last decoded frame quantizer,"]
#[doc = " int* parameter"]
#[doc = ""]
#[doc = " Returned value uses internal quantizer scale defined by the codec."]
pub const AOMD_GET_LAST_QUANTIZER: aom_dec_control_id = 269;
#[doc = "Codec control function to set the range of tile decoding, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " A value that is greater and equal to zero indicates only the specific"]
#[doc = " row/column is decoded. A value that is -1 indicates the whole row/column"]
#[doc = " is decoded. A special case is both values are -1 that means the whole"]
#[doc = " frame is decoded."]
pub const AV1_SET_DECODE_TILE_ROW: aom_dec_control_id = 270;
#[doc = "Codec control function to set the range of tile decoding, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " A value that is greater and equal to zero indicates only the specific"]
#[doc = " row/column is decoded. A value that is -1 indicates the whole row/column"]
#[doc = " is decoded. A special case is both values are -1 that means the whole"]
#[doc = " frame is decoded."]
pub const AV1_SET_DECODE_TILE_COL: aom_dec_control_id = 271;
#[doc = "Codec control function to set the tile coding mode, int parameter"]
#[doc = ""]
#[doc = " - 0 = tiles are coded in normal tile mode"]
#[doc = " - 1 = tiles are coded in large-scale tile mode"]
pub const AV1_SET_TILE_MODE: aom_dec_control_id = 272;
#[doc = "Codec control function to get the frame header information of an"]
#[doc = " encoded frame, unsigned int* parameter"]
pub const AV1D_GET_FRAME_HEADER_INFO: aom_dec_control_id = 273;
#[doc = "Codec control function to get the start address and size of a"]
#[doc = " tile in the coded bitstream, aom_tile_data* parameter."]
pub const AV1D_GET_TILE_DATA: aom_dec_control_id = 274;
#[doc = "Codec control function to set the external references' pointers in"]
#[doc = " the decoder, av1_ext_ref_frame_t* parameter."]
#[doc = ""]
#[doc = " This is used while decoding the tile list OBU in large-scale tile coding"]
#[doc = " mode."]
pub const AV1D_SET_EXT_REF_PTR: aom_dec_control_id = 275;
#[doc = "Codec control function to enable the ext-tile software debug and"]
#[doc = " testing code in the decoder, unsigned int parameter"]
pub const AV1D_EXT_TILE_DEBUG: aom_dec_control_id = 276;
#[doc = "Codec control function to enable the row based multi-threading of"]
#[doc = " decoding, unsigned int parameter"]
#[doc = ""]
#[doc = " - 0 = disabled"]
#[doc = " - 1 = enabled (default)"]
pub const AV1D_SET_ROW_MT: aom_dec_control_id = 277;
#[doc = "Codec control function to indicate whether bitstream is in"]
#[doc = " Annex-B format, unsigned int parameter"]
pub const AV1D_SET_IS_ANNEXB: aom_dec_control_id = 278;
#[doc = "Codec control function to indicate which operating point to use,"]
#[doc = " int parameter"]
#[doc = ""]
#[doc = " A scalable stream may define multiple operating points, each of which"]
#[doc = " defines a set of temporal and spatial layers to be processed. The"]
#[doc = " operating point index may take a value between 0 and"]
#[doc = " operating_points_cnt_minus_1 (which is at most 31)."]
pub const AV1D_SET_OPERATING_POINT: aom_dec_control_id = 279;
#[doc = "Codec control function to indicate whether to output one frame per"]
#[doc = " temporal unit (the default), or one frame per spatial layer. int parameter"]
#[doc = ""]
#[doc = " In a scalable stream, each temporal unit corresponds to a single \"frame\""]
#[doc = " of video, and within a temporal unit there may be multiple spatial layers"]
#[doc = " with different versions of that frame."]
#[doc = " For video playback, only the highest-quality version (within the"]
#[doc = " selected operating point) is needed, but for some use cases it is useful"]
#[doc = " to have access to multiple versions of a frame when they are available."]
pub const AV1D_SET_OUTPUT_ALL_LAYERS: aom_dec_control_id = 280;
#[doc = "Codec control function to set an aom_inspect_cb callback that is"]
#[doc = " invoked each time a frame is decoded, aom_inspect_init* parameter"]
#[doc = ""]
#[doc = " \\attention When compiled without --enable-inspection, this"]
#[doc = " returns AOM_CODEC_INCAPABLE."]
pub const AV1_SET_INSPECTION_CALLBACK: aom_dec_control_id = 281;
#[doc = "Codec control function to set the skip film grain flag, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " Valid values are integers. The decoder will skip the film grain when its"]
#[doc = " value is set to nonzero. The default value is 0."]
pub const AV1D_SET_SKIP_FILM_GRAIN: aom_dec_control_id = 282;
#[doc = "Codec control function to set the skip film grain flag, int"]
#[doc = " parameter"]
#[doc = ""]
#[doc = " Valid values are integers. The decoder will skip the film grain when its"]
#[doc = " value is set to nonzero. The default value is 0."]
pub const AOM_DECODER_CTRL_ID_MAX: aom_dec_control_id = 283;
#[doc = "Codec control function to check the presence of forward key frames"]
pub const AOMD_GET_FWD_KF_PRESENT: aom_dec_control_id = 284;
#[doc = "Codec control function to get the frame flags of the previous frame"]
#[doc = " decoded. This will return a flag of type aom_codec_frame_flags_t."]
pub const AOMD_GET_FRAME_FLAGS: aom_dec_control_id = 285;
#[doc = "Codec control function to check the presence of altref frames"]
pub const AOMD_GET_ALTREF_PRESENT: aom_dec_control_id = 286;
#[doc = "Codec control function to get tile information of the previous frame"]
#[doc = " decoded. This will return a struct of type aom_tile_info."]
pub const AOMD_GET_TILE_INFO: aom_dec_control_id = 287;
#[doc = "Codec control function to get screen content tools information."]
#[doc = " It returns a struct of type aom_screen_content_tools_info, which contains"]
#[doc = " the header flags allow_screen_content_tools, allow_intrabc, and"]
#[doc = " force_integer_mv."]
pub const AOMD_GET_SCREEN_CONTENT_TOOLS_INFO: aom_dec_control_id = 288;
#[doc = "Codec control function to get the still picture coding information"]
pub const AOMD_GET_STILL_PICTURE: aom_dec_control_id = 289;
#[doc = "Codec control function to get superblock size."]
#[doc = " It returns an integer, indicating the superblock size"]
#[doc = " read from the sequence header(0 for BLOCK_64X64 and"]
#[doc = " 1 for BLOCK_128X128)"]
pub const AOMD_GET_SB_SIZE: aom_dec_control_id = 290;
#[doc = "Codec control function to check if the previous frame"]
#[doc = " decoded has show existing frame flag set."]
pub const AOMD_GET_SHOW_EXISTING_FRAME_FLAG: aom_dec_control_id = 291;
#[doc = "Codec control function to get the S_FRAME coding information"]
pub const AOMD_GET_S_FRAME_INFO: aom_dec_control_id = 292;
#[doc = "\\enum aom_dec_control_id"]
#[doc = "AOM decoder control functions"]
#[doc = ""]
#[doc = " This set of macros define the control functions available for the AOM"]
#[doc = " decoder interface."]
#[doc = ""]
#[doc = " \\sa #aom_codec_control(aom_codec_ctx_t *ctx, int ctrl_id, ...)"]
pub type aom_dec_control_id = u32;
pub type aom_codec_control_type_AOMD_GET_LAST_REF_UPDATES = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_FRAME_CORRUPTED = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_LAST_REF_USED = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_LAST_QUANTIZER = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_FWD_KF_PRESENT = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_ALTREF_PRESENT = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_FRAME_FLAGS = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_TILE_INFO = *mut aom_tile_info;
pub type aom_codec_control_type_AOMD_GET_SCREEN_CONTENT_TOOLS_INFO =
    *mut aom_screen_content_tools_info;
pub type aom_codec_control_type_AOMD_GET_STILL_PICTURE = *mut aom_still_picture_info;
pub type aom_codec_control_type_AOMD_GET_SB_SIZE = *mut aom_superblock_size_t;
pub type aom_codec_control_type_AOMD_GET_SHOW_EXISTING_FRAME_FLAG = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AOMD_GET_S_FRAME_INFO = *mut aom_s_frame_info;
pub type aom_codec_control_type_AV1D_GET_DISPLAY_SIZE = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1D_GET_BIT_DEPTH = *mut ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_GET_IMG_FORMAT = *mut aom_img_fmt_t;
pub type aom_codec_control_type_AV1D_GET_TILE_SIZE = *mut ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_GET_TILE_COUNT = *mut ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_GET_FRAME_SIZE = *mut ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1_INVERT_TILE_DECODE_ORDER = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1_GET_ACCOUNTING = *mut *mut Accounting;
pub type aom_codec_control_type_AV1_SET_DECODE_TILE_ROW = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1_SET_DECODE_TILE_COL = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1_SET_TILE_MODE = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_GET_FRAME_HEADER_INFO = *mut aom_tile_data;
pub type aom_codec_control_type_AV1D_GET_TILE_DATA = *mut aom_tile_data;
pub type aom_codec_control_type_AV1D_SET_EXT_REF_PTR = *mut av1_ext_ref_frame_t;
pub type aom_codec_control_type_AV1D_EXT_TILE_DEBUG = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_SET_ROW_MT = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_SET_SKIP_FILM_GRAIN = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1D_SET_IS_ANNEXB = ::std::os::raw::c_uint;
pub type aom_codec_control_type_AV1D_SET_OPERATING_POINT = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1D_SET_OUTPUT_ALL_LAYERS = ::std::os::raw::c_int;
pub type aom_codec_control_type_AV1_SET_INSPECTION_CALLBACK = *mut aom_inspect_init;
