// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Animation;
use crate::AnimationTarget;
use crate::Easing;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "AdwTimedAnimation")]
    pub struct TimedAnimation(Object<ffi::AdwTimedAnimation, ffi::AdwTimedAnimationClass>) @extends Animation;

    match fn {
        type_ => || ffi::adw_timed_animation_get_type(),
    }
}

impl TimedAnimation {
    #[doc(alias = "adw_timed_animation_new")]
    pub fn new<P: IsA<gtk::Widget>, Q: IsA<AnimationTarget>>(
        widget: &P,
        from: f64,
        to: f64,
        duration: u32,
        target: &Q,
    ) -> TimedAnimation {
        skip_assert_initialized!();
        unsafe {
            Animation::from_glib_none(ffi::adw_timed_animation_new(
                widget.as_ref().to_glib_none().0,
                from,
                to,
                duration,
                target.as_ref().to_glib_full(),
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TimedAnimation`] objects.
    ///
    /// This method returns an instance of [`TimedAnimationBuilder`] which can be used to create [`TimedAnimation`] objects.
    pub fn builder() -> TimedAnimationBuilder {
        TimedAnimationBuilder::default()
    }

    #[doc(alias = "adw_timed_animation_get_alternate")]
    #[doc(alias = "get_alternate")]
    pub fn is_alternate(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_timed_animation_get_alternate(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_timed_animation_get_duration")]
    #[doc(alias = "get_duration")]
    pub fn duration(&self) -> u32 {
        unsafe { ffi::adw_timed_animation_get_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_timed_animation_get_easing")]
    #[doc(alias = "get_easing")]
    pub fn easing(&self) -> Easing {
        unsafe { from_glib(ffi::adw_timed_animation_get_easing(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_timed_animation_get_repeat_count")]
    #[doc(alias = "get_repeat_count")]
    pub fn repeat_count(&self) -> u32 {
        unsafe { ffi::adw_timed_animation_get_repeat_count(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_timed_animation_get_reverse")]
    #[doc(alias = "get_reverse")]
    pub fn is_reverse(&self) -> bool {
        unsafe { from_glib(ffi::adw_timed_animation_get_reverse(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_timed_animation_get_value_from")]
    #[doc(alias = "get_value_from")]
    pub fn value_from(&self) -> f64 {
        unsafe { ffi::adw_timed_animation_get_value_from(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_timed_animation_get_value_to")]
    #[doc(alias = "get_value_to")]
    pub fn value_to(&self) -> f64 {
        unsafe { ffi::adw_timed_animation_get_value_to(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_timed_animation_set_alternate")]
    pub fn set_alternate(&self, alternate: bool) {
        unsafe {
            ffi::adw_timed_animation_set_alternate(self.to_glib_none().0, alternate.into_glib());
        }
    }

    #[doc(alias = "adw_timed_animation_set_duration")]
    pub fn set_duration(&self, duration: u32) {
        unsafe {
            ffi::adw_timed_animation_set_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "adw_timed_animation_set_easing")]
    pub fn set_easing(&self, easing: Easing) {
        unsafe {
            ffi::adw_timed_animation_set_easing(self.to_glib_none().0, easing.into_glib());
        }
    }

    #[doc(alias = "adw_timed_animation_set_repeat_count")]
    pub fn set_repeat_count(&self, repeat_count: u32) {
        unsafe {
            ffi::adw_timed_animation_set_repeat_count(self.to_glib_none().0, repeat_count);
        }
    }

    #[doc(alias = "adw_timed_animation_set_reverse")]
    pub fn set_reverse(&self, reverse: bool) {
        unsafe {
            ffi::adw_timed_animation_set_reverse(self.to_glib_none().0, reverse.into_glib());
        }
    }

    #[doc(alias = "adw_timed_animation_set_value_from")]
    pub fn set_value_from(&self, value: f64) {
        unsafe {
            ffi::adw_timed_animation_set_value_from(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "adw_timed_animation_set_value_to")]
    pub fn set_value_to(&self, value: f64) {
        unsafe {
            ffi::adw_timed_animation_set_value_to(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "alternate")]
    pub fn connect_alternate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_alternate_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::alternate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_alternate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "duration")]
    pub fn connect_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_duration_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "easing")]
    pub fn connect_easing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_easing_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::easing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_easing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "repeat-count")]
    pub fn connect_repeat_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_repeat_count_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::repeat-count\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_repeat_count_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reverse")]
    pub fn connect_reverse_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reverse_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reverse\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reverse_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-from")]
    pub fn connect_value_from_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_from_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::value-from\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_value_from_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-to")]
    pub fn connect_value_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_to_trampoline<F: Fn(&TimedAnimation) + 'static>(
            this: *mut ffi::AdwTimedAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::value-to\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_value_to_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TimedAnimation`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct TimedAnimationBuilder {
    alternate: Option<bool>,
    duration: Option<u32>,
    easing: Option<Easing>,
    repeat_count: Option<u32>,
    reverse: Option<bool>,
    value_from: Option<f64>,
    value_to: Option<f64>,
    target: Option<AnimationTarget>,
    widget: Option<gtk::Widget>,
}

impl TimedAnimationBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TimedAnimationBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TimedAnimation`].
    pub fn build(self) -> TimedAnimation {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref alternate) = self.alternate {
            properties.push(("alternate", alternate));
        }
        if let Some(ref duration) = self.duration {
            properties.push(("duration", duration));
        }
        if let Some(ref easing) = self.easing {
            properties.push(("easing", easing));
        }
        if let Some(ref repeat_count) = self.repeat_count {
            properties.push(("repeat-count", repeat_count));
        }
        if let Some(ref reverse) = self.reverse {
            properties.push(("reverse", reverse));
        }
        if let Some(ref value_from) = self.value_from {
            properties.push(("value-from", value_from));
        }
        if let Some(ref value_to) = self.value_to {
            properties.push(("value-to", value_to));
        }
        if let Some(ref target) = self.target {
            properties.push(("target", target));
        }
        if let Some(ref widget) = self.widget {
            properties.push(("widget", widget));
        }
        glib::Object::new::<TimedAnimation>(&properties)
            .expect("Failed to create an instance of TimedAnimation")
    }

    pub fn alternate(mut self, alternate: bool) -> Self {
        self.alternate = Some(alternate);
        self
    }

    pub fn duration(mut self, duration: u32) -> Self {
        self.duration = Some(duration);
        self
    }

    pub fn easing(mut self, easing: Easing) -> Self {
        self.easing = Some(easing);
        self
    }

    pub fn repeat_count(mut self, repeat_count: u32) -> Self {
        self.repeat_count = Some(repeat_count);
        self
    }

    pub fn reverse(mut self, reverse: bool) -> Self {
        self.reverse = Some(reverse);
        self
    }

    pub fn value_from(mut self, value_from: f64) -> Self {
        self.value_from = Some(value_from);
        self
    }

    pub fn value_to(mut self, value_to: f64) -> Self {
        self.value_to = Some(value_to);
        self
    }

    pub fn target<P: IsA<AnimationTarget>>(mut self, target: &P) -> Self {
        self.target = Some(target.clone().upcast());
        self
    }

    pub fn widget<P: IsA<gtk::Widget>>(mut self, widget: &P) -> Self {
        self.widget = Some(widget.clone().upcast());
        self
    }
}

impl fmt::Display for TimedAnimation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TimedAnimation")
    }
}
