// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::LeafletPage;
use crate::LeafletTransitionType;
use crate::NavigationDirection;
use crate::Swipeable;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "AdwLeaflet")]
    pub struct Leaflet(Object<ffi::AdwLeaflet, ffi::AdwLeafletClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, Swipeable, gtk::Orientable;

    match fn {
        type_ => || ffi::adw_leaflet_get_type(),
    }
}

impl Leaflet {
    #[doc(alias = "adw_leaflet_new")]
    pub fn new() -> Leaflet {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_leaflet_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Leaflet`] objects.
    ///
    /// This method returns an instance of [`LeafletBuilder`] which can be used to create [`Leaflet`] objects.
    pub fn builder() -> LeafletBuilder {
        LeafletBuilder::default()
    }

    #[doc(alias = "adw_leaflet_append")]
    pub fn append<P: IsA<gtk::Widget>>(&self, child: &P) -> Option<LeafletPage> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_append(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_adjacent_child")]
    #[doc(alias = "get_adjacent_child")]
    pub fn adjacent_child(&self, direction: NavigationDirection) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_get_adjacent_child(
                self.to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_can_swipe_back")]
    #[doc(alias = "get_can_swipe_back")]
    pub fn can_swipe_back(&self) -> bool {
        unsafe { from_glib(ffi::adw_leaflet_get_can_swipe_back(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_can_swipe_forward")]
    #[doc(alias = "get_can_swipe_forward")]
    pub fn can_swipe_forward(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_leaflet_get_can_swipe_forward(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_can_unfold")]
    #[doc(alias = "get_can_unfold")]
    pub fn can_unfold(&self) -> bool {
        unsafe { from_glib(ffi::adw_leaflet_get_can_unfold(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_child_by_name")]
    #[doc(alias = "get_child_by_name")]
    pub fn child_by_name(&self, name: &str) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_get_child_by_name(
                self.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_child_transition_duration")]
    #[doc(alias = "get_child_transition_duration")]
    pub fn child_transition_duration(&self) -> u32 {
        unsafe { ffi::adw_leaflet_get_child_transition_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_leaflet_get_child_transition_running")]
    #[doc(alias = "get_child_transition_running")]
    pub fn is_child_transition_running(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_leaflet_get_child_transition_running(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_folded")]
    #[doc(alias = "get_folded")]
    pub fn is_folded(&self) -> bool {
        unsafe { from_glib(ffi::adw_leaflet_get_folded(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_homogeneous")]
    #[doc(alias = "get_homogeneous")]
    pub fn is_homogeneous(&self, folded: bool, orientation: gtk::Orientation) -> bool {
        unsafe {
            from_glib(ffi::adw_leaflet_get_homogeneous(
                self.to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_interpolate_size")]
    #[doc(alias = "get_interpolate_size")]
    pub fn is_interpolate_size(&self) -> bool {
        unsafe { from_glib(ffi::adw_leaflet_get_interpolate_size(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_mode_transition_duration")]
    #[doc(alias = "get_mode_transition_duration")]
    pub fn mode_transition_duration(&self) -> u32 {
        unsafe { ffi::adw_leaflet_get_mode_transition_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_leaflet_get_page")]
    #[doc(alias = "get_page")]
    pub fn page<P: IsA<gtk::Widget>>(&self, child: &P) -> Option<LeafletPage> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_get_page(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_get_pages")]
    #[doc(alias = "get_pages")]
    pub fn pages(&self) -> Option<gtk::SelectionModel> {
        unsafe { from_glib_full(ffi::adw_leaflet_get_pages(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_transition_type")]
    #[doc(alias = "get_transition_type")]
    pub fn transition_type(&self) -> LeafletTransitionType {
        unsafe { from_glib(ffi::adw_leaflet_get_transition_type(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_visible_child")]
    #[doc(alias = "get_visible_child")]
    pub fn visible_child(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::adw_leaflet_get_visible_child(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_leaflet_get_visible_child_name")]
    #[doc(alias = "get_visible_child_name")]
    pub fn visible_child_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_get_visible_child_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_insert_child_after")]
    pub fn insert_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    ) -> Option<LeafletPage> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_insert_child_after(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_navigate")]
    pub fn navigate(&self, direction: NavigationDirection) -> bool {
        unsafe {
            from_glib(ffi::adw_leaflet_navigate(
                self.to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[doc(alias = "adw_leaflet_prepend")]
    pub fn prepend<P: IsA<gtk::Widget>>(&self, child: &P) -> Option<LeafletPage> {
        unsafe {
            from_glib_none(ffi::adw_leaflet_prepend(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_leaflet_remove")]
    pub fn remove<P: IsA<gtk::Widget>>(&self, child: &P) {
        unsafe {
            ffi::adw_leaflet_remove(self.to_glib_none().0, child.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "adw_leaflet_reorder_child_after")]
    pub fn reorder_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    ) {
        unsafe {
            ffi::adw_leaflet_reorder_child_after(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_leaflet_set_can_swipe_back")]
    pub fn set_can_swipe_back(&self, can_swipe_back: bool) {
        unsafe {
            ffi::adw_leaflet_set_can_swipe_back(self.to_glib_none().0, can_swipe_back.into_glib());
        }
    }

    #[doc(alias = "adw_leaflet_set_can_swipe_forward")]
    pub fn set_can_swipe_forward(&self, can_swipe_forward: bool) {
        unsafe {
            ffi::adw_leaflet_set_can_swipe_forward(
                self.to_glib_none().0,
                can_swipe_forward.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_leaflet_set_can_unfold")]
    pub fn set_can_unfold(&self, can_unfold: bool) {
        unsafe {
            ffi::adw_leaflet_set_can_unfold(self.to_glib_none().0, can_unfold.into_glib());
        }
    }

    #[doc(alias = "adw_leaflet_set_child_transition_duration")]
    pub fn set_child_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::adw_leaflet_set_child_transition_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "adw_leaflet_set_homogeneous")]
    pub fn set_homogeneous(&self, folded: bool, orientation: gtk::Orientation, homogeneous: bool) {
        unsafe {
            ffi::adw_leaflet_set_homogeneous(
                self.to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
                homogeneous.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_leaflet_set_interpolate_size")]
    pub fn set_interpolate_size(&self, interpolate_size: bool) {
        unsafe {
            ffi::adw_leaflet_set_interpolate_size(
                self.to_glib_none().0,
                interpolate_size.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_leaflet_set_mode_transition_duration")]
    pub fn set_mode_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::adw_leaflet_set_mode_transition_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "adw_leaflet_set_transition_type")]
    pub fn set_transition_type(&self, transition: LeafletTransitionType) {
        unsafe {
            ffi::adw_leaflet_set_transition_type(self.to_glib_none().0, transition.into_glib());
        }
    }

    #[doc(alias = "adw_leaflet_set_visible_child")]
    pub fn set_visible_child<P: IsA<gtk::Widget>>(&self, visible_child: &P) {
        unsafe {
            ffi::adw_leaflet_set_visible_child(
                self.to_glib_none().0,
                visible_child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_leaflet_set_visible_child_name")]
    pub fn set_visible_child_name(&self, name: &str) {
        unsafe {
            ffi::adw_leaflet_set_visible_child_name(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "hhomogeneous-folded")]
    pub fn is_hhomogeneous_folded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-folded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `hhomogeneous-folded` getter")
        }
    }

    #[doc(alias = "hhomogeneous-folded")]
    pub fn set_hhomogeneous_folded(&self, hhomogeneous_folded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-folded\0".as_ptr() as *const _,
                hhomogeneous_folded.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    pub fn is_hhomogeneous_unfolded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-unfolded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `hhomogeneous-unfolded` getter")
        }
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    pub fn set_hhomogeneous_unfolded(&self, hhomogeneous_unfolded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-unfolded\0".as_ptr() as *const _,
                hhomogeneous_unfolded.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "vhomogeneous-folded")]
    pub fn is_vhomogeneous_folded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-folded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `vhomogeneous-folded` getter")
        }
    }

    #[doc(alias = "vhomogeneous-folded")]
    pub fn set_vhomogeneous_folded(&self, vhomogeneous_folded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-folded\0".as_ptr() as *const _,
                vhomogeneous_folded.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    pub fn is_vhomogeneous_unfolded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-unfolded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `vhomogeneous-unfolded` getter")
        }
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    pub fn set_vhomogeneous_unfolded(&self, vhomogeneous_unfolded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-unfolded\0".as_ptr() as *const _,
                vhomogeneous_unfolded.to_value().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "can-swipe-back")]
    pub fn connect_can_swipe_back_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_back_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-back\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_back_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "can-swipe-forward")]
    pub fn connect_can_swipe_forward_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_forward_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-forward\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_forward_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "can-unfold")]
    pub fn connect_can_unfold_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_unfold_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-unfold\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_unfold_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "child-transition-duration")]
    pub fn connect_child_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_duration_trampoline<
            F: Fn(&Leaflet) + 'static,
        >(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "child-transition-running")]
    pub fn connect_child_transition_running_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_running_trampoline<
            F: Fn(&Leaflet) + 'static,
        >(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-running\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_running_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "folded")]
    pub fn connect_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_folded_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_folded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hhomogeneous-folded")]
    pub fn connect_hhomogeneous_folded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_folded_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_folded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    pub fn connect_hhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_unfolded_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_unfolded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "interpolate-size")]
    pub fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_interpolate_size_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::interpolate-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_interpolate_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mode-transition-duration")]
    pub fn connect_mode_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_mode_transition_duration_trampoline<
            F: Fn(&Leaflet) + 'static,
        >(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mode-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mode_transition_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pages")]
    pub fn connect_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pages_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pages\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pages_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "transition-type")]
    pub fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_type_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vhomogeneous-folded")]
    pub fn connect_vhomogeneous_folded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_folded_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_folded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    pub fn connect_vhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_unfolded_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_unfolded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visible-child")]
    pub fn connect_visible_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visible-child-name")]
    pub fn connect_visible_child_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_name_trampoline<F: Fn(&Leaflet) + 'static>(
            this: *mut ffi::AdwLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Leaflet {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Leaflet`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct LeafletBuilder {
    can_swipe_back: Option<bool>,
    can_swipe_forward: Option<bool>,
    can_unfold: Option<bool>,
    child_transition_duration: Option<u32>,
    hhomogeneous_folded: Option<bool>,
    hhomogeneous_unfolded: Option<bool>,
    interpolate_size: Option<bool>,
    mode_transition_duration: Option<u32>,
    transition_type: Option<LeafletTransitionType>,
    vhomogeneous_folded: Option<bool>,
    vhomogeneous_unfolded: Option<bool>,
    visible_child: Option<gtk::Widget>,
    visible_child_name: Option<String>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<gtk::Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<gtk::LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<gtk::Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<gtk::AccessibleRole>,
    orientation: Option<gtk::Orientation>,
}

impl LeafletBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`LeafletBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Leaflet`].
    pub fn build(self) -> Leaflet {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref can_swipe_back) = self.can_swipe_back {
            properties.push(("can-swipe-back", can_swipe_back));
        }
        if let Some(ref can_swipe_forward) = self.can_swipe_forward {
            properties.push(("can-swipe-forward", can_swipe_forward));
        }
        if let Some(ref can_unfold) = self.can_unfold {
            properties.push(("can-unfold", can_unfold));
        }
        if let Some(ref child_transition_duration) = self.child_transition_duration {
            properties.push(("child-transition-duration", child_transition_duration));
        }
        if let Some(ref hhomogeneous_folded) = self.hhomogeneous_folded {
            properties.push(("hhomogeneous-folded", hhomogeneous_folded));
        }
        if let Some(ref hhomogeneous_unfolded) = self.hhomogeneous_unfolded {
            properties.push(("hhomogeneous-unfolded", hhomogeneous_unfolded));
        }
        if let Some(ref interpolate_size) = self.interpolate_size {
            properties.push(("interpolate-size", interpolate_size));
        }
        if let Some(ref mode_transition_duration) = self.mode_transition_duration {
            properties.push(("mode-transition-duration", mode_transition_duration));
        }
        if let Some(ref transition_type) = self.transition_type {
            properties.push(("transition-type", transition_type));
        }
        if let Some(ref vhomogeneous_folded) = self.vhomogeneous_folded {
            properties.push(("vhomogeneous-folded", vhomogeneous_folded));
        }
        if let Some(ref vhomogeneous_unfolded) = self.vhomogeneous_unfolded {
            properties.push(("vhomogeneous-unfolded", vhomogeneous_unfolded));
        }
        if let Some(ref visible_child) = self.visible_child {
            properties.push(("visible-child", visible_child));
        }
        if let Some(ref visible_child_name) = self.visible_child_name {
            properties.push(("visible-child-name", visible_child_name));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<Leaflet>(&properties).expect("Failed to create an instance of Leaflet")
    }

    pub fn can_swipe_back(mut self, can_swipe_back: bool) -> Self {
        self.can_swipe_back = Some(can_swipe_back);
        self
    }

    pub fn can_swipe_forward(mut self, can_swipe_forward: bool) -> Self {
        self.can_swipe_forward = Some(can_swipe_forward);
        self
    }

    pub fn can_unfold(mut self, can_unfold: bool) -> Self {
        self.can_unfold = Some(can_unfold);
        self
    }

    pub fn child_transition_duration(mut self, child_transition_duration: u32) -> Self {
        self.child_transition_duration = Some(child_transition_duration);
        self
    }

    pub fn hhomogeneous_folded(mut self, hhomogeneous_folded: bool) -> Self {
        self.hhomogeneous_folded = Some(hhomogeneous_folded);
        self
    }

    pub fn hhomogeneous_unfolded(mut self, hhomogeneous_unfolded: bool) -> Self {
        self.hhomogeneous_unfolded = Some(hhomogeneous_unfolded);
        self
    }

    pub fn interpolate_size(mut self, interpolate_size: bool) -> Self {
        self.interpolate_size = Some(interpolate_size);
        self
    }

    pub fn mode_transition_duration(mut self, mode_transition_duration: u32) -> Self {
        self.mode_transition_duration = Some(mode_transition_duration);
        self
    }

    pub fn transition_type(mut self, transition_type: LeafletTransitionType) -> Self {
        self.transition_type = Some(transition_type);
        self
    }

    pub fn vhomogeneous_folded(mut self, vhomogeneous_folded: bool) -> Self {
        self.vhomogeneous_folded = Some(vhomogeneous_folded);
        self
    }

    pub fn vhomogeneous_unfolded(mut self, vhomogeneous_unfolded: bool) -> Self {
        self.vhomogeneous_unfolded = Some(vhomogeneous_unfolded);
        self
    }

    pub fn visible_child<P: IsA<gtk::Widget>>(mut self, visible_child: &P) -> Self {
        self.visible_child = Some(visible_child.clone().upcast());
        self
    }

    pub fn visible_child_name(mut self, visible_child_name: &str) -> Self {
        self.visible_child_name = Some(visible_child_name.to_string());
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager<P: IsA<gtk::LayoutManager>>(mut self, layout_manager: &P) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: gtk::Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: gtk::AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

impl fmt::Display for Leaflet {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Leaflet")
    }
}
