//! Here you'll find common used constants from several mathematical fields.
/// π² / 6.
pub const PISQRDIV6: f64 = 1.6449340668482264364724151666460251892189499012067984377355582293;
/// 180 / π.
pub const RADDEGRATE: f64 = 57.295779513082320876798154814105170332405472466564321549160243861;
/// π / 180.
pub const DEGRADRATE: f64 = 0.0174532925199432957692369076848861271344287188854172545609719144;
/// π.
pub const PI: f64 = 3.1415926535897932384626433832795028841971693993751058209749445923;
/// √π.
pub const SQRTPI: f64 = 1.7724538509055160272981674833411451827975494561223871282138077898;
/// τ.
pub const TAU: f64 = 6.2831853071795864769252867665590057683943387987502116419498891846;
/// π / 2.
pub const HALFPI: f64 = 1.5707963267948966192313216916397514420985846996875529104874722961;
/// Eulers number.
pub const E: f64 = 2.7182818284590452353602874713526624977572470936999595749669676277;
/// The square root of Eulers number.
pub const SQRTE: f64 = 1.6487212707001281468486507878141635716537761007101480115750793116;
/// √2.
pub const SQRT2: f64 = 1.4142135623730950488016887242096980785696718753769480731766797379;
/// √3.
pub const SQRT3: f64 = 1.7320508075688772935274463415058723669428052538103806280558069794;
/// √5.
pub const SQRT5: f64 = 2.2360679774997896964091736687312762354406183596115257242708972454;
/// The golden ratio φ.
pub const GOLDENRATIO: f64 = 1.6180339887498948482045868343656381177203091798057628621354486227;
/// The Euler-Mascheroni constant, γ.
pub const EULERMASCHERONI: f64 = 0.5772156649015328606065120900824024310421593359399235988057672348;
/// The Twin Primes Constant.
pub const TWINPRIMES: f64 = 0.6601618158468695739278121100145557784326233602847334133194484233;
/// ln(2).
pub const LN2: f64 = 0.6931471805599453094172321214581765680755001343602552541206800094;
/// ln(3).
pub const LN3: f64 = 1.0986122886681096913952452369225257046474905578227494517346943336;
/// ln(5).
pub const LN5: f64 = 1.6094379124341003746007593332261876395256013542685177219126478914;
/// ζ(3).
pub const ZETA3: f64 = 1.2020569031595942853997381615114499907649862923404988817922715553;
/// ∛2.
pub const CUBEROOT2: f64 = 1.2599210498948731647672106072782283505702514647015079800819751121;
/// ∛3.
pub const CUBEROOT3: f64 = 1.4422495703074083823216383107801095883918692534993505775464161945;
/// the speed of light, c.
pub const LIGHTSPEED: f64 = 299_792_458.0;
/// Gravity of Earth, denoted as g
pub const EARTHGRAVITY: f64 = 9.80665;
/// Wallis Constant.
pub const WALLISCONSTANT: f64 = 2.0945514815423265914823865405793029638573061056282391803041285290;
/// The Laplace limit, λ.
pub const LAPLACELIMIT: f64 = 0.6627434193491815809747420971092529070562335491150224175203925349;
/// Gauss's constant.
pub const GAUSSCONSTANT: f64 = 0.8346268416740731862814297327990468089939930134903470024498273701;
/// Cahen's constant, C.
pub const CAHENSCONSTANT: f64 = 0.6434105462883380261822543077575647632865878602682395059870309203;
/// The parabolic constant, P₂.
pub const P2: f64 = 2.2955871493926380740342980491894903875978322036385834839299753466;
/// The Dottie number.
pub const DOTTIENUMBER: f64 = 0.7390851332151606416553120876738734040134117589007574649656806357;
/// The Meissel-Mertens constant.
pub const MEISSELMERTENS: f64 = 0.2614972128476427837554268386086958590515666482611992061920642139;
/// Gelfond's constant e^π.
pub const ETOPI: f64 = 23.140692632779269005729086367948547380266106242600211993445046409;
/// The golden angle.
pub const GOLDENANGLE: f64 = 2.3999632297286533222315555066336138531249990110581150429351127507;
/// The area of the Mandelbrot fractal.
pub const MANDELBROTAREA: f64 = 1.5065918849;
/// The Gieseking constant.
pub const GIESEKINGCONSTANT: f64 = 1.0149416064096536250212025542745202859416893075302997920174891067;
/// The Bloch-Landau constant.
pub const BLOCHLANDAU: f64 = 0.5432589653429767069527282953006132311388632937583569889557325691;
/// The Golomb-Dickman constant.
pub const GOLOMBDICKMAN: f64 = 0.6243299885435508709929363831008372441796426201805292869735519024;
/// The Feller-Tornier constant.
pub const FELLERTORNIER: f64 = 0.6613170494696223352897658462741185332854752898329;
/// The 2^(√2).
pub const TWOTOSQRT2: f64 = 2.6651441426902251886502972498731398482742113137146594928359795933;
/// The Khinchin's constant.
pub const KHINCHINSCONSTANT: f64 = 2.6854520010653064453097148354817956938203822939944629530511523455;
/// Mill's constant.
pub const MILLSCONSTANT: f64 = 1.3063778838630806904686144926026057129167845851567136443680537599;
/// π / ln(2).
pub const PIOVERLN2: f64 = 4.5323601418271938096276829457166668101718614677237955841860165479;
/// Loch's constant.
pub const LOCHSCONSTANT: f64 = 0.9702701143920339257402560192100108337812847047851612866103505299;
/// Niven's constant.
pub const NIVENSCONSTANT: f64 = 1.7052111401053677642885514534345081607620276516534690999942849065;
/// Reciprocal Fibonacci constant.
pub const RECIPFIBCONST: f64 = 3.3598856662431775531720113029189271796889051337319684864955538153;
/// Backhouse's constant.
pub const BACKHOUSECONST: f64 = 1.4560749485826896713995953511165435576531783748471315402707024374;
/// The MRB constant.
pub const MRBCONSTANT: f64 = 0.1878596424620671202485179340542732300559030949001387861720046840;
/// Somos' quadratic recurrence constant.
pub const QUADRECURR: f64 = 1.6616879496335941212958189227499507499644186350250682081897111680;
/// The plastic number.
pub const PLASTICNUMBER: f64 = 1.3247179572447460259609088544780973407344040569017333645340150503;