//! Here you'll find common used constants from several mathematical fields.
/// The mathematical constant π² / 6.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of π² / 6. Rounded.
pub const PISQRDIV6: f64 = 1.644934066848226;
/// The mathematical constant 180 / π.
///
/// # Returns
/// a f64 containing the first 15+2 decimal places of 180 / π. Rounded.
pub const RADDEGRATE: f64 = 57.295779513082321;
/// The mathematical constant π / 180.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of π / 180. Rounded.
pub const DEGRADRATE: f64 = 0.017453292519943;
/// The mathematical constant π.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of π. Rounded.
pub const PI: f64 = 3.141592653589793;
/// The mathematical constant √π.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of √π. Rounded.
pub const SQRTPI: f64 = 1.77245385090552;
/// The mathematical constant τ.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of τ. Rounded.
pub const TAU: f64 = 6.283185307179586;
/// π / 2.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of π / 2. Rounded.
pub const HALFPI: f64 = 1.570796326794897;
/// Eulers number.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of Eulers number. Rounded.
pub const E: f64 = 2.718281828459045;
/// The square root of Eulers number.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of √e. Rounded.
pub const SQRTE: f64 = 1.648721270700128;
/// √2.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of √2. Rounded.
pub const SQRT2: f64 = 1.414213562373095;
/// √3.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of √3. Rounded.
pub const SQRT3: f64 = 1.732050807568877;
/// √5.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of √5. Rounded.
pub const SQRT5: f64 = 2.236067977499790;
/// The golden ratio φ.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of the golden ratio. Rounded.
pub const GOLDENRATIO: f64 = 1.618033988749895;
/// The Euler-Mascheroni constant, γ.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of γ. Rounded.
pub const EULERMASCHERONI: f64 = 0.577215664901532;
/// The Twin Primes Constant.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of the Twin Primes Constant. Rounded.
pub const TWINPRIMES: f64 = 0.660161815846869;
/// ln(2).
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ln(2). Rounded.
pub const LN2: f64 = 0.693147180559945;
/// ln(3).
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ln(3). Rounded.
pub const LN3: f64 = 1.098612288668109;
/// ln(5).
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ln(5). Rounded.
pub const LN5: f64 = 1.609437912434100;
/// ζ(3).
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ζ(3). Rounded.
pub const ZETA3: f64 = 1.202056903159594;
/// ∛2.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ∛2. Rounded.
pub const CUBEROOT2: f64 = 1.259921049894873;
/// ∛3.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of ∛3. Rounded.
pub const CUBEROOT3: f64 = 1.442249570307408;
/// the speed of light, c.
///
/// # Returns
/// a f64 containing the decimal places of c. Rounded.
pub const LIGHTSPEED: f64 = 299_792_458.0;
/// Gravity of Earth, denoted as g
///
/// # Returns
/// a f64 containing the decimal places of the total average of g. Rounded.
pub const EARTHGRAVITY: f64 = 9.80665;
/// Wallis Constant.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of the Wallis Constant. Rounded.
pub const WALLISCONSTANT: f64 = 2.094551481542327;
/// The Laplace limit, λ.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of λ. Rounded.
pub const LAPLACELIMIT: f64 = 0.662743419349182;
/// Gauss's constant.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of Gauss's constant. Rounded.
pub const GAUSSCONSTANT: f64 = 0.834626841674073;
/// Cahen's constant, C.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of C. Rounded.
pub const CAHENSCONSTANT: f64 = 0.643410546288338;
/// The parabolic constant.
///
/// # Returns
/// a f64 containing the first 15+1 decimal places of the parabolic constant. Rounded.
pub const P2: f64 = 2.295587149392638;