//! Here you'll find common used constants from several mathematical fields.
/// The mathematical constant π² / 6.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of π² / 6. Rounded.
pub const PISQRDIV6:   f64 = 1.644934066848226;
/// The mathematical constant 180 / π.
///
/// # Returns
/// a f64 containing the first 16+2 decimal places of 180 / π. Rounded.
pub const RADDEGRATE:  f64 = 57.295779513082321;
/// The mathematical constant π / 180.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of π / 180. Rounded.
pub const DEGRADRATE:  f64 = 0.017453292519943;
/// The mathematical constant π.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of π. Rounded.
pub const PI:          f64 = 3.141592653589793;
/// The mathematical constant τ.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of τ. Rounded.
pub const TAU:         f64 = 6.283185307179586;
/// π / 2.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of π / 2. Rounded.
pub const HALFPI:      f64 = 1.570796326794897;
/// Eulers number.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Eulers number. Rounded.
pub const E:           f64 = 2.718281828459045;
/// √2.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of √2. Rounded.
pub const SQRT2:       f64 = 1.414213562373095;
/// √3.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of √3. Rounded.
pub const SQRT3:       f64 = 1.732050807568877;
/// √5.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of √5. Rounded.
pub const SQRT5:       f64 = 2.236067977499790;
/// The golden ratio φ.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of the golden ratio. Rounded.
pub const GOLDENRATIO: f64 = 1.618033988749895;