//! Here you'll find common used constants from several mathematical fields.
/// The mathematical constant Pi squared over 6.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Pi squared over 6. Rounded.
pub const PISQRDIV6:   f64 = 1.644934066848226;
/// The mathematical constant 180 / Pi.
///
/// # Returns
/// a f64 containing the first 16+2 decimal places of 180 / Pi. Rounded.
pub const RADDEGRATE:  f64 = 57.295779513082321;
/// The mathematical constant Pi / 180.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Pi / 180. Rounded.
pub const DEGRADRATE:  f64 = 0.017453292519943;
/// The mathematical constant Pi.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Pi. Rounded.
pub const PI:          f64 = 3.141592653589793;
/// The mathematical constant Tau.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Tau. Rounded.
pub const TAU:         f64 = 6.283185307179586;
/// Half Pi.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of half pi. Rounded.
pub const HALFPI:      f64 = 1.570796326794897;
/// Eulers number.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of Eulers number. Rounded.
pub const E:           f64 = 2.718281828459045;
/// The square root of 2.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of the square root of 2. Rounded.
pub const SQRT2:       f64 = 1.414213562373095;
/// The square root of 3.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of the square root of 3. Rounded.
pub const SQRT3:       f64 = 1.732050807568877;
/// The square root of 5.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of the square root of 5. Rounded.
pub const SQRT5:       f64 = 2.236067977499790;
/// The golden Ratio.
///
/// # Returns
/// a f64 containing the first 16+1 decimal places of the golden ratio. Rounded.
pub const GOLDENRATIO: f64 = 1.618033988749895;