use serde::{Deserialize, Serialize};
use serde_repr::{Deserialize_repr, Serialize_repr};

/*
Task is sufficiently complicated enough to warrant having its own space, whereas the others are
relatively simple.
*/
pub mod task;

#[derive(Debug, Default, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct DueDateTime {
    /** Human defined date in arbitrary format. */
    pub string: String,
    /** Date in format `YYYY-MM-DD` corrected to user's time zone. */
    pub date: String,
    pub recurring: bool,
    /** Only returned if exact due time set (i.e. it's not a whole-day task), in UTC. */
    pub datetime: Option<String>,
    /**
    Only returned if exact due time set, user's time zone definition either in
    tzdata-compatible format ("Europe/Berlin") or as a string specifying east of UTC offset
    as "UTC±HH:MM" (i.e. "UTC-01:00").
    */
    pub timezone: Option<String>,
    /*
    In case DueDateTime.string is not in English, a two character language code can be provided.
    pub lang: Option<[char; 2]>,
    */
}

#[derive(Debug, Default)]
pub struct Project {
    pub id: usize,
    pub name: String,
    pub color: Color,
    pub parent_id: Option<usize>,
    pub order: usize,
    pub favorite: bool,
    /** Whether the project is Inbox (read-only, true or otherwise this property is not sent). */
    pub inbox_project: Option<bool>,
    pub url: String,
    // IGNORED: comment_count; shared; team_inbox; sync_id
}

#[derive(Debug, Default)]
pub struct Label {
    pub id: usize,
    pub name: String,
    pub color: Color,
    pub favorite: bool,
}

/**
A numeric ID representing the color of the project icon; refer to the id column in the colors guide
for more info; https://developer.todoist.com/guides/#colors.
*/
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Serialize_repr, Deserialize_repr)]
#[repr(usize)]
pub enum Color {
    BerryRed = 30,
    Red = 31,
    Orange = 32,
    Yellow = 33,
    OliveGreen = 34,
    LimeGreen = 35,
    Green = 36,
    MintGreen = 37,
    Teal = 38,
    SkyBlue = 39,
    LightBlue = 40,
    Blue = 41,
    Grape = 42,
    Violet = 43,
    Lavender = 44,
    Magenta = 45,
    Salmon = 46,
    Charcoal = 47,
    Grey = 48,
    Taupe = 49,
}

impl Default for Color {
    fn default() -> Self {
        Self::Charcoal
    }
}
