pub mod models;

pub const BASE_URL: &'static str = "https://api.todoist.com/rest/v1";

pub mod task {
    use std::borrow::Cow;

    use korero::http::{Method, Query, QueryParams, Strategy};
    use serde::{Deserialize, Serialize};

    use crate::models::task::Task;

    #[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
    pub struct Get {
        pub id: usize,
        pub params: GetQueryParams,
    }

    impl Get {
        pub fn new(id: usize) -> Self {
            Self {
                id,
                params: GetQueryParams::default(),
            }
        }
    }

    /** In order of precedence when processed by Todoist. */
    #[derive(Debug, Default, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
    pub struct GetQueryParams {
        #[serde(skip_serializing_if = "Option::is_none")]
        filter: Option<String>,
        #[serde(skip_serializing_if = "Option::is_none")]
        project_id: Option<usize>,
        #[serde(skip_serializing_if = "Option::is_none")]
        label_id: Option<usize>,
    }

    impl GetQueryParams {
        /** Set the get query params's filter. */
        pub fn set_filter(&mut self, filter: Option<String>) -> &mut Self {
            self.filter = filter;
            self
        }

        /** Set the get query params's project id. */
        pub fn set_project_id(&mut self, project_id: Option<usize>) -> &mut Self {
            self.project_id = project_id;
            self
        }

        /** Set the get query params's label id. */
        pub fn set_label_id(&mut self, label_id: Option<usize>) -> &mut Self {
            self.label_id = label_id;
            self
        }
    }

    impl Query for Get {
        fn endpoint(&self) -> Cow<'static, str> {
            format!("{}/tasks/{}", super::BASE_URL, self.id).into()
        }

        fn params(&self) -> QueryParams {
            // turn self.params into a QueryParams obj
            todo!()
        }
    }

    impl Strategy for Get {
        type Type = Task;

        fn method(&self) -> Method {
            Method::GET
        }

        fn execute(&self) -> Self::Type {
            todo!()
        }
    }
}

#[cfg(test)]
mod tests {}
