// This file is auto-generated by codegen/rust/visitor.rs

use crate::nodes::*;
use crate::Node;

/// Common trait for all visitors
///
/// ```rust
/// use lib_ruby_parser::{
///     nodes::{Class, Const},
///     traverse::visitor::{visit_class, Visitor},
///     Node,
/// };
///
/// struct ClassesCollector {
///     classes: Vec<String>,
/// }
///
/// impl Visitor for ClassesCollector {
///     fn on_class(&mut self, node: &Class) {
///         self.classes.push(fetch_const_name(&node.name));
///         visit_class(self, node);
///     }
/// }
///
/// fn fetch_const_name(name: &Node) -> String {
///     match name {
///         Node::Const(Const { name, .. }) => name.to_owned(),
///         other => panic!("Don't know how to fetch const name from {:?}", other),
///     }
/// }
///
/// use lib_ruby_parser::{Parser, ParserOptions, ParserResult};
/// let parser = Parser::new(
///     b"class A; class B; end; end".to_vec(),
///     ParserOptions::default(),
/// );
/// let ParserResult { ast, .. } = parser.do_parse();
/// let ast = ast.unwrap();
///
/// let mut collector = ClassesCollector { classes: vec![] };
/// collector.visit(&ast);
/// assert_eq!(
///     collector.classes,
///     vec![String::from("A"), String::from("B")]
/// );
/// ```
pub trait Visitor: Sized {
    /// Invoked by a `Visitor` on entering into `Alias` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_alias(node)` to continue traversing.
    fn on_alias(&mut self, node: &Alias) {
        visit_alias(self, node);
    }
    /// Invoked by a `Visitor` on entering into `And` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_and(node)` to continue traversing.
    fn on_and(&mut self, node: &And) {
        visit_and(self, node);
    }
    /// Invoked by a `Visitor` on entering into `AndAsgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_and_asgn(node)` to continue traversing.
    fn on_and_asgn(&mut self, node: &AndAsgn) {
        visit_and_asgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Arg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_arg(node)` to continue traversing.
    fn on_arg(&mut self, node: &Arg) {
        visit_arg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Args` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_args(node)` to continue traversing.
    fn on_args(&mut self, node: &Args) {
        visit_args(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Array` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_array(node)` to continue traversing.
    fn on_array(&mut self, node: &Array) {
        visit_array(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ArrayPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_array_pattern(node)` to continue traversing.
    fn on_array_pattern(&mut self, node: &ArrayPattern) {
        visit_array_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ArrayPatternWithTail` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_array_pattern_with_tail(node)` to continue traversing.
    fn on_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {
        visit_array_pattern_with_tail(self, node);
    }
    /// Invoked by a `Visitor` on entering into `BackRef` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_back_ref(node)` to continue traversing.
    fn on_back_ref(&mut self, node: &BackRef) {
        visit_back_ref(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Begin` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_begin(node)` to continue traversing.
    fn on_begin(&mut self, node: &Begin) {
        visit_begin(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Block` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_block(node)` to continue traversing.
    fn on_block(&mut self, node: &Block) {
        visit_block(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Blockarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_blockarg(node)` to continue traversing.
    fn on_blockarg(&mut self, node: &Blockarg) {
        visit_blockarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `BlockPass` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_block_pass(node)` to continue traversing.
    fn on_block_pass(&mut self, node: &BlockPass) {
        visit_block_pass(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Break` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_break(node)` to continue traversing.
    fn on_break(&mut self, node: &Break) {
        visit_break(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Case` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_case(node)` to continue traversing.
    fn on_case(&mut self, node: &Case) {
        visit_case(self, node);
    }
    /// Invoked by a `Visitor` on entering into `CaseMatch` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_case_match(node)` to continue traversing.
    fn on_case_match(&mut self, node: &CaseMatch) {
        visit_case_match(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Casgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_casgn(node)` to continue traversing.
    fn on_casgn(&mut self, node: &Casgn) {
        visit_casgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Cbase` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_cbase(node)` to continue traversing.
    fn on_cbase(&mut self, node: &Cbase) {
        visit_cbase(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Class` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_class(node)` to continue traversing.
    fn on_class(&mut self, node: &Class) {
        visit_class(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Complex` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_complex(node)` to continue traversing.
    fn on_complex(&mut self, node: &Complex) {
        visit_complex(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Const` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_const(node)` to continue traversing.
    fn on_const(&mut self, node: &Const) {
        visit_const(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ConstPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_const_pattern(node)` to continue traversing.
    fn on_const_pattern(&mut self, node: &ConstPattern) {
        visit_const_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `CSend` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_c_send(node)` to continue traversing.
    fn on_c_send(&mut self, node: &CSend) {
        visit_c_send(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Cvar` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_cvar(node)` to continue traversing.
    fn on_cvar(&mut self, node: &Cvar) {
        visit_cvar(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Cvasgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_cvasgn(node)` to continue traversing.
    fn on_cvasgn(&mut self, node: &Cvasgn) {
        visit_cvasgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Def` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_def(node)` to continue traversing.
    fn on_def(&mut self, node: &Def) {
        visit_def(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Defined` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_defined(node)` to continue traversing.
    fn on_defined(&mut self, node: &Defined) {
        visit_defined(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Defs` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_defs(node)` to continue traversing.
    fn on_defs(&mut self, node: &Defs) {
        visit_defs(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Dstr` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_dstr(node)` to continue traversing.
    fn on_dstr(&mut self, node: &Dstr) {
        visit_dstr(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Dsym` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_dsym(node)` to continue traversing.
    fn on_dsym(&mut self, node: &Dsym) {
        visit_dsym(self, node);
    }
    /// Invoked by a `Visitor` on entering into `EFlipFlop` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_e_flip_flop(node)` to continue traversing.
    fn on_e_flip_flop(&mut self, node: &EFlipFlop) {
        visit_e_flip_flop(self, node);
    }
    /// Invoked by a `Visitor` on entering into `EmptyElse` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_empty_else(node)` to continue traversing.
    fn on_empty_else(&mut self, node: &EmptyElse) {
        visit_empty_else(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Encoding` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_encoding(node)` to continue traversing.
    fn on_encoding(&mut self, node: &Encoding) {
        visit_encoding(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Ensure` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_ensure(node)` to continue traversing.
    fn on_ensure(&mut self, node: &Ensure) {
        visit_ensure(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Erange` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_erange(node)` to continue traversing.
    fn on_erange(&mut self, node: &Erange) {
        visit_erange(self, node);
    }
    /// Invoked by a `Visitor` on entering into `False` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_false(node)` to continue traversing.
    fn on_false(&mut self, node: &False) {
        visit_false(self, node);
    }
    /// Invoked by a `Visitor` on entering into `File` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_file(node)` to continue traversing.
    fn on_file(&mut self, node: &File) {
        visit_file(self, node);
    }
    /// Invoked by a `Visitor` on entering into `FindPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_find_pattern(node)` to continue traversing.
    fn on_find_pattern(&mut self, node: &FindPattern) {
        visit_find_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Float` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_float(node)` to continue traversing.
    fn on_float(&mut self, node: &Float) {
        visit_float(self, node);
    }
    /// Invoked by a `Visitor` on entering into `For` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_for(node)` to continue traversing.
    fn on_for(&mut self, node: &For) {
        visit_for(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ForwardArg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_forward_arg(node)` to continue traversing.
    fn on_forward_arg(&mut self, node: &ForwardArg) {
        visit_forward_arg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ForwardedArgs` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_forwarded_args(node)` to continue traversing.
    fn on_forwarded_args(&mut self, node: &ForwardedArgs) {
        visit_forwarded_args(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Gvar` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_gvar(node)` to continue traversing.
    fn on_gvar(&mut self, node: &Gvar) {
        visit_gvar(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Gvasgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_gvasgn(node)` to continue traversing.
    fn on_gvasgn(&mut self, node: &Gvasgn) {
        visit_gvasgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Hash` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_hash(node)` to continue traversing.
    fn on_hash(&mut self, node: &Hash) {
        visit_hash(self, node);
    }
    /// Invoked by a `Visitor` on entering into `HashPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_hash_pattern(node)` to continue traversing.
    fn on_hash_pattern(&mut self, node: &HashPattern) {
        visit_hash_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Heredoc` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_heredoc(node)` to continue traversing.
    fn on_heredoc(&mut self, node: &Heredoc) {
        visit_heredoc(self, node);
    }
    /// Invoked by a `Visitor` on entering into `If` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_if(node)` to continue traversing.
    fn on_if(&mut self, node: &If) {
        visit_if(self, node);
    }
    /// Invoked by a `Visitor` on entering into `IfGuard` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_if_guard(node)` to continue traversing.
    fn on_if_guard(&mut self, node: &IfGuard) {
        visit_if_guard(self, node);
    }
    /// Invoked by a `Visitor` on entering into `IFlipFlop` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_i_flip_flop(node)` to continue traversing.
    fn on_i_flip_flop(&mut self, node: &IFlipFlop) {
        visit_i_flip_flop(self, node);
    }
    /// Invoked by a `Visitor` on entering into `IfMod` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_if_mod(node)` to continue traversing.
    fn on_if_mod(&mut self, node: &IfMod) {
        visit_if_mod(self, node);
    }
    /// Invoked by a `Visitor` on entering into `IfTernary` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_if_ternary(node)` to continue traversing.
    fn on_if_ternary(&mut self, node: &IfTernary) {
        visit_if_ternary(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Index` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_index(node)` to continue traversing.
    fn on_index(&mut self, node: &Index) {
        visit_index(self, node);
    }
    /// Invoked by a `Visitor` on entering into `IndexAsgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_index_asgn(node)` to continue traversing.
    fn on_index_asgn(&mut self, node: &IndexAsgn) {
        visit_index_asgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `InPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_in_pattern(node)` to continue traversing.
    fn on_in_pattern(&mut self, node: &InPattern) {
        visit_in_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Int` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_int(node)` to continue traversing.
    fn on_int(&mut self, node: &Int) {
        visit_int(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Irange` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_irange(node)` to continue traversing.
    fn on_irange(&mut self, node: &Irange) {
        visit_irange(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Ivar` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_ivar(node)` to continue traversing.
    fn on_ivar(&mut self, node: &Ivar) {
        visit_ivar(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Ivasgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_ivasgn(node)` to continue traversing.
    fn on_ivasgn(&mut self, node: &Ivasgn) {
        visit_ivasgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwarg(node)` to continue traversing.
    fn on_kwarg(&mut self, node: &Kwarg) {
        visit_kwarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwargs` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwargs(node)` to continue traversing.
    fn on_kwargs(&mut self, node: &Kwargs) {
        visit_kwargs(self, node);
    }
    /// Invoked by a `Visitor` on entering into `KwBegin` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kw_begin(node)` to continue traversing.
    fn on_kw_begin(&mut self, node: &KwBegin) {
        visit_kw_begin(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwnilarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwnilarg(node)` to continue traversing.
    fn on_kwnilarg(&mut self, node: &Kwnilarg) {
        visit_kwnilarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwoptarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwoptarg(node)` to continue traversing.
    fn on_kwoptarg(&mut self, node: &Kwoptarg) {
        visit_kwoptarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwrestarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwrestarg(node)` to continue traversing.
    fn on_kwrestarg(&mut self, node: &Kwrestarg) {
        visit_kwrestarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Kwsplat` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_kwsplat(node)` to continue traversing.
    fn on_kwsplat(&mut self, node: &Kwsplat) {
        visit_kwsplat(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Lambda` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_lambda(node)` to continue traversing.
    fn on_lambda(&mut self, node: &Lambda) {
        visit_lambda(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Line` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_line(node)` to continue traversing.
    fn on_line(&mut self, node: &Line) {
        visit_line(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Lvar` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_lvar(node)` to continue traversing.
    fn on_lvar(&mut self, node: &Lvar) {
        visit_lvar(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Lvasgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_lvasgn(node)` to continue traversing.
    fn on_lvasgn(&mut self, node: &Lvasgn) {
        visit_lvasgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Masgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_masgn(node)` to continue traversing.
    fn on_masgn(&mut self, node: &Masgn) {
        visit_masgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchAlt` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_alt(node)` to continue traversing.
    fn on_match_alt(&mut self, node: &MatchAlt) {
        visit_match_alt(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchAs` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_as(node)` to continue traversing.
    fn on_match_as(&mut self, node: &MatchAs) {
        visit_match_as(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchCurrentLine` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_current_line(node)` to continue traversing.
    fn on_match_current_line(&mut self, node: &MatchCurrentLine) {
        visit_match_current_line(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchNilPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_nil_pattern(node)` to continue traversing.
    fn on_match_nil_pattern(&mut self, node: &MatchNilPattern) {
        visit_match_nil_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchPattern` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_pattern(node)` to continue traversing.
    fn on_match_pattern(&mut self, node: &MatchPattern) {
        visit_match_pattern(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchPatternP` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_pattern_p(node)` to continue traversing.
    fn on_match_pattern_p(&mut self, node: &MatchPatternP) {
        visit_match_pattern_p(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchRest` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_rest(node)` to continue traversing.
    fn on_match_rest(&mut self, node: &MatchRest) {
        visit_match_rest(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchVar` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_var(node)` to continue traversing.
    fn on_match_var(&mut self, node: &MatchVar) {
        visit_match_var(self, node);
    }
    /// Invoked by a `Visitor` on entering into `MatchWithLvasgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_match_with_lvasgn(node)` to continue traversing.
    fn on_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {
        visit_match_with_lvasgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Mlhs` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_mlhs(node)` to continue traversing.
    fn on_mlhs(&mut self, node: &Mlhs) {
        visit_mlhs(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Module` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_module(node)` to continue traversing.
    fn on_module(&mut self, node: &Module) {
        visit_module(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Next` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_next(node)` to continue traversing.
    fn on_next(&mut self, node: &Next) {
        visit_next(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Nil` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_nil(node)` to continue traversing.
    fn on_nil(&mut self, node: &Nil) {
        visit_nil(self, node);
    }
    /// Invoked by a `Visitor` on entering into `NthRef` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_nth_ref(node)` to continue traversing.
    fn on_nth_ref(&mut self, node: &NthRef) {
        visit_nth_ref(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Numblock` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_numblock(node)` to continue traversing.
    fn on_numblock(&mut self, node: &Numblock) {
        visit_numblock(self, node);
    }
    /// Invoked by a `Visitor` on entering into `OpAsgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_op_asgn(node)` to continue traversing.
    fn on_op_asgn(&mut self, node: &OpAsgn) {
        visit_op_asgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Optarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_optarg(node)` to continue traversing.
    fn on_optarg(&mut self, node: &Optarg) {
        visit_optarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Or` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_or(node)` to continue traversing.
    fn on_or(&mut self, node: &Or) {
        visit_or(self, node);
    }
    /// Invoked by a `Visitor` on entering into `OrAsgn` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_or_asgn(node)` to continue traversing.
    fn on_or_asgn(&mut self, node: &OrAsgn) {
        visit_or_asgn(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Pair` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_pair(node)` to continue traversing.
    fn on_pair(&mut self, node: &Pair) {
        visit_pair(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Pin` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_pin(node)` to continue traversing.
    fn on_pin(&mut self, node: &Pin) {
        visit_pin(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Postexe` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_postexe(node)` to continue traversing.
    fn on_postexe(&mut self, node: &Postexe) {
        visit_postexe(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Preexe` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_preexe(node)` to continue traversing.
    fn on_preexe(&mut self, node: &Preexe) {
        visit_preexe(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Procarg0` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_procarg0(node)` to continue traversing.
    fn on_procarg0(&mut self, node: &Procarg0) {
        visit_procarg0(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Rational` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_rational(node)` to continue traversing.
    fn on_rational(&mut self, node: &Rational) {
        visit_rational(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Redo` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_redo(node)` to continue traversing.
    fn on_redo(&mut self, node: &Redo) {
        visit_redo(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Regexp` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_regexp(node)` to continue traversing.
    fn on_regexp(&mut self, node: &Regexp) {
        visit_regexp(self, node);
    }
    /// Invoked by a `Visitor` on entering into `RegOpt` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_reg_opt(node)` to continue traversing.
    fn on_reg_opt(&mut self, node: &RegOpt) {
        visit_reg_opt(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Rescue` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_rescue(node)` to continue traversing.
    fn on_rescue(&mut self, node: &Rescue) {
        visit_rescue(self, node);
    }
    /// Invoked by a `Visitor` on entering into `RescueBody` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_rescue_body(node)` to continue traversing.
    fn on_rescue_body(&mut self, node: &RescueBody) {
        visit_rescue_body(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Restarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_restarg(node)` to continue traversing.
    fn on_restarg(&mut self, node: &Restarg) {
        visit_restarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Retry` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_retry(node)` to continue traversing.
    fn on_retry(&mut self, node: &Retry) {
        visit_retry(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Return` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_return(node)` to continue traversing.
    fn on_return(&mut self, node: &Return) {
        visit_return(self, node);
    }
    /// Invoked by a `Visitor` on entering into `SClass` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_s_class(node)` to continue traversing.
    fn on_s_class(&mut self, node: &SClass) {
        visit_s_class(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Self_` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_self_(node)` to continue traversing.
    fn on_self_(&mut self, node: &Self_) {
        visit_self_(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Send` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_send(node)` to continue traversing.
    fn on_send(&mut self, node: &Send) {
        visit_send(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Shadowarg` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_shadowarg(node)` to continue traversing.
    fn on_shadowarg(&mut self, node: &Shadowarg) {
        visit_shadowarg(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Splat` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_splat(node)` to continue traversing.
    fn on_splat(&mut self, node: &Splat) {
        visit_splat(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Str` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_str(node)` to continue traversing.
    fn on_str(&mut self, node: &Str) {
        visit_str(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Super` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_super(node)` to continue traversing.
    fn on_super(&mut self, node: &Super) {
        visit_super(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Sym` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_sym(node)` to continue traversing.
    fn on_sym(&mut self, node: &Sym) {
        visit_sym(self, node);
    }
    /// Invoked by a `Visitor` on entering into `True` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_true(node)` to continue traversing.
    fn on_true(&mut self, node: &True) {
        visit_true(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Undef` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_undef(node)` to continue traversing.
    fn on_undef(&mut self, node: &Undef) {
        visit_undef(self, node);
    }
    /// Invoked by a `Visitor` on entering into `UnlessGuard` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_unless_guard(node)` to continue traversing.
    fn on_unless_guard(&mut self, node: &UnlessGuard) {
        visit_unless_guard(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Until` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_until(node)` to continue traversing.
    fn on_until(&mut self, node: &Until) {
        visit_until(self, node);
    }
    /// Invoked by a `Visitor` on entering into `UntilPost` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_until_post(node)` to continue traversing.
    fn on_until_post(&mut self, node: &UntilPost) {
        visit_until_post(self, node);
    }
    /// Invoked by a `Visitor` on entering into `When` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_when(node)` to continue traversing.
    fn on_when(&mut self, node: &When) {
        visit_when(self, node);
    }
    /// Invoked by a `Visitor` on entering into `While` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_while(node)` to continue traversing.
    fn on_while(&mut self, node: &While) {
        visit_while(self, node);
    }
    /// Invoked by a `Visitor` on entering into `WhilePost` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_while_post(node)` to continue traversing.
    fn on_while_post(&mut self, node: &WhilePost) {
        visit_while_post(self, node);
    }
    /// Invoked by a `Visitor` on entering into `XHeredoc` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_x_heredoc(node)` to continue traversing.
    fn on_x_heredoc(&mut self, node: &XHeredoc) {
        visit_x_heredoc(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Xstr` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_xstr(node)` to continue traversing.
    fn on_xstr(&mut self, node: &Xstr) {
        visit_xstr(self, node);
    }
    /// Invoked by a `Visitor` on entering into `Yield` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_yield(node)` to continue traversing.
    fn on_yield(&mut self, node: &Yield) {
        visit_yield(self, node);
    }
    /// Invoked by a `Visitor` on entering into `ZSuper` node.
    ///
    /// Has a default implementation, but you can override it and (optionally) call
    /// `visit_z_super(node)` to continue traversing.
    fn on_z_super(&mut self, node: &ZSuper) {
        visit_z_super(self, node);
    }


    /// Generic `visit` router that calls `on_<type>` under the hood
    fn visit(&mut self, node: &Node) {
        match node {
            Node::Alias(inner) => {
                self.on_alias(inner);
            }
            Node::And(inner) => {
                self.on_and(inner);
            }
            Node::AndAsgn(inner) => {
                self.on_and_asgn(inner);
            }
            Node::Arg(inner) => {
                self.on_arg(inner);
            }
            Node::Args(inner) => {
                self.on_args(inner);
            }
            Node::Array(inner) => {
                self.on_array(inner);
            }
            Node::ArrayPattern(inner) => {
                self.on_array_pattern(inner);
            }
            Node::ArrayPatternWithTail(inner) => {
                self.on_array_pattern_with_tail(inner);
            }
            Node::BackRef(inner) => {
                self.on_back_ref(inner);
            }
            Node::Begin(inner) => {
                self.on_begin(inner);
            }
            Node::Block(inner) => {
                self.on_block(inner);
            }
            Node::Blockarg(inner) => {
                self.on_blockarg(inner);
            }
            Node::BlockPass(inner) => {
                self.on_block_pass(inner);
            }
            Node::Break(inner) => {
                self.on_break(inner);
            }
            Node::Case(inner) => {
                self.on_case(inner);
            }
            Node::CaseMatch(inner) => {
                self.on_case_match(inner);
            }
            Node::Casgn(inner) => {
                self.on_casgn(inner);
            }
            Node::Cbase(inner) => {
                self.on_cbase(inner);
            }
            Node::Class(inner) => {
                self.on_class(inner);
            }
            Node::Complex(inner) => {
                self.on_complex(inner);
            }
            Node::Const(inner) => {
                self.on_const(inner);
            }
            Node::ConstPattern(inner) => {
                self.on_const_pattern(inner);
            }
            Node::CSend(inner) => {
                self.on_c_send(inner);
            }
            Node::Cvar(inner) => {
                self.on_cvar(inner);
            }
            Node::Cvasgn(inner) => {
                self.on_cvasgn(inner);
            }
            Node::Def(inner) => {
                self.on_def(inner);
            }
            Node::Defined(inner) => {
                self.on_defined(inner);
            }
            Node::Defs(inner) => {
                self.on_defs(inner);
            }
            Node::Dstr(inner) => {
                self.on_dstr(inner);
            }
            Node::Dsym(inner) => {
                self.on_dsym(inner);
            }
            Node::EFlipFlop(inner) => {
                self.on_e_flip_flop(inner);
            }
            Node::EmptyElse(inner) => {
                self.on_empty_else(inner);
            }
            Node::Encoding(inner) => {
                self.on_encoding(inner);
            }
            Node::Ensure(inner) => {
                self.on_ensure(inner);
            }
            Node::Erange(inner) => {
                self.on_erange(inner);
            }
            Node::False(inner) => {
                self.on_false(inner);
            }
            Node::File(inner) => {
                self.on_file(inner);
            }
            Node::FindPattern(inner) => {
                self.on_find_pattern(inner);
            }
            Node::Float(inner) => {
                self.on_float(inner);
            }
            Node::For(inner) => {
                self.on_for(inner);
            }
            Node::ForwardArg(inner) => {
                self.on_forward_arg(inner);
            }
            Node::ForwardedArgs(inner) => {
                self.on_forwarded_args(inner);
            }
            Node::Gvar(inner) => {
                self.on_gvar(inner);
            }
            Node::Gvasgn(inner) => {
                self.on_gvasgn(inner);
            }
            Node::Hash(inner) => {
                self.on_hash(inner);
            }
            Node::HashPattern(inner) => {
                self.on_hash_pattern(inner);
            }
            Node::Heredoc(inner) => {
                self.on_heredoc(inner);
            }
            Node::If(inner) => {
                self.on_if(inner);
            }
            Node::IfGuard(inner) => {
                self.on_if_guard(inner);
            }
            Node::IFlipFlop(inner) => {
                self.on_i_flip_flop(inner);
            }
            Node::IfMod(inner) => {
                self.on_if_mod(inner);
            }
            Node::IfTernary(inner) => {
                self.on_if_ternary(inner);
            }
            Node::Index(inner) => {
                self.on_index(inner);
            }
            Node::IndexAsgn(inner) => {
                self.on_index_asgn(inner);
            }
            Node::InPattern(inner) => {
                self.on_in_pattern(inner);
            }
            Node::Int(inner) => {
                self.on_int(inner);
            }
            Node::Irange(inner) => {
                self.on_irange(inner);
            }
            Node::Ivar(inner) => {
                self.on_ivar(inner);
            }
            Node::Ivasgn(inner) => {
                self.on_ivasgn(inner);
            }
            Node::Kwarg(inner) => {
                self.on_kwarg(inner);
            }
            Node::Kwargs(inner) => {
                self.on_kwargs(inner);
            }
            Node::KwBegin(inner) => {
                self.on_kw_begin(inner);
            }
            Node::Kwnilarg(inner) => {
                self.on_kwnilarg(inner);
            }
            Node::Kwoptarg(inner) => {
                self.on_kwoptarg(inner);
            }
            Node::Kwrestarg(inner) => {
                self.on_kwrestarg(inner);
            }
            Node::Kwsplat(inner) => {
                self.on_kwsplat(inner);
            }
            Node::Lambda(inner) => {
                self.on_lambda(inner);
            }
            Node::Line(inner) => {
                self.on_line(inner);
            }
            Node::Lvar(inner) => {
                self.on_lvar(inner);
            }
            Node::Lvasgn(inner) => {
                self.on_lvasgn(inner);
            }
            Node::Masgn(inner) => {
                self.on_masgn(inner);
            }
            Node::MatchAlt(inner) => {
                self.on_match_alt(inner);
            }
            Node::MatchAs(inner) => {
                self.on_match_as(inner);
            }
            Node::MatchCurrentLine(inner) => {
                self.on_match_current_line(inner);
            }
            Node::MatchNilPattern(inner) => {
                self.on_match_nil_pattern(inner);
            }
            Node::MatchPattern(inner) => {
                self.on_match_pattern(inner);
            }
            Node::MatchPatternP(inner) => {
                self.on_match_pattern_p(inner);
            }
            Node::MatchRest(inner) => {
                self.on_match_rest(inner);
            }
            Node::MatchVar(inner) => {
                self.on_match_var(inner);
            }
            Node::MatchWithLvasgn(inner) => {
                self.on_match_with_lvasgn(inner);
            }
            Node::Mlhs(inner) => {
                self.on_mlhs(inner);
            }
            Node::Module(inner) => {
                self.on_module(inner);
            }
            Node::Next(inner) => {
                self.on_next(inner);
            }
            Node::Nil(inner) => {
                self.on_nil(inner);
            }
            Node::NthRef(inner) => {
                self.on_nth_ref(inner);
            }
            Node::Numblock(inner) => {
                self.on_numblock(inner);
            }
            Node::OpAsgn(inner) => {
                self.on_op_asgn(inner);
            }
            Node::Optarg(inner) => {
                self.on_optarg(inner);
            }
            Node::Or(inner) => {
                self.on_or(inner);
            }
            Node::OrAsgn(inner) => {
                self.on_or_asgn(inner);
            }
            Node::Pair(inner) => {
                self.on_pair(inner);
            }
            Node::Pin(inner) => {
                self.on_pin(inner);
            }
            Node::Postexe(inner) => {
                self.on_postexe(inner);
            }
            Node::Preexe(inner) => {
                self.on_preexe(inner);
            }
            Node::Procarg0(inner) => {
                self.on_procarg0(inner);
            }
            Node::Rational(inner) => {
                self.on_rational(inner);
            }
            Node::Redo(inner) => {
                self.on_redo(inner);
            }
            Node::Regexp(inner) => {
                self.on_regexp(inner);
            }
            Node::RegOpt(inner) => {
                self.on_reg_opt(inner);
            }
            Node::Rescue(inner) => {
                self.on_rescue(inner);
            }
            Node::RescueBody(inner) => {
                self.on_rescue_body(inner);
            }
            Node::Restarg(inner) => {
                self.on_restarg(inner);
            }
            Node::Retry(inner) => {
                self.on_retry(inner);
            }
            Node::Return(inner) => {
                self.on_return(inner);
            }
            Node::SClass(inner) => {
                self.on_s_class(inner);
            }
            Node::Self_(inner) => {
                self.on_self_(inner);
            }
            Node::Send(inner) => {
                self.on_send(inner);
            }
            Node::Shadowarg(inner) => {
                self.on_shadowarg(inner);
            }
            Node::Splat(inner) => {
                self.on_splat(inner);
            }
            Node::Str(inner) => {
                self.on_str(inner);
            }
            Node::Super(inner) => {
                self.on_super(inner);
            }
            Node::Sym(inner) => {
                self.on_sym(inner);
            }
            Node::True(inner) => {
                self.on_true(inner);
            }
            Node::Undef(inner) => {
                self.on_undef(inner);
            }
            Node::UnlessGuard(inner) => {
                self.on_unless_guard(inner);
            }
            Node::Until(inner) => {
                self.on_until(inner);
            }
            Node::UntilPost(inner) => {
                self.on_until_post(inner);
            }
            Node::When(inner) => {
                self.on_when(inner);
            }
            Node::While(inner) => {
                self.on_while(inner);
            }
            Node::WhilePost(inner) => {
                self.on_while_post(inner);
            }
            Node::XHeredoc(inner) => {
                self.on_x_heredoc(inner);
            }
            Node::Xstr(inner) => {
                self.on_xstr(inner);
            }
            Node::Yield(inner) => {
                self.on_yield(inner);
            }
            Node::ZSuper(inner) => {
                self.on_z_super(inner);
            }

        }
    }
}

/// Visits all children of Alias node
#[allow(unused_variables)]
pub fn visit_alias<V: Visitor>(visitor: &mut V, node: &Alias) {
    visitor.visit(&node.to);
    visitor.visit(&node.from);
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of And node
#[allow(unused_variables)]
pub fn visit_and<V: Visitor>(visitor: &mut V, node: &And) {
    visitor.visit(&node.lhs);
    visitor.visit(&node.rhs);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of AndAsgn node
#[allow(unused_variables)]
pub fn visit_and_asgn<V: Visitor>(visitor: &mut V, node: &AndAsgn) {
    visitor.visit(&node.recv);
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Arg node
#[allow(unused_variables)]
pub fn visit_arg<V: Visitor>(visitor: &mut V, node: &Arg) {
    // skip name
    // skip expression_l
}
/// Visits all children of Args node
#[allow(unused_variables)]
pub fn visit_args<V: Visitor>(visitor: &mut V, node: &Args) {
    for item in &node.args { visitor.visit(item); }
    // skip expression_l
    // skip begin_l
    // skip end_l
}
/// Visits all children of Array node
#[allow(unused_variables)]
pub fn visit_array<V: Visitor>(visitor: &mut V, node: &Array) {
    for item in &node.elements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of ArrayPattern node
#[allow(unused_variables)]
pub fn visit_array_pattern<V: Visitor>(visitor: &mut V, node: &ArrayPattern) {
    for item in &node.elements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of ArrayPatternWithTail node
#[allow(unused_variables)]
pub fn visit_array_pattern_with_tail<V: Visitor>(visitor: &mut V, node: &ArrayPatternWithTail) {
    for item in &node.elements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of BackRef node
#[allow(unused_variables)]
pub fn visit_back_ref<V: Visitor>(visitor: &mut V, node: &BackRef) {
    // skip name
    // skip expression_l
}
/// Visits all children of Begin node
#[allow(unused_variables)]
pub fn visit_begin<V: Visitor>(visitor: &mut V, node: &Begin) {
    for item in &node.statements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Block node
#[allow(unused_variables)]
pub fn visit_block<V: Visitor>(visitor: &mut V, node: &Block) {
    visitor.visit(&node.call);
    if let Some(inner) = node.args.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Blockarg node
#[allow(unused_variables)]
pub fn visit_blockarg<V: Visitor>(visitor: &mut V, node: &Blockarg) {
    // skip name
    // skip operator_l
    // skip name_l
    // skip expression_l
}
/// Visits all children of BlockPass node
#[allow(unused_variables)]
pub fn visit_block_pass<V: Visitor>(visitor: &mut V, node: &BlockPass) {
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Break node
#[allow(unused_variables)]
pub fn visit_break<V: Visitor>(visitor: &mut V, node: &Break) {
    for item in &node.args { visitor.visit(item); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of Case node
#[allow(unused_variables)]
pub fn visit_case<V: Visitor>(visitor: &mut V, node: &Case) {
    if let Some(inner) = node.expr.as_ref() { visitor.visit(inner); }
    for item in &node.when_bodies { visitor.visit(item); }
    if let Some(inner) = node.else_body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip else_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of CaseMatch node
#[allow(unused_variables)]
pub fn visit_case_match<V: Visitor>(visitor: &mut V, node: &CaseMatch) {
    visitor.visit(&node.expr);
    for item in &node.in_bodies { visitor.visit(item); }
    if let Some(inner) = node.else_body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip else_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Casgn node
#[allow(unused_variables)]
pub fn visit_casgn<V: Visitor>(visitor: &mut V, node: &Casgn) {
    if let Some(inner) = node.scope.as_ref() { visitor.visit(inner); }
    // skip name
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip double_colon_l
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Cbase node
#[allow(unused_variables)]
pub fn visit_cbase<V: Visitor>(visitor: &mut V, node: &Cbase) {
    // skip expression_l
}
/// Visits all children of Class node
#[allow(unused_variables)]
pub fn visit_class<V: Visitor>(visitor: &mut V, node: &Class) {
    visitor.visit(&node.name);
    if let Some(inner) = node.superclass.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip operator_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Complex node
#[allow(unused_variables)]
pub fn visit_complex<V: Visitor>(visitor: &mut V, node: &Complex) {
    // skip value
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Const node
#[allow(unused_variables)]
pub fn visit_const<V: Visitor>(visitor: &mut V, node: &Const) {
    if let Some(inner) = node.scope.as_ref() { visitor.visit(inner); }
    // skip name
    // skip double_colon_l
    // skip name_l
    // skip expression_l
}
/// Visits all children of ConstPattern node
#[allow(unused_variables)]
pub fn visit_const_pattern<V: Visitor>(visitor: &mut V, node: &ConstPattern) {
    visitor.visit(&node.const_);
    visitor.visit(&node.pattern);
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of CSend node
#[allow(unused_variables)]
pub fn visit_c_send<V: Visitor>(visitor: &mut V, node: &CSend) {
    visitor.visit(&node.recv);
    // skip method_name
    for item in &node.args { visitor.visit(item); }
    // skip dot_l
    // skip selector_l
    // skip begin_l
    // skip end_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Cvar node
#[allow(unused_variables)]
pub fn visit_cvar<V: Visitor>(visitor: &mut V, node: &Cvar) {
    // skip name
    // skip expression_l
}
/// Visits all children of Cvasgn node
#[allow(unused_variables)]
pub fn visit_cvasgn<V: Visitor>(visitor: &mut V, node: &Cvasgn) {
    // skip name
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Def node
#[allow(unused_variables)]
pub fn visit_def<V: Visitor>(visitor: &mut V, node: &Def) {
    // skip name
    if let Some(inner) = node.args.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip name_l
    // skip end_l
    // skip assignment_l
    // skip expression_l
}
/// Visits all children of Defined node
#[allow(unused_variables)]
pub fn visit_defined<V: Visitor>(visitor: &mut V, node: &Defined) {
    visitor.visit(&node.value);
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Defs node
#[allow(unused_variables)]
pub fn visit_defs<V: Visitor>(visitor: &mut V, node: &Defs) {
    visitor.visit(&node.definee);
    // skip name
    if let Some(inner) = node.args.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip operator_l
    // skip name_l
    // skip assignment_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Dstr node
#[allow(unused_variables)]
pub fn visit_dstr<V: Visitor>(visitor: &mut V, node: &Dstr) {
    for item in &node.parts { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Dsym node
#[allow(unused_variables)]
pub fn visit_dsym<V: Visitor>(visitor: &mut V, node: &Dsym) {
    for item in &node.parts { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of EFlipFlop node
#[allow(unused_variables)]
pub fn visit_e_flip_flop<V: Visitor>(visitor: &mut V, node: &EFlipFlop) {
    if let Some(inner) = node.left.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.right.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of EmptyElse node
#[allow(unused_variables)]
pub fn visit_empty_else<V: Visitor>(visitor: &mut V, node: &EmptyElse) {
    // skip expression_l
}
/// Visits all children of Encoding node
#[allow(unused_variables)]
pub fn visit_encoding<V: Visitor>(visitor: &mut V, node: &Encoding) {
    // skip expression_l
}
/// Visits all children of Ensure node
#[allow(unused_variables)]
pub fn visit_ensure<V: Visitor>(visitor: &mut V, node: &Ensure) {
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.ensure.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of Erange node
#[allow(unused_variables)]
pub fn visit_erange<V: Visitor>(visitor: &mut V, node: &Erange) {
    if let Some(inner) = node.left.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.right.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of False node
#[allow(unused_variables)]
pub fn visit_false<V: Visitor>(visitor: &mut V, node: &False) {
    // skip expression_l
}
/// Visits all children of File node
#[allow(unused_variables)]
pub fn visit_file<V: Visitor>(visitor: &mut V, node: &File) {
    // skip expression_l
}
/// Visits all children of FindPattern node
#[allow(unused_variables)]
pub fn visit_find_pattern<V: Visitor>(visitor: &mut V, node: &FindPattern) {
    for item in &node.elements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Float node
#[allow(unused_variables)]
pub fn visit_float<V: Visitor>(visitor: &mut V, node: &Float) {
    // skip value
    // skip operator_l
    // skip expression_l
}
/// Visits all children of For node
#[allow(unused_variables)]
pub fn visit_for<V: Visitor>(visitor: &mut V, node: &For) {
    visitor.visit(&node.iterator);
    visitor.visit(&node.iteratee);
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip operator_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of ForwardArg node
#[allow(unused_variables)]
pub fn visit_forward_arg<V: Visitor>(visitor: &mut V, node: &ForwardArg) {
    // skip expression_l
}
/// Visits all children of ForwardedArgs node
#[allow(unused_variables)]
pub fn visit_forwarded_args<V: Visitor>(visitor: &mut V, node: &ForwardedArgs) {
    // skip expression_l
}
/// Visits all children of Gvar node
#[allow(unused_variables)]
pub fn visit_gvar<V: Visitor>(visitor: &mut V, node: &Gvar) {
    // skip name
    // skip expression_l
}
/// Visits all children of Gvasgn node
#[allow(unused_variables)]
pub fn visit_gvasgn<V: Visitor>(visitor: &mut V, node: &Gvasgn) {
    // skip name
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Hash node
#[allow(unused_variables)]
pub fn visit_hash<V: Visitor>(visitor: &mut V, node: &Hash) {
    for item in &node.pairs { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of HashPattern node
#[allow(unused_variables)]
pub fn visit_hash_pattern<V: Visitor>(visitor: &mut V, node: &HashPattern) {
    for item in &node.elements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Heredoc node
#[allow(unused_variables)]
pub fn visit_heredoc<V: Visitor>(visitor: &mut V, node: &Heredoc) {
    for item in &node.parts { visitor.visit(item); }
    // skip heredoc_body_l
    // skip heredoc_end_l
    // skip expression_l
}
/// Visits all children of If node
#[allow(unused_variables)]
pub fn visit_if<V: Visitor>(visitor: &mut V, node: &If) {
    visitor.visit(&node.cond);
    if let Some(inner) = node.if_true.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.if_false.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip else_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of IfGuard node
#[allow(unused_variables)]
pub fn visit_if_guard<V: Visitor>(visitor: &mut V, node: &IfGuard) {
    visitor.visit(&node.cond);
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of IFlipFlop node
#[allow(unused_variables)]
pub fn visit_i_flip_flop<V: Visitor>(visitor: &mut V, node: &IFlipFlop) {
    if let Some(inner) = node.left.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.right.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of IfMod node
#[allow(unused_variables)]
pub fn visit_if_mod<V: Visitor>(visitor: &mut V, node: &IfMod) {
    visitor.visit(&node.cond);
    if let Some(inner) = node.if_true.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.if_false.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of IfTernary node
#[allow(unused_variables)]
pub fn visit_if_ternary<V: Visitor>(visitor: &mut V, node: &IfTernary) {
    visitor.visit(&node.cond);
    visitor.visit(&node.if_true);
    visitor.visit(&node.if_false);
    // skip question_l
    // skip colon_l
    // skip expression_l
}
/// Visits all children of Index node
#[allow(unused_variables)]
pub fn visit_index<V: Visitor>(visitor: &mut V, node: &Index) {
    visitor.visit(&node.recv);
    for item in &node.indexes { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of IndexAsgn node
#[allow(unused_variables)]
pub fn visit_index_asgn<V: Visitor>(visitor: &mut V, node: &IndexAsgn) {
    visitor.visit(&node.recv);
    for item in &node.indexes { visitor.visit(item); }
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip begin_l
    // skip end_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of InPattern node
#[allow(unused_variables)]
pub fn visit_in_pattern<V: Visitor>(visitor: &mut V, node: &InPattern) {
    visitor.visit(&node.pattern);
    if let Some(inner) = node.guard.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip expression_l
}
/// Visits all children of Int node
#[allow(unused_variables)]
pub fn visit_int<V: Visitor>(visitor: &mut V, node: &Int) {
    // skip value
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Irange node
#[allow(unused_variables)]
pub fn visit_irange<V: Visitor>(visitor: &mut V, node: &Irange) {
    if let Some(inner) = node.left.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.right.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Ivar node
#[allow(unused_variables)]
pub fn visit_ivar<V: Visitor>(visitor: &mut V, node: &Ivar) {
    // skip name
    // skip expression_l
}
/// Visits all children of Ivasgn node
#[allow(unused_variables)]
pub fn visit_ivasgn<V: Visitor>(visitor: &mut V, node: &Ivasgn) {
    // skip name
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Kwarg node
#[allow(unused_variables)]
pub fn visit_kwarg<V: Visitor>(visitor: &mut V, node: &Kwarg) {
    // skip name
    // skip name_l
    // skip expression_l
}
/// Visits all children of Kwargs node
#[allow(unused_variables)]
pub fn visit_kwargs<V: Visitor>(visitor: &mut V, node: &Kwargs) {
    for item in &node.pairs { visitor.visit(item); }
    // skip expression_l
}
/// Visits all children of KwBegin node
#[allow(unused_variables)]
pub fn visit_kw_begin<V: Visitor>(visitor: &mut V, node: &KwBegin) {
    for item in &node.statements { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Kwnilarg node
#[allow(unused_variables)]
pub fn visit_kwnilarg<V: Visitor>(visitor: &mut V, node: &Kwnilarg) {
    // skip name_l
    // skip expression_l
}
/// Visits all children of Kwoptarg node
#[allow(unused_variables)]
pub fn visit_kwoptarg<V: Visitor>(visitor: &mut V, node: &Kwoptarg) {
    // skip name
    visitor.visit(&node.default);
    // skip name_l
    // skip expression_l
}
/// Visits all children of Kwrestarg node
#[allow(unused_variables)]
pub fn visit_kwrestarg<V: Visitor>(visitor: &mut V, node: &Kwrestarg) {
    // skip name
    // skip operator_l
    // skip name_l
    // skip expression_l
}
/// Visits all children of Kwsplat node
#[allow(unused_variables)]
pub fn visit_kwsplat<V: Visitor>(visitor: &mut V, node: &Kwsplat) {
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Lambda node
#[allow(unused_variables)]
pub fn visit_lambda<V: Visitor>(visitor: &mut V, node: &Lambda) {
    // skip expression_l
}
/// Visits all children of Line node
#[allow(unused_variables)]
pub fn visit_line<V: Visitor>(visitor: &mut V, node: &Line) {
    // skip expression_l
}
/// Visits all children of Lvar node
#[allow(unused_variables)]
pub fn visit_lvar<V: Visitor>(visitor: &mut V, node: &Lvar) {
    // skip name
    // skip expression_l
}
/// Visits all children of Lvasgn node
#[allow(unused_variables)]
pub fn visit_lvasgn<V: Visitor>(visitor: &mut V, node: &Lvasgn) {
    // skip name
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Masgn node
#[allow(unused_variables)]
pub fn visit_masgn<V: Visitor>(visitor: &mut V, node: &Masgn) {
    visitor.visit(&node.lhs);
    visitor.visit(&node.rhs);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchAlt node
#[allow(unused_variables)]
pub fn visit_match_alt<V: Visitor>(visitor: &mut V, node: &MatchAlt) {
    visitor.visit(&node.lhs);
    visitor.visit(&node.rhs);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchAs node
#[allow(unused_variables)]
pub fn visit_match_as<V: Visitor>(visitor: &mut V, node: &MatchAs) {
    visitor.visit(&node.value);
    visitor.visit(&node.as_);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchCurrentLine node
#[allow(unused_variables)]
pub fn visit_match_current_line<V: Visitor>(visitor: &mut V, node: &MatchCurrentLine) {
    visitor.visit(&node.re);
    // skip expression_l
}
/// Visits all children of MatchNilPattern node
#[allow(unused_variables)]
pub fn visit_match_nil_pattern<V: Visitor>(visitor: &mut V, node: &MatchNilPattern) {
    // skip operator_l
    // skip name_l
    // skip expression_l
}
/// Visits all children of MatchPattern node
#[allow(unused_variables)]
pub fn visit_match_pattern<V: Visitor>(visitor: &mut V, node: &MatchPattern) {
    visitor.visit(&node.value);
    visitor.visit(&node.pattern);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchPatternP node
#[allow(unused_variables)]
pub fn visit_match_pattern_p<V: Visitor>(visitor: &mut V, node: &MatchPatternP) {
    visitor.visit(&node.value);
    visitor.visit(&node.pattern);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchRest node
#[allow(unused_variables)]
pub fn visit_match_rest<V: Visitor>(visitor: &mut V, node: &MatchRest) {
    if let Some(inner) = node.name.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of MatchVar node
#[allow(unused_variables)]
pub fn visit_match_var<V: Visitor>(visitor: &mut V, node: &MatchVar) {
    // skip name
    // skip name_l
    // skip expression_l
}
/// Visits all children of MatchWithLvasgn node
#[allow(unused_variables)]
pub fn visit_match_with_lvasgn<V: Visitor>(visitor: &mut V, node: &MatchWithLvasgn) {
    visitor.visit(&node.re);
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Mlhs node
#[allow(unused_variables)]
pub fn visit_mlhs<V: Visitor>(visitor: &mut V, node: &Mlhs) {
    for item in &node.items { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Module node
#[allow(unused_variables)]
pub fn visit_module<V: Visitor>(visitor: &mut V, node: &Module) {
    visitor.visit(&node.name);
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Next node
#[allow(unused_variables)]
pub fn visit_next<V: Visitor>(visitor: &mut V, node: &Next) {
    for item in &node.args { visitor.visit(item); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of Nil node
#[allow(unused_variables)]
pub fn visit_nil<V: Visitor>(visitor: &mut V, node: &Nil) {
    // skip expression_l
}
/// Visits all children of NthRef node
#[allow(unused_variables)]
pub fn visit_nth_ref<V: Visitor>(visitor: &mut V, node: &NthRef) {
    // skip name
    // skip expression_l
}
/// Visits all children of Numblock node
#[allow(unused_variables)]
pub fn visit_numblock<V: Visitor>(visitor: &mut V, node: &Numblock) {
    visitor.visit(&node.call);
    // skip numargs
    visitor.visit(&node.body);
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of OpAsgn node
#[allow(unused_variables)]
pub fn visit_op_asgn<V: Visitor>(visitor: &mut V, node: &OpAsgn) {
    visitor.visit(&node.recv);
    // skip operator
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Optarg node
#[allow(unused_variables)]
pub fn visit_optarg<V: Visitor>(visitor: &mut V, node: &Optarg) {
    // skip name
    visitor.visit(&node.default);
    // skip name_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Or node
#[allow(unused_variables)]
pub fn visit_or<V: Visitor>(visitor: &mut V, node: &Or) {
    visitor.visit(&node.lhs);
    visitor.visit(&node.rhs);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of OrAsgn node
#[allow(unused_variables)]
pub fn visit_or_asgn<V: Visitor>(visitor: &mut V, node: &OrAsgn) {
    visitor.visit(&node.recv);
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Pair node
#[allow(unused_variables)]
pub fn visit_pair<V: Visitor>(visitor: &mut V, node: &Pair) {
    visitor.visit(&node.key);
    visitor.visit(&node.value);
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Pin node
#[allow(unused_variables)]
pub fn visit_pin<V: Visitor>(visitor: &mut V, node: &Pin) {
    visitor.visit(&node.var);
    // skip selector_l
    // skip expression_l
}
/// Visits all children of Postexe node
#[allow(unused_variables)]
pub fn visit_postexe<V: Visitor>(visitor: &mut V, node: &Postexe) {
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Preexe node
#[allow(unused_variables)]
pub fn visit_preexe<V: Visitor>(visitor: &mut V, node: &Preexe) {
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Procarg0 node
#[allow(unused_variables)]
pub fn visit_procarg0<V: Visitor>(visitor: &mut V, node: &Procarg0) {
    for item in &node.args { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Rational node
#[allow(unused_variables)]
pub fn visit_rational<V: Visitor>(visitor: &mut V, node: &Rational) {
    // skip value
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Redo node
#[allow(unused_variables)]
pub fn visit_redo<V: Visitor>(visitor: &mut V, node: &Redo) {
    // skip expression_l
}
/// Visits all children of Regexp node
#[allow(unused_variables)]
pub fn visit_regexp<V: Visitor>(visitor: &mut V, node: &Regexp) {
    for item in &node.parts { visitor.visit(item); }
    if let Some(inner) = node.options.as_ref() { visitor.visit(inner); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of RegOpt node
#[allow(unused_variables)]
pub fn visit_reg_opt<V: Visitor>(visitor: &mut V, node: &RegOpt) {
    // skip options
    // skip expression_l
}
/// Visits all children of Rescue node
#[allow(unused_variables)]
pub fn visit_rescue<V: Visitor>(visitor: &mut V, node: &Rescue) {
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    for item in &node.rescue_bodies { visitor.visit(item); }
    if let Some(inner) = node.else_.as_ref() { visitor.visit(inner); }
    // skip else_l
    // skip expression_l
}
/// Visits all children of RescueBody node
#[allow(unused_variables)]
pub fn visit_rescue_body<V: Visitor>(visitor: &mut V, node: &RescueBody) {
    if let Some(inner) = node.exc_list.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.exc_var.as_ref() { visitor.visit(inner); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip assoc_l
    // skip begin_l
    // skip expression_l
}
/// Visits all children of Restarg node
#[allow(unused_variables)]
pub fn visit_restarg<V: Visitor>(visitor: &mut V, node: &Restarg) {
    // skip name
    // skip operator_l
    // skip name_l
    // skip expression_l
}
/// Visits all children of Retry node
#[allow(unused_variables)]
pub fn visit_retry<V: Visitor>(visitor: &mut V, node: &Retry) {
    // skip expression_l
}
/// Visits all children of Return node
#[allow(unused_variables)]
pub fn visit_return<V: Visitor>(visitor: &mut V, node: &Return) {
    for item in &node.args { visitor.visit(item); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of SClass node
#[allow(unused_variables)]
pub fn visit_s_class<V: Visitor>(visitor: &mut V, node: &SClass) {
    visitor.visit(&node.expr);
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip operator_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Self_ node
#[allow(unused_variables)]
pub fn visit_self_<V: Visitor>(visitor: &mut V, node: &Self_) {
    // skip expression_l
}
/// Visits all children of Send node
#[allow(unused_variables)]
pub fn visit_send<V: Visitor>(visitor: &mut V, node: &Send) {
    if let Some(inner) = node.recv.as_ref() { visitor.visit(inner); }
    // skip method_name
    for item in &node.args { visitor.visit(item); }
    // skip dot_l
    // skip selector_l
    // skip begin_l
    // skip end_l
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Shadowarg node
#[allow(unused_variables)]
pub fn visit_shadowarg<V: Visitor>(visitor: &mut V, node: &Shadowarg) {
    // skip name
    // skip expression_l
}
/// Visits all children of Splat node
#[allow(unused_variables)]
pub fn visit_splat<V: Visitor>(visitor: &mut V, node: &Splat) {
    if let Some(inner) = node.value.as_ref() { visitor.visit(inner); }
    // skip operator_l
    // skip expression_l
}
/// Visits all children of Str node
#[allow(unused_variables)]
pub fn visit_str<V: Visitor>(visitor: &mut V, node: &Str) {
    // skip value
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Super node
#[allow(unused_variables)]
pub fn visit_super<V: Visitor>(visitor: &mut V, node: &Super) {
    for item in &node.args { visitor.visit(item); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Sym node
#[allow(unused_variables)]
pub fn visit_sym<V: Visitor>(visitor: &mut V, node: &Sym) {
    // skip name
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of True node
#[allow(unused_variables)]
pub fn visit_true<V: Visitor>(visitor: &mut V, node: &True) {
    // skip expression_l
}
/// Visits all children of Undef node
#[allow(unused_variables)]
pub fn visit_undef<V: Visitor>(visitor: &mut V, node: &Undef) {
    for item in &node.names { visitor.visit(item); }
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of UnlessGuard node
#[allow(unused_variables)]
pub fn visit_unless_guard<V: Visitor>(visitor: &mut V, node: &UnlessGuard) {
    visitor.visit(&node.cond);
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of Until node
#[allow(unused_variables)]
pub fn visit_until<V: Visitor>(visitor: &mut V, node: &Until) {
    visitor.visit(&node.cond);
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of UntilPost node
#[allow(unused_variables)]
pub fn visit_until_post<V: Visitor>(visitor: &mut V, node: &UntilPost) {
    visitor.visit(&node.cond);
    visitor.visit(&node.body);
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of When node
#[allow(unused_variables)]
pub fn visit_when<V: Visitor>(visitor: &mut V, node: &When) {
    for item in &node.patterns { visitor.visit(item); }
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip expression_l
}
/// Visits all children of While node
#[allow(unused_variables)]
pub fn visit_while<V: Visitor>(visitor: &mut V, node: &While) {
    visitor.visit(&node.cond);
    if let Some(inner) = node.body.as_ref() { visitor.visit(inner); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of WhilePost node
#[allow(unused_variables)]
pub fn visit_while_post<V: Visitor>(visitor: &mut V, node: &WhilePost) {
    visitor.visit(&node.cond);
    visitor.visit(&node.body);
    // skip keyword_l
    // skip expression_l
}
/// Visits all children of XHeredoc node
#[allow(unused_variables)]
pub fn visit_x_heredoc<V: Visitor>(visitor: &mut V, node: &XHeredoc) {
    for item in &node.parts { visitor.visit(item); }
    // skip heredoc_body_l
    // skip heredoc_end_l
    // skip expression_l
}
/// Visits all children of Xstr node
#[allow(unused_variables)]
pub fn visit_xstr<V: Visitor>(visitor: &mut V, node: &Xstr) {
    for item in &node.parts { visitor.visit(item); }
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of Yield node
#[allow(unused_variables)]
pub fn visit_yield<V: Visitor>(visitor: &mut V, node: &Yield) {
    for item in &node.args { visitor.visit(item); }
    // skip keyword_l
    // skip begin_l
    // skip end_l
    // skip expression_l
}
/// Visits all children of ZSuper node
#[allow(unused_variables)]
pub fn visit_z_super<V: Visitor>(visitor: &mut V, node: &ZSuper) {
    // skip expression_l
}
