// This file is auto-generated by codegen/rust/finder.rs

use crate::traverse::finder::{Finder, PatternItem};
use crate::traverse::visitor::Visitor;
use crate::nodes::*;
use crate::Node;

impl Visitor for Finder {
    fn on_alias(&mut self, node: &Alias) {
        match self.pattern.unshift() {
            Some(PatternItem::To) => { self.visit(&node.to); }
            Some(PatternItem::From) => { self.visit(&node.from); }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Alias(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_and(&mut self, node: &And) {
        match self.pattern.unshift() {
            Some(PatternItem::Lhs) => { self.visit(&node.lhs); }
            Some(PatternItem::Rhs) => { self.visit(&node.rhs); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::And(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_and_asgn(&mut self, node: &AndAsgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::AndAsgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_arg(&mut self, node: &Arg) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Arg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_args(&mut self, node: &Args) {
        match self.pattern.unshift() {
            Some(PatternItem::Arglist) => { visit_node_list(self, &node.args) }
            // skip expression_l
            // skip begin_l
            // skip end_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Args(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_array(&mut self, node: &Array) {
        match self.pattern.unshift() {
            Some(PatternItem::Elements) => { visit_node_list(self, &node.elements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Array(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_array_pattern(&mut self, node: &ArrayPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Elements) => { visit_node_list(self, &node.elements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ArrayPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {
        match self.pattern.unshift() {
            Some(PatternItem::Elements) => { visit_node_list(self, &node.elements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ArrayPatternWithTail(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_back_ref(&mut self, node: &BackRef) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::BackRef(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_begin(&mut self, node: &Begin) {
        match self.pattern.unshift() {
            Some(PatternItem::Stmts) => { visit_node_list(self, &node.statements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Begin(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_block(&mut self, node: &Block) {
        match self.pattern.unshift() {
            Some(PatternItem::MethodCall) => { self.visit(&node.call); }
            Some(PatternItem::Args) => { if let Some(inner) = node.args.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Block(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_blockarg(&mut self, node: &Blockarg) {
        match self.pattern.unshift() {
            // skip name
            // skip operator_l
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Blockarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_block_pass(&mut self, node: &BlockPass) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::BlockPass(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_break(&mut self, node: &Break) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Break(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_case(&mut self, node: &Case) {
        match self.pattern.unshift() {
            Some(PatternItem::Expr) => { if let Some(inner) = node.expr.as_ref() { self.visit(inner); } }
            Some(PatternItem::WhenBodies) => { visit_node_list(self, &node.when_bodies) }
            Some(PatternItem::ElseBody) => { if let Some(inner) = node.else_body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip else_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Case(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_case_match(&mut self, node: &CaseMatch) {
        match self.pattern.unshift() {
            Some(PatternItem::Expr) => { self.visit(&node.expr); }
            Some(PatternItem::InBodies) => { visit_node_list(self, &node.in_bodies) }
            Some(PatternItem::ElseBody) => { if let Some(inner) = node.else_body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip else_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::CaseMatch(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_casgn(&mut self, node: &Casgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Scope) => { if let Some(inner) = node.scope.as_ref() { self.visit(inner); } }
            // skip name
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip double_colon_l
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Casgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_cbase(&mut self, node: &Cbase) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Cbase(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_class(&mut self, node: &Class) {
        match self.pattern.unshift() {
            Some(PatternItem::Name) => { self.visit(&node.name); }
            Some(PatternItem::Superclass) => { if let Some(inner) = node.superclass.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip operator_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Class(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_complex(&mut self, node: &Complex) {
        match self.pattern.unshift() {
            // skip value
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Complex(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_const(&mut self, node: &Const) {
        match self.pattern.unshift() {
            Some(PatternItem::Scope) => { if let Some(inner) = node.scope.as_ref() { self.visit(inner); } }
            // skip name
            // skip double_colon_l
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Const(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_const_pattern(&mut self, node: &ConstPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Const) => { self.visit(&node.const_); }
            Some(PatternItem::Pattern) => { self.visit(&node.pattern); }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ConstPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_c_send(&mut self, node: &CSend) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            // skip method_name
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip dot_l
            // skip selector_l
            // skip begin_l
            // skip end_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::CSend(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_cvar(&mut self, node: &Cvar) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Cvar(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_cvasgn(&mut self, node: &Cvasgn) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Cvasgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_def(&mut self, node: &Def) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::Args) => { if let Some(inner) = node.args.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip name_l
            // skip end_l
            // skip assignment_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Def(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_defined(&mut self, node: &Defined) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Defined(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_defs(&mut self, node: &Defs) {
        match self.pattern.unshift() {
            Some(PatternItem::Definee) => { self.visit(&node.definee); }
            // skip name
            Some(PatternItem::Args) => { if let Some(inner) = node.args.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip operator_l
            // skip name_l
            // skip assignment_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Defs(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_dstr(&mut self, node: &Dstr) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Dstr(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_dsym(&mut self, node: &Dsym) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Dsym(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_e_flip_flop(&mut self, node: &EFlipFlop) {
        match self.pattern.unshift() {
            Some(PatternItem::Left) => { if let Some(inner) = node.left.as_ref() { self.visit(inner); } }
            Some(PatternItem::Right) => { if let Some(inner) = node.right.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::EFlipFlop(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_empty_else(&mut self, node: &EmptyElse) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::EmptyElse(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_encoding(&mut self, node: &Encoding) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Encoding(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_ensure(&mut self, node: &Ensure) {
        match self.pattern.unshift() {
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            Some(PatternItem::Ensure) => { if let Some(inner) = node.ensure.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Ensure(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_erange(&mut self, node: &Erange) {
        match self.pattern.unshift() {
            Some(PatternItem::Left) => { if let Some(inner) = node.left.as_ref() { self.visit(inner); } }
            Some(PatternItem::Right) => { if let Some(inner) = node.right.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Erange(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_false(&mut self, node: &False) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::False(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_file(&mut self, node: &File) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::File(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_find_pattern(&mut self, node: &FindPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Elements) => { visit_node_list(self, &node.elements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::FindPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_float(&mut self, node: &Float) {
        match self.pattern.unshift() {
            // skip value
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Float(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_for(&mut self, node: &For) {
        match self.pattern.unshift() {
            Some(PatternItem::Iterator) => { self.visit(&node.iterator); }
            Some(PatternItem::Iteratee) => { self.visit(&node.iteratee); }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip operator_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::For(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_forward_arg(&mut self, node: &ForwardArg) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ForwardArg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_forwarded_args(&mut self, node: &ForwardedArgs) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ForwardedArgs(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_gvar(&mut self, node: &Gvar) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Gvar(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_gvasgn(&mut self, node: &Gvasgn) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Gvasgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_hash(&mut self, node: &Hash) {
        match self.pattern.unshift() {
            Some(PatternItem::Pairs) => { visit_node_list(self, &node.pairs) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Hash(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_hash_pattern(&mut self, node: &HashPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Elements) => { visit_node_list(self, &node.elements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::HashPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_heredoc(&mut self, node: &Heredoc) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            // skip heredoc_body_l
            // skip heredoc_end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Heredoc(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_if(&mut self, node: &If) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::IfTrue) => { if let Some(inner) = node.if_true.as_ref() { self.visit(inner); } }
            Some(PatternItem::IfFalse) => { if let Some(inner) = node.if_false.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip else_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::If(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_if_guard(&mut self, node: &IfGuard) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::IfGuard(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_i_flip_flop(&mut self, node: &IFlipFlop) {
        match self.pattern.unshift() {
            Some(PatternItem::Left) => { if let Some(inner) = node.left.as_ref() { self.visit(inner); } }
            Some(PatternItem::Right) => { if let Some(inner) = node.right.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::IFlipFlop(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_if_mod(&mut self, node: &IfMod) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::IfTrue) => { if let Some(inner) = node.if_true.as_ref() { self.visit(inner); } }
            Some(PatternItem::IfFalse) => { if let Some(inner) = node.if_false.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::IfMod(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_if_ternary(&mut self, node: &IfTernary) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::IfTrue) => { self.visit(&node.if_true); }
            Some(PatternItem::IfFalse) => { self.visit(&node.if_false); }
            // skip question_l
            // skip colon_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::IfTernary(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_index(&mut self, node: &Index) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            Some(PatternItem::Indexes) => { visit_node_list(self, &node.indexes) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Index(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_index_asgn(&mut self, node: &IndexAsgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            Some(PatternItem::Indexes) => { visit_node_list(self, &node.indexes) }
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip begin_l
            // skip end_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::IndexAsgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_in_pattern(&mut self, node: &InPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Pattern) => { self.visit(&node.pattern); }
            Some(PatternItem::Guard) => { if let Some(inner) = node.guard.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::InPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_int(&mut self, node: &Int) {
        match self.pattern.unshift() {
            // skip value
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Int(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_irange(&mut self, node: &Irange) {
        match self.pattern.unshift() {
            Some(PatternItem::Left) => { if let Some(inner) = node.left.as_ref() { self.visit(inner); } }
            Some(PatternItem::Right) => { if let Some(inner) = node.right.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Irange(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_ivar(&mut self, node: &Ivar) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Ivar(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_ivasgn(&mut self, node: &Ivasgn) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Ivasgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwarg(&mut self, node: &Kwarg) {
        match self.pattern.unshift() {
            // skip name
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwargs(&mut self, node: &Kwargs) {
        match self.pattern.unshift() {
            Some(PatternItem::Pairs) => { visit_node_list(self, &node.pairs) }
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwargs(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kw_begin(&mut self, node: &KwBegin) {
        match self.pattern.unshift() {
            Some(PatternItem::Stmts) => { visit_node_list(self, &node.statements) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::KwBegin(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwnilarg(&mut self, node: &Kwnilarg) {
        match self.pattern.unshift() {
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwnilarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwoptarg(&mut self, node: &Kwoptarg) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::DefaultValue) => { self.visit(&node.default); }
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwoptarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwrestarg(&mut self, node: &Kwrestarg) {
        match self.pattern.unshift() {
            // skip name
            // skip operator_l
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwrestarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_kwsplat(&mut self, node: &Kwsplat) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Kwsplat(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_lambda(&mut self, node: &Lambda) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Lambda(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_line(&mut self, node: &Line) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Line(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_lvar(&mut self, node: &Lvar) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Lvar(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_lvasgn(&mut self, node: &Lvasgn) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Lvasgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_masgn(&mut self, node: &Masgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Lhs) => { self.visit(&node.lhs); }
            Some(PatternItem::Rhs) => { self.visit(&node.rhs); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Masgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_alt(&mut self, node: &MatchAlt) {
        match self.pattern.unshift() {
            Some(PatternItem::Lhs) => { self.visit(&node.lhs); }
            Some(PatternItem::Rhs) => { self.visit(&node.rhs); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchAlt(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_as(&mut self, node: &MatchAs) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { self.visit(&node.value); }
            Some(PatternItem::As) => { self.visit(&node.as_); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchAs(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_current_line(&mut self, node: &MatchCurrentLine) {
        match self.pattern.unshift() {
            Some(PatternItem::Re) => { self.visit(&node.re); }
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchCurrentLine(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_nil_pattern(&mut self, node: &MatchNilPattern) {
        match self.pattern.unshift() {
            // skip operator_l
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchNilPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_pattern(&mut self, node: &MatchPattern) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { self.visit(&node.value); }
            Some(PatternItem::Pattern) => { self.visit(&node.pattern); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchPattern(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_pattern_p(&mut self, node: &MatchPatternP) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { self.visit(&node.value); }
            Some(PatternItem::Pattern) => { self.visit(&node.pattern); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchPatternP(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_rest(&mut self, node: &MatchRest) {
        match self.pattern.unshift() {
            Some(PatternItem::Name) => { if let Some(inner) = node.name.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchRest(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_var(&mut self, node: &MatchVar) {
        match self.pattern.unshift() {
            // skip name
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchVar(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Re) => { self.visit(&node.re); }
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::MatchWithLvasgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_mlhs(&mut self, node: &Mlhs) {
        match self.pattern.unshift() {
            Some(PatternItem::MlhsItems) => { visit_node_list(self, &node.items) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Mlhs(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_module(&mut self, node: &Module) {
        match self.pattern.unshift() {
            Some(PatternItem::Name) => { self.visit(&node.name); }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Module(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_next(&mut self, node: &Next) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Next(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_nil(&mut self, node: &Nil) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Nil(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_nth_ref(&mut self, node: &NthRef) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::NthRef(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_numblock(&mut self, node: &Numblock) {
        match self.pattern.unshift() {
            Some(PatternItem::MethodCall) => { self.visit(&node.call); }
            // skip numargs
            Some(PatternItem::Body) => { self.visit(&node.body); }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Numblock(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_op_asgn(&mut self, node: &OpAsgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            // skip operator
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::OpAsgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_optarg(&mut self, node: &Optarg) {
        match self.pattern.unshift() {
            // skip name
            Some(PatternItem::DefaultValue) => { self.visit(&node.default); }
            // skip name_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Optarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_or(&mut self, node: &Or) {
        match self.pattern.unshift() {
            Some(PatternItem::Lhs) => { self.visit(&node.lhs); }
            Some(PatternItem::Rhs) => { self.visit(&node.rhs); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Or(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_or_asgn(&mut self, node: &OrAsgn) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { self.visit(&node.recv); }
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::OrAsgn(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_pair(&mut self, node: &Pair) {
        match self.pattern.unshift() {
            Some(PatternItem::Key) => { self.visit(&node.key); }
            Some(PatternItem::Value) => { self.visit(&node.value); }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Pair(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_pin(&mut self, node: &Pin) {
        match self.pattern.unshift() {
            Some(PatternItem::Var) => { self.visit(&node.var); }
            // skip selector_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Pin(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_postexe(&mut self, node: &Postexe) {
        match self.pattern.unshift() {
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Postexe(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_preexe(&mut self, node: &Preexe) {
        match self.pattern.unshift() {
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Preexe(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_procarg0(&mut self, node: &Procarg0) {
        match self.pattern.unshift() {
            Some(PatternItem::Arglist) => { visit_node_list(self, &node.args) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Procarg0(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_rational(&mut self, node: &Rational) {
        match self.pattern.unshift() {
            // skip value
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Rational(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_redo(&mut self, node: &Redo) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Redo(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_regexp(&mut self, node: &Regexp) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            Some(PatternItem::Options) => { if let Some(inner) = node.options.as_ref() { self.visit(inner); } }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Regexp(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_reg_opt(&mut self, node: &RegOpt) {
        match self.pattern.unshift() {
            // skip options
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::RegOpt(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_rescue(&mut self, node: &Rescue) {
        match self.pattern.unshift() {
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            Some(PatternItem::RescueBodies) => { visit_node_list(self, &node.rescue_bodies) }
            Some(PatternItem::ElseBody) => { if let Some(inner) = node.else_.as_ref() { self.visit(inner); } }
            // skip else_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Rescue(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_rescue_body(&mut self, node: &RescueBody) {
        match self.pattern.unshift() {
            Some(PatternItem::ExcList) => { if let Some(inner) = node.exc_list.as_ref() { self.visit(inner); } }
            Some(PatternItem::ExcVar) => { if let Some(inner) = node.exc_var.as_ref() { self.visit(inner); } }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip assoc_l
            // skip begin_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::RescueBody(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_restarg(&mut self, node: &Restarg) {
        match self.pattern.unshift() {
            // skip name
            // skip operator_l
            // skip name_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Restarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_retry(&mut self, node: &Retry) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Retry(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_return(&mut self, node: &Return) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Return(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_s_class(&mut self, node: &SClass) {
        match self.pattern.unshift() {
            Some(PatternItem::Expr) => { self.visit(&node.expr); }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip operator_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::SClass(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_self_(&mut self, node: &Self_) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Self_(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_send(&mut self, node: &Send) {
        match self.pattern.unshift() {
            Some(PatternItem::Recv) => { if let Some(inner) = node.recv.as_ref() { self.visit(inner); } }
            // skip method_name
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip dot_l
            // skip selector_l
            // skip begin_l
            // skip end_l
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Send(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_shadowarg(&mut self, node: &Shadowarg) {
        match self.pattern.unshift() {
            // skip name
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Shadowarg(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_splat(&mut self, node: &Splat) {
        match self.pattern.unshift() {
            Some(PatternItem::Value) => { if let Some(inner) = node.value.as_ref() { self.visit(inner); } }
            // skip operator_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Splat(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_str(&mut self, node: &Str) {
        match self.pattern.unshift() {
            // skip value
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Str(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_super(&mut self, node: &Super) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Super(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_sym(&mut self, node: &Sym) {
        match self.pattern.unshift() {
            // skip name
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Sym(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_true(&mut self, node: &True) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::True(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_undef(&mut self, node: &Undef) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.names) }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Undef(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_unless_guard(&mut self, node: &UnlessGuard) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::UnlessGuard(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_until(&mut self, node: &Until) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Until(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_until_post(&mut self, node: &UntilPost) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::Body) => { self.visit(&node.body); }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::UntilPost(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_when(&mut self, node: &When) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.patterns) }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::When(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_while(&mut self, node: &While) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::Body) => { if let Some(inner) = node.body.as_ref() { self.visit(inner); } }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::While(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_while_post(&mut self, node: &WhilePost) {
        match self.pattern.unshift() {
            Some(PatternItem::Cond) => { self.visit(&node.cond); }
            Some(PatternItem::Body) => { self.visit(&node.body); }
            // skip keyword_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::WhilePost(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_x_heredoc(&mut self, node: &XHeredoc) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            // skip heredoc_body_l
            // skip heredoc_end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::XHeredoc(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_xstr(&mut self, node: &Xstr) {
        match self.pattern.unshift() {
            Some(PatternItem::Parts) => { visit_node_list(self, &node.parts) }
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Xstr(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_yield(&mut self, node: &Yield) {
        match self.pattern.unshift() {
            Some(PatternItem::Args) => { visit_node_list(self, &node.args) }
            // skip keyword_l
            // skip begin_l
            // skip end_l
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::Yield(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }
    fn on_z_super(&mut self, node: &ZSuper) {
        match self.pattern.unshift() {
            // skip expression_l
            None => {
                // end of the search chain, match
                self.result = Some(Node::ZSuper(node.clone()));
            }
            Some(_) => {
                // end of the search chain, no match
            }
        }
    }


    fn visit(&mut self, node: &Node) {
        match node {
            Node::Alias(inner) => {
                self.on_alias(inner);
            }
            Node::And(inner) => {
                self.on_and(inner);
            }
            Node::AndAsgn(inner) => {
                self.on_and_asgn(inner);
            }
            Node::Arg(inner) => {
                self.on_arg(inner);
            }
            Node::Args(inner) => {
                self.on_args(inner);
            }
            Node::Array(inner) => {
                self.on_array(inner);
            }
            Node::ArrayPattern(inner) => {
                self.on_array_pattern(inner);
            }
            Node::ArrayPatternWithTail(inner) => {
                self.on_array_pattern_with_tail(inner);
            }
            Node::BackRef(inner) => {
                self.on_back_ref(inner);
            }
            Node::Begin(inner) => {
                self.on_begin(inner);
            }
            Node::Block(inner) => {
                self.on_block(inner);
            }
            Node::Blockarg(inner) => {
                self.on_blockarg(inner);
            }
            Node::BlockPass(inner) => {
                self.on_block_pass(inner);
            }
            Node::Break(inner) => {
                self.on_break(inner);
            }
            Node::Case(inner) => {
                self.on_case(inner);
            }
            Node::CaseMatch(inner) => {
                self.on_case_match(inner);
            }
            Node::Casgn(inner) => {
                self.on_casgn(inner);
            }
            Node::Cbase(inner) => {
                self.on_cbase(inner);
            }
            Node::Class(inner) => {
                self.on_class(inner);
            }
            Node::Complex(inner) => {
                self.on_complex(inner);
            }
            Node::Const(inner) => {
                self.on_const(inner);
            }
            Node::ConstPattern(inner) => {
                self.on_const_pattern(inner);
            }
            Node::CSend(inner) => {
                self.on_c_send(inner);
            }
            Node::Cvar(inner) => {
                self.on_cvar(inner);
            }
            Node::Cvasgn(inner) => {
                self.on_cvasgn(inner);
            }
            Node::Def(inner) => {
                self.on_def(inner);
            }
            Node::Defined(inner) => {
                self.on_defined(inner);
            }
            Node::Defs(inner) => {
                self.on_defs(inner);
            }
            Node::Dstr(inner) => {
                self.on_dstr(inner);
            }
            Node::Dsym(inner) => {
                self.on_dsym(inner);
            }
            Node::EFlipFlop(inner) => {
                self.on_e_flip_flop(inner);
            }
            Node::EmptyElse(inner) => {
                self.on_empty_else(inner);
            }
            Node::Encoding(inner) => {
                self.on_encoding(inner);
            }
            Node::Ensure(inner) => {
                self.on_ensure(inner);
            }
            Node::Erange(inner) => {
                self.on_erange(inner);
            }
            Node::False(inner) => {
                self.on_false(inner);
            }
            Node::File(inner) => {
                self.on_file(inner);
            }
            Node::FindPattern(inner) => {
                self.on_find_pattern(inner);
            }
            Node::Float(inner) => {
                self.on_float(inner);
            }
            Node::For(inner) => {
                self.on_for(inner);
            }
            Node::ForwardArg(inner) => {
                self.on_forward_arg(inner);
            }
            Node::ForwardedArgs(inner) => {
                self.on_forwarded_args(inner);
            }
            Node::Gvar(inner) => {
                self.on_gvar(inner);
            }
            Node::Gvasgn(inner) => {
                self.on_gvasgn(inner);
            }
            Node::Hash(inner) => {
                self.on_hash(inner);
            }
            Node::HashPattern(inner) => {
                self.on_hash_pattern(inner);
            }
            Node::Heredoc(inner) => {
                self.on_heredoc(inner);
            }
            Node::If(inner) => {
                self.on_if(inner);
            }
            Node::IfGuard(inner) => {
                self.on_if_guard(inner);
            }
            Node::IFlipFlop(inner) => {
                self.on_i_flip_flop(inner);
            }
            Node::IfMod(inner) => {
                self.on_if_mod(inner);
            }
            Node::IfTernary(inner) => {
                self.on_if_ternary(inner);
            }
            Node::Index(inner) => {
                self.on_index(inner);
            }
            Node::IndexAsgn(inner) => {
                self.on_index_asgn(inner);
            }
            Node::InPattern(inner) => {
                self.on_in_pattern(inner);
            }
            Node::Int(inner) => {
                self.on_int(inner);
            }
            Node::Irange(inner) => {
                self.on_irange(inner);
            }
            Node::Ivar(inner) => {
                self.on_ivar(inner);
            }
            Node::Ivasgn(inner) => {
                self.on_ivasgn(inner);
            }
            Node::Kwarg(inner) => {
                self.on_kwarg(inner);
            }
            Node::Kwargs(inner) => {
                self.on_kwargs(inner);
            }
            Node::KwBegin(inner) => {
                self.on_kw_begin(inner);
            }
            Node::Kwnilarg(inner) => {
                self.on_kwnilarg(inner);
            }
            Node::Kwoptarg(inner) => {
                self.on_kwoptarg(inner);
            }
            Node::Kwrestarg(inner) => {
                self.on_kwrestarg(inner);
            }
            Node::Kwsplat(inner) => {
                self.on_kwsplat(inner);
            }
            Node::Lambda(inner) => {
                self.on_lambda(inner);
            }
            Node::Line(inner) => {
                self.on_line(inner);
            }
            Node::Lvar(inner) => {
                self.on_lvar(inner);
            }
            Node::Lvasgn(inner) => {
                self.on_lvasgn(inner);
            }
            Node::Masgn(inner) => {
                self.on_masgn(inner);
            }
            Node::MatchAlt(inner) => {
                self.on_match_alt(inner);
            }
            Node::MatchAs(inner) => {
                self.on_match_as(inner);
            }
            Node::MatchCurrentLine(inner) => {
                self.on_match_current_line(inner);
            }
            Node::MatchNilPattern(inner) => {
                self.on_match_nil_pattern(inner);
            }
            Node::MatchPattern(inner) => {
                self.on_match_pattern(inner);
            }
            Node::MatchPatternP(inner) => {
                self.on_match_pattern_p(inner);
            }
            Node::MatchRest(inner) => {
                self.on_match_rest(inner);
            }
            Node::MatchVar(inner) => {
                self.on_match_var(inner);
            }
            Node::MatchWithLvasgn(inner) => {
                self.on_match_with_lvasgn(inner);
            }
            Node::Mlhs(inner) => {
                self.on_mlhs(inner);
            }
            Node::Module(inner) => {
                self.on_module(inner);
            }
            Node::Next(inner) => {
                self.on_next(inner);
            }
            Node::Nil(inner) => {
                self.on_nil(inner);
            }
            Node::NthRef(inner) => {
                self.on_nth_ref(inner);
            }
            Node::Numblock(inner) => {
                self.on_numblock(inner);
            }
            Node::OpAsgn(inner) => {
                self.on_op_asgn(inner);
            }
            Node::Optarg(inner) => {
                self.on_optarg(inner);
            }
            Node::Or(inner) => {
                self.on_or(inner);
            }
            Node::OrAsgn(inner) => {
                self.on_or_asgn(inner);
            }
            Node::Pair(inner) => {
                self.on_pair(inner);
            }
            Node::Pin(inner) => {
                self.on_pin(inner);
            }
            Node::Postexe(inner) => {
                self.on_postexe(inner);
            }
            Node::Preexe(inner) => {
                self.on_preexe(inner);
            }
            Node::Procarg0(inner) => {
                self.on_procarg0(inner);
            }
            Node::Rational(inner) => {
                self.on_rational(inner);
            }
            Node::Redo(inner) => {
                self.on_redo(inner);
            }
            Node::Regexp(inner) => {
                self.on_regexp(inner);
            }
            Node::RegOpt(inner) => {
                self.on_reg_opt(inner);
            }
            Node::Rescue(inner) => {
                self.on_rescue(inner);
            }
            Node::RescueBody(inner) => {
                self.on_rescue_body(inner);
            }
            Node::Restarg(inner) => {
                self.on_restarg(inner);
            }
            Node::Retry(inner) => {
                self.on_retry(inner);
            }
            Node::Return(inner) => {
                self.on_return(inner);
            }
            Node::SClass(inner) => {
                self.on_s_class(inner);
            }
            Node::Self_(inner) => {
                self.on_self_(inner);
            }
            Node::Send(inner) => {
                self.on_send(inner);
            }
            Node::Shadowarg(inner) => {
                self.on_shadowarg(inner);
            }
            Node::Splat(inner) => {
                self.on_splat(inner);
            }
            Node::Str(inner) => {
                self.on_str(inner);
            }
            Node::Super(inner) => {
                self.on_super(inner);
            }
            Node::Sym(inner) => {
                self.on_sym(inner);
            }
            Node::True(inner) => {
                self.on_true(inner);
            }
            Node::Undef(inner) => {
                self.on_undef(inner);
            }
            Node::UnlessGuard(inner) => {
                self.on_unless_guard(inner);
            }
            Node::Until(inner) => {
                self.on_until(inner);
            }
            Node::UntilPost(inner) => {
                self.on_until_post(inner);
            }
            Node::When(inner) => {
                self.on_when(inner);
            }
            Node::While(inner) => {
                self.on_while(inner);
            }
            Node::WhilePost(inner) => {
                self.on_while_post(inner);
            }
            Node::XHeredoc(inner) => {
                self.on_x_heredoc(inner);
            }
            Node::Xstr(inner) => {
                self.on_xstr(inner);
            }
            Node::Yield(inner) => {
                self.on_yield(inner);
            }
            Node::ZSuper(inner) => {
                self.on_z_super(inner);
            }

        }
    }
}

fn visit_node_list(finder: &mut Finder, nodes: &[Node]) {
    if let Some(PatternItem::Idx(idx)) = finder.pattern.unshift() {
        if let Some(item) = nodes.get(idx) {
            finder.visit(item)
        }
    } else {
        // end of the search chain, no match
    }
}
