// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `super` call without arguments and parentheses
///
/// It's different from `super()` as it implicitly forwards current arguments
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ZSuper {
    /// Location of the `super` keyword
    ///
    /// ```text
    /// super
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for ZSuper {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "zsuper"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
