// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `yield` keyword
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Yield {
    /// A list of arguments given to `yield`
    pub args: Vec<Node>,

    /// Location of the `yield` keyword
    ///
    /// ```text
    /// yield 1, 2
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// yield(1, 2)
    ///      ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// yield(1, 2)
    ///           ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// yield(1, 2)
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Yield {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.args);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "yield"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.args.iter() { node.inner_ref().print_with_locs(); }
        self.keyword_l.print("keyword");
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
