// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `next` keyword
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Next {
    /// Arguments given to `next`
    pub args: Vec<Node>,

    /// Location of the `next` keyword
    ///
    /// ```text
    /// next 42
    /// ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// next(42)
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Next {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.args);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "next"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.args.iter() { node.inner_ref().print_with_locs(); }
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
