// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents access to a local variable (i.e. `foo`)
///
/// Parser knows that it's a local variable because:
/// 1. there was an assignment to this variable **before** accessing it
/// 2. it's an argument of the current method / block
/// 3. it's been implicitly declared by `MatchWithLvasgn` node
///
/// Otherwise it's a method call (see `Send`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Lvar {
    /// Name of the local variable
    pub name: String,

    /// Location of the local variable
    ///
    /// ```text
    /// foo
    /// ~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Lvar {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "lvar"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.expression_l.print("expression");
    }
}
