// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a keyword rest argument (i.e. `foo` in `def m(**foo); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwrestarg {
    /// Name of the keyword rest argument, `String("foo")` in `def m(**foo); end`.
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name: Option<String>,

    /// Location of the `**` operator
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(**foo); end
    ///         ~~~
    /// ```
    ///
    /// `None` if argument has no name (`def m(**); end`)
    pub name_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(**foo); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Kwrestarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_str(&self.name);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwrestarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.operator_l.print("operator");
        if let Some(loc) = self.name_l.as_ref() { loc.print("name") }
        self.expression_l.print("expression");
    }
}
