// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents an special argument that rejects all keyword arguments (i.e. `def m(**nil); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwnilarg {
    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Kwnilarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwnilarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
