// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an explicit `begin; end` block.
///
/// The reason why it's different is that
/// ```text
/// begin; foo; end while cond
/// ```
/// is a post-while loop (same with post-until loop)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct KwBegin {
    /// A list of statements
    pub statements: Vec<Node>,

    /// Location of the `begin` keyword
    ///
    /// ```text
    /// begin; foo; end
    /// ~~~~~
    /// ```
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// begin; foo; end
    ///             ~~~
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; foo; bar
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for KwBegin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.statements);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwbegin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.statements.iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
