// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents indexing operation (i.e. `foo[1,2,3]`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Index {
    /// Receiver of indexing
    pub recv: Box<Node>,

    /// A list of indexes
    pub indexes: Vec<Node>,

    /// Location of open bracket
    ///
    /// ```text
    /// foo[1, 2, 3]
    ///    ~
    /// ```
    pub begin_l: Loc,

    /// Location of closing bracket
    ///
    /// ```text
    /// foo[1, 2, 3]
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo[1, 2, 3]
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Index {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_nodes(&self.indexes);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "index"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        for node in self.indexes.iter() { node.inner_ref().print_with_locs(); }
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
