// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if`/`unless` modifier (i.e. `stmt if cond`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfMod {
    /// Condition of the modifier
    pub cond: Box<Node>,

    /// True-branch of the modifier.
    ///
    /// Always set for `if` modifier.
    /// Always `None` for `unless` modifier.
    pub if_true: Option<Box<Node>>,

    /// False-branch of the modifier.
    ///
    /// Always set for `unless` modifier.
    /// Always `None` for `if` modifier.
    pub if_false: Option<Box<Node>>,

    /// Location of the `if`/`unless` keyword
    ///
    /// ```text
    /// stmt if cond
    ///      ~~
    ///
    /// stmt unless cond
    ///      ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// stmt if cond
    /// ~~~~~~~~~~~~
    ///
    /// stmt unless cond
    /// ~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for IfMod {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_maybe_node_or_nil(&self.if_true);
        result.push_maybe_node_or_nil(&self.if_false);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        if let Some(node) = self.if_true.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.if_false.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
