// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `...` operator that contains forwarded argument (see `ForwardArg`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ForwardedArgs {
    /// Location of the `...`
    ///
    /// ```text
    /// def m(...); foo(...); end
    ///                 ~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for ForwardedArgs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "forwarded_args"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
