// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `for` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct For {
    /// Variable that is used in loop, `Lvasgn("a")` in `for a in b; end`
    pub iterator: Box<Node>,

    /// Collection that is for iteration. `Lvar("b")` in `for a in b; end`
    pub iteratee: Box<Node>,

    /// Body of the loop. `None` if there's no body
    pub body: Option<Box<Node>>,

    /// Location of the `for` keyword
    ///
    /// ```text
    /// for a in b; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `in` keyword
    ///
    /// ```text
    /// for a in b; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// for a in b do; end
    ///            ~~
    /// ```
    ///
    /// **Note**: this `do` is optional, and so `begin_l` can be `None`.
    pub begin_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// for a in b; end
    ///             ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// for a in b; end
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for For {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.iterator);
        result.push_node(&self.iteratee);
        result.push_maybe_node_or_nil(&self.body);





        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "for"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.iterator.inner_ref().print_with_locs();
        self.iteratee.inner_ref().print_with_locs();
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.operator_l.print("operator");
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
