// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a block of code with `ensure` (i.e. `begin; ensure; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Ensure {
    /// Block of code that is wrapped into `ensure`
    /// **Note**: that's the body of the `ensure` block
    ///
    /// `Int("1")` for `begin; 1; ensure; 2; end`
    pub body: Option<Box<Node>>,

    /// Body of the `ensure` block
    ///
    /// `Int("2")` for `begin; 1; ensure; 2; end`
    pub ensure: Option<Box<Node>>,

    /// Location of the `ensure` keyword
    ///
    /// ```text
    /// begin; ensure; end
    ///        ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue; 2; else; 3; ensure; 4; end
    ///        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    ///
    /// **Note**: begin/end belong to `KwBegin` node.
    pub expression_l: Loc,

}

impl InnerNode for Ensure {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.body);
        result.push_maybe_node_or_nil(&self.ensure);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "ensure"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.ensure.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
