// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents method definition using `def` keyword (not on a singleton, see `Defs` node).
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Def {
    /// Name of the method, `String("foo")` for `def foo; end`
    pub name: String,

    /// Arguments of a method, `None` if there's no arguments.
    ///
    /// All information about parentheses around arguments is stored in this node.
    pub args: Option<Box<Node>>,

    /// Body of a method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `def` keyword.
    ///
    /// ```text
    /// def foo; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the method name.
    ///
    /// ```text
    /// def foo; end
    ///     ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// def foo; end
    ///          ~~~
    /// ```
    ///
    /// `None` for endless method definition
    pub end_l: Option<Loc>,

    /// Location of the `=` operator for endless method definition
    ///
    /// ```text
    /// def m() = 1
    ///         ~
    /// ```
    ///
    /// `None` for regular method definition
    pub assignment_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(a); foo; end
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Def {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_maybe_node_or_nil(&self.args);
        result.push_maybe_node_or_nil(&self.body);





        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "def"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(node) = self.args.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.name_l.print("name");
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        if let Some(loc) = self.assignment_l.as_ref() { loc.print("assignment") }
        self.expression_l.print("expression");
    }
}
