// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents special global variables:
/// 1. `` $` ``
/// 2. `$&`
/// 3. `$'`
/// 4. `$+`
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct BackRef {
    /// Name of the variable (`"$+"` for `$+`)
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// $+
    /// ~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for BackRef {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "back_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.expression_l.print("expression");
    }
}
