// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an arguments list
///
/// `Args(vec![Arg("a"), Optarg("b", Int("1"))])` in `def m(a, b = 1); end`
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Args {
    /// List of arguments
    pub args: Vec<Node>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///      ~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///      ~
    /// ```
    ///
    /// `None` for code like `def m; end` or `def m arg; end`
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// def m(a, b = 1, c:, &blk); end
    ///                         ~
    /// ```
    ///
    /// `None` for code like `def m; end` or `def m arg; end`
    pub end_l: Option<Loc>,

}

impl InnerNode for Args {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.args);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "args"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.args.iter() { node.inner_ref().print_with_locs(); }
        self.expression_l.print("expression");
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
    }
}
