// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `foo && bar` (or `foo and bar`) statement.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct And {
    /// Left hand statament of the `&&` operation.
    ///
    /// `Lvar("foo")` node for `foo && bar`
    pub lhs: Box<Node>,

    /// Right hand statement of the `&&` operation.
    ///
    /// `Lvar("bar")` node for `foo && bar`
    pub rhs: Box<Node>,

    /// Location of the `&&` (or `and`) operator
    ///
    /// ```text
    /// a && b
    ///   ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// a && b
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for And {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.lhs);
        result.push_node(&self.rhs);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "and"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.lhs.inner_ref().print_with_locs();
        self.rhs.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
