use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

/// Enum of all possible diagnostic message (both warnings and errors)
#[derive(Debug, Clone, PartialEq, Eq)]
#[allow(missing_docs)]
#[repr(C)]
pub enum DiagnosticMessage {
{{ each message }}<dnl>
{{ helper message-comment }}
    {{ helper message-camelcase-name }} {
{{ each message-field }}<dnl>
{{ helper message-field-comment }}
        {{ helper message-field-name }}: {{ helper message-field-rust-field-type }}, <dnl>
{{ end }}
    },
{{ end }}<dnl>
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/messages/message_enum.rs", contents).unwrap();
}
