/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Skeleton implementation for Bison LALR(1) parsers in Rust

   Copyright (C) 2007-2015, 2018-2020 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */




use std::convert::TryInto;


/* "%code use" blocks.  */
/* "src/parser/parser.y":52  */


use alloc_from_pool::{Pool, PoolValue};
use crate::{ParserOptions, ParserResult};
use crate::{Token};
use crate::{Lexer, Builder, CurrentArgStack, StaticEnvironment, MaxNumparamStack, VariablesStack};
use crate::lex_states::*;
use crate::{SharedContext as ParserContext, context::Context};
use crate::builder::{LoopType, KeywordCmd, LogicalOp, PKwLabel, ArgsType};
use crate::builder::clone_value;
use crate::parse_value::ParseValue as Value;
use crate::parse_value::*;
use crate::Node;
use crate::nodes;
use crate::{Diagnostic, DiagnosticMessage, ErrorLevel};
use crate::error::Diagnostics;
use crate::source::token_rewriter::{TokenRewriter, TokenRewriterResult, LexStateAction, RewriteAction};
use crate::Loc;


/* "src/parser/parser.rs":66  */


/// A Bison parser, automatically generated from src/parser/parser.y.
#[derive(Debug)]
pub struct  Parser  {
    /// Lexer that is used to get tokens
    pub yylexer: Lexer,
    // true if verbose error messages are enabled.
    #[allow(dead_code)]
    yy_error_verbose: bool,
    // number of errors so far
    yynerrs: i32,

    yyerrstatus_: i32,

    /* "%code parser_fields" blocks.  */
/* "src/parser/parser.y":10  */

    result: Option<Box<Node>>,
    builder: Builder,
    current_arg_stack: CurrentArgStack,
    /// Stack of sets of variables in current scopes.
    /// Each stack item represents locals in the scope.
    ///
    /// You can use it to pre-define some locals and parse
    /// your input as if these locals exist.
    ///
    /// For example, you can parse the following code
    ///
    /// ```text
    /// a = b + c
    /// ```
    ///
    /// as
    ///
    /// ```text
    /// Send(LocalVar(a), "+", LocalVar(b))
    /// ```
    ///
    /// by declaring `a` and `b` as locals using
    ///
    /// ```text
    /// parser.static_env.declare("a")
    /// parser.static_env.declare("b")
    /// parser.parse()
    /// ```
    pub static_env: StaticEnvironment,
    context: ParserContext,
    last_token_type: i32,
    max_numparam_stack: MaxNumparamStack,
    pattern_variables: VariablesStack,
    pattern_hash_keys: VariablesStack,
    tokens: Vec<Token>,
    diagnostics: Diagnostics,
    token_rewriter: Option<TokenRewriter>,
    record_tokens: bool,
    tokens_pool: Pool<Token>,

/* "src/parser/parser.rs":125  */

}

#[inline]
fn i32_to_usize(v: i32) -> usize {
    v as usize
}

/// Maps token ID into human-readable name
pub fn token_name(id: i32) -> &'static str { /* ' */
    let first_token = Lexer::YYerror;
    if id > first_token + 1 {
        let pos: usize = (id - first_token + 1)
            .try_into()
            .expect("failed to cast token id into usize, is it negative?");
        Lexer::TOKEN_NAMES[pos]
    } else if id == 0 {
        "EOF"
    } else {
        panic!("token_name fails, {} (first token = {})", id, first_token)
    }
}

/// Local alias
type YYLoc = Loc;

impl  Parser  {
    // Version number for the Bison executable that generated this parser.
    #[allow(dead_code)]
    const BISON_VERSION: &'static str = "30802";

}


fn make_yylloc(rhs: &YYStack, n: usize) -> YYLoc {
    if 0 < n {
        YYLoc {
            begin: rhs.location_at(n - 1).begin,
            end: rhs.location_at(0).end
        }
    } else {
        YYLoc {
            begin: rhs.location_at(0).end,
            end: rhs.location_at(0).end
        }
    }
}

#[derive(Debug, Clone, PartialEq)]
pub struct SymbolKind { value: i32 }

impl SymbolKind {



    #[allow(non_upper_case_globals)]
    const S_YYEOF: i32 = 0;        /* "end-of-input"  */

    #[allow(non_upper_case_globals)]
    const S_YYerror: i32 = 1;      /* error  */

    #[allow(non_upper_case_globals)]
    const S_YYUNDEF: i32 = 2;      /* "invalid token"  */

    #[allow(non_upper_case_globals)]
    const S_kCLASS: i32 = 3;       /* "`class'"  */

    #[allow(non_upper_case_globals)]
    const S_kMODULE: i32 = 4;      /* "`module'"  */

    #[allow(non_upper_case_globals)]
    const S_kDEF: i32 = 5;         /* "`def'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNDEF: i32 = 6;       /* "`undef'"  */

    #[allow(non_upper_case_globals)]
    const S_kBEGIN: i32 = 7;       /* "`begin'"  */

    #[allow(non_upper_case_globals)]
    const S_kRESCUE: i32 = 8;      /* "`rescue'"  */

    #[allow(non_upper_case_globals)]
    const S_kENSURE: i32 = 9;      /* "`ensure'"  */

    #[allow(non_upper_case_globals)]
    const S_kEND: i32 = 10;        /* "`end'"  */

    #[allow(non_upper_case_globals)]
    const S_kIF: i32 = 11;         /* "`if'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNLESS: i32 = 12;     /* "`unless'"  */

    #[allow(non_upper_case_globals)]
    const S_kTHEN: i32 = 13;       /* "`then'"  */

    #[allow(non_upper_case_globals)]
    const S_kELSIF: i32 = 14;      /* "`elsif'"  */

    #[allow(non_upper_case_globals)]
    const S_kELSE: i32 = 15;       /* "`else'"  */

    #[allow(non_upper_case_globals)]
    const S_kCASE: i32 = 16;       /* "`case'"  */

    #[allow(non_upper_case_globals)]
    const S_kWHEN: i32 = 17;       /* "`when'"  */

    #[allow(non_upper_case_globals)]
    const S_kWHILE: i32 = 18;      /* "`while'"  */

    #[allow(non_upper_case_globals)]
    const S_kUNTIL: i32 = 19;      /* "`until'"  */

    #[allow(non_upper_case_globals)]
    const S_kFOR: i32 = 20;        /* "`for'"  */

    #[allow(non_upper_case_globals)]
    const S_kBREAK: i32 = 21;      /* "`break'"  */

    #[allow(non_upper_case_globals)]
    const S_kNEXT: i32 = 22;       /* "`next'"  */

    #[allow(non_upper_case_globals)]
    const S_kREDO: i32 = 23;       /* "`redo'"  */

    #[allow(non_upper_case_globals)]
    const S_kRETRY: i32 = 24;      /* "`retry'"  */

    #[allow(non_upper_case_globals)]
    const S_kIN: i32 = 25;         /* "`in'"  */

    #[allow(non_upper_case_globals)]
    const S_kDO: i32 = 26;         /* "`do'"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_COND: i32 = 27;    /* "`do' for condition"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_BLOCK: i32 = 28;   /* "`do' for block"  */

    #[allow(non_upper_case_globals)]
    const S_kDO_LAMBDA: i32 = 29;  /* "`do' for lambda"  */

    #[allow(non_upper_case_globals)]
    const S_kRETURN: i32 = 30;     /* "`return'"  */

    #[allow(non_upper_case_globals)]
    const S_kYIELD: i32 = 31;      /* "`yield'"  */

    #[allow(non_upper_case_globals)]
    const S_kSUPER: i32 = 32;      /* "`super'"  */

    #[allow(non_upper_case_globals)]
    const S_kSELF: i32 = 33;       /* "`self'"  */

    #[allow(non_upper_case_globals)]
    const S_kNIL: i32 = 34;        /* "`nil'"  */

    #[allow(non_upper_case_globals)]
    const S_kTRUE: i32 = 35;       /* "`true'"  */

    #[allow(non_upper_case_globals)]
    const S_kFALSE: i32 = 36;      /* "`false'"  */

    #[allow(non_upper_case_globals)]
    const S_kAND: i32 = 37;        /* "`and'"  */

    #[allow(non_upper_case_globals)]
    const S_kOR: i32 = 38;         /* "`or'"  */

    #[allow(non_upper_case_globals)]
    const S_kNOT: i32 = 39;        /* "`not'"  */

    #[allow(non_upper_case_globals)]
    const S_kIF_MOD: i32 = 40;     /* "`if' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kUNLESS_MOD: i32 = 41; /* "`unless' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kWHILE_MOD: i32 = 42;  /* "`while' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kUNTIL_MOD: i32 = 43;  /* "`until' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kRESCUE_MOD: i32 = 44; /* "`rescue' modifier"  */

    #[allow(non_upper_case_globals)]
    const S_kALIAS: i32 = 45;      /* "`alias'"  */

    #[allow(non_upper_case_globals)]
    const S_kDEFINED: i32 = 46;    /* "`defined?'"  */

    #[allow(non_upper_case_globals)]
    const S_klBEGIN: i32 = 47;     /* "`BEGIN'"  */

    #[allow(non_upper_case_globals)]
    const S_klEND: i32 = 48;       /* "`END'"  */

    #[allow(non_upper_case_globals)]
    const S_k__LINE__: i32 = 49;   /* "`__LINE__'"  */

    #[allow(non_upper_case_globals)]
    const S_k__FILE__: i32 = 50;   /* "`__FILE__'"  */

    #[allow(non_upper_case_globals)]
    const S_k__ENCODING__: i32 = 51; /* "`__ENCODING__'"  */

    #[allow(non_upper_case_globals)]
    const S_tIDENTIFIER: i32 = 52; /* "local variable or method"  */

    #[allow(non_upper_case_globals)]
    const S_tFID: i32 = 53;        /* "method"  */

    #[allow(non_upper_case_globals)]
    const S_tGVAR: i32 = 54;       /* "global variable"  */

    #[allow(non_upper_case_globals)]
    const S_tIVAR: i32 = 55;       /* "instance variable"  */

    #[allow(non_upper_case_globals)]
    const S_tCONSTANT: i32 = 56;   /* "constant"  */

    #[allow(non_upper_case_globals)]
    const S_tCVAR: i32 = 57;       /* "class variable"  */

    #[allow(non_upper_case_globals)]
    const S_tLABEL: i32 = 58;      /* "label"  */

    #[allow(non_upper_case_globals)]
    const S_tINTEGER: i32 = 59;    /* "integer literal"  */

    #[allow(non_upper_case_globals)]
    const S_tFLOAT: i32 = 60;      /* "float literal"  */

    #[allow(non_upper_case_globals)]
    const S_tRATIONAL: i32 = 61;   /* "rational literal"  */

    #[allow(non_upper_case_globals)]
    const S_tIMAGINARY: i32 = 62;  /* "imaginary literal"  */

    #[allow(non_upper_case_globals)]
    const S_tCHAR: i32 = 63;       /* "char literal"  */

    #[allow(non_upper_case_globals)]
    const S_tNTH_REF: i32 = 64;    /* "numbered reference"  */

    #[allow(non_upper_case_globals)]
    const S_tBACK_REF: i32 = 65;   /* "back reference"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_CONTENT: i32 = 66; /* "literal content"  */

    #[allow(non_upper_case_globals)]
    const S_tREGEXP_END: i32 = 67; /* tREGEXP_END  */

    #[allow(non_upper_case_globals)]
    const S_tDOT: i32 = 68;        /* tDOT  */

    #[allow(non_upper_case_globals)]
    const S_tBACKSLASH: i32 = 69;  /* "backslash"  */

    #[allow(non_upper_case_globals)]
    const S_tSP: i32 = 70;         /* "escaped space"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_T: i32 = 71;    /* "escaped horizontal tab"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_F: i32 = 72;    /* "escaped form feed"  */

    #[allow(non_upper_case_globals)]
    const S_tSLASH_R: i32 = 73;    /* "escaped carriage return"  */

    #[allow(non_upper_case_globals)]
    const S_tVTAB: i32 = 74;       /* "escaped vertical tab"  */

    #[allow(non_upper_case_globals)]
    const S_tUPLUS: i32 = 75;      /* "unary+"  */

    #[allow(non_upper_case_globals)]
    const S_tUMINUS: i32 = 76;     /* "unary-"  */

    #[allow(non_upper_case_globals)]
    const S_tPOW: i32 = 77;        /* "**"  */

    #[allow(non_upper_case_globals)]
    const S_tCMP: i32 = 78;        /* "<=>"  */

    #[allow(non_upper_case_globals)]
    const S_tEQ: i32 = 79;         /* "=="  */

    #[allow(non_upper_case_globals)]
    const S_tEQQ: i32 = 80;        /* "==="  */

    #[allow(non_upper_case_globals)]
    const S_tNEQ: i32 = 81;        /* "!="  */

    #[allow(non_upper_case_globals)]
    const S_tGEQ: i32 = 82;        /* ">="  */

    #[allow(non_upper_case_globals)]
    const S_tLEQ: i32 = 83;        /* "<="  */

    #[allow(non_upper_case_globals)]
    const S_tANDOP: i32 = 84;      /* "&&"  */

    #[allow(non_upper_case_globals)]
    const S_tOROP: i32 = 85;       /* "||"  */

    #[allow(non_upper_case_globals)]
    const S_tMATCH: i32 = 86;      /* "=~"  */

    #[allow(non_upper_case_globals)]
    const S_tNMATCH: i32 = 87;     /* "!~"  */

    #[allow(non_upper_case_globals)]
    const S_tDOT2: i32 = 88;       /* ".."  */

    #[allow(non_upper_case_globals)]
    const S_tDOT3: i32 = 89;       /* "..."  */

    #[allow(non_upper_case_globals)]
    const S_tBDOT2: i32 = 90;      /* "(.."  */

    #[allow(non_upper_case_globals)]
    const S_tBDOT3: i32 = 91;      /* "(..."  */

    #[allow(non_upper_case_globals)]
    const S_tAREF: i32 = 92;       /* "[]"  */

    #[allow(non_upper_case_globals)]
    const S_tASET: i32 = 93;       /* "[]="  */

    #[allow(non_upper_case_globals)]
    const S_tLSHFT: i32 = 94;      /* "<<"  */

    #[allow(non_upper_case_globals)]
    const S_tRSHFT: i32 = 95;      /* ">>"  */

    #[allow(non_upper_case_globals)]
    const S_tANDDOT: i32 = 96;     /* "&."  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON2: i32 = 97;     /* "::"  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON3: i32 = 98;     /* ":: at EXPR_BEG"  */

    #[allow(non_upper_case_globals)]
    const S_tOP_ASGN: i32 = 99;    /* "operator-assignment"  */

    #[allow(non_upper_case_globals)]
    const S_tASSOC: i32 = 100;     /* "=>"  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN: i32 = 101;    /* "("  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN_ARG: i32 = 102; /* "( arg"  */

    #[allow(non_upper_case_globals)]
    const S_tRPAREN: i32 = 103;    /* ")"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACK: i32 = 104;    /* "["  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACE: i32 = 105;    /* "{"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACE_ARG: i32 = 106; /* "{ arg"  */

    #[allow(non_upper_case_globals)]
    const S_tSTAR: i32 = 107;      /* "*"  */

    #[allow(non_upper_case_globals)]
    const S_tDSTAR: i32 = 108;     /* "**arg"  */

    #[allow(non_upper_case_globals)]
    const S_tAMPER: i32 = 109;     /* "&"  */

    #[allow(non_upper_case_globals)]
    const S_tLAMBDA: i32 = 110;    /* "->"  */

    #[allow(non_upper_case_globals)]
    const S_tSYMBEG: i32 = 111;    /* "symbol literal"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_BEG: i32 = 112; /* "string begin"  */

    #[allow(non_upper_case_globals)]
    const S_tXSTRING_BEG: i32 = 113; /* "backtick literal"  */

    #[allow(non_upper_case_globals)]
    const S_tREGEXP_BEG: i32 = 114; /* "regexp literal"  */

    #[allow(non_upper_case_globals)]
    const S_tWORDS_BEG: i32 = 115; /* "word list"  */

    #[allow(non_upper_case_globals)]
    const S_tQWORDS_BEG: i32 = 116; /* "verbatim word list"  */

    #[allow(non_upper_case_globals)]
    const S_tSYMBOLS_BEG: i32 = 117; /* "symbol list"  */

    #[allow(non_upper_case_globals)]
    const S_tQSYMBOLS_BEG: i32 = 118; /* "verbatim symbol list"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_END: i32 = 119; /* "string end"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DEND: i32 = 120; /* "tRCURLY"  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DBEG: i32 = 121; /* tSTRING_DBEG  */

    #[allow(non_upper_case_globals)]
    const S_tSTRING_DVAR: i32 = 122; /* tSTRING_DVAR  */

    #[allow(non_upper_case_globals)]
    const S_tLAMBEG: i32 = 123;    /* tLAMBEG  */

    #[allow(non_upper_case_globals)]
    const S_tLABEL_END: i32 = 124; /* tLABEL_END  */

    #[allow(non_upper_case_globals)]
    const S_tCOMMA: i32 = 125;     /* ","  */

    #[allow(non_upper_case_globals)]
    const S_tLCURLY: i32 = 126;    /* "{ (tLCURLY)"  */

    #[allow(non_upper_case_globals)]
    const S_tRCURLY: i32 = 127;    /* "}"  */

    #[allow(non_upper_case_globals)]
    const S_tLBRACK2: i32 = 128;   /* "[ (tLBRACK2)"  */

    #[allow(non_upper_case_globals)]
    const S_tEQL: i32 = 129;       /* "="  */

    #[allow(non_upper_case_globals)]
    const S_tPIPE: i32 = 130;      /* "|"  */

    #[allow(non_upper_case_globals)]
    const S_tAMPER2: i32 = 131;    /* "& (tAMPER2)"  */

    #[allow(non_upper_case_globals)]
    const S_tGT: i32 = 132;        /* ">"  */

    #[allow(non_upper_case_globals)]
    const S_tLT: i32 = 133;        /* "<"  */

    #[allow(non_upper_case_globals)]
    const S_tBACK_REF2: i32 = 134; /* "`"  */

    #[allow(non_upper_case_globals)]
    const S_tCARET: i32 = 135;     /* "^"  */

    #[allow(non_upper_case_globals)]
    const S_tLPAREN2: i32 = 136;   /* "( (tLPAREN2)"  */

    #[allow(non_upper_case_globals)]
    const S_tRBRACK: i32 = 137;    /* "]"  */

    #[allow(non_upper_case_globals)]
    const S_tSEMI: i32 = 138;      /* ";"  */

    #[allow(non_upper_case_globals)]
    const S_tSPACE: i32 = 139;     /* " "  */

    #[allow(non_upper_case_globals)]
    const S_tNL: i32 = 140;        /* "\n"  */

    #[allow(non_upper_case_globals)]
    const S_tPLUS: i32 = 141;      /* "+"  */

    #[allow(non_upper_case_globals)]
    const S_tMINUS: i32 = 142;     /* "-"  */

    #[allow(non_upper_case_globals)]
    const S_tSTAR2: i32 = 143;     /* "* (tSTAR2)"  */

    #[allow(non_upper_case_globals)]
    const S_tDIVIDE: i32 = 144;    /* "/"  */

    #[allow(non_upper_case_globals)]
    const S_tPERCENT: i32 = 145;   /* "%"  */

    #[allow(non_upper_case_globals)]
    const S_tTILDE: i32 = 146;     /* "~"  */

    #[allow(non_upper_case_globals)]
    const S_tBANG: i32 = 147;      /* "!"  */

    #[allow(non_upper_case_globals)]
    const S_tLOWEST: i32 = 148;    /* tLOWEST  */

    #[allow(non_upper_case_globals)]
    const S_tEH: i32 = 149;        /* tEH  */

    #[allow(non_upper_case_globals)]
    const S_tCOLON: i32 = 150;     /* tCOLON  */

    #[allow(non_upper_case_globals)]
    const S_tUMINUS_NUM: i32 = 151; /* tUMINUS_NUM  */

    #[allow(non_upper_case_globals)]
    const S_tLAST_TOKEN: i32 = 152; /* tLAST_TOKEN  */

    #[allow(non_upper_case_globals)]
    const S_YYACCEPT: i32 = 153;   /* $accept  */

    #[allow(non_upper_case_globals)]
    const S_program: i32 = 154;    /* program  */

    #[allow(non_upper_case_globals)]
    const S_155_1: i32 = 155;      /* @1  */

    #[allow(non_upper_case_globals)]
    const S_top_compstmt: i32 = 156; /* top_compstmt  */

    #[allow(non_upper_case_globals)]
    const S_top_stmts: i32 = 157;  /* top_stmts  */

    #[allow(non_upper_case_globals)]
    const S_top_stmt: i32 = 158;   /* top_stmt  */

    #[allow(non_upper_case_globals)]
    const S_begin_block: i32 = 159; /* begin_block  */

    #[allow(non_upper_case_globals)]
    const S_bodystmt: i32 = 160;   /* bodystmt  */

    #[allow(non_upper_case_globals)]
    const S_compstmt: i32 = 161;   /* compstmt  */

    #[allow(non_upper_case_globals)]
    const S_stmts: i32 = 162;      /* stmts  */

    #[allow(non_upper_case_globals)]
    const S_stmt_or_begin: i32 = 163; /* stmt_or_begin  */

    #[allow(non_upper_case_globals)]
    const S_164_2: i32 = 164;      /* $@2  */

    #[allow(non_upper_case_globals)]
    const S_stmt: i32 = 165;       /* stmt  */

    #[allow(non_upper_case_globals)]
    const S_166_3: i32 = 166;      /* @3  */

    #[allow(non_upper_case_globals)]
    const S_command_asgn: i32 = 167; /* command_asgn  */

    #[allow(non_upper_case_globals)]
    const S_command_rhs: i32 = 168; /* command_rhs  */

    #[allow(non_upper_case_globals)]
    const S_expr: i32 = 169;       /* expr  */

    #[allow(non_upper_case_globals)]
    const S_170_4: i32 = 170;      /* @4  */

    #[allow(non_upper_case_globals)]
    const S_171_5: i32 = 171;      /* @5  */

    #[allow(non_upper_case_globals)]
    const S_def_name: i32 = 172;   /* def_name  */

    #[allow(non_upper_case_globals)]
    const S_defn_head: i32 = 173;  /* defn_head  */

    #[allow(non_upper_case_globals)]
    const S_defs_head: i32 = 174;  /* defs_head  */

    #[allow(non_upper_case_globals)]
    const S_175_6: i32 = 175;      /* @6  */

    #[allow(non_upper_case_globals)]
    const S_expr_value: i32 = 176; /* expr_value  */

    #[allow(non_upper_case_globals)]
    const S_expr_value_do: i32 = 177; /* expr_value_do  */

    #[allow(non_upper_case_globals)]
    const S_178_7: i32 = 178;      /* @7  */

    #[allow(non_upper_case_globals)]
    const S_command_call: i32 = 179; /* command_call  */

    #[allow(non_upper_case_globals)]
    const S_block_command: i32 = 180; /* block_command  */

    #[allow(non_upper_case_globals)]
    const S_cmd_brace_block: i32 = 181; /* cmd_brace_block  */

    #[allow(non_upper_case_globals)]
    const S_182_8: i32 = 182;      /* @8  */

    #[allow(non_upper_case_globals)]
    const S_fcall: i32 = 183;      /* fcall  */

    #[allow(non_upper_case_globals)]
    const S_command: i32 = 184;    /* command  */

    #[allow(non_upper_case_globals)]
    const S_mlhs: i32 = 185;       /* mlhs  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_inner: i32 = 186; /* mlhs_inner  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_basic: i32 = 187; /* mlhs_basic  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_item: i32 = 188;  /* mlhs_item  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_head: i32 = 189;  /* mlhs_head  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_post: i32 = 190;  /* mlhs_post  */

    #[allow(non_upper_case_globals)]
    const S_mlhs_node: i32 = 191;  /* mlhs_node  */

    #[allow(non_upper_case_globals)]
    const S_lhs: i32 = 192;        /* lhs  */

    #[allow(non_upper_case_globals)]
    const S_cname: i32 = 193;      /* cname  */

    #[allow(non_upper_case_globals)]
    const S_cpath: i32 = 194;      /* cpath  */

    #[allow(non_upper_case_globals)]
    const S_fname: i32 = 195;      /* fname  */

    #[allow(non_upper_case_globals)]
    const S_fitem: i32 = 196;      /* fitem  */

    #[allow(non_upper_case_globals)]
    const S_undef_list: i32 = 197; /* undef_list  */

    #[allow(non_upper_case_globals)]
    const S_198_9: i32 = 198;      /* @9  */

    #[allow(non_upper_case_globals)]
    const S_op: i32 = 199;         /* op  */

    #[allow(non_upper_case_globals)]
    const S_reswords: i32 = 200;   /* reswords  */

    #[allow(non_upper_case_globals)]
    const S_arg: i32 = 201;        /* arg  */

    #[allow(non_upper_case_globals)]
    const S_202_10: i32 = 202;     /* @10  */

    #[allow(non_upper_case_globals)]
    const S_relop: i32 = 203;      /* relop  */

    #[allow(non_upper_case_globals)]
    const S_rel_expr: i32 = 204;   /* rel_expr  */

    #[allow(non_upper_case_globals)]
    const S_arg_value: i32 = 205;  /* arg_value  */

    #[allow(non_upper_case_globals)]
    const S_aref_args: i32 = 206;  /* aref_args  */

    #[allow(non_upper_case_globals)]
    const S_arg_rhs: i32 = 207;    /* arg_rhs  */

    #[allow(non_upper_case_globals)]
    const S_paren_args: i32 = 208; /* paren_args  */

    #[allow(non_upper_case_globals)]
    const S_opt_paren_args: i32 = 209; /* opt_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_opt_call_args: i32 = 210; /* opt_call_args  */

    #[allow(non_upper_case_globals)]
    const S_call_args: i32 = 211;  /* call_args  */

    #[allow(non_upper_case_globals)]
    const S_command_args: i32 = 212; /* command_args  */

    #[allow(non_upper_case_globals)]
    const S_213_11: i32 = 213;     /* @11  */

    #[allow(non_upper_case_globals)]
    const S_block_arg: i32 = 214;  /* block_arg  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_arg: i32 = 215; /* opt_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_args: i32 = 216;       /* args  */

    #[allow(non_upper_case_globals)]
    const S_mrhs_arg: i32 = 217;   /* mrhs_arg  */

    #[allow(non_upper_case_globals)]
    const S_mrhs: i32 = 218;       /* mrhs  */

    #[allow(non_upper_case_globals)]
    const S_primary: i32 = 219;    /* primary  */

    #[allow(non_upper_case_globals)]
    const S_220_12: i32 = 220;     /* @12  */

    #[allow(non_upper_case_globals)]
    const S_221_13: i32 = 221;     /* @13  */

    #[allow(non_upper_case_globals)]
    const S_222_14: i32 = 222;     /* @14  */

    #[allow(non_upper_case_globals)]
    const S_223_15: i32 = 223;     /* @15  */

    #[allow(non_upper_case_globals)]
    const S_224_16: i32 = 224;     /* @16  */

    #[allow(non_upper_case_globals)]
    const S_225_17: i32 = 225;     /* @17  */

    #[allow(non_upper_case_globals)]
    const S_226_18: i32 = 226;     /* @18  */

    #[allow(non_upper_case_globals)]
    const S_227_19: i32 = 227;     /* @19  */

    #[allow(non_upper_case_globals)]
    const S_228_20: i32 = 228;     /* @20  */

    #[allow(non_upper_case_globals)]
    const S_primary_value: i32 = 229; /* primary_value  */

    #[allow(non_upper_case_globals)]
    const S_k_begin: i32 = 230;    /* k_begin  */

    #[allow(non_upper_case_globals)]
    const S_k_if: i32 = 231;       /* k_if  */

    #[allow(non_upper_case_globals)]
    const S_k_unless: i32 = 232;   /* k_unless  */

    #[allow(non_upper_case_globals)]
    const S_k_while: i32 = 233;    /* k_while  */

    #[allow(non_upper_case_globals)]
    const S_k_until: i32 = 234;    /* k_until  */

    #[allow(non_upper_case_globals)]
    const S_k_case: i32 = 235;     /* k_case  */

    #[allow(non_upper_case_globals)]
    const S_k_for: i32 = 236;      /* k_for  */

    #[allow(non_upper_case_globals)]
    const S_k_class: i32 = 237;    /* k_class  */

    #[allow(non_upper_case_globals)]
    const S_k_module: i32 = 238;   /* k_module  */

    #[allow(non_upper_case_globals)]
    const S_k_def: i32 = 239;      /* k_def  */

    #[allow(non_upper_case_globals)]
    const S_k_do: i32 = 240;       /* k_do  */

    #[allow(non_upper_case_globals)]
    const S_k_do_block: i32 = 241; /* k_do_block  */

    #[allow(non_upper_case_globals)]
    const S_k_rescue: i32 = 242;   /* k_rescue  */

    #[allow(non_upper_case_globals)]
    const S_k_ensure: i32 = 243;   /* k_ensure  */

    #[allow(non_upper_case_globals)]
    const S_k_when: i32 = 244;     /* k_when  */

    #[allow(non_upper_case_globals)]
    const S_k_else: i32 = 245;     /* k_else  */

    #[allow(non_upper_case_globals)]
    const S_k_elsif: i32 = 246;    /* k_elsif  */

    #[allow(non_upper_case_globals)]
    const S_k_end: i32 = 247;      /* k_end  */

    #[allow(non_upper_case_globals)]
    const S_k_return: i32 = 248;   /* k_return  */

    #[allow(non_upper_case_globals)]
    const S_then: i32 = 249;       /* then  */

    #[allow(non_upper_case_globals)]
    const S_do: i32 = 250;         /* do  */

    #[allow(non_upper_case_globals)]
    const S_if_tail: i32 = 251;    /* if_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_else: i32 = 252;   /* opt_else  */

    #[allow(non_upper_case_globals)]
    const S_for_var: i32 = 253;    /* for_var  */

    #[allow(non_upper_case_globals)]
    const S_f_marg: i32 = 254;     /* f_marg  */

    #[allow(non_upper_case_globals)]
    const S_f_marg_list: i32 = 255; /* f_marg_list  */

    #[allow(non_upper_case_globals)]
    const S_f_margs: i32 = 256;    /* f_margs  */

    #[allow(non_upper_case_globals)]
    const S_f_rest_marg: i32 = 257; /* f_rest_marg  */

    #[allow(non_upper_case_globals)]
    const S_f_any_kwrest: i32 = 258; /* f_any_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_f_eq: i32 = 259;       /* f_eq  */

    #[allow(non_upper_case_globals)]
    const S_260_21: i32 = 260;     /* @21  */

    #[allow(non_upper_case_globals)]
    const S_block_args_tail: i32 = 261; /* block_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_args_tail: i32 = 262; /* opt_block_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_excessed_comma: i32 = 263; /* excessed_comma  */

    #[allow(non_upper_case_globals)]
    const S_block_param: i32 = 264; /* block_param  */

    #[allow(non_upper_case_globals)]
    const S_opt_block_param: i32 = 265; /* opt_block_param  */

    #[allow(non_upper_case_globals)]
    const S_block_param_def: i32 = 266; /* block_param_def  */

    #[allow(non_upper_case_globals)]
    const S_opt_bv_decl: i32 = 267; /* opt_bv_decl  */

    #[allow(non_upper_case_globals)]
    const S_bv_decls: i32 = 268;   /* bv_decls  */

    #[allow(non_upper_case_globals)]
    const S_bvar: i32 = 269;       /* bvar  */

    #[allow(non_upper_case_globals)]
    const S_lambda: i32 = 270;     /* lambda  */

    #[allow(non_upper_case_globals)]
    const S_271_22: i32 = 271;     /* @22  */

    #[allow(non_upper_case_globals)]
    const S_272_23: i32 = 272;     /* @23  */

    #[allow(non_upper_case_globals)]
    const S_273_24: i32 = 273;     /* @24  */

    #[allow(non_upper_case_globals)]
    const S_f_larglist: i32 = 274; /* f_larglist  */

    #[allow(non_upper_case_globals)]
    const S_lambda_body: i32 = 275; /* lambda_body  */

    #[allow(non_upper_case_globals)]
    const S_276_25: i32 = 276;     /* @25  */

    #[allow(non_upper_case_globals)]
    const S_277_26: i32 = 277;     /* @26  */

    #[allow(non_upper_case_globals)]
    const S_do_block: i32 = 278;   /* do_block  */

    #[allow(non_upper_case_globals)]
    const S_279_27: i32 = 279;     /* @27  */

    #[allow(non_upper_case_globals)]
    const S_block_call: i32 = 280; /* block_call  */

    #[allow(non_upper_case_globals)]
    const S_method_call: i32 = 281; /* method_call  */

    #[allow(non_upper_case_globals)]
    const S_brace_block: i32 = 282; /* brace_block  */

    #[allow(non_upper_case_globals)]
    const S_283_28: i32 = 283;     /* @28  */

    #[allow(non_upper_case_globals)]
    const S_284_29: i32 = 284;     /* @29  */

    #[allow(non_upper_case_globals)]
    const S_brace_body: i32 = 285; /* brace_body  */

    #[allow(non_upper_case_globals)]
    const S_286_30: i32 = 286;     /* @30  */

    #[allow(non_upper_case_globals)]
    const S_do_body: i32 = 287;    /* do_body  */

    #[allow(non_upper_case_globals)]
    const S_288_31: i32 = 288;     /* @31  */

    #[allow(non_upper_case_globals)]
    const S_case_args: i32 = 289;  /* case_args  */

    #[allow(non_upper_case_globals)]
    const S_case_body: i32 = 290;  /* case_body  */

    #[allow(non_upper_case_globals)]
    const S_cases: i32 = 291;      /* cases  */

    #[allow(non_upper_case_globals)]
    const S_p_case_body: i32 = 292; /* p_case_body  */

    #[allow(non_upper_case_globals)]
    const S_293_32: i32 = 293;     /* @32  */

    #[allow(non_upper_case_globals)]
    const S_294_33: i32 = 294;     /* @33  */

    #[allow(non_upper_case_globals)]
    const S_p_cases: i32 = 295;    /* p_cases  */

    #[allow(non_upper_case_globals)]
    const S_p_top_expr: i32 = 296; /* p_top_expr  */

    #[allow(non_upper_case_globals)]
    const S_p_top_expr_body: i32 = 297; /* p_top_expr_body  */

    #[allow(non_upper_case_globals)]
    const S_p_expr: i32 = 298;     /* p_expr  */

    #[allow(non_upper_case_globals)]
    const S_p_as: i32 = 299;       /* p_as  */

    #[allow(non_upper_case_globals)]
    const S_p_alt: i32 = 300;      /* p_alt  */

    #[allow(non_upper_case_globals)]
    const S_p_lparen: i32 = 301;   /* p_lparen  */

    #[allow(non_upper_case_globals)]
    const S_p_lbracket: i32 = 302; /* p_lbracket  */

    #[allow(non_upper_case_globals)]
    const S_p_expr_basic: i32 = 303; /* p_expr_basic  */

    #[allow(non_upper_case_globals)]
    const S_304_34: i32 = 304;     /* @34  */

    #[allow(non_upper_case_globals)]
    const S_305_35: i32 = 305;     /* @35  */

    #[allow(non_upper_case_globals)]
    const S_p_args: i32 = 306;     /* p_args  */

    #[allow(non_upper_case_globals)]
    const S_p_args_head: i32 = 307; /* p_args_head  */

    #[allow(non_upper_case_globals)]
    const S_p_args_tail: i32 = 308; /* p_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_p_find: i32 = 309;     /* p_find  */

    #[allow(non_upper_case_globals)]
    const S_p_rest: i32 = 310;     /* p_rest  */

    #[allow(non_upper_case_globals)]
    const S_p_args_post: i32 = 311; /* p_args_post  */

    #[allow(non_upper_case_globals)]
    const S_p_arg: i32 = 312;      /* p_arg  */

    #[allow(non_upper_case_globals)]
    const S_p_kwargs: i32 = 313;   /* p_kwargs  */

    #[allow(non_upper_case_globals)]
    const S_p_kwarg: i32 = 314;    /* p_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_p_kw: i32 = 315;       /* p_kw  */

    #[allow(non_upper_case_globals)]
    const S_p_kw_label: i32 = 316; /* p_kw_label  */

    #[allow(non_upper_case_globals)]
    const S_p_kwrest: i32 = 317;   /* p_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_p_kwnorest: i32 = 318; /* p_kwnorest  */

    #[allow(non_upper_case_globals)]
    const S_p_any_kwrest: i32 = 319; /* p_any_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_p_value: i32 = 320;    /* p_value  */

    #[allow(non_upper_case_globals)]
    const S_p_primitive: i32 = 321; /* p_primitive  */

    #[allow(non_upper_case_globals)]
    const S_p_variable: i32 = 322; /* p_variable  */

    #[allow(non_upper_case_globals)]
    const S_p_var_ref: i32 = 323;  /* p_var_ref  */

    #[allow(non_upper_case_globals)]
    const S_p_expr_ref: i32 = 324; /* p_expr_ref  */

    #[allow(non_upper_case_globals)]
    const S_p_const: i32 = 325;    /* p_const  */

    #[allow(non_upper_case_globals)]
    const S_opt_rescue: i32 = 326; /* opt_rescue  */

    #[allow(non_upper_case_globals)]
    const S_exc_list: i32 = 327;   /* exc_list  */

    #[allow(non_upper_case_globals)]
    const S_exc_var: i32 = 328;    /* exc_var  */

    #[allow(non_upper_case_globals)]
    const S_opt_ensure: i32 = 329; /* opt_ensure  */

    #[allow(non_upper_case_globals)]
    const S_literal: i32 = 330;    /* literal  */

    #[allow(non_upper_case_globals)]
    const S_strings: i32 = 331;    /* strings  */

    #[allow(non_upper_case_globals)]
    const S_string: i32 = 332;     /* string  */

    #[allow(non_upper_case_globals)]
    const S_string1: i32 = 333;    /* string1  */

    #[allow(non_upper_case_globals)]
    const S_xstring: i32 = 334;    /* xstring  */

    #[allow(non_upper_case_globals)]
    const S_regexp: i32 = 335;     /* regexp  */

    #[allow(non_upper_case_globals)]
    const S_words: i32 = 336;      /* words  */

    #[allow(non_upper_case_globals)]
    const S_word_list: i32 = 337;  /* word_list  */

    #[allow(non_upper_case_globals)]
    const S_word: i32 = 338;       /* word  */

    #[allow(non_upper_case_globals)]
    const S_symbols: i32 = 339;    /* symbols  */

    #[allow(non_upper_case_globals)]
    const S_symbol_list: i32 = 340; /* symbol_list  */

    #[allow(non_upper_case_globals)]
    const S_qwords: i32 = 341;     /* qwords  */

    #[allow(non_upper_case_globals)]
    const S_qsymbols: i32 = 342;   /* qsymbols  */

    #[allow(non_upper_case_globals)]
    const S_qword_list: i32 = 343; /* qword_list  */

    #[allow(non_upper_case_globals)]
    const S_qsym_list: i32 = 344;  /* qsym_list  */

    #[allow(non_upper_case_globals)]
    const S_string_contents: i32 = 345; /* string_contents  */

    #[allow(non_upper_case_globals)]
    const S_xstring_contents: i32 = 346; /* xstring_contents  */

    #[allow(non_upper_case_globals)]
    const S_regexp_contents: i32 = 347; /* regexp_contents  */

    #[allow(non_upper_case_globals)]
    const S_string_content: i32 = 348; /* string_content  */

    #[allow(non_upper_case_globals)]
    const S_349_36: i32 = 349;     /* @36  */

    #[allow(non_upper_case_globals)]
    const S_350_37: i32 = 350;     /* @37  */

    #[allow(non_upper_case_globals)]
    const S_351_38: i32 = 351;     /* @38  */

    #[allow(non_upper_case_globals)]
    const S_352_39: i32 = 352;     /* @39  */

    #[allow(non_upper_case_globals)]
    const S_353_40: i32 = 353;     /* @40  */

    #[allow(non_upper_case_globals)]
    const S_354_41: i32 = 354;     /* @41  */

    #[allow(non_upper_case_globals)]
    const S_string_dvar: i32 = 355; /* string_dvar  */

    #[allow(non_upper_case_globals)]
    const S_symbol: i32 = 356;     /* symbol  */

    #[allow(non_upper_case_globals)]
    const S_ssym: i32 = 357;       /* ssym  */

    #[allow(non_upper_case_globals)]
    const S_sym: i32 = 358;        /* sym  */

    #[allow(non_upper_case_globals)]
    const S_dsym: i32 = 359;       /* dsym  */

    #[allow(non_upper_case_globals)]
    const S_numeric: i32 = 360;    /* numeric  */

    #[allow(non_upper_case_globals)]
    const S_simple_numeric: i32 = 361; /* simple_numeric  */

    #[allow(non_upper_case_globals)]
    const S_nonlocal_var: i32 = 362; /* nonlocal_var  */

    #[allow(non_upper_case_globals)]
    const S_user_variable: i32 = 363; /* user_variable  */

    #[allow(non_upper_case_globals)]
    const S_keyword_variable: i32 = 364; /* keyword_variable  */

    #[allow(non_upper_case_globals)]
    const S_var_ref: i32 = 365;    /* var_ref  */

    #[allow(non_upper_case_globals)]
    const S_var_lhs: i32 = 366;    /* var_lhs  */

    #[allow(non_upper_case_globals)]
    const S_backref: i32 = 367;    /* backref  */

    #[allow(non_upper_case_globals)]
    const S_superclass: i32 = 368; /* superclass  */

    #[allow(non_upper_case_globals)]
    const S_369_42: i32 = 369;     /* @42  */

    #[allow(non_upper_case_globals)]
    const S_f_opt_paren_args: i32 = 370; /* f_opt_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_f_paren_args: i32 = 371; /* f_paren_args  */

    #[allow(non_upper_case_globals)]
    const S_f_arglist: i32 = 372;  /* f_arglist  */

    #[allow(non_upper_case_globals)]
    const S_373_43: i32 = 373;     /* @43  */

    #[allow(non_upper_case_globals)]
    const S_args_tail: i32 = 374;  /* args_tail  */

    #[allow(non_upper_case_globals)]
    const S_opt_args_tail: i32 = 375; /* opt_args_tail  */

    #[allow(non_upper_case_globals)]
    const S_f_args: i32 = 376;     /* f_args  */

    #[allow(non_upper_case_globals)]
    const S_args_forward: i32 = 377; /* args_forward  */

    #[allow(non_upper_case_globals)]
    const S_f_bad_arg: i32 = 378;  /* f_bad_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_norm_arg: i32 = 379; /* f_norm_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_arg_asgn: i32 = 380; /* f_arg_asgn  */

    #[allow(non_upper_case_globals)]
    const S_f_arg_item: i32 = 381; /* f_arg_item  */

    #[allow(non_upper_case_globals)]
    const S_f_arg: i32 = 382;      /* f_arg  */

    #[allow(non_upper_case_globals)]
    const S_f_label: i32 = 383;    /* f_label  */

    #[allow(non_upper_case_globals)]
    const S_f_kw: i32 = 384;       /* f_kw  */

    #[allow(non_upper_case_globals)]
    const S_f_block_kw: i32 = 385; /* f_block_kw  */

    #[allow(non_upper_case_globals)]
    const S_f_block_kwarg: i32 = 386; /* f_block_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_f_kwarg: i32 = 387;    /* f_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_kwrest_mark: i32 = 388; /* kwrest_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_no_kwarg: i32 = 389; /* f_no_kwarg  */

    #[allow(non_upper_case_globals)]
    const S_f_kwrest: i32 = 390;   /* f_kwrest  */

    #[allow(non_upper_case_globals)]
    const S_f_opt: i32 = 391;      /* f_opt  */

    #[allow(non_upper_case_globals)]
    const S_f_block_opt: i32 = 392; /* f_block_opt  */

    #[allow(non_upper_case_globals)]
    const S_f_block_optarg: i32 = 393; /* f_block_optarg  */

    #[allow(non_upper_case_globals)]
    const S_f_optarg: i32 = 394;   /* f_optarg  */

    #[allow(non_upper_case_globals)]
    const S_restarg_mark: i32 = 395; /* restarg_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_rest_arg: i32 = 396; /* f_rest_arg  */

    #[allow(non_upper_case_globals)]
    const S_blkarg_mark: i32 = 397; /* blkarg_mark  */

    #[allow(non_upper_case_globals)]
    const S_f_block_arg: i32 = 398; /* f_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_opt_f_block_arg: i32 = 399; /* opt_f_block_arg  */

    #[allow(non_upper_case_globals)]
    const S_singleton: i32 = 400;  /* singleton  */

    #[allow(non_upper_case_globals)]
    const S_401_44: i32 = 401;     /* @44  */

    #[allow(non_upper_case_globals)]
    const S_assoc_list: i32 = 402; /* assoc_list  */

    #[allow(non_upper_case_globals)]
    const S_assocs: i32 = 403;     /* assocs  */

    #[allow(non_upper_case_globals)]
    const S_assoc: i32 = 404;      /* assoc  */

    #[allow(non_upper_case_globals)]
    const S_operation: i32 = 405;  /* operation  */

    #[allow(non_upper_case_globals)]
    const S_operation2: i32 = 406; /* operation2  */

    #[allow(non_upper_case_globals)]
    const S_operation3: i32 = 407; /* operation3  */

    #[allow(non_upper_case_globals)]
    const S_dot_or_colon: i32 = 408; /* dot_or_colon  */

    #[allow(non_upper_case_globals)]
    const S_call_op: i32 = 409;    /* call_op  */

    #[allow(non_upper_case_globals)]
    const S_call_op2: i32 = 410;   /* call_op2  */

    #[allow(non_upper_case_globals)]
    const S_opt_terms: i32 = 411;  /* opt_terms  */

    #[allow(non_upper_case_globals)]
    const S_opt_nl: i32 = 412;     /* opt_nl  */

    #[allow(non_upper_case_globals)]
    const S_rparen: i32 = 413;     /* rparen  */

    #[allow(non_upper_case_globals)]
    const S_rbracket: i32 = 414;   /* rbracket  */

    #[allow(non_upper_case_globals)]
    const S_rbrace: i32 = 415;     /* rbrace  */

    #[allow(non_upper_case_globals)]
    const S_trailer: i32 = 416;    /* trailer  */

    #[allow(non_upper_case_globals)]
    const S_term: i32 = 417;       /* term  */

    #[allow(non_upper_case_globals)]
    const S_terms: i32 = 418;      /* terms  */

    #[allow(non_upper_case_globals)]
    const S_none: i32 = 419;       /* none  */


    const VALUES_: &'static [SymbolKind] = &[ 
        SymbolKind { value: SymbolKind::S_YYEOF },
        SymbolKind { value: SymbolKind::S_YYerror },
        SymbolKind { value: SymbolKind::S_YYUNDEF },
        SymbolKind { value: SymbolKind::S_kCLASS },
        SymbolKind { value: SymbolKind::S_kMODULE },
        SymbolKind { value: SymbolKind::S_kDEF },
        SymbolKind { value: SymbolKind::S_kUNDEF },
        SymbolKind { value: SymbolKind::S_kBEGIN },
        SymbolKind { value: SymbolKind::S_kRESCUE },
        SymbolKind { value: SymbolKind::S_kENSURE },
        SymbolKind { value: SymbolKind::S_kEND },
        SymbolKind { value: SymbolKind::S_kIF },
        SymbolKind { value: SymbolKind::S_kUNLESS },
        SymbolKind { value: SymbolKind::S_kTHEN },
        SymbolKind { value: SymbolKind::S_kELSIF },
        SymbolKind { value: SymbolKind::S_kELSE },
        SymbolKind { value: SymbolKind::S_kCASE },
        SymbolKind { value: SymbolKind::S_kWHEN },
        SymbolKind { value: SymbolKind::S_kWHILE },
        SymbolKind { value: SymbolKind::S_kUNTIL },
        SymbolKind { value: SymbolKind::S_kFOR },
        SymbolKind { value: SymbolKind::S_kBREAK },
        SymbolKind { value: SymbolKind::S_kNEXT },
        SymbolKind { value: SymbolKind::S_kREDO },
        SymbolKind { value: SymbolKind::S_kRETRY },
        SymbolKind { value: SymbolKind::S_kIN },
        SymbolKind { value: SymbolKind::S_kDO },
        SymbolKind { value: SymbolKind::S_kDO_COND },
        SymbolKind { value: SymbolKind::S_kDO_BLOCK },
        SymbolKind { value: SymbolKind::S_kDO_LAMBDA },
        SymbolKind { value: SymbolKind::S_kRETURN },
        SymbolKind { value: SymbolKind::S_kYIELD },
        SymbolKind { value: SymbolKind::S_kSUPER },
        SymbolKind { value: SymbolKind::S_kSELF },
        SymbolKind { value: SymbolKind::S_kNIL },
        SymbolKind { value: SymbolKind::S_kTRUE },
        SymbolKind { value: SymbolKind::S_kFALSE },
        SymbolKind { value: SymbolKind::S_kAND },
        SymbolKind { value: SymbolKind::S_kOR },
        SymbolKind { value: SymbolKind::S_kNOT },
        SymbolKind { value: SymbolKind::S_kIF_MOD },
        SymbolKind { value: SymbolKind::S_kUNLESS_MOD },
        SymbolKind { value: SymbolKind::S_kWHILE_MOD },
        SymbolKind { value: SymbolKind::S_kUNTIL_MOD },
        SymbolKind { value: SymbolKind::S_kRESCUE_MOD },
        SymbolKind { value: SymbolKind::S_kALIAS },
        SymbolKind { value: SymbolKind::S_kDEFINED },
        SymbolKind { value: SymbolKind::S_klBEGIN },
        SymbolKind { value: SymbolKind::S_klEND },
        SymbolKind { value: SymbolKind::S_k__LINE__ },
        SymbolKind { value: SymbolKind::S_k__FILE__ },
        SymbolKind { value: SymbolKind::S_k__ENCODING__ },
        SymbolKind { value: SymbolKind::S_tIDENTIFIER },
        SymbolKind { value: SymbolKind::S_tFID },
        SymbolKind { value: SymbolKind::S_tGVAR },
        SymbolKind { value: SymbolKind::S_tIVAR },
        SymbolKind { value: SymbolKind::S_tCONSTANT },
        SymbolKind { value: SymbolKind::S_tCVAR },
        SymbolKind { value: SymbolKind::S_tLABEL },
        SymbolKind { value: SymbolKind::S_tINTEGER },
        SymbolKind { value: SymbolKind::S_tFLOAT },
        SymbolKind { value: SymbolKind::S_tRATIONAL },
        SymbolKind { value: SymbolKind::S_tIMAGINARY },
        SymbolKind { value: SymbolKind::S_tCHAR },
        SymbolKind { value: SymbolKind::S_tNTH_REF },
        SymbolKind { value: SymbolKind::S_tBACK_REF },
        SymbolKind { value: SymbolKind::S_tSTRING_CONTENT },
        SymbolKind { value: SymbolKind::S_tREGEXP_END },
        SymbolKind { value: SymbolKind::S_tDOT },
        SymbolKind { value: SymbolKind::S_tBACKSLASH },
        SymbolKind { value: SymbolKind::S_tSP },
        SymbolKind { value: SymbolKind::S_tSLASH_T },
        SymbolKind { value: SymbolKind::S_tSLASH_F },
        SymbolKind { value: SymbolKind::S_tSLASH_R },
        SymbolKind { value: SymbolKind::S_tVTAB },
        SymbolKind { value: SymbolKind::S_tUPLUS },
        SymbolKind { value: SymbolKind::S_tUMINUS },
        SymbolKind { value: SymbolKind::S_tPOW },
        SymbolKind { value: SymbolKind::S_tCMP },
        SymbolKind { value: SymbolKind::S_tEQ },
        SymbolKind { value: SymbolKind::S_tEQQ },
        SymbolKind { value: SymbolKind::S_tNEQ },
        SymbolKind { value: SymbolKind::S_tGEQ },
        SymbolKind { value: SymbolKind::S_tLEQ },
        SymbolKind { value: SymbolKind::S_tANDOP },
        SymbolKind { value: SymbolKind::S_tOROP },
        SymbolKind { value: SymbolKind::S_tMATCH },
        SymbolKind { value: SymbolKind::S_tNMATCH },
        SymbolKind { value: SymbolKind::S_tDOT2 },
        SymbolKind { value: SymbolKind::S_tDOT3 },
        SymbolKind { value: SymbolKind::S_tBDOT2 },
        SymbolKind { value: SymbolKind::S_tBDOT3 },
        SymbolKind { value: SymbolKind::S_tAREF },
        SymbolKind { value: SymbolKind::S_tASET },
        SymbolKind { value: SymbolKind::S_tLSHFT },
        SymbolKind { value: SymbolKind::S_tRSHFT },
        SymbolKind { value: SymbolKind::S_tANDDOT },
        SymbolKind { value: SymbolKind::S_tCOLON2 },
        SymbolKind { value: SymbolKind::S_tCOLON3 },
        SymbolKind { value: SymbolKind::S_tOP_ASGN },
        SymbolKind { value: SymbolKind::S_tASSOC },
        SymbolKind { value: SymbolKind::S_tLPAREN },
        SymbolKind { value: SymbolKind::S_tLPAREN_ARG },
        SymbolKind { value: SymbolKind::S_tRPAREN },
        SymbolKind { value: SymbolKind::S_tLBRACK },
        SymbolKind { value: SymbolKind::S_tLBRACE },
        SymbolKind { value: SymbolKind::S_tLBRACE_ARG },
        SymbolKind { value: SymbolKind::S_tSTAR },
        SymbolKind { value: SymbolKind::S_tDSTAR },
        SymbolKind { value: SymbolKind::S_tAMPER },
        SymbolKind { value: SymbolKind::S_tLAMBDA },
        SymbolKind { value: SymbolKind::S_tSYMBEG },
        SymbolKind { value: SymbolKind::S_tSTRING_BEG },
        SymbolKind { value: SymbolKind::S_tXSTRING_BEG },
        SymbolKind { value: SymbolKind::S_tREGEXP_BEG },
        SymbolKind { value: SymbolKind::S_tWORDS_BEG },
        SymbolKind { value: SymbolKind::S_tQWORDS_BEG },
        SymbolKind { value: SymbolKind::S_tSYMBOLS_BEG },
        SymbolKind { value: SymbolKind::S_tQSYMBOLS_BEG },
        SymbolKind { value: SymbolKind::S_tSTRING_END },
        SymbolKind { value: SymbolKind::S_tSTRING_DEND },
        SymbolKind { value: SymbolKind::S_tSTRING_DBEG },
        SymbolKind { value: SymbolKind::S_tSTRING_DVAR },
        SymbolKind { value: SymbolKind::S_tLAMBEG },
        SymbolKind { value: SymbolKind::S_tLABEL_END },
        SymbolKind { value: SymbolKind::S_tCOMMA },
        SymbolKind { value: SymbolKind::S_tLCURLY },
        SymbolKind { value: SymbolKind::S_tRCURLY },
        SymbolKind { value: SymbolKind::S_tLBRACK2 },
        SymbolKind { value: SymbolKind::S_tEQL },
        SymbolKind { value: SymbolKind::S_tPIPE },
        SymbolKind { value: SymbolKind::S_tAMPER2 },
        SymbolKind { value: SymbolKind::S_tGT },
        SymbolKind { value: SymbolKind::S_tLT },
        SymbolKind { value: SymbolKind::S_tBACK_REF2 },
        SymbolKind { value: SymbolKind::S_tCARET },
        SymbolKind { value: SymbolKind::S_tLPAREN2 },
        SymbolKind { value: SymbolKind::S_tRBRACK },
        SymbolKind { value: SymbolKind::S_tSEMI },
        SymbolKind { value: SymbolKind::S_tSPACE },
        SymbolKind { value: SymbolKind::S_tNL },
        SymbolKind { value: SymbolKind::S_tPLUS },
        SymbolKind { value: SymbolKind::S_tMINUS },
        SymbolKind { value: SymbolKind::S_tSTAR2 },
        SymbolKind { value: SymbolKind::S_tDIVIDE },
        SymbolKind { value: SymbolKind::S_tPERCENT },
        SymbolKind { value: SymbolKind::S_tTILDE },
        SymbolKind { value: SymbolKind::S_tBANG },
        SymbolKind { value: SymbolKind::S_tLOWEST },
        SymbolKind { value: SymbolKind::S_tEH },
        SymbolKind { value: SymbolKind::S_tCOLON },
        SymbolKind { value: SymbolKind::S_tUMINUS_NUM },
        SymbolKind { value: SymbolKind::S_tLAST_TOKEN },
        SymbolKind { value: SymbolKind::S_YYACCEPT },
        SymbolKind { value: SymbolKind::S_program },
        SymbolKind { value: SymbolKind::S_155_1 },
        SymbolKind { value: SymbolKind::S_top_compstmt },
        SymbolKind { value: SymbolKind::S_top_stmts },
        SymbolKind { value: SymbolKind::S_top_stmt },
        SymbolKind { value: SymbolKind::S_begin_block },
        SymbolKind { value: SymbolKind::S_bodystmt },
        SymbolKind { value: SymbolKind::S_compstmt },
        SymbolKind { value: SymbolKind::S_stmts },
        SymbolKind { value: SymbolKind::S_stmt_or_begin },
        SymbolKind { value: SymbolKind::S_164_2 },
        SymbolKind { value: SymbolKind::S_stmt },
        SymbolKind { value: SymbolKind::S_166_3 },
        SymbolKind { value: SymbolKind::S_command_asgn },
        SymbolKind { value: SymbolKind::S_command_rhs },
        SymbolKind { value: SymbolKind::S_expr },
        SymbolKind { value: SymbolKind::S_170_4 },
        SymbolKind { value: SymbolKind::S_171_5 },
        SymbolKind { value: SymbolKind::S_def_name },
        SymbolKind { value: SymbolKind::S_defn_head },
        SymbolKind { value: SymbolKind::S_defs_head },
        SymbolKind { value: SymbolKind::S_175_6 },
        SymbolKind { value: SymbolKind::S_expr_value },
        SymbolKind { value: SymbolKind::S_expr_value_do },
        SymbolKind { value: SymbolKind::S_178_7 },
        SymbolKind { value: SymbolKind::S_command_call },
        SymbolKind { value: SymbolKind::S_block_command },
        SymbolKind { value: SymbolKind::S_cmd_brace_block },
        SymbolKind { value: SymbolKind::S_182_8 },
        SymbolKind { value: SymbolKind::S_fcall },
        SymbolKind { value: SymbolKind::S_command },
        SymbolKind { value: SymbolKind::S_mlhs },
        SymbolKind { value: SymbolKind::S_mlhs_inner },
        SymbolKind { value: SymbolKind::S_mlhs_basic },
        SymbolKind { value: SymbolKind::S_mlhs_item },
        SymbolKind { value: SymbolKind::S_mlhs_head },
        SymbolKind { value: SymbolKind::S_mlhs_post },
        SymbolKind { value: SymbolKind::S_mlhs_node },
        SymbolKind { value: SymbolKind::S_lhs },
        SymbolKind { value: SymbolKind::S_cname },
        SymbolKind { value: SymbolKind::S_cpath },
        SymbolKind { value: SymbolKind::S_fname },
        SymbolKind { value: SymbolKind::S_fitem },
        SymbolKind { value: SymbolKind::S_undef_list },
        SymbolKind { value: SymbolKind::S_198_9 },
        SymbolKind { value: SymbolKind::S_op },
        SymbolKind { value: SymbolKind::S_reswords },
        SymbolKind { value: SymbolKind::S_arg },
        SymbolKind { value: SymbolKind::S_202_10 },
        SymbolKind { value: SymbolKind::S_relop },
        SymbolKind { value: SymbolKind::S_rel_expr },
        SymbolKind { value: SymbolKind::S_arg_value },
        SymbolKind { value: SymbolKind::S_aref_args },
        SymbolKind { value: SymbolKind::S_arg_rhs },
        SymbolKind { value: SymbolKind::S_paren_args },
        SymbolKind { value: SymbolKind::S_opt_paren_args },
        SymbolKind { value: SymbolKind::S_opt_call_args },
        SymbolKind { value: SymbolKind::S_call_args },
        SymbolKind { value: SymbolKind::S_command_args },
        SymbolKind { value: SymbolKind::S_213_11 },
        SymbolKind { value: SymbolKind::S_block_arg },
        SymbolKind { value: SymbolKind::S_opt_block_arg },
        SymbolKind { value: SymbolKind::S_args },
        SymbolKind { value: SymbolKind::S_mrhs_arg },
        SymbolKind { value: SymbolKind::S_mrhs },
        SymbolKind { value: SymbolKind::S_primary },
        SymbolKind { value: SymbolKind::S_220_12 },
        SymbolKind { value: SymbolKind::S_221_13 },
        SymbolKind { value: SymbolKind::S_222_14 },
        SymbolKind { value: SymbolKind::S_223_15 },
        SymbolKind { value: SymbolKind::S_224_16 },
        SymbolKind { value: SymbolKind::S_225_17 },
        SymbolKind { value: SymbolKind::S_226_18 },
        SymbolKind { value: SymbolKind::S_227_19 },
        SymbolKind { value: SymbolKind::S_228_20 },
        SymbolKind { value: SymbolKind::S_primary_value },
        SymbolKind { value: SymbolKind::S_k_begin },
        SymbolKind { value: SymbolKind::S_k_if },
        SymbolKind { value: SymbolKind::S_k_unless },
        SymbolKind { value: SymbolKind::S_k_while },
        SymbolKind { value: SymbolKind::S_k_until },
        SymbolKind { value: SymbolKind::S_k_case },
        SymbolKind { value: SymbolKind::S_k_for },
        SymbolKind { value: SymbolKind::S_k_class },
        SymbolKind { value: SymbolKind::S_k_module },
        SymbolKind { value: SymbolKind::S_k_def },
        SymbolKind { value: SymbolKind::S_k_do },
        SymbolKind { value: SymbolKind::S_k_do_block },
        SymbolKind { value: SymbolKind::S_k_rescue },
        SymbolKind { value: SymbolKind::S_k_ensure },
        SymbolKind { value: SymbolKind::S_k_when },
        SymbolKind { value: SymbolKind::S_k_else },
        SymbolKind { value: SymbolKind::S_k_elsif },
        SymbolKind { value: SymbolKind::S_k_end },
        SymbolKind { value: SymbolKind::S_k_return },
        SymbolKind { value: SymbolKind::S_then },
        SymbolKind { value: SymbolKind::S_do },
        SymbolKind { value: SymbolKind::S_if_tail },
        SymbolKind { value: SymbolKind::S_opt_else },
        SymbolKind { value: SymbolKind::S_for_var },
        SymbolKind { value: SymbolKind::S_f_marg },
        SymbolKind { value: SymbolKind::S_f_marg_list },
        SymbolKind { value: SymbolKind::S_f_margs },
        SymbolKind { value: SymbolKind::S_f_rest_marg },
        SymbolKind { value: SymbolKind::S_f_any_kwrest },
        SymbolKind { value: SymbolKind::S_f_eq },
        SymbolKind { value: SymbolKind::S_260_21 },
        SymbolKind { value: SymbolKind::S_block_args_tail },
        SymbolKind { value: SymbolKind::S_opt_block_args_tail },
        SymbolKind { value: SymbolKind::S_excessed_comma },
        SymbolKind { value: SymbolKind::S_block_param },
        SymbolKind { value: SymbolKind::S_opt_block_param },
        SymbolKind { value: SymbolKind::S_block_param_def },
        SymbolKind { value: SymbolKind::S_opt_bv_decl },
        SymbolKind { value: SymbolKind::S_bv_decls },
        SymbolKind { value: SymbolKind::S_bvar },
        SymbolKind { value: SymbolKind::S_lambda },
        SymbolKind { value: SymbolKind::S_271_22 },
        SymbolKind { value: SymbolKind::S_272_23 },
        SymbolKind { value: SymbolKind::S_273_24 },
        SymbolKind { value: SymbolKind::S_f_larglist },
        SymbolKind { value: SymbolKind::S_lambda_body },
        SymbolKind { value: SymbolKind::S_276_25 },
        SymbolKind { value: SymbolKind::S_277_26 },
        SymbolKind { value: SymbolKind::S_do_block },
        SymbolKind { value: SymbolKind::S_279_27 },
        SymbolKind { value: SymbolKind::S_block_call },
        SymbolKind { value: SymbolKind::S_method_call },
        SymbolKind { value: SymbolKind::S_brace_block },
        SymbolKind { value: SymbolKind::S_283_28 },
        SymbolKind { value: SymbolKind::S_284_29 },
        SymbolKind { value: SymbolKind::S_brace_body },
        SymbolKind { value: SymbolKind::S_286_30 },
        SymbolKind { value: SymbolKind::S_do_body },
        SymbolKind { value: SymbolKind::S_288_31 },
        SymbolKind { value: SymbolKind::S_case_args },
        SymbolKind { value: SymbolKind::S_case_body },
        SymbolKind { value: SymbolKind::S_cases },
        SymbolKind { value: SymbolKind::S_p_case_body },
        SymbolKind { value: SymbolKind::S_293_32 },
        SymbolKind { value: SymbolKind::S_294_33 },
        SymbolKind { value: SymbolKind::S_p_cases },
        SymbolKind { value: SymbolKind::S_p_top_expr },
        SymbolKind { value: SymbolKind::S_p_top_expr_body },
        SymbolKind { value: SymbolKind::S_p_expr },
        SymbolKind { value: SymbolKind::S_p_as },
        SymbolKind { value: SymbolKind::S_p_alt },
        SymbolKind { value: SymbolKind::S_p_lparen },
        SymbolKind { value: SymbolKind::S_p_lbracket },
        SymbolKind { value: SymbolKind::S_p_expr_basic },
        SymbolKind { value: SymbolKind::S_304_34 },
        SymbolKind { value: SymbolKind::S_305_35 },
        SymbolKind { value: SymbolKind::S_p_args },
        SymbolKind { value: SymbolKind::S_p_args_head },
        SymbolKind { value: SymbolKind::S_p_args_tail },
        SymbolKind { value: SymbolKind::S_p_find },
        SymbolKind { value: SymbolKind::S_p_rest },
        SymbolKind { value: SymbolKind::S_p_args_post },
        SymbolKind { value: SymbolKind::S_p_arg },
        SymbolKind { value: SymbolKind::S_p_kwargs },
        SymbolKind { value: SymbolKind::S_p_kwarg },
        SymbolKind { value: SymbolKind::S_p_kw },
        SymbolKind { value: SymbolKind::S_p_kw_label },
        SymbolKind { value: SymbolKind::S_p_kwrest },
        SymbolKind { value: SymbolKind::S_p_kwnorest },
        SymbolKind { value: SymbolKind::S_p_any_kwrest },
        SymbolKind { value: SymbolKind::S_p_value },
        SymbolKind { value: SymbolKind::S_p_primitive },
        SymbolKind { value: SymbolKind::S_p_variable },
        SymbolKind { value: SymbolKind::S_p_var_ref },
        SymbolKind { value: SymbolKind::S_p_expr_ref },
        SymbolKind { value: SymbolKind::S_p_const },
        SymbolKind { value: SymbolKind::S_opt_rescue },
        SymbolKind { value: SymbolKind::S_exc_list },
        SymbolKind { value: SymbolKind::S_exc_var },
        SymbolKind { value: SymbolKind::S_opt_ensure },
        SymbolKind { value: SymbolKind::S_literal },
        SymbolKind { value: SymbolKind::S_strings },
        SymbolKind { value: SymbolKind::S_string },
        SymbolKind { value: SymbolKind::S_string1 },
        SymbolKind { value: SymbolKind::S_xstring },
        SymbolKind { value: SymbolKind::S_regexp },
        SymbolKind { value: SymbolKind::S_words },
        SymbolKind { value: SymbolKind::S_word_list },
        SymbolKind { value: SymbolKind::S_word },
        SymbolKind { value: SymbolKind::S_symbols },
        SymbolKind { value: SymbolKind::S_symbol_list },
        SymbolKind { value: SymbolKind::S_qwords },
        SymbolKind { value: SymbolKind::S_qsymbols },
        SymbolKind { value: SymbolKind::S_qword_list },
        SymbolKind { value: SymbolKind::S_qsym_list },
        SymbolKind { value: SymbolKind::S_string_contents },
        SymbolKind { value: SymbolKind::S_xstring_contents },
        SymbolKind { value: SymbolKind::S_regexp_contents },
        SymbolKind { value: SymbolKind::S_string_content },
        SymbolKind { value: SymbolKind::S_349_36 },
        SymbolKind { value: SymbolKind::S_350_37 },
        SymbolKind { value: SymbolKind::S_351_38 },
        SymbolKind { value: SymbolKind::S_352_39 },
        SymbolKind { value: SymbolKind::S_353_40 },
        SymbolKind { value: SymbolKind::S_354_41 },
        SymbolKind { value: SymbolKind::S_string_dvar },
        SymbolKind { value: SymbolKind::S_symbol },
        SymbolKind { value: SymbolKind::S_ssym },
        SymbolKind { value: SymbolKind::S_sym },
        SymbolKind { value: SymbolKind::S_dsym },
        SymbolKind { value: SymbolKind::S_numeric },
        SymbolKind { value: SymbolKind::S_simple_numeric },
        SymbolKind { value: SymbolKind::S_nonlocal_var },
        SymbolKind { value: SymbolKind::S_user_variable },
        SymbolKind { value: SymbolKind::S_keyword_variable },
        SymbolKind { value: SymbolKind::S_var_ref },
        SymbolKind { value: SymbolKind::S_var_lhs },
        SymbolKind { value: SymbolKind::S_backref },
        SymbolKind { value: SymbolKind::S_superclass },
        SymbolKind { value: SymbolKind::S_369_42 },
        SymbolKind { value: SymbolKind::S_f_opt_paren_args },
        SymbolKind { value: SymbolKind::S_f_paren_args },
        SymbolKind { value: SymbolKind::S_f_arglist },
        SymbolKind { value: SymbolKind::S_373_43 },
        SymbolKind { value: SymbolKind::S_args_tail },
        SymbolKind { value: SymbolKind::S_opt_args_tail },
        SymbolKind { value: SymbolKind::S_f_args },
        SymbolKind { value: SymbolKind::S_args_forward },
        SymbolKind { value: SymbolKind::S_f_bad_arg },
        SymbolKind { value: SymbolKind::S_f_norm_arg },
        SymbolKind { value: SymbolKind::S_f_arg_asgn },
        SymbolKind { value: SymbolKind::S_f_arg_item },
        SymbolKind { value: SymbolKind::S_f_arg },
        SymbolKind { value: SymbolKind::S_f_label },
        SymbolKind { value: SymbolKind::S_f_kw },
        SymbolKind { value: SymbolKind::S_f_block_kw },
        SymbolKind { value: SymbolKind::S_f_block_kwarg },
        SymbolKind { value: SymbolKind::S_f_kwarg },
        SymbolKind { value: SymbolKind::S_kwrest_mark },
        SymbolKind { value: SymbolKind::S_f_no_kwarg },
        SymbolKind { value: SymbolKind::S_f_kwrest },
        SymbolKind { value: SymbolKind::S_f_opt },
        SymbolKind { value: SymbolKind::S_f_block_opt },
        SymbolKind { value: SymbolKind::S_f_block_optarg },
        SymbolKind { value: SymbolKind::S_f_optarg },
        SymbolKind { value: SymbolKind::S_restarg_mark },
        SymbolKind { value: SymbolKind::S_f_rest_arg },
        SymbolKind { value: SymbolKind::S_blkarg_mark },
        SymbolKind { value: SymbolKind::S_f_block_arg },
        SymbolKind { value: SymbolKind::S_opt_f_block_arg },
        SymbolKind { value: SymbolKind::S_singleton },
        SymbolKind { value: SymbolKind::S_401_44 },
        SymbolKind { value: SymbolKind::S_assoc_list },
        SymbolKind { value: SymbolKind::S_assocs },
        SymbolKind { value: SymbolKind::S_assoc },
        SymbolKind { value: SymbolKind::S_operation },
        SymbolKind { value: SymbolKind::S_operation2 },
        SymbolKind { value: SymbolKind::S_operation3 },
        SymbolKind { value: SymbolKind::S_dot_or_colon },
        SymbolKind { value: SymbolKind::S_call_op },
        SymbolKind { value: SymbolKind::S_call_op2 },
        SymbolKind { value: SymbolKind::S_opt_terms },
        SymbolKind { value: SymbolKind::S_opt_nl },
        SymbolKind { value: SymbolKind::S_rparen },
        SymbolKind { value: SymbolKind::S_rbracket },
        SymbolKind { value: SymbolKind::S_rbrace },
        SymbolKind { value: SymbolKind::S_trailer },
        SymbolKind { value: SymbolKind::S_term },
        SymbolKind { value: SymbolKind::S_terms },
        SymbolKind { value: SymbolKind::S_none }
    ];

    pub(crate) fn get(n: i32) -> &'static SymbolKind {
        &Self::VALUES_[i32_to_usize(n)]
    }

    pub(crate) fn code(&self) -> i32 {
        self.value
    }

    /* YYNAMES_[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
    First, the terminals, then, starting at \a YYNTOKENS_, nonterminals.  */
    #[allow(non_upper_case_globals)]
const yynames_: &'static [&'static str] = &[ "end-of-input", "error", "invalid token", "`class'", "`module'",
  "`def'", "`undef'", "`begin'", "`rescue'", "`ensure'", "`end'", "`if'",
  "`unless'", "`then'", "`elsif'", "`else'", "`case'", "`when'", "`while'",
  "`until'", "`for'", "`break'", "`next'", "`redo'", "`retry'", "`in'",
  "`do'", "`do' for condition", "`do' for block", "`do' for lambda",
  "`return'", "`yield'", "`super'", "`self'", "`nil'", "`true'", "`false'",
  "`and'", "`or'", "`not'", "`if' modifier", "`unless' modifier",
  "`while' modifier", "`until' modifier", "`rescue' modifier", "`alias'",
  "`defined?'", "`BEGIN'", "`END'", "`__LINE__'", "`__FILE__'",
  "`__ENCODING__'", "local variable or method", "method",
  "global variable", "instance variable", "constant", "class variable",
  "label", "integer literal", "float literal", "rational literal",
  "imaginary literal", "char literal", "numbered reference",
  "back reference", "literal content", "tREGEXP_END", "tDOT", "backslash",
  "escaped space", "escaped horizontal tab", "escaped form feed",
  "escaped carriage return", "escaped vertical tab", "unary+", "unary-",
  "**", "<=>", "==", "===", "!=", ">=", "<=", "&&", "||", "=~", "!~", "..",
  "...", "(..", "(...", "[]", "[]=", "<<", ">>", "&.", "::",
  ":: at EXPR_BEG", "operator-assignment", "=>", "(", "( arg", ")", "[",
  "{", "{ arg", "*", "**arg", "&", "->", "symbol literal", "string begin",
  "backtick literal", "regexp literal", "word list", "verbatim word list",
  "symbol list", "verbatim symbol list", "string end", "tRCURLY",
  "tSTRING_DBEG", "tSTRING_DVAR", "tLAMBEG", "tLABEL_END", ",",
  "{ (tLCURLY)", "}", "[ (tLBRACK2)", "=", "|", "& (tAMPER2)", ">", "<",
  "`", "^", "( (tLPAREN2)", "]", ";", " ", "\n", "+", "-", "* (tSTAR2)",
  "/", "%", "~", "!", "tLOWEST", "tEH", "tCOLON", "tUMINUS_NUM",
  "tLAST_TOKEN", "$accept", "program", "@1", "top_compstmt", "top_stmts",
  "top_stmt", "begin_block", "bodystmt", "compstmt", "stmts",
  "stmt_or_begin", "$@2", "stmt", "@3", "command_asgn", "command_rhs",
  "expr", "@4", "@5", "def_name", "defn_head", "defs_head", "@6",
  "expr_value", "expr_value_do", "@7", "command_call", "block_command",
  "cmd_brace_block", "@8", "fcall", "command", "mlhs", "mlhs_inner",
  "mlhs_basic", "mlhs_item", "mlhs_head", "mlhs_post", "mlhs_node", "lhs",
  "cname", "cpath", "fname", "fitem", "undef_list", "@9", "op", "reswords",
  "arg", "@10", "relop", "rel_expr", "arg_value", "aref_args", "arg_rhs",
  "paren_args", "opt_paren_args", "opt_call_args", "call_args",
  "command_args", "@11", "block_arg", "opt_block_arg", "args", "mrhs_arg",
  "mrhs", "primary", "@12", "@13", "@14", "@15", "@16", "@17", "@18",
  "@19", "@20", "primary_value", "k_begin", "k_if", "k_unless", "k_while",
  "k_until", "k_case", "k_for", "k_class", "k_module", "k_def", "k_do",
  "k_do_block", "k_rescue", "k_ensure", "k_when", "k_else", "k_elsif",
  "k_end", "k_return", "then", "do", "if_tail", "opt_else", "for_var",
  "f_marg", "f_marg_list", "f_margs", "f_rest_marg", "f_any_kwrest",
  "f_eq", "@21", "block_args_tail", "opt_block_args_tail",
  "excessed_comma", "block_param", "opt_block_param", "block_param_def",
  "opt_bv_decl", "bv_decls", "bvar", "lambda", "@22", "@23", "@24",
  "f_larglist", "lambda_body", "@25", "@26", "do_block", "@27",
  "block_call", "method_call", "brace_block", "@28", "@29", "brace_body",
  "@30", "do_body", "@31", "case_args", "case_body", "cases",
  "p_case_body", "@32", "@33", "p_cases", "p_top_expr", "p_top_expr_body",
  "p_expr", "p_as", "p_alt", "p_lparen", "p_lbracket", "p_expr_basic",
  "@34", "@35", "p_args", "p_args_head", "p_args_tail", "p_find", "p_rest",
  "p_args_post", "p_arg", "p_kwargs", "p_kwarg", "p_kw", "p_kw_label",
  "p_kwrest", "p_kwnorest", "p_any_kwrest", "p_value", "p_primitive",
  "p_variable", "p_var_ref", "p_expr_ref", "p_const", "opt_rescue",
  "exc_list", "exc_var", "opt_ensure", "literal", "strings", "string",
  "string1", "xstring", "regexp", "words", "word_list", "word", "symbols",
  "symbol_list", "qwords", "qsymbols", "qword_list", "qsym_list",
  "string_contents", "xstring_contents", "regexp_contents",
  "string_content", "@36", "@37", "@38", "@39", "@40", "@41",
  "string_dvar", "symbol", "ssym", "sym", "dsym", "numeric",
  "simple_numeric", "nonlocal_var", "user_variable", "keyword_variable",
  "var_ref", "var_lhs", "backref", "superclass", "@42", "f_opt_paren_args",
  "f_paren_args", "f_arglist", "@43", "args_tail", "opt_args_tail",
  "f_args", "args_forward", "f_bad_arg", "f_norm_arg", "f_arg_asgn",
  "f_arg_item", "f_arg", "f_label", "f_kw", "f_block_kw", "f_block_kwarg",
  "f_kwarg", "kwrest_mark", "f_no_kwarg", "f_kwrest", "f_opt",
  "f_block_opt", "f_block_optarg", "f_optarg", "restarg_mark",
  "f_rest_arg", "blkarg_mark", "f_block_arg", "opt_f_block_arg",
  "singleton", "@44", "assoc_list", "assocs", "assoc", "operation",
  "operation2", "operation3", "dot_or_colon", "call_op", "call_op2",
  "opt_terms", "opt_nl", "rparen", "rbracket", "rbrace", "trailer", "term",
  "terms", "none", "<<NULL>>" ] ;

    /* The user-facing name of this symbol.  */
    pub(crate) fn name(&self) -> String {
        let code: usize = self.code().try_into().unwrap();
        Self::yynames_[code].to_owned()
    }
}


const DYMMY_SYMBOL_KIND: SymbolKind = SymbolKind { value: 0 };

impl Lexer {
        /* Token kinds.  */
    /// Token `` "end-of-input" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const END_OF_INPUT: i32 = 0;
    /// Token `` error ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const YYerror: i32 = 256;
    /// Token `` "invalid token" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const YYUNDEF: i32 = 257;
    /// Token `` "`class'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kCLASS: i32 = 258;
    /// Token `` "`module'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kMODULE: i32 = 259;
    /// Token `` "`def'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDEF: i32 = 260;
    /// Token `` "`undef'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNDEF: i32 = 261;
    /// Token `` "`begin'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kBEGIN: i32 = 262;
    /// Token `` "`rescue'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRESCUE: i32 = 263;
    /// Token `` "`ensure'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kENSURE: i32 = 264;
    /// Token `` "`end'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kEND: i32 = 265;
    /// Token `` "`if'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIF: i32 = 266;
    /// Token `` "`unless'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNLESS: i32 = 267;
    /// Token `` "`then'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kTHEN: i32 = 268;
    /// Token `` "`elsif'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kELSIF: i32 = 269;
    /// Token `` "`else'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kELSE: i32 = 270;
    /// Token `` "`case'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kCASE: i32 = 271;
    /// Token `` "`when'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHEN: i32 = 272;
    /// Token `` "`while'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHILE: i32 = 273;
    /// Token `` "`until'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNTIL: i32 = 274;
    /// Token `` "`for'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kFOR: i32 = 275;
    /// Token `` "`break'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kBREAK: i32 = 276;
    /// Token `` "`next'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNEXT: i32 = 277;
    /// Token `` "`redo'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kREDO: i32 = 278;
    /// Token `` "`retry'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRETRY: i32 = 279;
    /// Token `` "`in'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIN: i32 = 280;
    /// Token `` "`do'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO: i32 = 281;
    /// Token `` "`do' for condition" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_COND: i32 = 282;
    /// Token `` "`do' for block" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_BLOCK: i32 = 283;
    /// Token `` "`do' for lambda" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDO_LAMBDA: i32 = 284;
    /// Token `` "`return'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRETURN: i32 = 285;
    /// Token `` "`yield'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kYIELD: i32 = 286;
    /// Token `` "`super'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kSUPER: i32 = 287;
    /// Token `` "`self'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kSELF: i32 = 288;
    /// Token `` "`nil'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNIL: i32 = 289;
    /// Token `` "`true'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kTRUE: i32 = 290;
    /// Token `` "`false'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kFALSE: i32 = 291;
    /// Token `` "`and'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kAND: i32 = 292;
    /// Token `` "`or'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kOR: i32 = 293;
    /// Token `` "`not'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kNOT: i32 = 294;
    /// Token `` "`if' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kIF_MOD: i32 = 295;
    /// Token `` "`unless' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNLESS_MOD: i32 = 296;
    /// Token `` "`while' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kWHILE_MOD: i32 = 297;
    /// Token `` "`until' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kUNTIL_MOD: i32 = 298;
    /// Token `` "`rescue' modifier" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kRESCUE_MOD: i32 = 299;
    /// Token `` "`alias'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kALIAS: i32 = 300;
    /// Token `` "`defined?'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const kDEFINED: i32 = 301;
    /// Token `` "`BEGIN'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const klBEGIN: i32 = 302;
    /// Token `` "`END'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const klEND: i32 = 303;
    /// Token `` "`__LINE__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__LINE__: i32 = 304;
    /// Token `` "`__FILE__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__FILE__: i32 = 305;
    /// Token `` "`__ENCODING__'" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const k__ENCODING__: i32 = 306;
    /// Token `` "local variable or method" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIDENTIFIER: i32 = 307;
    /// Token `` "method" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tFID: i32 = 308;
    /// Token `` "global variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGVAR: i32 = 309;
    /// Token `` "instance variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIVAR: i32 = 310;
    /// Token `` "constant" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCONSTANT: i32 = 311;
    /// Token `` "class variable" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCVAR: i32 = 312;
    /// Token `` "label" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLABEL: i32 = 313;
    /// Token `` "integer literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tINTEGER: i32 = 314;
    /// Token `` "float literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tFLOAT: i32 = 315;
    /// Token `` "rational literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRATIONAL: i32 = 316;
    /// Token `` "imaginary literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tIMAGINARY: i32 = 317;
    /// Token `` "char literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCHAR: i32 = 318;
    /// Token `` "numbered reference" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNTH_REF: i32 = 319;
    /// Token `` "back reference" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACK_REF: i32 = 320;
    /// Token `` "literal content" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_CONTENT: i32 = 321;
    /// Token `` tREGEXP_END ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tREGEXP_END: i32 = 322;
    /// Token `` tDOT ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT: i32 = 323;
    /// Token `` "backslash" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACKSLASH: i32 = 324;
    /// Token `` "escaped space" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSP: i32 = 325;
    /// Token `` "escaped horizontal tab" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_T: i32 = 326;
    /// Token `` "escaped form feed" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_F: i32 = 327;
    /// Token `` "escaped carriage return" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSLASH_R: i32 = 328;
    /// Token `` "escaped vertical tab" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tVTAB: i32 = 329;
    /// Token `` "unary+" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUPLUS: i32 = 330;
    /// Token `` "unary-" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUMINUS: i32 = 331;
    /// Token `` "**" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPOW: i32 = 332;
    /// Token `` "<=>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCMP: i32 = 333;
    /// Token `` "==" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQ: i32 = 334;
    /// Token `` "===" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQQ: i32 = 335;
    /// Token `` "!=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNEQ: i32 = 336;
    /// Token `` ">=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGEQ: i32 = 337;
    /// Token `` "<=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLEQ: i32 = 338;
    /// Token `` "&&" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tANDOP: i32 = 339;
    /// Token `` "||" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tOROP: i32 = 340;
    /// Token `` "=~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tMATCH: i32 = 341;
    /// Token `` "!~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNMATCH: i32 = 342;
    /// Token `` ".." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT2: i32 = 343;
    /// Token `` "..." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDOT3: i32 = 344;
    /// Token `` "(.." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBDOT2: i32 = 345;
    /// Token `` "(..." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBDOT3: i32 = 346;
    /// Token `` "[]" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAREF: i32 = 347;
    /// Token `` "[]=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tASET: i32 = 348;
    /// Token `` "<<" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLSHFT: i32 = 349;
    /// Token `` ">>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRSHFT: i32 = 350;
    /// Token `` "&." ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tANDDOT: i32 = 351;
    /// Token `` "::" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON2: i32 = 352;
    /// Token `` ":: at EXPR_BEG" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON3: i32 = 353;
    /// Token `` "operator-assignment" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tOP_ASGN: i32 = 354;
    /// Token `` "=>" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tASSOC: i32 = 355;
    /// Token `` "(" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN: i32 = 356;
    /// Token `` "( arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN_ARG: i32 = 357;
    /// Token `` ")" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRPAREN: i32 = 358;
    /// Token `` "[" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACK: i32 = 359;
    /// Token `` "{" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACE: i32 = 360;
    /// Token `` "{ arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACE_ARG: i32 = 361;
    /// Token `` "*" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTAR: i32 = 362;
    /// Token `` "**arg" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDSTAR: i32 = 363;
    /// Token `` "&" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAMPER: i32 = 364;
    /// Token `` "->" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAMBDA: i32 = 365;
    /// Token `` "symbol literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSYMBEG: i32 = 366;
    /// Token `` "string begin" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_BEG: i32 = 367;
    /// Token `` "backtick literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tXSTRING_BEG: i32 = 368;
    /// Token `` "regexp literal" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tREGEXP_BEG: i32 = 369;
    /// Token `` "word list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tWORDS_BEG: i32 = 370;
    /// Token `` "verbatim word list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tQWORDS_BEG: i32 = 371;
    /// Token `` "symbol list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSYMBOLS_BEG: i32 = 372;
    /// Token `` "verbatim symbol list" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tQSYMBOLS_BEG: i32 = 373;
    /// Token `` "string end" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_END: i32 = 374;
    /// Token `` "tRCURLY" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DEND: i32 = 375;
    /// Token `` tSTRING_DBEG ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DBEG: i32 = 376;
    /// Token `` tSTRING_DVAR ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTRING_DVAR: i32 = 377;
    /// Token `` tLAMBEG ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAMBEG: i32 = 378;
    /// Token `` tLABEL_END ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLABEL_END: i32 = 379;
    /// Token `` "," ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOMMA: i32 = 380;
    /// Token `` "{ (tLCURLY)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLCURLY: i32 = 381;
    /// Token `` "}" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRCURLY: i32 = 382;
    /// Token `` "[ (tLBRACK2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLBRACK2: i32 = 383;
    /// Token `` "=" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEQL: i32 = 384;
    /// Token `` "|" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPIPE: i32 = 385;
    /// Token `` "& (tAMPER2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tAMPER2: i32 = 386;
    /// Token `` ">" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tGT: i32 = 387;
    /// Token `` "<" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLT: i32 = 388;
    /// Token `` "`" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBACK_REF2: i32 = 389;
    /// Token `` "^" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCARET: i32 = 390;
    /// Token `` "( (tLPAREN2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLPAREN2: i32 = 391;
    /// Token `` "]" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tRBRACK: i32 = 392;
    /// Token `` ";" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSEMI: i32 = 393;
    /// Token `` " " ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSPACE: i32 = 394;
    /// Token `` "\n" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tNL: i32 = 395;
    /// Token `` "+" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPLUS: i32 = 396;
    /// Token `` "-" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tMINUS: i32 = 397;
    /// Token `` "* (tSTAR2)" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tSTAR2: i32 = 398;
    /// Token `` "/" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tDIVIDE: i32 = 399;
    /// Token `` "%" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tPERCENT: i32 = 400;
    /// Token `` "~" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tTILDE: i32 = 401;
    /// Token `` "!" ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tBANG: i32 = 402;
    /// Token `` tLOWEST ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLOWEST: i32 = 403;
    /// Token `` tEH ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tEH: i32 = 404;
    /// Token `` tCOLON ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tCOLON: i32 = 405;
    /// Token `` tUMINUS_NUM ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tUMINUS_NUM: i32 = 406;
    /// Token `` tLAST_TOKEN ``, to be returned by the scanner.
    #[allow(non_upper_case_globals, dead_code)]
    pub const tLAST_TOKEN: i32 = 407;


    // Deprecated, use END_OF_INPUT instead.
    #[allow(dead_code)]
    const EOF: i32 = Self::END_OF_INPUT;

    // Token values
    #[allow(dead_code)]
    pub(crate) const TOKEN_NAMES: &'static [&'static str] = &    [

    "END_OF_INPUT",

    "YYerror",

    "YYUNDEF",

    "kCLASS",

    "kMODULE",

    "kDEF",

    "kUNDEF",

    "kBEGIN",

    "kRESCUE",

    "kENSURE",

    "kEND",

    "kIF",

    "kUNLESS",

    "kTHEN",

    "kELSIF",

    "kELSE",

    "kCASE",

    "kWHEN",

    "kWHILE",

    "kUNTIL",

    "kFOR",

    "kBREAK",

    "kNEXT",

    "kREDO",

    "kRETRY",

    "kIN",

    "kDO",

    "kDO_COND",

    "kDO_BLOCK",

    "kDO_LAMBDA",

    "kRETURN",

    "kYIELD",

    "kSUPER",

    "kSELF",

    "kNIL",

    "kTRUE",

    "kFALSE",

    "kAND",

    "kOR",

    "kNOT",

    "kIF_MOD",

    "kUNLESS_MOD",

    "kWHILE_MOD",

    "kUNTIL_MOD",

    "kRESCUE_MOD",

    "kALIAS",

    "kDEFINED",

    "klBEGIN",

    "klEND",

    "k__LINE__",

    "k__FILE__",

    "k__ENCODING__",

    "tIDENTIFIER",

    "tFID",

    "tGVAR",

    "tIVAR",

    "tCONSTANT",

    "tCVAR",

    "tLABEL",

    "tINTEGER",

    "tFLOAT",

    "tRATIONAL",

    "tIMAGINARY",

    "tCHAR",

    "tNTH_REF",

    "tBACK_REF",

    "tSTRING_CONTENT",

    "tREGEXP_END",

    "tDOT",

    "tBACKSLASH",

    "tSP",

    "tSLASH_T",

    "tSLASH_F",

    "tSLASH_R",

    "tVTAB",

    "tUPLUS",

    "tUMINUS",

    "tPOW",

    "tCMP",

    "tEQ",

    "tEQQ",

    "tNEQ",

    "tGEQ",

    "tLEQ",

    "tANDOP",

    "tOROP",

    "tMATCH",

    "tNMATCH",

    "tDOT2",

    "tDOT3",

    "tBDOT2",

    "tBDOT3",

    "tAREF",

    "tASET",

    "tLSHFT",

    "tRSHFT",

    "tANDDOT",

    "tCOLON2",

    "tCOLON3",

    "tOP_ASGN",

    "tASSOC",

    "tLPAREN",

    "tLPAREN_ARG",

    "tRPAREN",

    "tLBRACK",

    "tLBRACE",

    "tLBRACE_ARG",

    "tSTAR",

    "tDSTAR",

    "tAMPER",

    "tLAMBDA",

    "tSYMBEG",

    "tSTRING_BEG",

    "tXSTRING_BEG",

    "tREGEXP_BEG",

    "tWORDS_BEG",

    "tQWORDS_BEG",

    "tSYMBOLS_BEG",

    "tQSYMBOLS_BEG",

    "tSTRING_END",

    "tSTRING_DEND",

    "tSTRING_DBEG",

    "tSTRING_DVAR",

    "tLAMBEG",

    "tLABEL_END",

    "tCOMMA",

    "tLCURLY",

    "tRCURLY",

    "tLBRACK2",

    "tEQL",

    "tPIPE",

    "tAMPER2",

    "tGT",

    "tLT",

    "tBACK_REF2",

    "tCARET",

    "tLPAREN2",

    "tRBRACK",

    "tSEMI",

    "tSPACE",

    "tNL",

    "tPLUS",

    "tMINUS",

    "tSTAR2",

    "tDIVIDE",

    "tPERCENT",

    "tTILDE",

    "tBANG",

    "tLOWEST",

    "tEH",

    "tCOLON",

    "tUMINUS_NUM",

    "tLAST_TOKEN",

]
;
}


impl  Parser  {

    fn yycdebug(&self, s: &str) {
        if  self.is_debug()  {
            eprintln!("{}", s);
        }
    }

}

/// Local alias
type YYValue =  Value ;

#[derive(Debug)]
struct YYStackItem {
    state: i32,
    value: YYValue,
    loc: YYLoc,
}

#[derive(Debug)]
pub struct YYStack {
    stack: Vec<YYStackItem>,
}

impl YYStack {
    pub(crate) fn new() -> Self {
        Self {
          stack: Vec::with_capacity(20),
        }
    }

    pub(crate) fn push(&mut self, state: i32, value: YYValue, loc: YYLoc) {
        self.stack.push(YYStackItem { state, value, loc });
    }

    pub(crate) fn pop(&mut self) {
        self.stack.pop();
    }

    pub(crate) fn pop_n(&mut self, num: usize) {
        let len = self.stack.len() - num;
        self.stack.truncate(len);
    }

    pub(crate) fn state_at(&self, i: usize) -> i32 {
        self.stack[self.len() - 1 - i].state
    }

    pub(crate) fn location_at(&self, i: usize) -> &YYLoc {
        &self.stack[self.len() - 1 - i].loc
    }

    pub(crate) fn borrow_value_at(&self, i: usize) -> &YYValue {
        &self.stack[self.len() - 1 - i].value
    }

    pub(crate) fn owned_value_at(&mut self, i: usize) -> YYValue {
        let len = self.len();
        std::mem::take(&mut self.stack[len - 1 - i].value)
    }

    pub(crate) fn len(&self) -> usize {
      self.stack.len()
    }
}

impl std::fmt::Display for YYStack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let states = self.stack.iter().map(|e| e.state.to_string()).collect::<Vec<String>>().join(" ");
        let values = self.stack.iter().map(|e| format!("{:?}", e.value)).collect::<Vec<String>>().join(" ");
        f.write_fmt(format_args!("Stack now states = {} / values = {:?} ", states, values))
    }
}

impl  Parser  {
  /// Returned by a Bison action in order to stop the parsing process and
  /// return success (true).
  pub(crate) const YYACCEPT: i32 = 0;

  /// Returned by a Bison action in order to stop the parsing process and
  /// return failure (false).
  pub(crate) const YYABORT: i32 = 1;

  /// Returned by a Bison action in order to start error recovery without
  /// printing an error message.
  pub(crate) const YYERROR: i32 = 2;

  /// Internal return codes that are not supported for user semantic
  /// actions.
  pub(crate) const YYERRLAB: i32 = 3;
  pub(crate) const YYNEWSTATE: i32 = 4;
  pub(crate) const YYDEFAULT: i32 = 5;
  pub(crate) const YYREDUCE: i32 = 6;
  pub(crate) const YYERRLAB1: i32 = 7;
  #[allow(dead_code)]
  pub(crate) const YYRETURN: i32 = 8;

  /// Whether error recovery is being done.  In this state, the parser
  /// reads token until it reaches a known state, and then restarts normal
  /// operation.
  #[allow(dead_code)]
  pub(crate) fn recovering(&self) -> bool {
      self.yyerrstatus_ == 0
  }

    // Compute post-reduction state.
    // yystate:   the current state
    // yysym:     the nonterminal to push on the stack
    fn yy_lr_goto_state(&self, yystate: i32, yysym: i32) -> i32 {
        let idx = i32_to_usize(yysym - Self::YYNTOKENS_);
        let yyr = Self::yypgoto_[idx] + yystate;
        if (0..=Self::YYLAST_).contains(&yyr) {
            let yyr = i32_to_usize(yyr);
            if Self::yycheck_[yyr] == yystate {
                return Self::yytable_[yyr];
            }
        }
        Self::yydefgoto_[idx]
    }

    fn yyaction(&mut self, yyn: i32, yystack: &mut YYStack, yylen: &mut usize) -> Result<i32, ()> {
        // If YYLEN is nonzero, implement the default value of the action:
        // '$$ = $1'.  Otherwise, use the top of the stack.
        //
        // Otherwise, the following line sets YYVAL to garbage.
        // This behavior is undocumented and Bison
        // users should not rely upon it.
        #[allow(unused_assignments)]
        let mut yyval: YYValue = YYValue::new_uninitialized();
        let yyloc: YYLoc = make_yylloc(yystack, *yylen);

        self.yy_reduce_print(yyn, yystack);

        match yyn {
              2 =>  /* @1: %empty  */
  /* "src/parser/parser.y":346  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.current_arg_stack.push(None);
                        self.max_numparam_stack.push(true);

                        yyval = Value::None;
                    },


  3 =>  /* program: @1 top_compstmt  */
  /* "src/parser/parser.y":354  */
                    {
                        let top_compstmt =  MaybeNode::from(yystack.owned_value_at(0));
                        self.result = top_compstmt.map(Box::new);
                        yyval = Value::None;

                        self.current_arg_stack.pop();
                        self.max_numparam_stack.pop();
                    },


  4 =>  /* top_compstmt: top_stmts opt_terms  */
  /* "src/parser/parser.y":365  */
                    {
                        // TODO: run void_stmts
                        yyval = Value::MaybeNode(
                            self.builder.compstmt( NodeList::from(yystack.owned_value_at(1)))
                        );
                    },


  5 =>  /* top_stmts: none  */
  /* "src/parser/parser.y":374  */
                    {
                      yyval = Value::NodeList( Box::new(vec![]) );
                    },


  6 =>  /* top_stmts: top_stmt  */
  /* "src/parser/parser.y":378  */
                    {
                      yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  7 =>  /* top_stmts: top_stmts terms top_stmt  */
  /* "src/parser/parser.y":382  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList( nodes );
                    },


  8 =>  /* top_stmts: error top_stmt  */
  /* "src/parser/parser.y":388  */
                    {
                      yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  9 =>  /* top_stmt: stmt  */
  /* "src/parser/parser.y":394  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  10 =>  /* top_stmt: "`BEGIN'" begin_block  */
  /* "src/parser/parser.y":398  */
                    {
                        let BeginBlock { begin_t, body, end_t } =  BeginBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.preexe( Token::from(yystack.owned_value_at(1)), begin_t, body, end_t)
                        );
                    },


  11 =>  /* begin_block: "{ (tLCURLY)" top_compstmt "}"  */
  /* "src/parser/parser.y":407  */
                    {
                        yyval = Value::new_begin_block(
                            BeginBlock {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  12 =>  /* bodystmt: compstmt opt_rescue k_else compstmt opt_ensure  */
  /* "src/parser/parser.y":422  */
                    {
                        let compound_stmt =  MaybeBoxedNode::from(yystack.owned_value_at(4));
                        let rescue_bodies =  NodeList::from(yystack.owned_value_at(3));
                        if rescue_bodies.is_empty() {
                            return self.yyerror(yystack.location_at (2), DiagnosticMessage::ElseWithoutRescue {});
                        }

                        let else_ = Some((  Token::from(yystack.owned_value_at(2)),  MaybeBoxedNode::from(yystack.owned_value_at(1)) ));
                        let ensure =  OptEnsure::from(yystack.owned_value_at(0)).map(|ensure| (ensure.ensure_t, ensure.body));

                        yyval = Value::MaybeNode(
                            self.builder.begin_body(
                                compound_stmt,
                                rescue_bodies,
                                else_,
                                ensure
                            )
                        );
                    },


  13 =>  /* bodystmt: compstmt opt_rescue opt_ensure  */
  /* "src/parser/parser.y":444  */
                    {
                        let compound_stmt =  MaybeBoxedNode::from(yystack.owned_value_at(2));
                        let rescue_bodies =  NodeList::from(yystack.owned_value_at(1));
                        let ensure =  OptEnsure::from(yystack.owned_value_at(0)).map(|ensure| (ensure.ensure_t, ensure.body));

                        yyval = Value::MaybeNode(
                            self.builder.begin_body(
                                compound_stmt,
                                rescue_bodies,
                                None,
                                ensure
                            )
                        );
                    },


  14 =>  /* compstmt: stmts opt_terms  */
  /* "src/parser/parser.y":461  */
                    {
                        // TODO: run void_stmts
                        yyval = Value::MaybeNode(
                            self.builder.compstmt( NodeList::from(yystack.owned_value_at(1)))
                        );
                    },


  15 =>  /* stmts: none  */
  /* "src/parser/parser.y":470  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  16 =>  /* stmts: stmt_or_begin  */
  /* "src/parser/parser.y":474  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  17 =>  /* stmts: stmts terms stmt_or_begin  */
  /* "src/parser/parser.y":478  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  18 =>  /* stmts: error  */
  /* "src/parser/parser.y":484  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  19 =>  /* stmt_or_begin: stmt  */
  /* "src/parser/parser.y":490  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  20 =>  /* $@2: %empty  */
  /* "src/parser/parser.y":494  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::BeginNotAtTopLevel {});
                    },


  21 =>  /* stmt_or_begin: "`BEGIN'" $@2 begin_block  */
  /* "src/parser/parser.y":498  */
                    {
                        yyval = Value::None;
                    },


  22 =>  /* @3: %empty  */
  /* "src/parser/parser.y":504  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME|EXPR_FITEM);
                        yyval = Value::None;
                    },


  23 =>  /* stmt: "`alias'" fitem @3 fitem  */
  /* "src/parser/parser.y":509  */
                    {
                        yyval = Value::Node(
                            self.builder.alias( Token::from(yystack.owned_value_at(3)),  BoxedNode::from(yystack.owned_value_at(2)),  BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  24 =>  /* stmt: "`alias'" "global variable" "global variable"  */
  /* "src/parser/parser.y":515  */
                    {
                        yyval = Value::Node(
                            self.builder.alias(
                                 Token::from(yystack.owned_value_at(2)),
                                self.builder.gvar( Token::from(yystack.owned_value_at(1))),
                                self.builder.gvar( Token::from(yystack.owned_value_at(0))),
                            )
                        )
                    },


  25 =>  /* stmt: "`alias'" "global variable" "back reference"  */
  /* "src/parser/parser.y":525  */
                    {
                        yyval = Value::Node(
                            self.builder.alias(
                                 Token::from(yystack.owned_value_at(2)),
                                self.builder.gvar( Token::from(yystack.owned_value_at(1))),
                                self.builder.back_ref( Token::from(yystack.owned_value_at(0))),
                            )
                        )
                    },


  26 =>  /* stmt: "`alias'" "global variable" "numbered reference"  */
  /* "src/parser/parser.y":535  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::AliasNthRef {});
                    },


  27 =>  /* stmt: "`undef'" undef_list  */
  /* "src/parser/parser.y":539  */
                    {
                        yyval = Value::Node(
                            self.builder.undef_method(
                                 Token::from(yystack.owned_value_at(1)),
                                 NodeList::from(yystack.owned_value_at(0))
                            )
                        )
                    },


  28 =>  /* stmt: stmt "`if' modifier" expr_value  */
  /* "src/parser/parser.y":548  */
                    {
                        yyval = Value::Node(
                            self.builder.condition_mod(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  29 =>  /* stmt: stmt "`unless' modifier" expr_value  */
  /* "src/parser/parser.y":559  */
                    {
                        yyval = Value::Node(
                            self.builder.condition_mod(
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  30 =>  /* stmt: stmt "`while' modifier" expr_value  */
  /* "src/parser/parser.y":570  */
                    {
                        yyval = Value::Node(
                            self.builder.loop_mod(
                                LoopType::While,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  31 =>  /* stmt: stmt "`until' modifier" expr_value  */
  /* "src/parser/parser.y":581  */
                    {
                        yyval = Value::Node(
                            self.builder.loop_mod(
                                LoopType::Until,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  32 =>  /* stmt: stmt "`rescue' modifier" stmt  */
  /* "src/parser/parser.y":592  */
                    {
                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                vec![*rescue_body],
                                None,
                                None,
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  33 =>  /* stmt: "`END'" "{ (tLCURLY)" compstmt "}"  */
  /* "src/parser/parser.y":612  */
                    {
                        if self.context.in_def() {
                            self.warn(yystack.location_at (3), DiagnosticMessage::EndInMethod {});
                        }

                        yyval = Value::Node(
                            self.builder.postexe(
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  34 =>  /* stmt: command_asgn  */
  /* "src/parser/parser.y":627  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  35 =>  /* stmt: mlhs "=" command_call  */
  /* "src/parser/parser.y":631  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&command_call)?;

                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                command_call
                            )
                        );
                    },


  36 =>  /* stmt: lhs "=" mrhs  */
  /* "src/parser/parser.y":644  */
                    {
                        let mrhs = self.builder.array(
                            None,
                             NodeList::from(yystack.owned_value_at(0)),
                            None
                        );
                        self.value_expr(&mrhs)?;

                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                mrhs
                            )
                        );
                    },


  37 =>  /* stmt: mlhs "=" mrhs_arg "`rescue' modifier" stmt  */
  /* "src/parser/parser.y":661  */
                    {
                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let mrhs_arg =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&mrhs_arg)?;

                        let begin_body = self.builder.begin_body(
                            Some(mrhs_arg),
                            vec![ *rescue_body ],
                            None,
                            None,
                        ).expect("expected begin_body to return Some (compound_stmt was given)");

                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                begin_body
                            )
                        );
                    },


  38 =>  /* stmt: mlhs "=" mrhs_arg  */
  /* "src/parser/parser.y":690  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  39 =>  /* stmt: expr  */
  /* "src/parser/parser.y":700  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  40 =>  /* command_asgn: lhs "=" command_rhs  */
  /* "src/parser/parser.y":706  */
                    {
                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  41 =>  /* command_asgn: var_lhs "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":716  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  42 =>  /* command_asgn: primary_value "[ (tLBRACK2)" opt_call_args rbracket "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":726  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.index(
                                     BoxedNode::from(yystack.owned_value_at(5)),
                                     Token::from(yystack.owned_value_at(4)),
                                     NodeList::from(yystack.owned_value_at(3)),
                                     Token::from(yystack.owned_value_at(2))
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  43 =>  /* command_asgn: primary_value call_op "local variable or method" "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":741  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  44 =>  /* command_asgn: primary_value call_op "constant" "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":758  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  45 =>  /* command_asgn: primary_value "::" "constant" "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":775  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  46 =>  /* command_asgn: primary_value "::" "local variable or method" "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":792  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  47 =>  /* command_asgn: defn_head f_opt_paren_args "=" command  */
  /* "src/parser/parser.y":809  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  48 =>  /* command_asgn: defn_head f_opt_paren_args "=" command "`rescue' modifier" arg  */
  /* "src/parser/parser.y":829  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(5));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0))),
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None,
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body,
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  49 =>  /* command_asgn: defs_head f_opt_paren_args "=" command  */
  /* "src/parser/parser.y":865  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  50 =>  /* command_asgn: defs_head f_opt_paren_args "=" command "`rescue' modifier" arg  */
  /* "src/parser/parser.y":887  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(5));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0))),
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None,
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body,
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  51 =>  /* command_asgn: backref "operator-assignment" command_rhs  */
  /* "src/parser/parser.y":925  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  52 =>  /* command_rhs: command_call  */
  /* "src/parser/parser.y":937  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&command_call)?;
                        yyval = Value::Node(command_call);
                    },


  53 =>  /* command_rhs: command_call "`rescue' modifier" stmt  */
  /* "src/parser/parser.y":943  */
                    {
                        let command_call =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&command_call)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some(command_call),
                                vec![ *rescue_body ],
                                None,
                                None,
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  54 =>  /* command_rhs: command_asgn  */
  /* "src/parser/parser.y":966  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  55 =>  /* expr: command_call  */
  /* "src/parser/parser.y":972  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  56 =>  /* expr: expr "`and'" expr  */
  /* "src/parser/parser.y":976  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::And,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  57 =>  /* expr: expr "`or'" expr  */
  /* "src/parser/parser.y":987  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::Or,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  58 =>  /* expr: "`not'" opt_nl expr  */
  /* "src/parser/parser.y":998  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(2)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  59 =>  /* expr: "!" command_call  */
  /* "src/parser/parser.y":1009  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  60 =>  /* @4: %empty  */
  /* "src/parser/parser.y":1020  */
                    {
                        let arg = match yystack.borrow_value_at(1) {
                            Value::Node(node) => node,
                            other => unreachable!("expected Node, got {:?}", other)
                        };
                        self.value_expr(arg)?;

                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();

                        yyval = Value::Bool(self.context.in_kwarg());
                        self.context.set_in_kwarg(true);
                    },


  61 =>  /* expr: arg "=>" @4 p_top_expr_body  */
  /* "src/parser/parser.y":1035  */
                    {
                        self.pattern_variables.pop();
                        self.context.set_in_kwarg( Bool::from(yystack.owned_value_at(1)));

                        yyval = Value::Node(
                            self.builder.match_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  62 =>  /* @5: %empty  */
  /* "src/parser/parser.y":1048  */
                    {
                        let arg = match yystack.borrow_value_at(1) {
                            Value::Node(node) => node,
                            other => unreachable!("expected Node, got {:?}", other)
                        };
                        self.value_expr(arg)?;

                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();

                        yyval = Value::Bool(self.context.in_kwarg());
                        self.context.set_in_kwarg(true);
                    },


  63 =>  /* expr: arg "`in'" @5 p_top_expr_body  */
  /* "src/parser/parser.y":1063  */
                    {
                        self.pattern_variables.pop();
                        self.context.set_in_kwarg( Bool::from(yystack.owned_value_at(1)));

                        yyval = Value::Node(
                            self.builder.match_pattern_p(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  64 =>  /* expr: arg  */
  /* "src/parser/parser.y":1076  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  65 =>  /* def_name: fname  */
  /* "src/parser/parser.y":1082  */
                    {
                        self.local_push();
                        self.current_arg_stack.push(None);

                        yyval = Value::TokenWithContext(
                            Box::new(
                                TokenWithContext {
                                    token:  Token::from(yystack.owned_value_at(0)),
                                    ctx: self.context.dump()
                                }
                            )
                        );

                        self.context.set_in_def(true);
                    },


  66 =>  /* defn_head: k_def def_name  */
  /* "src/parser/parser.y":1100  */
                    {
                        yyval = Value::new_defn_head(
                            DefnHead {
                                def_t:  Token::from(yystack.owned_value_at(1)),
                                name_t:  TokenWithContext::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  67 =>  /* @6: %empty  */
  /* "src/parser/parser.y":1111  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME);
                        self.context.set_in_argdef(true);
                        yyval = Value::None;
                    },


  68 =>  /* defs_head: k_def singleton dot_or_colon @6 def_name  */
  /* "src/parser/parser.y":1117  */
                    {
                        self.yylexer.lex_state.set(EXPR_ENDFN|EXPR_LABEL);

                        yyval = Value::new_defs_head(
                            DefsHead {
                                def_t:  Token::from(yystack.owned_value_at(4)),
                                definee:  BoxedNode::from(yystack.owned_value_at(3)),
                                dot_t:  Token::from(yystack.owned_value_at(2)),
                                name_t:  TokenWithContext::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  69 =>  /* expr_value: expr  */
  /* "src/parser/parser.y":1132  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&expr)?;
                        yyval = Value::Node(expr);
                    },


  70 =>  /* @7: %empty  */
  /* "src/parser/parser.y":1139  */
                    {
                        self.yylexer.cond.push(true);
                        yyval = Value::None;
                    },


  71 =>  /* expr_value_do: @7 expr_value do  */
  /* "src/parser/parser.y":1144  */
                    {
                        self.yylexer.cond.pop();

                        yyval = Value::new_expr_value_do(
                            ExprValueDo {
                                value:  BoxedNode::from(yystack.owned_value_at(1)),
                                do_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  72 =>  /* command_call: command  */
  /* "src/parser/parser.y":1158  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  73 =>  /* command_call: block_command  */
  /* "src/parser/parser.y":1162  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  74 =>  /* block_command: block_call  */
  /* "src/parser/parser.y":1168  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  75 =>  /* block_command: block_call call_op2 operation2 command_args  */
  /* "src/parser/parser.y":1172  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  76 =>  /* @8: %empty  */
  /* "src/parser/parser.y":1187  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_block(true);
                    },


  77 =>  /* cmd_brace_block: "{ arg" @8 brace_body "}"  */
  /* "src/parser/parser.y":1192  */
                    {
                        self.context.set_in_block( Context::from(yystack.owned_value_at(2)).in_block());
                        let BraceBody { args_type, body } =  BraceBody::from(yystack.owned_value_at(1));
                        yyval = Value::new_cmd_brace_block(
                            CmdBraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  78 =>  /* fcall: operation  */
  /* "src/parser/parser.y":1207  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  79 =>  /* command: fcall command_args  */
  /* "src/parser/parser.y":1213  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  80 =>  /* command: fcall command_args cmd_brace_block  */
  /* "src/parser/parser.y":1226  */
                    {
                        let method_call = self.builder.call_method(
                            None,
                            None,
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  81 =>  /* command: primary_value call_op operation2 command_args  */
  /* "src/parser/parser.y":1248  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  82 =>  /* command: primary_value call_op operation2 command_args cmd_brace_block  */
  /* "src/parser/parser.y":1261  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  83 =>  /* command: primary_value "::" operation2 command_args  */
  /* "src/parser/parser.y":1283  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  84 =>  /* command: primary_value "::" operation2 command_args cmd_brace_block  */
  /* "src/parser/parser.y":1296  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );
                        let CmdBraceBlock { begin_t, args_type, body, end_t } =  CmdBraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  85 =>  /* command: "`super'" command_args  */
  /* "src/parser/parser.y":1318  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Super,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  86 =>  /* command: "`yield'" command_args  */
  /* "src/parser/parser.y":1330  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  87 =>  /* command: k_return call_args  */
  /* "src/parser/parser.y":1342  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Return,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  88 =>  /* command: "`break'" call_args  */
  /* "src/parser/parser.y":1354  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Break,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  89 =>  /* command: "`next'" call_args  */
  /* "src/parser/parser.y":1366  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Next,
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  90 =>  /* mlhs: mlhs_basic  */
  /* "src/parser/parser.y":1380  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  91 =>  /* mlhs: "(" mlhs_inner rparen  */
  /* "src/parser/parser.y":1390  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  92 =>  /* mlhs_inner: mlhs_basic  */
  /* "src/parser/parser.y":1402  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  93 =>  /* mlhs_inner: "(" mlhs_inner rparen  */
  /* "src/parser/parser.y":1412  */
                    {
                        let mlhs_inner =  Node::from(yystack.owned_value_at(1));
                        let mlhs_items = match mlhs_inner {
                            Node::Mlhs(nodes::Mlhs { items, .. }) => {
                                items
                            }
                            other => {
                                unreachable!("unsupported mlhs item {:?}", other)
                            }
                        };

                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                mlhs_items,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  94 =>  /* mlhs_basic: mlhs_head  */
  /* "src/parser/parser.y":1434  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  95 =>  /* mlhs_basic: mlhs_head mlhs_item  */
  /* "src/parser/parser.y":1438  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  96 =>  /* mlhs_basic: mlhs_head "*" mlhs_node  */
  /* "src/parser/parser.y":1444  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        let mlhs_node = *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))));
                        nodes.push(mlhs_node);
                        yyval = Value::NodeList(nodes);
                    },


  97 =>  /* mlhs_basic: mlhs_head "*" mlhs_node "," mlhs_post  */
  /* "src/parser/parser.y":1451  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(4));
                        let mlhs_node = *self.builder.splat( Token::from(yystack.owned_value_at(3)), Some( BoxedNode::from(yystack.owned_value_at(2))));
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + mlhs_post.len());
                        nodes.push(mlhs_node);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  98 =>  /* mlhs_basic: mlhs_head "*"  */
  /* "src/parser/parser.y":1463  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(0)), None);
                        nodes.push(splat);
                        yyval = Value::NodeList(nodes);
                    },


  99 =>  /* mlhs_basic: mlhs_head "*" "," mlhs_post  */
  /* "src/parser/parser.y":1470  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(2)), None);
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + mlhs_post.len());
                        nodes.push(splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  100 =>  /* mlhs_basic: "*" mlhs_node  */
  /* "src/parser/parser.y":1482  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.splat(
                                         Token::from(yystack.owned_value_at(1)),
                                        Some( BoxedNode::from(yystack.owned_value_at(0)))
                                    )
                                ]
                            )
                        );
                    },


  101 =>  /* mlhs_basic: "*" mlhs_node "," mlhs_post  */
  /* "src/parser/parser.y":1495  */
                    {
                        let mut nodes;
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(3)), Some( BoxedNode::from(yystack.owned_value_at(2))));
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Box::new(Vec::with_capacity(1 + mlhs_post.len()));
                        nodes.push(splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  102 =>  /* mlhs_basic: "*"  */
  /* "src/parser/parser.y":1507  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.splat(
                                         Token::from(yystack.owned_value_at(0)),
                                        None
                                    )
                                ]
                            )
                        );
                    },


  103 =>  /* mlhs_basic: "*" "," mlhs_post  */
  /* "src/parser/parser.y":1520  */
                    {
                        let mut nodes;
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(2)), None);
                        let mut mlhs_post =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Box::new(Vec::with_capacity(1 + mlhs_post.len()));
                        nodes.push(splat);
                        nodes.append(&mut mlhs_post);

                        yyval = Value::NodeList(nodes);
                    },


  104 =>  /* mlhs_item: mlhs_node  */
  /* "src/parser/parser.y":1534  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  105 =>  /* mlhs_item: "(" mlhs_inner rparen  */
  /* "src/parser/parser.y":1538  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  106 =>  /* mlhs_head: mlhs_item ","  */
  /* "src/parser/parser.y":1550  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(1)) ]) );
                    },


  107 =>  /* mlhs_head: mlhs_head mlhs_item ","  */
  /* "src/parser/parser.y":1554  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(1)) );
                        yyval = Value::NodeList(nodes);
                    },


  108 =>  /* mlhs_post: mlhs_item  */
  /* "src/parser/parser.y":1562  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  109 =>  /* mlhs_post: mlhs_post "," mlhs_item  */
  /* "src/parser/parser.y":1566  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  110 =>  /* mlhs_node: user_variable  */
  /* "src/parser/parser.y":1574  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  111 =>  /* mlhs_node: keyword_variable  */
  /* "src/parser/parser.y":1580  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  112 =>  /* mlhs_node: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser/parser.y":1586  */
                    {
                        yyval = Value::Node(
                            self.builder.index_asgn(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  113 =>  /* mlhs_node: primary_value call_op "local variable or method"  */
  /* "src/parser/parser.y":1597  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        if op_t.token_type == Lexer::tANDDOT {
                            return self.yyerror(yystack.location_at (1), DiagnosticMessage::CsendInsideMasgn {});
                        }

                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  114 =>  /* mlhs_node: primary_value "::" "local variable or method"  */
  /* "src/parser/parser.y":1612  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  115 =>  /* mlhs_node: primary_value call_op "constant"  */
  /* "src/parser/parser.y":1622  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        if op_t.token_type == Lexer::tANDDOT {
                            return self.yyerror(yystack.location_at (1), DiagnosticMessage::CsendInsideMasgn {});
                        }

                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  116 =>  /* mlhs_node: primary_value "::" "constant"  */
  /* "src/parser/parser.y":1637  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_fetch(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0))
                                )
                            )?
                        );
                    },


  117 =>  /* mlhs_node: ":: at EXPR_BEG" "constant"  */
  /* "src/parser/parser.y":1649  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_global(
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0))
                                )
                            )?
                        );
                    },


  118 =>  /* mlhs_node: backref  */
  /* "src/parser/parser.y":1660  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  119 =>  /* lhs: user_variable  */
  /* "src/parser/parser.y":1670  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  120 =>  /* lhs: keyword_variable  */
  /* "src/parser/parser.y":1676  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  121 =>  /* lhs: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser/parser.y":1682  */
                    {
                        yyval = Value::Node(
                            self.builder.index_asgn(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        )
                    },


  122 =>  /* lhs: primary_value call_op "local variable or method"  */
  /* "src/parser/parser.y":1693  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  123 =>  /* lhs: primary_value "::" "local variable or method"  */
  /* "src/parser/parser.y":1703  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  124 =>  /* lhs: primary_value call_op "constant"  */
  /* "src/parser/parser.y":1713  */
                    {
                        yyval = Value::Node(
                            self.builder.attr_asgn(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  125 =>  /* lhs: primary_value "::" "constant"  */
  /* "src/parser/parser.y":1723  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_fetch(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0)),
                                )
                            )?
                        );
                    },


  126 =>  /* lhs: ":: at EXPR_BEG" "constant"  */
  /* "src/parser/parser.y":1735  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.const_global(
                                     Token::from(yystack.owned_value_at(1)),
                                     Token::from(yystack.owned_value_at(0)),
                                )
                            )?
                        );
                    },


  127 =>  /* lhs: backref  */
  /* "src/parser/parser.y":1746  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  128 =>  /* cname: "local variable or method"  */
  /* "src/parser/parser.y":1756  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::ClassOrModuleNameMustBeConstant {});
                    },


  129 =>  /* cname: "constant"  */
  /* "src/parser/parser.y":1760  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  130 =>  /* cpath: ":: at EXPR_BEG" cname  */
  /* "src/parser/parser.y":1766  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  131 =>  /* cpath: cname  */
  /* "src/parser/parser.y":1772  */
                    {
                        yyval = Value::Node(
                            self.builder.const_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  132 =>  /* cpath: primary_value "::" cname  */
  /* "src/parser/parser.y":1778  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  133 =>  /* fname: "local variable or method"  */
  /* "src/parser/parser.y":1790  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  134 =>  /* fname: "constant"  */
  /* "src/parser/parser.y":1794  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  135 =>  /* fname: "method"  */
  /* "src/parser/parser.y":1798  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  136 =>  /* fname: op  */
  /* "src/parser/parser.y":1802  */
                    {
                        self.yylexer.lex_state.set(EXPR_ENDFN);
                        yyval =  yystack.owned_value_at(0);
                    },


  137 =>  /* fname: reswords  */
  /* "src/parser/parser.y":1807  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  138 =>  /* fitem: fname  */
  /* "src/parser/parser.y":1813  */
                    {
                        yyval = Value::Node(
                            self.builder.symbol_internal( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  139 =>  /* fitem: symbol  */
  /* "src/parser/parser.y":1819  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  140 =>  /* undef_list: fitem  */
  /* "src/parser/parser.y":1825  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  141 =>  /* @9: %empty  */
  /* "src/parser/parser.y":1829  */
                    {
                        self.yylexer.lex_state.set(EXPR_FNAME|EXPR_FITEM);
                        yyval = Value::None;
                    },


  142 =>  /* undef_list: undef_list "," @9 fitem  */
  /* "src/parser/parser.y":1834  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  143 =>  /* op: "|"  */
  /* "src/parser/parser.y":1841  */
                             { yyval =  yystack.owned_value_at(0); },


  144 =>  /* op: "^"  */
  /* "src/parser/parser.y":1842  */
                             { yyval =  yystack.owned_value_at(0); },


  145 =>  /* op: "& (tAMPER2)"  */
  /* "src/parser/parser.y":1843  */
                             { yyval =  yystack.owned_value_at(0); },


  146 =>  /* op: "<=>"  */
  /* "src/parser/parser.y":1844  */
                             { yyval =  yystack.owned_value_at(0); },


  147 =>  /* op: "=="  */
  /* "src/parser/parser.y":1845  */
                             { yyval =  yystack.owned_value_at(0); },


  148 =>  /* op: "==="  */
  /* "src/parser/parser.y":1846  */
                             { yyval =  yystack.owned_value_at(0); },


  149 =>  /* op: "=~"  */
  /* "src/parser/parser.y":1847  */
                             { yyval =  yystack.owned_value_at(0); },


  150 =>  /* op: "!~"  */
  /* "src/parser/parser.y":1848  */
                             { yyval =  yystack.owned_value_at(0); },


  151 =>  /* op: ">"  */
  /* "src/parser/parser.y":1849  */
                             { yyval =  yystack.owned_value_at(0); },


  152 =>  /* op: ">="  */
  /* "src/parser/parser.y":1850  */
                             { yyval =  yystack.owned_value_at(0); },


  153 =>  /* op: "<"  */
  /* "src/parser/parser.y":1851  */
                             { yyval =  yystack.owned_value_at(0); },


  154 =>  /* op: "<="  */
  /* "src/parser/parser.y":1852  */
                             { yyval =  yystack.owned_value_at(0); },


  155 =>  /* op: "!="  */
  /* "src/parser/parser.y":1853  */
                             { yyval =  yystack.owned_value_at(0); },


  156 =>  /* op: "<<"  */
  /* "src/parser/parser.y":1854  */
                             { yyval =  yystack.owned_value_at(0); },


  157 =>  /* op: ">>"  */
  /* "src/parser/parser.y":1855  */
                             { yyval =  yystack.owned_value_at(0); },


  158 =>  /* op: "+"  */
  /* "src/parser/parser.y":1856  */
                             { yyval =  yystack.owned_value_at(0); },


  159 =>  /* op: "-"  */
  /* "src/parser/parser.y":1857  */
                             { yyval =  yystack.owned_value_at(0); },


  160 =>  /* op: "* (tSTAR2)"  */
  /* "src/parser/parser.y":1858  */
                             { yyval =  yystack.owned_value_at(0); },


  161 =>  /* op: "*"  */
  /* "src/parser/parser.y":1859  */
                             { yyval =  yystack.owned_value_at(0); },


  162 =>  /* op: "/"  */
  /* "src/parser/parser.y":1860  */
                             { yyval =  yystack.owned_value_at(0); },


  163 =>  /* op: "%"  */
  /* "src/parser/parser.y":1861  */
                             { yyval =  yystack.owned_value_at(0); },


  164 =>  /* op: "**"  */
  /* "src/parser/parser.y":1862  */
                             { yyval =  yystack.owned_value_at(0); },


  165 =>  /* op: "**arg"  */
  /* "src/parser/parser.y":1863  */
                             { yyval =  yystack.owned_value_at(0); },


  166 =>  /* op: "!"  */
  /* "src/parser/parser.y":1864  */
                             { yyval =  yystack.owned_value_at(0); },


  167 =>  /* op: "~"  */
  /* "src/parser/parser.y":1865  */
                             { yyval =  yystack.owned_value_at(0); },


  168 =>  /* op: "unary+"  */
  /* "src/parser/parser.y":1866  */
                             { yyval =  yystack.owned_value_at(0); },


  169 =>  /* op: "unary-"  */
  /* "src/parser/parser.y":1867  */
                             { yyval =  yystack.owned_value_at(0); },


  170 =>  /* op: "[]"  */
  /* "src/parser/parser.y":1868  */
                             { yyval =  yystack.owned_value_at(0); },


  171 =>  /* op: "[]="  */
  /* "src/parser/parser.y":1869  */
                             { yyval =  yystack.owned_value_at(0); },


  172 =>  /* op: "`"  */
  /* "src/parser/parser.y":1870  */
                             { yyval =  yystack.owned_value_at(0); },


  173 =>  /* reswords: "`__LINE__'"  */
  /* "src/parser/parser.y":1873  */
                                { yyval =  yystack.owned_value_at(0); },


  174 =>  /* reswords: "`__FILE__'"  */
  /* "src/parser/parser.y":1874  */
                                { yyval =  yystack.owned_value_at(0); },


  175 =>  /* reswords: "`__ENCODING__'"  */
  /* "src/parser/parser.y":1875  */
                                { yyval =  yystack.owned_value_at(0); },


  176 =>  /* reswords: "`BEGIN'"  */
  /* "src/parser/parser.y":1876  */
                                { yyval =  yystack.owned_value_at(0); },


  177 =>  /* reswords: "`END'"  */
  /* "src/parser/parser.y":1877  */
                                { yyval =  yystack.owned_value_at(0); },


  178 =>  /* reswords: "`alias'"  */
  /* "src/parser/parser.y":1878  */
                                { yyval =  yystack.owned_value_at(0); },


  179 =>  /* reswords: "`and'"  */
  /* "src/parser/parser.y":1879  */
                                { yyval =  yystack.owned_value_at(0); },


  180 =>  /* reswords: "`begin'"  */
  /* "src/parser/parser.y":1880  */
                                { yyval =  yystack.owned_value_at(0); },


  181 =>  /* reswords: "`break'"  */
  /* "src/parser/parser.y":1881  */
                                { yyval =  yystack.owned_value_at(0); },


  182 =>  /* reswords: "`case'"  */
  /* "src/parser/parser.y":1882  */
                                { yyval =  yystack.owned_value_at(0); },


  183 =>  /* reswords: "`class'"  */
  /* "src/parser/parser.y":1883  */
                                { yyval =  yystack.owned_value_at(0); },


  184 =>  /* reswords: "`def'"  */
  /* "src/parser/parser.y":1884  */
                                { yyval =  yystack.owned_value_at(0); },


  185 =>  /* reswords: "`defined?'"  */
  /* "src/parser/parser.y":1885  */
                                { yyval =  yystack.owned_value_at(0); },


  186 =>  /* reswords: "`do'"  */
  /* "src/parser/parser.y":1886  */
                                { yyval =  yystack.owned_value_at(0); },


  187 =>  /* reswords: "`else'"  */
  /* "src/parser/parser.y":1887  */
                                { yyval =  yystack.owned_value_at(0); },


  188 =>  /* reswords: "`elsif'"  */
  /* "src/parser/parser.y":1888  */
                                { yyval =  yystack.owned_value_at(0); },


  189 =>  /* reswords: "`end'"  */
  /* "src/parser/parser.y":1889  */
                                { yyval =  yystack.owned_value_at(0); },


  190 =>  /* reswords: "`ensure'"  */
  /* "src/parser/parser.y":1890  */
                                { yyval =  yystack.owned_value_at(0); },


  191 =>  /* reswords: "`false'"  */
  /* "src/parser/parser.y":1891  */
                                { yyval =  yystack.owned_value_at(0); },


  192 =>  /* reswords: "`for'"  */
  /* "src/parser/parser.y":1892  */
                                { yyval =  yystack.owned_value_at(0); },


  193 =>  /* reswords: "`in'"  */
  /* "src/parser/parser.y":1893  */
                                { yyval =  yystack.owned_value_at(0); },


  194 =>  /* reswords: "`module'"  */
  /* "src/parser/parser.y":1894  */
                                { yyval =  yystack.owned_value_at(0); },


  195 =>  /* reswords: "`next'"  */
  /* "src/parser/parser.y":1895  */
                                { yyval =  yystack.owned_value_at(0); },


  196 =>  /* reswords: "`nil'"  */
  /* "src/parser/parser.y":1896  */
                                { yyval =  yystack.owned_value_at(0); },


  197 =>  /* reswords: "`not'"  */
  /* "src/parser/parser.y":1897  */
                                { yyval =  yystack.owned_value_at(0); },


  198 =>  /* reswords: "`or'"  */
  /* "src/parser/parser.y":1898  */
                                { yyval =  yystack.owned_value_at(0); },


  199 =>  /* reswords: "`redo'"  */
  /* "src/parser/parser.y":1899  */
                                { yyval =  yystack.owned_value_at(0); },


  200 =>  /* reswords: "`rescue'"  */
  /* "src/parser/parser.y":1900  */
                                { yyval =  yystack.owned_value_at(0); },


  201 =>  /* reswords: "`retry'"  */
  /* "src/parser/parser.y":1901  */
                                { yyval =  yystack.owned_value_at(0); },


  202 =>  /* reswords: "`return'"  */
  /* "src/parser/parser.y":1902  */
                                { yyval =  yystack.owned_value_at(0); },


  203 =>  /* reswords: "`self'"  */
  /* "src/parser/parser.y":1903  */
                                { yyval =  yystack.owned_value_at(0); },


  204 =>  /* reswords: "`super'"  */
  /* "src/parser/parser.y":1904  */
                                { yyval =  yystack.owned_value_at(0); },


  205 =>  /* reswords: "`then'"  */
  /* "src/parser/parser.y":1905  */
                                { yyval =  yystack.owned_value_at(0); },


  206 =>  /* reswords: "`true'"  */
  /* "src/parser/parser.y":1906  */
                                { yyval =  yystack.owned_value_at(0); },


  207 =>  /* reswords: "`undef'"  */
  /* "src/parser/parser.y":1907  */
                                { yyval =  yystack.owned_value_at(0); },


  208 =>  /* reswords: "`when'"  */
  /* "src/parser/parser.y":1908  */
                                { yyval =  yystack.owned_value_at(0); },


  209 =>  /* reswords: "`yield'"  */
  /* "src/parser/parser.y":1909  */
                                { yyval =  yystack.owned_value_at(0); },


  210 =>  /* reswords: "`if'"  */
  /* "src/parser/parser.y":1910  */
                                { yyval =  yystack.owned_value_at(0); },


  211 =>  /* reswords: "`unless'"  */
  /* "src/parser/parser.y":1911  */
                                { yyval =  yystack.owned_value_at(0); },


  212 =>  /* reswords: "`while'"  */
  /* "src/parser/parser.y":1912  */
                                { yyval =  yystack.owned_value_at(0); },


  213 =>  /* reswords: "`until'"  */
  /* "src/parser/parser.y":1913  */
                                { yyval =  yystack.owned_value_at(0); },


  214 =>  /* arg: lhs "=" arg_rhs  */
  /* "src/parser/parser.y":1917  */
                    {
                        yyval = Value::Node(
                            self.builder.assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  215 =>  /* arg: var_lhs "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":1927  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  216 =>  /* arg: primary_value "[ (tLBRACK2)" opt_call_args rbracket "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":1937  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.index(
                                     BoxedNode::from(yystack.owned_value_at(5)),
                                     Token::from(yystack.owned_value_at(4)),
                                     NodeList::from(yystack.owned_value_at(3)),
                                     Token::from(yystack.owned_value_at(2))
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  217 =>  /* arg: primary_value call_op "local variable or method" "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":1952  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  218 =>  /* arg: primary_value call_op "constant" "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":1969  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  219 =>  /* arg: primary_value "::" "local variable or method" "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":1986  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                self.builder.call_method(
                                    Some( BoxedNode::from(yystack.owned_value_at(4))),
                                    Some( Token::from(yystack.owned_value_at(3))),
                                    Some( Token::from(yystack.owned_value_at(2))),
                                    None,
                                    vec![],
                                    None
                                ),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  220 =>  /* arg: primary_value "::" "constant" "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":2003  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  221 =>  /* arg: ":: at EXPR_BEG" "constant" "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":2020  */
                    {
                        let const_ = self.builder.const_op_assignable(
                            self.builder.const_global(
                                 Token::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2))
                            )
                        );
                        yyval = Value::Node(
                            self.builder.op_assign(
                                const_,
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  222 =>  /* arg: backref "operator-assignment" arg_rhs  */
  /* "src/parser/parser.y":2036  */
                    {
                        yyval = Value::Node(
                            self.builder.op_assign(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  223 =>  /* arg: arg ".." arg  */
  /* "src/parser/parser.y":2046  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  224 =>  /* arg: arg "..." arg  */
  /* "src/parser/parser.y":2062  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  225 =>  /* arg: arg ".."  */
  /* "src/parser/parser.y":2078  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  226 =>  /* arg: arg "..."  */
  /* "src/parser/parser.y":2091  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  227 =>  /* arg: "(.." arg  */
  /* "src/parser/parser.y":2104  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  228 =>  /* arg: "(..." arg  */
  /* "src/parser/parser.y":2117  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  229 =>  /* arg: arg "+" arg  */
  /* "src/parser/parser.y":2130  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  230 =>  /* arg: arg "-" arg  */
  /* "src/parser/parser.y":2136  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  231 =>  /* arg: arg "* (tSTAR2)" arg  */
  /* "src/parser/parser.y":2142  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  232 =>  /* arg: arg "/" arg  */
  /* "src/parser/parser.y":2148  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  233 =>  /* arg: arg "%" arg  */
  /* "src/parser/parser.y":2154  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  234 =>  /* arg: arg "**" arg  */
  /* "src/parser/parser.y":2160  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  235 =>  /* arg: tUMINUS_NUM simple_numeric "**" arg  */
  /* "src/parser/parser.y":2166  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(3)),
                                self.builder.binary_op(
                                     BoxedNode::from(yystack.owned_value_at(2)),
                                     Token::from(yystack.owned_value_at(1)),
                                     BoxedNode::from(yystack.owned_value_at(0))
                                )?
                            )?
                        );
                    },


  236 =>  /* arg: "unary+" arg  */
  /* "src/parser/parser.y":2179  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  237 =>  /* arg: "unary-" arg  */
  /* "src/parser/parser.y":2188  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  238 =>  /* arg: arg "|" arg  */
  /* "src/parser/parser.y":2197  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  239 =>  /* arg: arg "^" arg  */
  /* "src/parser/parser.y":2203  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  240 =>  /* arg: arg "& (tAMPER2)" arg  */
  /* "src/parser/parser.y":2209  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  241 =>  /* arg: arg "<=>" arg  */
  /* "src/parser/parser.y":2215  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  242 =>  /* arg: rel_expr  */
  /* "src/parser/parser.y":2221  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  243 =>  /* arg: arg "==" arg  */
  /* "src/parser/parser.y":2225  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  244 =>  /* arg: arg "===" arg  */
  /* "src/parser/parser.y":2231  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  245 =>  /* arg: arg "!=" arg  */
  /* "src/parser/parser.y":2237  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  246 =>  /* arg: arg "=~" arg  */
  /* "src/parser/parser.y":2243  */
                    {
                        yyval = Value::Node(
                            self.builder.match_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  247 =>  /* arg: arg "!~" arg  */
  /* "src/parser/parser.y":2249  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  248 =>  /* arg: "!" arg  */
  /* "src/parser/parser.y":2259  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(1)),
                                None,
                                Some( BoxedNode::from(yystack.owned_value_at(0))),
                                None
                            )?
                        );
                    },


  249 =>  /* arg: "~" arg  */
  /* "src/parser/parser.y":2270  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_op(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  250 =>  /* arg: arg "<<" arg  */
  /* "src/parser/parser.y":2279  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  251 =>  /* arg: arg ">>" arg  */
  /* "src/parser/parser.y":2285  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op( BoxedNode::from(yystack.owned_value_at(2)),  Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  252 =>  /* arg: arg "&&" arg  */
  /* "src/parser/parser.y":2291  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::And,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  253 =>  /* arg: arg "||" arg  */
  /* "src/parser/parser.y":2302  */
                    {
                        yyval = Value::Node(
                            self.builder.logical_op(
                                LogicalOp::Or,
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  254 =>  /* @10: %empty  */
  /* "src/parser/parser.y":2313  */
                    {
                        self.context.set_in_defined(true);
                        yyval = Value::None;
                    },


  255 =>  /* arg: "`defined?'" opt_nl @10 arg  */
  /* "src/parser/parser.y":2318  */
                    {
                        self.context.set_in_defined(false);
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Defined,
                                 Token::from(yystack.owned_value_at(3)),
                                None,
                                vec![  Node::from(yystack.owned_value_at(0)) ],
                                None
                            )?
                        );
                    },


  256 =>  /* arg: arg tEH arg opt_nl tCOLON arg  */
  /* "src/parser/parser.y":2331  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(5));
                        self.value_expr(&expr)?;

                        yyval = Value::Node(
                            self.builder.ternary(
                                expr,
                                 Token::from(yystack.owned_value_at(4)),
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  257 =>  /* arg: defn_head f_opt_paren_args "=" arg  */
  /* "src/parser/parser.y":2346  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0)))
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  258 =>  /* arg: defn_head f_opt_paren_args "=" arg "`rescue' modifier" arg  */
  /* "src/parser/parser.y":2366  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(5));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None,
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  259 =>  /* arg: defs_head f_opt_paren_args "=" arg  */
  /* "src/parser/parser.y":2402  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0)))
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  260 =>  /* arg: defs_head f_opt_paren_args "=" arg "`rescue' modifier" arg  */
  /* "src/parser/parser.y":2424  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(5));
                        let TokenWithContext { token: name_t, ctx } = name_t;
                        self.validate_endless_method_name(&name_t)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        let method_body = self.builder.begin_body(
                            Some( BoxedNode::from(yystack.owned_value_at(2))),
                            vec![ *rescue_body ],
                            None,
                            None,
                        );

                        yyval = Value::Node(
                            self.builder.def_endless_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                method_body
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  261 =>  /* arg: primary  */
  /* "src/parser/parser.y":2462  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  262 =>  /* relop: ">"  */
  /* "src/parser/parser.y":2468  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  263 =>  /* relop: "<"  */
  /* "src/parser/parser.y":2472  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  264 =>  /* relop: ">="  */
  /* "src/parser/parser.y":2476  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  265 =>  /* relop: "<="  */
  /* "src/parser/parser.y":2480  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  266 =>  /* rel_expr: arg relop arg  */
  /* "src/parser/parser.y":2486  */
                    {
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  267 =>  /* rel_expr: rel_expr relop arg  */
  /* "src/parser/parser.y":2496  */
                    {
                        let op_t =  Token::from(yystack.owned_value_at(1));
                        self.warn(
                            yystack.location_at (1),
                            DiagnosticMessage::ComparisonAfterComparison { comparison: clone_value(&op_t) }
                        );
                        yyval = Value::Node(
                            self.builder.binary_op(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                op_t,
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  268 =>  /* arg_value: arg  */
  /* "src/parser/parser.y":2513  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&arg)?;
                        yyval = Value::Node(arg);
                    },


  269 =>  /* aref_args: none  */
  /* "src/parser/parser.y":2521  */
                    {
                        yyval = Value::NodeList( Box::new( vec![] ) );
                    },


  270 =>  /* aref_args: args trailer  */
  /* "src/parser/parser.y":2525  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  271 =>  /* aref_args: args "," assocs trailer  */
  /* "src/parser/parser.y":2529  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        nodes.push(
                            *self.builder.associate(
                                None,
                                 NodeList::from(yystack.owned_value_at(1)),
                                None
                            )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  272 =>  /* aref_args: assocs trailer  */
  /* "src/parser/parser.y":2541  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.associate(
                                        None,
                                         NodeList::from(yystack.owned_value_at(1)),
                                        None
                                    )
                                ]
                            )
                        );
                    },


  273 =>  /* arg_rhs: arg  */
  /* "src/parser/parser.y":2557  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&arg)?;
                        yyval = Value::Node(arg);
                    },


  274 =>  /* arg_rhs: arg "`rescue' modifier" arg  */
  /* "src/parser/parser.y":2563  */
                    {
                        let arg =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&arg)?;

                        let rescue_body = self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(1)),
                            None,
                            None,
                            None,
                            None,
                            Some( BoxedNode::from(yystack.owned_value_at(0)))
                        );

                        yyval = Value::Node(
                            self.builder.begin_body(
                                Some(arg),
                                vec![ *rescue_body ],
                                None,
                                None,
                            ).expect("expected begin_body to return Some (compound_stmt was given)")
                        );
                    },


  275 =>  /* paren_args: "( (tLPAREN2)" opt_call_args rparen  */
  /* "src/parser/parser.y":2588  */
                    {
                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                args:  NodeList::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  276 =>  /* paren_args: "( (tLPAREN2)" args "," args_forward rparen  */
  /* "src/parser/parser.y":2598  */
                    {
                        if !self.static_env.is_forward_args_declared() {
                            return self.yyerror(
                                yystack.location_at (1),
                                DiagnosticMessage::UnexpectedToken { token_name: "tBDOT3".to_string() }
                            );
                        }

                        let mut args =  NodeList::from(yystack.owned_value_at(3));
                        let forwarded_args = *self.builder.forwarded_args( Token::from(yystack.owned_value_at(1)));
                        args.push(forwarded_args);

                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(4)),
                                args,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  277 =>  /* paren_args: "( (tLPAREN2)" args_forward rparen  */
  /* "src/parser/parser.y":2619  */
                    {
                        if !self.static_env.is_forward_args_declared() {
                            return self.yyerror(yystack.location_at (1), DiagnosticMessage::UnexpectedToken { token_name: "tBDOT3".to_string() });
                        }

                        yyval = Value::new_paren_args(
                            ParenArgs {
                                begin_t:  Token::from(yystack.owned_value_at(2)),
                                args: vec![ *self.builder.forwarded_args( Token::from(yystack.owned_value_at(1))) ],
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  278 =>  /* opt_paren_args: none  */
  /* "src/parser/parser.y":2635  */
                    {
                        yyval = Value::new_opt_paren_args(
                            OptParenArgs {
                                begin_t: None,
                                args: vec![],
                                end_t: None
                            }
                        );
                    },


  279 =>  /* opt_paren_args: paren_args  */
  /* "src/parser/parser.y":2645  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_paren_args(
                            OptParenArgs {
                                begin_t: Some(begin_t),
                                args,
                                end_t: Some(end_t)
                            }
                        );
                    },


  280 =>  /* opt_call_args: none  */
  /* "src/parser/parser.y":2658  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  281 =>  /* opt_call_args: call_args  */
  /* "src/parser/parser.y":2662  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  282 =>  /* opt_call_args: args ","  */
  /* "src/parser/parser.y":2666  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  283 =>  /* opt_call_args: args "," assocs ","  */
  /* "src/parser/parser.y":2670  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let pair = *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        nodes.push(pair);
                        yyval = Value::NodeList(nodes);
                    },


  284 =>  /* opt_call_args: assocs ","  */
  /* "src/parser/parser.y":2677  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.associate(
                                        None,
                                         NodeList::from(yystack.owned_value_at(1)),
                                        None
                                    )
                                ]
                            )
                        );
                    },


  285 =>  /* call_args: command  */
  /* "src/parser/parser.y":2693  */
                    {
                        let command =  Node::from(yystack.owned_value_at(0));
                        self.value_expr(&command)?;
                        yyval = Value::NodeList( Box::new(vec![ command ]) );
                    },


  286 =>  /* call_args: args opt_block_arg  */
  /* "src/parser/parser.y":2699  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  287 =>  /* call_args: assocs opt_block_arg  */
  /* "src/parser/parser.y":2706  */
                    {
                        let mut nodes;
                        let hash = *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        let mut opt_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Box::new(Vec::with_capacity(1 + opt_block_arg.len()));
                        nodes.push(hash);
                        nodes.append(&mut opt_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  288 =>  /* call_args: args "," assocs opt_block_arg  */
  /* "src/parser/parser.y":2718  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let hash = *self.builder.associate(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        let mut opt_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + opt_block_arg.len());
                        nodes.push(hash);
                        nodes.append(&mut opt_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  289 =>  /* call_args: block_arg  */
  /* "src/parser/parser.y":2730  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  290 =>  /* @11: %empty  */
  /* "src/parser/parser.y":2735  */
                    {
                        let lookahead =
                            matches!(
                                self.last_token_type,
                                Lexer::tLPAREN2
                                    | Lexer::tLPAREN
                                    | Lexer:: tLPAREN_ARG
                                    | Lexer::tLBRACK2
                                    | Lexer::tLBRACK
                            );

                        if lookahead { self.yylexer.cmdarg.pop() }
                        self.yylexer.cmdarg.push(true);
                        if lookahead { self.yylexer.cmdarg.push(false) }
                        yyval = Value::None;
                    },


  291 =>  /* command_args: @11 call_args  */
  /* "src/parser/parser.y":2752  */
                    {
                        let lookahead = matches!(self.last_token_type, Lexer::tLBRACE_ARG);

                        if lookahead { self.yylexer.cmdarg.pop() }
                        self.yylexer.cmdarg.pop();
                        if lookahead { self.yylexer.cmdarg.push(false) }

                        yyval =  yystack.owned_value_at(0);
                    },


  292 =>  /* block_arg: "&" arg_value  */
  /* "src/parser/parser.y":2764  */
                    {
                        yyval = Value::Node(
                            self.builder.block_pass(
                                 Token::from(yystack.owned_value_at(1)),
                                Some( BoxedNode::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  293 =>  /* block_arg: "&"  */
  /* "src/parser/parser.y":2773  */
                    {
                        if !self.static_env.is_anonymous_blockarg_declared() {
                            return self.yyerror(yystack.location_at (0), DiagnosticMessage::NoAnonymousBlockarg {});
                        }

                        yyval = Value::Node(
                            self.builder.block_pass(
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                            )
                        );
                    },


  294 =>  /* opt_block_arg: "," block_arg  */
  /* "src/parser/parser.y":2788  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  295 =>  /* opt_block_arg: none  */
  /* "src/parser/parser.y":2792  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  296 =>  /* args: arg_value  */
  /* "src/parser/parser.y":2798  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  297 =>  /* args: "*" arg_value  */
  /* "src/parser/parser.y":2802  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.splat(
                                         Token::from(yystack.owned_value_at(1)),
                                        Some( BoxedNode::from(yystack.owned_value_at(0)))
                                    )
                                ]
                            )
                        );
                    },


  298 =>  /* args: args "," arg_value  */
  /* "src/parser/parser.y":2815  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  299 =>  /* args: args "," "*" arg_value  */
  /* "src/parser/parser.y":2821  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))));
                        nodes.push(splat);
                        yyval = Value::NodeList(nodes);
                    },


  300 =>  /* mrhs_arg: mrhs  */
  /* "src/parser/parser.y":2830  */
                    {
                        yyval = Value::Node(
                            self.builder.array(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  301 =>  /* mrhs_arg: arg_value  */
  /* "src/parser/parser.y":2836  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  302 =>  /* mrhs: args "," arg_value  */
  /* "src/parser/parser.y":2842  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  303 =>  /* mrhs: args "," "*" arg_value  */
  /* "src/parser/parser.y":2848  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        nodes.push(
                            *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))))
                        );
                        yyval = Value::NodeList(nodes);
                    },


  304 =>  /* mrhs: "*" arg_value  */
  /* "src/parser/parser.y":2856  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.splat(
                                         Token::from(yystack.owned_value_at(1)),
                                        Some( BoxedNode::from(yystack.owned_value_at(0)))
                                    )
                                ]
                            )
                        );
                    },


  305 =>  /* primary: literal  */
  /* "src/parser/parser.y":2871  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  306 =>  /* primary: strings  */
  /* "src/parser/parser.y":2875  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  307 =>  /* primary: xstring  */
  /* "src/parser/parser.y":2879  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  308 =>  /* primary: regexp  */
  /* "src/parser/parser.y":2883  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  309 =>  /* primary: words  */
  /* "src/parser/parser.y":2887  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  310 =>  /* primary: qwords  */
  /* "src/parser/parser.y":2891  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  311 =>  /* primary: symbols  */
  /* "src/parser/parser.y":2895  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  312 =>  /* primary: qsymbols  */
  /* "src/parser/parser.y":2899  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  313 =>  /* primary: var_ref  */
  /* "src/parser/parser.y":2903  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  314 =>  /* primary: backref  */
  /* "src/parser/parser.y":2907  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  315 =>  /* primary: "method"  */
  /* "src/parser/parser.y":2911  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(0))),
                                None,
                                vec![],
                                None
                            )
                        );
                    },


  316 =>  /* @12: %empty  */
  /* "src/parser/parser.y":2924  */
                    {
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  317 =>  /* primary: k_begin @12 bodystmt k_end  */
  /* "src/parser/parser.y":2930  */
                    {
                        self.yylexer.cmdarg.pop();

                        yyval = Value::Node(
                            self.builder.begin_keyword( Token::from(yystack.owned_value_at(3)),  MaybeBoxedNode::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  318 =>  /* @13: %empty  */
  /* "src/parser/parser.y":2937  */
                              { self.yylexer.lex_state.set(EXPR_ENDARG); yyval = Value::None; },


  319 =>  /* primary: "( arg" @13 rparen  */
  /* "src/parser/parser.y":2938  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                None,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  320 =>  /* @14: %empty  */
  /* "src/parser/parser.y":2947  */
                                   { self.yylexer.lex_state.set(EXPR_ENDARG); yyval = Value::None; },


  321 =>  /* primary: "( arg" stmt @14 rparen  */
  /* "src/parser/parser.y":2948  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  322 =>  /* primary: "(" compstmt ")"  */
  /* "src/parser/parser.y":2958  */
                    {
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  323 =>  /* primary: primary_value "::" "constant"  */
  /* "src/parser/parser.y":2968  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  324 =>  /* primary: ":: at EXPR_BEG" "constant"  */
  /* "src/parser/parser.y":2978  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  325 =>  /* primary: "[" aref_args "]"  */
  /* "src/parser/parser.y":2984  */
                    {
                        yyval = Value::Node(
                            self.builder.array(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  326 =>  /* primary: "{" assoc_list "}"  */
  /* "src/parser/parser.y":2994  */
                    {
                        yyval = Value::Node(
                            self.builder.associate(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  327 =>  /* primary: k_return  */
  /* "src/parser/parser.y":3004  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Return,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  328 =>  /* primary: "`yield'" "( (tLPAREN2)" call_args rparen  */
  /* "src/parser/parser.y":3016  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(3)),
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  329 =>  /* primary: "`yield'" "( (tLPAREN2)" rparen  */
  /* "src/parser/parser.y":3028  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  330 =>  /* primary: "`yield'"  */
  /* "src/parser/parser.y":3040  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Yield,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  331 =>  /* @15: %empty  */
  /* "src/parser/parser.y":3052  */
                    {
                        self.context.set_in_defined(true);
                        yyval = Value::None;
                    },


  332 =>  /* primary: "`defined?'" opt_nl "( (tLPAREN2)" @15 expr rparen  */
  /* "src/parser/parser.y":3057  */
                    {
                        self.context.set_in_defined(false);
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Defined,
                                 Token::from(yystack.owned_value_at(5)),
                                Some( Token::from(yystack.owned_value_at(3))),
                                vec![  Node::from(yystack.owned_value_at(1)) ],
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  333 =>  /* primary: "`not'" "( (tLPAREN2)" expr rparen  */
  /* "src/parser/parser.y":3070  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  334 =>  /* primary: "`not'" "( (tLPAREN2)" rparen  */
  /* "src/parser/parser.y":3081  */
                    {
                        yyval = Value::Node(
                            self.builder.not_op(
                                 Token::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )?
                        );
                    },


  335 =>  /* primary: fcall brace_block  */
  /* "src/parser/parser.y":3092  */
                    {
                        let method_call = self.builder.call_method(
                            None,
                            None,
                            Some( Token::from(yystack.owned_value_at(1))),
                            None,
                            vec![],
                            None
                        );
                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  336 =>  /* primary: method_call  */
  /* "src/parser/parser.y":3114  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  337 =>  /* primary: method_call brace_block  */
  /* "src/parser/parser.y":3118  */
                    {
                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                 BoxedNode::from(yystack.owned_value_at(1)),
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  338 =>  /* primary: lambda  */
  /* "src/parser/parser.y":3131  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  339 =>  /* primary: k_if expr_value then compstmt if_tail k_end  */
  /* "src/parser/parser.y":3138  */
                    {
                        let IfTail { keyword_t, body: else_body } =  IfTail::from(yystack.owned_value_at(1));

                        yyval = Value::Node(
                            self.builder.condition(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                keyword_t,
                                else_body,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  340 =>  /* primary: k_unless expr_value then compstmt opt_else k_end  */
  /* "src/parser/parser.y":3157  */
                    {
                        let (else_t, body) =  OptElse::from(yystack.owned_value_at(1)).map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.condition(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                body,
                                else_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  341 =>  /* primary: k_while expr_value_do compstmt k_end  */
  /* "src/parser/parser.y":3175  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.loop_(
                                LoopType::While,
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  342 =>  /* primary: k_until expr_value_do compstmt k_end  */
  /* "src/parser/parser.y":3191  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.loop_(
                                LoopType::Until,
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  343 =>  /* @16: %empty  */
  /* "src/parser/parser.y":3205  */
                    {
                        // TODO: there's a warning that wq/parser doesn't trigger,
                        // search for `p->case_labels`
                        yyval = Value::None;
                    },


  344 =>  /* primary: k_case expr_value opt_terms @16 case_body k_end  */
  /* "src/parser/parser.y":3212  */
                    {
                        let CaseBody { when_bodies, opt_else } =  CaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case(
                                 Token::from(yystack.owned_value_at(5)),
                                Some( BoxedNode::from(yystack.owned_value_at(4))),
                                when_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  345 =>  /* @17: %empty  */
  /* "src/parser/parser.y":3228  */
                    {
                        // TODO: there's a warning that wq/parser doesn't trigger,
                        // search for `p->case_labels`
                        yyval = Value::None;
                    },


  346 =>  /* primary: k_case opt_terms @17 case_body k_end  */
  /* "src/parser/parser.y":3235  */
                    {
                        let CaseBody { when_bodies, opt_else } =  CaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case(
                                 Token::from(yystack.owned_value_at(4)),
                                None,
                                when_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  347 =>  /* primary: k_case expr_value opt_terms p_case_body k_end  */
  /* "src/parser/parser.y":3253  */
                    {
                        let PCaseBody { in_bodies, opt_else } =  PCaseBody::from(yystack.owned_value_at(1));
                        let (else_t, else_body) = opt_else.map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));

                        yyval = Value::Node(
                            self.builder.case_match(
                                 Token::from(yystack.owned_value_at(4)),
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                in_bodies,
                                else_t,
                                else_body,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  348 =>  /* primary: k_for for_var "`in'" expr_value_do compstmt k_end  */
  /* "src/parser/parser.y":3271  */
                    {
                        let ExprValueDo { value, do_t } =  ExprValueDo::from(yystack.owned_value_at(2));
                        yyval = Value::Node(
                            self.builder.for_(
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 Token::from(yystack.owned_value_at(3)),
                                value,
                                do_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  349 =>  /* @18: %empty  */
  /* "src/parser/parser.y":3286  */
                    {
                        self.local_push();
                        self.context.set_in_class(true);
                        yyval = Value::None;
                    },


  350 =>  /* primary: k_class cpath superclass @18 bodystmt k_end  */
  /* "src/parser/parser.y":3293  */
                    {
                        let TokenWithContext { token: k_class, ctx } =  TokenWithContext::from(yystack.owned_value_at(5));
                        if self.context.in_def() {
                            return self.yyerror(&k_class.loc, DiagnosticMessage::ClassDefinitionInMethodBody {});
                        }

                        let Superclass { lt_t, value } =  Superclass::from(yystack.owned_value_at(3));

                        yyval = Value::Node(
                            self.builder.def_class(
                                k_class,
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                lt_t,
                                value,
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.local_pop();
                        self.context.set_in_class(ctx.in_class());
                    },


  351 =>  /* @19: %empty  */
  /* "src/parser/parser.y":3316  */
                    {
                        self.context.set_in_def(false);
                        self.context.set_in_class(false);
                        self.local_push();
                        yyval = Value::None;
                    },


  352 =>  /* primary: k_class "<<" expr @19 term bodystmt k_end  */
  /* "src/parser/parser.y":3325  */
                    {
                        let TokenWithContext { token: k_class, ctx } =  TokenWithContext::from(yystack.owned_value_at(6));
                        yyval = Value::Node(
                            self.builder.def_sclass(
                                k_class,
                                 Token::from(yystack.owned_value_at(5)),
                                 BoxedNode::from(yystack.owned_value_at(4)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.local_pop();
                        self.context.set_in_def(ctx.in_def());
                        self.context.set_in_class(ctx.in_class());
                    },


  353 =>  /* @20: %empty  */
  /* "src/parser/parser.y":3342  */
                    {
                        self.local_push();
                        self.context.set_in_class(true);
                        yyval = Value::None;
                    },


  354 =>  /* primary: k_module cpath @20 bodystmt k_end  */
  /* "src/parser/parser.y":3349  */
                    {
                        let TokenWithContext { token: k_module, ctx } =  TokenWithContext::from(yystack.owned_value_at(4));
                        if self.context.in_def() {
                            return self.yyerror(&k_module.loc, DiagnosticMessage::ModuleDefinitionInMethodBody {});
                        }

                        yyval = Value::Node(
                            self.builder.def_module(
                                k_module,
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );

                        self.local_pop();
                        self.context.set_in_class(ctx.in_class());
                    },


  355 =>  /* primary: defn_head f_arglist bodystmt k_end  */
  /* "src/parser/parser.y":3368  */
                    {
                        let DefnHead { def_t, name_t } =  DefnHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;

                        yyval = Value::Node(
                            self.builder.def_method(
                                def_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  356 =>  /* primary: defs_head f_arglist bodystmt k_end  */
  /* "src/parser/parser.y":3387  */
                    {
                        let DefsHead { def_t, definee, dot_t, name_t } =  DefsHead::from(yystack.owned_value_at(3));
                        let TokenWithContext { token: name_t, ctx } = name_t;

                        yyval = Value::Node(
                            self.builder.def_singleton(
                                def_t,
                                definee,
                                dot_t,
                                name_t,
                                 MaybeBoxedNode::from(yystack.owned_value_at(2)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )?
                        );

                        self.local_pop();
                        self.current_arg_stack.pop();
                        self.context.set_in_def(ctx.in_def());
                    },


  357 =>  /* primary: "`break'"  */
  /* "src/parser/parser.y":3408  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Break,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  358 =>  /* primary: "`next'"  */
  /* "src/parser/parser.y":3420  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Next,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  359 =>  /* primary: "`redo'"  */
  /* "src/parser/parser.y":3432  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Redo,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  360 =>  /* primary: "`retry'"  */
  /* "src/parser/parser.y":3444  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Retry,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  361 =>  /* primary_value: primary  */
  /* "src/parser/parser.y":3458  */
                    {
                        let primary =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&primary)?;
                        yyval = Value::Node(primary);
                    },


  362 =>  /* k_begin: "`begin'"  */
  /* "src/parser/parser.y":3466  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  363 =>  /* k_if: "`if'"  */
  /* "src/parser/parser.y":3472  */
                    {
                        self.warn_eol(yystack.location_at (0), "if");
                        yyval =  yystack.owned_value_at(0);
                    },


  364 =>  /* k_unless: "`unless'"  */
  /* "src/parser/parser.y":3479  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  365 =>  /* k_while: "`while'"  */
  /* "src/parser/parser.y":3485  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  366 =>  /* k_until: "`until'"  */
  /* "src/parser/parser.y":3491  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  367 =>  /* k_case: "`case'"  */
  /* "src/parser/parser.y":3497  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  368 =>  /* k_for: "`for'"  */
  /* "src/parser/parser.y":3503  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  369 =>  /* k_class: "`class'"  */
  /* "src/parser/parser.y":3509  */
                    {
                        yyval = Value::TokenWithContext(
                            Box::new(
                                TokenWithContext {
                                    token:  Token::from(yystack.owned_value_at(0)),
                                    ctx: self.context.dump(),
                                }
                            )
                        );
                    },


  370 =>  /* k_module: "`module'"  */
  /* "src/parser/parser.y":3522  */
                    {
                        yyval = Value::TokenWithContext(
                            Box::new(
                                TokenWithContext {
                                    token:  Token::from(yystack.owned_value_at(0)),
                                    ctx: self.context.dump(),
                                }
                            )
                        );
                    },


  371 =>  /* k_def: "`def'"  */
  /* "src/parser/parser.y":3535  */
                    {
                        yyval =  yystack.owned_value_at(0);
                        self.context.set_in_argdef(true);
                    },


  372 =>  /* k_do: "`do'"  */
  /* "src/parser/parser.y":3542  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  373 =>  /* k_do_block: "`do' for block"  */
  /* "src/parser/parser.y":3548  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  374 =>  /* k_rescue: "`rescue'"  */
  /* "src/parser/parser.y":3554  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  375 =>  /* k_ensure: "`ensure'"  */
  /* "src/parser/parser.y":3560  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  376 =>  /* k_when: "`when'"  */
  /* "src/parser/parser.y":3566  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  377 =>  /* k_else: "`else'"  */
  /* "src/parser/parser.y":3572  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  378 =>  /* k_elsif: "`elsif'"  */
  /* "src/parser/parser.y":3578  */
                    {
                        self.warn_eol(yystack.location_at (0), "elsif");
                        yyval =  yystack.owned_value_at(0);
                    },


  379 =>  /* k_end: "`end'"  */
  /* "src/parser/parser.y":3585  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  380 =>  /* k_return: "`return'"  */
  /* "src/parser/parser.y":3591  */
                    {
                        if self.context.in_class() && !self.context.in_def() && !(self.context.in_block() || self.context.in_lambda()) {
                            return self.yyerror(yystack.location_at (0), DiagnosticMessage::InvalidReturnInClassOrModuleBody {});
                        }
                        yyval =  yystack.owned_value_at(0);
                    },


  381 =>  /* then: term  */
  /* "src/parser/parser.y":3600  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  382 =>  /* then: "`then'"  */
  /* "src/parser/parser.y":3604  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  383 =>  /* then: term "`then'"  */
  /* "src/parser/parser.y":3608  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  384 =>  /* do: term  */
  /* "src/parser/parser.y":3614  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  385 =>  /* do: "`do' for condition"  */
  /* "src/parser/parser.y":3618  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  386 =>  /* if_tail: opt_else  */
  /* "src/parser/parser.y":3624  */
                    {
                        let (keyword_t, body) =  OptElse::from(yystack.owned_value_at(0)).map(|else_| (Some(else_.else_t), else_.body)).unwrap_or_else(|| (None, None));
                        yyval = Value::new_if_tail(IfTail { keyword_t, body });
                    },


  387 =>  /* if_tail: k_elsif expr_value then compstmt if_tail  */
  /* "src/parser/parser.y":3631  */
                    {
                        let IfTail { keyword_t, body: else_body } =  IfTail::from(yystack.owned_value_at(0));

                        let elsif_t =  Token::from(yystack.owned_value_at(4));

                        yyval = Value::new_if_tail(
                            IfTail {
                                keyword_t: Some(elsif_t.clone()),
                                body: Some(
                                    self.builder.condition(
                                        elsif_t,
                                         BoxedNode::from(yystack.owned_value_at(3)),
                                         Token::from(yystack.owned_value_at(2)),
                                         MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                        keyword_t,
                                        else_body,
                                        None
                                    )
                                )
                            }
                        );
                    },


  388 =>  /* opt_else: none  */
  /* "src/parser/parser.y":3656  */
                    {
                        yyval = Value::new_opt_else(None);
                    },


  389 =>  /* opt_else: k_else compstmt  */
  /* "src/parser/parser.y":3660  */
                    {
                        let else_t =  Token::from(yystack.owned_value_at(1));
                        let body   =  MaybeBoxedNode::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_else(Some(Else { else_t, body }));
                    },


  390 =>  /* for_var: lhs  */
  /* "src/parser/parser.y":3668  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  391 =>  /* for_var: mlhs  */
  /* "src/parser/parser.y":3672  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  392 =>  /* f_marg: f_norm_arg  */
  /* "src/parser/parser.y":3678  */
                    {
                        yyval = Value::Node(
                            self.builder.arg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  393 =>  /* f_marg: "(" f_margs rparen  */
  /* "src/parser/parser.y":3684  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  394 =>  /* f_marg_list: f_marg  */
  /* "src/parser/parser.y":3696  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  395 =>  /* f_marg_list: f_marg_list "," f_marg  */
  /* "src/parser/parser.y":3700  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  396 =>  /* f_margs: f_marg_list  */
  /* "src/parser/parser.y":3708  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  397 =>  /* f_margs: f_marg_list "," f_rest_marg  */
  /* "src/parser/parser.y":3712  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  398 =>  /* f_margs: f_marg_list "," f_rest_marg "," f_marg_list  */
  /* "src/parser/parser.y":3718  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(4));
                        let f_rest_marg =  Node::from(yystack.owned_value_at(2));
                        let mut f_marg_list =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(1 + f_marg_list.len());
                        nodes.push(f_rest_marg);
                        nodes.append(&mut f_marg_list);

                        yyval = Value::NodeList(nodes);
                    },


  399 =>  /* f_margs: f_rest_marg  */
  /* "src/parser/parser.y":3730  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  400 =>  /* f_margs: f_rest_marg "," f_marg_list  */
  /* "src/parser/parser.y":3734  */
                    {
                        let mut nodes;
                        let f_rest_marg =  Node::from(yystack.owned_value_at(2));
                        let mut f_marg_list =  NodeList::from(yystack.owned_value_at(0));

                        nodes = Box::new( Vec::with_capacity(1 + f_marg_list.len()) );
                        nodes.push(f_rest_marg);
                        nodes.append(&mut f_marg_list);

                        yyval = Value::NodeList(nodes);
                    },


  401 =>  /* f_rest_marg: "*" f_norm_arg  */
  /* "src/parser/parser.y":3748  */
                    {
                        yyval = Value::Node(
                            self.builder.restarg( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?
                        );
                    },


  402 =>  /* f_rest_marg: "*"  */
  /* "src/parser/parser.y":3754  */
                    {
                        yyval = Value::Node(
                            self.builder.restarg( Token::from(yystack.owned_value_at(0)), None)?
                        );
                    },


  403 =>  /* f_any_kwrest: f_kwrest  */
  /* "src/parser/parser.y":3762  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  404 =>  /* f_any_kwrest: f_no_kwarg  */
  /* "src/parser/parser.y":3766  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  405 =>  /* @21: %empty  */
  /* "src/parser/parser.y":3771  */
                    {
                        self.context.set_in_argdef(false);
                        yyval = Value::None;
                    },


  406 =>  /* f_eq: @21 "="  */
  /* "src/parser/parser.y":3776  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  407 =>  /* block_args_tail: f_block_kwarg "," f_kwrest opt_f_block_arg  */
  /* "src/parser/parser.y":3782  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_kwrest =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_f_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_kwrest.len() + opt_f_block_arg.len());
                        nodes.append(&mut f_kwrest);
                        nodes.append(&mut opt_f_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  408 =>  /* block_args_tail: f_block_kwarg opt_f_block_arg  */
  /* "src/parser/parser.y":3794  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  409 =>  /* block_args_tail: f_any_kwrest opt_f_block_arg  */
  /* "src/parser/parser.y":3801  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  410 =>  /* block_args_tail: f_block_arg  */
  /* "src/parser/parser.y":3808  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  411 =>  /* opt_block_args_tail: "," block_args_tail  */
  /* "src/parser/parser.y":3815  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  412 =>  /* opt_block_args_tail: %empty  */
  /* "src/parser/parser.y":3819  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  413 =>  /* excessed_comma: ","  */
  /* "src/parser/parser.y":3825  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  414 =>  /* block_param: f_arg "," f_block_optarg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3831  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  415 =>  /* block_param: f_arg "," f_block_optarg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3845  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(7));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  416 =>  /* block_param: f_arg "," f_block_optarg opt_block_args_tail  */
  /* "src/parser/parser.y":3861  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  417 =>  /* block_param: f_arg "," f_block_optarg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3873  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_block_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_block_optarg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_block_optarg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  418 =>  /* block_param: f_arg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3887  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  419 =>  /* block_param: f_arg excessed_comma  */
  /* "src/parser/parser.y":3899  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  420 =>  /* block_param: f_arg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3903  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  421 =>  /* block_param: f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3917  */
                    {
                        let f_arg =  BoxedNodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));
                        let mut nodes;

                        if opt_block_args_tail.is_empty() && f_arg.len() == 1 {
                            let procarg0 = *self.builder.procarg0(
                                Box::new(f_arg.into_iter().next().unwrap())
                            );
                            nodes = Box::new( vec![ procarg0 ] );
                        } else {
                            nodes = f_arg;
                            nodes.append(&mut opt_block_args_tail);
                        }

                        yyval = Value::NodeList(nodes);
                    },


  422 =>  /* block_param: f_block_optarg "," f_rest_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3935  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  423 =>  /* block_param: f_block_optarg "," f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3947  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  424 =>  /* block_param: f_block_optarg opt_block_args_tail  */
  /* "src/parser/parser.y":3961  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  425 =>  /* block_param: f_block_optarg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3968  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  426 =>  /* block_param: f_rest_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3980  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  427 =>  /* block_param: f_rest_arg "," f_arg opt_block_args_tail  */
  /* "src/parser/parser.y":3987  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_block_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_block_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_block_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  428 =>  /* block_param: block_args_tail  */
  /* "src/parser/parser.y":3999  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  429 =>  /* opt_block_param: none  */
  /* "src/parser/parser.y":4005  */
                    {
                        yyval = Value::MaybeNode(
                            self.builder.args(None, vec![], None)
                        );
                    },


  430 =>  /* opt_block_param: block_param_def  */
  /* "src/parser/parser.y":4011  */
                    {
                        self.yylexer.command_start = true;
                        yyval =  yystack.owned_value_at(0);
                    },


  431 =>  /* block_param_def: "|" opt_bv_decl "|"  */
  /* "src/parser/parser.y":4018  */
                    {
                        self.max_numparam_stack.set_has_ordinary_params();
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(false);

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  432 =>  /* block_param_def: "|" block_param opt_bv_decl "|"  */
  /* "src/parser/parser.y":4032  */
                    {
                        self.max_numparam_stack.set_has_ordinary_params();
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(false);

                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(1)));

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(3))),
                                nodes,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  433 =>  /* opt_bv_decl: opt_nl  */
  /* "src/parser/parser.y":4052  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  434 =>  /* opt_bv_decl: opt_nl ";" bv_decls opt_nl  */
  /* "src/parser/parser.y":4056  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  435 =>  /* bv_decls: bvar  */
  /* "src/parser/parser.y":4062  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  436 =>  /* bv_decls: bv_decls "," bvar  */
  /* "src/parser/parser.y":4066  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  437 =>  /* bvar: "local variable or method"  */
  /* "src/parser/parser.y":4074  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(clone_value(&ident_t).as_str());
                        yyval = Value::Node(
                            self.builder.shadowarg(ident_t)?
                        );
                    },


  438 =>  /* bvar: f_bad_arg  */
  /* "src/parser/parser.y":4082  */
                    {
                        yyval = Value::None;
                    },


  439 =>  /* @22: %empty  */
  /* "src/parser/parser.y":4088  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push(false);
                        yyval = Value::Num(self.yylexer.lpar_beg);
                        self.yylexer.lpar_beg = self.yylexer.paren_nest;
                    },


  440 =>  /* @23: %empty  */
  /* "src/parser/parser.y":4094  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_lambda(true);
                    },


  441 =>  /* @24: %empty  */
  /* "src/parser/parser.y":4099  */
                    {
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  442 =>  /* lambda: "->" @22 @23 f_larglist @24 lambda_body  */
  /* "src/parser/parser.y":4104  */
                    {
                        self.yylexer.lpar_beg =  Num::from(yystack.owned_value_at(4));

                        let lambda_call = self.builder.call_lambda( Token::from(yystack.owned_value_at(5)));
                        let args = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(2)))
                        };
                        let LambdaBody { begin_t, body, end_t } =  LambdaBody::from(yystack.owned_value_at(0));

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();
                        self.yylexer.cmdarg.pop();
                        self.context.set_in_lambda( Context::from(yystack.owned_value_at(3)).in_lambda());

                        yyval = Value::Node(
                            self.builder.block(
                                lambda_call,
                                begin_t,
                                args,
                                body,
                                end_t
                            )?
                        );
                    },


  443 =>  /* f_larglist: "( (tLPAREN2)" f_args opt_bv_decl ")"  */
  /* "src/parser/parser.y":4133  */
                    {
                        self.context.set_in_argdef(false);
                        self.max_numparam_stack.set_has_ordinary_params();

                        let mut nodes =  NodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(1)));

                        yyval = Value::MaybeNode(
                            self.builder.args(
                                Some( Token::from(yystack.owned_value_at(3))),
                                nodes,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  444 =>  /* f_larglist: f_args  */
  /* "src/parser/parser.y":4149  */
                    {
                        self.context.set_in_argdef(false);
                        let args =  NodeList::from(yystack.owned_value_at(0));
                        if !args.is_empty() {
                            self.max_numparam_stack.set_has_ordinary_params();
                        }
                        yyval = Value::MaybeNode(
                            self.builder.args(None, args, None)
                        );
                    },


  445 =>  /* @25: %empty  */
  /* "src/parser/parser.y":4162  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_lambda(true);
                    },


  446 =>  /* lambda_body: tLAMBEG @25 compstmt "}"  */
  /* "src/parser/parser.y":4167  */
                    {
                        self.context.set_in_lambda( Context::from(yystack.owned_value_at(2)).in_lambda());
                        yyval = Value::new_lambda_body(
                            LambdaBody {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  447 =>  /* @26: %empty  */
  /* "src/parser/parser.y":4178  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_lambda(true);
                    },


  448 =>  /* lambda_body: "`do' for lambda" @26 bodystmt k_end  */
  /* "src/parser/parser.y":4183  */
                    {
                        self.context.set_in_lambda( Context::from(yystack.owned_value_at(2)).in_lambda());
                        yyval = Value::new_lambda_body(
                            LambdaBody {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  449 =>  /* @27: %empty  */
  /* "src/parser/parser.y":4196  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_block(true);
                    },


  450 =>  /* do_block: k_do_block @27 do_body k_end  */
  /* "src/parser/parser.y":4201  */
                    {
                        self.context.set_in_block( Context::from(yystack.owned_value_at(2)).in_block());
                        let DoBody { args_type, body } =  DoBody::from(yystack.owned_value_at(1));
                        yyval = Value::new_do_block(
                            DoBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  451 =>  /* block_call: command do_block  */
  /* "src/parser/parser.y":4216  */
                    {
                        let DoBlock { begin_t, args_type, body, end_t } =  DoBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                 BoxedNode::from(yystack.owned_value_at(1)),
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  452 =>  /* block_call: block_call call_op2 operation2 opt_paren_args  */
  /* "src/parser/parser.y":4229  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                begin_t,
                                args,
                                end_t
                            )
                        );
                    },


  453 =>  /* block_call: block_call call_op2 operation2 opt_paren_args brace_block  */
  /* "src/parser/parser.y":4243  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(1));
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            begin_t,
                            args,
                            end_t
                        );

                        let BraceBlock { begin_t, args_type, body, end_t } =  BraceBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  454 =>  /* block_call: block_call call_op2 operation2 command_args do_block  */
  /* "src/parser/parser.y":4266  */
                    {
                        let method_call = self.builder.call_method(
                            Some( BoxedNode::from(yystack.owned_value_at(4))),
                            Some( Token::from(yystack.owned_value_at(3))),
                            Some( Token::from(yystack.owned_value_at(2))),
                            None,
                             NodeList::from(yystack.owned_value_at(1)),
                            None
                        );

                        let DoBlock { begin_t, args_type, body, end_t } =  DoBlock::from(yystack.owned_value_at(0));
                        yyval = Value::Node(
                            self.builder.block(
                                method_call,
                                begin_t,
                                args_type,
                                body,
                                end_t
                            )?
                        );
                    },


  455 =>  /* method_call: fcall paren_args  */
  /* "src/parser/parser.y":4290  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                None,
                                None,
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  456 =>  /* method_call: primary_value call_op operation2 opt_paren_args  */
  /* "src/parser/parser.y":4305  */
                    {
                        let OptParenArgs { begin_t, args, end_t } =  OptParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                begin_t,
                                args,
                                end_t
                            )
                        );
                    },


  457 =>  /* method_call: primary_value "::" operation2 paren_args  */
  /* "src/parser/parser.y":4320  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(3))),
                                Some( Token::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  458 =>  /* method_call: primary_value "::" operation3  */
  /* "src/parser/parser.y":4335  */
                    {
                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                Some( Token::from(yystack.owned_value_at(0))),
                                None,
                                vec![],
                                None
                            )
                        );
                    },


  459 =>  /* method_call: primary_value call_op paren_args  */
  /* "src/parser/parser.y":4348  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  460 =>  /* method_call: primary_value "::" paren_args  */
  /* "src/parser/parser.y":4363  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.call_method(
                                Some( BoxedNode::from(yystack.owned_value_at(2))),
                                Some( Token::from(yystack.owned_value_at(1))),
                                None,
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )
                        );
                    },


  461 =>  /* method_call: "`super'" paren_args  */
  /* "src/parser/parser.y":4378  */
                    {
                        let ParenArgs { begin_t, args, end_t } =  ParenArgs::from(yystack.owned_value_at(0));

                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Super,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(begin_t),
                                args,
                                Some(end_t)
                            )?
                        );
                    },


  462 =>  /* method_call: "`super'"  */
  /* "src/parser/parser.y":4392  */
                    {
                        yyval = Value::Node(
                            self.builder.keyword_cmd(
                                KeywordCmd::Zsuper,
                                 Token::from(yystack.owned_value_at(0)),
                                None,
                                vec![],
                                None
                            )?
                        );
                    },


  463 =>  /* method_call: primary_value "[ (tLBRACK2)" opt_call_args rbracket  */
  /* "src/parser/parser.y":4404  */
                    {
                        yyval = Value::Node(
                            self.builder.index(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  464 =>  /* @28: %empty  */
  /* "src/parser/parser.y":4417  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_block(true);
                    },


  465 =>  /* brace_block: "{ (tLCURLY)" @28 brace_body "}"  */
  /* "src/parser/parser.y":4422  */
                    {
                        let BraceBody { args_type, body } =  BraceBody::from(yystack.owned_value_at(1));
                        self.context.set_in_block( Context::from(yystack.owned_value_at(2)).in_block());

                        yyval = Value::new_brace_block(
                            BraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  466 =>  /* @29: %empty  */
  /* "src/parser/parser.y":4436  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_block(true);
                    },


  467 =>  /* brace_block: k_do @29 do_body k_end  */
  /* "src/parser/parser.y":4441  */
                    {
                        let DoBody { args_type, body } =  DoBody::from(yystack.owned_value_at(1));
                        self.context.set_in_block( Context::from(yystack.owned_value_at(2)).in_block());

                        yyval = Value::new_brace_block(
                            BraceBlock {
                                begin_t:  Token::from(yystack.owned_value_at(3)),
                                args_type,
                                body,
                                end_t:  Token::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  468 =>  /* @30: %empty  */
  /* "src/parser/parser.y":4456  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push(false);
                        yyval = Value::None;
                    },


  469 =>  /* brace_body: @30 opt_block_param compstmt  */
  /* "src/parser/parser.y":4462  */
                    {
                        let args_type = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(1)))
                        };

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();

                        yyval = Value::new_brace_body(
                            BraceBody {
                                args_type,
                                body:  MaybeBoxedNode::from(yystack.owned_value_at(0))
                            }
                        );
                    },


  470 =>  /* @31: %empty  */
  /* "src/parser/parser.y":4481  */
                    {
                        self.static_env.extend_dynamic();
                        self.max_numparam_stack.push(false);
                        self.yylexer.cmdarg.push(false);
                        yyval = Value::None;
                    },


  471 =>  /* do_body: @31 opt_block_param bodystmt  */
  /* "src/parser/parser.y":4488  */
                    {
                        let args_type = if self.max_numparam_stack.has_numparams() {
                            ArgsType::Numargs(self.max_numparam_stack.top() as u8)
                        } else {
                            ArgsType::Args( MaybeBoxedNode::from(yystack.owned_value_at(1)))
                        };

                        self.max_numparam_stack.pop();
                        self.static_env.unextend();
                        self.yylexer.cmdarg.pop();

                        yyval = Value::new_do_body(
                            DoBody { args_type, body:  MaybeBoxedNode::from(yystack.owned_value_at(0)) }
                        );
                    },


  472 =>  /* case_args: arg_value  */
  /* "src/parser/parser.y":4506  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  473 =>  /* case_args: "*" arg_value  */
  /* "src/parser/parser.y":4510  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.splat(
                                         Token::from(yystack.owned_value_at(1)),
                                        Some( BoxedNode::from(yystack.owned_value_at(0)))
                                    )
                                ]
                            )
                        );
                    },


  474 =>  /* case_args: case_args "," arg_value  */
  /* "src/parser/parser.y":4523  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  475 =>  /* case_args: case_args "," "*" arg_value  */
  /* "src/parser/parser.y":4529  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let splat = *self.builder.splat( Token::from(yystack.owned_value_at(1)), Some( BoxedNode::from(yystack.owned_value_at(0))));
                        nodes.push(splat);
                        yyval = Value::NodeList(nodes);
                    },


  476 =>  /* case_body: k_when case_args then compstmt cases  */
  /* "src/parser/parser.y":4540  */
                    {
                        let when = *self.builder.when( Token::from(yystack.owned_value_at(4)),  NodeList::from(yystack.owned_value_at(3)),  Token::from(yystack.owned_value_at(2)),  MaybeBoxedNode::from(yystack.owned_value_at(1)));
                        let Cases { mut when_bodies, opt_else } =  Cases::from(yystack.owned_value_at(0));

                        let mut nodes = Vec::with_capacity(1 + when_bodies.len());
                        nodes.push(when);
                        nodes.append(&mut when_bodies);

                        yyval = Value::new_case_body(CaseBody { when_bodies: nodes, opt_else });
                    },


  477 =>  /* cases: opt_else  */
  /* "src/parser/parser.y":4553  */
                    {
                        yyval = Value::new_cases(Cases { when_bodies: vec![], opt_else:  OptElse::from(yystack.owned_value_at(0)) });
                    },


  478 =>  /* cases: case_body  */
  /* "src/parser/parser.y":4557  */
                    {
                        let CaseBody { when_bodies, .. } =  CaseBody::from(yystack.owned_value_at(0));
                        yyval = Value::new_cases(Cases { when_bodies, opt_else: None });
                    },


  479 =>  /* @32: %empty  */
  /* "src/parser/parser.y":4564  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG|EXPR_LABEL);
                        self.yylexer.command_start = false;
                        self.pattern_variables.push();
                        self.pattern_hash_keys.push();

                        yyval = Value::Bool(self.context.in_kwarg());
                        self.context.set_in_kwarg(true);
                    },


  480 =>  /* @33: %empty  */
  /* "src/parser/parser.y":4574  */
                    {
                        self.context.set_in_kwarg( Bool::from(yystack.owned_value_at(2)));
                        self.pattern_variables.pop();
                        self.pattern_hash_keys.pop();
                        yyval = Value::None;
                    },


  481 =>  /* p_case_body: "`in'" @32 p_top_expr then @33 compstmt p_cases  */
  /* "src/parser/parser.y":4582  */
                    {
                        let PCases { mut in_bodies, opt_else } =  PCases::from(yystack.owned_value_at(0));
                        let PTopExpr { pattern, guard } =  PTopExpr::from(yystack.owned_value_at(4));

                        let mut nodes = Vec::with_capacity(1 + in_bodies.len());
                        nodes.push(
                            *self.builder.in_pattern(
                                 Token::from(yystack.owned_value_at(6)),
                                pattern,
                                guard,
                                 Token::from(yystack.owned_value_at(3)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1))
                            )
                        );
                        nodes.append(&mut in_bodies);

                        yyval = Value::new_p_case_body(PCaseBody { in_bodies: nodes, opt_else  });
                    },


  482 =>  /* p_cases: opt_else  */
  /* "src/parser/parser.y":4603  */
                    {
                        yyval = Value::new_p_cases(PCases { in_bodies: vec![], opt_else:  OptElse::from(yystack.owned_value_at(0)) });
                    },


  483 =>  /* p_cases: p_case_body  */
  /* "src/parser/parser.y":4607  */
                    {
                        let PCaseBody { in_bodies, .. } =  PCaseBody::from(yystack.owned_value_at(0));
                        yyval = Value::new_p_cases(PCases { in_bodies, opt_else: None });
                    },


  484 =>  /* p_top_expr: p_top_expr_body  */
  /* "src/parser/parser.y":4614  */
                    {
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(0)), guard: None });
                    },


  485 =>  /* p_top_expr: p_top_expr_body "`if' modifier" expr_value  */
  /* "src/parser/parser.y":4618  */
                    {
                        let guard = self.builder.if_guard( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(2)), guard: Some(guard) });
                    },


  486 =>  /* p_top_expr: p_top_expr_body "`unless' modifier" expr_value  */
  /* "src/parser/parser.y":4623  */
                    {
                        let guard = self.builder.unless_guard( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_p_top_expr(PTopExpr { pattern:  BoxedNode::from(yystack.owned_value_at(2)), guard: Some(guard) });
                    },


  487 =>  /* p_top_expr_body: p_expr  */
  /* "src/parser/parser.y":4630  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  488 =>  /* p_top_expr_body: p_expr ","  */
  /* "src/parser/parser.y":4634  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                None,
                                vec![  Node::from(yystack.owned_value_at(1)) ],
                                Some( Token::from(yystack.owned_value_at(0))),
                                None
                            )
                        );
                    },


  489 =>  /* p_top_expr_body: p_expr "," p_args  */
  /* "src/parser/parser.y":4645  */
                    {
                        let MatchPatternWithTrailingComma { mut elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(0));

                        let mut nodes = Vec::with_capacity(1 + elements.len());
                        nodes.push( Node::from(yystack.owned_value_at(2)));
                        nodes.append(&mut elements);

                        yyval = Value::Node(
                            self.builder.array_pattern(None, nodes, trailing_comma, None)
                        );
                    },


  490 =>  /* p_top_expr_body: p_find  */
  /* "src/parser/parser.y":4657  */
                    {
                        yyval = Value::Node(
                            self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  491 =>  /* p_top_expr_body: p_args_tail  */
  /* "src/parser/parser.y":4663  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None, None)
                        );
                    },


  492 =>  /* p_top_expr_body: p_kwargs  */
  /* "src/parser/parser.y":4669  */
                    {
                        yyval = Value::Node(
                            self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(0)), None)
                        );
                    },


  493 =>  /* p_expr: p_as  */
  /* "src/parser/parser.y":4677  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  494 =>  /* p_as: p_expr "=>" p_variable  */
  /* "src/parser/parser.y":4683  */
                    {
                        yyval = Value::Node(
                            self.builder.match_as(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  495 =>  /* p_as: p_alt  */
  /* "src/parser/parser.y":4693  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  496 =>  /* p_alt: p_alt "|" p_expr_basic  */
  /* "src/parser/parser.y":4699  */
                    {
                        yyval = Value::Node(
                            self.builder.match_alt(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  497 =>  /* p_alt: p_expr_basic  */
  /* "src/parser/parser.y":4709  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  498 =>  /* p_lparen: "( (tLPAREN2)"  */
  /* "src/parser/parser.y":4715  */
                    {
                        yyval =  yystack.owned_value_at(0);
                        self.pattern_hash_keys.push();
                    },


  499 =>  /* p_lbracket: "[ (tLBRACK2)"  */
  /* "src/parser/parser.y":4722  */
                    {
                        yyval =  yystack.owned_value_at(0);
                        self.pattern_hash_keys.push();
                    },


  500 =>  /* p_expr_basic: p_value  */
  /* "src/parser/parser.y":4729  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  501 =>  /* p_expr_basic: p_variable  */
  /* "src/parser/parser.y":4733  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  502 =>  /* p_expr_basic: p_const p_lparen p_args rparen  */
  /* "src/parser/parser.y":4737  */
                    {
                        self.pattern_hash_keys.pop();
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        let pattern = self.builder.array_pattern(None, elements, trailing_comma, None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  503 =>  /* p_expr_basic: p_const p_lparen p_find rparen  */
  /* "src/parser/parser.y":4751  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  504 =>  /* p_expr_basic: p_const p_lparen p_kwargs rparen  */
  /* "src/parser/parser.y":4764  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  505 =>  /* p_expr_basic: p_const "( (tLPAREN2)" rparen  */
  /* "src/parser/parser.y":4777  */
                    {
                        let lparen =  Token::from(yystack.owned_value_at(1));
                        let rparen =  Token::from(yystack.owned_value_at(0));
                        let pattern = self.builder.array_pattern(
                            Some(lparen.clone()),
                            vec![],
                            None,
                            Some(rparen.clone())
                        );
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                lparen,
                                pattern,
                                rparen
                            )
                        );
                    },


  506 =>  /* p_expr_basic: p_const p_lbracket p_args rbracket  */
  /* "src/parser/parser.y":4796  */
                    {
                        self.pattern_hash_keys.pop();
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        let pattern = self.builder.array_pattern(None, elements, trailing_comma, None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  507 =>  /* p_expr_basic: p_const p_lbracket p_find rbracket  */
  /* "src/parser/parser.y":4810  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.find_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  508 =>  /* p_expr_basic: p_const p_lbracket p_kwargs rbracket  */
  /* "src/parser/parser.y":4823  */
                    {
                        self.pattern_hash_keys.pop();
                        let pattern = self.builder.hash_pattern(None,  NodeList::from(yystack.owned_value_at(1)), None);
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(3)),
                                 Token::from(yystack.owned_value_at(2)),
                                pattern,
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  509 =>  /* p_expr_basic: p_const "[ (tLBRACK2)" rbracket  */
  /* "src/parser/parser.y":4836  */
                    {
                        let lparen =  Token::from(yystack.owned_value_at(1));
                        let rparen =  Token::from(yystack.owned_value_at(0));
                        let pattern = self.builder.array_pattern(
                            Some(lparen.clone()),
                            vec![],
                            None,
                            Some(rparen.clone())
                        );
                        yyval = Value::Node(
                            self.builder.const_pattern(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                lparen,
                                pattern,
                                rparen
                            )
                        );
                    },


  510 =>  /* p_expr_basic: "[" p_args rbracket  */
  /* "src/parser/parser.y":4855  */
                    {
                        let MatchPatternWithTrailingComma { elements, trailing_comma } =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1));
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                Some( Token::from(yystack.owned_value_at(2))),
                                elements,
                                trailing_comma,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  511 =>  /* p_expr_basic: "[" p_find rbracket  */
  /* "src/parser/parser.y":4867  */
                    {
                        yyval = Value::Node(
                            self.builder.find_pattern(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  512 =>  /* p_expr_basic: "[" rbracket  */
  /* "src/parser/parser.y":4877  */
                    {
                        yyval = Value::Node(
                            self.builder.array_pattern(
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                None,
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  513 =>  /* @34: %empty  */
  /* "src/parser/parser.y":4888  */
                    {
                        self.pattern_hash_keys.push();
                        yyval = Value::Bool(self.context.in_kwarg());
                        self.context.set_in_kwarg(false);
                    },


  514 =>  /* p_expr_basic: "{" @34 p_kwargs rbrace  */
  /* "src/parser/parser.y":4894  */
                    {
                        self.pattern_hash_keys.pop();
                        self.context.set_in_kwarg( Bool::from(yystack.owned_value_at(2)));
                        yyval = Value::Node(
                            self.builder.hash_pattern(
                                Some( Token::from(yystack.owned_value_at(3))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  515 =>  /* p_expr_basic: "{" rbrace  */
  /* "src/parser/parser.y":4906  */
                    {
                        yyval = Value::Node(
                            self.builder.hash_pattern(
                                Some( Token::from(yystack.owned_value_at(1))),
                                vec![],
                                Some( Token::from(yystack.owned_value_at(0))),
                            )
                        );
                    },


  516 =>  /* @35: %empty  */
  /* "src/parser/parser.y":4916  */
                    {
                        self.pattern_hash_keys.push();
                        yyval = Value::None;
                    },


  517 =>  /* p_expr_basic: "(" @35 p_expr rparen  */
  /* "src/parser/parser.y":4921  */
                    {
                        self.pattern_hash_keys.pop();
                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(3)),
                                Some( BoxedNode::from(yystack.owned_value_at(1))),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  518 =>  /* p_args: p_expr  */
  /* "src/parser/parser.y":4934  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements: vec![  Node::from(yystack.owned_value_at(0)) ],
                                trailing_comma: None
                            }
                        );
                    },


  519 =>  /* p_args: p_args_head  */
  /* "src/parser/parser.y":4943  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  520 =>  /* p_args: p_args_head p_arg  */
  /* "src/parser/parser.y":4947  */
                    {
                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1)).elements;
                        elements.push( Node::from(yystack.owned_value_at(0)));

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  521 =>  /* p_args: p_args_head "*" "local variable or method"  */
  /* "src/parser/parser.y":4959  */
                    {
                        let match_rest = *self.builder.match_rest( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(2)).elements;
                        elements.push(match_rest);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  522 =>  /* p_args: p_args_head "*" "local variable or method" "," p_args_post  */
  /* "src/parser/parser.y":4973  */
                    {
                        let match_rest = *self.builder.match_rest( Token::from(yystack.owned_value_at(3)), Some( Token::from(yystack.owned_value_at(2))))?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(4)).elements;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        elements.reserve(1 + p_args_post.len());
                        elements.push(match_rest);
                        elements.append(&mut p_args_post);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  523 =>  /* p_args: p_args_head "*"  */
  /* "src/parser/parser.y":4990  */
                    {
                        let match_rest = *self.builder.match_rest( Token::from(yystack.owned_value_at(0)), None)?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(1)).elements;
                        elements.push(match_rest);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  524 =>  /* p_args: p_args_head "*" "," p_args_post  */
  /* "src/parser/parser.y":5004  */
                    {
                        let match_rest = *self.builder.match_rest( Token::from(yystack.owned_value_at(2)), None)?;

                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(3)).elements;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        elements.push(match_rest);
                        elements.append(&mut p_args_post);

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: None
                            }
                        );
                    },


  525 =>  /* p_args: p_args_tail  */
  /* "src/parser/parser.y":5020  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements:  NodeList::from(yystack.owned_value_at(0)),
                                trailing_comma: None
                            }
                        );
                    },


  526 =>  /* p_args_head: p_arg ","  */
  /* "src/parser/parser.y":5031  */
                    {
                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements: vec![ Node::from(yystack.owned_value_at(1))],
                                trailing_comma: Some( Token::from(yystack.owned_value_at(0))),
                            }
                        );
                    },


  527 =>  /* p_args_head: p_args_head p_arg ","  */
  /* "src/parser/parser.y":5040  */
                    {
                        let mut elements =  MatchPatternWithTrailingComma::from(yystack.owned_value_at(2)).elements;
                        elements.push( Node::from(yystack.owned_value_at(1)));

                        yyval = Value::new_match_pattern_with_trailing_comma(
                            MatchPatternWithTrailingComma {
                                elements,
                                trailing_comma: Some( Token::from(yystack.owned_value_at(0))),
                            }
                        );
                    },


  528 =>  /* p_args_tail: p_rest  */
  /* "src/parser/parser.y":5054  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  529 =>  /* p_args_tail: p_rest "," p_args_post  */
  /* "src/parser/parser.y":5058  */
                    {
                        let mut nodes;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(0));
                        nodes = Box::new(Vec::with_capacity(1 + p_args_post.len()));
                        nodes.push( Node::from(yystack.owned_value_at(2)));
                        nodes.append(&mut p_args_post);

                        yyval = Value::NodeList(nodes);
                    },


  530 =>  /* p_find: p_rest "," p_args_post "," p_rest  */
  /* "src/parser/parser.y":5070  */
                    {
                        let mut nodes;
                        let mut p_args_post =  NodeList::from(yystack.owned_value_at(2));
                        nodes = Box::new(Vec::with_capacity(1 + p_args_post.len() + 1));
                        nodes.push( Node::from(yystack.owned_value_at(4)));
                        nodes.append(&mut p_args_post);
                        nodes.push( Node::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  531 =>  /* p_rest: "*" "local variable or method"  */
  /* "src/parser/parser.y":5084  */
                    {
                        yyval = Value::Node(
                            self.builder.match_rest( Token::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))?
                        );
                    },


  532 =>  /* p_rest: "*"  */
  /* "src/parser/parser.y":5090  */
                    {
                        yyval = Value::Node(
                            self.builder.match_rest( Token::from(yystack.owned_value_at(0)), None)?
                        );
                    },


  533 =>  /* p_args_post: p_arg  */
  /* "src/parser/parser.y":5098  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  534 =>  /* p_args_post: p_args_post "," p_arg  */
  /* "src/parser/parser.y":5102  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  535 =>  /* p_arg: p_expr  */
  /* "src/parser/parser.y":5110  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  536 =>  /* p_kwargs: p_kwarg "," p_any_kwrest  */
  /* "src/parser/parser.y":5116  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  537 =>  /* p_kwargs: p_kwarg  */
  /* "src/parser/parser.y":5123  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  538 =>  /* p_kwargs: p_kwarg ","  */
  /* "src/parser/parser.y":5127  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  539 =>  /* p_kwargs: p_any_kwrest  */
  /* "src/parser/parser.y":5131  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  540 =>  /* p_kwarg: p_kw  */
  /* "src/parser/parser.y":5137  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  541 =>  /* p_kwarg: p_kwarg "," p_kw  */
  /* "src/parser/parser.y":5141  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  542 =>  /* p_kw: p_kw_label p_expr  */
  /* "src/parser/parser.y":5149  */
                    {
                        yyval = Value::Node(
                            self.builder.match_pair(
                                 PKwLabel::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  543 =>  /* p_kw: p_kw_label  */
  /* "src/parser/parser.y":5158  */
                    {
                        yyval = Value::Node(
                            self.builder.match_label(
                                 PKwLabel::from(yystack.owned_value_at(0)),
                            )?
                        );
                    },


  544 =>  /* p_kw_label: "label"  */
  /* "src/parser/parser.y":5168  */
                    {
                        yyval = Value::new_p_kw_label(
                            PKwLabel::PlainLabel( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  545 =>  /* p_kw_label: "string begin" string_contents tLABEL_END  */
  /* "src/parser/parser.y":5174  */
                    {
                        yyval = Value::new_p_kw_label(
                            PKwLabel::QuotedLabel( ( Token::from(yystack.owned_value_at(2)),  NodeList::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0))) )
                        );
                    },


  546 =>  /* p_kwrest: kwrest_mark "local variable or method"  */
  /* "src/parser/parser.y":5182  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.match_rest(
                                         Token::from(yystack.owned_value_at(1)),
                                        Some( Token::from(yystack.owned_value_at(0)))
                                    )?
                                ]
                            )
                        );
                    },


  547 =>  /* p_kwrest: kwrest_mark  */
  /* "src/parser/parser.y":5195  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.match_rest(
                                         Token::from(yystack.owned_value_at(0)),
                                        None
                                    )?
                                ]
                            )
                        );
                    },


  548 =>  /* p_kwnorest: kwrest_mark "`nil'"  */
  /* "src/parser/parser.y":5210  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.match_nil_pattern(
                                         Token::from(yystack.owned_value_at(1)),
                                         Token::from(yystack.owned_value_at(0))
                                    )
                                ]
                            )
                        );
                    },


  549 =>  /* p_any_kwrest: p_kwrest  */
  /* "src/parser/parser.y":5225  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  550 =>  /* p_any_kwrest: p_kwnorest  */
  /* "src/parser/parser.y":5229  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  551 =>  /* p_value: p_primitive  */
  /* "src/parser/parser.y":5235  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  552 =>  /* p_value: p_primitive ".." p_primitive  */
  /* "src/parser/parser.y":5239  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  553 =>  /* p_value: p_primitive "..." p_primitive  */
  /* "src/parser/parser.y":5255  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(2));
                        self.value_expr(&left)?;

                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  554 =>  /* p_value: p_primitive ".."  */
  /* "src/parser/parser.y":5271  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  555 =>  /* p_value: p_primitive "..."  */
  /* "src/parser/parser.y":5284  */
                    {
                        let left =  BoxedNode::from(yystack.owned_value_at(1));
                        self.value_expr(&left)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                Some(left),
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  556 =>  /* p_value: p_var_ref  */
  /* "src/parser/parser.y":5297  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  557 =>  /* p_value: p_expr_ref  */
  /* "src/parser/parser.y":5301  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  558 =>  /* p_value: p_const  */
  /* "src/parser/parser.y":5305  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  559 =>  /* p_value: "(.." p_primitive  */
  /* "src/parser/parser.y":5309  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_inclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  560 =>  /* p_value: "(..." p_primitive  */
  /* "src/parser/parser.y":5322  */
                    {
                        let right =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&right)?;

                        yyval = Value::Node(
                            self.builder.range_exclusive(
                                None,
                                 Token::from(yystack.owned_value_at(1)),
                                Some(right)
                            )
                        );
                    },


  561 =>  /* p_primitive: literal  */
  /* "src/parser/parser.y":5337  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  562 =>  /* p_primitive: strings  */
  /* "src/parser/parser.y":5341  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  563 =>  /* p_primitive: xstring  */
  /* "src/parser/parser.y":5345  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  564 =>  /* p_primitive: regexp  */
  /* "src/parser/parser.y":5349  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  565 =>  /* p_primitive: words  */
  /* "src/parser/parser.y":5353  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  566 =>  /* p_primitive: qwords  */
  /* "src/parser/parser.y":5357  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  567 =>  /* p_primitive: symbols  */
  /* "src/parser/parser.y":5361  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  568 =>  /* p_primitive: qsymbols  */
  /* "src/parser/parser.y":5365  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  569 =>  /* p_primitive: keyword_variable  */
  /* "src/parser/parser.y":5369  */
                    {
                        yyval = Value::Node(
                            self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  570 =>  /* p_primitive: lambda  */
  /* "src/parser/parser.y":5375  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  571 =>  /* p_variable: "local variable or method"  */
  /* "src/parser/parser.y":5381  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable(
                                self.builder.match_var( Token::from(yystack.owned_value_at(0)))?
                            )?
                        );
                    },


  572 =>  /* p_var_ref: "^" "local variable or method"  */
  /* "src/parser/parser.y":5391  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        let name = clone_value(&ident_t);

                        if !self.static_env.is_declared(name.as_str()) {
                            return self.yyerror(
                                yystack.location_at (0),
                                DiagnosticMessage::NoSuchLocalVariable { var_name: name }
                            );
                        }

                        let lvar = self.builder.accessible(self.builder.lvar(ident_t));
                        yyval = Value::Node(
                            self.builder.pin( Token::from(yystack.owned_value_at(1)), lvar)
                        );
                    },


  573 =>  /* p_var_ref: "^" nonlocal_var  */
  /* "src/parser/parser.y":5408  */
                    {
                        let non_lvar = self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::Node(
                            self.builder.pin(
                                 Token::from(yystack.owned_value_at(1)),
                                non_lvar,
                            )
                        );
                    },


  574 =>  /* p_expr_ref: "^" "(" expr_value ")"  */
  /* "src/parser/parser.y":5420  */
                    {
                        let expr = self.builder.begin(
                             Token::from(yystack.owned_value_at(2)),
                            Some( BoxedNode::from(yystack.owned_value_at(1))),
                             Token::from(yystack.owned_value_at(0))
                        );
                        yyval = Value::Node(
                            self.builder.pin(
                                 Token::from(yystack.owned_value_at(3)),
                                expr
                            )
                        );
                    },


  575 =>  /* p_const: ":: at EXPR_BEG" cname  */
  /* "src/parser/parser.y":5436  */
                    {
                        yyval = Value::Node(
                            self.builder.const_global( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  576 =>  /* p_const: p_const "::" cname  */
  /* "src/parser/parser.y":5442  */
                    {
                        yyval = Value::Node(
                            self.builder.const_fetch(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0)),
                            )
                        );
                    },


  577 =>  /* p_const: "constant"  */
  /* "src/parser/parser.y":5452  */
                    {
                        yyval = Value::Node(self.builder.const_( Token::from(yystack.owned_value_at(0))));
                    },


  578 =>  /* opt_rescue: k_rescue exc_list exc_var then compstmt opt_rescue  */
  /* "src/parser/parser.y":5460  */
                    {
                        let ExcVar { assoc_t, exc_var } =  ExcVar::from(yystack.owned_value_at(3));

                        let exc_list =  NodeList::from(yystack.owned_value_at(4));
                        let exc_list = if exc_list.is_empty() {
                            None
                        } else {
                            Some(self.builder.array(None, exc_list, None))
                        };

                        let rescue_body = *self.builder.rescue_body(
                             Token::from(yystack.owned_value_at(5)),
                            exc_list,
                            assoc_t,
                            exc_var,
                            Some( Token::from(yystack.owned_value_at(2))),
                             MaybeBoxedNode::from(yystack.owned_value_at(1))
                        );
                        let mut nodes;
                        let mut opt_rescue =  NodeList::from(yystack.owned_value_at(0));
                        nodes = Box::new(Vec::with_capacity(1 + opt_rescue.len()));
                        nodes.push(rescue_body);
                        nodes.append(&mut opt_rescue);

                        yyval = Value::NodeList(nodes);
                    },


  579 =>  /* opt_rescue: none  */
  /* "src/parser/parser.y":5487  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  580 =>  /* exc_list: arg_value  */
  /* "src/parser/parser.y":5493  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  581 =>  /* exc_list: mrhs  */
  /* "src/parser/parser.y":5497  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  582 =>  /* exc_list: none  */
  /* "src/parser/parser.y":5501  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  583 =>  /* exc_var: "=>" lhs  */
  /* "src/parser/parser.y":5507  */
                    {
                        let assoc_t = Some( Token::from(yystack.owned_value_at(1)));
                        let exc_var = Some( BoxedNode::from(yystack.owned_value_at(0)));
                        yyval = Value::new_exc_var(ExcVar { assoc_t, exc_var });
                    },


  584 =>  /* exc_var: none  */
  /* "src/parser/parser.y":5513  */
                    {
                        yyval = Value::new_exc_var(ExcVar { assoc_t: None, exc_var: None });
                    },


  585 =>  /* opt_ensure: k_ensure compstmt  */
  /* "src/parser/parser.y":5519  */
                    {
                        let ensure_t =  Token::from(yystack.owned_value_at(1));
                        let body =  MaybeBoxedNode::from(yystack.owned_value_at(0));
                        yyval = Value::new_opt_ensure(Some(Ensure { ensure_t, body }));
                    },


  586 =>  /* opt_ensure: none  */
  /* "src/parser/parser.y":5525  */
                    {
                        yyval = Value::new_opt_ensure(None);
                    },


  587 =>  /* literal: numeric  */
  /* "src/parser/parser.y":5531  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  588 =>  /* literal: symbol  */
  /* "src/parser/parser.y":5535  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  589 =>  /* strings: string  */
  /* "src/parser/parser.y":5541  */
                    {
                        yyval = Value::Node(
                            self.builder.string_compose(
                                None,
                                 NodeList::from(yystack.owned_value_at(0)),
                                None
                            )
                        );
                    },


  590 =>  /* string: "char literal"  */
  /* "src/parser/parser.y":5553  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.character( Token::from(yystack.owned_value_at(0)))
                                ]
                            )
                        );
                    },


  591 =>  /* string: string1  */
  /* "src/parser/parser.y":5563  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  592 =>  /* string: string string1  */
  /* "src/parser/parser.y":5567  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  593 =>  /* string1: "string begin" string_contents "string end"  */
  /* "src/parser/parser.y":5575  */
                    {
                        let mut string = self.builder.string_compose(
                            Some( Token::from(yystack.owned_value_at(2))),
                             NodeList::from(yystack.owned_value_at(1)),
                            Some( Token::from(yystack.owned_value_at(0)))
                        );
                        let indent = self.yylexer.buffer.heredoc_indent;
                        self.yylexer.buffer.heredoc_indent = 0;
                        string = self.builder.heredoc_dedent(string, indent);
                        yyval = Value::Node(string);
                    },


  594 =>  /* xstring: "backtick literal" xstring_contents "string end"  */
  /* "src/parser/parser.y":5589  */
                    {
                        let mut string = self.builder.xstring_compose(
                             Token::from(yystack.owned_value_at(2)),
                             NodeList::from(yystack.owned_value_at(1)),
                             Token::from(yystack.owned_value_at(0))
                        );
                        let indent = self.yylexer.buffer.heredoc_indent;
                        self.yylexer.buffer.heredoc_indent = 0;
                        string = self.builder.heredoc_dedent(string, indent);
                        yyval = Value::Node(string);
                    },


  595 =>  /* regexp: "regexp literal" regexp_contents tREGEXP_END  */
  /* "src/parser/parser.y":5603  */
                    {
                        let regexp_end =  Token::from(yystack.owned_value_at(0));
                        let opts = self.builder.regexp_options(regexp_end.clone());
                        yyval = Value::Node(
                            self.builder.regexp_compose(
                                 Token::from(yystack.owned_value_at(2)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                regexp_end,
                                opts
                            )
                        );
                    },


  596 =>  /* words: "word list" " " word_list "string end"  */
  /* "src/parser/parser.y":5618  */
                    {
                        yyval = Value::Node(
                            self.builder.words_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  597 =>  /* word_list: %empty  */
  /* "src/parser/parser.y":5630  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );

                    },


  598 =>  /* word_list: word_list word " "  */
  /* "src/parser/parser.y":5635  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.word(  NodeList::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  599 =>  /* word: string_content  */
  /* "src/parser/parser.y":5645  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  600 =>  /* word: word string_content  */
  /* "src/parser/parser.y":5649  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  601 =>  /* symbols: "symbol list" " " symbol_list "string end"  */
  /* "src/parser/parser.y":5657  */
                    {
                        yyval = Value::Node(
                            self.builder.symbols_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  602 =>  /* symbol_list: %empty  */
  /* "src/parser/parser.y":5669  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  603 =>  /* symbol_list: symbol_list word " "  */
  /* "src/parser/parser.y":5673  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.word(  NodeList::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  604 =>  /* qwords: "verbatim word list" " " qword_list "string end"  */
  /* "src/parser/parser.y":5683  */
                    {
                        yyval = Value::Node(
                            self.builder.words_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  605 =>  /* qsymbols: "verbatim symbol list" " " qsym_list "string end"  */
  /* "src/parser/parser.y":5695  */
                    {
                        yyval = Value::Node(
                            self.builder.symbols_compose(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  606 =>  /* qword_list: %empty  */
  /* "src/parser/parser.y":5707  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  607 =>  /* qword_list: qword_list "literal content" " "  */
  /* "src/parser/parser.y":5711  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.string_internal(  Token::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  608 =>  /* qsym_list: %empty  */
  /* "src/parser/parser.y":5721  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  609 =>  /* qsym_list: qsym_list "literal content" " "  */
  /* "src/parser/parser.y":5725  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(
                            *self.builder.symbol_internal(  Token::from(yystack.owned_value_at(1)) )
                        );
                        yyval = Value::NodeList(nodes);
                    },


  610 =>  /* string_contents: %empty  */
  /* "src/parser/parser.y":5735  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  611 =>  /* string_contents: string_contents string_content  */
  /* "src/parser/parser.y":5739  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  612 =>  /* xstring_contents: %empty  */
  /* "src/parser/parser.y":5747  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  613 =>  /* xstring_contents: xstring_contents string_content  */
  /* "src/parser/parser.y":5751  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  614 =>  /* regexp_contents: %empty  */
  /* "src/parser/parser.y":5759  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  615 =>  /* regexp_contents: regexp_contents string_content  */
  /* "src/parser/parser.y":5763  */
                    {
                        let mut  nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  616 =>  /* string_content: "literal content"  */
  /* "src/parser/parser.y":5771  */
                    {
                        yyval = Value::Node(
                            self.builder.string_internal( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  617 =>  /* @36: %empty  */
  /* "src/parser/parser.y":5777  */
                    {
                        yyval = Value::MaybeStrTerm(std::mem::take(&mut self.yylexer.strterm));
                        self.yylexer.lex_state.set(EXPR_BEG);
                    },


  618 =>  /* string_content: tSTRING_DVAR @36 string_dvar  */
  /* "src/parser/parser.y":5782  */
                    {
                        self.yylexer.strterm =  MaybeStrTerm::from(yystack.owned_value_at(1));
                        yyval =  yystack.owned_value_at(0);
                    },


  619 =>  /* @37: %empty  */
  /* "src/parser/parser.y":5787  */
                    {
                        self.yylexer.cmdarg.push(false);
                        self.yylexer.cond.push(false);
                        yyval = Value::None;
                    },


  620 =>  /* @38: %empty  */
  /* "src/parser/parser.y":5792  */
                    {
                        yyval = Value::MaybeStrTerm(std::mem::take(&mut self.yylexer.strterm));
                    },


  621 =>  /* @39: %empty  */
  /* "src/parser/parser.y":5795  */
                    {
                        yyval = Value::Num( self.yylexer.lex_state.get() );
                        self.yylexer.lex_state.set(EXPR_BEG);
                    },


  622 =>  /* @40: %empty  */
  /* "src/parser/parser.y":5799  */
                    {
                        yyval = Value::Num( self.yylexer.brace_nest );
                        self.yylexer.brace_nest = 0;
                    },


  623 =>  /* @41: %empty  */
  /* "src/parser/parser.y":5803  */
                    {
                        yyval = Value::Num( self.yylexer.buffer.heredoc_indent );
                        self.yylexer.buffer.heredoc_indent = 0;
                    },


  624 =>  /* string_content: tSTRING_DBEG @37 @38 @39 @40 @41 compstmt "tRCURLY"  */
  /* "src/parser/parser.y":5808  */
                    {
                        self.yylexer.cond.pop();
                        self.yylexer.cmdarg.pop();
                        self.yylexer.strterm =  MaybeStrTerm::from(yystack.owned_value_at(5));
                        self.yylexer.lex_state.set( Num::from(yystack.owned_value_at(4)));
                        self.yylexer.brace_nest =  Num::from(yystack.owned_value_at(3));
                        self.yylexer.buffer.heredoc_indent =  Num::from(yystack.owned_value_at(2));
                        self.yylexer.buffer.heredoc_line_indent = -1;

                        yyval = Value::Node(
                            self.builder.begin(
                                 Token::from(yystack.owned_value_at(7)),
                                 MaybeBoxedNode::from(yystack.owned_value_at(1)),
                                 Token::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  625 =>  /* string_dvar: "global variable"  */
  /* "src/parser/parser.y":5828  */
                    {
                        yyval = Value::Node(self.builder.gvar( Token::from(yystack.owned_value_at(0))));
                    },


  626 =>  /* string_dvar: "instance variable"  */
  /* "src/parser/parser.y":5832  */
                    {
                        yyval = Value::Node(self.builder.ivar( Token::from(yystack.owned_value_at(0))));

                    },


  627 =>  /* string_dvar: "class variable"  */
  /* "src/parser/parser.y":5837  */
                    {
                        yyval = Value::Node(self.builder.cvar( Token::from(yystack.owned_value_at(0))));
                    },


  628 =>  /* string_dvar: backref  */
  /* "src/parser/parser.y":5841  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  629 =>  /* symbol: ssym  */
  /* "src/parser/parser.y":5846  */
                       { yyval =  yystack.owned_value_at(0); },


  630 =>  /* symbol: dsym  */
  /* "src/parser/parser.y":5847  */
                       { yyval =  yystack.owned_value_at(0); },


  631 =>  /* ssym: "symbol literal" sym  */
  /* "src/parser/parser.y":5851  */
                    {
                        self.yylexer.lex_state.set(EXPR_END);
                        yyval = Value::Node(
                            self.builder.symbol( Token::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  632 =>  /* sym: fname  */
  /* "src/parser/parser.y":5859  */
                        { yyval =  yystack.owned_value_at(0); },


  633 =>  /* sym: "instance variable"  */
  /* "src/parser/parser.y":5860  */
                        { yyval =  yystack.owned_value_at(0); },


  634 =>  /* sym: "global variable"  */
  /* "src/parser/parser.y":5861  */
                        { yyval =  yystack.owned_value_at(0); },


  635 =>  /* sym: "class variable"  */
  /* "src/parser/parser.y":5862  */
                        { yyval =  yystack.owned_value_at(0); },


  636 =>  /* dsym: "symbol literal" string_contents "string end"  */
  /* "src/parser/parser.y":5866  */
                    {
                        self.yylexer.lex_state.set(EXPR_END);
                        yyval = Value::Node(
                            self.builder.symbol_compose( Token::from(yystack.owned_value_at(2)),  NodeList::from(yystack.owned_value_at(1)),  Token::from(yystack.owned_value_at(0)))
                        );
                    },


  637 =>  /* numeric: simple_numeric  */
  /* "src/parser/parser.y":5875  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  638 =>  /* numeric: tUMINUS_NUM simple_numeric  */
  /* "src/parser/parser.y":5879  */
                    {
                        yyval = Value::Node(
                            self.builder.unary_num(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  639 =>  /* simple_numeric: "integer literal"  */
  /* "src/parser/parser.y":5890  */
                    {
                        yyval = Value::Node(
                            self.builder.integer( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  640 =>  /* simple_numeric: "float literal"  */
  /* "src/parser/parser.y":5896  */
                    {
                        yyval = Value::Node(
                            self.builder.float( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  641 =>  /* simple_numeric: "rational literal"  */
  /* "src/parser/parser.y":5902  */
                    {
                        yyval = Value::Node(
                            self.builder.rational( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  642 =>  /* simple_numeric: "imaginary literal"  */
  /* "src/parser/parser.y":5908  */
                    {
                        yyval = Value::Node(
                            self.builder.complex( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  643 =>  /* nonlocal_var: "instance variable"  */
  /* "src/parser/parser.y":5916  */
                    {
                        yyval = Value::Node(
                            self.builder.ivar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  644 =>  /* nonlocal_var: "global variable"  */
  /* "src/parser/parser.y":5922  */
                    {
                        yyval = Value::Node(
                            self.builder.gvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  645 =>  /* nonlocal_var: "class variable"  */
  /* "src/parser/parser.y":5928  */
                    {
                        yyval = Value::Node(
                            self.builder.cvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  646 =>  /* user_variable: "local variable or method"  */
  /* "src/parser/parser.y":5936  */
                    {
                        yyval = Value::Node(
                            self.builder.lvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  647 =>  /* user_variable: "instance variable"  */
  /* "src/parser/parser.y":5942  */
                    {
                        yyval = Value::Node(
                            self.builder.ivar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  648 =>  /* user_variable: "global variable"  */
  /* "src/parser/parser.y":5948  */
                    {
                        yyval = Value::Node(
                            self.builder.gvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  649 =>  /* user_variable: "constant"  */
  /* "src/parser/parser.y":5954  */
                    {
                        yyval = Value::Node(
                            self.builder.const_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  650 =>  /* user_variable: "class variable"  */
  /* "src/parser/parser.y":5960  */
                    {
                        yyval = Value::Node(
                            self.builder.cvar( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  651 =>  /* keyword_variable: "`nil'"  */
  /* "src/parser/parser.y":5968  */
                    {
                        yyval = Value::Node(
                            self.builder.nil( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  652 =>  /* keyword_variable: "`self'"  */
  /* "src/parser/parser.y":5974  */
                    {
                        yyval = Value::Node(
                            self.builder.self_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  653 =>  /* keyword_variable: "`true'"  */
  /* "src/parser/parser.y":5980  */
                    {
                        yyval = Value::Node(
                            self.builder.true_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  654 =>  /* keyword_variable: "`false'"  */
  /* "src/parser/parser.y":5986  */
                    {
                        yyval = Value::Node(
                            self.builder.false_( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  655 =>  /* keyword_variable: "`__FILE__'"  */
  /* "src/parser/parser.y":5992  */
                    {
                        yyval = Value::Node(
                            self.builder.__file__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  656 =>  /* keyword_variable: "`__LINE__'"  */
  /* "src/parser/parser.y":5998  */
                    {
                        yyval = Value::Node(
                            self.builder.__line__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  657 =>  /* keyword_variable: "`__ENCODING__'"  */
  /* "src/parser/parser.y":6004  */
                    {
                        yyval = Value::Node(
                            self.builder.__encoding__( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  658 =>  /* var_ref: user_variable  */
  /* "src/parser/parser.y":6012  */
                    {
                        yyval = Value::Node(
                            self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  659 =>  /* var_ref: keyword_variable  */
  /* "src/parser/parser.y":6018  */
                    {
                        yyval = Value::Node(
                            self.builder.accessible( BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  660 =>  /* var_lhs: user_variable  */
  /* "src/parser/parser.y":6026  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  661 =>  /* var_lhs: keyword_variable  */
  /* "src/parser/parser.y":6032  */
                    {
                        yyval = Value::Node(
                            self.builder.assignable( BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  662 =>  /* backref: "numbered reference"  */
  /* "src/parser/parser.y":6040  */
                    {
                        yyval = Value::Node(
                            self.builder.nth_ref( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  663 =>  /* backref: "back reference"  */
  /* "src/parser/parser.y":6046  */
                    {
                        yyval = Value::Node(
                            self.builder.back_ref( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  664 =>  /* @42: %empty  */
  /* "src/parser/parser.y":6054  */
                    {
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                        yyval = Value::None;
                    },


  665 =>  /* superclass: "<" @42 expr_value term  */
  /* "src/parser/parser.y":6060  */
                    {
                        let lt_t  = Some( Token::from(yystack.owned_value_at(3)));
                        let value = Some( BoxedNode::from(yystack.owned_value_at(1)));
                        yyval = Value::new_superclass(
                            Superclass { lt_t, value }
                        );
                    },


  666 =>  /* superclass: %empty  */
  /* "src/parser/parser.y":6068  */
                    {
                        yyval = Value::new_superclass(Superclass { lt_t: None, value: None });
                    },


  667 =>  /* f_opt_paren_args: f_paren_args  */
  /* "src/parser/parser.y":6074  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  668 =>  /* f_opt_paren_args: none  */
  /* "src/parser/parser.y":6078  */
                    {
                        self.context.set_in_argdef(false);
                        yyval = Value::MaybeNode(None);
                    },


  669 =>  /* f_paren_args: "( (tLPAREN2)" f_args rparen  */
  /* "src/parser/parser.y":6085  */
                    {
                        yyval = Value::MaybeNode(
                            self.builder.args(Some( Token::from(yystack.owned_value_at(2))),  NodeList::from(yystack.owned_value_at(1)), Some( Token::from(yystack.owned_value_at(0))))
                        );

                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                        self.context.set_in_argdef(false);
                    },


  670 =>  /* f_arglist: f_paren_args  */
  /* "src/parser/parser.y":6097  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  671 =>  /* @43: %empty  */
  /* "src/parser/parser.y":6100  */
                    {
                        yyval = Value::Context(self.context.dump());
                        self.context.set_in_kwarg(true);
                        self.context.set_in_argdef(true);
                        self.yylexer.lex_state.set(self.yylexer.lex_state.get()|EXPR_LABEL);
                    },


  672 =>  /* f_arglist: @43 f_args term  */
  /* "src/parser/parser.y":6107  */
                    {
                        self.context.set_in_kwarg( Context::from(yystack.owned_value_at(2)).in_kwarg());
                        self.context.set_in_argdef(false);
                        yyval = Value::MaybeNode(
                            self.builder.args(None,  NodeList::from(yystack.owned_value_at(1)), None)
                        );
                        self.yylexer.lex_state.set(EXPR_BEG);
                        self.yylexer.command_start = true;
                    },


  673 =>  /* args_tail: f_kwarg "," f_kwrest opt_f_block_arg  */
  /* "src/parser/parser.y":6119  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_kwrest =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_f_block_arg =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_kwrest.len() + opt_f_block_arg.len());
                        nodes.append(&mut f_kwrest);
                        nodes.append(&mut opt_f_block_arg);

                        yyval = Value::NodeList(nodes);
                    },


  674 =>  /* args_tail: f_kwarg opt_f_block_arg  */
  /* "src/parser/parser.y":6131  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  675 =>  /* args_tail: f_any_kwrest opt_f_block_arg  */
  /* "src/parser/parser.y":6138  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  676 =>  /* args_tail: f_block_arg  */
  /* "src/parser/parser.y":6145  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![  Node::from(yystack.owned_value_at(0)) ]
                            )
                        );
                    },


  677 =>  /* args_tail: args_forward  */
  /* "src/parser/parser.y":6153  */
                    {
                        let forward_arg = *self.builder.forward_arg( Token::from(yystack.owned_value_at(0)));
                        self.static_env.declare_forward_args();
                        yyval = Value::NodeList(
                            Box::new(
                                vec![ forward_arg ]
                            )
                        );
                    },


  678 =>  /* opt_args_tail: "," args_tail  */
  /* "src/parser/parser.y":6165  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  679 =>  /* opt_args_tail: %empty  */
  /* "src/parser/parser.y":6169  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  680 =>  /* f_args: f_arg "," f_optarg "," f_rest_arg opt_args_tail  */
  /* "src/parser/parser.y":6175  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  681 =>  /* f_args: f_arg "," f_optarg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6189  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(7));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  682 =>  /* f_args: f_arg "," f_optarg opt_args_tail  */
  /* "src/parser/parser.y":6205  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  683 =>  /* f_args: f_arg "," f_optarg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6217  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_optarg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_optarg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_optarg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  684 =>  /* f_args: f_arg "," f_rest_arg opt_args_tail  */
  /* "src/parser/parser.y":6231  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  685 =>  /* f_args: f_arg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6243  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  686 =>  /* f_args: f_arg opt_args_tail  */
  /* "src/parser/parser.y":6257  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  687 =>  /* f_args: f_optarg "," f_rest_arg opt_args_tail  */
  /* "src/parser/parser.y":6264  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  688 =>  /* f_args: f_optarg "," f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6276  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(5));
                        let mut f_rest_arg =  NodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_rest_arg.len() + f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_rest_arg);
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  689 =>  /* f_args: f_optarg opt_args_tail  */
  /* "src/parser/parser.y":6290  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  690 =>  /* f_args: f_optarg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6297  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  691 =>  /* f_args: f_rest_arg opt_args_tail  */
  /* "src/parser/parser.y":6309  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(1));
                        nodes.append(&mut  NodeList::from(yystack.owned_value_at(0)));

                        yyval = Value::NodeList(nodes);
                    },


  692 =>  /* f_args: f_rest_arg "," f_arg opt_args_tail  */
  /* "src/parser/parser.y":6316  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(3));
                        let mut f_arg =  NodeList::from(yystack.owned_value_at(1));
                        let mut opt_args_tail =  NodeList::from(yystack.owned_value_at(0));

                        nodes.reserve(f_arg.len() + opt_args_tail.len());
                        nodes.append(&mut f_arg);
                        nodes.append(&mut opt_args_tail);

                        yyval = Value::NodeList(nodes);
                    },


  693 =>  /* f_args: args_tail  */
  /* "src/parser/parser.y":6328  */
                    {
                        yyval = Value::NodeList( BoxedNodeList::from(yystack.owned_value_at(0)));
                    },


  694 =>  /* f_args: %empty  */
  /* "src/parser/parser.y":6332  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  695 =>  /* args_forward: "(..."  */
  /* "src/parser/parser.y":6338  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  696 =>  /* f_bad_arg: "constant"  */
  /* "src/parser/parser.y":6344  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::ConstArgument {});
                    },


  697 =>  /* f_bad_arg: "instance variable"  */
  /* "src/parser/parser.y":6348  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::IvarArgument {});
                    },


  698 =>  /* f_bad_arg: "global variable"  */
  /* "src/parser/parser.y":6352  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::GvarArgument {});
                    },


  699 =>  /* f_bad_arg: "class variable"  */
  /* "src/parser/parser.y":6356  */
                    {
                        return self.yyerror(yystack.location_at (0), DiagnosticMessage::CvarArgument {});
                    },


  700 =>  /* f_norm_arg: f_bad_arg  */
  /* "src/parser/parser.y":6362  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  701 =>  /* f_norm_arg: "local variable or method"  */
  /* "src/parser/parser.y":6366  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        let name = clone_value(&ident_t);
                        self.static_env.declare(name.as_str());
                        self.max_numparam_stack.set_has_ordinary_params();
                        yyval = Value::Token(ident_t);
                    },


  702 =>  /* f_arg_asgn: f_norm_arg  */
  /* "src/parser/parser.y":6376  */
                    {
                        let arg_t =  Token::from(yystack.owned_value_at(0));
                        let arg_name = clone_value(&arg_t);
                        self.current_arg_stack.set(Some(arg_name));
                        yyval = Value::Token(arg_t);
                    },


  703 =>  /* f_arg_item: f_arg_asgn  */
  /* "src/parser/parser.y":6385  */
                    {
                        self.current_arg_stack.set(None);
                        yyval = Value::Node(
                            self.builder.arg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  704 =>  /* f_arg_item: "(" f_margs rparen  */
  /* "src/parser/parser.y":6392  */
                    {
                        yyval = Value::Node(
                            self.builder.multi_lhs(
                                Some( Token::from(yystack.owned_value_at(2))),
                                 NodeList::from(yystack.owned_value_at(1)),
                                Some( Token::from(yystack.owned_value_at(0)))
                            )
                        );
                    },


  705 =>  /* f_arg: f_arg_item  */
  /* "src/parser/parser.y":6404  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  706 =>  /* f_arg: f_arg "," f_arg_item  */
  /* "src/parser/parser.y":6408  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  707 =>  /* f_label: "label"  */
  /* "src/parser/parser.y":6417  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.check_kwarg_name(&ident_t)?;

                        let ident = clone_value(&ident_t);
                        self.static_env.declare(&ident);

                        self.max_numparam_stack.set_has_ordinary_params();

                        self.current_arg_stack.set(Some(ident));
                        self.context.set_in_argdef(false);

                        yyval = Value::Token(ident_t);
                    },


  708 =>  /* f_kw: f_label arg_value  */
  /* "src/parser/parser.y":6434  */
                    {
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.kwoptarg( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  709 =>  /* f_kw: f_label  */
  /* "src/parser/parser.y":6442  */
                    {
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.kwarg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  710 =>  /* f_block_kw: f_label primary_value  */
  /* "src/parser/parser.y":6452  */
                    {
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.kwoptarg( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))?
                        );
                    },


  711 =>  /* f_block_kw: f_label  */
  /* "src/parser/parser.y":6459  */
                    {
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.kwarg( Token::from(yystack.owned_value_at(0)))?
                        );
                    },


  712 =>  /* f_block_kwarg: f_block_kw  */
  /* "src/parser/parser.y":6468  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  713 =>  /* f_block_kwarg: f_block_kwarg "," f_block_kw  */
  /* "src/parser/parser.y":6472  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  714 =>  /* f_kwarg: f_kw  */
  /* "src/parser/parser.y":6481  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  715 =>  /* f_kwarg: f_kwarg "," f_kw  */
  /* "src/parser/parser.y":6485  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  716 =>  /* kwrest_mark: "**"  */
  /* "src/parser/parser.y":6493  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  717 =>  /* kwrest_mark: "**arg"  */
  /* "src/parser/parser.y":6497  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  718 =>  /* f_no_kwarg: kwrest_mark "`nil'"  */
  /* "src/parser/parser.y":6503  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *self.builder.kwnilarg(
                                         Token::from(yystack.owned_value_at(1)),
                                         Token::from(yystack.owned_value_at(0))
                                    )
                                ]
                            )
                        );
                    },


  719 =>  /* f_kwrest: kwrest_mark "local variable or method"  */
  /* "src/parser/parser.y":6518  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(clone_value(&ident_t).as_str());
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *(self.builder.kwrestarg( Token::from(yystack.owned_value_at(1)), Some(ident_t))?)
                                ]
                            )
                        );
                    },


  720 =>  /* f_kwrest: kwrest_mark  */
  /* "src/parser/parser.y":6530  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *(self.builder.kwrestarg( Token::from(yystack.owned_value_at(0)), None)?)
                                ]
                            )
                        );
                    },


  721 =>  /* f_opt: f_arg_asgn f_eq arg_value  */
  /* "src/parser/parser.y":6542  */
                    {
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.optarg(
                                 Token::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  722 =>  /* f_block_opt: f_arg_asgn f_eq primary_value  */
  /* "src/parser/parser.y":6556  */
                    {
                        self.current_arg_stack.set(None);
                        self.context.set_in_argdef(true);
                        yyval = Value::Node(
                            self.builder.optarg(
                                 Token::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )?
                        );
                    },


  723 =>  /* f_block_optarg: f_block_opt  */
  /* "src/parser/parser.y":6570  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  724 =>  /* f_block_optarg: f_block_optarg "," f_block_opt  */
  /* "src/parser/parser.y":6574  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  725 =>  /* f_optarg: f_opt  */
  /* "src/parser/parser.y":6582  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  726 =>  /* f_optarg: f_optarg "," f_opt  */
  /* "src/parser/parser.y":6586  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push(  Node::from(yystack.owned_value_at(0)) );
                        yyval = Value::NodeList(nodes);
                    },


  727 =>  /* restarg_mark: "* (tSTAR2)"  */
  /* "src/parser/parser.y":6594  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  728 =>  /* restarg_mark: "*"  */
  /* "src/parser/parser.y":6598  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  729 =>  /* f_rest_arg: restarg_mark "local variable or method"  */
  /* "src/parser/parser.y":6604  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(clone_value(&ident_t).as_str());

                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *(self.builder.restarg( Token::from(yystack.owned_value_at(1)), Some(ident_t))?)
                                ]
                            )
                        );
                    },


  730 =>  /* f_rest_arg: restarg_mark  */
  /* "src/parser/parser.y":6617  */
                    {
                        yyval = Value::NodeList(
                            Box::new(
                                vec![
                                    *(self.builder.restarg( Token::from(yystack.owned_value_at(0)), None)?)
                                ]
                            )
                        );
                    },


  731 =>  /* blkarg_mark: "& (tAMPER2)"  */
  /* "src/parser/parser.y":6629  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  732 =>  /* blkarg_mark: "&"  */
  /* "src/parser/parser.y":6633  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  733 =>  /* f_block_arg: blkarg_mark "local variable or method"  */
  /* "src/parser/parser.y":6639  */
                    {
                        let ident_t =  Token::from(yystack.owned_value_at(0));
                        self.static_env.declare(clone_value(&ident_t).as_str());
                        yyval = Value::Node(
                            self.builder.blockarg(
                                 Token::from(yystack.owned_value_at(1)),
                                Some(ident_t),
                            )?
                        );
                    },


  734 =>  /* f_block_arg: blkarg_mark  */
  /* "src/parser/parser.y":6650  */
                    {
                        self.static_env.declare_anonymous_blockarg();
                        yyval = Value::Node(
                            self.builder.blockarg(
                                 Token::from(yystack.owned_value_at(0)),
                                None
                            )?
                        );
                    },


  735 =>  /* opt_f_block_arg: "," f_block_arg  */
  /* "src/parser/parser.y":6662  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  736 =>  /* opt_f_block_arg: none  */
  /* "src/parser/parser.y":6666  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  737 =>  /* singleton: var_ref  */
  /* "src/parser/parser.y":6672  */
                    {
                        let var_ref =  BoxedNode::from(yystack.owned_value_at(0));
                        self.value_expr(&var_ref)?;
                        yyval = Value::Node(var_ref);
                    },


  738 =>  /* @44: %empty  */
  /* "src/parser/parser.y":6677  */
                           { self.yylexer.lex_state.set(EXPR_BEG); yyval = Value::None; },


  739 =>  /* singleton: "( (tLPAREN2)" @44 expr rparen  */
  /* "src/parser/parser.y":6678  */
                    {
                        let expr =  BoxedNode::from(yystack.owned_value_at(1));

                        match &*expr {
                            Node::Int(nodes::Int { expression_l, .. })
                            | Node::Float(nodes::Float { expression_l, .. })
                            | Node::Rational(nodes::Rational { expression_l, .. })
                            | Node::Complex(nodes::Complex { expression_l, .. })
                            | Node::Str(nodes::Str { expression_l, .. })
                            | Node::Dstr(nodes::Dstr { expression_l, .. })
                            | Node::Sym(nodes::Sym { expression_l, .. })
                            | Node::Dsym(nodes::Dsym { expression_l, .. })
                            | Node::Heredoc(nodes::Heredoc { expression_l, .. })
                            | Node::XHeredoc(nodes::XHeredoc { expression_l, .. })
                            | Node::Regexp(nodes::Regexp { expression_l, .. })
                            | Node::Array(nodes::Array { expression_l, .. })
                            | Node::Hash(nodes::Hash { expression_l, .. }) => {
                                self.yyerror1(
                                    DiagnosticMessage::SingletonLiteral {},
                                    *expression_l,
                                )?;
                            }
                            other => {
                                self.value_expr(other)?
                            }
                        }

                        yyval = Value::Node(expr);
                    },


  740 =>  /* assoc_list: none  */
  /* "src/parser/parser.y":6710  */
                    {
                        yyval = Value::NodeList( Box::new(vec![]) );
                    },


  741 =>  /* assoc_list: assocs trailer  */
  /* "src/parser/parser.y":6714  */
                    {
                        yyval =  yystack.owned_value_at(1);
                    },


  742 =>  /* assocs: assoc  */
  /* "src/parser/parser.y":6720  */
                    {
                        yyval = Value::NodeList( Box::new(vec![  Node::from(yystack.owned_value_at(0)) ]) );
                    },


  743 =>  /* assocs: assocs "," assoc  */
  /* "src/parser/parser.y":6724  */
                    {
                        let mut nodes =  BoxedNodeList::from(yystack.owned_value_at(2));
                        nodes.push( Node::from(yystack.owned_value_at(0)));
                        yyval = Value::NodeList(nodes);
                    },


  744 =>  /* assoc: arg_value "=>" arg_value  */
  /* "src/parser/parser.y":6732  */
                    {
                        yyval = Value::Node(
                            self.builder.pair(
                                 BoxedNode::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  745 =>  /* assoc: "label" arg_value  */
  /* "src/parser/parser.y":6742  */
                    {
                        yyval = Value::Node(
                            self.builder.pair_keyword(
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  746 =>  /* assoc: "label"  */
  /* "src/parser/parser.y":6751  */
                    {
                        yyval = Value::Node(
                            self.builder.pair_label( Token::from(yystack.owned_value_at(0)))
                        );
                    },


  747 =>  /* assoc: "string begin" string_contents tLABEL_END arg_value  */
  /* "src/parser/parser.y":6757  */
                    {
                        yyval = Value::Node(
                            self.builder.pair_quoted(
                                 Token::from(yystack.owned_value_at(3)),
                                 NodeList::from(yystack.owned_value_at(2)),
                                 Token::from(yystack.owned_value_at(1)),
                                 BoxedNode::from(yystack.owned_value_at(0))
                            )
                        );
                    },


  748 =>  /* assoc: "**arg" arg_value  */
  /* "src/parser/parser.y":6768  */
                    {
                        yyval = Value::Node(
                            self.builder.kwsplat( Token::from(yystack.owned_value_at(1)),  BoxedNode::from(yystack.owned_value_at(0)))
                        );
                    },


  749 =>  /* operation: "local variable or method"  */
  /* "src/parser/parser.y":6776  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  750 =>  /* operation: "constant"  */
  /* "src/parser/parser.y":6780  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  751 =>  /* operation: "method"  */
  /* "src/parser/parser.y":6784  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  752 =>  /* operation2: "local variable or method"  */
  /* "src/parser/parser.y":6790  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  753 =>  /* operation2: "constant"  */
  /* "src/parser/parser.y":6794  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  754 =>  /* operation2: "method"  */
  /* "src/parser/parser.y":6798  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  755 =>  /* operation2: op  */
  /* "src/parser/parser.y":6802  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  756 =>  /* operation3: "local variable or method"  */
  /* "src/parser/parser.y":6808  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  757 =>  /* operation3: "method"  */
  /* "src/parser/parser.y":6812  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  758 =>  /* operation3: op  */
  /* "src/parser/parser.y":6816  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  759 =>  /* dot_or_colon: tDOT  */
  /* "src/parser/parser.y":6822  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  760 =>  /* dot_or_colon: "::"  */
  /* "src/parser/parser.y":6826  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  761 =>  /* call_op: tDOT  */
  /* "src/parser/parser.y":6832  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  762 =>  /* call_op: "&."  */
  /* "src/parser/parser.y":6836  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  763 =>  /* call_op2: call_op  */
  /* "src/parser/parser.y":6842  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  764 =>  /* call_op2: "::"  */
  /* "src/parser/parser.y":6846  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  765 =>  /* opt_terms: %empty  */
  /* "src/parser/parser.y":6852  */
                    {
                        yyval = Value::None;
                    },


  766 =>  /* opt_terms: terms  */
  /* "src/parser/parser.y":6856  */
                    {
                        yyval = Value::None;
                    },


  767 =>  /* opt_nl: %empty  */
  /* "src/parser/parser.y":6862  */
                    {
                        yyval = Value::None;
                    },


  768 =>  /* opt_nl: "\n"  */
  /* "src/parser/parser.y":6866  */
                    {
                        yyval = Value::None;
                    },


  769 =>  /* rparen: opt_nl ")"  */
  /* "src/parser/parser.y":6872  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  770 =>  /* rbracket: opt_nl "]"  */
  /* "src/parser/parser.y":6878  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  771 =>  /* rbrace: opt_nl "}"  */
  /* "src/parser/parser.y":6884  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  772 =>  /* trailer: %empty  */
  /* "src/parser/parser.y":6890  */
                    {
                        yyval = Value::None;
                    },


  773 =>  /* trailer: "\n"  */
  /* "src/parser/parser.y":6894  */
                    {
                        yyval = Value::None;
                    },


  774 =>  /* trailer: ","  */
  /* "src/parser/parser.y":6898  */
                    {
                        yyval = Value::None;
                    },


  775 =>  /* term: ";"  */
  /* "src/parser/parser.y":6904  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  776 =>  /* term: "\n"  */
  /* "src/parser/parser.y":6908  */
                    {
                        yyval =  yystack.owned_value_at(0);
                    },


  777 =>  /* terms: term  */
  /* "src/parser/parser.y":6914  */
                    {
                        yyval = Value::TokenList( Box::new(vec![]) );
                    },


  778 =>  /* terms: terms ";"  */
  /* "src/parser/parser.y":6918  */
                    {
                        yyval = Value::TokenList( Box::new(vec![]) );
                    },


  779 =>  /* none: %empty  */
  /* "src/parser/parser.y":6924  */
                  {
                        yyval = Value::None;
                  },



/* "src/parser/parser.rs":11407  */

            _ => {}
        }

        assert!(
            !yyval.is_uninitialized(),
            "yyval is Uninitialized in rule at line {}",
            Self::yyrline_[i32_to_usize(yyn)],
        );

        self.yy_symbol_print("-> $$ =", SymbolKind::get(Self::yyr1_[i32_to_usize(yyn)]), &yyval, &yyloc);

        yystack.pop_n(*yylen);
        *yylen = 0;
        /* Shift the result of the reduction.  */
        let yystate = self.yy_lr_goto_state(yystack.state_at(0), Self::yyr1_[i32_to_usize(yyn)]);
        yystack.push(yystate, yyval, yyloc);
        Ok(Self::YYNEWSTATE)
    }

    // Print this symbol on YYOUTPUT.
    fn yy_symbol_print(&self, s: &str, yykind: &SymbolKind, yyvalue: &YYValue, yylocation: &YYLoc) {
        if  self.is_debug()  {
            self.yycdebug(
                &format!("{}{} {:?} ( {:?}: {:?} )", // " fix highlighting
                s,
                if yykind.code() < Self::YYNTOKENS_ { " token " } else { " nterm " },
                yykind.name(),
                yylocation,
                yyvalue
                )
            )
        }
    }

    /// Parses given input. Returns true if the parsing was successful.
    pub fn parse(&mut self) -> bool {
        /* @$.  */
        let mut yyloc: YYLoc;
        
    /* Lookahead token kind.  */
    let mut yychar: i32 = Self::YYEMPTY_;
    /* Lookahead symbol kind.  */
    let mut yytoken = &DYMMY_SYMBOL_KIND;

    /* State.  */
    let mut yyn: i32 = 0;
    let mut yylen: usize = 0;
    let mut yystate: i32 = 0;
    let mut yystack = YYStack::new();
    let mut label: i32 = Self::YYNEWSTATE;

    /* The location where the error started.  */
    let mut yyerrloc: YYLoc = YYLoc { begin: 0, end: 0 };

    /* Location. */
    let mut yylloc: YYLoc = YYLoc { begin: 0, end: 0 };

    /* Semantic value of the lookahead.  */
    let mut yylval: YYValue = YYValue::new_uninitialized();

        self.yycdebug("Starting parse");
        self.yyerrstatus_ = 0;
        self.yynerrs = 0;

        /* Initialize the stack.  */
        yystack.push(yystate, yylval.clone(), yylloc);

        loop {
            match label {
                // New state.  Unlike in the C/C++ skeletons, the state is already
                // pushed when we come here.

                Self::YYNEWSTATE => {
                    if  self.is_debug()  {
                        self.yycdebug(&format!("Entering state {}", yystate));
                        eprintln!("{}", yystack);
                    }

                    /* Accept? */
                    if yystate == Self::YYFINAL_ {
                        return true;
                    }

                    /* Take a decision.  First try without lookahead.  */
                    yyn = Self::yypact_[i32_to_usize(yystate)];
                    if yy_pact_value_is_default(yyn) {
                        label = Self::YYDEFAULT;
                        continue;
                    }

                    /* Read a lookahead token.  */
                    if yychar == Self::YYEMPTY_ {
                        self.yycdebug("Reading a token");
                        let token = self.next_token();
                        yychar = token.token_type;
                        yylloc = token.loc;
                        yylval = YYValue::from_token(token);
                    }

                    /* Convert token to internal form.  */
                    yytoken = Self::yytranslate_(yychar);
                    self.yy_symbol_print("Next token is", yytoken, &yylval, &yylloc);

                    if yytoken == SymbolKind::get(1) {
                        // The scanner already issued an error message, process directly
                        // to error recovery.  But do not keep the error token as
                        // lookahead, it is too special and may lead us to an endless
                        // loop in error recovery. */
                        yychar = Lexer::YYUNDEF;
                        yytoken = SymbolKind::get(2);
                        yyerrloc = yylloc;
                        label = Self::YYERRLAB1;
                    } else {
                        // If the proper action on seeing token YYTOKEN is to reduce or to
                        // detect an error, take that action.
                        yyn += yytoken.code();
                        if yyn < 0 || Self::YYLAST_ < yyn || Self::yycheck_[i32_to_usize(yyn)] != yytoken.code() {
                            label = Self::YYDEFAULT;
                        }

                        /* <= 0 means reduce or error.  */
                        else {
                            yyn = Self::yytable_[i32_to_usize(yyn)];
                            if yyn <= 0 {
                                if yy_table_value_is_error(yyn) {
                                    label = Self::YYERRLAB;
                                } else {
                                    yyn = -yyn;
                                    label = Self::YYREDUCE;
                                }
                            } else {
                                /* Shift the lookahead token.  */
                                self.yy_symbol_print("Shifting", yytoken, &yylval, &yylloc);

                                /* Discard the token being shifted.  */
                                yychar = Self::YYEMPTY_;

                                /* Count tokens shifted since error; after three, turn off error status.  */
                                if self.yyerrstatus_ > 0 {
                                    self.yyerrstatus_ -= 1;
                                }

                                yystate = yyn;
                                yystack.push(yystate, std::mem::take(&mut yylval), std::mem::take(&mut yylloc));
                                label = Self::YYNEWSTATE;
                            }
                        }
                    }
                    continue;
                }, // YYNEWSTATE

                // yydefault -- do the default action for the current state.
                Self::YYDEFAULT => {
                    yyn = Self::yydefact_[i32_to_usize(yystate)];
                    if yyn == 0 {
                        label = Self::YYERRLAB;
                    } else {
                        label = Self::YYREDUCE;
                    }
                    continue;
                } // YYDEFAULT

                // yyreduce -- Do a reduction.
                Self::YYREDUCE => {
                    yylen = i32_to_usize(Self::yyr2_[i32_to_usize(yyn)]);
                    label = match self.yyaction(yyn, &mut yystack, &mut yylen) {
                        Ok(label) => label,
                        Err(_) => Self::YYERROR
                    };
                    yystate = yystack.state_at(0);
                    continue;
                }, // YYREDUCE

                // yyerrlab -- here on detecting error
                Self::YYERRLAB => {
                    /* If not already recovering from an error, report this error.  */
                    if self.yyerrstatus_ == 0 {
                        self.yynerrs += 1;
                        if yychar == Self::YYEMPTY_ {
                            yytoken = &DYMMY_SYMBOL_KIND;
                        }
                        self.report_syntax_error(&yystack, yytoken, yylloc);
                    }
                    yyerrloc = yylloc;
                    if self.yyerrstatus_ == 3 {
                        // If just tried and failed to reuse lookahead token after an error, discard it.

                        if yychar <= Lexer::END_OF_INPUT {
                            /* Return failure if at end of input.  */
                            if yychar == Lexer::END_OF_INPUT {
                                return false;
                            }
                        }
                        else {
                            yychar = Self::YYEMPTY_;
                        }
                    }

                    // Else will try to reuse lookahead token after shifting the error token.
                    label = Self::YYERRLAB1;
                    continue;
                }, // YYERRLAB

                // errorlab -- error raised explicitly by YYERROR.
                Self::YYERROR => {
                    /* Do not reclaim the symbols of the rule which action triggered
                    this YYERROR.  */
                    yystack.pop_n(yylen);
                    yylen = 0;
                    yystate = yystack.state_at(0);
                    label = Self::YYERRLAB1;
                    continue;
                }, // YYERROR

                // yyerrlab1 -- common code for both syntax error and YYERROR.
                Self::YYERRLAB1 => {
                    self.yyerrstatus_ = 3;       /* Each real token shifted decrements this.  */

                    // Pop stack until we find a state that shifts the error token.
                    loop {
                        yyn = Self::yypact_[i32_to_usize(yystate)];
                        if !yy_pact_value_is_default(yyn) {
                            yyn += SymbolKind { value: SymbolKind::S_YYerror }.code();
                            if (0..=Self::YYLAST_).contains(&yyn) {
                                let yyn_usize = i32_to_usize(yyn);
                                if Self::yycheck_[yyn_usize] == SymbolKind::S_YYerror {
                                    yyn = Self::yytable_[yyn_usize];
                                    if 0 < yyn {
                                        break;
                                    }
                                }
                            }
                        }

                        // Pop the current state because it cannot handle the error token.
                        if yystack.len() == 1 {
                            return false;
                        }

                        yyerrloc = *yystack.location_at(0);
                        yystack.pop();
                        yystate = yystack.state_at(0);
                        if  self.is_debug()  {
                            eprintln!("{}", yystack);
                        }
                    }

                    if label == Self::YYABORT {
                        /* Leave the switch.  */
                        continue;
                    }

                    /* Muck with the stack to setup for yylloc.  */
                    yystack.push(0, YYValue::new_uninitialized(), yylloc);
                    yystack.push(0, YYValue::new_uninitialized(), yyerrloc);
                    yyloc = make_yylloc(&yystack, 2);
                    yystack.pop_n(2);

                    /* Shift the error token.  */
                    self.yy_symbol_print("Shifting", SymbolKind::get(Self::yystos_[i32_to_usize(yyn)]), &yylval, &yyloc);

                    yystate = yyn;
                    yystack.push(yyn, yylval.clone(), yyloc);
                    label = Self::YYNEWSTATE;
                    continue;
                }, // YYERRLAB1

                // Accept
                Self::YYACCEPT => {
                    return true;
                }

                // Abort.
                Self::YYABORT => {
                    return false;
                },

                _ => {
                    panic!("internal bison error: unknown label {}", label);
                }
            }
        }
    }
}

// Whether the given `yypact_` value indicates a defaulted state.
fn yy_pact_value_is_default(yyvalue: i32) -> bool {
    yyvalue == YYPACT_NINF_
}

// Whether the given `yytable_`
// value indicates a syntax error.
// yyvalue: the value to check
fn yy_table_value_is_error(yyvalue: i32) -> bool {
    yyvalue == YYTABLE_NINF_
}

const YYPACT_NINF_: i32 = -1064;
const YYTABLE_NINF_: i32 = -780;

impl  Parser  {

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
  #[allow(non_upper_case_globals)]
const yypact_: &'static [i32] = &[  -1064,   137,  4268, -1064,  8317, -1064, -1064, -1064, 12732, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064,  8592,  8592, -1064, -1064,
   -1064,  7449,  7157, -1064, -1064, -1064, -1064,   293, 12587,     2,
      28,   144, -1064, -1064, -1064,  6281,  7011, -1064, -1064,  6427,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, 10786, 10786,
   10786, 10786,   131,  5456,  8729,  9277,  9688, 11197, -1064, 12442,
   -1064, -1064, -1064,    67,   188,   196,   255, 10786, 10923,  1340,
   -1064,   341, -1064,  1074, -1064,   526,   230,   230, -1064, -1064,
      79,   282,   283, -1064,   318, 11320, -1064,   358,  2409,   811,
     484,   641, -1064, 11060, 11060, -1064, -1064,  9825, 11442, 11564,
   11809, 12297,  8592, -1064,   271,    86, -1064, -1064,   387, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064,   600,   664, -1064,   440,   689, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064,   434, -1064, -1064, -1064,   447,
   10786,   534,  5594, 10786, 10786, 10786, -1064, 10786,   230,   230,
   -1064,   441, 14599,   497, -1064, -1064,   476,   706,    35,   220,
     516,   226,   492, -1064, -1064,  8454, -1064,  8592,  8866, -1064,
   -1064,  9963, -1064, 11060,   876, -1064,   485,  5732, -1064,  5870,
   -1064, -1064,   495,   560,    79, -1064,   712, -1064,   631,  3903,
    3903,   700, -1064, -1064,  5456,   611,   341, -1064,  1074,     2,
     587, -1064,  1074,     2,   581,   307,   343, -1064,   497,   593,
     343, -1064,     2,   672, 11931,  1340,   609,   609,   615, -1064,
     842,   852,   860,   906, -1064, -1064, -1064, -1064, -1064,   295,
   -1064,  1017,  1101,   756, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064,   680, -1064, -1064, -1064, -1064,  4422, 11060, 11060, 11060,
   11060,  8729, 11060, 11060,  2223,   637,   648,  4601,  2223, -1064,
     657,  4601, -1064, -1064, -1064,   701, -1064, -1064, -1064, -1064,
   -1064, 10101, -1064,  5456, 11686,   690, 10101, -1064, 10786, 10786,
   10786, 10786, 10786, -1064, -1064, 10786, 10786, 10786, 10786, 10786,
   10786, 10786, 10786, -1064, 10786, 10786, -1064, -1064, 10786, 10786,
   10786, 10786, 10786, 10786, 10786, 10786, 10786, -1064, -1064, 13472,
    8592, 13545,  4601,   526,    83,    83,  6008, 11060,  6008,   341,
   -1064,   694,   771, -1064, -1064,   913,   810,    88,   138,   142,
     716,   835, 11060,   145, -1064,   705,   954, -1064, -1064, -1064,
   -1064,    64,    80,   246,   323,   340,   422,   514,   604,   605,
   -1064, -1064, -1064, -1064,   618, -1064, -1064, -1064, 14567, -1064,
   -1064, 10923, 10923, -1064, -1064,   229, -1064, -1064, -1064,   787,
     714,   722, 10786, 10786,  9003, -1064, -1064, 13618,  8592, 13691,
   10786, 10786,  9414, -1064,     2,   751, -1064, -1064, 10786,     2,
   -1064,   735,     2,   745, -1064,   103, -1064, -1064, -1064, -1064,
   -1064, 12732, -1064, 10786,   759,   768, 13618, 13691, 10786,    28,
       2, -1064, -1064,  8180,   774,     2, -1064, -1064,  9551, -1064,
   -1064,  9688, -1064, -1064, -1064,   485,   963, -1064,   779, -1064,
   -1064, 11931, 13764,  8592, 13837,  1914, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064,  1120,    53,  1147,    62,
   10786, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,  1235, -1064,
   -1064, -1064, -1064, -1064,   780, -1064,     2, -1064, -1064, -1064,
     783, -1064,   788, 10786, -1064,   791,   101, -1064, -1064, -1064,
     792,   883,   825,   884, -1064, 10923,   941,   951,   341, 10923,
     941, -1064, -1064, -1064, -1064, -1064, 10786, -1064,   840,   841,
     932, -1064,     2, 11931,   861, -1064, -1064, -1064,   943,   831,
    3292, -1064, -1064, -1064,   967,   231, 12940,   631,  3590,  3590,
    3590,  3590,  4592, 14641,  3590,  3590,  3903,  3903,   747,   747,
   12940,  1033,   653,  1033,   568,   568,   631,   631,   631,  3749,
    1775,  1775,  7595,  6573,  7887,  6719, -1064,   560, -1064,     2,
     866,   738, -1064,   848, -1064, -1064,  7303,   941, -1064,  4755,
     979,  5169,   941,    71,   941,   969,   981,   151, 13910,  8592,
   13983, -1064,   526, -1064,   963, -1064, -1064, -1064, 14056,  8592,
   14129,  4601, 11060, -1064, -1064, -1064, -1064, -1064,  2163, -1064,
   13286, -1064, -1064, -1064, 12732, 10786, 10786, 10786, -1064, 10786,
     497, -1064,   492,  4066,  6865,     2,   367,   373, -1064, -1064,
   -1064, -1064,  9140, -1064,  9414, -1064, -1064, 11060, 14599, -1064,
   -1064,   560,   560, -1064, -1064,   349, -1064, -1064,   343, 11931,
     779,   473,   540,     2,   437,   501,  2223, -1064, -1064, -1064,
    1090, -1064,   466, -1064,   865, -1064, -1064,   612,   868, -1064,
     631,  1235,  1105, -1064,   874,     2,   886, -1064,   416, -1064,
   -1064, -1064, 10786,   879,  2223, -1064, -1064,   627, -1064, -1064,
   -1064,  2223, -1064, -1064,  2012, -1064, -1064,   972, 13363, -1064,
   -1064, -1064, 10238,   309, -1064, -1064,   974, 13388, -1064,   897,
     895, -1064,   941,   895,   941,   908, 10375,  8729, -1064,   779,
   11931,  8729, 10923, 10786, 14202,  8592, 14275, -1064, -1064, -1064,
    1968,  1968,   505, -1064, 13027,   236,   991, -1064,  1242, -1064,
   -1064,    55, -1064,   915, -1064, -1064, -1064,   921, -1064,   924,
   -1064, 13288, -1064, -1064, -1064, -1064,   665, -1064, -1064, -1064,
      47, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
     104, -1064,   907, 10923, 10923, -1064,   701,   929,   890,  9003,
   10923, 10923, -1064, -1064,   701, -1064, -1064,   796, -1064,  1043,
   -1064, -1064, -1064, -1064, -1064, -1064,   981,   941, -1064, 10512,
     941,    74,    82,     2,   154,   171,  6008,   341, 11060,  4601,
     916,   540, -1064,     2,   941,   103, 12877,    86,   282, -1064,
   -1064, -1064, -1064, 10786, 10786,   455, 10786, 10786,     2,   944,
     103, -1064, -1064,   566,     2,    61, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064,     2, -1064,  1235,
   -1064,  1352, -1064, -1064, -1064, -1064, -1064,   945,   949, -1064,
    1025,   780,   956, -1064,   959, -1064,   956, 10786, 10786,   840,
   -1064,   985, -1064, -1064, -1064,  6008,  5318, -1064, -1064, 10786,
   10786, -1064,  1600,  5870, -1064, -1064,   961, -1064,  4601, -1064,
   10786,   976, -1064,   779, -1064, 14599,  7741,  8033,     2,   487,
     493, -1064, -1064, -1064, -1064, 13288,   190,     2, 13114, -1064,
       2,   980, -1064,   647,   982, -1064, -1064,   802, -1064, -1064,
   -1064, -1064, 11060, -1064,  1055, 13201, 13288, 13288,   647,  1011,
    1968,  1968,   505,   525,    26, 12940, 12940, -1064, -1064, 10786,
   -1064, -1064, -1064, -1064, -1064, -1064, 10923, -1064, -1064, -1064,
   -1064, -1064, -1064,  6008, 11060,   941, -1064, -1064,   941, 12940,
     941, -1064, 10786, -1064,    60, -1064,   213,   941,  4601,   341,
     941, -1064, -1064, -1064, -1064, -1064, -1064, 10786, -1064,  9414,
   -1064,  1026,   994, -1064, -1064, -1064, -1064, -1064, -1064,   995,
    1012,  2223, -1064,  2012, -1064, -1064,  2012, -1064,  2012, -1064,
   -1064, 14599, 14599, 12053,    83, -1064, -1064,  1131, 14599, 14599,
     780, -1064,     2,  1016,   783,  1040, 12175, -1064,  1048, -1064,
    1054,  1056, -1064, -1064, -1064, -1064,  1058,   500,    17, -1064,
      68,  1011,  1059, -1064, -1064, -1064,     2, -1064, -1064,  1039,
   -1064, -1064,  1069, -1064,  1071, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064,     2,     2,     2,     2,     2,     2, 14599,
   -1064, -1064, -1064,    83, -1064, -1064,    83,   790, -1064, -1064,
   10649,  4893, -1064,   941, -1064, -1064, -1064,  1191,  4601,  5870,
   -1064,  1352,  1352,   956,  1072,   956,   956,  1095, -1064,  1003,
     113,   133,   241,  4601, -1064, -1064,  1023, -1064, 12175,  1174,
   -1064, -1064,  1124,  1028,   627, -1064,  1174, -1064,  1745, -1064,
   -1064,  1073, 13288, -1064,   251, -1064, -1064, 13288, 13201, -1064,
   -1064, -1064, -1064, -1064, -1064,  4755, -1064, 11060, 11060, 10786,
   -1064,   660, -1064, -1064,   418, -1064, -1064,   941,  1076,  6146,
    1012, -1064,  2012, -1064, -1064, -1064,   320, 14348,  8592, 14421,
     951, -1064,  1028, -1064,  1082,  1087, -1064, 14494, -1064,   780,
    1096, -1064,  1099,  1096, 13288,  1100,  1100, -1064, -1064,   796,
    5031, -1064, -1064, -1064, -1064, -1064, -1064,  1191, -1064, -1064,
   -1064,  1113,   956,   169,   275,     2,   344,   396, -1064,  1174,
   -1064,  1745, -1064,  1108,  1118, -1064,  1745, -1064,  1745, -1064,
   -1064,  1100, 13288, -1064,   118, -1064, -1064, -1064,   397,  1096,
    1110,  1096,  1096, -1064, -1064, -1064, -1064,  1745, -1064, -1064,
   -1064,  1096, -1064 ];

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
  #[allow(non_upper_case_globals)]
const yydefact_: &'static [i32] = &[      2,     0,     0,     1,     0,   369,   370,   371,     0,   362,
     363,   364,   367,   365,   366,   368,   357,   358,   359,   360,
     380,   290,   290,   652,   651,   653,   654,   767,     0,   767,
       0,     0,   656,   655,   657,   749,   751,   648,   647,   750,
     650,   639,   640,   641,   642,   590,   662,   663,     0,     0,
       0,     0,     0,     0,   318,   779,   779,   102,   439,   610,
     610,   612,   614,     0,     0,     0,     0,     0,     0,     0,
       3,   765,     6,     9,    34,    39,   671,   671,    55,    73,
     290,    72,     0,    90,     0,    94,   104,     0,    64,   242,
     261,     0,   316,     0,     0,    70,    70,   765,     0,     0,
       0,     0,   327,   338,    74,   336,   305,   306,   589,   591,
     307,   308,   309,   311,   310,   312,   588,   629,   630,   587,
     637,   658,   659,   313,     0,   314,    78,     5,     8,   183,
     194,   184,   207,   180,   200,   190,   189,   210,   211,   205,
     188,   187,   182,   208,   212,   213,   192,   181,   195,   199,
     201,   193,   186,   202,   209,   204,   203,   196,   206,   191,
     179,   198,   197,   178,   185,   176,   177,   173,   174,   175,
     133,   135,   134,   168,   169,   164,   146,   147,   148,   155,
     152,   154,   149,   150,   170,   171,   156,   157,   161,   165,
     143,   145,   151,   153,   172,   144,   158,   159,   160,   162,
     163,   167,   166,   138,   140,    27,   136,   137,   139,     0,
     746,     0,     0,     0,     0,   293,   610,     0,   671,   671,
     285,     0,   268,   296,    88,   289,   779,     0,   658,   659,
       0,   314,   779,   742,    89,   767,    86,     0,   779,   461,
      85,   767,   768,     0,     0,    22,   254,     0,    10,     0,
     357,   358,   330,   462,     0,   236,     0,   327,   237,   227,
     228,   324,    18,    20,     0,     0,   765,    16,    19,   767,
      92,    15,   320,   767,     0,   772,   772,   269,     0,     0,
     772,   740,   767,     0,     0,     0,   671,   671,   100,   361,
       0,   110,   111,   118,   440,   634,   633,   635,   632,     0,
     631,     0,     0,     0,   597,   606,   602,   608,   249,    59,
     248,   638,   775,   776,     4,   777,   766,     0,     0,     0,
       0,     0,     0,     0,   694,     0,   670,     0,   694,   668,
       0,     0,   372,   464,   455,    79,   466,   335,   373,   449,
     451,     0,   106,     0,    98,    95,     0,    62,     0,     0,
       0,     0,     0,   264,   265,     0,     0,     0,     0,   225,
     226,     0,     0,    60,     0,     0,   262,   263,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   761,   762,     0,
     779,     0,     0,    69,     0,     0,     0,     0,     0,   765,
     345,   766,     0,   391,   390,     0,     0,   658,   659,   314,
     128,   129,     0,     0,   131,   666,     0,   658,   659,   314,
     353,   203,   196,   206,   191,   173,   174,   175,   133,   134,
     738,    66,    65,   737,     0,    87,   764,   763,     0,   337,
     592,     0,     0,   141,   745,   324,   297,   748,   292,     0,
       0,     0,     0,     0,     0,   286,   295,     0,   779,     0,
       0,     0,     0,   287,   767,     0,   329,   291,   695,   767,
     281,   779,   767,   779,   280,   767,   334,    58,    24,    26,
      25,     0,   331,     0,     0,     0,     0,     0,     0,     0,
     767,   322,    14,   766,    91,   767,   319,   325,   774,   773,
     270,   774,   272,   326,   741,     0,   117,   108,   103,   638,
     670,     0,     0,   779,     0,   694,   616,   636,   619,   617,
     611,   593,   594,   613,   595,   615,     0,     0,     0,     0,
       0,   778,     7,    28,    29,    30,    31,    32,    56,    57,
     701,   698,   697,   696,   699,   707,   716,   695,     0,   728,
     717,   732,   731,   727,   779,   693,   767,   677,   700,   702,
     703,   705,   679,   709,   714,   779,   720,   404,   403,   725,
     679,   730,   679,   734,   676,     0,     0,   779,     0,     0,
       0,   468,    76,    80,   470,   470,     0,    35,   301,     0,
      38,   300,   767,     0,    96,   107,    54,    40,    52,     0,
     273,   296,   214,    36,     0,   314,     0,   234,   241,   243,
     244,   245,   252,   253,   246,   247,   223,   224,   250,   251,
       0,   238,   240,   239,   229,   230,   231,   232,   233,   767,
     266,   267,   752,   754,   753,   755,   460,   290,   458,   767,
     779,   752,   754,   753,   755,   459,   290,     0,   382,     0,
     381,     0,     0,     0,     0,   343,     0,   324,     0,   779,
       0,    70,   351,   128,   129,   130,   664,   349,     0,   779,
       0,     0,     0,   759,   760,    67,   752,   753,   290,    41,
     273,   215,    51,   222,     0,     0,     0,     0,   744,     0,
     298,   294,   779,   752,   753,   767,   752,   753,   743,   328,
     769,   275,   282,   277,   284,   333,    23,     0,   255,    11,
      33,     0,   779,   221,    21,    93,    17,   321,   772,     0,
     101,   756,   116,   767,   752,   753,   694,   441,   444,   620,
       0,   596,     0,   599,     0,   604,   601,     0,     0,   605,
     235,     0,   402,   394,   396,   767,   399,   392,     0,   675,
     736,   669,     0,     0,     0,   686,   708,     0,   674,   718,
     719,     0,   689,   729,     0,   691,   733,    47,   257,   379,
     355,   374,   779,   779,   579,   672,    49,   259,   356,     0,
     779,   468,     0,   779,     0,   304,     0,     0,   105,    99,
       0,     0,     0,     0,     0,   779,     0,   571,   577,   544,
       0,     0,     0,   516,   767,   513,   532,   610,     0,   570,
      63,   487,   493,   495,   497,   491,   490,   528,   492,   537,
     540,   543,   549,   550,   539,   500,   551,   501,   556,   557,
     558,   561,   562,   563,   564,   565,   567,   566,   568,   569,
     547,    61,     0,     0,     0,   457,    83,     0,   463,   282,
       0,     0,   279,   456,    81,   278,   317,   779,   383,   779,
     341,   385,    71,   384,   342,   479,     0,     0,   376,     0,
       0,   756,   323,   767,   752,   753,     0,     0,     0,     0,
     128,   129,   132,   767,     0,   767,     0,   452,    75,   142,
     747,   299,   288,     0,     0,   463,     0,     0,   767,   779,
     767,   271,   109,   463,   767,     0,   621,   625,   626,   627,
     618,   628,   598,   600,   607,   603,   609,   767,   401,     0,
     704,     0,   735,   721,   406,   678,   706,   679,   679,   715,
     720,   779,   679,   726,   679,   703,   679,     0,     0,   580,
     581,   779,   582,   375,   377,     0,     0,    13,   586,     0,
       0,   465,   767,     0,   430,   429,     0,   467,     0,   450,
       0,   302,    37,    97,    53,   274,   752,   753,   767,   752,
     753,   559,   560,   129,   575,     0,   518,   767,   519,   525,
     767,     0,   512,     0,     0,   515,   531,     0,   572,   644,
     643,   645,     0,   573,     0,   488,     0,     0,   538,   542,
     554,   555,     0,   499,   498,     0,     0,   548,   546,     0,
      46,   219,    45,   220,    84,   770,     0,    43,   217,    44,
     218,    82,   378,     0,     0,     0,   386,   388,     0,     0,
       0,   347,     0,   472,     0,   346,   463,     0,     0,     0,
       0,   463,   354,   739,    68,   453,   454,     0,   276,   283,
     332,     0,   433,   447,   445,   442,   622,   393,   395,   397,
     400,     0,   682,     0,   684,   673,     0,   690,     0,   687,
     692,    48,   258,     0,     0,   584,   585,   779,    50,   260,
     779,   428,   767,     0,   703,   412,   711,   712,   779,   723,
     412,   412,   410,   469,    77,   471,   303,   463,   767,   510,
     523,   535,   520,   511,   526,   610,   767,   771,   545,     0,
     494,   489,   528,   496,   529,   533,   541,   536,   552,   553,
     576,   509,   505,   767,   767,   767,   767,   767,   767,   256,
      42,   216,   389,     0,   339,   340,     0,   484,   344,   473,
       0,     0,   348,     0,   665,   350,   443,     0,     0,     0,
     623,     0,     0,   679,   679,   679,   679,     0,   583,     0,
     658,   659,   314,     0,    12,   409,     0,   431,     0,   413,
     421,   419,     0,   710,     0,   408,     0,   424,     0,   426,
     517,   521,     0,   527,     0,   514,   574,     0,     0,   502,
     503,   504,   506,   507,   508,     0,   480,     0,     0,     0,
     474,   779,   352,   437,   767,   435,   438,     0,     0,     0,
     398,   683,     0,   680,   685,   688,   324,     0,   779,     0,
     779,   432,   722,   411,   412,   412,   324,     0,   713,   779,
     412,   724,   412,   412,     0,   524,   529,   530,   534,   779,
       0,   485,   486,   475,   477,   478,   476,     0,   434,   448,
     446,     0,   679,   756,   323,   767,   752,   753,   578,     0,
     416,     0,   418,   756,   323,   407,     0,   425,     0,   422,
     427,   522,     0,   387,   779,   436,   624,   681,   463,   412,
     412,   412,   412,   482,   483,   481,   417,     0,   414,   420,
     423,   412,   415 ];

/* YYPGOTO[NTERM-NUM].  */
  #[allow(non_upper_case_globals)]
const yypgoto_: &'static [i32] = &[  -1064, -1064, -1064,  1008, -1064,    32,   777,  -321,    19, -1064,
     776, -1064,    85, -1064,  -317,  -262,    65, -1064, -1064,   384,
    2138,  2376, -1064,     3,   -66, -1064,    24, -1064,  -642, -1064,
    1117,    -9,  1163,   -91,    13,   -70, -1064,  -433,    -8,  2620,
    -392,  1167,   -57,   -22, -1064, -1064,    -7, -1064,  3564, -1064,
    1181, -1064,  1232, -1064,   424,    -4,   606,  -367,    63,     6,
   -1064,  -401,  -207,    23, -1064,  -327,   -15, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064,   187, -1064, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064, -1064,
   -1064, -1064,   510, -1064,   -93,  1375,  -380, -1064,    48,  -811,
   -1064,  -864,  -840,   555,   386,   147,   228, -1064,   361,   313,
   -1064, -1064,   527, -1064,  -838, -1064,    72,   107, -1064, -1064,
   -1064, -1064, -1064, -1064, -1064,   438, -1064, -1064, -1064,  -102,
   -1064, -1064,   541, -1064,   746, -1064, -1064,  -794, -1064,    56,
   -1064, -1064, -1064, -1064,  -578,  -371, -1064, -1064, -1064, -1064,
     336, -1064, -1064,    41, -1064,  -550,  -693,  -903, -1056,  -446,
    -223, -1064,   339, -1064, -1064, -1064,   345, -1064,  -639,   350,
   -1064, -1064, -1064,   125, -1064, -1064,   270,   556,   870, -1064,
    1230,   877,  1666,  1805, -1064,   821,  2059, -1064,  2348,  2797,
   -1064, -1064,   -56, -1064, -1064,  -172, -1064, -1064, -1064, -1064,
   -1064, -1064, -1064,    49, -1064, -1064, -1064, -1064,   -21, -1064,
    2611,    10,  1240,  2872,  1505, -1064, -1064,    14,   586,    29,
   -1064,  -201,  -263,  -240,  -212,  -842,  -420,  -259,  -711,   762,
     164,   597,   184, -1064, -1064,  -569, -1064,  -710,  -717, -1063,
     192,   613, -1064,  -556, -1064,   112,  -532, -1064, -1064, -1064,
       0,  -432, -1064,  -257, -1064, -1064,   -82, -1064,   -39,   120,
     839,   677,   253,  -245,   -47,   -24,    -2 ];

/* YYDEFGOTO[NTERM-NUM].  */
  #[allow(non_upper_case_globals)]
const yydefgoto_: &'static [i32] = &[      0,     1,     2,    70,    71,    72,   248,   566,   567,   266,
     267,   479,   268,   471,    74,   587,    75,   610,   596,   421,
     218,   219,   876,   384,   386,   387,    78,    79,   573,   771,
     254,    81,    82,   269,    83,    84,    85,   498,    86,   221,
     404,   405,   203,   204,   205,   674,   625,   207,    88,   473,
     375,    89,   223,   274,   592,   626,   843,   459,   460,   236,
     237,   225,   445,   630,   580,   581,    90,   382,   273,   485,
     697,   856,   646,   869,   867,   661,   256,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   336,   339,   762,
     935,   859,  1013,  1014,   760,   257,   639,   852,  1015,  1016,
     396,   733,   734,   735,   736,   544,   742,   743,  1213,  1160,
    1161,  1072,   943,   944,  1041,  1194,  1195,   103,   294,   505,
     895,   717,  1045,  1139,  1138,   340,   575,   104,   105,   337,
     571,   574,   769,   770,   772,   773,  1024,   860,  1236,   857,
    1019,  1230,  1275,  1126,   800,  1091,   802,   803,   995,   996,
     804,   973,   965,   967,   968,   969,   806,   807,  1104,   971,
     808,   809,   810,   811,   812,   813,   814,   815,   816,   817,
     818,   819,   820,   763,   931,  1064,   937,   106,   107,   108,
     109,   110,   111,   112,   516,   722,   113,   518,   114,   115,
     517,   519,   299,   302,   303,   510,   720,   719,   896,  1046,
    1140,  1199,   900,   116,   117,   300,   118,   119,   120,   983,
     228,   229,   123,   230,   231,   657,   868,   325,   326,   327,
     328,   915,   745,   546,   547,   548,   549,   925,   551,   552,
     553,   554,  1077,  1078,   555,   556,   557,   558,   559,  1079,
    1080,   560,   561,   562,   563,   564,   739,   424,   662,   279,
     463,   233,   126,   701,   628,   665,   660,   428,   314,   455,
     456,   838,   975,   490,   640,   391,   271 ];

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
  #[allow(non_upper_case_globals)]
const yytable_: &'static [i32] = &[    127,   206,   298,   429,   301,   641,   245,   220,   220,   381,
     570,   655,   122,   629,   122,   345,   232,   232,   239,   593,
     688,   206,   427,   748,   315,   453,   462,   830,   240,   586,
     388,   492,   831,   916,   923,   494,   128,   921,  1018,   226,
     226,   830,   289,   681,   422,  1048,   805,   316,   311,   288,
     315,   681,   206,   277,   281,   276,   280,   208,   390,   688,
     805,   637,  1020,   122,   122,   550,   270,   292,   710,   550,
     289,  1050,   265,   638,   329,   329,   334,   208,   275,   224,
     234,   685,  1102,   289,   289,   289,   335,    73,   568,    73,
    1043,   330,   309,   220,   206,   292,   638,   385,   851,  -123,
     389,   970,   232,  1221,  1073,   332,   331,  -125,   398,   408,
     408,   408,   332,  -119,   586,   586,  1225,   984,   737,   724,
    1171,  1226,   627,   545,   636,   226,  -119,   545,   728,  -767,
     513,   515,  -652,   934,  -660,   749,   713,     3,   997,   272,
     322,   323,   242,   855,   992,   449,  -120,   243,  -651,   246,
     779,   961,   962,   750,   247,   984,   998,   242,   383,   383,
     439,  -652,   383,  -120,  -119,   425,   242,  -127,  1261,   669,
     672,   668,   725,   480,   477,   993,  -126,  -651,   920,  -122,
     985,   729,  -123,   994,  1044,  1130,  1221,   261,   918,    91,
     627,    91,   636,  1172,  1004,   924,  -124,   653,   312,  -114,
     313,   654,  1011,   227,   227,   333,   304,  -116,   504,   312,
    -752,   313,   333,  -110,   497,   238,   329,   329,  -753,   315,
     702,   312,   122,   313,   446,   801,   220,   482,   220,   220,
     446,   265,   440,   441,  1156,   232,   464,   232,  -121,   801,
      91,    91,   483,   242,   290,   127,   550,   702,   331,   239,
     334,  -119,   582,  -119,  -127,   227,   453,   122,   226,   122,
     226,   461,   688,  -111,   499,   718,   872,  -118,   475,   289,
     249,  -120,   290,  -120,   122,  1227,  -117,   270,  1048,  -113,
     227,   227,   863,   265,   227,   395,   406,   406,  -125,   227,
     984,   681,   873,   681,   292,  1196,  -115,   752,   454,   755,
     457,  1200,  1114,  1117,   545,  -752,   465,  -123,   467,  -123,
     338,   737,   908,   650,  -653,  -535,   331,   506,   933,  -661,
     523,   524,   525,   526,   934,   451,   122,   305,   478,   289,
     432,   122,    73,  -126,   923,   306,   584,   122,  -112,   377,
     874,   122,   315,  -653,   723,   916,   723,   953,   522,  -120,
     645,  1108,  1109,   122,   292,  -127,   270,  -122,  -126,  -779,
    -127,   506,   265,  -767,   579,   577,   324,   378,   426,   579,
     588,   220,   508,   509,   634,  1098,   242,   635,   464,  -127,
    1234,  -127,   383,   383,   383,   383,  1081,   528,   529,  1055,
     643,  -654,   122,   702,   307,  1196,   122,  1235,   122,    91,
     964,    73,   495,   702,   830,   642,   527,   644,  -656,  -124,
    -121,  -753,   341,  -125,   507,  -125,   508,   509,   958,   830,
    -654,   634,   227,   966,   227,   227,   830,   830,   227,   241,
     227,   497,   488,   242,    91,   930,    91,  -656,   681,   220,
     989,  1127,   634,   342,   682,   635,   464,   489,   916,   696,
     830,    91,   383,  1273,  1219,   588,   588,   550,  -126,   446,
    -126,   446,  -113,   891,   206,   586,   886,   652,   491,   805,
     634,   290,   887,   635,  -105,   882,   894,   768,   -91,   312,
     888,   313,  -122,   489,  -122,   550,   289,   346,   708,   737,
    -655,   737,   550,   122,   220,  1144,  -122,   634,  -114,    60,
     635,   464,  -124,    91,   227,   227,   227,   227,    91,   227,
     227,   292,   786,   497,    91,   545,   586,   586,    91,  -655,
     208,   765,  1092,   586,   586,   541,  -115,   627,   227,   636,
      91,   290,   506,   594,  -124,  -121,  -124,  -121,  1155,   431,
    -113,  1105,   740,  1237,   846,   916,  1165,   542,  1030,   850,
     903,   854,  -361,   740,  1037,   903,   757,   653,   242,   433,
     766,   963,  -113,   322,   323,   764,  -113,   227,   289,    91,
     442,  1000,  1002,    91,   227,    91,  -114,  -113,  1007,  1009,
    -361,  -361,  -657,   241,  -121,   866,   840,   508,   509,   227,
     435,  -112,   841,   292,  1088,   920,   853,   443,  -114,  1006,
    1110,   444,  -114,  1215,  -115,   902,   829,   688,  -323,  -752,
    1222,  -657,  -361,  -114,   966,   450,  -122,   452,   594,   594,
     829,   472,  -124,   835,   966,   966,  -115,  1085,   446,  -121,
    -115,   235,   842,   836,   845,   227,  -323,  -323,   681,   892,
     220,  -115,   844,   634,  1131,   348,   635,   464,   801,   122,
     220,   122,   879,   634,  1052,  1054,   635,   464,   847,  1057,
     849,  1059,  -767,  1060,   842,   242,   845,   206,  -323,  -112,
      91,   122,  -646,  -649,   878,   934,  -753,   858,   506,   947,
     446,   949,   882,  1074,  1153,   535,   663,  1255,   290,   586,
     227,  -112,   889,  1270,   289,  -112,   238,   835,   842,  -660,
     845,  -646,  -649,   799,   536,   789,  -112,  1133,   348,   377,
     497,   371,   372,   373,   481,   664,   -90,   799,   487,   292,
     493,   737,   737,   208,   536,  -110,  1105,   875,   496,  -119,
     348,  1105,  1228,   508,   509,   540,   541,   378,   379,   832,
     501,   977,  -749,  1185,  1120,   324,  1186,   361,   362,   837,
    1096,   905,   227,   990,   991,   540,   227,   520,   542,  1095,
     932,   938,   890,  -661,  1021,   289,   565,  1025,   945,   380,
     290,   945,  1115,  1118,   377,  1035,   220,  -667,  1105,   634,
     377,  1032,   635,   464,  -646,   579,   569,   122,   432,  -111,
     292,   122,   550,  -120,   369,   370,   371,   372,   373,   478,
     829,   829,   378,   447,   829,   837,   588,   572,   378,   476,
    1012,   934,  -646,  -646,  -118,   585,  1228,  1197,  -127,   422,
    1028,   829,   506,   514,   348,  -117,    91,   647,    91,  -126,
    1187,  1188,   521,   837,   448,   651,   227,   840,   656,   889,
     448,  1245,  -749,   676,  -646,  1017,   227,  1017,    91,   227,
     912,   677,  -749,   506,   690,   671,   673,   588,   588,   912,
     692,  -750,   952,  -113,   588,   588,   954,  -122,   506,   206,
     694,  1029,   500,   500,   671,   673,   122,   508,   509,   122,
    1201,  1203,  1204,  1205,   227,  1027,   699,   446,   369,   370,
     371,   372,   373,   353,   354,   700,   290,   799,   799,  -105,
    1074,   799,   703,  -649,   709,   738,   511,  1074,   508,   509,
     377,   675,  -405,   744,   837,   974,   747,   751,   799,   740,
    -658,   511,  1124,   508,   509,  1125,  1098,  1128,  -659,  1065,
     468,  -649,  -649,   383,  1132,   753,   756,  1135,   378,   502,
     469,   470,  -756,   366,   367,   122,   122,   841,  -658,  -658,
     754,   759,   702,   122,  1066,  1067,  -659,  -659,   122,   761,
     782,  -750,  1083,  -649,    91,  -296,   776,   290,    91,   594,
     503,  -750,   227,  -115,  -314,   829,   777,  -124,   829,  1267,
    -658,   377,  1134,   837,  -756,  1099,   780,   781,  -659,  1006,
    1074,   839,   848,   837,   855,   829,   829,   829,   858,   909,
     829,   829,  -314,  -314,   904,   829,   829,   906,   914,   378,
     648,   911,  -756,  -756,  1042,  -112,   927,  1123,   939,  -121,
     594,   594,   377,   122,   941,   942,  1101,   594,   594,   829,
     588,  -324,  1122,  -297,  -314,   377,  1113,  1116,   122,  1174,
    1192,   649,  -756,   976,  -756,   986,   987,   383,   289,   988,
     378,   658,  -752,    91,  1082,   227,    91,   999,   934,  -324,
    -324,   289,  1042,   378,   784,   938,  1005,  1209,   740,  1039,
    1051,   377,   799,  1151,  1053,   799,   740,   750,   837,   383,
     466,  1056,   659,   506,  1058,  1063,   408,   837,  1084,  1070,
     837,  -324,   799,   799,   799,   785,   377,   799,   799,   378,
    1207,  -298,   799,   799,  1239,  1094,  1076,   787,   484,  1097,
     348,   984,   486,   837,   317,   318,   319,   320,   321,    80,
    1141,    80,    91,    91,   378,  1217,   799,   361,   362,  1136,
      91,  1208,  1137,    80,    80,    91,   511,  1142,   508,   509,
     933,   122,  1176,   289,   897,   898,  1157,   899,   122,   122,
    1191,  1206,   821,  1211,    46,    47,   659,   530,  1198,   531,
     532,   533,   534,   122,   365,  1159,   821,   506,   408,   227,
      80,    80,  1210,  1164,   369,   370,   371,   372,   373,  1166,
    1216,  1168,   829,  -299,  1173,    80,   506,   829,   829,  1017,
    1231,  1232,  1042,   594,  1177,   122,  1178,  1202,  1224,   220,
      91,   227,   634,  1240,  1229,   635,   464,  1249,   764,   122,
      80,    80,  1251,   506,    80,    91,   974,   740,  1241,    80,
     512,  1256,   508,   509,  1258,  1262,   530,  1017,   531,   532,
     533,   534,   535,  1266,   829,  1277,   837,   837,   837,   721,
     122,   508,   509,  1193,  -752,   531,   532,   533,   534,  1264,
    1149,   536,   383,   383,  -753,   474,   704,  1001,  1003,   706,
    1034,   393,  1017,  1163,  1008,  1010,   726,   410,   508,   509,
     376,  1082,   829,   936,   877,   538,   912,  1263,  1082,   799,
    1082,   539,   540,   541,   799,   799,   907,   530,   278,   531,
     532,   533,   534,   689,   978,  1049,   979,   980,   691,   981,
     948,   693,  1158,  1071,   695,   542,  1070,  1001,  1003,  1265,
    1008,  1010,   946,  1070,  1238,  1070,  1036,   543,    91,   705,
    1274,   774,  1103,  1076,   707,    91,    91,  1106,  1076,    80,
    1076,   799,  1076,  1107,  1100,  1248,   731,  1154,   430,   727,
      91,   423,   732,   982,   919,  1212,   821,   821,  1218,  1175,
     821,  1214,    80,     0,    80,    80,     0,   917,    80,     0,
      80,  1082,   885,  1082,    80,   837,    80,   821,  1082,   799,
    1082,     0,    91,     0,   227,   227,     0,   102,     0,   102,
       0,    80,     0,     0,     0,   741,    91,     0,     0,  1082,
     893,   102,   102,  1167,  1169,   227,  1070,     0,  1070,    41,
      42,    43,    44,  1070,   530,  1070,   531,   532,   533,   534,
       0,     0,     0,  1076,     0,  1076,     0,    91,     0,     0,
    1076,   778,  1076,     0,  1070,     0,     0,     0,   102,   102,
    1121,     0,     0,    80,    80,    80,    80,    80,    80,    80,
      80,  1076,   434,   102,    80,   436,   437,   438,    80,     0,
       0,     0,     0,   731,     0,     0,     0,     0,    80,     0,
      80,  1121,     0,    80,     0,     0,   822,     0,   102,   102,
       0,   972,   102,   823,     0,     0,     0,   102,     0,     0,
     822,     0,     0,     0,     0,     0,     0,   823,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    80,     0,    80,
       0,     0,     0,    80,    80,    80,     0,   125,     0,   125,
       0,     0,     0,   922,     0,     0,   926,     0,     0,    80,
       0,   821,     0,     0,   821,     0,     0,  1250,  1252,     0,
       0,     0,     0,  1257,     0,  1259,  1260,     0,     0,     0,
    1026,   821,   821,   821,     0,     0,   821,   821,    80,    80,
    1031,   821,   821,     0,     0,     0,     0,     0,   125,   125,
       0,     0,   293,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,   578,   910,   821,     0,     0,   591,     0,
       0,     0,  1276,  1278,  1279,  1280,     0,   102,     0,     0,
     293,     0,     0,     0,  1282,     0,     0,     0,     0,     0,
      80,     0,     0,   399,   409,   409,     0,     0,     0,     0,
     102,     0,   102,   102,     0,     0,   102,     0,   102,     0,
      80,     0,   102,     0,   102,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1087,     0,     0,     0,   102,
       0,     0,     0,     0,  1089,     0,     0,  1093,     0,     0,
       0,     0,   530,     0,   531,   532,   533,   534,   535,     0,
     822,   822,     0,     0,   822,     0,     0,   823,   823,     0,
    1111,   823,     0,     0,     0,   678,   680,   536,     0,     0,
       0,   822,    80,     0,   278,     0,    80,     0,   823,     0,
       0,   102,   102,   102,   102,   102,   102,   102,   102,     0,
       0,   538,   102,     0,  1075,     0,   102,   539,   540,   541,
       0,     0,     0,     0,  1033,     0,   102,   125,   102,     0,
     680,   102,     0,   278,     0,     0,     0,  1038,   821,  1040,
       0,   542,     0,   821,   821,     0,     0,     0,     0,     0,
     242,     0,     0,   543,     0,     0,  1047,     0,     0,     0,
       0,     0,   125,     0,   125,   102,    80,   102,    80,     0,
       0,   102,   102,   102,     0,     0,    80,     0,     0,   125,
       0,     0,     0,     0,     0,     0,    80,   102,    80,    80,
     821,     0,     0,     0,     0,   746,     0,     0,     0,   293,
       0,     0,     0,  1182,  1183,  1184,     0,   530,     0,   531,
     532,   533,   534,   535,     0,     0,   102,   102,   775,     0,
       0,     0,     0,  1143,    80,  1145,     0,     0,   821,     0,
    1146,   125,   536,   102,     0,     0,   125,     0,     0,     0,
       0,     0,   125,  1112,     0,   822,   125,     0,   822,     0,
       0,     0,   823,     0,     0,   823,   538,     0,   125,   293,
       0,   595,   348,   540,   541,   822,   822,   822,   102,     0,
     822,   822,   823,   823,   823,   822,   822,   823,   823,   361,
     362,     0,   823,   823,     0,     0,   542,     0,   102,     0,
       0,     0,     0,     0,     0,     0,     0,   125,     0,   822,
       0,   125,     0,   125,    80,     0,   823,     0,    80,    80,
       0,     0,    80,     0,     0,   364,   365,   880,     0,     0,
     368,   881,     0,     0,     0,     0,   369,   370,   371,   372,
     373,     0,  1268,     0,   680,     0,   278,  1170,  1220,     0,
    1223,     0,     0,     0,     0,     0,   595,   595,     0,     0,
     102,     0,     0,     0,   102,     0,     0,     0,     0,     0,
      80,    80,  1179,  1180,  1181,     0,     0,    80,    80,     0,
       0,     0,     0,     0,  1242,     0,   530,     0,   531,   532,
     533,   534,   535,     0,   913,     0,     0,     0,     0,     0,
       0,     0,     0,    80,     0,    80,    80,     0,   125,     0,
       0,   536,     0,     0,   929,     0,     0,     0,     0,     0,
       0,    23,    24,    25,    26,   537,   293,     0,   951,     0,
       0,  1269,     0,  1271,   102,   538,   102,    32,    33,    34,
    1272,   539,   540,   541,   102,     0,     0,    41,    42,    43,
      44,    45,     0,     0,   102,     0,   102,   102,     0,  1281,
       0,     0,   822,     0,     0,   542,     0,   822,   822,   823,
     716,     0,    80,    80,   823,   823,     0,   543,     0,     0,
      80,     0,     0,     0,   530,    80,   531,   532,   533,   534,
     535,   680,   102,     0,     0,     0,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,   293,   536,
       0,  1023,     0,     0,   822,     0,     0,     0,     0,    80,
       0,   823,     0,   537,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   538,     0,     0,     0,     0,     0,   285,
     540,   541,     0,    80,     0,     0,     0,     0,     0,     0,
      80,    80,   822,     0,     0,     0,     0,     0,     0,   823,
      76,     0,    76,   542,   125,    80,   125,     0,     0,     0,
       0,     0,   102,     0,     0,     0,   102,   102,     0,     0,
     102,     0,     0,  -779,     0,     0,   125,     0,     0,     0,
       0,  -779,  -779,  -779,     0,     0,  -779,  -779,  -779,     0,
    -779,     0,  1086,     0,     0,     0,     0,     0,  -779,  -779,
    -779,    76,    76,     0,     0,   286,     0,     0,     0,     0,
    -779,  -779,     0,  -779,  -779,  -779,  -779,  -779,   102,   102,
       0,     0,     0,     0,   293,   102,   102,     0,     0,     0,
       0,     0,     0,   286,     0,   901,     0,     0,     0,     0,
       0,  -779,     0,     0,     0,     0,   286,   286,   286,     0,
       0,   102,     0,   102,   102,     0,     0,     0,    80,     0,
       0,     0,     0,     0,  1129,    80,    80,     0,     0,  -779,
    -779,     0,   824,     0,     0,     0,  -779,     0,     0,     0,
      80,   278,     0,     0,     0,   530,   824,   531,   532,   533,
     534,   535,   125,  -779,     0,   293,   125,   595,     0,  -779,
    -779,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     536,  -779,    80,  -779,    80,    80,     0,     0,     0,     0,
     102,   102,     0,     0,   537,     0,    80,     0,   102,     0,
       0,     0,     0,   102,   538,    80,     0,     0,     0,     0,
     539,   540,   541,     0,     0,     0,     0,     0,   595,   595,
       0,     0,     0,     0,     0,   595,   595,    80,     0,     0,
      76,     0,     0,     0,   542,     0,     0,   102,     0,     0,
       0,     0,  1190,     0,     0,     0,   543,     0,     0,     0,
       0,   125,     0,     0,   125,     0,     0,     0,    77,     0,
      77,   102,     0,     0,     0,    76,     0,    76,   102,   102,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   825,    76,   102,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   825,     0,     0,     0,     0,
       0,  1233,   286,     0,     0,     0,     0,     0,     0,    77,
      77,     0,     0,   287,   347,     0,     0,     0,     0,     0,
     125,   125,     0,     0,     0,     0,     0,     0,   125,     0,
       0,     0,     0,   125,    76,     0,   824,   824,     0,    76,
     824,   287,     0,     0,     0,    76,     0,     0,     0,    76,
       0,     0,     0,     0,   287,   287,   287,   824,     0,     0,
       0,    76,   286,     0,    76,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,     0,
       0,     0,     0,   361,   362,     0,   102,     0,     0,   363,
       0,   595,     0,   102,   102,     0,     0,     0,   125,     0,
      76,     0,     0,     0,    76,     0,    76,     0,   102,     0,
       0,     0,     0,   125,     0,     0,     0,     0,     0,   364,
     365,   366,   367,     0,   368,     0,     0,     0,     0,     0,
     369,   370,   371,   372,   373,     0,     0,     0,   374,     0,
     102,     0,   102,   102,     0,     0,     0,     0,  1152,    76,
      76,     0,     0,     0,   102,     0,     0,     0,     0,     0,
       0,   409,     0,   102,     0,     0,     0,     0,    77,     0,
       0,     0,     0,     0,     0,   825,   825,     0,     0,   825,
       0,     0,     0,     0,     0,   102,     0,     0,     0,     0,
       0,     0,     0,   121,     0,   121,   825,     0,     0,     0,
       0,    76,    87,    77,    87,    77,     0,     0,     0,     0,
       0,   824,     0,     0,   824,     0,   125,     0,     0,   286,
      77,     0,     0,   125,   125,     0,     0,     0,     0,     0,
       0,   824,   824,   824,     0,   826,   824,   824,   125,     0,
     287,   824,   824,   409,   121,   121,     0,     0,   291,   826,
       0,     0,     0,    87,    87,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
     125,     0,    77,     0,     0,     0,   291,    77,     0,     0,
       0,     0,     0,    77,   125,     0,     0,    77,     0,   397,
     407,   407,   407,     0,     0,     0,     0,     0,   394,    77,
     287,   286,    77,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   125,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    77,     0,
       0,     0,    77,     0,    77,     0,     0,     0,     0,     0,
     825,     0,     0,   825,     0,     0,     0,    76,     0,    76,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     825,   825,   825,     0,     0,   825,   825,     0,     0,    76,
     825,   825,     0,     0,     0,     0,     0,    77,    77,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   121,   825,     0,     0,     0,     0,     0,
       0,     0,    87,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,   824,   824,     0,     0,   286,     0,   826,
     826,     0,     0,   826,     0,     0,     0,     0,   121,    77,
     121,     0,     0,     0,     0,     0,     0,    87,     0,    87,
     826,     0,     0,     0,   124,   121,   124,   287,     0,     0,
       0,     0,     0,     0,    87,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,   291,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,     0,     0,   286,    76,
      76,     0,     0,     0,     0,   124,   124,   121,   824,     0,
       0,     0,   121,     0,     0,     0,    87,     0,   121,     0,
       0,    87,   121,     0,   827,     0,     0,    87,     0,     0,
       0,    87,     0,     0,   121,   291,     0,     0,   827,   287,
       0,     0,     0,    87,     0,     0,   589,     0,     0,     0,
       0,    76,    76,     0,     0,     0,     0,   825,    76,    76,
       0,     0,   825,   825,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   121,     0,     0,     0,   121,     0,   121,
       0,     0,    87,     0,    76,     0,    87,    76,    87,     0,
       0,     0,     0,     0,     0,    77,     0,    77,     0,     0,
       0,     0,     0,     0,   826,     0,     0,   826,     0,   825,
       0,     0,     0,     0,     0,     0,     0,    77,     0,     0,
       0,     0,     0,     0,   826,   826,   826,     0,     0,   826,
     826,   589,   589,     0,   826,   826,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   825,     0,     0,
       0,     0,     0,    76,    76,     0,     0,     0,   826,     0,
       0,    76,     0,     0,   124,   287,    76,     0,     0,     0,
       0,     0,     0,     0,   121,     0,     0,     0,     0,     0,
       0,     0,     0,    87,     0,     0,     0,     0,     0,     0,
       0,     0,   291,     0,     0,     0,     0,     0,     0,   124,
       0,   124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   827,   827,
       0,     0,   827,     0,    76,     0,     0,     0,     0,     0,
       0,    76,     0,    77,     0,     0,   287,    77,    77,   827,
       0,     0,     0,     0,     0,     0,    76,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
       0,     0,     0,   124,   291,     0,     0,     0,     0,   124,
       0,   286,     0,   124,     0,     0,     0,     0,     0,    77,
      77,     0,     0,     0,   286,   124,    77,    77,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   826,     0,     0,     0,     0,   826,   826,     0,     0,
       0,     0,    77,     0,     0,    77,     0,     0,     0,     0,
     121,     0,   121,     0,   124,     0,     0,     0,   124,    87,
     124,    87,     0,     0,     0,     0,     0,     0,     0,    76,
       0,     0,   121,     0,     0,     0,    76,    76,     0,     0,
       0,    87,     0,   826,     0,     0,     0,     0,     0,     0,
       0,    76,     0,     0,     0,     0,   286,     0,     0,     0,
       0,     0,     0,   124,   124,     0,     0,     0,     0,     0,
       0,    77,    77,   827,     0,     0,   827,     0,     0,    77,
     291,   826,     0,    76,    77,     0,     0,     0,     0,     0,
       0,     0,     0,   827,   827,   827,   783,    76,   827,   827,
       0,     0,     0,   827,   827,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   827,    76,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    77,     0,     0,     0,   361,   362,   121,    77,
       0,   291,   121,   828,     0,     0,     0,    87,     0,     0,
       0,    87,   589,     0,    77,     0,     0,   828,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -268,     0,     0,
       0,     0,   364,   365,   366,   367,     0,   368,     0,     0,
       0,     0,     0,   369,   370,   371,   372,   373,     0,   287,
       0,   374,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   287,   589,   589,     0,     0,     0,     0,     0,
     589,   589,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,     0,
     121,     0,     0,     0,     0,     0,    87,     0,     0,    87,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    77,     0,     0,
       0,   124,     0,   124,    77,    77,     0,     0,     0,     0,
     827,     0,     0,     0,     0,   827,   827,     0,     0,    77,
       0,     0,     0,   124,   287,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   121,   121,     0,     0,
       0,     0,     0,     0,   121,    87,    87,     0,     0,   121,
       0,    77,     0,    87,     0,     0,     0,     0,    87,     0,
       0,     0,   827,     0,     0,    77,     0,     0,     0,     0,
     222,   222,     0,     0,     0,     0,     0,   828,   828,     0,
       0,   828,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    77,     0,   828,     0,
     827,     0,   255,   258,   259,   260,     0,     0,     0,   222,
     222,     0,     0,     0,   121,     0,   589,     0,     0,     0,
       0,   308,   310,    87,     0,     0,     0,     0,     0,   121,
       0,     0,     0,     0,     0,     0,     0,     0,    87,   124,
       0,     0,     0,   124,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   348,  -780,  -780,
    -780,  -780,   353,   354,  1150,     0,  -780,  -780,     0,     0,
       0,     0,     0,  1148,   361,   362,     0,   407,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   124,   124,     0,     0,     0,
       0,     0,   124,   124,     0,     0,     0,     0,     0,     0,
     364,   365,   366,   367,     0,   368,     0,     0,     0,     0,
       0,   369,   370,   371,   372,   373,     0,     0,   124,     0,
       0,   124,   121,     0,     0,     0,     0,     0,     0,   121,
     121,    87,     0,     0,     0,     0,     0,     0,    87,    87,
       0,     0,   828,     0,   121,   828,     0,     0,     0,   407,
       0,     0,     0,    87,   222,     0,     0,   222,   222,   222,
       0,   310,   828,   828,   828,     0,     0,   828,   828,     0,
       0,     0,   828,   828,     0,     0,   121,     0,     0,   222,
       0,   222,   222,     0,     0,    87,     0,   124,   124,     0,
     121,     0,     0,     0,     0,   124,   828,     0,     0,    87,
     124,     0,     0,     0,     0,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,     0,
       0,   121,     0,   361,   362,     0,     0,     0,     0,     0,
      87,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   124,   364,
     365,   366,   367,     0,   368,   124,     0,     0,     0,   242,
     369,   370,   371,   372,   373,     0,     0,     0,   374,     0,
     124,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     590,     0,   597,   598,   599,   600,   601,     0,     0,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   611,   612,
       0,     0,   613,   614,   615,   616,   617,   618,   619,   620,
     621,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   828,
       0,     0,     0,     0,   828,   828,     0,     0,     0,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,  -780,  -780,     0,     0,   670,   670,   361,   362,     0,
       0,     0,     0,   124,     0,     0,   670,   222,   222,     0,
     124,   124,   222,     0,   670,   670,   222,     0,     0,     0,
       0,   828,   260,     0,     0,   124,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,   367,   698,   368,     0,
       0,     0,   670,     0,   369,   370,   371,   372,   373,     0,
       0,     0,   222,     0,     0,   222,     0,   124,     0,   828,
       0,     0,     0,     0,     0,     0,  -756,   222,     0,     0,
       0,   124,     0,     0,  -756,  -756,  -756,     0,     0,  -756,
    -756,  -756,     0,  -756,   730,     0,     0,     0,     0,     0,
       0,  -756,  -756,  -756,  -756,  -756,     0,     0,     0,     0,
       0,     0,   124,  -756,  -756,     0,  -756,  -756,  -756,  -756,
    -756,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   758,
       0,     0,     0,   767,  -756,     0,     0,     0,     0,     0,
     222,     0,     0,  -756,  -756,  -756,  -756,  -756,  -756,  -756,
    -756,  -756,  -756,  -756,  -756,  -756,     0,     0,     0,     0,
    -756,  -756,  -756,  -756,     0,   883,  -756,     0,     0,  -756,
       0,     0,  -756,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -756,     0,     0,  -756,
       0,  -756,  -756,  -756,  -756,  -123,  -756,  -756,  -756,  -756,
       0,  -756,     0,  -756,  -756,     0,  -756,  -756,  -756,  -756,
    -756,  -756,     0,   222,     0,  -756,  -756,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
     758,   767,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -779,     4,
       0,     5,     6,     7,     8,     9,     0,     0,     0,    10,
      11,     0,     0,     0,    12,     0,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,   222,    27,     0,     0,
       0,     0,     0,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,   222,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
     222,     0,     0,    48,    49,     0,   670,   955,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,    52,     0,     0,    53,
      54,     0,    55,    56,     0,    57,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   670,   670,     0,
       0,     0,     0,   222,   670,   670,  -779,     0,  -779,     0,
       0,     0,     0,     0,    67,    68,     0,     0,     0,    69,
       0,     0,     0,   222,     0,     5,     6,     7,     8,     9,
       0,     0,     0,    10,    11,     0,     0,     0,    12,     0,
      13,    14,    15,    16,    17,    18,    19,   670,   670,     0,
     670,   670,    20,    21,    22,    23,    24,    25,    26,     0,
       0,    27,     0,     0,     0,     0,     0,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,  1061,  1062,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,  1068,  1069,     0,     0,     0,     0,     0,
       0,     0,    50,    51,   222,     0,     0,     0,     0,     0,
      52,     0,     0,    53,    54,     0,    55,    56,     0,    57,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     521,     0,     0,  1119,     0,     0,     0,     0,    67,    68,
     670,     0,     0,    69,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   670,   262,   222,     5,     6,     7,     8,     9,  -779,
    -779,  -779,    10,    11,     0,     0,  -779,    12,     0,    13,
      14,    15,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,    29,   263,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,   348,
     349,   350,   351,   352,   353,   354,    48,    49,   357,   358,
       0,     0,     0,     0,     0,     0,   361,   362,     0,     0,
       0,    50,    51,     0,   222,     0,     0,     0,     0,    52,
       0,     0,    53,    54,     0,    55,    56,     0,    57,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,   364,   365,   366,   367,     0,   368,     0,     0,
       0,     0,     0,   369,   370,   371,   372,   373,     0,  -779,
       0,  -779,     0,     0,     0,     0,     0,    67,    68,     0,
       0,     0,    69,   222,     0,     0,   262,     0,     5,     6,
       7,     8,     9,     0,     0,  -779,    10,    11,     0,  -779,
    -779,    12,   222,    13,    14,    15,    16,    17,    18,    19,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
      28,    29,   263,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,    52,     0,     0,    53,    54,     0,    55,
      56,     0,    57,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -779,   262,  -779,     5,     6,     7,     8,
       9,    67,    68,  -779,    10,    11,    69,     0,  -779,    12,
    -779,    13,    14,    15,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,    28,    29,
     263,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,    52,     0,     0,    53,    54,     0,    55,    56,     0,
      57,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -779,   262,  -779,     5,     6,     7,     8,     9,    67,
      68,  -779,    10,    11,    69,     0,  -779,    12,     0,    13,
      14,    15,    16,    17,    18,    19,  -779,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      27,     0,     0,     0,     0,     0,    28,    29,   263,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,    52,
       0,     0,    53,    54,     0,    55,    56,     0,    57,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -779,
     262,  -779,     5,     6,     7,     8,     9,    67,    68,  -779,
      10,    11,    69,     0,  -779,    12,     0,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,    28,    29,   263,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,    52,     0,     0,
      53,    54,     0,    55,    56,     0,    57,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -779,     0,  -779,
       0,     0,     0,     0,     0,    67,    68,     0,     0,   262,
      69,     5,     6,     7,     8,     9,     0,  -779,  -779,    10,
      11,     0,     0,     0,    12,     0,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,     0,    27,     0,     0,
       0,     0,     0,    28,    29,   263,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,     0,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,    52,     0,     0,    53,
      54,     0,    55,    56,     0,    57,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -779,   262,  -779,     5,
       6,     7,     8,     9,    67,    68,     0,    10,    11,    69,
       0,     0,    12,     0,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,    27,     0,     0,     0,     0,
       0,    28,    29,   263,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,    52,     0,     0,   264,    54,  -779,
      55,    56,     0,    57,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -779,   262,  -779,     5,     6,     7,
       8,     9,    67,    68,     0,    10,    11,    69,     0,     0,
      12,     0,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    27,     0,     0,     0,     0,     0,    28,
      29,   263,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,    52,     0,     0,    53,    54,  -779,    55,    56,
       0,    57,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -779,     4,  -779,     5,     6,     7,     8,     9,
      67,    68,     0,    10,    11,    69,     0,     0,    12,     0,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,    25,    26,     0,
       0,    27,     0,     0,     0,     0,     0,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
      52,     0,     0,    53,    54,     0,    55,    56,     0,    57,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,  -779,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -779,   262,  -779,     5,     6,     7,     8,     9,    67,    68,
       0,    10,    11,    69,     0,     0,    12,     0,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,    28,    29,   263,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,     0,     0,     0,     0,     0,     0,    52,     0,
       0,    53,    54,     0,    55,    56,     0,    57,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,  -779,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -779,   262,
    -779,     5,     6,     7,     8,     9,    67,    68,  -779,    10,
      11,    69,     0,     0,    12,     0,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,    25,    26,     0,     0,    27,     0,     0,
       0,     0,     0,    28,    29,   263,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,     0,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,    52,     0,     0,    53,
      54,     0,    55,    56,     0,    57,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -779,   262,  -779,     5,
       6,     7,     8,     9,    67,    68,     0,    10,    11,    69,
       0,     0,    12,     0,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,    27,     0,     0,     0,     0,
       0,    28,    29,   263,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,    52,     0,     0,    53,    54,     0,
      55,    56,     0,    57,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,  -779,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -646,     0,     0,  -779,     0,  -779,     0,     0,  -646,
    -646,  -646,    67,    68,  -646,  -646,  -646,    69,  -646,     0,
       0,     0,     0,     0,     0,     0,  -646,     0,  -646,  -646,
    -646,     0,     0,     0,     0,     0,     0,     0,  -646,  -646,
       0,  -646,  -646,  -646,  -646,  -646,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -646,
       0,     0,     0,     0,     0,     0,     0,     0,  -646,  -646,
    -646,  -646,  -646,  -646,  -646,  -646,  -646,  -646,  -646,  -646,
    -646,     0,     0,     0,     0,  -646,  -646,  -646,  -646,     0,
    -646,  -646,     0,     0,  -646,     0,     0,  -646,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -646,     0,     0,  -646,     0,  -646,     0,  -646,  -646,
    -646,  -646,  -646,  -646,  -646,     0,  -646,     0,  -646,  -646,
       0,  -646,  -646,  -646,  -646,  -646,  -646,  -649,     0,     0,
    -646,  -646,     0,     0,     0,  -649,  -649,  -649,     0,     0,
    -649,  -649,  -649,     0,  -649,     0,     0,     0,     0,     0,
       0,     0,  -649,     0,  -649,  -649,  -649,     0,     0,     0,
       0,     0,     0,     0,  -649,  -649,     0,  -649,  -649,  -649,
    -649,  -649,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -649,     0,     0,     0,     0,
       0,     0,     0,     0,  -649,  -649,  -649,  -649,  -649,  -649,
    -649,  -649,  -649,  -649,  -649,  -649,  -649,     0,     0,     0,
       0,  -649,  -649,  -649,  -649,     0,  -649,  -649,     0,     0,
    -649,     0,     0,  -649,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -649,     0,     0,
    -649,     0,  -649,     0,  -649,  -649,  -649,  -649,  -649,  -649,
    -649,     0,  -649,     0,  -649,  -649,     0,  -649,  -649,  -649,
    -649,  -649,  -649,  -757,     0,     0,  -649,  -649,     0,     0,
       0,  -757,  -757,  -757,     0,     0,  -757,  -757,  -757,     0,
    -757,     0,     0,     0,     0,     0,     0,     0,  -757,  -757,
    -757,  -757,  -757,     0,     0,     0,     0,     0,     0,     0,
    -757,  -757,     0,  -757,  -757,  -757,  -757,  -757,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -757,     0,     0,     0,     0,     0,     0,     0,     0,
    -757,  -757,  -757,  -757,  -757,  -757,  -757,  -757,  -757,  -757,
    -757,  -757,  -757,     0,     0,     0,     0,  -757,  -757,  -757,
    -757,     0,     0,  -757,     0,     0,  -757,     0,     0,  -757,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -757,     0,     0,  -757,     0,  -757,  -757,
    -757,  -757,     0,  -757,  -757,  -757,  -757,     0,  -757,     0,
    -757,  -757,     0,  -757,  -757,  -757,  -757,  -757,  -757,  -758,
       0,     0,  -757,  -757,     0,     0,     0,  -758,  -758,  -758,
       0,     0,  -758,  -758,  -758,     0,  -758,     0,     0,     0,
       0,     0,     0,     0,  -758,  -758,  -758,  -758,  -758,     0,
       0,     0,     0,     0,     0,     0,  -758,  -758,     0,  -758,
    -758,  -758,  -758,  -758,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -758,     0,     0,
       0,     0,     0,     0,     0,     0,  -758,  -758,  -758,  -758,
    -758,  -758,  -758,  -758,  -758,  -758,  -758,  -758,  -758,     0,
       0,     0,     0,  -758,  -758,  -758,  -758,     0,     0,  -758,
       0,     0,  -758,     0,     0,  -758,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -758,
       0,     0,  -758,     0,  -758,  -758,  -758,  -758,     0,  -758,
    -758,  -758,  -758,     0,  -758,     0,  -758,  -758,     0,  -758,
    -758,  -758,  -758,  -758,  -758,  -323,     0,     0,  -758,  -758,
       0,     0,     0,  -323,  -323,  -323,     0,     0,  -323,  -323,
    -323,     0,  -323,     0,     0,     0,     0,     0,     0,     0,
    -323,     0,  -323,  -323,  -323,     0,     0,     0,     0,     0,
       0,     0,  -323,  -323,     0,  -323,  -323,  -323,  -323,  -323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -323,     0,     0,     0,     0,     0,     0,
       0,     0,  -323,  -323,  -323,  -323,  -323,  -323,  -323,  -323,
    -323,  -323,  -323,  -323,  -323,     0,     0,     0,     0,  -323,
    -323,  -323,  -323,     0,   884,  -323,     0,     0,  -323,     0,
       0,  -323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -323,     0,     0,  -323,     0,
    -323,     0,  -323,  -323,  -125,  -323,  -323,  -323,  -323,     0,
    -323,     0,  -323,  -323,     0,  -323,  -323,  -323,  -323,  -323,
    -323,  -315,     0,     0,  -323,  -323,     0,     0,     0,  -315,
    -315,  -315,     0,     0,  -315,  -315,  -315,     0,  -315,     0,
       0,     0,     0,     0,     0,     0,  -315,     0,  -315,  -315,
    -315,     0,     0,     0,     0,     0,     0,     0,  -315,  -315,
       0,  -315,  -315,  -315,  -315,  -315,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -315,
       0,     0,     0,     0,     0,     0,     0,     0,  -315,  -315,
    -315,  -315,  -315,  -315,  -315,  -315,  -315,  -315,  -315,  -315,
    -315,     0,     0,     0,     0,  -315,  -315,  -315,  -315,     0,
       0,  -315,     0,     0,  -315,     0,     0,  -315,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -315,     0,     0,  -315,     0,  -315,     0,  -315,  -315,
       0,  -315,  -315,  -315,  -315,     0,  -315,     0,  -315,  -315,
       0,  -315,  -315,  -315,  -315,  -315,  -315,  -462,     0,     0,
    -315,  -315,     0,     0,     0,  -462,  -462,  -462,     0,     0,
    -462,  -462,  -462,     0,  -462,     0,     0,     0,     0,     0,
       0,     0,  -462,  -462,  -462,  -462,     0,     0,     0,     0,
       0,     0,     0,     0,  -462,  -462,     0,  -462,  -462,  -462,
    -462,  -462,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -462,     0,     0,     0,     0,
       0,     0,     0,     0,  -462,  -462,  -462,  -462,  -462,  -462,
    -462,  -462,  -462,  -462,  -462,  -462,  -462,     0,     0,     0,
       0,  -462,  -462,  -462,  -462,     0,     0,  -462,     0,     0,
    -462,     0,     0,  -462,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -462,     0,     0,
       0,     0,  -462,  -462,  -462,  -462,     0,  -462,  -462,  -462,
    -462,     0,  -462,   238,  -462,  -462,     0,  -462,  -462,  -462,
    -462,  -462,  -462,  -779,     0,     0,  -462,     0,     0,     0,
       0,  -779,  -779,  -779,     0,     0,  -779,  -779,  -779,     0,
    -779,     0,     0,     0,     0,     0,     0,     0,  -779,  -779,
    -779,  -779,     0,     0,     0,     0,     0,     0,     0,     0,
    -779,  -779,     0,  -779,  -779,  -779,  -779,  -779,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -779,     0,     0,     0,     0,     0,     0,     0,     0,
    -779,  -779,  -779,  -779,  -779,  -779,  -779,  -779,  -779,  -779,
    -779,  -779,  -779,     0,     0,     0,     0,  -779,  -779,  -779,
    -779,     0,     0,  -779,     0,     0,  -779,     0,     0,  -779,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -779,     0,     0,     0,     0,  -779,  -779,
    -779,  -779,     0,  -779,  -779,  -779,  -779,     0,  -779,   238,
    -779,  -779,     0,  -779,  -779,  -779,  -779,  -779,  -779,  -330,
       0,     0,  -779,     0,     0,     0,     0,  -330,  -330,  -330,
       0,     0,  -330,  -330,  -330,     0,  -330,     0,     0,     0,
       0,     0,     0,     0,  -330,     0,  -330,  -330,     0,     0,
       0,     0,     0,     0,     0,     0,  -330,  -330,     0,  -330,
    -330,  -330,  -330,  -330,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -330,     0,     0,
       0,     0,     0,     0,     0,     0,  -330,  -330,  -330,  -330,
    -330,  -330,  -330,  -330,  -330,  -330,  -330,  -330,  -330,     0,
       0,     0,     0,  -330,  -330,  -330,  -330,     0,     0,  -330,
       0,     0,  -330,     0,     0,  -330,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -330,
       0,     0,     0,     0,  -330,     0,  -330,  -330,     0,  -330,
    -330,  -330,  -330,     0,  -330,   235,  -330,  -330,     0,  -330,
    -330,  -330,  -330,  -330,  -330,  -756,     0,     0,  -330,     0,
       0,     0,     0,  -756,  -756,  -756,     0,     0,     0,  -756,
    -756,     0,  -756,     0,     0,     0,     0,     0,     0,     0,
    -756,  -756,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -756,  -756,     0,  -756,  -756,  -756,  -756,  -756,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -756,     0,     0,     0,     0,     0,     0,
       0,     0,  -756,  -756,  -756,  -756,  -756,  -756,  -756,  -756,
    -756,  -756,  -756,  -756,  -756,     0,     0,     0,     0,  -756,
    -756,  -756,  -756,     0,   833,  -756,     0,     0,  -756,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -756,     0,     0,     0,     0,
    -114,  -756,  -756,  -756,  -123,  -756,  -756,  -756,  -756,     0,
    -756,     0,     0,  -756,     0,  -756,  -756,  -756,  -756,  -756,
    -756,  -756,     0,     0,  -756,     0,     0,     0,     0,  -756,
    -756,  -756,     0,     0,     0,  -756,  -756,     0,  -756,     0,
       0,     0,     0,     0,     0,     0,  -756,  -756,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -756,  -756,
       0,  -756,  -756,  -756,  -756,  -756,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -756,
       0,     0,     0,     0,     0,     0,     0,     0,  -756,  -756,
    -756,  -756,  -756,  -756,  -756,  -756,  -756,  -756,  -756,  -756,
    -756,     0,     0,     0,     0,  -756,  -756,  -756,  -756,     0,
     833,  -756,     0,     0,  -756,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -756,     0,     0,     0,     0,  -756,  -756,  -756,  -756,
    -123,  -756,  -756,  -756,  -756,     0,  -756,     0,     0,  -756,
       0,  -756,  -756,  -756,  -756,  -756,  -756,  -323,     0,     0,
    -756,     0,     0,     0,     0,  -323,  -323,  -323,     0,     0,
       0,  -323,  -323,     0,  -323,     0,     0,     0,     0,     0,
       0,     0,  -323,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -323,  -323,     0,  -323,  -323,  -323,
    -323,  -323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -323,     0,     0,     0,     0,
       0,     0,     0,     0,  -323,  -323,  -323,  -323,  -323,  -323,
    -323,  -323,  -323,  -323,  -323,  -323,  -323,     0,     0,     0,
       0,  -323,  -323,  -323,  -323,     0,   834,  -323,     0,     0,
    -323,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -323,     0,     0,
       0,     0,  -116,     0,  -323,  -323,  -125,  -323,  -323,  -323,
    -323,     0,  -323,     0,     0,  -323,     0,  -323,  -323,  -323,
    -323,  -323,  -323,  -323,     0,     0,  -323,     0,     0,     0,
       0,  -323,  -323,  -323,     0,     0,     0,  -323,  -323,     0,
    -323,     0,     0,     0,     0,     0,     0,     0,  -323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -323,  -323,     0,  -323,  -323,  -323,  -323,  -323,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -323,     0,     0,     0,     0,     0,     0,     0,     0,
    -323,  -323,  -323,  -323,  -323,  -323,  -323,  -323,  -323,  -323,
    -323,  -323,  -323,     0,     0,     0,     0,  -323,  -323,  -323,
    -323,     0,   834,  -323,     0,     0,  -323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -323,     0,     0,     0,     0,  -323,     0,
    -323,  -323,  -125,  -323,  -323,  -323,  -323,     0,  -323,     0,
       0,  -323,     0,  -323,  -323,  -323,  -323,  -323,  -323,     0,
       0,     0,  -323,     5,     6,     7,     8,     9,     0,     0,
       0,    10,    11,     0,     0,     0,    12,     0,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,    28,    29,   263,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,     0,     0,     0,     0,     0,     0,    52,     0,
       0,    53,    54,     0,    55,    56,     0,    57,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   521,     0,
       5,     6,     7,     8,     9,     0,    67,    68,    10,    11,
       0,    69,     0,    12,     0,    13,    14,    15,    16,    17,
      18,    19,     0,     0,     0,     0,     0,    20,    21,    22,
      23,    24,    25,    26,     0,     0,    27,     0,     0,     0,
       0,     0,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,    52,     0,     0,    53,    54,
       0,    55,    56,     0,    57,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,    67,    68,    10,    11,     0,    69,     0,
      12,     0,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,    20,    21,    22,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   210,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   212,    54,     0,    55,    56,
       0,   213,   214,   215,    58,    59,   216,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   242,     5,     6,     7,     0,     9,
      67,   217,     0,    10,    11,    69,     0,     0,    12,     0,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
     210,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   212,    54,     0,    55,    56,     0,   213,
     214,   215,    58,    59,   216,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     6,     7,     8,     9,     0,    67,   217,
      10,    11,     0,    69,     0,    12,     0,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,     0,     0,    20,
      21,    22,    23,    24,    25,    26,     0,     0,    27,     0,
       0,     0,     0,     0,    28,    29,     0,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,    52,     0,     0,
      53,    54,     0,    55,    56,     0,    57,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     0,     9,     0,    67,    68,    10,    11,     0,
      69,     0,    12,     0,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,    20,    21,    22,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,   210,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,   458,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   212,    54,     0,
      55,    56,     0,   213,   214,   215,    58,    59,   216,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     0,
       9,     0,    67,   217,    10,    11,     0,    69,     0,    12,
       0,    13,    14,    15,   250,   251,    18,    19,     0,     0,
       0,     0,     0,    20,   252,   253,    23,    24,    25,    26,
       0,     0,   209,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,   210,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   212,    54,     0,    55,    56,     0,
     679,   214,   215,    58,    59,   216,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     0,     9,     0,    67,
     217,    10,    11,     0,    69,     0,    12,     0,    13,    14,
      15,   250,   251,    18,    19,     0,     0,     0,     0,     0,
      20,   252,   253,    23,    24,    25,    26,     0,     0,   209,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    32,
      33,    34,    35,    36,    37,    38,    39,    40,   210,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,   458,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   212,    54,     0,    55,    56,     0,   679,   214,   215,
      58,    59,   216,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     6,     7,     0,     9,     0,    67,   217,    10,    11,
       0,    69,     0,    12,     0,    13,    14,    15,   250,   251,
      18,    19,     0,     0,     0,     0,     0,    20,   252,   253,
      23,    24,    25,    26,     0,     0,   209,     0,     0,     0,
       0,     0,     0,    29,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,   210,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,    51,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   212,    54,
       0,    55,    56,     0,   213,   214,     0,    58,    59,   216,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,    67,   217,    10,    11,     0,    69,     0,
      12,     0,    13,    14,    15,   250,   251,    18,    19,     0,
       0,     0,     0,     0,    20,   252,   253,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
      29,     0,     0,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   210,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,    51,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   212,    54,     0,    55,    56,
       0,     0,   214,   215,    58,    59,   216,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     6,     7,     0,     9,     0,
      67,   217,    10,    11,     0,    69,     0,    12,     0,    13,
      14,    15,   250,   251,    18,    19,     0,     0,     0,     0,
       0,    20,   252,   253,    23,    24,    25,    26,     0,     0,
     209,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,   210,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   212,    54,     0,    55,    56,     0,   679,   214,
       0,    58,    59,   216,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     0,     9,     0,    67,   217,    10,
      11,     0,    69,     0,    12,     0,    13,    14,    15,   250,
     251,    18,    19,     0,     0,     0,     0,     0,    20,   252,
     253,    23,    24,    25,    26,     0,     0,   209,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    32,    33,    34,
      35,    36,    37,    38,    39,    40,   210,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   212,
      54,     0,    55,    56,     0,     0,   214,     0,    58,    59,
     216,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     6,
       7,     0,     9,     0,    67,   217,    10,    11,     0,    69,
       0,    12,     0,    13,    14,    15,    16,    17,    18,    19,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
      25,    26,     0,     0,    27,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   212,    54,     0,    55,
      56,     0,     0,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   312,     0,   313,     5,     6,     7,     0,
       9,    67,    68,     0,    10,    11,    69,     0,     0,    12,
       0,    13,    14,    15,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,    27,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   212,    54,     0,    55,    56,     0,
       0,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   242,     5,     6,     7,     0,     9,    67,
      68,     0,    10,    11,    69,     0,     0,    12,     0,    13,
      14,    15,    16,    17,    18,    19,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,    25,    26,     0,     0,
     209,     0,     0,     0,     0,     0,     0,    29,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,    51,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   212,    54,     0,    55,    56,     0,   576,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     7,     0,     9,     0,    67,   217,    10,
      11,     0,    69,     0,    12,     0,    13,    14,    15,   250,
     251,    18,    19,     0,     0,     0,     0,     0,    20,   252,
     253,    23,    24,    25,    26,     0,     0,   209,     0,     0,
       0,     0,     0,     0,    29,     0,     0,    32,    33,    34,
      35,    36,    37,    38,    39,    40,     0,    41,    42,    43,
      44,    45,    46,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,    51,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   212,
      54,     0,    55,    56,     0,   576,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     6,
       7,     0,     9,     0,    67,   217,    10,    11,     0,    69,
       0,    12,     0,    13,    14,    15,   250,   251,    18,    19,
       0,     0,     0,     0,     0,    20,   252,   253,    23,    24,
      25,    26,     0,     0,   209,     0,     0,     0,     0,     0,
       0,    29,     0,     0,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,    51,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   212,    54,     0,    55,
      56,     0,   950,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     0,     9,
       0,    67,   217,    10,    11,     0,    69,     0,    12,     0,
      13,    14,    15,   250,   251,    18,    19,     0,     0,     0,
       0,     0,    20,   252,   253,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,    29,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    51,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   212,    54,     0,    55,    56,     0,  1022,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     6,     7,     0,     9,     0,    67,   217,
      10,    11,     0,    69,     0,    12,     0,    13,    14,    15,
     250,   251,    18,    19,     0,     0,     0,     0,     0,    20,
     252,   253,    23,    24,    25,    26,     0,     0,   209,     0,
       0,     0,     0,     0,     0,    29,     0,     0,    32,    33,
      34,    35,    36,    37,    38,    39,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
      51,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     212,    54,     0,    55,    56,     0,  1189,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     0,     9,     0,    67,   217,    10,    11,     0,
      69,     0,    12,     0,    13,    14,    15,   250,   251,    18,
      19,     0,     0,     0,     0,     0,    20,   252,   253,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,    29,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,    51,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   212,    54,     0,
      55,    56,     0,     0,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     0,
       9,     0,    67,   217,    10,    11,     0,    69,     0,    12,
       0,    13,    14,    15,    16,    17,    18,    19,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,    25,    26,
       0,     0,   209,     0,     0,     0,     0,     0,     0,    29,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,    51,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   212,    54,     0,    55,    56,     0,
       0,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     6,     7,     0,     9,     0,    67,
     217,    10,    11,     0,    69,     0,    12,     0,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
      20,    21,    22,    23,    24,    25,    26,     0,     0,    27,
       0,     0,     0,     0,     0,     0,    29,     0,     0,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,    51,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   212,    54,     0,    55,    56,     0,     0,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     6,     7,     0,     9,     0,    67,    68,    10,    11,
       0,    69,     0,    12,     0,    13,    14,    15,   250,   251,
      18,    19,     0,     0,     0,     0,     0,    20,   252,   253,
      23,    24,    25,    26,     0,     0,   209,     0,     0,     0,
       0,     0,     0,   282,     0,     0,    32,    33,    34,    35,
      36,    37,    38,    39,    40,     0,    41,    42,    43,    44,
      45,    46,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   283,     0,     0,   212,    54,
       0,    55,    56,     0,     0,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,     0,     0,     0,
       0,     0,   284,     5,     6,     7,     0,     9,     0,     0,
       0,    10,    11,     0,     0,     0,    12,     0,    13,    14,
      15,   250,   251,    18,    19,     0,     0,     0,   285,     0,
      20,   252,   253,    23,    24,    25,    26,     0,     0,   209,
       0,     0,     0,     0,     0,     0,   282,     0,     0,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     0,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   283,     0,
       0,   343,    54,     0,    55,    56,     0,   344,     0,     0,
      58,    59,    60,    61,    62,    63,    64,    65,    66,     0,
       0,     0,     0,     0,     0,     5,     6,     7,     0,     9,
       0,     0,     0,    10,    11,     0,     0,     0,    12,     0,
      13,    14,    15,   250,   251,    18,    19,     0,     0,     0,
       0,   285,    20,   252,   253,    23,    24,    25,    26,     0,
       0,   209,     0,     0,     0,     0,     0,     0,   282,     0,
       0,    32,    33,    34,    35,    36,    37,    38,    39,    40,
       0,    41,    42,    43,    44,    45,    46,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     392,     0,     0,    53,    54,     0,    55,    56,     0,    57,
       0,     0,    58,    59,    60,    61,    62,    63,    64,    65,
      66,     0,     0,     0,     0,     0,     0,     5,     6,     7,
       0,     9,     0,     0,     0,    10,    11,     0,     0,     0,
      12,     0,    13,    14,    15,   250,   251,    18,    19,     0,
       0,     0,     0,   285,    20,   252,   253,    23,    24,    25,
      26,     0,     0,   209,     0,     0,     0,     0,     0,     0,
     282,     0,     0,    32,    33,    34,   400,    36,    37,    38,
     401,    40,     0,    41,    42,    43,    44,    45,    46,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   402,     0,
       0,     0,   403,     0,     0,   212,    54,     0,    55,    56,
       0,     0,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,     0,     0,     0,     0,     0,     5,
       6,     7,     0,     9,     0,     0,     0,    10,    11,     0,
       0,     0,    12,     0,    13,    14,    15,   250,   251,    18,
      19,     0,     0,     0,     0,   285,    20,   252,   253,    23,
      24,    25,    26,     0,     0,   209,     0,     0,     0,     0,
       0,     0,   282,     0,     0,    32,    33,    34,    35,    36,
      37,    38,    39,    40,     0,    41,    42,    43,    44,    45,
      46,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   283,     0,     0,   212,    54,     0,
      55,    56,     0,     0,     0,     0,    58,    59,    60,    61,
      62,    63,    64,    65,    66,     0,     0,     0,     0,     0,
       0,   583,     5,     6,     7,     0,     9,     0,     0,     0,
      10,    11,     0,     0,     0,    12,     0,    13,    14,    15,
     250,   251,    18,    19,     0,     0,     0,   285,     0,    20,
     252,   253,    23,    24,    25,    26,     0,     0,   209,     0,
       0,     0,     0,     0,     0,   282,     0,     0,    32,    33,
      34,   400,    36,    37,    38,   401,    40,     0,    41,    42,
      43,    44,    45,    46,    47,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   403,     0,     0,
     212,    54,     0,    55,    56,     0,     0,     0,     0,    58,
      59,    60,    61,    62,    63,    64,    65,    66,     0,     0,
       0,     0,     0,     0,     5,     6,     7,     0,     9,     0,
       0,     0,    10,    11,     0,     0,     0,    12,     0,    13,
      14,    15,   250,   251,    18,    19,     0,     0,     0,     0,
     285,    20,   252,   253,    23,    24,    25,    26,     0,     0,
     209,     0,     0,     0,     0,     0,     0,   282,     0,     0,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     0,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   283,
       0,     0,   343,    54,     0,    55,    56,     0,     0,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,     0,     0,     0,     0,     0,     5,     6,     7,     0,
       9,     0,     0,     0,    10,    11,     0,     0,     0,    12,
       0,    13,    14,    15,   250,   251,    18,    19,     0,     0,
       0,     0,   285,    20,   252,   253,    23,    24,    25,    26,
       0,     0,   209,     0,     0,     0,     0,     0,     0,   282,
       0,     0,    32,    33,    34,    35,    36,    37,    38,    39,
      40,     0,    41,    42,    43,    44,    45,    46,    47,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1147,     0,     0,   212,    54,     0,    55,    56,     0,
       0,     0,     0,    58,    59,    60,    61,    62,    63,    64,
      65,    66,     0,     0,     0,     0,     0,     0,     5,     6,
       7,     0,     9,     0,     0,     0,    10,    11,     0,     0,
       0,    12,     0,    13,    14,    15,   250,   251,    18,    19,
       0,     0,     0,     0,   285,    20,   252,   253,    23,    24,
      25,    26,     0,     0,   209,     0,     0,     0,     0,     0,
       0,   282,     0,     0,    32,    33,    34,    35,    36,    37,
      38,    39,    40,     0,    41,    42,    43,    44,    45,    46,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1162,     0,     0,   212,    54,     0,    55,
      56,     0,     0,     0,     0,    58,    59,    60,    61,    62,
      63,    64,    65,    66,     0,     0,     0,     0,     0,     0,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,     0,     0,   285,   153,   154,   155,
     411,   412,   413,   414,   160,   161,   162,     0,     0,     0,
       0,     0,   163,   164,   165,   166,   415,   416,   417,   418,
     171,    37,    38,   419,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   190,   191,   192,
     193,   194,   195,   420,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,     0,
       0,     0,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,     0,     0,     0,     0,     0,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   295,   296,   172,   297,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   190,   191,   192,   193,   194,   195,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,     0,     0,     0,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,     0,     0,     0,
       0,     0,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   244,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,     0,     0,    59,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   190,   191,   192,
     193,   194,   195,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,     0,
       0,     0,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,     0,     0,     0,     0,     0,   163,   164,   165,
     166,   167,   168,   169,   170,   171,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,    59,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   190,   191,   192,   193,   194,   195,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,     0,     0,     0,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,     0,     0,     0,
       0,     0,   163,   164,   165,   166,   167,   168,   169,   170,
     171,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,    23,    24,    25,    26,     0,     0,     0,
       0,     0,     0,     0,   188,   189,     0,     0,     0,    32,
      33,    34,   787,     0,     0,     0,   788,     0,   789,    41,
      42,    43,    44,    45,     0,     0,     0,   190,   191,   192,
     193,   194,   195,     0,     0,     0,     0,   536,   196,   197,
     198,   199,   200,   201,   202,     0,     0,     0,     0,     0,
     790,   791,     0,     0,     0,     0,     0,     0,   792,     0,
       0,   793,     0,     0,   794,   795,     0,   796,   540,     0,
      58,    59,   797,    61,    62,    63,    64,    65,    66,     0,
      23,    24,    25,    26,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   798,    32,    33,    34,   787,
       0,     0,     0,   788,     0,     0,    41,    42,    43,    44,
      45,   285,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   790,   791,     0,
       0,     0,     0,     0,     0,   792,     0,     0,   793,     0,
       0,   794,   795,     0,   796,     0,     0,    58,    59,    60,
      61,    62,    63,    64,    65,    66,     0,    23,    24,    25,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   798,    32,    33,    34,   787,   242,     0,     0,
     788,     0,     0,    41,    42,    43,    44,    45,   285,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   790,   791,     0,     0,     0,     0,
       0,     0,   792,     0,     0,   793,     0,     0,   794,   795,
       0,  1090,     0,     0,    58,    59,    60,    61,    62,    63,
      64,    65,    66,     0,    23,    24,    25,    26,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   798,
      32,    33,    34,   787,     0,     0,     0,   788,     0,     0,
      41,    42,    43,    44,    45,   285,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   790,   791,     0,     0,     0,     0,     0,     0,   792,
       0,     0,   793,     0,     0,   794,   795,     0,   796,     0,
       0,    58,    59,    60,    61,    62,    63,    64,    65,    66,
       0,    23,    24,    25,    26,     0,     0,     0,     0,     0,
     783,     0,     0,     0,     0,     0,   798,    32,    33,    34,
     787,     0,     0,     0,   788,     0,     0,    41,    42,    43,
      44,    45,   285,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,     0,     0,   790,   791,
     361,   362,     0,     0,     0,     0,   792,     0,     0,   793,
       0,     0,   794,   795,     0,     0,     0,     0,    58,    59,
      60,    61,    62,    63,    64,    65,    66,   928,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,   367,
       0,   368,     0,   798,     0,     0,     0,   369,   370,   371,
     372,   373,   940,     0,     0,   374,     0,     0,     0,   285,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,     0,     0,     0,     0,   361,   362,     0,
       0,     0,     0,     0,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,     0,     0,
       0,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,   367,     0,   368,     0,
       0,     0,     0,     0,   369,   370,   371,   372,   373,     0,
       0,     0,   374,     0,     0,     0,     0,     0,   364,   365,
     366,   367,     0,   368,   622,   623,     0,     0,   624,   369,
     370,   371,   372,   373,     0,     0,     0,   374,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   631,   632,     0,
       0,   633,   190,   191,   192,   193,   194,   195,   238,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     173,   174,   175,   176,   177,   178,   179,   180,   181,     0,
       0,   182,   183,     0,     0,     0,     0,   184,   185,   186,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     683,   623,     0,     0,   684,   190,   191,   192,   193,   194,
     195,   238,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   686,   632,     0,     0,   687,   190,   191,
     192,   193,   194,   195,   238,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   173,   174,   175,   176,
     177,   178,   179,   180,   181,     0,     0,   182,   183,     0,
       0,     0,     0,   184,   185,   186,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   711,   623,     0,     0,
     712,   190,   191,   192,   193,   194,   195,   238,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   173,
     174,   175,   176,   177,   178,   179,   180,   181,     0,     0,
     182,   183,     0,     0,     0,     0,   184,   185,   186,   187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   714,
     632,     0,     0,   715,   190,   191,   192,   193,   194,   195,
     238,     0,     0,     0,     0,   196,   197,   198,   199,   200,
     201,   202,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   861,   623,     0,     0,   862,   190,   191,   192,
     193,   194,   195,   238,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   173,   174,   175,   176,   177,
     178,   179,   180,   181,     0,     0,   182,   183,     0,     0,
       0,     0,   184,   185,   186,   187,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   864,   632,     0,     0,   865,
     190,   191,   192,   193,   194,   195,   238,     0,     0,     0,
       0,   196,   197,   198,   199,   200,   201,   202,   173,   174,
     175,   176,   177,   178,   179,   180,   181,     0,     0,   182,
     183,     0,     0,     0,     0,   184,   185,   186,   187,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   870,   623,
       0,     0,   871,   190,   191,   192,   193,   194,   195,   238,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   173,   174,   175,   176,   177,   178,   179,   180,   181,
       0,     0,   182,   183,     0,     0,     0,     0,   184,   185,
     186,   187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,   632,     0,     0,   667,   190,   191,   192,   193,
     194,   195,   238,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   173,   174,   175,   176,   177,   178,
     179,   180,   181,     0,     0,   182,   183,     0,     0,     0,
       0,   184,   185,   186,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   956,   623,     0,     0,   957,   190,
     191,   192,   193,   194,   195,   238,     0,     0,     0,     0,
     196,   197,   198,   199,   200,   201,   202,   173,   174,   175,
     176,   177,   178,   179,   180,   181,     0,     0,   182,   183,
       0,     0,     0,     0,   184,   185,   186,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   959,   632,     0,
       0,   960,   190,   191,   192,   193,   194,   195,   238,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     173,   174,   175,   176,   177,   178,   179,   180,   181,     0,
       0,   182,   183,     0,     0,     0,     0,   184,   185,   186,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1243,   623,     0,     0,  1244,   190,   191,   192,   193,   194,
     195,   238,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   173,   174,   175,   176,   177,   178,   179,
     180,   181,     0,     0,   182,   183,     0,     0,     0,     0,
     184,   185,   186,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1246,   632,     0,     0,  1247,   190,   191,
     192,   193,   194,   195,   238,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   173,   174,   175,   176,
     177,   178,   179,   180,   181,     0,     0,   182,   183,     0,
       0,     0,     0,   184,   185,   186,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1253,   623,     0,     0,
    1254,   190,   191,   192,   193,   194,   195,   238,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   173,
     174,   175,   176,   177,   178,   179,   180,   181,     0,     0,
     182,   183,     0,     0,     0,     0,   184,   185,   186,   187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   666,
     632,     0,     0,   667,   190,   191,   192,   193,   194,   195,
     238,     0,     0,     0,     0,   196,   197,   198,   199,   200,
     201,   202,   173,   174,   175,   176,   177,   178,   179,   180,
     181,     0,     0,   182,   183,     0,     0,     0,     0,   184,
     185,   186,   187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,     0,
       0,     0,     0,   361,   362,     0,     0,   190,   191,   192,
     193,   194,   195,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,     0,     0,     0,   348,   349,
     350,   351,   352,   353,   354,   355,     0,   357,   358,   364,
     365,   366,   367,     0,   368,   361,   362,     0,     0,     0,
     369,   370,   371,   372,   373,     0,     0,     0,   374,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,   367,     0,   368,     0,     0,     0,
       0,     0,   369,   370,   371,   372,   373 ];

#[allow(non_upper_case_globals)]
const yycheck_: &'static [i32] = &[      2,     8,    59,   105,    60,   385,    28,    16,    17,    91,
     331,   403,     2,   380,     4,    85,    16,    17,    22,   346,
     452,    28,   104,   555,    71,   232,   238,   596,    22,   346,
      96,   276,   610,   744,   751,   280,     4,   747,   849,    16,
      17,   610,    57,   444,   101,   909,   596,    71,    69,    57,
      97,   452,    59,    55,    56,    55,    56,     8,    97,   491,
     610,   382,   856,    53,    54,   324,    53,    57,   501,   328,
      85,   911,    53,    13,    76,    77,    80,    28,    55,    16,
      17,   448,   985,    98,    99,   100,    80,     2,   328,     4,
      29,    77,    68,   102,   101,    85,    13,    94,    27,    25,
      97,   794,   102,  1166,   942,    26,    77,    25,    98,    99,
     100,   101,    26,    25,   431,   432,  1172,   100,   538,    66,
      52,  1177,   379,   324,   381,   102,    13,   328,    66,   103,
     302,   303,    68,    15,    99,    34,   503,     0,    34,    54,
      37,    38,   140,    25,    97,   227,    13,    27,    68,    29,
     583,   790,   791,    52,   126,   100,    52,   140,    93,    94,
     216,    97,    97,    25,   129,   102,   140,    25,  1224,   431,
     432,   428,   119,   264,   256,   128,    25,    97,   747,    25,
     125,   119,    13,   136,   123,   125,  1249,    56,   744,     2,
     447,     4,   449,   125,   836,   751,    25,    52,   138,   125,
     140,    56,   844,    16,    17,   126,   139,   125,   290,   138,
     136,   140,   126,   125,   284,   136,   218,   219,   136,   266,
     477,   138,   212,   140,   226,   596,   235,   266,   237,   238,
     232,   212,   218,   219,  1072,   235,   238,   237,    25,   610,
      53,    54,   266,   140,    57,   247,   505,   504,   219,   253,
     254,   138,   343,   140,    13,    68,   463,   247,   235,   249,
     237,   238,   694,   125,   285,   505,   658,   125,   249,   284,
     126,   138,    85,   140,   264,  1178,   125,   264,  1142,   125,
      93,    94,   649,   264,    97,    98,    99,   100,    13,   102,
     100,   692,   659,   694,   284,  1137,   125,   560,   235,   562,
     237,  1141,   995,   996,   505,   136,   241,   138,   243,   140,
      28,   731,   732,   395,    68,   125,   287,    66,     9,    99,
     317,   318,   319,   320,    15,    99,   316,   139,    99,   344,
      99,   321,   247,    13,  1051,   139,   344,   327,   125,    68,
     661,   331,   389,    97,   516,  1056,   518,   780,   316,   129,
     389,   990,   991,   343,   344,   129,   343,    13,   129,   129,
     129,    66,   343,   127,   341,   341,   136,    96,    97,   346,
     346,   380,   121,   122,   381,   124,   140,   381,   380,   138,
    1191,   140,   317,   318,   319,   320,   942,   322,   323,   921,
     387,    68,   382,   650,   139,  1237,   386,  1191,   388,   212,
     792,   316,   282,   660,   973,   386,   321,   388,    68,    13,
      13,   136,   129,   138,   119,   140,   121,   122,   785,   988,
      97,   428,   235,   794,   237,   238,   995,   996,   241,   136,
     243,   501,   125,   140,   247,   762,   249,    97,   839,   448,
     811,  1019,   449,   125,   444,   449,   448,   140,  1159,   471,
    1019,   264,   387,  1264,  1164,   431,   432,   716,   138,   461,
     140,   463,    25,   708,   471,   782,    99,   402,   125,  1019,
     477,   284,    99,   477,   125,   682,   716,   570,   129,   138,
     692,   140,   138,   140,   140,   744,   501,   129,   488,   909,
      68,   911,   751,   483,   503,  1051,   129,   504,    25,   112,
     504,   503,   129,   316,   317,   318,   319,   320,   321,   322,
     323,   501,   594,   583,   327,   716,   833,   834,   331,    97,
     471,   568,   968,   840,   841,   109,    25,   784,   341,   786,
     343,   344,    66,   346,   138,   138,   140,   140,  1070,    99,
     103,   987,   544,   125,   637,  1256,  1078,   131,   869,   642,
     722,   644,    68,   555,    99,   727,   565,    52,   140,   125,
     569,    56,   125,    37,    38,   567,   129,   380,   583,   382,
     129,   833,   834,   386,   387,   388,   103,   140,   840,   841,
      96,    97,    68,   136,   129,   651,    99,   121,   122,   402,
      56,    25,    99,   583,   965,  1164,   643,   100,   125,    99,
     992,   125,   129,  1159,   103,   139,   596,  1039,    68,   136,
    1166,    97,   128,   140,   985,    99,   129,   125,   431,   432,
     610,   136,   129,   627,   995,   996,   125,   948,   630,   129,
     129,   136,   636,   627,   636,   448,    96,    97,  1039,   709,
     649,   140,   636,   650,  1024,    77,   650,   649,  1019,   639,
     659,   641,   674,   660,   917,   918,   660,   659,   639,   922,
     641,   924,   137,   926,   668,   140,   668,   674,   128,   103,
     483,   661,    68,    68,   668,    15,   136,    17,    66,   772,
     682,   774,   889,   942,  1064,    58,    68,  1219,   501,  1006,
     503,   125,   692,  1249,   709,   129,   136,   701,   702,    99,
     702,    97,    97,   596,    77,    58,   140,  1028,    77,    68,
     780,   143,   144,   145,   103,    97,   129,   610,   137,   709,
     127,  1141,  1142,   674,    77,   125,  1172,   662,    56,   129,
      77,  1177,  1178,   121,   122,   108,   109,    96,    97,   619,
     125,   797,    26,  1123,  1006,   136,  1126,    94,    95,   629,
     973,   139,   565,    88,    89,   108,   569,    77,   131,   112,
     762,   763,   697,    99,   857,   780,   129,   860,   770,   128,
     583,   773,   995,   996,    68,   877,   785,   129,  1224,   786,
      68,   874,   786,   785,    68,   762,   129,   777,    99,   125,
     780,   781,  1051,   129,   141,   142,   143,   144,   145,    99,
     790,   791,    96,    97,   794,   685,   782,   106,    96,    97,
      14,    15,    96,    97,   125,   125,  1262,  1138,   129,   876,
     867,   811,    66,    67,    77,   125,   639,    56,   641,   129,
      40,    41,   138,   713,   128,    25,   649,    99,   133,   839,
     128,  1208,   126,   129,   128,   847,   659,   849,   661,   662,
     738,   129,   136,    66,   103,   431,   432,   833,   834,   747,
     125,    26,   777,   125,   840,   841,   781,   129,    66,   876,
     125,   868,   286,   287,   450,   451,   866,   121,   122,   869,
    1143,  1144,  1145,  1146,   697,   866,   127,   889,   141,   142,
     143,   144,   145,    82,    83,   127,   709,   790,   791,   125,
    1159,   794,   478,    68,   125,   125,   119,  1166,   121,   122,
      68,   124,   129,   125,   794,   795,   125,   125,   811,   921,
      68,   119,  1015,   121,   122,  1018,   124,  1020,    68,   931,
      54,    96,    97,   868,  1027,    52,    52,  1030,    96,    97,
      64,    65,    26,   132,   133,   935,   936,    99,    96,    97,
     125,    10,  1209,   943,   935,   936,    96,    97,   948,     8,
     129,   126,   943,   128,   777,   125,   125,   780,   781,   782,
     128,   136,   785,   125,    68,   965,    44,   129,   968,  1242,
     128,    68,  1029,   863,    68,   982,   125,    44,   128,    99,
    1249,   125,    13,   873,    25,   985,   986,   987,    17,   125,
     990,   991,    96,    97,   139,   995,   996,   139,   129,    96,
      97,   125,    96,    97,   894,   125,    44,  1014,    44,   129,
     833,   834,    68,  1013,   127,   130,   985,   840,   841,  1019,
    1006,    68,  1013,   125,   128,    68,   995,   996,  1028,  1095,
    1133,   128,   126,    52,   128,   130,   125,   982,  1063,   125,
      96,    97,   136,   866,   942,   868,   869,   150,    15,    96,
      97,  1076,   942,    96,    97,  1067,   137,  1149,  1070,   125,
     125,    68,   965,  1063,   125,   968,  1078,    52,   958,  1014,
     241,   125,   128,    66,   125,   100,  1076,   967,   127,   942,
     970,   128,   985,   986,   987,   128,    68,   990,   991,    96,
      97,   125,   995,   996,  1197,   125,   942,    52,   269,   127,
      77,   100,   273,   993,    40,    41,    42,    43,    44,     2,
     125,     4,   935,   936,    96,    97,  1019,    94,    95,   103,
     943,   128,   138,    16,    17,   948,   119,   125,   121,   122,
       9,  1131,   103,  1158,    54,    55,   130,    57,  1138,  1139,
    1131,    56,   596,   130,    64,    65,   128,    52,  1139,    54,
      55,    56,    57,  1153,   131,   125,   610,    66,  1158,   982,
      53,    54,  1153,   125,   141,   142,   143,   144,   145,   125,
      56,   125,  1172,   125,   125,    68,    66,  1177,  1178,  1191,
    1187,  1188,  1072,  1006,   125,  1185,   125,   125,   125,  1208,
    1013,  1014,  1209,   127,  1185,  1209,  1208,   125,  1210,  1199,
      93,    94,   125,    66,    97,  1028,  1096,  1219,  1199,   102,
     119,   125,   121,   122,   125,   125,    52,  1229,    54,    55,
      56,    57,    58,   120,  1224,   125,  1116,  1117,  1118,   119,
    1230,   121,   122,    52,   136,    54,    55,    56,    57,  1230,
    1063,    77,  1187,  1188,   136,   247,   479,   833,   834,   483,
     876,    98,  1264,  1076,   840,   841,   119,   100,   121,   122,
      89,  1159,  1262,   763,   668,   101,  1164,  1229,  1166,  1172,
    1168,   107,   108,   109,  1177,  1178,   731,    52,    56,    54,
      55,    56,    57,   454,    52,   909,    54,    55,   459,    57,
     773,   462,  1074,   942,   465,   131,  1159,   883,   884,  1237,
     886,   887,   771,  1166,  1194,  1168,   878,   143,  1131,   480,
    1264,   575,   986,  1159,   485,  1138,  1139,   988,  1164,   212,
    1166,  1224,  1168,   988,   984,  1210,   101,  1067,   108,   518,
    1153,   101,   107,   101,   747,  1158,   790,   791,  1164,  1096,
     794,  1159,   235,    -1,   237,   238,    -1,   744,   241,    -1,
     243,  1249,   685,  1251,   247,  1245,   249,   811,  1256,  1262,
    1258,    -1,  1185,    -1,  1187,  1188,    -1,     2,    -1,     4,
      -1,   264,    -1,    -1,    -1,   546,  1199,    -1,    -1,  1277,
     713,    16,    17,  1080,  1081,  1208,  1249,    -1,  1251,    59,
      60,    61,    62,  1256,    52,  1258,    54,    55,    56,    57,
      -1,    -1,    -1,  1249,    -1,  1251,    -1,  1230,    -1,    -1,
    1256,   582,  1258,    -1,  1277,    -1,    -1,    -1,    53,    54,
    1006,    -1,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,  1277,   210,    68,   327,   213,   214,   215,   331,    -1,
      -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,   341,    -1,
     343,  1037,    -1,   346,    -1,    -1,   596,    -1,    93,    94,
      -1,   794,    97,   596,    -1,    -1,    -1,   102,    -1,    -1,
     610,    -1,    -1,    -1,    -1,    -1,    -1,   610,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,   382,
      -1,    -1,    -1,   386,   387,   388,    -1,     2,    -1,     4,
      -1,    -1,    -1,   751,    -1,    -1,   754,    -1,    -1,   402,
      -1,   965,    -1,    -1,   968,    -1,    -1,  1214,  1215,    -1,
      -1,    -1,    -1,  1220,    -1,  1222,  1223,    -1,    -1,    -1,
     863,   985,   986,   987,    -1,    -1,   990,   991,   431,   432,
     873,   995,   996,    -1,    -1,    -1,    -1,    -1,    53,    54,
      -1,    -1,    57,    -1,    -1,   448,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   341,   735,  1019,    -1,    -1,   346,    -1,
      -1,    -1,  1269,  1270,  1271,  1272,    -1,   212,    -1,    -1,
      85,    -1,    -1,    -1,  1281,    -1,    -1,    -1,    -1,    -1,
     483,    -1,    -1,    98,    99,   100,    -1,    -1,    -1,    -1,
     235,    -1,   237,   238,    -1,    -1,   241,    -1,   243,    -1,
     503,    -1,   247,    -1,   249,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   958,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,   967,    -1,    -1,   970,    -1,    -1,
      -1,    -1,    52,    -1,    54,    55,    56,    57,    58,    -1,
     790,   791,    -1,    -1,   794,    -1,    -1,   790,   791,    -1,
     993,   794,    -1,    -1,    -1,   443,   444,    77,    -1,    -1,
      -1,   811,   565,    -1,   452,    -1,   569,    -1,   811,    -1,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   101,   327,    -1,   942,    -1,   331,   107,   108,   109,
      -1,    -1,    -1,    -1,   875,    -1,   341,   212,   343,    -1,
     488,   346,    -1,   491,    -1,    -1,    -1,   888,  1172,   890,
      -1,   131,    -1,  1177,  1178,    -1,    -1,    -1,    -1,    -1,
     140,    -1,    -1,   143,    -1,    -1,   907,    -1,    -1,    -1,
      -1,    -1,   247,    -1,   249,   380,   639,   382,   641,    -1,
      -1,   386,   387,   388,    -1,    -1,   649,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,   659,   402,   661,   662,
    1224,    -1,    -1,    -1,    -1,   553,    -1,    -1,    -1,   284,
      -1,    -1,    -1,  1116,  1117,  1118,    -1,    52,    -1,    54,
      55,    56,    57,    58,    -1,    -1,   431,   432,   576,    -1,
      -1,    -1,    -1,  1051,   697,  1053,    -1,    -1,  1262,    -1,
    1058,   316,    77,   448,    -1,    -1,   321,    -1,    -1,    -1,
      -1,    -1,   327,   994,    -1,   965,   331,    -1,   968,    -1,
      -1,    -1,   965,    -1,    -1,   968,   101,    -1,   343,   344,
      -1,   346,    77,   108,   109,   985,   986,   987,   483,    -1,
     990,   991,   985,   986,   987,   995,   996,   990,   991,    94,
      95,    -1,   995,   996,    -1,    -1,   131,    -1,   503,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   382,    -1,  1019,
      -1,   386,    -1,   388,   777,    -1,  1019,    -1,   781,   782,
      -1,    -1,   785,    -1,    -1,   130,   131,   675,    -1,    -1,
     135,   679,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
     145,    -1,  1245,    -1,   692,    -1,   694,  1088,  1166,    -1,
    1168,    -1,    -1,    -1,    -1,    -1,   431,   432,    -1,    -1,
     565,    -1,    -1,    -1,   569,    -1,    -1,    -1,    -1,    -1,
     833,   834,  1113,  1114,  1115,    -1,    -1,   840,   841,    -1,
      -1,    -1,    -1,    -1,  1202,    -1,    52,    -1,    54,    55,
      56,    57,    58,    -1,   742,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   866,    -1,   868,   869,    -1,   483,    -1,
      -1,    77,    -1,    -1,   762,    -1,    -1,    -1,    -1,    -1,
      -1,    33,    34,    35,    36,    91,   501,    -1,   776,    -1,
      -1,  1249,    -1,  1251,   639,   101,   641,    49,    50,    51,
    1258,   107,   108,   109,   649,    -1,    -1,    59,    60,    61,
      62,    63,    -1,    -1,   659,    -1,   661,   662,    -1,  1277,
      -1,    -1,  1172,    -1,    -1,   131,    -1,  1177,  1178,  1172,
     136,    -1,   935,   936,  1177,  1178,    -1,   143,    -1,    -1,
     943,    -1,    -1,    -1,    52,   948,    54,    55,    56,    57,
      58,   839,   697,    -1,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,   583,    77,
      -1,   859,    -1,    -1,  1224,    -1,    -1,    -1,    -1,   982,
      -1,  1224,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,   151,
     108,   109,    -1,  1006,    -1,    -1,    -1,    -1,    -1,    -1,
    1013,  1014,  1262,    -1,    -1,    -1,    -1,    -1,    -1,  1262,
       2,    -1,     4,   131,   639,  1028,   641,    -1,    -1,    -1,
      -1,    -1,   777,    -1,    -1,    -1,   781,   782,    -1,    -1,
     785,    -1,    -1,     0,    -1,    -1,   661,    -1,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    13,    14,    15,    -1,
      17,    -1,   950,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    53,    54,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,   833,   834,
      -1,    -1,    -1,    -1,   709,   840,   841,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    -1,   720,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    98,    99,   100,    -1,
      -1,   866,    -1,   868,   869,    -1,    -1,    -1,  1131,    -1,
      -1,    -1,    -1,    -1,  1022,  1138,  1139,    -1,    -1,    96,
      97,    -1,   596,    -1,    -1,    -1,   103,    -1,    -1,    -1,
    1153,  1039,    -1,    -1,    -1,    52,   610,    54,    55,    56,
      57,    58,   777,   120,    -1,   780,   781,   782,    -1,   126,
     127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
      77,   138,  1185,   140,  1187,  1188,    -1,    -1,    -1,    -1,
     935,   936,    -1,    -1,    91,    -1,  1199,    -1,   943,    -1,
      -1,    -1,    -1,   948,   101,  1208,    -1,    -1,    -1,    -1,
     107,   108,   109,    -1,    -1,    -1,    -1,    -1,   833,   834,
      -1,    -1,    -1,    -1,    -1,   840,   841,  1230,    -1,    -1,
     212,    -1,    -1,    -1,   131,    -1,    -1,   982,    -1,    -1,
      -1,    -1,  1130,    -1,    -1,    -1,   143,    -1,    -1,    -1,
      -1,   866,    -1,    -1,   869,    -1,    -1,    -1,     2,    -1,
       4,  1006,    -1,    -1,    -1,   247,    -1,   249,  1013,  1014,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   596,   264,  1028,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   610,    -1,    -1,    -1,    -1,
      -1,  1189,   284,    -1,    -1,    -1,    -1,    -1,    -1,    53,
      54,    -1,    -1,    57,    25,    -1,    -1,    -1,    -1,    -1,
     935,   936,    -1,    -1,    -1,    -1,    -1,    -1,   943,    -1,
      -1,    -1,    -1,   948,   316,    -1,   790,   791,    -1,   321,
     794,    85,    -1,    -1,    -1,   327,    -1,    -1,    -1,   331,
      -1,    -1,    -1,    -1,    98,    99,   100,   811,    -1,    -1,
      -1,   343,   344,    -1,   346,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    94,    95,    -1,  1131,    -1,    -1,   100,
      -1,  1006,    -1,  1138,  1139,    -1,    -1,    -1,  1013,    -1,
     382,    -1,    -1,    -1,   386,    -1,   388,    -1,  1153,    -1,
      -1,    -1,    -1,  1028,    -1,    -1,    -1,    -1,    -1,   130,
     131,   132,   133,    -1,   135,    -1,    -1,    -1,    -1,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
    1185,    -1,  1187,  1188,    -1,    -1,    -1,    -1,  1063,   431,
     432,    -1,    -1,    -1,  1199,    -1,    -1,    -1,    -1,    -1,
      -1,  1076,    -1,  1208,    -1,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,    -1,    -1,   790,   791,    -1,    -1,   794,
      -1,    -1,    -1,    -1,    -1,  1230,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     2,    -1,     4,   811,    -1,    -1,    -1,
      -1,   483,     2,   247,     4,   249,    -1,    -1,    -1,    -1,
      -1,   965,    -1,    -1,   968,    -1,  1131,    -1,    -1,   501,
     264,    -1,    -1,  1138,  1139,    -1,    -1,    -1,    -1,    -1,
      -1,   985,   986,   987,    -1,   596,   990,   991,  1153,    -1,
     284,   995,   996,  1158,    53,    54,    -1,    -1,    57,   610,
      -1,    -1,    -1,    53,    54,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1019,    -1,    -1,    -1,    -1,
    1185,    -1,   316,    -1,    -1,    -1,    85,   321,    -1,    -1,
      -1,    -1,    -1,   327,  1199,    -1,    -1,   331,    -1,    98,
      99,   100,   101,    -1,    -1,    -1,    -1,    -1,    98,   343,
     344,   583,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1230,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   382,    -1,
      -1,    -1,   386,    -1,   388,    -1,    -1,    -1,    -1,    -1,
     965,    -1,    -1,   968,    -1,    -1,    -1,   639,    -1,   641,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     985,   986,   987,    -1,    -1,   990,   991,    -1,    -1,   661,
     995,   996,    -1,    -1,    -1,    -1,    -1,   431,   432,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   212,  1019,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,  1172,    -1,
      -1,    -1,    -1,  1177,  1178,    -1,    -1,   709,    -1,   790,
     791,    -1,    -1,   794,    -1,    -1,    -1,    -1,   247,   483,
     249,    -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,   249,
     811,    -1,    -1,    -1,     2,   264,     4,   501,    -1,    -1,
      -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,
    1224,    -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   777,    -1,    -1,   780,   781,
     782,    -1,    -1,    -1,    -1,    53,    54,   316,  1262,    -1,
      -1,    -1,   321,    -1,    -1,    -1,   316,    -1,   327,    -1,
      -1,   321,   331,    -1,   596,    -1,    -1,   327,    -1,    -1,
      -1,   331,    -1,    -1,   343,   344,    -1,    -1,   610,   583,
      -1,    -1,    -1,   343,    -1,    -1,   346,    -1,    -1,    -1,
      -1,   833,   834,    -1,    -1,    -1,    -1,  1172,   840,   841,
      -1,    -1,  1177,  1178,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   382,    -1,    -1,    -1,   386,    -1,   388,
      -1,    -1,   382,    -1,   866,    -1,   386,   869,   388,    -1,
      -1,    -1,    -1,    -1,    -1,   639,    -1,   641,    -1,    -1,
      -1,    -1,    -1,    -1,   965,    -1,    -1,   968,    -1,  1224,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   661,    -1,    -1,
      -1,    -1,    -1,    -1,   985,   986,   987,    -1,    -1,   990,
     991,   431,   432,    -1,   995,   996,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1262,    -1,    -1,
      -1,    -1,    -1,   935,   936,    -1,    -1,    -1,  1019,    -1,
      -1,   943,    -1,    -1,   212,   709,   948,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   483,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   483,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   501,    -1,    -1,    -1,    -1,    -1,    -1,   247,
      -1,   249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,   790,   791,
      -1,    -1,   794,    -1,  1006,    -1,    -1,    -1,    -1,    -1,
      -1,  1013,    -1,   777,    -1,    -1,   780,   781,   782,   811,
      -1,    -1,    -1,    -1,    -1,    -1,  1028,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,
      -1,    -1,    -1,   321,   583,    -1,    -1,    -1,    -1,   327,
      -1,  1063,    -1,   331,    -1,    -1,    -1,    -1,    -1,   833,
     834,    -1,    -1,    -1,  1076,   343,   840,   841,   346,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1172,    -1,    -1,    -1,    -1,  1177,  1178,    -1,    -1,
      -1,    -1,   866,    -1,    -1,   869,    -1,    -1,    -1,    -1,
     639,    -1,   641,    -1,   382,    -1,    -1,    -1,   386,   639,
     388,   641,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1131,
      -1,    -1,   661,    -1,    -1,    -1,  1138,  1139,    -1,    -1,
      -1,   661,    -1,  1224,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1153,    -1,    -1,    -1,    -1,  1158,    -1,    -1,    -1,
      -1,    -1,    -1,   431,   432,    -1,    -1,    -1,    -1,    -1,
      -1,   935,   936,   965,    -1,    -1,   968,    -1,    -1,   943,
     709,  1262,    -1,  1185,   948,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   985,   986,   987,    44,  1199,   990,   991,
      -1,    -1,    -1,   995,   996,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   483,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1019,  1230,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,  1006,    -1,    -1,    -1,    94,    95,   777,  1013,
      -1,   780,   781,   596,    -1,    -1,    -1,   777,    -1,    -1,
      -1,   781,   782,    -1,  1028,    -1,    -1,   610,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,
      -1,    -1,   130,   131,   132,   133,    -1,   135,    -1,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,    -1,  1063,
      -1,   149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1076,   833,   834,    -1,    -1,    -1,    -1,    -1,
     840,   841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,
     869,    -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,   869,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1131,    -1,    -1,
      -1,   639,    -1,   641,  1138,  1139,    -1,    -1,    -1,    -1,
    1172,    -1,    -1,    -1,    -1,  1177,  1178,    -1,    -1,  1153,
      -1,    -1,    -1,   661,  1158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   935,   936,    -1,    -1,
      -1,    -1,    -1,    -1,   943,   935,   936,    -1,    -1,   948,
      -1,  1185,    -1,   943,    -1,    -1,    -1,    -1,   948,    -1,
      -1,    -1,  1224,    -1,    -1,  1199,    -1,    -1,    -1,    -1,
      16,    17,    -1,    -1,    -1,    -1,    -1,   790,   791,    -1,
      -1,   794,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1230,    -1,   811,    -1,
    1262,    -1,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,  1013,    -1,  1006,    -1,    -1,    -1,
      -1,    67,    68,  1013,    -1,    -1,    -1,    -1,    -1,  1028,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1028,   777,
      -1,    -1,    -1,   781,   782,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,    77,    78,    79,
      80,    81,    82,    83,  1063,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,  1063,    94,    95,    -1,  1076,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   833,   834,    -1,    -1,    -1,
      -1,    -1,   840,   841,    -1,    -1,    -1,    -1,    -1,    -1,
     130,   131,   132,   133,    -1,   135,    -1,    -1,    -1,    -1,
      -1,   141,   142,   143,   144,   145,    -1,    -1,   866,    -1,
      -1,   869,  1131,    -1,    -1,    -1,    -1,    -1,    -1,  1138,
    1139,  1131,    -1,    -1,    -1,    -1,    -1,    -1,  1138,  1139,
      -1,    -1,   965,    -1,  1153,   968,    -1,    -1,    -1,  1158,
      -1,    -1,    -1,  1153,   210,    -1,    -1,   213,   214,   215,
      -1,   217,   985,   986,   987,    -1,    -1,   990,   991,    -1,
      -1,    -1,   995,   996,    -1,    -1,  1185,    -1,    -1,   235,
      -1,   237,   238,    -1,    -1,  1185,    -1,   935,   936,    -1,
    1199,    -1,    -1,    -1,    -1,   943,  1019,    -1,    -1,  1199,
     948,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,  1230,    -1,    94,    95,    -1,    -1,    -1,    -1,    -1,
    1230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1006,   130,
     131,   132,   133,    -1,   135,  1013,    -1,    -1,    -1,   140,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
    1028,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,    -1,
     346,    -1,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,    -1,   368,   369,   370,   371,   372,   373,   374,   375,
     376,    -1,    -1,    -1,   380,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1172,
      -1,    -1,    -1,    -1,  1177,  1178,    -1,    -1,    -1,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,   431,   432,    94,    95,    -1,
      -1,    -1,    -1,  1131,    -1,    -1,   442,   443,   444,    -1,
    1138,  1139,   448,    -1,   450,   451,   452,    -1,    -1,    -1,
      -1,  1224,   458,    -1,    -1,  1153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,   131,   132,   133,   473,   135,    -1,
      -1,    -1,   478,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   488,    -1,    -1,   491,    -1,  1185,    -1,  1262,
      -1,    -1,    -1,    -1,    -1,    -1,     0,   503,    -1,    -1,
      -1,  1199,    -1,    -1,     8,     9,    10,    -1,    -1,    13,
      14,    15,    -1,    17,   520,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,  1230,    37,    38,    -1,    40,    41,    42,    43,
      44,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,
      -1,    -1,    -1,   569,    68,    -1,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      94,    95,    96,    97,    -1,    99,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,   123,
      -1,   125,   126,   127,   128,   129,   130,   131,   132,   133,
      -1,   135,    -1,   137,   138,    -1,   140,   141,   142,   143,
     144,   145,    -1,   649,    -1,   149,   150,    -1,    -1,    -1,
      -1,    -1,    -1,   659,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   675,
     676,   677,    -1,   679,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   692,    -1,   694,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,     1,
      -1,     3,     4,     5,     6,     7,    -1,    -1,    -1,    11,
      12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,   742,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,   762,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
     776,    -1,    -1,    75,    76,    -1,   782,   783,    -1,   785,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   833,   834,    -1,
      -1,    -1,    -1,   839,   840,   841,   138,    -1,   140,    -1,
      -1,    -1,    -1,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,    -1,    -1,   859,    -1,     3,     4,     5,     6,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,   883,   884,    -1,
     886,   887,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,   927,   928,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,   939,   940,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,   950,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,   999,    -1,    -1,    -1,    -1,   146,   147,
    1006,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1022,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1037,     1,  1039,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    77,
      78,    79,    80,    81,    82,    83,    75,    76,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    -1,    -1,
      -1,    90,    91,    -1,  1130,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,   130,   131,   132,   133,    -1,   135,    -1,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,    -1,   138,
      -1,   140,    -1,    -1,    -1,    -1,    -1,   146,   147,    -1,
      -1,    -1,   151,  1189,    -1,    -1,     1,    -1,     3,     4,
       5,     6,     7,    -1,    -1,    10,    11,    12,    -1,    14,
      15,    16,  1208,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,     1,   140,     3,     4,     5,     6,
       7,   146,   147,    10,    11,    12,   151,    -1,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,     1,   140,     3,     4,     5,     6,     7,   146,
     147,    10,    11,    12,   151,    -1,    15,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    25,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
       1,   140,     3,     4,     5,     6,     7,   146,   147,    10,
      11,    12,   151,    -1,    15,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,   140,
      -1,    -1,    -1,    -1,    -1,   146,   147,    -1,    -1,     1,
     151,     3,     4,     5,     6,     7,    -1,     9,    10,    11,
      12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,     1,   140,     3,
       4,     5,     6,     7,   146,   147,    -1,    11,    12,   151,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,   103,
     104,   105,    -1,   107,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,     1,   140,     3,     4,     5,
       6,     7,   146,   147,    -1,    11,    12,   151,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,   103,   104,   105,
      -1,   107,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,     1,   140,     3,     4,     5,     6,     7,
     146,   147,    -1,    11,    12,   151,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   127,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,     1,   140,     3,     4,     5,     6,     7,   146,   147,
      -1,    11,    12,   151,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   127,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,     1,
     140,     3,     4,     5,     6,     7,   146,   147,    10,    11,
      12,   151,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,     1,   140,     3,
       4,     5,     6,     7,   146,   147,    -1,    11,    12,   151,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,   107,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     0,    -1,    -1,   138,    -1,   140,    -1,    -1,     8,
       9,    10,   146,   147,    13,    14,    15,   151,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,
      99,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,   125,    -1,   127,   128,
     129,   130,   131,   132,   133,    -1,   135,    -1,   137,   138,
      -1,   140,   141,   142,   143,   144,   145,     0,    -1,    -1,
     149,   150,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    -1,    27,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      -1,    94,    95,    96,    97,    -1,    99,   100,    -1,    -1,
     103,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,   125,    -1,   127,   128,   129,   130,   131,   132,
     133,    -1,   135,    -1,   137,   138,    -1,   140,   141,   142,
     143,   144,   145,     0,    -1,    -1,   149,   150,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,    96,
      97,    -1,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,   123,    -1,   125,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,    -1,
     137,   138,    -1,   140,   141,   142,   143,   144,   145,     0,
      -1,    -1,   149,   150,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    94,    95,    96,    97,    -1,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,   125,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,    -1,   137,   138,    -1,   140,
     141,   142,   143,   144,   145,     0,    -1,    -1,   149,   150,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    -1,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,
      95,    96,    97,    -1,    99,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
     125,    -1,   127,   128,   129,   130,   131,   132,   133,    -1,
     135,    -1,   137,   138,    -1,   140,   141,   142,   143,   144,
     145,     0,    -1,    -1,   149,   150,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,
      -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,   125,    -1,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,    -1,   137,   138,
      -1,   140,   141,   142,   143,   144,   145,     0,    -1,    -1,
     149,   150,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      -1,    94,    95,    96,    97,    -1,    -1,   100,    -1,    -1,
     103,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
      -1,    -1,   125,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,    -1,   140,   141,   142,
     143,   144,   145,     0,    -1,    -1,   149,    -1,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,    96,
      97,    -1,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,   125,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,    -1,   140,   141,   142,   143,   144,   145,     0,
      -1,    -1,   149,    -1,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    -1,    27,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    94,    95,    96,    97,    -1,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,    -1,   125,    -1,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,    -1,   140,
     141,   142,   143,   144,   145,     0,    -1,    -1,   149,    -1,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    -1,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,
      95,    96,    97,    -1,    99,   100,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,
     125,   126,   127,   128,   129,   130,   131,   132,   133,    -1,
     135,    -1,    -1,   138,    -1,   140,   141,   142,   143,   144,
     145,     0,    -1,    -1,   149,    -1,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    -1,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    94,    95,    96,    97,    -1,
      99,   100,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,   125,   126,   127,   128,
     129,   130,   131,   132,   133,    -1,   135,    -1,    -1,   138,
      -1,   140,   141,   142,   143,   144,   145,     0,    -1,    -1,
     149,    -1,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      -1,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      -1,    94,    95,    96,    97,    -1,    99,   100,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
      -1,    -1,   125,    -1,   127,   128,   129,   130,   131,   132,
     133,    -1,   135,    -1,    -1,   138,    -1,   140,   141,   142,
     143,   144,   145,     0,    -1,    -1,   149,    -1,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    -1,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,    96,
      97,    -1,    99,   100,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,   125,    -1,
     127,   128,   129,   130,   131,   132,   133,    -1,   135,    -1,
      -1,   138,    -1,   140,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,     3,     4,     5,     6,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,
       3,     4,     5,     6,     7,    -1,   146,   147,    11,    12,
      -1,   151,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,   146,   147,    11,    12,    -1,   151,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   140,     3,     4,     5,    -1,     7,
     146,   147,    -1,    11,    12,   151,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,     6,     7,    -1,   146,   147,
      11,    12,    -1,   151,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,   146,   147,    11,    12,    -1,
     151,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,   146,   147,    11,    12,    -1,   151,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,
     147,    11,    12,    -1,   151,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,   146,   147,    11,    12,
      -1,   151,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,   107,   108,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,   146,   147,    11,    12,    -1,   151,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,    -1,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
     146,   147,    11,    12,    -1,   151,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,   108,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,   146,   147,    11,
      12,    -1,   151,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,    -1,   108,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,   146,   147,    11,    12,    -1,   151,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,   140,     3,     4,     5,    -1,
       7,   146,   147,    -1,    11,    12,   151,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   140,     3,     4,     5,    -1,     7,   146,
     147,    -1,    11,    12,   151,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,   146,   147,    11,
      12,    -1,   151,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
     102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,   146,   147,    11,    12,    -1,   151,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,   146,   147,    11,    12,    -1,   151,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,   147,
      11,    12,    -1,   151,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,   146,   147,    11,    12,    -1,
     151,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,   146,   147,    11,    12,    -1,   151,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,   146,
     147,    11,    12,    -1,   151,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,   146,   147,    11,    12,
      -1,   151,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,   125,     3,     4,     5,    -1,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,   151,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,   102,    -1,   104,   105,    -1,   107,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,   151,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,   107,
      -1,    -1,   110,   111,   112,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,   151,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    94,    -1,
      -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,
      -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,   151,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,
      -1,   125,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,   151,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
     101,   102,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
     151,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,   102,    -1,   104,   105,    -1,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,   151,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,   101,   102,    -1,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,   151,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,   101,   102,    -1,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    -1,    -1,   151,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,   111,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   130,   131,   132,   133,   134,   135,    -1,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    33,    34,    35,    36,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    -1,    58,    59,
      60,    61,    62,    63,    -1,    -1,    -1,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,    77,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
      90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,   101,    -1,    -1,   104,   105,    -1,   107,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      33,    34,    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   135,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    -1,    -1,    59,    60,    61,    62,
      63,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,    -1,
      -1,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    33,    34,    35,
      36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,    49,    50,    51,    52,   140,    -1,    -1,
      56,    -1,    -1,    59,    60,    61,    62,    63,   151,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,   101,    -1,    -1,   104,   105,
      -1,   107,    -1,    -1,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    -1,    -1,
      59,    60,    61,    62,    63,   151,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,   101,    -1,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    33,    34,    35,    36,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    -1,    -1,    -1,   135,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    -1,    -1,    59,    60,    61,
      62,    63,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    90,    91,
      94,    95,    -1,    -1,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,   131,   132,   133,
      -1,   135,    -1,   135,    -1,    -1,    -1,   141,   142,   143,
     144,   145,    44,    -1,    -1,   149,    -1,    -1,    -1,   151,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    -1,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   130,   131,   132,   133,    -1,   135,    -1,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,    -1,    -1,    -1,   130,   131,
     132,   133,    -1,   135,    52,    53,    -1,    -1,    56,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,    56,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      52,    53,    -1,    -1,    56,   130,   131,   132,   133,   134,
     135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
     145,   146,   147,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,
      56,   130,   131,   132,   133,   134,   135,   136,    -1,    -1,
      -1,    -1,   141,   142,   143,   144,   145,   146,   147,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,
      53,    -1,    -1,    56,   130,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    52,    53,    -1,    -1,    56,   130,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    -1,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,
     130,   131,   132,   133,   134,   135,   136,    -1,    -1,    -1,
      -1,   141,   142,   143,   144,   145,   146,   147,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    -1,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,
      -1,    -1,    56,   130,   131,   132,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,   146,
     147,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,
      94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    53,    -1,    -1,    56,   130,   131,   132,   133,
     134,   135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,
     144,   145,   146,   147,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
     141,   142,   143,   144,   145,   146,   147,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    -1,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,    56,   130,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,   141,   142,   143,   144,   145,   146,   147,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      52,    53,    -1,    -1,    56,   130,   131,   132,   133,   134,
     135,   136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,
     145,   146,   147,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    53,    -1,    -1,    56,   130,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,   141,
     142,   143,   144,   145,   146,   147,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    -1,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,
      56,   130,   131,   132,   133,   134,   135,   136,    -1,    -1,
      -1,    -1,   141,   142,   143,   144,   145,   146,   147,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    -1,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,
      53,    -1,    -1,    56,   130,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,    -1,   141,   142,   143,   144,   145,
     146,   147,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      93,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    -1,    94,    95,    -1,    -1,   130,   131,   132,
     133,   134,   135,    -1,    -1,    -1,    -1,    -1,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,   130,
     131,   132,   133,    -1,   135,    94,    95,    -1,    -1,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   130,   131,   132,   133,    -1,   135,    -1,    -1,    -1,
      -1,    -1,   141,   142,   143,   144,   145 ];

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
  #[allow(non_upper_case_globals)]
const yystos_: &'static [i32] = &[      0,   154,   155,     0,     1,     3,     4,     5,     6,     7,
      11,    12,    16,    18,    19,    20,    21,    22,    23,    24,
      30,    31,    32,    33,    34,    35,    36,    39,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    59,    60,    61,    62,    63,    64,    65,    75,    76,
      90,    91,    98,   101,   102,   104,   105,   107,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   146,   147,   151,
     156,   157,   158,   165,   167,   169,   173,   174,   179,   180,
     183,   184,   185,   187,   188,   189,   191,   192,   201,   204,
     219,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   248,   270,   280,   281,   330,   331,   332,   333,
     334,   335,   336,   339,   341,   342,   356,   357,   359,   360,
     361,   363,   364,   365,   366,   367,   405,   419,   158,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    56,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    86,    87,    92,    93,    94,    95,   107,   108,
     130,   131,   132,   133,   134,   135,   141,   142,   143,   144,
     145,   146,   147,   195,   196,   197,   199,   200,   356,    39,
      58,    98,   101,   107,   108,   109,   112,   147,   173,   174,
     184,   192,   201,   205,   211,   214,   216,   229,   363,   364,
     366,   367,   403,   404,   211,   136,   212,   213,   136,   208,
     212,   136,   140,   412,    54,   196,   412,   126,   159,   126,
      21,    22,    31,    32,   183,   201,   229,   248,   201,   201,
     201,    56,     1,    47,   101,   161,   162,   163,   165,   186,
     187,   419,   165,   221,   206,   216,   403,   419,   205,   402,
     403,   419,    46,    98,   125,   151,   173,   174,   191,   219,
     229,   363,   364,   367,   271,    54,    55,    57,   195,   345,
     358,   345,   346,   347,   139,   139,   139,   139,   201,   179,
     201,   361,   138,   140,   411,   417,   418,    40,    41,    42,
      43,    44,    37,    38,   136,   370,   371,   372,   373,   419,
     370,   372,    26,   126,   208,   212,   240,   282,    28,   241,
     278,   129,   125,   101,   107,   188,   129,    25,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    94,    95,   100,   130,   131,   132,   133,   135,   141,
     142,   143,   144,   145,   149,   203,   203,    68,    96,    97,
     128,   409,   220,   169,   176,   176,   177,   178,   177,   176,
     411,   418,    98,   185,   192,   229,   253,   363,   364,   367,
      52,    56,    94,    98,   193,   194,   229,   363,   364,   367,
     194,    33,    34,    35,    36,    49,    50,    51,    52,    56,
     136,   172,   195,   365,   400,   211,    97,   409,   410,   282,
     333,    99,    99,   125,   205,    56,   205,   205,   205,   345,
     370,   370,   129,   100,   125,   215,   419,    97,   128,   409,
      99,    99,   125,   215,   211,   412,   413,   211,    91,   210,
     211,   216,   377,   403,   419,   169,   413,   169,    54,    64,
      65,   166,   136,   202,   156,   161,    97,   409,    99,   164,
     186,   103,   411,   418,   413,   222,   413,   137,   125,   140,
     416,   125,   416,   127,   416,   412,    56,   188,   190,   361,
     371,   125,    97,   128,   409,   272,    66,   119,   121,   122,
     348,   119,   119,   348,    67,   348,   337,   343,   340,   344,
      77,   138,   158,   176,   176,   176,   176,   165,   169,   169,
      52,    54,    55,    56,    57,    58,    77,    91,   101,   107,
     108,   109,   131,   143,   258,   374,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   387,   388,   389,   390,   391,
     394,   395,   396,   397,   398,   129,   160,   161,   376,   129,
     160,   283,   106,   181,   284,   279,   107,   179,   205,   216,
     217,   218,   186,   125,   191,   125,   167,   168,   179,   192,
     201,   205,   207,   218,   229,   367,   171,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     170,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,    52,    53,    56,   199,   208,   406,   407,   210,
     216,    52,    53,    56,   199,   208,   406,   160,    13,   249,
     417,   249,   161,   176,   161,   411,   225,    56,    97,   128,
     409,    25,   169,    52,    56,   193,   133,   368,    97,   128,
     409,   228,   401,    68,    97,   408,    52,    56,   406,   168,
     201,   207,   168,   207,   198,   124,   129,   129,   205,   107,
     205,   214,   403,    52,    56,   210,    52,    56,   404,   413,
     103,   413,   125,   413,   125,   413,   196,   223,   201,   127,
     127,   406,   406,   207,   159,   413,   163,   413,   403,   125,
     190,    52,    56,   210,    52,    56,   136,   274,   376,   350,
     349,   119,   338,   348,    66,   119,   119,   338,    66,   119,
     201,   101,   107,   254,   255,   256,   257,   379,   125,   399,
     419,   413,   259,   260,   125,   375,   205,   125,   399,    34,
      52,   125,   375,    52,   125,   375,    52,   184,   201,    10,
     247,     8,   242,   326,   419,   417,   184,   201,   247,   285,
     286,   182,   287,   288,   287,   205,   125,    44,   413,   190,
     125,    44,   129,    44,    97,   128,   409,    52,    56,    58,
      90,    91,    98,   101,   104,   105,   107,   112,   135,   270,
     297,   298,   299,   300,   303,   308,   309,   310,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   330,   331,   334,   335,   336,   339,   341,   342,   364,
     388,   297,   412,    99,    99,   208,   212,   412,   414,   125,
      99,    99,   208,   209,   212,   419,   247,   161,    13,   161,
     247,    27,   250,   417,   247,    25,   224,   292,    17,   244,
     290,    52,    56,   210,    52,    56,   177,   227,   369,   226,
      52,    56,   193,   210,   160,   169,   175,   209,   212,   196,
     205,   205,   215,    99,    99,   414,    99,    99,   377,   403,
     169,   416,   188,   414,   376,   273,   351,    54,    55,    57,
     355,   367,   139,   348,   139,   139,   139,   256,   379,   125,
     413,   125,   398,   205,   129,   374,   381,   394,   396,   384,
     388,   390,   382,   391,   396,   380,   382,    44,    44,   205,
     218,   327,   419,     9,    15,   243,   245,   329,   419,    44,
      44,   127,   130,   265,   266,   419,   285,   247,   265,   247,
     107,   205,   165,   190,   165,   201,    52,    56,   210,    52,
      56,   321,   321,    56,   193,   305,   298,   306,   307,   308,
     309,   312,   414,   304,   412,   415,    52,   345,    52,    54,
      55,    57,   101,   362,   100,   125,   130,   125,   125,   298,
      88,    89,    97,   128,   136,   301,   302,    34,    52,   150,
     168,   207,   168,   207,   181,   137,    99,   168,   207,   168,
     207,   181,    14,   245,   246,   251,   252,   419,   252,   293,
     290,   247,   107,   205,   289,   247,   414,   161,   417,   176,
     160,   414,   247,   413,   172,   282,   278,    99,   413,   125,
     413,   267,   412,    29,   123,   275,   352,   413,   254,   257,
     255,   125,   375,   125,   375,   399,   125,   375,   125,   375,
     375,   201,   201,   100,   328,   419,   161,   161,   201,   201,
     258,   261,   264,   267,   380,   382,   383,   385,   386,   392,
     393,   396,   398,   161,   127,   160,   205,   414,   298,   414,
     107,   298,   312,   414,   125,   112,   313,   127,   124,   176,
     322,   306,   310,   303,   311,   312,   315,   319,   321,   321,
     193,   414,   413,   306,   309,   313,   306,   309,   313,   201,
     168,   207,   161,   176,   247,   247,   296,   297,   247,   205,
     125,   249,   247,   160,   417,   247,   103,   138,   277,   276,
     353,   125,   125,   382,   396,   382,   382,    98,   192,   229,
     363,   364,   367,   249,   329,   399,   267,   130,   259,   125,
     262,   263,    98,   229,   125,   399,   125,   262,   125,   262,
     413,    52,   125,   125,   345,   415,   103,   125,   125,   413,
     413,   413,   414,   414,   414,   249,   249,    40,    41,   107,
     205,   161,   247,    52,   268,   269,   378,   160,   161,   354,
     255,   375,   125,   375,   375,   375,    56,    97,   128,   409,
     161,   130,   229,   261,   393,   396,    56,    97,   385,   390,
     382,   392,   396,   382,   125,   311,   311,   310,   312,   161,
     294,   176,   176,   205,   252,   290,   291,   125,   412,   247,
     127,   161,   382,    52,    56,   210,    52,    56,   326,   125,
     262,   125,   262,    52,    56,   399,   125,   262,   125,   262,
     262,   311,   125,   251,   161,   269,   120,   375,   414,   382,
     396,   382,   382,   252,   292,   295,   262,   125,   262,   262,
     262,   382,   262 ];

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
  #[allow(non_upper_case_globals)]
const yyr1_: &'static [i32] = &[      0,   153,   155,   154,   156,   157,   157,   157,   157,   158,
     158,   159,   160,   160,   161,   162,   162,   162,   162,   163,
     164,   163,   166,   165,   165,   165,   165,   165,   165,   165,
     165,   165,   165,   165,   165,   165,   165,   165,   165,   165,
     167,   167,   167,   167,   167,   167,   167,   167,   167,   167,
     167,   167,   168,   168,   168,   169,   169,   169,   169,   169,
     170,   169,   171,   169,   169,   172,   173,   175,   174,   176,
     178,   177,   179,   179,   180,   180,   182,   181,   183,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     185,   185,   186,   186,   187,   187,   187,   187,   187,   187,
     187,   187,   187,   187,   188,   188,   189,   189,   190,   190,
     191,   191,   191,   191,   191,   191,   191,   191,   191,   192,
     192,   192,   192,   192,   192,   192,   192,   192,   193,   193,
     194,   194,   194,   195,   195,   195,   195,   195,   196,   196,
     197,   198,   197,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   199,
     199,   199,   199,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   200,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,   201,   202,   201,   201,   201,   201,   201,
     201,   201,   203,   203,   203,   203,   204,   204,   205,   206,
     206,   206,   206,   207,   207,   208,   208,   208,   209,   209,
     210,   210,   210,   210,   210,   211,   211,   211,   211,   211,
     213,   212,   214,   214,   215,   215,   216,   216,   216,   216,
     217,   217,   218,   218,   218,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   220,   219,   221,   219,
     222,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   223,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   224,   219,   225,   219,   219,   219,   226,
     219,   227,   219,   228,   219,   219,   219,   219,   219,   219,
     219,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   249,   249,   250,   250,   251,   251,   252,   252,
     253,   253,   254,   254,   255,   255,   256,   256,   256,   256,
     256,   257,   257,   258,   258,   260,   259,   261,   261,   261,
     261,   262,   262,   263,   264,   264,   264,   264,   264,   264,
     264,   264,   264,   264,   264,   264,   264,   264,   264,   265,
     265,   266,   266,   267,   267,   268,   268,   269,   269,   271,
     272,   273,   270,   274,   274,   276,   275,   277,   275,   279,
     278,   280,   280,   280,   280,   281,   281,   281,   281,   281,
     281,   281,   281,   281,   283,   282,   284,   282,   286,   285,
     288,   287,   289,   289,   289,   289,   290,   291,   291,   293,
     294,   292,   295,   295,   296,   296,   296,   297,   297,   297,
     297,   297,   297,   298,   299,   299,   300,   300,   301,   302,
     303,   303,   303,   303,   303,   303,   303,   303,   303,   303,
     303,   303,   303,   304,   303,   303,   305,   303,   306,   306,
     306,   306,   306,   306,   306,   306,   307,   307,   308,   308,
     309,   310,   310,   311,   311,   312,   313,   313,   313,   313,
     314,   314,   315,   315,   316,   316,   317,   317,   318,   319,
     319,   320,   320,   320,   320,   320,   320,   320,   320,   320,
     320,   321,   321,   321,   321,   321,   321,   321,   321,   321,
     321,   322,   323,   323,   324,   325,   325,   325,   326,   326,
     327,   327,   327,   328,   328,   329,   329,   330,   330,   331,
     332,   332,   332,   333,   334,   335,   336,   337,   337,   338,
     338,   339,   340,   340,   341,   342,   343,   343,   344,   344,
     345,   345,   346,   346,   347,   347,   348,   349,   348,   350,
     351,   352,   353,   354,   348,   355,   355,   355,   355,   356,
     356,   357,   358,   358,   358,   358,   359,   360,   360,   361,
     361,   361,   361,   362,   362,   362,   363,   363,   363,   363,
     363,   364,   364,   364,   364,   364,   364,   364,   365,   365,
     366,   366,   367,   367,   369,   368,   368,   370,   370,   371,
     372,   373,   372,   374,   374,   374,   374,   374,   375,   375,
     376,   376,   376,   376,   376,   376,   376,   376,   376,   376,
     376,   376,   376,   376,   376,   377,   378,   378,   378,   378,
     379,   379,   380,   381,   381,   382,   382,   383,   384,   384,
     385,   385,   386,   386,   387,   387,   388,   388,   389,   390,
     390,   391,   392,   393,   393,   394,   394,   395,   395,   396,
     396,   397,   397,   398,   398,   399,   399,   400,   401,   400,
     402,   402,   403,   403,   404,   404,   404,   404,   404,   405,
     405,   405,   406,   406,   406,   406,   407,   407,   407,   408,
     408,   409,   409,   410,   410,   411,   411,   412,   412,   413,
     414,   415,   416,   416,   416,   417,   417,   418,   418,   419 ];

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
  #[allow(non_upper_case_globals)]
const yyr2_: &'static [i32] = &[      0,     2,     0,     2,     2,     1,     1,     3,     2,     1,
       2,     3,     5,     3,     2,     1,     1,     3,     1,     1,
       0,     3,     0,     4,     3,     3,     3,     2,     3,     3,
       3,     3,     3,     4,     1,     3,     3,     5,     3,     1,
       3,     3,     6,     5,     5,     5,     5,     4,     6,     4,
       6,     3,     1,     3,     1,     1,     3,     3,     3,     2,
       0,     4,     0,     4,     1,     1,     2,     0,     5,     1,
       0,     3,     1,     1,     1,     4,     0,     4,     1,     2,
       3,     4,     5,     4,     5,     2,     2,     2,     2,     2,
       1,     3,     1,     3,     1,     2,     3,     5,     2,     4,
       2,     4,     1,     3,     1,     3,     2,     3,     1,     3,
       1,     1,     4,     3,     3,     3,     3,     2,     1,     1,
       1,     4,     3,     3,     3,     3,     2,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     6,     5,     5,     5,
       5,     4,     3,     3,     3,     2,     2,     2,     2,     3,
       3,     3,     3,     3,     3,     4,     2,     2,     3,     3,
       3,     3,     1,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     3,     3,     0,     4,     6,     4,     6,     4,
       6,     1,     1,     1,     1,     1,     3,     3,     1,     1,
       2,     4,     2,     1,     3,     3,     5,     3,     1,     1,
       1,     1,     2,     4,     2,     1,     2,     2,     4,     1,
       0,     2,     2,     1,     2,     1,     1,     2,     3,     4,
       1,     1,     3,     4,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     4,     0,     3,
       0,     4,     3,     3,     2,     3,     3,     1,     4,     3,
       1,     0,     6,     4,     3,     2,     1,     2,     1,     6,
       6,     4,     4,     0,     6,     0,     5,     5,     6,     0,
       6,     0,     7,     0,     5,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     5,     1,     2,
       1,     1,     1,     3,     1,     3,     1,     3,     5,     1,
       3,     2,     1,     1,     1,     0,     2,     4,     2,     2,
       1,     2,     0,     1,     6,     8,     4,     6,     4,     2,
       6,     2,     4,     6,     2,     4,     2,     4,     1,     1,
       1,     3,     4,     1,     4,     1,     3,     1,     1,     0,
       0,     0,     6,     4,     1,     0,     4,     0,     4,     0,
       4,     2,     4,     5,     5,     2,     4,     4,     3,     3,
       3,     2,     1,     4,     0,     4,     0,     4,     0,     3,
       0,     3,     1,     2,     3,     4,     5,     1,     1,     0,
       0,     7,     1,     1,     1,     3,     3,     1,     2,     3,
       1,     1,     1,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     4,     4,     4,     3,     4,     4,     4,     3,
       3,     3,     2,     0,     4,     2,     0,     4,     1,     1,
       2,     3,     5,     2,     4,     1,     2,     3,     1,     3,
       5,     2,     1,     1,     3,     1,     3,     1,     2,     1,
       1,     3,     2,     1,     1,     3,     2,     1,     2,     1,
       1,     1,     3,     3,     2,     2,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     4,     2,     3,     1,     6,     1,
       1,     1,     1,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     3,     4,     0,     3,     1,
       2,     4,     0,     3,     4,     4,     0,     3,     0,     3,
       0,     2,     0,     2,     0,     2,     1,     0,     3,     0,
       0,     0,     0,     0,     8,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     3,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     0,     1,     1,     3,
       1,     0,     3,     4,     2,     2,     1,     1,     2,     0,
       6,     8,     4,     6,     4,     6,     2,     4,     6,     2,
       4,     2,     4,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     3,     1,     2,     1,
       2,     1,     1,     3,     1,     3,     1,     1,     2,     2,
       1,     3,     3,     1,     3,     1,     3,     1,     1,     2,
       1,     1,     1,     2,     1,     2,     1,     1,     0,     4,
       1,     2,     1,     3,     3,     2,     1,     4,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     0,     1,     2,
       2,     2,     0,     1,     1,     1,     1,     1,     2,     0 ];


/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
  #[allow(non_upper_case_globals)]
const yyrline_: &'static [i32] = &[      0,   346,   346,   346,   364,   373,   377,   381,   387,   393,
     397,   406,   418,   441,   460,   469,   473,   477,   483,   489,
     494,   493,   504,   503,   514,   524,   534,   538,   547,   558,
     569,   580,   591,   611,   626,   630,   643,   660,   689,   699,
     705,   715,   725,   740,   757,   774,   791,   808,   828,   864,
     886,   924,   936,   942,   965,   971,   975,   986,   997,  1008,
    1020,  1019,  1048,  1047,  1075,  1081,  1099,  1111,  1110,  1131,
    1139,  1139,  1157,  1161,  1167,  1171,  1187,  1186,  1206,  1212,
    1225,  1247,  1260,  1282,  1295,  1317,  1329,  1341,  1353,  1365,
    1379,  1389,  1401,  1411,  1433,  1437,  1443,  1450,  1462,  1469,
    1481,  1494,  1506,  1519,  1533,  1537,  1549,  1553,  1561,  1565,
    1573,  1579,  1585,  1596,  1611,  1621,  1636,  1648,  1659,  1669,
    1675,  1681,  1692,  1702,  1712,  1722,  1734,  1745,  1755,  1759,
    1765,  1771,  1777,  1789,  1793,  1797,  1801,  1806,  1812,  1818,
    1824,  1829,  1828,  1841,  1842,  1843,  1844,  1845,  1846,  1847,
    1848,  1849,  1850,  1851,  1852,  1853,  1854,  1855,  1856,  1857,
    1858,  1859,  1860,  1861,  1862,  1863,  1864,  1865,  1866,  1867,
    1868,  1869,  1870,  1873,  1874,  1875,  1876,  1877,  1878,  1879,
    1880,  1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,  1889,
    1890,  1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,
    1900,  1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,
    1910,  1911,  1912,  1913,  1916,  1926,  1936,  1951,  1968,  1985,
    2002,  2019,  2035,  2045,  2061,  2077,  2090,  2103,  2116,  2129,
    2135,  2141,  2147,  2153,  2159,  2165,  2178,  2187,  2196,  2202,
    2208,  2214,  2220,  2224,  2230,  2236,  2242,  2248,  2258,  2269,
    2278,  2284,  2290,  2301,  2313,  2312,  2330,  2345,  2365,  2401,
    2423,  2461,  2467,  2471,  2475,  2479,  2485,  2495,  2512,  2520,
    2524,  2528,  2540,  2556,  2562,  2587,  2597,  2618,  2634,  2644,
    2657,  2661,  2665,  2669,  2676,  2692,  2698,  2705,  2717,  2729,
    2735,  2735,  2763,  2772,  2787,  2791,  2797,  2801,  2814,  2820,
    2829,  2835,  2841,  2847,  2855,  2870,  2874,  2878,  2882,  2886,
    2890,  2894,  2898,  2902,  2906,  2910,  2924,  2923,  2937,  2937,
    2947,  2947,  2957,  2967,  2977,  2983,  2993,  3003,  3015,  3027,
    3039,  3052,  3051,  3069,  3080,  3091,  3113,  3117,  3130,  3134,
    3153,  3172,  3188,  3205,  3204,  3228,  3227,  3250,  3268,  3286,
    3285,  3316,  3315,  3342,  3341,  3367,  3386,  3407,  3419,  3431,
    3443,  3457,  3465,  3471,  3478,  3484,  3490,  3496,  3502,  3508,
    3521,  3534,  3541,  3547,  3553,  3559,  3565,  3571,  3577,  3584,
    3590,  3599,  3603,  3607,  3613,  3617,  3623,  3628,  3655,  3659,
    3667,  3671,  3677,  3683,  3695,  3699,  3707,  3711,  3717,  3729,
    3733,  3747,  3753,  3761,  3765,  3771,  3771,  3781,  3793,  3800,
    3807,  3814,  3819,  3824,  3830,  3844,  3860,  3872,  3886,  3898,
    3902,  3916,  3934,  3946,  3960,  3967,  3979,  3986,  3998,  4004,
    4010,  4017,  4031,  4051,  4055,  4061,  4065,  4073,  4081,  4088,
    4094,  4099,  4087,  4132,  4148,  4162,  4161,  4178,  4177,  4196,
    4195,  4215,  4228,  4242,  4265,  4289,  4304,  4319,  4334,  4347,
    4362,  4377,  4391,  4403,  4417,  4416,  4436,  4435,  4456,  4456,
    4481,  4481,  4505,  4509,  4522,  4528,  4537,  4552,  4556,  4564,
    4574,  4563,  4602,  4606,  4613,  4617,  4622,  4629,  4633,  4644,
    4656,  4662,  4668,  4676,  4682,  4692,  4698,  4708,  4714,  4721,
    4728,  4732,  4736,  4750,  4763,  4776,  4795,  4809,  4822,  4835,
    4854,  4866,  4876,  4888,  4887,  4905,  4916,  4915,  4933,  4942,
    4946,  4958,  4972,  4989,  5003,  5019,  5030,  5039,  5053,  5057,
    5069,  5083,  5089,  5097,  5101,  5109,  5115,  5122,  5126,  5130,
    5136,  5140,  5148,  5157,  5167,  5173,  5181,  5194,  5209,  5224,
    5228,  5234,  5238,  5254,  5270,  5283,  5296,  5300,  5304,  5308,
    5321,  5336,  5340,  5344,  5348,  5352,  5356,  5360,  5364,  5368,
    5374,  5380,  5390,  5407,  5419,  5435,  5441,  5451,  5457,  5486,
    5492,  5496,  5500,  5506,  5512,  5518,  5524,  5530,  5534,  5540,
    5552,  5562,  5566,  5574,  5588,  5602,  5617,  5630,  5634,  5644,
    5648,  5656,  5669,  5672,  5682,  5694,  5707,  5710,  5721,  5724,
    5735,  5738,  5747,  5750,  5759,  5762,  5770,  5777,  5776,  5787,
    5792,  5795,  5799,  5803,  5786,  5827,  5831,  5836,  5840,  5846,
    5847,  5850,  5859,  5860,  5861,  5862,  5865,  5874,  5878,  5889,
    5895,  5901,  5907,  5915,  5921,  5927,  5935,  5941,  5947,  5953,
    5959,  5967,  5973,  5979,  5985,  5991,  5997,  6003,  6011,  6017,
    6025,  6031,  6039,  6045,  6054,  6053,  6068,  6073,  6077,  6084,
    6096,  6100,  6100,  6118,  6130,  6137,  6144,  6152,  6164,  6169,
    6174,  6188,  6204,  6216,  6230,  6242,  6256,  6263,  6275,  6289,
    6296,  6308,  6315,  6327,  6332,  6337,  6343,  6347,  6351,  6355,
    6361,  6365,  6375,  6384,  6391,  6403,  6407,  6416,  6433,  6441,
    6451,  6458,  6467,  6471,  6480,  6484,  6492,  6496,  6502,  6517,
    6529,  6541,  6555,  6569,  6573,  6581,  6585,  6593,  6597,  6603,
    6616,  6628,  6632,  6638,  6649,  6661,  6665,  6671,  6677,  6677,
    6709,  6713,  6719,  6723,  6731,  6741,  6750,  6756,  6767,  6775,
    6779,  6783,  6789,  6793,  6797,  6801,  6807,  6811,  6815,  6821,
    6825,  6831,  6835,  6841,  6845,  6852,  6855,  6862,  6865,  6871,
    6877,  6883,  6890,  6893,  6897,  6903,  6907,  6913,  6917,  6924 ];


  // Report on the debug stream that the rule yyrule is going to be reduced.
  fn yy_reduce_print(&self, yyrule: i32, yystack: &YYStack) {
        if !( self.is_debug() ) {
            return;
        }

        let yylno = Self::yyrline_[i32_to_usize(yyrule)];
        let yynrhs = Self::yyr2_[i32_to_usize(yyrule)];
        // Print the symbols being reduced, and their result.
        self.yycdebug(&format!("Reducing stack by rule {} (line {}):", /* " fix */ yyrule - 1, yylno));

        // The symbols being reduced.
        for yyi in 0..yynrhs {
            let state: usize = i32_to_usize(yystack.state_at(i32_to_usize(yynrhs - (yyi + 1))));
            self.yy_symbol_print(
                &format!("   ${} =", yyi + 1),
                SymbolKind::get(Self::yystos_[state]),
                yystack.borrow_value_at(i32_to_usize(yynrhs - (yyi + 1))),
                yystack.location_at(i32_to_usize(yynrhs - (yyi + 1)))
            );
        }
  }

  /* YYTRANSLATE_(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
     as returned by yylex, with out-of-bounds checking.  */
  fn yytranslate_(t: i32) -> &'static SymbolKind
  {
        // Last valid token kind.
        let code_max: i32 = 407;
        if t <= 0 {
            SymbolKind::get(0)
        } else if t <= code_max {
            let t = i32_to_usize(t);
            SymbolKind::get(Self::yytranslate_table_[t])
        } else {
            SymbolKind::get(2)
        }
  }
  #[allow(non_upper_case_globals)]
const yytranslate_table_: &'static [i32] = &[      0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152 ];


const YYLAST_: i32 = 14786;
const YYEMPTY_: i32 = -2;
const YYFINAL_: i32 = 3;
const YYNTOKENS_: i32 = 153;


}

/* Unqualified %code blocks.  */
/* "src/parser/parser.y":73  */

    // pre-code

/* "src/parser/parser.rs":15476  */


/* "src/parser/parser.y":6929  */


impl Parser {
    /// Constructs a parser with given `input` and `options`.
    ///
    /// Returns an error if given `input` is invalid.
    pub fn new<TInput>(input: TInput, options: ParserOptions) -> Self
    where
        TInput: Into<Vec<u8>>
    {
        let ParserOptions {
            buffer_name,
            decoder,
            token_rewriter,
            record_tokens,
        } = options;

        let context = ParserContext::new();
        let current_arg_stack = CurrentArgStack::new();
        let max_numparam_stack = MaxNumparamStack::new();
        let pattern_variables = VariablesStack::new();
        let pattern_hash_keys = VariablesStack::new();
        let static_env = StaticEnvironment::new();
        let diagnostics = Diagnostics::new();
        let tokens_pool = Pool::new();

        let input: Vec<u8> = input.into();
        let buffer_name: String = buffer_name;

        let mut lexer = Lexer::new(input, buffer_name, decoder);
        lexer.context = context.clone();
        lexer.static_env = static_env.clone();
        lexer.diagnostics = diagnostics.clone();
        lexer.tokens_factory = tokens_pool.factory();

        let builder = Builder::new(
            static_env.clone(),
            context.clone(),
            current_arg_stack.clone(),
            max_numparam_stack.clone(),
            pattern_variables.clone(),
            pattern_hash_keys.clone(),
            diagnostics.clone(),
            tokens_pool.factory(),
        );

        let last_token_type = 0;

        Self {
            yy_error_verbose: true,
            yynerrs: 0,
            yyerrstatus_: 0,
            result: None,

            builder,
            context,
            current_arg_stack,
            max_numparam_stack,
            pattern_variables,
            pattern_hash_keys,
            static_env,
            last_token_type,
            tokens: vec![],
            diagnostics,
            yylexer: lexer,
            token_rewriter,
            record_tokens,
            tokens_pool,
        }
    }

    /// Parses given input and returns:
    ///
    /// 1. AST
    /// 2. tokens
    /// 3. diagnostics
    /// 4. coments
    /// 5. magic comments
    pub fn do_parse(mut self) -> ParserResult  {
        self.parse();

        ParserResult {
            ast: self.result,
            tokens: self.tokens,
            diagnostics: self.diagnostics.take_inner(),
            comments: self.yylexer.comments,
            magic_comments: self.yylexer.magic_comments,
            input: self.yylexer.buffer.input.decoded,
        }
    }

    #[doc(hidden)]
    pub fn do_parse_with_state_validation(mut self) -> ParserResult {
        self.parse();

        self.assert_state_is_final();

        ParserResult {
            ast: self.result,
            tokens: self.tokens,
            diagnostics: self.diagnostics.take_inner(),
            comments: self.yylexer.comments,
            magic_comments: self.yylexer.magic_comments,
            input: self.yylexer.buffer.input.decoded,
        }
    }

    fn warn(&mut self, loc: &Loc, message: DiagnosticMessage) {
        let diagnostic = Diagnostic {
            level: ErrorLevel::Warning,
            message,
            loc: *loc,
        };
        self.diagnostics.emit(diagnostic);
    }

    fn yylex(&mut self) -> PoolValue<Token> {
        self.yylexer.yylex()
    }

    fn next_token(&mut self) -> PoolValue<Token> {
        let mut token = self.yylex();

        if let Some(token_rewriter) = self.token_rewriter.as_ref() {
            let boxed_token = token.take_boxed_value();
            let TokenRewriterResult { rewritten_token, token_action, lex_state_action } =
                token_rewriter.call(boxed_token, self.yylexer.buffer.input.as_shared_bytes());

            match lex_state_action {
                LexStateAction::Keep => {
                    // keep
                }
                LexStateAction::Set(next_state) => {
                    self.yylexer.lex_state.set(next_state);
                }
            }

            match token_action {
                RewriteAction::Drop => {
                    return self.next_token();
                }
                RewriteAction::Keep => {
                    token = self.tokens_pool.alloc(*rewritten_token);
                }
            }
        }

        self.last_token_type = token.token_type;

        if self.record_tokens {
            let token = token.clone();
            self.tokens.push(token.take_value());
        }

        token
    }

    fn check_kwarg_name(&self, ident_t: &Token) -> Result<(), ()> {
        let name = clone_value(ident_t);
        let first_char = name.as_str().chars().next().expect("kwarg name can't be empty");
        if first_char.is_lowercase() || first_char == '_' {
            Ok(())
        } else {
            let loc = ident_t.loc;
            self.diagnostics.emit(
                Diagnostic {
                    level: ErrorLevel::Error,
                    message: DiagnosticMessage::ConstArgument {},
                    loc
                }
            );
            Err(())
        }
    }

    fn validate_endless_method_name(&mut self, name_t: &Token) -> Result<(), ()> {
        let name = clone_value(name_t);
        match &name[..] {
            "==" | "===" | ">=" | "<=" | "!=" => Ok(()),
            other if other.ends_with('=') => {
                self.yyerror(&name_t.loc, DiagnosticMessage::EndlessSetterDefinition {}).map(|_| ())
            }
            _ => Ok(())
        }
    }

    fn yyerror(&mut self, loc: &Loc, message: DiagnosticMessage) -> Result<i32, ()> {
        self.yyerror1(
            message,
            *loc
        )
    }

    fn yyerror1(&mut self, message: DiagnosticMessage, loc: Loc) -> Result<i32, ()> {
        let diagnostic = Diagnostic { level: ErrorLevel::Error, message, loc };
        self.diagnostics.emit(diagnostic);
        Err(())
    }

    fn report_syntax_error(&mut self, _stack: &YYStack, yytoken: &SymbolKind, loc: YYLoc) {
        let id: usize = yytoken.code().try_into().expect("failed to convert token code into i32, is it too big?");
        let diagnostic = Diagnostic {
            level: ErrorLevel::Error,
            message: DiagnosticMessage::UnexpectedToken {
                token_name: Lexer::TOKEN_NAMES[id].to_string()
            },
            loc,
        };
        self.diagnostics.emit(diagnostic);
    }

    fn warn_eol(&mut self, loc: &Loc, tok: &str) {
        if self.yylexer.buffer.is_looking_at_eol() {
            self.warn(loc, DiagnosticMessage::TokAtEolWithoutExpression { token_name: tok.to_string() });
        }
    }

    fn value_expr(&self, node: &Node) -> Result<(), ()> {
        self.builder.value_expr(node)
    }

    #[doc(hidden)]
    fn assert_state_is_final(&self) {
        assert!(self.yylexer.cmdarg.is_empty());
        assert!(self.yylexer.cond.is_empty());
        assert!(self.yylexer.paren_nest == 0);

        assert!(self.static_env.is_empty());
        assert!(self.context.is_empty());
        assert!(self.max_numparam_stack.is_empty());
        assert!(self.current_arg_stack.is_empty());
        assert!(self.pattern_variables.is_empty());
        assert!(self.pattern_hash_keys.is_empty());
    }

    #[inline]
    fn is_debug(&self) -> bool {
        cfg!(feature = "debug-parser")
    }

    fn local_push(&mut self) {
        self.static_env.extend_static();
        self.yylexer.cmdarg.push(false);
        self.yylexer.cond.push(false);
        self.max_numparam_stack.push(true);
    }

    fn local_pop(&mut self) {
        self.static_env.unextend();
        self.yylexer.cmdarg.pop();
        self.yylexer.cond.pop();
        self.max_numparam_stack.pop();
    }
}
