// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a executable here-document literal (both with and without interpolation)
///
/// It's similar to `Xstr` in terms of abstract syntax tree, but has different source maps.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct XHeredoc {
    /// A list of string parts (static literals and interpolated expressions)
    pub parts: Vec<Node>,

    /// Location of the executable here-document body
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    ///          ~~~~~~~~~~~~~~~
    /// ```
    pub heredoc_body_l: Loc,

    /// Location of the executable here-document end
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    ///                           ~~~~
    /// ```
    pub heredoc_end_l: Loc,

    /// Location of the executable here-document identifier
    ///
    /// ```text
    /// <<-`HERE`\n  a\n   #{42}\nHERE
    /// ~~~~~~~
    /// ```
    ///
    /// **Note**: This is the only node (with `Heredoc`) that has `expression_l` smaller that all other sub-locations merged.
    /// The reason for that is that it's possible to add more code after here-document ID:
    ///
    /// ```text
    /// <<-`HERE` + "rest"
    /// content
    /// HERE
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for XHeredoc {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.parts);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "xstr"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.parts.iter() { node.inner_ref().print_with_locs(); }
        self.heredoc_body_l.print("heredoc_body");
        self.heredoc_end_l.print("heredoc_end");
        self.expression_l.print("expression");
    }
}
