// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a branch of the `case` statement (i.e. `when foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct When {
    /// A list of values to compare/match against
    pub patterns: Vec<Node>,

    /// Body of the `when` branch
    pub body: Option<Box<Node>>,

    /// Location of the `when` keyword
    ///
    /// ```text
    /// case foo; when bar; end
    ///           ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///                    ~~~~
    /// ```
    ///
    /// `then` is optional, and so `begin_l` can be `None`
    pub begin_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///           ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for When {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.patterns);
        result.push_maybe_node_or_nil(&self.body);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "when"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.patterns.iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.expression_l.print("expression");
    }
}
