// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a pattern based on a "pinned" variable (e.g. `^foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Pin {
    /// Variable that is pinned
    pub var: Box<Node>,

    /// Location of the `^` operator
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~
    /// ```
    pub selector_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Pin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.var);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.var.inner_ref().print_with_locs();
        self.selector_l.print("selector");
        self.expression_l.print("expression");
    }
}
