// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents `nil` literal
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Nil {
    /// Location of the `nil` keyword
    ///
    /// ```text
    /// nil
    /// ~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Nil {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nil"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
