// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents matching a regex that produces local variables (i.e. `/(?<match>bar)/ =~ 'bar'`)
///
/// Each named group in regex declares a local variable.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchWithLvasgn {
    /// Regex that is used for matching
    pub re: Box<Node>,

    /// Value that is used for matching
    pub value: Box<Node>,

    /// Location of the `=~` operatir
    ///
    /// ```text
    /// /(?<match>bar)/ =~ 'bar'
    ///                 ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// /(?<match>bar)/ =~ 'bar'
    /// ~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for MatchWithLvasgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.re);
        result.push_node(&self.value);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_with_lvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.re.inner_ref().print_with_locs();
        self.value.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
