// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents empty hash pattern that is used in pattern matching (i.e. `in **nil`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchNilPattern {
    /// Location of the `**` operator
    ///
    /// ```text
    /// in **nil
    ///    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// in **nil
    ///      ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// in **nil
    ///    ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for MatchNilPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_nil_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.operator_l.print("operator");
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
