// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents mass-assignment (i.e. `foo, bar = 1, 2`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Masgn {
    /// Left hand statement of the assignment
    pub lhs: Box<Node>,

    /// Left hand statement of the assignment
    pub rhs: Box<Node>,

    /// Location of the `=` operator
    ///
    /// ```text
    /// foo, bar = 1, 2
    ///          ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo, bar = 1, 2
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Masgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.lhs);
        result.push_node(&self.rhs);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "masgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.lhs.inner_ref().print_with_locs();
        self.rhs.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
