// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an optional keyword argument (i.e. `foo` in `def m(foo: 42); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwoptarg {
    /// Name of the optional keyword argument
    pub name: String,

    /// Default value of the optional keyword argument
    pub default: Box<Node>,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(foo: 1); end
    ///       ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(foo: 1); end
    ///       ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Kwoptarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_node(&self.default);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwoptarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.default.inner_ref().print_with_locs();
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
