// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents required keyword argument (i.e. `foo` in `def m(foo:); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwarg {
    /// Name of the keyword argument
    pub name: String,

    /// Location of the name
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Kwarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
