// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents an integer literal (i.e. `42`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Int {
    /// String value of the literal, `String("42")` for `42`
    pub value: String,

    /// Location of unary `-` (but not `+`)
    ///
    /// ```text
    /// -42
    /// ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// -42
    /// ~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Int {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.value);


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "int"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
